' VB Script showing the properties syntax differences from a user object '
'                                                                        '
' Version 1.00 - Alain Lissoir                                           '
' Compaq Computer Corporation - Professional Services - Belgium -        '
'                                                                        '
' Any comments or questions:              EMail:alain.lissoir@compaq.com '

Option Explicit

Dim objRoot
Dim strDefaultDomainName
Dim strUserDN
Dim objUser
Dim objUserClass
Dim objProperty

' -----------------------------------------------------------------------------------------
' Get the default Windows 2000 Domain name
Wscript.Echo "Binding to RootDSE to get default Domain Name"
Wscript.Echo
Set objRoot = GetObject("LDAP://RootDSE")
strDefaultDomainName = objRoot.Get("DefaultNamingContext")
Set objRoot = Nothing

' Create the Distinsguished Name (DN) by adding the default Windows 2000
' Domain name to the user name.
strUserDN = "CN=Administrator,CN=Users," & strDefaultDomainName

' -----------------------------------------------------------------------------------------
' Bind to the user object
Wscript.Echo "Binding to '" & strUserDN & "'"
Wscript.Echo
Set objUser = GetObject("LDAP://" & strUserDN)

' -----------------------------------------------------------------------------------------
' Bind to the class definition (User) path of the selected object.
Wscript.Echo "Binding to '" & objUser.Schema & "'"
Wscript.Echo
Set objUserClass = GetObject(objUser.Schema)

' -----------------------------------------------------------------------------------------
Wscript.Echo "Show the 'sAMAccountName' syntax property of '" & strUserDN & "'"

Set objProperty = GetObject(objUserClass.Parent + "/sAMAccountName")
WScript.Echo objProperty.Name & " (Syntax=" & objProperty.Syntax & ")" & _
                                " (Multi-Valued=" & objProperty.Multivalued & ")"
Set objProperty = Nothing

Wscript.Echo

' -----------------------------------------------------------------------------------------
Wscript.Echo "Show the 'objectSid' syntax property of '" & strUserDN & "'"

Set objProperty = GetObject(objUserClass.Parent + "/objectSid")
WScript.Echo objProperty.Name & " (Syntax=" & objProperty.Syntax & ")" & _
                                " (Multi-Valued=" & objProperty.Multivalued & ")"
Set objProperty = Nothing

Wscript.Echo


Set objUserClass = Nothing
Set objUser = Nothing

WScript.Quit (0)