' VB Script showing the Administrator's group membership via two  '
' different name spaces (WinNT: and LDAP) to show the name space  '
' syntax differences.                                             '
'                                                                 '
' Version 1.00 - Alain Lissoir                                    '
' Compaq Computer Corporation - Professional Services - Belgium - '
'                                                                 '
' Any comments or questions:       EMail:alain.lissoir@compaq.com '

Option Explicit

Dim objUser
Dim objMember
Dim strObjPath

' -----------------------------------------------------------------------------------------
' First access via the WinNT: namespace
strObjPath = "WinNT://MyW2KDomain/Administrator"
Set objUser = GetObject(strObjPath)

WScript.Echo
WScript.Echo "ADSI Query via WinNT: namespace"
For Each objMember In objUser.Groups
    WScript.Echo "'" & objMember.Name & "' has a ADsPath of '" & objMember.AdsPath & "'"
Next

Set objUser = Nothing

' -----------------------------------------------------------------------------------------
' Next access via the LDAP: namespace
strObjPath = "LDAP://CN=Administrator,CN=Users,DC=MyW2KDomain,DC=com"
Set objUser = GetObject(strObjPath)

WScript.Echo
WScript.Echo "ADSI Query via LDAP: namespace"
For Each objMember In objUser.Groups
    WScript.Echo "'" & objMember.Name & "' has a ADsPath of '" & objMember.AdsPath & "'"
Next

Set objUser = Nothing