#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook nc/tc4400 System BIOS (68YHV)  - Linux-Based"
BIOS_VERSION="F.05"
FILENAME="sp33579.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o44  )t4   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    68YHV   BIN  R44  m4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  6   d             F  /    I  
     &  o  A  )    %  z
  T
  
      U    y          ?  .          q  i  G    5          s"  m"  !           &       &  %  $  c$  N$  $  5#  /#  !#   }
 }
 }
Z*  A*  !*  *  )  )  )   }
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}
C  rC  AC  ;C  B  I  I  H  F  F  1F  +F  F  V}
&}
}
}
}
}
}
x}
N}
0}
}
}
}
}
}
}
p}
R}
4}
 S  S  S  S  S   ya  &a  a  
a  `  d  d  e    	}
2}
,}
}
    u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      3Ðjː
  F  F~ F F^9 uvfv)}fvfvu)~h	h jMRP%Vtj
fvvPB
h	h jN~RPVtj
fvvP
 Ð3f>^  tf6^ 覌f>  tf6 蓌j b	  V  h jh jh j鐃h  h 苒j>bh 蚐~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ?F^v&v&8 uNV  *=p t -d jHH|f6B jRPvkjzRP
jjRPjZRPꈃjJRPڈj:RPʈj	*RP躈j
RP誈j
RP蚈jRP芈j
RPzjqbT-r - @- (FF9F}-^v&&?-t^F&&?/uF ]=sjxtRPja]tjyURP凃ja>V   h	h hn  gvxvuj fh  ! hy
h@f6vfh   hy
h@f| f6vefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRPja]]fh  j Ԉ^ ` ^ ujzMRP݆j`s>R  tG  =]t( !  9  =  A  E  I jJj1fjZ   ujzRPcjZ`
t(b       ؎f&fjxRPj`>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uH>T  u	>L   >L   >\ u3T Ht	HtHt8j ]uwjJulj?jA.>\ u?T Ht
HtHtHtIjj OȐju+jRP3jT HHtH
>T  t7>N  t0f|A  h|h|j苁
> tjJRPڄ>J  t
j ^Ot  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uwG4(~ tfj fj G0F   =HtkI-
 -!- - - 
tFfA> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj Cd   F >J  t@Kt B= M- K- '-M- 0- )fjA>J  tzj \^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j襄}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFP/ff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPyfvFPfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;FvfvWFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPtWFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP豄
k3ÐSfv
 ÐT  Vfh  P FP߄f|K  Fhh|h|j䁃> t3^ÐFP^{BFVh	h FPJRPhzh	h fv.RPhd zfvhd Rz ^Ð  F@Fy
|"~FFhh|h|j:}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ Uu*u%f6vfh  f6^ ^= uv&G
 tf6v\놐f6v\?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP	
fh   vfh`  j f6^ ~@v>  WV	~ľ" f~ th	h FPZx~qFPu3^_h	h hd [vxvtj ff-   fPf6vz
f6vjFPy
f6v|j ff-    fPf6vy
f6vjFP]y
f6vb|~ uo~|ij ff-  fPf6vy
uLf6vjFPy
f6v|F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vzYFPhf6v]Y ^_Ð~ fh  h	h hd Zvxvcfp    	prff9psTf6vfh  f6^ Y= Yv&G
 Lfh   f6pfh  `f6^ %*t"f6vXfh  `^^_Ðfh   vfh`  j f6^ }
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP~
<F> tjJj1j f6 ~jh	h(      RP6~
6 hy
h@     RP~
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|jt
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   h!NNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jz> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|jy> tjk\RPv  fh  ! hy
h@O|j3RPYF  @ +FHuF F^
&@VxR&*RhRj*YF 9F}j >~Ĉf<t<uh	h2 XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRP vjJ`RPu3ø VxR&RhRjYh4XtwupÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RP9LFVfFf  fP!L;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  f|

 hh|h|jv> u0>} u)6~fv5K6fFf   fPK^_ÐfF    fFffFȸ	~4 fffFfFfFfFf-   f;FvfvJFVِf~qhXku2f+fFfFf~svBPƋVFVRPfJِ^_   jF "hRj
GVj[RPGUFF*;s6Pj:RP&UF*P4uVxR&
R뫐VxR&
RhRj
Uj|RPurju,jCRPYrjDRPIr>J  tVhhd jRPTÐ  F=fh  Qhh?t"jMQRPqjNARPqj{/RPqfh  ujEF 
jRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPSj F*P{u>X Xt	>X YvjKyRPh	h> _SjLcRPh	hD IS>J  /t~ h	h2  SF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPRj F*PlujzRPh	hH hhd j_RPKRj[ORPjZERPh	hN +RÐ  :l1fh hht"jMRPojNRP{oj{RPiofh  ujEF  jRPh	hH QF~  FF*;s>  u+ҊN*+= utԊF*PjURPAQjF*P%u>X Xt	>X YvjK#RPh	h> 	QjL
RPh	hD P>J  t~ F 8VxR&
RhRj
QF~sF F FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RRP>PjF*P"uj0RPh	hH  hhd j RPPj[RPjZRPh	hN OÐ  F >\ ut~ th	hV h	hb FP*ih	h FPLFVu3vPfh  f6^ xL= s^&G
 tF  fvLKO>\ u~ t	h	hn h	hz FPhh	h FPLFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPUCȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP0C  F /u3tF f6^ FPu1F~rh	h h	hV JFVtvPfh  f6^ ML= s^&G
 tF  fvI~ ujRPMh	hV j!RPMF*  F u3A.tt~ th	hV FPfj"h	hb FPfj#JRPFPfh	h FP JFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$RPL0F~  F ohRj
MF  hRj MFj$;F~VxR& R܊F*PjsRP_Lf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%RPL~ u~ tjjRPKF  F f6^ FP%/~uPh	h h	hV HFVu3vPfh  f6^ I= s^&G
 tF  fv`GFÐUf6^ FP/Ð  F u3F F~s7F*Pj:RP&Kf6^ FP{=uh	h2 Kh	h h	hn GFVtvPfh   f6^ >I= s^&G
 tF  fvFVxR&
R
hRj
KF hRj sKFj N*;~VxR& RՐVxR&
RhRj
'K~ uj5RP!Jh	hn j!RP	JF*  F u3At~ th	hn FPMcj"h	hz FP8cj#RPFP#ch	h FPzFFVtvPfh   f6^ uF= s^&G
 tF  fvIE~  j$YRPEI:EF phRj
JF  hRj JFj$T;F~VxR& R܊F*PjRPHf6^ FP
;FF~s#~ t~ uVwR&
Rt~ tFPFPj%RP}H~ u~ tjjqRP]HF  F f6^ FP:u3À~uLh	h h	hn EFVtvPfh   f6^ nF= s^&G
 tF  fvCFÐUf6^ FP:ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S[c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPlbFPNQVRh	h fvbvvvh	h FP3bFPFPm]ÐUvދRP]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfv\FN^v&8 t&@ ^fj <fh  vfh   !j݃RPf6B \*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0%݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0ۃFVRPZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvjكFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
X
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7؃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w׃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0уRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &pуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0΃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFPY"ÐFP>\ u*!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà ȢhDAht<thDAhِ != t= ut uу>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShBhR*F*PʃuFL| j hBhR jvʃ]FUtKjXʃhy
hd j hjlfj hG=thBhREtÐhy
hhy
h~&Ð&ÐU~ u hy
hjhHhy
hjh7F  F~ ujFÐF Df>   F{ j hChfh  >˃uF  F+uF~  ~1 F  F*@N*1 j hChFff   ffffN*+;|;s9 u(jSffYffffN*+ = utj F*Pyʃr>X Xt	>X Y6fj hF~.F 1 j hChF HFff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ 'ڃF*@N*1 j hChE>  u+ff   ffffN*+ = uFj F*P[Ƀ2~ fj hF
  fh  Ƀhy
hd fh  ȃt"hy
hhy
h幃t"fj hEfj hn
=uhhCht!hChtTfj hU~ u hy
hjhhy
hjhF  F~ ujFÐF Df>   F{ j hFhfh ȃuF  FuF~  ~s1 F  Fff   ffffN*+;|;sF*@N*1 ShFh0>  u)ff   ffffN*+ = utjF*PHǃq>X Xt	>X Y5fj hfF~.F 1 F 5Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ ׃F*@N*1 j hFh)jF*Pqƃh~ fj hF#  fh -ƃhy
hd fh ƃt"hy
hhy
ht"fj hEfj hn#=uhFht!hFhtjfj hÃ>J  tj htt t   1 ~ ujރFÐF Dj ԃud j hIh$tF F~s3c F*1 j hIh$FPuFA j hIh$he>\ utTtMztFj t:hFhIfj hn=thIh$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j hJhBFPuF<A j hJhBh또>\ ut>t7j hj }fj h=thJhBtÐ  Z1 ~ uj܃FÐj҃uÐF DTd j hKh`tF F~s3Tj F*1 Zj hKh`FPuFZA j hKh`hc>\ utTtMtFjt:hFh	gfj hn=thKh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPtFPhy
hՃ~ th	hDh	hPFP3h	h FPUFVu3vPfh0  FPLfv4FPhy
hqո U<ՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H4hLӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhT  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAhуfh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhJуm$PÐUj
0ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
~ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h=σÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hW̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̃fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth 
Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPTtFPhy
hgȃ~ th	h\h	hhFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhy
hǸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..qcf^gef[UfS..qcf^gef[UfS..qcf^gfeff[UPfS..qcf^Fgef[XUPfS..qcf^Fgef[XUfPfS..qcf^fFgfef[fX                           UfPS^tf3ffqc  f.c.c "  u  $" u [fX 0!<s3P˿y
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666QP.eظ eP.eۚj  y>	uXP 
 Py
 5! %d!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.|Vuxyyy{|w{{{{yx
x{{ru{x{{w{{zuRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }}}}~"~K~}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.2}V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33By
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3y
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![#%!uslkʻ 

FV]U- .8tK
I	]PPR.e؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUy
ء
F
F]XSQRy
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.eۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uTtT^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              y
              4.69  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This is an older version of BIOS which is not compatible with your system configuration BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                      MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) E  + , B  . / H  \ ] I a b VJ e f 8K h i 8L '  y
 `  y
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d					$		^														

	&
	F
	Z
	n
	~
	
	
	
	
	
	(		>	Z	|	.			n			6	T	n							(
	V
	
	
	
	
		$	4	                                  E    F    B l by
      C    D    B l y
      G    H    B l y
      K    L    B l y
      M    N    B l y
      Q    R l y
      P    O n y
      I    J    R l (y
      -     1    + o Fy
      V     S n dy
      *    1    ( o |y
      T    U     W   
X   
S m y
      Z    [    Y l y
      0     1    . o y
      _    ^ m  y
      c     1    a o y
      g     1    e o 6y
      j     1    h o Ty
      q    r    s    t     u     p l ry
               e                           _C_FILE_INFO=                                                         y
               
	
\ \                                  [y
  [y
                                                                                                                                                                                                                                                                                                                                                                                                                                             *y
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          fffffff               (((((                  H                                                                                                                                        "                                                     ddd                  rny
y
y
y
y
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                               p   `      POST  f   f.V .X <  
 f.d ` j  I     '       =    POSTf d_  f  
; H]  v	 V
 
 ^ 
 ^ ,` V w  ;  v 6  f  =  w ] v V &Y X  ! " 
# c$ % & t]'  0( ) W* c+ , w- Z. ]d/ 0 v1 2 ¡3 ;;4 5 Z6 p7 No8 u9 : ʋ; gW< = @> ? yb@  A B ƦC 
D E o;F v;G H ]I vJ  K ӓL M :N ^O P YQ R S T U 
V /cW X Y Z Ή[ v\ o	]@^ _ P` -Wa ;b Ivc d we Ӥf :g f3" f" @ ؠ   ؎  f{  3  3    ] QVW.D? PRNZX+ hX@ .X=X@u
_^rYPSظ hc [X <t
B	PW (f&E1_X  fPfSfQfRfGenu fntel ineIufp%=  rifa2fuYA؀,Uhrzbuf0/^0P   t
 p0fZfYf[fUfVfWfQh'rOS  rDL@h^f @f  f   gf  P^ s 5LP_f^]UQWfV6  
fvh,~uF F 73h3f^_YH	h r rD(gf 
  #n3fRS Bma&< t2?fvԹ tNh
sHtDs  hK{/ 3h%7(BFv ~&#3
Pf~f#ff   @
>tq  tgfNg A	~tfOF  ΁ ~3
[""3yą(BF{ t~y2h*Ff3ҲZho7FfVFf;Fu-0j43  
 VWRQS:5=PR<[YZ_ j<'={PA   0! <" #@ W @W ~@ W g g !g g 0w  w w Aw @ ߇   A 0    }  E  Pg gggDw ww C  ߇B 3P  
g  =S@ c W +&0@
'0!'<"'#' PQRa&F$` hSZYXSQWa$a$a  hU htV>_Y[2 TCA6n  @A Q C@@ @;uYð!$p h6B^f`  衞fa.h0 c	 h< kð]WOO@g&gf&qN0NXP$qfX61Pr&2hcV]$h*Ls($H0t'&2hU>E~hmOVh,bnfffw  &  -Eec
p/ @tÀtafihm+c}gthC^fTDSDh+{ <  CtU}uu %R3 d 
  % Z%UWUkVI
$ +#wh2*vt?uɀ0 [@@h;CZ^su hAB,Ⱥ: @p 3ȰS2 @ufP  fXtkSQh &kb!crúvh!s}  f5  p* t*-
H.@9060`a2 f4%  0Nc  
h	_迷`]~7aP /X`Q7 @ PQ= `t
3P @fYX _@Iðd`PAd  RPpKkWu  
 O %gEt&؁pN uM9NwN%uӿ~ uF= wt%   +PXh `.  	`  a `h&t* 'u VMu AOtPRf0 SP~f.Ep DE ~Tf` f != R0Ѱ?2AXG@0Fa`  aVSQR _Zkwh8\f`HX s 躩r-
wt` q!s0 3hhfr"s3 @An
!B9(]fa'?t5<t1awfǱ跟wë@    ,Æ"B<[ \ ]^C<` abc de_^   }f02RVW3`ʬ'$D0%
` yƭf _t`|R@YRPP_^ZYzRO"R  Zt  ZRu ? ZZS kVQ Y  \Q tc4TC4nc4NC4K `VȎc%8_&GF< u^?_7OB+G;rSrܰGoV
mefaʪ @ > /A A Ð T  M e M@@  9 Y .   n #SA A ڜq 3(
 ~`   +]{! ^qG2 P f!a6f60J  3 pB0 6>x  .h?PS $<t4r [ Ѝeڋh3 c f`7 V  %3P3hI"hHg0v  D 3 PF8h9fRؿ7&߈D{ĿX"Ѐ-rnFK82廙"8z `P7rR7K8 }8V7r% 8`7&5&D&EN7y^A	VW `h(#
 ߿8zS8
U8rV݃~^ ؐ8!3~39l'8j` 9fpX@tf&@ U$=u&9f= =u &,9&*9&(9V
, fgh  0 pqr  <ABCDE I@xyz{|}   tVw SC
f
|Q9 r&~9&9F r
& {  Sx"
 9QvC~f  f5fv& V3
Ê^@ ..0t+.FuN.Pp'Q%8mGX& WfVUSW! 3fv߿ h,C  ޿R&~22ك!IN܀3T
^
u
t_NA&>P7_[O]f^_"GEM
) "5! ` PNv[E` SV\PVn&=;u&&0u&^:SH&<#I+&~&p>E&D
lSV hY^[þ`nWfP   hEȁ  <fX_vqF9=Boot Device Menu  Lo?ading A;/r. . t=  `  # NP 3u.? $<t) \Ip j!0r𾰿  ^q!6AN & 	4Zò G诨t
.> t.F10=ROM Based Setup EnterP@Q@aCV2uCM  ̀
a@at2rt*164sW / iQ5R@AVfM@r? APt
(*[t hnAPXhlBsF12=Ne_tworkr2((Wake On LANAtte7mpt'to(%p  Qh& Rt8 *r	 A'u1+ 1+K	~/ t,sMsU. T.W.- !.Tޒp2-1- 7_"ss8.	BIؾa<^)s U͋b8CS֠VRySaЎNF }a3؁ma?	uCFG?~N0{tGh1ra}arvﱕhZ^òP*0␽Notebook Hard Drive O`#cal Disk Dock1Mb= Multibay (top)bottom)leftf	Floppy)USBCD-!G 1
B Superu6ControllerNI'C 123                        ~ P  	 
@8P 
V t m@prlec9tゔ  ͹U8 and _mo@=the highl@ tp`your cho .  Press3x1bose.Seconds until au;a A defa> start: v  ( $P  '#!;|S a;Zip d}D`&Zry&!, h2 wv.%!
00.#!eRJ! ځ  X}a3ma؊' tA<v<st1h & 2ؒ2ￄQ#YAr
 4@y 1 xB.d 
*f  @f +jjj(Pj@  '! `d (  }  , z>&! u ;!w~ M 2.  t03h 2Ɋ <F8tFsj}a $ bPdáq AURVQ.,.L.T^Y^Z]S,.f *[ݡQSVW7 s.t$QE!.<.-00}?@.@хY_^[YDQt(  u#2 = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu zw`2҂ XʱpP0
d ( ( r
;w2 {`d JQ1gFYô.*f <%20}fˀhZ 5΁h6 h#иd h<u	f  ` f0h.SB J  Wo rf.>=%߻46fgf&G, @ f   PG0f@G, Ru
h~G,f",f_ffP fQpt#QWK2_Yf= TKStfXbco    ? o N     @  y] Ѡr "R^@  , h45wg&Fg&Fg&F"tug&F0a 1 2P&׎Ǎ~A@rL.&p w#q 1 w?QMwV1_oh& @( 
ɾVWpL _^QRVT	  r&e^ZY
&ffL ]L r
рYSQ_&݈|\DLQH Yr)&}at&Eh&T+ r
W3`$F&c ]&UPfSVUfQW ( K&nC' @C$BC$ rx  q#ȑ# r]]" tsrg r7݀ K: k;WQT rQ G1"C""Y_r
E@t:]^f[XQ$Co"uV68e7u!#,ABM  f.@)PS [XAu.6D)f)@)IDNU.D)SfV0{#Q`/^31Ýf^[
3u
u ru!q!} " W3 hQP < Q7^S7hUh3-5icf_p}`u= v[ wOA[ aP hrzh$@<@X JPFSQRWhYBkr_ZMP TC r9?9 r/ u t t.@XR1$tut0ZSWQR fu
ʀgZY_
_*uu}  Ygу< @3ɹ2 uhT{#b)¼ P% = @uX%"4ٿg&@0RIaX;Wi	t<f_;H2m3r H4 70P\pL# @ ^" w X`2	Poi`e@  A qrtf &0:&,:@ p .p 3f$BZst$ uf*}sC>0: tuc ~rh^
&9: f3C<th(fO}G:  Gp2?}X4 Q < t&a:GfO&
3f30 2*f&0: uf
ffKЋ:&:&:kfC0:l:p:fhpRf vfP3ffCf[fKfS܃fF0rЁ0а K I+rF9_Of^fZЏtVWϾ u@3n_^ Ր	!BKV 
R3
t<^f~
w/v }/f0kd`Pfft@`[½ZVQWfv h,G-F&;F&p & &P&&{0&&&}&; q^bUaf   rGt >`*:ߨu
P0XhXX`aƳ؀ôad;f]PPRZIQ  chK{jjj%jG P	ePov h/f
w  h@ӤEú   hƓlp4 hn j (` t 	2se fo2 ffff>k2fhs
P	 Tg&; 	 f)f)fsg&t` b   tHtx3~srnfǂB 0E	e~/uP~/t a	pW;x2tM ʤ6]                                                           @   'Tff.f2j2WucrWJrR-rMj2tf0fqP| @Wb t#r"t p ; }PJR  ZR pf]LCqfUr*6@^  RNZ0rG	0KuҰo!!Vg&fFfFf^@ұe rC\A@3ۿYyP8E tEG? SBWAi4m r`4>o2p@ҍmN8lql0h0c ߰W rt r
 GC_RZt$ؤÚb$]W 躿 _W spO  a #`P
߰@S P  	ð D v Sذ8 e R	$#
R'
//(QWjuptPX_Yù
 d h?sxusz
ՏP <.<u.uĀ ~!RR]1R22< uZ#ȴ$ t	5J k 
	:bVf v@ ,Ј^h<àhӫh62$4/h 1ܓGKh¤uԻv û 蒲 PQW 0> 3_YX,huq=9J @%hNSs	A~ DHð   ! $!f``STPVhrz@u' tf` h.ȓa6vP<F X8[`ؾL &>]a&DEP&D >au dړa e%j@ tma}
 +Ȁ}	 >ia 33S [tSo[a>o 2[sd3 th2h܋Ws
Jh{Oaàh;ƈD
ϰ<QDuL
p
E$<u D
@11sd
rSi&pS]@` uL
 6 6Qa u  (X6K &
u{hP
	\

u   	D&}?u
 t&E_b t

&E^D
&Efww>Bt6j t.&t	&  t"& xu	\	PS   =? @4P'>ja_3& ?! W>ka	_[XB
t+# P xt  t  w\DPV!$!"桾t+h*s
hF
~1 &.@ &  ~`"hC#r!L	vTt
vC	`WU&n@t! $<vJ_`
SQ3  v
p''
u$< t"<u P>ȷXlPRt茿ϊ σ|ϰtϹߘ:В7߀thT^' *#ăN@xBpφ=q4]ZXPz` 22Iǿa&Gt5}a=matOu:0: u	Et!sE=`: u5 ~2cs߃
t!^&S q s  a
׿/ aǷ3eDs{&=  V ?bu_ ? ^  3f8G0bf_{  }0 U!    b&egWʃO&MuO OqfGtM!t$Ot, t"߹OG}r Ǿ`NM0oOg&b/z` 8(5'
	!,<t2>Er54_k,P*`THtX@LDhJ =_7_D D	 d_
z=1>bctSvrG&}	r??23ɰ6t`hȈҋa&EY$f	&M&]aN`.'`a%# rZ [ﴱcϠR0၍ZW&= uqF=HNY
h Mn˃8h݅P. RhE+mZq˰k_Wfat
q tVP
 t   U!w#w !#`0|wv
h3 D.-.MZN0CtI! //(rD.58v/Se+`T[uA gr@ 0\_B   ڋhbhsaW$
D {h3
hYТ@[X_Ë
?`PS@&[X Sϲ
A HWU<vLR
Z,<u(Rfff ,ZJvG! !
u
 0wSH
sA  Sѯ[¡n$pu{ 0G@aĻ  f3Ұfw< p@`֎h,73۹ F
t):u%RC qD	& h bͿ}a &	 hy=c}a3Ga}R3  I  ma qSiu@ X [\ rYbǃN rKŀf{q p4<{t0\7d&' t&1R- ׹'2
Ɔ'+zQPIrMuRӈƆZtpt! g r'h@		 & YQ`H?Sp[r%u% w= 0eY!j[f[s`U3ma+6 w
HH!E&QEԀ A, Prffsh_xfPs՝  xWV @Ũu$P<PtRZR1p軂Ł z OrjbZ nZ^1 hWV 0  PhBX@ 02+
*2wƀƐ,?!C@?r@D<t5Q0 1u,߀u1 
@a

+&C323&@t  %
t&
0 _ 5  " k  ( ;
u: >d!	^"	? A%o ^a{PRWD&A{ &]&U ۀA] _ZX"3һ -wv2C.{"/#߹N 3#h&{_ '߸^  Z	^    Ic>u  ׄ'SX \主 P`DMZfCa[f3fcu 3 Q>`\#:uBE&8Uu8p]
R +B&U
ZK!?ؾDMZa6f?YBP)7%qr h܋  G;1	't/u=z
 ߿춳4hNqxRP-
<tpZ`ûPV#
E^f  X`ED/
B HA   HQS,SUf`3؎ FwO.p ڎfafSfQf.{Of fff#fYf[2VftGf   nOIgf;t&f_ l	F`$f^`2ۢۈfaf`S||faPP3_X.>pO+ . P	TACO Fr O 
!	& .lOc<F	nO fFf.{O  sOF.Of.>{O;E.O  tqOttYprOtNp  D@SIVfB.f$;VrT%W tB!Z\ܐ	i %Qf2$fP'fffgf"ޱ'r. p l1Ff@c .ffHpsfXf>Qdf3ۃ!u+`s?I
s*"/S"Vf+f;wffߋf3w3RREwOo4^Jq4'r44$.71p6ɐp08333Ҹ  QW>^% |F
3}@u'JE.ȩ t0 t~  1o10 't
t} tWM_ } ,   F EF^V/ SV^P) uyQ`  &t Y&  
 < tr&\]p &\U&T 
׋U `&qzNd ma?
S &	F& $F^[_F F@Zp 0UW(rPVWًذ|P6' aS! _^Y[XWfQSn Q[fbt
  [fY_` t =$PnPu2M~taPfhT6أ#s } t@( ` j &?&EP?SRU@Qj@6^]ZPV` koU@ǌ!^Xp~ 
*?F
  t#cR `n{F  FpKs d3d hKu`<Uuùd `Vh}4d w& Xt   h}A& h PhE'`X!$!   ¿rsA 
߰ehì   t't 4  h\c`w tKu& & ? 
  ѵ` h,s@<t<uuТ 
0u?1*`P	hc# XhRB % PM '@D[%-ys)aPR怺NZX*%#E1*1U`)t_QX`$}  .`G  3`3 ZDoqp8L À   ; Z x     0N@`^~$bhk201fF3.Y& _r 
_0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^KY.~r@V_ 㐅û< fu ff @fUPxf!N
 ffFf3fvZfFsfBf{〹fЬ1 r9pf3ǿzfAP  fafPVa3v޸rF3X

S,0<	v	,$[.[W D`

Lb f s ^ f 
T
T p s 	 
Sf_f@s ЎfvPV,ZP, P:F s
uf^fNfV_f^pPrRp*fVA6?F@20hC@ Ң
 ff  fffffXܽq p  `907] P9󤾊^" v / a,P*hK{÷P, ýP)9u&ն^?t$ hs9h1bfPRhC2R ĺMP  (Q * 4ff:aD0  %=f3X2St 2MMS۸h   hɀhhXBvZqpq$ q!8̰Āu̀!A t0NCðvstut
t<1w(<vv{P(Ehs_0P&
0
3q 33Ҋ|tW۰/g.&;u;@.ont)@)hPҎt	؀a`2G@t03@ @u  Sc[
u9z3Q2,;98.Np
~
P/j4rX?~ 7Qr 3X@Y8SwQ@2P5 &&趿 &0hs|C huɰ hh"
t[ Ȱ t
坪ŀv#t_̰,5-PXv8v&> `t`_RP3 u $h2H  
#V 7  .>xb  22h|urиum&ߵua 
wUpb2 Q  hcôu= Ct= DQ tY0)y葶BY.xb^Ga1ζP$WSQR74 @3@ma&}u} -:$ [#%aWaZY[}_
U  Pf^ b]ӡrr	 
) OLPHÁ      6
dP8;V(6 
u^V- ^"(P*^  2ޠ{SP( 22< `2X[úB  $P?R  Zp?              sfp^[t /c& X   fgff+f@fABfLrkr.r^gf+Ff ^0r8Ur 8?cf\ rKCchHCab
fa<c PR 30 ZR" `&FpKJ^uhnCPp*Xhl r.>c.cpu 	AѧQRfW.c0h f3f%  ff_ѫXURQSWF^
gF=Fg^ ^0F P^fPgfv
f;v F;F
 g< uYa  < g22 IF ɿt 茥u븱% 8t
` ppPj ;}
+V 
N JZ=uϿ<N00?_[YZ]`P "&X&`PQp^ kPYPUkPk`W]]]/D              'Dff6f.gu;v` Qx0 >Cih *YCi"SwNQ f& 'CCKg  r)`Ÿ  Ci=Y>SLP3rz?[M26$&%<GP٬Pp	 @uαR  β <BMtf3蒰P2`@c  !XbVrUVWfU؎fO  f]f_efpgfft&fVf( f^3tHtHtuf@w@ WvÀgF
fp f+3fGenuuufineIulfnteluc32ہ= w7= wf+tHB,x<w<
r	gf0fP.nt%t0w<wėnf^f^3R=u  @P	sfˀrڋ@<v rsKsrUt f 'u f%A'u븑'Y=uUfQ g*t`ftp  ffGg:tErIgfY]Y]`b`lf!;gtxg Q4 I 7f8"gYs g롑fH0\I!"ffú f@tfHptԀsuf( 0    rmxl-ll` ! lll1 m	m^mmÀ:ɰ::Y1&uo (yP=<}t	<@tMt# ufff uf́@p týU $3f=@  rf,2us
ws ] ff17ó p}PW_еr RWO  3/OC?xx@o  .BB <t BB2J &ݾHo   8u!@`23
ShTft0`́ y aut0i at]U U[aSR  4hƣ
 h^SZ[`-1p  h=?S	 hԕQ
 "BീPaԀa$8uXRP<uTZQrtwv0Yu6ѹ }RPwCZthU2&<U   f@  hmך u
3Ҹ EFv)F upQst&,Ⱥ:3 s 't
 &sf.q UReUfVf!$: rsNhW3f.~ fgg^]ahf.>qff@Qfgf0uYKU q u, P3	f0pwCpwIfwfwgf.#f^9uppfY7tv0    /p ;h  p8Q h. ٸ h, 1瀊  >QV3%4@40t6; hΓ ;
V^BE"/fWi &g 9  f% '"t #YFfFA^faQaV p @\  
^b]3]<    DTDkw R `so 0 ȳh w 1   e l ( Pb @z0 W HL P`A T W Xb, `
^`! p@pؾ`sx o A0
|\D`QWhP3 3_`С 0 PQ= `tqѽ @YX |pSPr
& p  ff& X[oca"&    ir  xh}  J5O fQQ>-E S^@ݿ.s4/0 љ蜠 <t.@l~虠 tq.~ri."D.|u.:DtSI ^ wD:r5+s&v;
uAm
?cC1%bkPQ13^S
fV -XÑ2
O`2	  "	f\Ж@0fɰ%  3f3fPaX Ah  l0v ڗ fpb #&f fa dD 	h+W"ϻ (;sQSfrGf.
 
2@σ	40֠qп
 Q[ffY+vޑf[Wf+_f t%ȡH/+f@``h0Q[- f@rf`0z q_L2_&#y uZ=PrUf%@ uCfy* f=`  t0  t( f{f
1"0"fph'a%/$_!"
 \\ycfFQ &Ffg&{ txs  @z{f;~t	uzɰ&~q|N|V&Ä{{VfPXfXU`r<wؠ.?'{U5ӝf &ˀtg&fVA8&ưfpfnu=жtsaNu(g&fVPf#"Ȁf+p*)^f^ugPRNZX2u  w & P XRhE+Zt5vmt
t@ Z % r  hsh">uЕahsD-3&>`prqrﲁuR zsRߒ@uthuu	r` 	 Z-jj B6uS`` jFF phVrv+@ `nn=ﺁ ؀>t !$!֚$< uCpx 
 <u_r<ēƑ	Vhk*'a&f&أڡ[%(}		䡿"3`A%rU [u ĿTYP='t %
u2Ɋ،P3t<u
< tȵ E$<u&w $tuRVˣL  N L 3NprSCu û` t  P8&[E:u
@j j(ǽ(!!2g(<!1Ằe$ h>u$0끀t$~!.#K .t4&^ tJr& w 3.\{  ".\H.d nb    W	x .|whb_DuQ&~% t PRXӹ
 .:t
 ._
vXP%8Xr6%ȸf)R3;Ta    PJNL p      QKOMp @Kt  Jt P(.DGH hõh  h3Y h  hAE !EE^  ` f  Hp ]RdmZ K 
v %&T~t&<
&=r&jp$~qڌt1]KuB!
U@!i_(q _" sR$%	lPP&` 	3a C 	H =rr`2pshvraVRQSh{s|4Th5J2.hD6趋越8u,2
t&6<r@t2 s ޝ[YZ^Sû Ph~hX<?tFh(fTe~jjjj P@ &hlB[\ h^ $vbwt = ;t= Dt
hcy[ WVS%@a%
)[@ @v= u"*׿Oط߰h<TsOׇtd--B贊J變=Ot1j0b@|Rf rh#SgU^QﶘB ~@ 0d{L P5W ?  :J2?=q%A 	
   >XFP kpfǋVW 2_2~Et2
u
2 
 r2䕆2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2`^2*à
&}v~xhNqTPRQ3& 
Ь%*t,YZRPSQ Zh?tu	rr ľP> sQ? 6tXYl-G: tY4
G*h&&  t8&t'u ,V p+H6$`$  \& &&K <[@ `dde`P`  XC̪U @?
ڹ  .ـ0B B =8uG` A݁ ; 5݋/)u@#BS _ʭ6Y"@ @WA@ B C W   ?Ü
 dt&&Ȱ'蝊<;we?ċ  X؊<wM3ɆQ#"XR<  YƊȊĴ3ЇуE P\8 E
68u@u<uz`0FV۴	2U
v058VhgP݀k =)"_f&. ."/  b&k @!< uf& bÊ$
R 7Cu%ϊ1uh$߻Pf  f#f#f#f#f#f#f#QLfPfSfQfRVWh^Lf_Lff
fmhmf3f3ɹ f mf0n f+fm ! K^u*^آ^3ہsV4C\` a^_^fZfYf[}fX3h 5U`2|L揀M0s< |&?	3ytwp;u4QP V-t
"ARbKBC Kernel: xx.xxo
 ` $ pK    t?  .]3۸ 2ҹe%@HaaÍ6h{2VWa18{_^^` hG(3=h uP$<X3I)sf @  t<   4 k r	.A$<u
@ f3hh.@ 
d]p jJh㤦=  tdbw_?s.>@Nfo t@hFĺC	
q!U2 u@? l > ]c \3Fd@ e f Fc~ce`@4~e uQ@@9 hnSc5Ա
P	dh/#BFe:Ffu1wr,
 h
 Fd;   	:  <g htmKhzühz!af`THgh*ҏu;E#f% PCAXt#_ Nu	,D&N r0 hfPξ   F^P XSĻ  y ,  o   h|-[t(t@t,i i,>" ' À thtZdúߋw."**ED/.xpE$q+Ë؀ބF/VU2NfQa dYF :uE]Àg33tVtst
}t
t
u
2րt#u
tN 3t?"FF0u3! :5tFFdz ulm":``F: uYeb +Πu<?6F1 ep0Fff`Gup  ~@j(j	R2	aURhd2  ˺ {1 h@RZ]ÃpRfB?pr@"  to3hRQ Q;YsY2$
 !u$`e|Z0f` / ðXXfIN.&D_fD  9`Dh
 C ƀu0u.>B 12fa
[FRtUqVHhK{yk:Zn @Zp to(tq 	. u|#[oi"g Tsq@u4VfRfA`hHs4< ^f[^D8"o \c[Yhcr vs Wp١6r!UR 2R s rZQ'VqpX  `.CuNҝma$<u7 pr& .㕩 t t@vB t`t a%u N9ި`
`
`
`P` ¨maYSQ u,SS[r&
	!.ͿY[C<ff<!`00xx00`&19||	>>.w r
 ~ (r]ˀ'p &G =`!<!7' &$ tޣsC  Eo rB uzuN D I/u00fA ;q5F -7p@V aUfV3vCDPDQD 7@?f^]&໰PPЂJ zwPduXdGd8`ߏ@ ___ /./././.$.q/ "  @f%pd0ǩ Dō$r I FACS 
DBGP4BHP  30B1 A!  8 ? APIChOL	 G			

 		
  >` MCFG<	?TCPA2
PO A	     @({ e '
 2'A*N     %E  E ("A)EI*RSDT(  (I(X,f`ȎߎhTTV hԟf V fdf.tߚf웰.pgf^$?fp    }"gfǆff3..߀dN~$f.>x `fp$|Fv@F f7'h
Pd$
3ffgf&ߥf.>@ı `M@$f.t&F  FPTRU R
wg&FfI!NcBpQf?f[1(.
,.t2赨P6x	~}(Nbq	Sgǆ&  P 2fffcff+f+.umf2pi	2	fYPq@G#>pEP4`P0Xff-!*ñqV3g&fFgЛY[סff=TDSwDt; St3Pt+SBSt#f=CIPAtf=PGBDtf=GFCMtf=APCTt0tQr}$< u2{zRfQf̓2 tdpump޹rUr}*v!';0 }EƲ<Qtg&P
rX*fYf8ʰȥfWfV5?f& f~ >@/$|p(@86f6fP)婊Ȁ$ 4 
Ȱ F
ff	hΩӊp@;fhgrthnR;u3ɚߡ tQ fPW %fX~S jDZfWP-@p*ve*Xg$$m e jj@g& h: 3hdL71f._  tc440
0V?Q0Q=p}f1. [&D3fCCC22CC5 ߚ 9Y(t P h*> 	@1 JLPdf}AttD`& b#   if=KlD*<ҫRW D hр߀ h _ZuPSS껸 $PS!u PfP3s f&L fSb}E
L fX`ߴhv" 03f&?    6bu    ^OGobf3{Ӿ p䶀   U!   b>b&geE E puMPMeGfEtXAtߴ$Ot3 t)O$fM~
rþQpmMe&baqqU  r.p]h$~r.DZÿta~f    ma * aPW f
Ph	xD0f(&tt' t u(뭿7 e)P%+io_VΎގƚ`L ^&Sf`FF  hD uP_ h.  U$g(,0wu4'8  Ã9FtFfN:F> h;[ɀuh(fa`DؿE13ɊMh-t

h ;r%uacUWF ^VϣDf+0GNPoNBf.9ߗu tc rfߺQPH_Drf;^uf;Nt;ft)   
tF~U_ DWVf`w4
`ɓ_ @SS&VYRt }`!	Y8g&HPH `g&@uhfP _u	fX: ht@P@b
.ߥZXyu .ip 3 @ & .>t= fa^_.f   Q3g&w@hX
YH`g&Hh`XhuЋPd ܠ+t+Wu+P+ ɢB@t\ސ&PYɷRWVc^_ )vwfSq_0qtA"  u
3   t}'gf 1G򘀼G$L<LT }COMPAQ PC Card Smart ReaderLGEMPLUS GPR0LPSCRq CQLB REFLEX 20Q241 PCMCIAVReflex v.2$cr$HP
  G@! ,O@GdSG`0   rLfK sEcr>G	 .D!G
A"O@.d.D~`4f`_ PQWϬ 00)
G.P:uG Y.5 _YX8t<t@F 
afWD
"
@
@B`9gT"

Ṕ%Qf_* - UycP`?P_aShBhu=} ߡhG Zu <t rUr  ЎvVrr^~W  2_s
 D<tJCrE.A&=t&؋.AuV< ^Lx 
y z {   h@hl
|  ({ZnhzLPt =upW  fЮ  6
h,?f9>q tQа.A#"=<t빻<^A+[p _*X$SQWȎ  <p^ crd~YrS&tM tB&=r6.?r(r%t&t2_Y[`
׎Ǎ~؃^ԃ^֋ڃtU.6N09a 9u;.>׮ tU  !&2 iٮ `j0@vk!n㮁nw䮂n@oW05Ej6.6뮃y krr 

rf	B6c	rNb&^at ?(4
y	r "	.!vP3b'О@ ; P 6rj&
 v p rTv&rB@r7&}u%&E=uf&EDDpP r0
}r 
t ׃BB
r
 SP '24=@	rl.&:r_ vp6W Q
rP@ tI	<~ ݸ
=@E
tQ&A3¥?GYۜ׻5h2>QSwVW	'	6	r`(= u< s_2.
q	%I@PP  ro.2x0o w	P_^[YSQRpCТ8ؾM tٮW؎В>'>'b?_
˃<S3(QY2D5 3 3-Wކ,.@|_4,zx60 ;^_^Z< 
TT ۸,P_`v.容  p ,DPfLFs-<t(<#Ȁ0&Z h~L`E^àEPRU32t
t
u
ku
 ur餿 t!;rՀw/tM> ʇ"SQ X$Y[>"Q;>0I`u 2a0`*SQY(E;?!e	w]ZE]f``3r&}tho3,֎fvp\@qgrgf9tЦa D2 *0 th|}Rd1 m@ Vff3u"gf\ F f !3pf? t
@ /0޾u3۹: 8tCq'P qtrXfPňf uPPRVo
tdܷP 	 & &$ЛTОRu	& 8t.ZPP^ P   0 ? 0    0   0
  З  дi CR01    '  '| s 
 /  %Rp   d]	b%ck@c$@G k"$Q  OM3	Y׺bPS.Dbް޾Jӎr\v uTG{rL0Nwpq  wQﮝw1󮱡` i5rx36rd̸xE@&_=uճ
q ﻮ* 5Q{@KwTewrWЅ$^h鮩!뫮ۓBq 0BB
B:qZ-pۻuؑk=L]dn(uIQC!^
$0ӆ{ރ"\rWa ZžNDT}r eþ55hD
Tb
$9N4Rϼr# t itct  t$_1^0XffL7	] 	W0!	R|S
ïʽ@+0P3cr8u_QY_ 0Lr&UkL`
v}2UO
ދA
 s
t0<i_u,#/+]RS݈|\_DL	(`at Š03A@L6NKB&G
\DLjC

0ѶCPyX.ס@@` $2L1nB0<th3H8t8u6
uBp & D?BlTt
߀zaP 03 r/) r%BBn!J@ 
; 05 aù<t

B J 2@u8` BŅI2۬2؇Pu+BTl&2]Q8uC\u rq@m ri~ ra ñ  tAc rF n r:i r5&D?@u-&a$vQ> Yr	2QQi'Y߬B@Aq Br蹐{  	W  @@ `  !f@v  ffư  m !f`  t~ hs
èo tRԢVXYς h%  '% ~觴hfa`    ut_@u)Ɵ:< uup	@  `e3Hrd rπ DƆ  P rZ  s-Z@^   pπ$Wp_ǀ uu' 3g rhzD1 tg	 u%@  .AfD  Ơ׿fVǠ!&""Y[sf0u.#̒s3hn6 }̻ w> q̻hM F  ~fmߋ J% t\+sf=R	H N  ? 
̻E~ .D@t0*݃@eMF t w  pFN QF ~ t˳	4Rpf^0STcV _ h/TV<XXtFE:rq ؋
00޵ D	  A;[t	q= ;t"Se[Puu;RTUfa @"fRfȋ³<fZ`SDDagPf` WPf3Q fY`0@ N(  ' 4buLPC:!&= t<R %ZM \r01DoVQ&U fٳ
&Y^G@^
Sf" 	
p
@7:!@7 KH7 ؋ IhI#Ss 
0U}|p` wH< P -q]ws0uPpIu[	¡	1tQZWtg$1DJLP2@ [ fSRWE
{D& w t
 tP _%b#\	(bffU0:T2Vt`
1e;'''':R? :Zt  E'
QV^ f^DUYfPµ'&D{.t'H"ltztKȠfX`L &z.O[PQjjjj P@yVY\ hsWk
ZdvjU&F]^#^egFF= <t
ŢtNOXQȝa ֓Vh'  p4> X	r
	 0cf8А3@ff#j @f p B'}PK{tgofPwfa  0 f  З@ 3gfhd-Ha# $~ EQ0Sf3CES膯Y  f
ffK`Pf@&@ Cp e  q3B`C[fSfWak  
f_^>nq? s1ؐ:_f^KEҦY s@u}e%.K..L̀`P t3Qu	  c t߻ .>t*Q YQP5Y  gw $@Q  hfYfXr`!t[u . f u-
upu0s&sEff PХQp  
P
MLMF弋كt
t "׃ ! g t \phf ]POj wf=;  p@>3 [jh tc SRKZKdcuWLMqCARLLP$FLuW uLPX螕LY
0dPS	2FLBA@ PUUW              i Ȏ؎6l薞r'6P3f<tB>tf&f;t	t3ҋCPW
 
t_   @ك
_X4SQW  hS/h _?		[Y
V:@`[e{W  W_fbg&3 rfTbu!g&pZg& Z1\`_Pua] Ԑڠ   @v
 a$bAZ g.k0N
:8!0 Pf% g.m@fHg@0Qߤ O@kDSOD    pgD ODvB _ g ʡ 
 8t d dRrr{f
QQf	  qu
O@	br	g&WƇ00"P07PhNo6wXPR Z S .> t.}Q .Ӑ\mOt.AaɐM0QO H @ UvTf.~񾀰 .|Է h_f.p]P xf@q_fpp{	;h;cT٠Iv:fDƀ u1 
  <uq
t.t	
;
utiu~Ԫc. ~Iqp@T`.B؁uf@x:qvPQfZfQW 3	< 	006_fY5BҩWCUr.
fNr~}~1fvfgofff O hdC%f_ ?v^Q` 3fff׃YP
SfQf"9xsf-xԈ\0tfD Cr"
uf.`` @.) t2[Rݟ BE@fQVff3 3fO^fY 3 ~
  (    SETU ˸ @؎  Y r IW@ P& u_SV  GG0G hc ߇   Gu Fu t3  hC) 
hBt & ^[SO
&hz" '[UVW F F@    w < F`D2ED2E
 2Eށ 2E _ 2    D(2E($
f&EPXuafa!tE/e.a ƅ @<qt	dR>t <tjjjj3qP@ .w_j5Rr$<t.<@t$t = ;t= DP h5   7"FF~ t#^FLr
F FQ  ~ t: ] *f
 hC2%PkFAc~ t
FK_^Q
hs^Tudu@   h~+$?ط h@cR"h"h6(f_01Fh+{2$..]  @Y'` 2WVe1E0PE.WV .^_UH (UQSi50'i5(e1E0eEE.U s@ m2a hrC3$?eU49$:8a3qr  utw
t1w
tBPSQW33 G&./N_Y[Xõ   sc3@ @   p^ D  /[xsqUmf* %  < ! 1C  s	_
QVWb>u% p u P3  | = <tk ;A( _^YqRW0P  Ê %TCrr3ߺ ڑXAB rN _Z1SUEH H)H
VNujvzJ`LJ5; DE<}@ ;<<!<3Qu KKLt
Lm[VfPfSfQl~ mf3f3lPllXfffDDG(	Dh fYf[fX^r#j0HgO Gx1mQRpA3ۻ9 @q CҋuB`sxfDf3ۋfË\` 	
C  T U S V 		-	`h0uh  h h h	 h	 h-	 a1uv.L.< t)F.63.PF.ߋhB[+V..^̋] yDF. P .shlXh/؃04R  16W  0"Xa Y Z #[  
\a a _BA]a f gn'^a b ` `hcij!k qp10G pppQWĀ>t?		 u	?	.G	_7   O 4a9Rһ ߃-w C.5/2Pm?n8o7@W3۸ e _f^ϊ߸^6_>QRrPS[XhY(`fЍeڋh;a
3     z     KBC  [( V   Q LGB=   0{+&!	!$03/04/05 Copyright 2003 by Hewlett-Packard mpany D@ !`t` T`  *!'p~}P >"!"!'DTTut0pwt@twt t`A	"@	# d~ Y`DD
=t@@t	0&6t!`#8TDS>0tVqt0"#D@0(tQ	>D	T0'T?@D &
%k"tatt DuaүT$*""#$%%#$"P&dM&&
@%%p$"2` `ЂЃ| u u3 2a!Txu. B/q >$4 `Op" P{ Y T {Y(
"  "tz|}~ }䓣𣮟
!`@ -"Cp`t   +,-.00..--p,,++  @p," ~}|}>p"{ z}!tu r$} |tl$h%P '%($('&G"!&3&P9@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PT~P%&$ |Q
0%
,Q
@C!D @T((s~1 8 
BO0 Qp" qt~ 33BO]pNIA,=#;". #߭"!aq ?"QUT8"uPu4"%$q4,tʎ"0"
pXp"0"_d   \5tUtV`]5"++/ÞP.%@^ Sp`A [T߀͹m{ +u.!-..3-N`I0
,3 {
	,}BSe,`C"d`"7:rb8"ps        	> ;3   06/16zY205/29/06 kHEAVEN {4{{.@RaR"x#TYT0	T@ 
t/{3" 8xhv$ÔdPx>0WN"""d""S2%x xb} Quu u	`	[[@)!T$3TD ȃ@VF @~`T?0	TP``T%`@@ałŃ 瀾xD¯1o~Fү bu12"xt}
~"x`vvuu@tx!Du)u*u+) + 5FvGuu!*үx0PPp}Dxh``
$`$p

dx g
.x1x txDESxxxxjD@@/}W}@ v o ;*}d`xHBFa&sx}DۣౌQ¯00xtxtyuu"*`}m`}ts ,{a,+b)
xnD0P173 px^Dx_T_xcDxfTh 0p# * -bLV
,&05@"RG	Tx"b3
x4T00`]0} Q!T`? `  %Ơ#P"	|pT`#9 r*r0:Pg	tXP	R<GQ#!
¯,u,$4?i|T,}',p Y(Ô@^G-p,
 
0%?
3
vp8b"-`^00}./@ 02`(" ",=x'q,x_`t ="<}

P} _}	!	 ֑ @$#}}!}a 
xxt"xg}A(}DQ" , 1}=
Ъ[l#rX00x )xl`xm  p 0S,;0TB,x,¯0*R0b 9P4.,30Bx,`xOM	, xTx !
,:DTrKLPFЯ y,oP>

D]Tdp,$!$^P',.` 8QPÔ2@htx0  ¯xx7x8r x001;`<%g0< CT߰J`	pA7Urz_<@5HZ[10x1,6`@ 00a]_"[[t# `P!\x, Y;xtx0x,AC0TG0xT?Tx*\-tx+b]Zt@BTI rY_P^_PrQ"pPm"
,adGq`1quxe_GNG0=̀ >  qP\>вgxgpvRd	@;?[(hqTP@*AUx-	+_VUNx*VgMx+` 1Qـ }`U0ʀ 
 veT`
`UVSS1 0YT `W  k H9_Z Y[NS[1a 0 ٱ	Z}[?\o0^1]1]aY a\']^sc_	_T=W_R"^q	_A}@ A}= #-/ 576A~l B~n  ;A~m uuҌВ"T#8x'D
^ 038d`!8 n33TT?OCЃ38`'`2`=`HpQx`w 6uuuu r uu0 uu5ˏO$ƨpN`0T`
020Oй0D1DaD"+| }(8x`P",--E,p
0 ,AG--, ,-,x-,0pb!--@,,xb--"./T0ӯ P73At
Pt&x&Tpd `+2g22ÿ@2@tx#Ҍ(響01mp0l`
01d@T	`E31Dd/.01|" ,xf$-xt`o3x7@x87t o"d``^S^cd"xer_Ab0cx," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,`7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >AC g d  FApqIkli/ur}z'tw l k i h Ju s r p ; t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ |x @ s   ww ~~ r  %":x4D@ T̀` D)tZ 2t?x1tI-0'%]0'A'xtvv 'xt]FWxv$% & & #2#x1 	ү  ¯0 #%°tK~3$b0#	Mx3F
r bgJ"xuF`XP p~0$" '	x30%0&<T`P$"xv`dfp?
0#% tX.4} 
xv$3z 
`Hp`p$W$. yvp1Rxrv"x0	DP$$6Ӕ@TxyD"04hxpx@ DT 0s
 peB"pxx1xyx"xxxxyxx	"x{#xmzP|yzx{f`Ӏp'x{ QwB@
"10"010u1 u100" 
1WJ{ _!f$>0m<QHRtTX`  
0"HD =16/(!a0"0
	10"Fd0$!02¯p90?x2" ~u ?TA ""45Ӊ63/:}NP"46{55!_Q0"0"xro`xdT`pxqr?v+r!3}TOp0@0 0 [
Q]P:0 /\uP'2BbQP`Ӏu"=> "0a T?3u$,40>S0"{z}yH338ע?
u? >+
`?=0?=0=@o3$-h'Ô@_0p4S

`^$Y	0
	^@À{0-$`
$`$p"a"V4#RK0" [:0!@ß-0
  K s	!93>0"
3xrfKs0*3d|p0>SH{zy 3 xsvJ%_`gK>P2 _( 	4  · "H	5456q3`	t%6645wߢr	@ :0	h0"0>`	3A0>< L~r@1 
 !o
 +90 B >, 
j	Ӎ" "!`BQ
p0( >"^ 
-еNU
]DU 
>.
j'	30"G+6,,f-e3pO7)0	LP85p
b3&05	c	0
ES ":"08y8;sfpOd:2`"/c)P3
ª˦Cxq`qe`?0}Dp h-tg-"a-a b}i!"5xMNOpxD Te5`^}V Vp0
T5d`#"5#p~}i5zx_d@4 0
4 #㐛`4`4$`j$`6$p%	$`>$`$`.3*$`,qT%70 DQpAh0Txv{SKv`@906%L i`@`?Dx@[40p~	4^"P Ctp 	`lr搬?&I¯?4 `0@
 p)TU`xn  OM*` /xv
xD}S&G0{P^`
}mT?DtS䀑PtYTݤ{S#@`T`Q	0898$``$pa1e9`/tg9r))QDѱ0'0*a a
Td`x0dp#  xF PTÔP
@*_`xFt txBUBxNN{}wxJqJp;<=t/?>)x ү~!;%$t>t><2)0 )>$Px`vT"` 2'=x7"ү3y(;< 0) <;@ p0 xv7xV97}'p p 8  %87((8  ""99Ô@ p/pP(  /..d`
&~Nr7(TP5O( 4 4040x`P564``/`@$pN675:I&du~*);mPʿ [x 
43oppG+L2<>gp1  ';sP"T~ _,?T#?d`pxH 8@224P65b3e1@dq?C2/ 
m
@d,11xA%40 B2
@
 ݈`00
TDT@5q0	 4:@a AP}Rt
} u3P3b퟿tl@
&Ȑ.
@	  r2l0dpe#1DxF105@2*`e bC7xnu4߀0 0u4r3+~(t2;234#.2}p<0 =$43  a<1? }~
2pAR ErpM"p  d.u*x0s-u`2:-]P2UU/05-?-* 2732pha-
$,2O!% *R5 }
Q'x`S,0	,a .R	,,`@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp/~LDy}?N%@k54.Eop;OCD.qXċTQQu:94: !p	S41B4dUA`hy%%Ovtu1QON@pH ( N9
d.0
`_0MX6Fp0X--Fx0571`5#O1]c6e`	S8@2
QT-2ÀI%P/;u2
p< u22Q=+C{p4z5z5
3z+,yuv {| A, 90 & nPÑkT0 ,	al:Gpd010 upo66o-/.@ppFB}}0
~P//.rdct%0d Wu tq70YS 8S;_"W4쑔p1BŐ}BT_0=+_<I?_`$:<p:T0Oő89e`pYלBxjSTAx`%ddz0  98>P$3q"W¥A3	``"uqq
r	1Q`{0
#}
ȷ"rdP:$$P7"{ 2^F}&e
'AChS4Iq}a X@apR`pLxpG3p?u]1$U^#5_`@TU`#v@|T kx{}Pxzp V{xy TxxPUxwQxv0Gxuxpxtxd{xs`xrxqxxpx`{x|Px{`OVxzy@oUxxRxw Gxvxpxup&xtPxsxrxxqxxp"򓂯pxnv0|0,pTxjL@Ȃ" .4on0.TxjڀQj/{`p0P .^ ##..^..i C?"-u02ώ23B1T./32Կ^ L.2/ 'q-xĐ0$^7-T{AO./`۷pGQN/E/OMJP71py0Y)d)y0h
PI5
Ps|?`d7]}SPn-rtar4֒N0 `a2Е
p1
P

Q "u. 09r"l  }-n1vg8-  yA3/02s/pM=1s0D@dT0u`zP;DڰS-c-u?/B/`] 2 p0`u/Tag1C
/{%TOлQN](03p	 `` 9b  :*$ :A)NӔ@y6S ? x0s!  x/50QRq7prrqxvCWU	Xu
b
		0
  `
7P"wq 
G1opTrAL`>M)70.T`@}w}S?AP33TBDWD ~ Axn7"@tڐC9xwVxFdҢX`T`HT
PM>@D!3"xҟ*"0w\]z@0Qqڢ97F 03tv`
pXr *J(( (BP_P` q6w0P `	qPa"QRw.eB"TREQ Є1kn`=)v=A=aYpo0:BP eo0!JI$:1PJ1,F;KFi	D0c
d^"CO`@"KLOv30aA!L_dp`w@0ttq A2bLBxM``MLxrvKL<6"xFHxGIxEJxFt@0) IT.`xII0xJ@Ft")"I? 0 J=J"xB*!C!A!B/)B*( #N*A
OA
MA
N/I
UN+)D
JaKaIaJ/iJK
I
cMNOPd`NPJLT&` v0uN N@ 
POtS Q@KNM}m}t}}{EAMI"//C} Ô@""=xr."xiQ· =" x``xr."WxD[ЬT0WAp {@9$0+H;x`E}@1UTKF}R0+XWAmAgA[AEA9A#A@@@@@@@@@@  AyBQ@KK"4eerat"xer o "C0D )6	PR#Rq! * 	^_@1Y R[Y$`RqBCb ]$BrXӔ@XlOȯXp0	0!ZӒ!}vX`#`5`2$pCx`E@D4SS [CxdXXTpxqs&NYq 
xmx GÔ@π<PTxmCӔ@/`B{r
T" Ptmxi0Pdv+xqv29vt4}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBmRBAD+@9*F?0$0ᶽDP9}Emb $|F6a0X`Xd`*uXrCDDDDEE
E*E6EIEUEhEsEEEoE@CE"o@D IttRB'
pE<B.}1F
m0T Ag@$$MPN7 1&;T Fa7Ñr`Vx['GAS
hRa?`YÔP؀B`9AO0D=Dd
`#p`(`0<`PdP`d`X]ݎXw0@PR/`npttd	SxtxxWtxXtx\x]txat"xbtxJxFxBxtx( xx%tp&x)t xxxxxxtxtxtxx#x;x:Q> x=tx@tI  	a	0x6txTВ}ష.xtu"Ttx!TTTD?D@xTp
T=TTTx= Q@TxDpD? =V1D1D 1T#
xnv0_}Gt U@iQiViT jP}S;*"x0xJ"xk 3MsM"B S?/"?@>"a$tT>$-"TpdÔ
P~0~7%XXiWW7%WW{ z yW@H H+H3I4I	6I7I8I$9I/:I:;I?<  IDPWIY1	 Q
 I`A @V1~5HlWW& 8 `;cuWuWK0W"$`($`*`-@|/vp4P
TB V GQb U T"VPW$```$$`(`7`F$cpH\w	A^@
:3
2  *}0p9 `#'Ӣ0A``,`003`G`[$ap]Wp^"W  dpF_ 0$s  `!DTwwq0!$ W0 X "T}$pUaPMLTd`pHTxkTÔ PTH[Hq@P
qJPxkv@PKeKeKeKeKrKKKKΨKKLL
LLL2LtLyL~LLLLLLLLLLMMMME  ML0
`2v"xMNO`uUUUs }i  x  "%L"0U]
U:p;`|"} >HH}T0A"uV 0SVVT
ТTV0CVp ~ {0P 0y@4xdtWkvaUQP0ӒP nxTxnD0Fx ̏Hxbx"x@$xx"x`}K}IF	
Q@PM0""3HxW| } ~ ?J{4Ta*OL QUU &OLMo((sMMNNNNNNMMMMNlNrNNO
OO#O;.?AÔ`P/TIM"T{? } 00xpf"TfVoTq0JѴ0pV	50T ;uTm0ʀ*` 00)؀	0PV":D$p
;?!/0Tp,"xdP P0A3"~}i yz0?IU3dAP>2J1gg~0M}E@JWC`X"! .YpNZ TF mT0d2Α O00# 0xD TQxl_!1?xxlvQI@T  AA=B0 12u43}'  $42T4433@"P0  "(u(W "   p}"0*`PB10Ô0pC1S11Pd210@@"
Q#xp0 "0#x@p24567&J@"(t?5t 4x547R6?U7B udxQx}QDQxQ  09Ԟ<x}T<`nTCT6QCQR
R*R4 SFSSTT
T<x
12!x
tP1P
21Px
:  x
Q{Px
! %<0$t $T &Qxw濴	}XBxv0xvßP2P0 p;%@$X$ÞPxxv߀R`01 R	`$3`-.܅0u /p0=Tt^}0$`&ppAP~}!  `YP0u;Bx/.-0d<
&xxwӔ@v%)xvvyvxwP9  @'0 =	b<
`^xv <txQ`r
paP!0	-xx
xB"x	0<T=)`~P$# p 0< e2pTf TmTwTTTTU@	Uq_
  U{`xjD D@2A"?xDcV$P`?`3 z0TOXpY  ,oD"{;:GT`i`S/AE@E +@@CZEtGm O@` { 33TOB4  "@ B^@0x"`=!`p}Tp`8 -5--F5S-  KS-`xhvS- ?S--",-00-WRVx	` }"yNJVu1 u234xi`-40(?Ӕ
P!P34	D4E3NYSSS0S4u3 u53U14U2Np2%2131555P	6xp7x	521ځ	^`_
66-ӔO@xA1 YM<1c
`/p11Ӕ@: 07-	`	PWWWWWX;XVXqXXXXXXX$Y
%Y&Y+Y-,Y:-  Y?g-`:S	Yxu0@xEqP_./_P
/. ^y	
x3?t?e/pt e.0
` q	#qQ2q"	ߔ`pEx@}햿}tx*`
.!  2#@t`-nQhvP  q}U pQ t u vAO}	}150R)1S Q!q`^"2&0 -,o"aP|ZP@YYYYYYYY	YYYZ Z
ZZ!Z(ZEZZ3Z  Z0_Z_s  S1
tt)Qu}#	e
pu& YD pTӮT WT0BT
":ĴP^`pa'`Q=T]P  rgZ`!L0dGNt(DiDrOBkrsQ
xbn)S@`DRAT,T
qM0C#_ "gD `E - gt .`T/Ӕ@"p..d`"` 
`.\E/t %Fe/`/<Ô@aG\D[>V\D%^"Xto/`:``ړ0U/`"U0`""-pV0`cÔ@ OeA
"x
qxt "Ӕ@
u/$ -$UݯP"xՃЊ0"6}78 d88p787@66P67 B353'   a	"? ]b3 ;]M]]]>]7']k/]yI]J]K]N]Z][   ips"xo00h"o00T1H: \$Ԕ %E 0k44%$a e3pL2650"0-5d	%5
5ura
rv"Ô
@"55$`$`2$`B$`J`[$Wpk1אP 30/0V_QRP"D	zqv34Aq:b5p-7P!
PD"""Q!0!pZ_+_>_D_J_c_____  `0"aK/u<u3#`u32b }! 0"tё]u3F,!wu3=r&
C^"Qb&6r3UDE.u8
Z/0"?HQ R 0 3A3"0`"x%0T~t@"_Ô@P @@	T<"X@ OpQx1~ <N "R`0ߐ}tp0	a~`d#`x0x!TT`Dϵƨp@TQ!D`Q!T1 <oxD qR  pp"X@'x  	xPӀ "x;T Dx;" 102^1 /Yx<S0g 2/1"0/A~ o`"0PbT/"/PG01a@    :	;
/'
123B=>C	D
WX`~x`!aP ^`_g"
% 5<xF`7v0x, ,dx0xqc;,s,p_`C00+xT <D Pǯ 20z DT`fy PTT`E0	< 1 c0S 
0cx@,$```90Ncxv (z q DxT"ҎxStTTHb!,xS,<x-{<-0T`$p#,pxSwx,	x0<00b
~
0bP ~"./Q@.Ӕ@	}.N.$``"`(
`F$epJ 0dC/` _}/  Py`PnD}!oT0o/s p l02iu/d@qP.R p}-} /@5CO@ g0
C//Ћa~f_g @ duŃ%Ńsf" @? ? ? ? ? ? ?  ? ? ? ? ? ? ? ? ? fmfvfff/T/
 7f/!"df!b0
R0@@&  xo//T&oxi/i@C2[\%/%{0S{ 8%Monpd#=ӛP	O  =Þ@d`~@ӛ@*ÝP@ABu t/19=t7"PKD;`p"x Gl"ʀ 	012345u61u<$t}5} 0hhÄii*iAiXioioiiiۑiijjj;j;j^jjk-k-kPkPkklll/l/lRlRlululllݱlݲm"m"m?m?mbmbmmmmmmmmmmmmn n   nV~V0p pC40}u@ uA uB4{g5nmT74 7b!~1 7` wR4`uu4pwuu@uA}uB{uxu{]{X$:@AoB{&6ՍhgR1`N * W['Uh)g
U
-ɘX>*05ࣵ ]E` } P0C4+1!~ .`| }` @?^_N0"`"!"HJ
$*
#5'((INp:Id @(
cC 002{ U7'+'(.U))X0,U/,28.17.Q4 f03g0o.| 82rPAA$__TW&A2 Wu3dG'XAU=9='UXEFxBUwBH˨DDU(KFFSo UHH#MPU7m/P!}UBfP"C0"U@πu4_00ZC5"$yހ!SPPkqp" ? "CD~R`{joQ$0o`T}&D`##xwC}}X} Y  ZxtEExwPE^Q`0%70$@"Dp
 pµ&@DOPr+ 	 	Y	U	Z 
 
[
Exw+		"=>?x>T@0Q
3?Tٮ(AB`âpPBAo IPw0@p̀"0?nO} P' ?@
఑| $ >_=>?h<0
.od 7Ep6}`~T }"uzQ p#@!t94f}%STTs0Xt
䣠"DvπM3  QP$B7,yg,,/"1yu2u3}u4ƀ1ТrEɫ234 СrT?T?` %%Opt1`	"24$531pV1}sToD kt@A?31"~T"2kPqO}qVP|@&p0{w``@ 
:4tUrrU"_4:P3s-{,4xhT`q<0<
 3_<3'|}pp
"T`:":"0u3<1{1`~`~^ׇ01ۨTODԿ#2p3/33j*0 $$Qп1 	4z h#P=0+`
=a&P @n3PB3&B43p0=mmP`
Rp@P
^4"0x?O"̀1<# 0Hu 09E9819e1`11K>_$Seau1o2 >2T`6@{a><`	їDtD}r"`BD0~c  O ``Ogc#2D
Jyg劃O*@bT7`5L#L0."6787E6`@" p߭8  tL` "Je8 }BQ67c`7p6n`/@ Tnpwo`Y$	4 ӣ`@ [w[2	Pu9:
99$":;:p;":;`x!D"p TU565U7u8}u9U5Uw_Eɫ_789cPmPw_pGpQTN0U``PpmP5T Vu6u667@
aW8T6@Y6#`TTd"V`<D E6Tq^s^FC(u2	08u1E">H*9/qr"<%<ÔZ	`Du2xu1QC "	Rp}u31 L}}]M`~ x~ ӝ@3u3L`Ù@;0X Ӝ@`31 S0@cZ?$Ýt#
EI0@QA@':L`3VLx	4`	x`612~BW@L<?0?;`@B@	P3|#O"	w`ڢva$U'NV[tU$	??
(F$	6
?? LxBv7xU}{z?y$I!k_}(0{|/)b{w0:<tиwÀu/'P~  | }` @_^_N/e{tSpbPz~@_!pԲф
@ԠpTN`43otpl	ÔPt}lP١1o`aze`а569:Cݓ@o44=4  j|((s}'}}}}~2~MbM3Tu	{ z y5o6P5F ,w
UI5pv6\<eLpJA4D#-t~5{u5?`u6 	]5T`pd`pQ?
p0
P!F	ڒ4	uLBT}P} pm!b$3kPK ß
Np&t00C餪Ir0'
b78d7 N_8"PnR Üd2/+Vy`{e65l`&I!įr^;);2DP| !5`z {D` @\]L~
`;<<<;;<d!Q!d;
<!
@&2nB0|gC' s
٤[#<;&d3^픜P6<00䥓
8 F FPEP{adoLp{|tP#I(I#<~I_[8mpl ??\,@7qd?NptOLVKUOKK=UNp7>	r^HQՏo`ppNVSYSSni{P/y'P#vZq/i T2Jf(?i)ikkዥm<o=	q>Bs?Mn i4լQ}lIDLT-K098n0Ö,98v4 =|v%4kU>[bƋF{z'y x 456A: PzyS9#Ô8@ 55P05H:590797(@7 c
`66`60>q? 507=C
@$}CSu@AB{?g&00|R"3u4s}@ˣ3Єp{õњ5 Ô|@u55$`Em a *c $0~ 3ɠu5x #ux[34@dEA`T@P*t8u@pj90Pے
PtPo	9TT Np; !U `*:52u5
tu q"[e5`54"u10r`0:TށCǐ}-`ܐ~Oe~hVA `P	 1!"1p@xo0!Ð}Z}÷~' ~& Pu224
t22sP`x13}oKX%ÝROCL5p N U23+`ߐ}t80O2ˌa*aw~0Y@ :3pP>u3op`8
1y
``ӕ2q0211a9xhT`}$2ßP`$8"}`q 
"""Ґ]{tȰt x 0 쐧Q
q%P
9e
08	~STD"LION א~Y Pmp`-͏P Yx33$2>| }d`;"`$;~ $}@P@XP~]3tjP3߀3c"3  ~d3~X;a;Z <Y>PS@~Wtu5<W53~P)5``u4Jp[pA_P~3\	@b
4'~cp~ @3P~_" 0~^{"01745u6$*``0$pB0}pouA~uB]{po5E`e^{c/Y{10o00u@ uA uB40r5"0^
`  g"p	` R^[)"0"iRS` "0B pc!Q!V]tVbt. P`pUZ E.ӟ@
.  e.`P KAptYX{`
Pp."b`[3p0-WxQY[- `"q ̓0p)sP&q)d0y&i`\A`[0/.P[c%-'`-lP-vt@p-06	b"?!$(p  h{a[hP%g2233"$&`
p:~k`oj["oT<f@_O0h%a	O"!i*h-eskjtg`bST^ .T ~Bio`P "h0 M
0`2Shqeo`'j`#jp.pA
 dpR~00x D
 6
Sx:pXP
 DlT;p
" Z~ dNA j׀Ӳ  0d"0Ӏ  "8@`9` 	@
D	Barb~g,PT h9"!Tc@epW 81nXPn"`"a&P0]C
pAb3
Wa@0fAdEA~ @0z {`  opn`dx"8@9uX`,8bPcP d{ Pnp	94g^k9$礍":;I=;3>u?;2nAe;p:lpe=0;E: `vȡ@~+P". $Ȁ
%r%8Wtt8<<Ӕ}@`<@x#q,	<x P,@x@-_<Q 1p?p = 
:;q0`@e>p?`p?;?ABuC;=`F  @BBpABA@;C;;C@	x&T 1"%T~ O:&{4@"`0P"x!To`	?TT793o``]3D"FFp'x!8@5K0P*D 0 Dϐ~m#J4W`1K Ad'0t"u<2CF<:;Ku< `dz I I;;:;:@ 67kx>HM  P@b776ð6P	` 
G~3IVD"¯ DK2Q}*,-U
-- ,- , `d T@| QG>G`xt
T1xT?T2U5TDx!|CD@ p
0g2dpa4:%44+ 4+!@
{5W5cqQp(%|sq
O[c1*OTgU		[etl/` #Aa""	F	 >	@2xpdX LҀƀiq3ꀚڿʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``##sB"P""傿):"P%0F "b``"Τ.` "  )"u/33@p " 3@P"Ø"0	Ý俜0 oar`80"(p p_8@
!	P	tt	1a
b*7q2	1	"wyt 
""̋ߤ,a u  ͨ-8%`,5P`.9<-5 "BBE"""ЃЂP  ts16 s._Ń+ "%0)5bp~ p
s@h`ߡ:!p: :@~:Iv:@n: b:RV:J:e e1:1: p:p:f:pWf:f:a:#s1u 233ł3ł傘@03"  Y -x6`4 73@"3@"u	3@
p<p:0q:;j|:0
<C<"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @          
     MESSB\5m6]}!O:d>_vI,	]								

$
>
G
L
~







I.)
i




&>Tilps{l1L	)Gh
@Uj+@Pn,t#OV 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
h
R	Rorhi7n: (ABO= 'Ctrl +P=t` Del'p08-1"j: @changed2: r)mB* ne@A P+@*3/: Video	Hֿ-4: rrupfPZ5D_i)8]6_an`!expansb D  TurnB!!"ej0fs}!)b<F?1>: Abr
bARrmal820UPZ mu@P#gi!Dqwaa6#+Bk-(Strg+Untbr,QI n%T@Mf owᳫ$oOp6utom0czb4uqhed: os ToW miuX: Kbyt0Vcksumtj,fauP/Jpku`l cpWNext? EfqttibExPfa Ks/ssaPeAcceP'= p F1~0 0 F2 C S I zB Apinue mpuP}s?  MaianceDb
 uyta6.<wirS us Tmodu+mme$+requires'.  $oc.,d. LBPU7MpibOOay1__2_]re`excee !QԱ@5b1`vCirccuue Undpw lndsy..P؂(. 4dobWee.GS ١nI5c5`^ XInrLShut
downi 0 	-a:Pe Y;PINW: [
] \Nb<1%left+ 0H1HB@6 u`Uρo
v^oax00S,ZbpCer@uSлUe@dLPcuҢchipQ+be TEp퍓JovldNew_ Pԁ*upu'< *Warn0/)fTPMoVc{O2	i8xrevpo aaks,STpa Tmr aI5->rmin[r` c&n>
U0_ >: XX hours a ` @sAAf($EpѪm	hk-.t*G uhSq
IfүkGnow#E%,FsAmj0"jcthXìultI `is.2K.!bAe$=4r"Q du`Rt!>TA n ADrZ
5 aff`Hb^a@)0{ak5xPunusKVPzItmsg'com a2
f@a%greplac2mâ aSF2 _dU`qo!B's TrPlatдm!(A)!:be.Bi2(HXe[C 5A?9aA f P;o takйos]k[ 	Pgt	g/ /S OEM Spec`Wc OmEƟb,dx
NOTE: `BBcBrwitch WARNINGirs#@갇2bYRlo c01@0b
O!;pAencrypqbh!yDoso]ghBhV~applĉ^Hy
 from funr п@4RR 
ERROR -BfБr gonePyjtlUaMaPIHx (MSGIDX)        	 OSBC_BM  p ( d }0    C %   O L Ʀ ҭ V s&  ` B ! B Genuine Intel 
 '"B#@ 'B1 \ w  ^  Π @^` Z    @      >"m2#3/V"aJ<!2!-"B#}2#3/
#32#
3z>"3#* `*@  gwb.A2".@ Ϫ ̀#@` # #	
/bf `((  +*# a@ 
!ϠiAmin"2/a!3d! b2oBcON /""aoAE`#Ufgw'vf	dA !D@@ wfUVfvh!$a"! %#`IWeW
U	v  I+",J	A!/d/L* Cu`
fwUn)@&-?>*eU@TfN7`
E0Ud 
_k:$aLJVeE> v y$w@F 
BDio.FF !W.LAU F@.NtED@y_TQWv`EhT@Y@!	hW@VO[/^          @ > !*gEgTbgy !K<bfW(uO
fW.@$W2ϖO* f T
 Uf!_kq ey!!X"V,NgI%X`GysDBO&na"WM,AGi
"cy o0 _6_84 .Y`1Rb4yn1@Z   OPMk!6URl7}mQ@! x@" UOA}aO B; )oug_ ?tK`+>i@i@`.9 Cx 0DoAb`&cakh-	!vo!uXN^O!#] KdA
#	$A	Ȗg("
f._"%		7@ 5n$oo Dh
1oo7=%SB!(o'!ih@3A4 >%
a@/H@Ip&
> D
;O !8 .E .A'b7B_b/aO&A7iɕ'
]aGB8
$7a8d';# ^@`t2`ƥG%c.%
agFN@Cb!"YbR j!˃R!tUEQED	O@: |`
<_Lfj
`$	_agb^"Zg΄pObN Yྂ20dO] WXf{Pn.E$:hind``s[

'!!wat)!"d>aD2b2d!, _ ~TU e A!N\  @ !U
!Bf .  i @6f@  a BF HaV" ,@ s $ {gJy`uأG`Tbpa!@b`g	J` HaςB
 Ta="B @$a\~ Q( # c`m," " 2̀ }!8 "
d@"  8  L	   @	 OSBI_BM8  p ( d }0    C % N . @" ^C ̤ O ۿ ҿ ʳ   `    Genuine Intel 
 \ ̟  `@  ^@ " 2!Z; #3   ,$1T!4Ft  $xCo8 A
+/`OCo  Aw?q`B A@_ O ?b `4D	)A"
TB	aO@!

\b-_OD$
 Uq. @`	'@
]74`A._3#@ / `C:MB
 /Gv"BD  "  A
WD2 4 132%`3.hB": #"
n_`-%eOl & 
`'@*@BARD 
*с!B+4*i - 
-Q?%#aqAT
 ),AX )Ia/ od`& 5/ot/@B :>Co 2  Aq \/ 9"`i@Bc 1gu= ,J%A
!5"=34('d*8WMTPAS o1       aF3HGw\`[`7!*9߇ K2$hA;"gC bDI*\kCh
20 B$6!(1h
`@ 5:b8LC#	UgF@
!EO[aFWB(E'2K$VEBjD[*m I?F0oc""H[a
U[G s#k`T *`;wdEO] M
a a,[4OKaK   2"(0""ak,Ve
 "$aX o2`C@$"ZT  (\[8a [9]K< 	_q>@I U!PgbKRmQd]g  !.OEG d S@$o f
Pc dO&i
 
K O#EІ!Q 2[`  qoU
	aTWv!" @.B_"O)]	 
#	{ !,f;
%		7 (B1n.oo&DAK!3OPL@B! =oC; oWw{ :A/.@qa1 $0 A;9k $B bQ	a` 6K@@.!E$2A@J	h6 Id6!Q?J @aC:E-$!Фa@[HBDJef QwA
` a\Th¶d@ݯo WJBb^OaWx	
aA ӆ H!(CO ص"" 0/0M"[pYaNUDk0d:$avR!$
 qd^
	z Ayo"Ab9r y{$Cbo`!~ae(t'	 J]>O  
	t`&  s
aFؔ pc!3DAH(@e`+BKK@vT u[@wo# w[b2UT` B3ob#+bVA vNT$@ !D`A6b!@@ZA t`$A! A@ˣ
 "(7@ $c
 G   9(!,.@#0F`Q@ $6 H7`%    
   `	 OSBI_BM  p ( d }0  $ C % e | ˯ Ծ ɥ  Ը    s% `    Celeron(R)  \@   ^`  !\ `3Z"!1	4DZ32 Vf?TXDC _UTR*
 NJ@LjUDg;T ew  WwvwtDEkTDodvW    F m 
DO`t?e_`]eG
e
UI@_R`D@ D gwoTU
O 
_	
UU@G!
Ac
@TDFR O@
`xJUIN_aG Uo guk"f B E!DR!o!T@o@
@	F oTDy]Hw#X 8D()U6#MT4D ,h 'eU )!U@.@- xb
F) ') ) o ) V%X 'o b*d '$` D24@!%V b%o%AJ 2.Y0%a. .
 5"d!:8+ >_`>EF#	
DO_` &
GOI
`?ooPabW@Ua   $/CE8a  C6D "A	A@!"$g:WX>,&&';	 DAQ! "u@1  P'"Q!#-VRB)tQ 2fD*	$.F `/$A2A2HWuNVz ave>RZ       | p&UE2F]Hfnyof*h ]hy2xe"lg"4vy2V*z'&awX0z#zX6Jeq|Q:tvv?a2ߪ
` &
:OA&?egNRY
@*"{A(IVa1(A`^!Zo ._O  \Z	"G2Aw j8	
Y!T@\
b@fh@{os
@N$\"(r~"Km,!S:
" `
 ?2	h   # O8i~<r>jb
P`Rb"@""
"/*+'  eK	!z`
/!`x !'A &a
.!a\@ CP-O `
a  3@ u
B@;BA)b!	 5+ lo
	F- #!%oi
6* L-OO C/,0olC{7B/A8Μ@O!9.${`;AG(k >	= 
(6!9/f$Kd$A 78@[%
@?b)!@"<:A2!6A/HIDJ	 6A7b] 	!4DB(& X^1 `hF%
'd Ei\R *8"Q!
` +*"#!hoXdB_[ B^/Wy4
AQx"BwDO" PZe00M@]B U+ee6d:fC;c7D qd'
 z /c#BD	"`y$ |Aua+?O~($b1`}b_y  ̴ "b&]CL! A4d
t.$, a-#CwF*/(Bx U	 y` "~##7 xA!!D` " H`8bF@	<C$CwA	 #)!
 "+!Y!@  W $" `!B``@!(w@BŪ' #,+`	 $0 H$B`%6n@I &  
  g   	 OSBI_BM
  |p (  b0  	  C %  Ǩ ӯ ٹ  Φt F x. ` j ÒU ɜe    O O O  . "#@B@(gb0:$a&6"Ex&u2 .rO.2T,8(`z#O@2x&
	
 V 	$@:"x'w@ga
K2}8 څ <axJ>c%( ˇBrD!D`
!h *O 
 `a  O}A"!B`  	 [
W@)o C@ W`#	@
@@ ,"A!A'`H/&"x'Q`!"@'V"Yooh`9!"@$&!#C#DOM8(4$ ,!A	!$b
"($ 4-DAO>L/,.!0 7854?4 A`6O_R1!/d=$%:_on$$ 8A>da9M T
 7%%FER ='$:* >.GF	. KK A
U?!.:!6:K/>/ 90T@VOJodt`I ZC-`] KK !/*!3!i`f4@UBB WeB7 ]a`eC@g@"Q `H)
jodABa!tVfo/gDN? r8'fcF"KUO$@a&QQ_@z$4XA]"B_%_Aha6&{ hB0`]jn/$U kq mEaly4paGR0 i`uOH*',{>R tA|`}ҢuOT7yr*Zw;@{u` }B}pdz~ $`_rqkyx KWKap:AxB@ubx k4eF`*0O O O       ;     VIDEU0 ! @ 
00IBM VGA Compatible BIOS. [ k y PCIR'    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`g aP b  c dP e  f gP h  io jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT CALISTO d 0  03 _DATA_BLOCK   o`1305Intel(r)Alviso   Accelerated Sa 
Contact joe.david@hp.com
Build Number: 1270 Dev1
12/0 2005
 hCopyright (C) 0-`3 2`rp. All RAs Re?servedPp      $		


	  ! 	TVD "LFPy{8 
    0| 02468:<@BDFHJLPRTVXZ\ i{
  4 (  8 H 00 @   _  @ 2 D Y

 Um w  @m/ ` _  @@D WHL
 0b ]! 1        04 @0
!		0! ?   H `  bѰ_ S . = PP R͢k $ (
 4             !0 R`SI-136;2-Xp@2^5IK .=H I <x <
 2	POZ a-  	     	Q Ia( S V?4<AS  `	  <  _=,H d @A &06*0* Q 0@0p+/xQ&@X%H?@0b2@@E( 6C6L @Qq~@*(    ' e# # , (q!s4) S	(		
	(		
	(
'

1
(_
q

{
(



(

(=O
Y(
(
(-
7(ew
(
(

(C
U
_
(


(

*߀Y @ Y  ' 0h \	 `"` X  1X (sK	 <8# xx Q@bܯ(,|)t @@/-{/c  P _
00 *f  @
%,@`@	b7
)(?<p#~Aqe
%
 P)E
D. $<? 00C27@ pQX/ 82

,+a NU XN ` JUXL o o o o , w * \ ςX0+GB)aUfPfVfWfVtkVfPu.t@uf.fF D  !.D{Fp 
F FPFF0FfX^=OfF  
FFFFZFFf@`w
F'  NnVQRffZYf;F  rufVWRf`ff@
ff1ff^pZffq_f^f !;F}Nn߈^ f~f~`.sf~ t$:V^:nQ:ND~{tPfFtFV?u )  
f~v ø t2:~sPv0v^*ߊfދfV2fX]~"Rf3
 fXfZfXþ   
@c|Ȱ ޾ M`[5  uÃp3 &#0&.!	 
 
f.aPVWo tR 2u/N"t!@>rVf" v ,.L^ 0ff^3_^Ï8@q} t-w 2td3 	\ tf1PSRV<v
W_2&fW`<<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\
		;ufRP1u5 0/f`fZdfVPfa3% `= `Xf^2dfP@@ r pf D!pf ;r;r.T#6f"2p#`HSfQ4tfY-ffXI=-fqQ fYf.; rZ&)[fVe$<uf 0,^ @`H|"-VWf`ak2Q菥/tN5/r Oufߋf%5D0d%sT #2fqfXu
R;Zskfr3b4fu46G4F15 Za_1/t4P812f8"tRJ;Zr.
 @) U$@ B*#"^tu
 `. &|@
fw0|	u q3f$3 $v82x2ydyyyyy%z~^)ͅv;"' ӵ{!0!!`"&`(:):U"a,d"e&"fgT$h"!mUP 0=t.<	0ffX.6Xnހs.< p=Ou
uNa=_ j W,6I=OuFt=Ot=_t
=OtP!IXOuN
 pt ,f]WZ+Ͼs .<t.:u.T1_F`2az   1av5031  0|*RUF|C ^*p q  öP;Q-2 f. u/u
/F t f# 11fн/fP*s&G#5 1WtJ"ee@79 gp
.f
'ڠ 6.6u޸ 48
0S@6[ u	uN 'Vp 
#-#8#c####	($
4$ Ǿ"`( u*u. x0Lr	Eˀ@tc`.uZ
^p;;2ۄtq Й'51Rfr/w*,	 A	`	/+s!r"	rqs
 "t+S
[ot^@z Af!O/r%x׊		Is
m(f"1S,fS,P$8X$@
؉	f`2d(q	dQ	ؾ~$.8wupPh$u]X㊤sUO/oF 1*= p\4/0]    ufhB, / ff''4.,PPQ,H-X,T].^.. #E.@u,K@n@{B{Ay.faPSQmQD@B2;YtlQ
 srYTZCQDtbt
@t@uY*Y d"ut2r$tt	Æf^ZY[z~S w3ɲ ƿt@#w83u &
 ut
 291jRf@  ? 0@Apߊٺ &ӫ.tN Z uf.VPQ\	1rp &.8tYX^r
gf&a ⢊f_C	f`VGsT0
wt#р tSRط=4Z[6O7uOBT)'0bv,iA$Q)B^Xщ)+o)ҟ&tԲW߾q|1]МS.L2큚.Pi
QPQffY
8Xt+YI+.t
P<0SQ;[tje u(r~^u'uB
2tPS#[;Xu)a+tuP
PSߋtIbY$tSQY[r[bd*3QRv`Xu@ك p
T.^tSD[r1r %p(5#22`] 0(@;ׄ !N
Ns 
 `YJO(B&fS  Q} 9*=(PQ]](L<vYX
(r2(P  W'x'"%hvX'	%X%0)&G.&7
 2Aa`df
a諿 t@IQ : 4@3YM`òg~)EXrPu(s#7S RX Wf_V.4.tf^^ ر 33K00 Gss''D/&f%  8ue#u㻐t/rP/ks}9@ CtĴ(Z{-3f
f^	
%&mdQ`D/rtSCcع"dD<(YJ&/"tns ?   "Iu?P$hlQXw
r
SX$w
؊ˣ$3Ҩ@&9
!1  ,1-R---.*.>.M.	.`,p${ us^|$D\өug$u@&'%{%t!xa#?%fSf[R#0%XQ3tX$ ۂ
$$uo  Q.2P;YrWw!ta˾  #fP&f߷0ff-  ff3g&fG_&f^E>1}>&%s4&f$8`%f
@q2 }#0` r`Dw oU	P \.:\s0f\0Z*.$tBuIP R" ^Xu,.80$.t2s{!P 4J4XS%[Ϡjt
 Sz1#*@@
<@f% K2M a%%"$ðs )r;
f^&?E$!o!$ 4#.8
f+442!tg2 A1fPWM
& b$-Y%2J:ZT4%."	2rVPS$? S#$7!Tz<!$tP:u@uEtAA49Q*sfQ(fwu!00`;fYvt @00ً0=+ r
`Q2Srs[Y+8<FHKUrM
rF\s)\.t0 tF0u33L rQ"YbcPPB<vrs	 PfWrZ@1㿏 .!u.Mm2ft!"SQл2Y8[r2QA÷sYf_XSW_L?_[`rFsr?ĊԽ
H
t+8t$P`Պ"X` 8uAHЀ`ʰ84
a߂ `b	+}!`QB#&f ¢IyV(u
 o(s"e,@K!fv> 롊 t~ .ut
ъ!-PD0$X5&ذ32
>J
U^ FVvnB]FPW߶ 3&!Gt8u"XuD>L t=s4dй @E\n tF^nr3vGZn3UX&26VS2.Zn3V8r *[Y22aFX]W.>bnt>Àt&}&t,(-)*.)` RXnÿ<v<t
<vÜȫP03bNb<w<?t0fͅx4es%2&J&P &L&ģ`&-pK L`  aÀ5 
65555
555
6
6
686`,sI!uM@B? 
<w
2¬t0EtH)57Ya3۱R u tF@rtu!WV ^_ 
?GW _u[GG d a `Zj	 Q_IХ@ڃ. (.[Q=Xuπð/؁Y`%@t	p`TFF!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tucPQV2
$̊XFY^Y s0&G
Pp&W&w@
p߀?w tHH,2۰>trvsr&9p,uh 30p?v 

r0_s'
 4G_.>`;Ǽ`;9ëp 0/&$F@f
r	u 	Ǻt@+E  4t<v<tP&X@F2h @&` Pe5tJf &&	7
aTugQc$ϯ<0tqZt2- u "_EpaE1^X qѾ9.8u*fĐs @_t}Uq`xA(  `
s6fGft42q	} t4~ [ $b訬`Q$1t0s=01
VWS t#`IF[_^ rffV 2~ r:<w4&	r*ufy21=S?f[f0VА	s0`t*Q<.LYt  u
d"8u^ZqSQ"*s	.S.쿋[d  Yrߊ̀vXG31Sf #brnŀtʀ tZ<`<rNQvYrJT rEPf;Xr8u $ f.;v"u fрt	] xrs_&fYfл@NRVSӆ6 X t|.<t.9uk.|t.9\u^.| _8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ^e.DYXu "
~?[` ?"RRf
P3f&ffX&e0&} ]r`/eu  / tRsZt	    >t gHKP&Q䰟E Mr f+V`b0m;P 	X~7^[0
 ^94S
B^HQKENP&EK@F K ,``HKqqA&> >  I m  @   	 -` QPQ 1-l#	`@PSPS+׀*   `s >4sPȉt'>&E# u 7K>Sߪ>.97J>r[._}E#[t &fV{GP@|5 >.Fr YS@;[^u;t;Gr;w3O0-?>tFt` u&t/>  - u,߃l6&=	r[s	;v2SSWp| u
Dt2ۉt
 u.\~.G#Ptp[[__[MfE#%Kt&  0&Dt&4BfЋ D&Ft5;v+!QБ\&{âCr AYF߹ q= t0U¿fawo R``Zv
uQrg   cYPVPV<v}`	 rL^sWwR} #fP?X2AL?$_pàs 
J
}fARf^d<w 8PFXft	3f0 
@
fg;w! SSPP@vi.8Az.<uSpZ  Q2<v+<t'ƿ<v!pt~ptR['SwPl@h/f
Q@0X. 
.?&!j Q] PRf!  wД YrVIv0r@fXufn0A
$@VW#sB d @@=&|&\CrwPx
Xu	 Zr0՟
0G^f
f D0   	

#`
Fr=.t5WC@Nu
CC_2.@S6&[X<`r<qwRZP$<P s?S# (S[2ۀvESp%RfߊfZEfP= [PP h".6fB p0Vfqi	sx/@2^ae U#e\sSuNUXrz5u P2ɸ,"ݿy:/]F+?sau\Uص÷ zMي3
x`@!2 > "
X߈rk;~r 
;=<uUӊz% 2MFVP3Q^;< N3
쉻N uWP1PS ^0[HF0Y.26~VWR\pԊr;~s8 ~JuZ_^N to0S[_i
Đ~27702GVz 
  8r@ 诿 9Pi` ߊ&OX6"2P	X PuA0`2RZΐ A拄P?0 ؆! PX_ PC[	ހur
1`a}@ߏ@}@     VHp^PfQs?r
^  rFf@ P@
K	Pf3fAw$'t`f_fXf%p	_
fL4!yEp_mp	t@ۥY^X~IQ1	fP@ǾIf.Vff@1uM^
 quy'ut?^ȱAlPQ  tn$R !
`ʰ
-Su@PQ% 3= u&=  Q݀YXp_u
_Sl`<XQVW_^YS 	sKk;@`@\*@ й   3wP, -2 Q	faVfW^W &  &E _^VS3۬
t
<a|<zw_$C ^3}V   2 s @"APP2 jFѐ:u.T3lV .^f.<Inteu   	  
 	 pPRaPa C` PB B_A B;rXatSR3Z[n.L@u"Sbx$ؠt  [.LE6r+f0rZ *  427f;q12mPwPf03x!f.80
+؀fy04u	fSff"ܰu@s W 0|}p.>M M^<1D.M0Rf6 10.df 
00.D +PR.>ff.!` pM .FFMȋF 
tJHa ρ FACFAa '俀Xð
r؀.E_Z.V`.
  4sbSA#ѐ$<1=P<uX.>_JNt  p9.JNs< RH@pR۾1BRATs3Z4kbdRzMtt
r	? r212R؀t⪀`.ȃ v(.жuc.<s.t0FjYf u.t-.5߀ut."\1
ǀfQ̀7vY   LY,_R,QPSP`X@K~0ct	bf'/R M6 @P4LC#t4ϹQJ uUw< UlU[ n X+	3-Yqءs
K
roRR
RZR@  $ bPBBCZQ
Q QQcfƊ$f`@fffX#t
p tfZYQ Q `  ?	Qqt= f
 tPP_S <Q<"4
P`aU$_$`` w GS S2 ihQ"$V$< Q IYɜu(uA ؠ`2  %Y^;}YqqSQRm 3ɱmtZS
S` 
  Rf  
u n P P0@#ftsrg{ AUZ_&"9R?(`1(LaPS9""
[Xb*Ch$)((ff>Q`IQ]`  `Iq-
'fS--`Pـ7P(t0yۑ-2e/ffȋ1#ff#f`	XsfA0@5@50/RA/u fP0/fXPӋ#ك#[uX6 &`E               [Qr|Pr;wKH7V &;v7ċZ++񑋷drd&Zf+0nwf 蘱0OU`F Ru F . QFQ	.8\uO.T;u
.u#u	Ff(	 ff"u
Ff!
uC✾E.  Dr
t !ĸ fV.4.tf^ Fݾf9cBa@Of^a]W s(PИ
P }2f^@=Чwp_ SRV	<\r5t(tP.\.DQ" YXsÀtڀ^fPWUю f{s" ~ f&;u Eu&M]p _fZ`rA@;r1;r-fQ&
 =p;fYua0Q 	^&	s(	'	3Z[R.6T.8u.| u
0.;6TrӡAVWrEDtfr
*tfk 
f^&M
 _V3t u2
^PuWVIr&&f^u1@uu P^_X@0k`Q QY .8u΋t2Yf$ADDfu
fIN30 (>
Et_qxu~r&蔡a4/f^6r P$/?<t<Irf&E   ೼ar$<<<f RVr
O.| ^О^`Ȏ&P " ta.\f^tA@
sCV! ^P;Xu%&}0!R&E  D BGr.TQGT
aA (
  RӊP` qX Zu4totjkts^_-sRSps+[7P-u#w` cЌWf_лO^u71m ɣP@8Ud0`.
 DBt0A\/fXu:.t5.
,u-P.D Xu!!NNr.
,.tU5]N<q@ˁ'WDAR9  O S]P%;ϋ%;7PV="Wa)u͈?TWf;<f<`rUwP2R#u< @yxH=C D?4ZXv!"d_p_.|PpXt	1t8ʳo q /d %!4op%pM  A= p`0jmyr+QBt"s	cu
< u	f3Ј[uP[pt4)?8ߑ@fZpQS2HD[#? rQ-Ys
 W1sf`DR.P^Z1{r$qC >0Rr. u'*"Xt"`ZzaefuvVW[UjBQ Y s
 rٰ6.&;
QYs" tm_ \t_t	}pf tF$3f`0s%_suHf# 30Q@2MsuK?HKPsZRZ;v 3`tN P```` t-wǾ` rpÀ  !vsTsVwf~s
(s<@ t@ffRZXQ;v
t
 C
 
h( pu1@_ Z àQJu0CA#wWR ZsNpn .:@u0.> u("J?  YZ}{rbQNs6W-# $NbwBY pa @;"Z0".q	fvf Z@Z1
  VQR3ɀ mYsKw01Ў +fP aêNuPluO!
Pf{_@1SA/H r	3Z3
 Q ,Qt*vq1!Yp <Wf'vf¿QZq-rsGvEBY3fW '%+'fR+fZqCt fNu&tGNu#3"_q``a pZuCt Q2YQ͐ Y_ 	 tus#c dbJ u!(5ҕG16ȡ  	

pV@orwf1@ud ._^PPPPPPPP P!P$P%P(P)P,P-PS wf3d0 ft3 B*&Z.qYb *PQRR?/ t& % u#2Z0(S\[Z"Q`t;i2x2(%p7  1 4E@V;p 7
t-1P.ttPUtA^` O PQ?W$<uvzZf^jRfZНtuU  u sEjtz _s3 @	<wPXs uf
V ^ !u*B9*
t5$0 oPSQ2c m %   Pw!rPSn2۾q F# !Pz S#;tt\7`Ruu OҖR`	7 t#Ju-* &t
& df0)A4%f"0~*h=hZhqhzhhhAsþ h<ðFF3F v0). iYA;sC2k1*<P+KrR l5@>B à032^@a hisiiiij7j
h2D<vP4Sվ[t5f{E 6@6f^@-t,o
<}οa;߀ǁ  ,2s2u xI s   þ/.p ?ȉN!lC]V(fS$o c Tސf ;~f t7fU<m)!\ff4AJf% ; F  aw<s	4ӣC Dt(K2Zb$K.蜱Z!ZߚBYQ-00
Ű jjk0kjњ@ Wf_fVBE/fFPpA@C3r0f« f ff+À f
f  	4!f#$01p8u2uAL4 kkr 6SEн5
Z_<_u
pr7`( !/ - [ଶuRSP?:g[Zfk2q۷f \Y3ɶ];u;F p(ذ 5m삸@ ^V@te@Tl. jXRV.tuB	}r^Z`19 t4W_s)v!f&= u }  u &G
S`a`S[sc UڷKZ[sMrHDt
 u6!Պ 1&!_l Zs	r03ҋʾ@ r`1ÁmmmFP6
paBw S.oQm[ 7T~At@߿耻r$?g r jH8
r#) ^X_l$XV8t\ٰ0yMz	0ztwAfP;broQ< t  >>3aAePMID x    2Intel(r) 82945GM Chipset Family Graphics Accelerated VGA BIOS 2 Corpoion#__Control0 Hardware VersP 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq 	ppYrrrrrlsqt	taxWmjhmko.<t.:u.TtOFE2&+]pUOuUWUESAU !dnf&ofPr0@Qv4v0?t/AW@w,ot2o s8 t>oDofYfY_uV f&E-  ߃A^ðC[Q 4\@Ύ޾oJ  dn rmuVO$K`шe  uڵ ,Ad@ @@dp dw¯PЫ p puЊwwfơXـrf
t rl@@ uf
  f2tmQRf0n~<3ZY 
ρ
ϊYu9rf
s,rRvFPSWĿ_[XF$:Iu6r	 @ 0vt
"u%uj^# ͰLr
VÀ>IvmwdtYw@t$ ;wR?$;v@f1yٺ t@АØsssst$tFtR p p ^s.$wfbt*R@	ZP	8Xf |pm


@F wf f` ta fI BGtѝ a* $a+Sb6̀tE#>tw1g& ~ft  )vGwAºBf_fP S WBBL쐫T 
RVI3΋萯׺ P!0 v-8 t3
^P%s_ZX27QfBQ_PfqU fYRDIRI]:T@:TuZP=ۊ̃X&ETE
ff'
 f@.; fʶ Aڰ t &H_HKV^}0^踲B]H
ea^Kz^f
|Y&E@(@R` c`-
~HK	02Й.XnȊ	ـ8u$?
32IHڨu	0Ir
v.
 @$
cAVH.?|^!77uf^oPP%iXv.t"{'{.D@t  }V߂^r
 
2^û< <#t2 <"t
+ <!t  ЫUP=.<	fp{X0u7
u.Ȁ
ufP{q;psnS׋иO O }Of]Yˀ u3faw*pMf3fr-uGE0/T0`uu t kudu^sY8s
tQG8s8s8t3 t-v&8swˊ
r*ˋc
P8bu J NذrPÆ2ۋ!iR
tBi1P`!2$b&LNذH<v<v	r	e狕P鐡 F ^cvr{otw%pvk&J`֋&OtʋsBuՃ%r' wPu;u$0<0 t**F Ɗ
t*02P [š	a>`@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQW_YupD0^ 	2@
2@PP *ڿ n@
  toʋXZQ2ܑ	/ ++(+t؋X  + 
"a݁Bt}G:#sNOFGuxs?OG$	B y*2䠃10>Ku , !+'k'ȋP&$1u'`'$4$鎠&  %2C3 B"pCR S ؎@
u0ȑ'Jur&^=ց3Ju=>?wP67):4&	55Fb1G!Z6c5 XqJrv
t-rȏ <G!M`sw r
XtӭנQqQ0QP2GpѽB2E tO FƮS ƯPЎ، 0u.2&>| _t
ϿÒ$.c-0@ȱ\,ppRC&PD+(2֋6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q0 wLwPaz x`֋Y$Wr!v$$Āu　?600Ql$$s$guzoѫ3*8*0*^OFH,G}`/$EѰ /Ë?*a)p2
y$6| 62u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
̃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T @fR@
 F$
 Sr7u̊ PW.bnu>&}JpbQǪ_XwL4/r#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w
p$!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$t<
tG<P<u(  2 y yb_2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [蛀D0rp^ʊ3ɸa0
uVЊdЊPSQRaPaD=X_aZY[X|*v脼s
ĀՈF0F02A?	HbgՇ܇<s<trt`ti0ù 2ۋ&<F 4w t3&ee!3<
EQ.~T  @@5 ÊP&0y LOuʷËÀ8 0_
1>ǀh  fnNË[Ċ嫊Nuúq 2Fó π?} Q {.` KNu"f&K͉DSRP$?.&RP   [[c   XʊZ[PȊXHPXP) ~~~~l|8 8| <<<80    <fBBf< Ù}x<fff<~

x rT88T  >w>`ZZpff f { "8DD8p
~%~~  Q  	 0``0A}$BB$@
V` l}$Q  ll  l ||f6j 8L8xz 0 0```0 @  <w<f00'0  || 8x~ |p <| <l |Mƀ |  ~H  a0!2  
x | ff|ff    bhxhb `}~ @< p flxlf bf  ΀|`|j|~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lv 8 1̀b BP7ܢ-|u p| v\ | q$4-4 lrl3
6|@[0d (s1B 00 # v܄?&qp|+8̅4
|!f!&88 `x`:|~~ ~΀)".
a0%||~`l``p9B~ ?p

6mff+ 8<448ll8 60` BU6F \E1S6ll6W` l  "# U# GwA 4T d J 6 P [ 5 NOqP_;U1@UQ2d770?d?0aa66R9 ja	
 R>     tv QƟ@bC8~llHO3O rg8 s 8||`qTXl( <"CBfa||=DPh4"  l~`l~ Y%r[& Qp0joG<8p(5ly}Xlq<p&Pl~0QEP< cSld$DtUtZZNTvTuW32xQ2)
{xpbn|ll|}220 a4֕BP{ |`Sl8>70k  B sV &
Rg#Zs8|||8x;ff""0AR	+p+q`llҒLMv܃o d $ 5)/ԑ#|1DVs r  Pb
1up bᔳ2ES6 7
 ц%25R$F9B@S9byA1  	Q$(f P C='# 7%7 @Pa"D"%
tÝ
0l`6$6~~$E47㠃#
l|8@s\3OƆpb#-<,00PcRr-Lu;T3'$D bZЦ `e 1d23] %`aB=`_ְr;b95Qp$R"ëBfӬ3*Pw~Ry Apotmeۯk5ܓOh0xpӰ`0HH0i ! Ѕah tC[D0 0AxxAcl>j%Uڨ	%SQ#x FΤW1hPr!`xC0q C'7!1 ^H(F/`1L!<0[	<\Qj0FespfS_dx0`> lܬ>ҚdwưD) ew ) )üut  (Yǳ x7ȥ WU>ɈT  4˳^S ds͢Ͳ 5Uc	 &
JTӄK$ %҇Kӧikso̓@"bR``0`&"b ct"1 آ1vetn v ||-@<`p` v3 9tt !Kpܶܵ *$1R3C.o0`
7| /  %4FU} '27Whu -7t u #8]@/䳔TJ}8&00 %7]i4&4E b6‸ <B eaְ "8Fdv D%Eu\f RU閝\ 
5cхե΀&C`et %EWu  %Em  'D~+ NWB^]Ë 
 1 
M et4G =&tDf tt0
" $d#$% e23401hK"r5BVgv 	!"f,`G 'awD 	8Fif .G@eEt8Bm`lx - Mo
/ on	/ Oi. Mm+ Ok/Imtܠk$5Fpctq =FTfv||6 <]}RRfy ѯU<ر p>| oaήԮ 	' 6!P"#$0v?Ë5&) ð薤 	!S P 豃  1 0 a.2&6| &>~ 
*r
t	2.Mò`_     맑! w<
u&| ϲ 2.^FFF3ҹ `Pw߸q` e _Y X  * : aQYSظ s2t  [ø 
>ct/    ^^ >Isu
^ t 36ȢJ2 Lc&̀>Iu	B$P
	JX̀v`
p uHtQ @ rw
2F.hÊ.̀N$F $FF.q(  /ID^Ysn<w$u 4$
ձp À0&&߀_+Q	_@Z<w?1A tS?ݡ[
!&{Rq<w#@tÂ u5Bcb? ȫFt^#!)#
 `08 u{ 3ҴugĠtb(u].-ŴQYR  
 8 t$8u
(
=
28u2ɋZ aR23Z%t<vÊ>bSu
㋗PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=ƇP [
kZV k{^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tu~r ͉N`u6s%&2Ft0 u*ш})~s&:s2& # E  a  {   ? t"<(õ* II `ga!īI<v=	..߯tI<tE2<t?<r<v7<	r
<v/<v)W  WuCt	t`2ۊêSP胚@X[$t   ^ъ$`Ip
P4
Ī3RQ$2.bnuZ&G&G_t  
 &_ët%
&;G 
 2     @    fPQVJ fVf.Da 4f^^YfX< o!!1~4f3nFFfPfSL臙fa#fxff f g{f% ;u@[`PSQRQmଊYZY[Q Y/@Ybf^fp/Pf..7CCRRt!Q̀YZÿ謙7t&pt&wG  x  u  b螡2
3f n.VQ3&&Ϭ&I1f P tQ | fYÀVFF30^XtJQF	 DYPRfW0f "! д P ˼ f3A  s P `g[  O&u 8y>s!pCF鼹*  7A	]  
  $ w=	E
 G0!3
y1

f{[X f_Z@* @QVVv^~B*&5誘&&&^ &T@0RV0&$rF@&F~跖  PX@F2m q5`^ZRDPNZ !u$uhY7V蟕ĊNu^>8[pP8R裕f<ZÐ5QfVQ7{f^Yb6`6 5ñi Ñ35?45}745\ %}d5ce56d5]QRrd3333ʁ333p3RV@3B3۽@3^Z2#2YØ    8 4 0 < !! !!!!pQ!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @`               pƔ!!!!!! !!  ?   #awqyy>V>>8I >, > >'"A> >> >;>ǲ>>0y>9>B>0>@> >>t>
v>jcf>M>O>C>?8?/?SQ쪁"2Št$J߀.~0$`Pd  : *Ī!B2WcP脔CP@P o@ PV1E"ݑX# M^ 
A?jp3  -i	P	X^GB.u=0s賋ñu6DxPt' opYy t	`mPx N ð  t%u7w0f^{f _ Sx[ p[ 	 $ADDIN30&.Of(M{AIM3bpmA  @ X@ Intel Corp. LVDS04Tp`Qf`5fPi..p.W rS..
 fft[
0jfw.>! v `P;b 0jfX 2ZY`2v p>bu .;pw.;rv
RWfVvTtOBf.G0I u"Iu0R 5s}ZR5Zr
`
f^_fZ fV$< v79ffb #*}t ;s1 I Ufq_S@i#3LfVᡥ2k[S o@t 3ɐRWlt
_ZP.o$ Wc4J0_ `8$<u<.\.!r   PPjXfTAf`1 fa`@.&=
U8s....@  "TO  5E]O P6yf.d..\fS.f.f0 f[ttr= rw rL<&]ff	\..FG@0	3@  .GAu.h a {fVf.t2.~f1uP@"d H0ZǏf^p\[a"4fu`ˀq6P	 ͫ!G4ҳ5fZ0
FKSy-`̢̧̝̾F	V  Ǒ F
FSDTY@ " HD|   I 	  
@  $ 6 d_   IL  LB 	 @ , "	UJz ,,UW[ 00?


s` Y,,6Md@X[l 
 
PА` q@Q@kQ] v lC q \ l @AEq@k6
-2-3 A  ``  3 dj 
=z 
u< FL _"Z  L  "V 

 ?}E S   
E 
y 
O: 

SZ  MnE(  02<@(@(<2`3 = < @3w`= @<`߀3=0; 3 ;1 0 4 >`; `4@> ;4݀ :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?90ޠ6`? 90@06 (8  7 (`8@7   `07?7`|
`;`*  ; `0 :@  0`<p*@*:``/0<P   =* *9 0=p    
>* *8 1 )  @? 7@1`?*)   2 )6@2*)  `2@( 5  3``)@ @3@)43(* )4  4?(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?XO(`$@#a6@-@6-6 -,5,7@-,@ 7-@,4-8 .+@ 8 .+ @9@.@+3:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? ]/`61 1)/)1  `p< < + + 0* `"ê0*  1X (& @A &06DPp  t f%Ѥf= u?XСPR@U^fu}= w
}w6fqWPЗA3tf
@@@$	eX*rQYmRx_fYW<t< _t
!cqRC"_T2. t.wf`7?01f&萇PصסrWRZ_1Sr3!f%2xS4tt@f
!afq /"`2f@2 t&2!@[t f?Xf^襆q 
f蕆Ҏ[dtWeuVfvPVfD .8ttFf ^Xq=v= vRpe fP`
ޢޠ')F>s-uBǒ*2" <  `0+ S[ ra
j  ! R b r "2B !Rz} rU[  R g 
BWq  6%*
vV{
 &
 #b 6%*
  # @  #  ƾ!"&  $ Wظ z  e Vf z  dtWW`ƿ t@~!u-f.|  Wē_ۃ,PI4о`ﻠι0" t t	uλ`S8pB u	[X󭿋جP0Q @fpQȃG @w^ u4163詃^ع 0}`T ^V PUfRP3r 考XQI/ UlfZ]ρ8t.L	n?.O(C; Sa^>];f aa{fJ`Hta"DZҳҋӑ~  ձW  f  g OOGoration Generic Device 12 A is0}BTo@0f^t$( 'rX
@ϐSlp
t߿lQW&]zrfS4~+f[r$
jY0`  @  8WPX6
 PSf NffYf t2QtY[Z? PwaWvdy@aw{wuLff0^
Z[ZQVҹ.t.9Tr.9\r	^Y 8	t&;Ew-&;]w'PP
Yr;rp pQ s&}u,p Au% uZ !$F&}&Mw[X		t
e v$ &E
t&E&E&]QW  _Y Gf΄fZrV詊t

u:
;
T	PUg$XӉ7q~_^`"
 uȊȰfuu ,	$1<ppX Qi	rH&
5`E@*R	
t׃.\τ*|~}fX~~pE0B  ()bc./1 204 7 8 :; !  ot	B [ Nչ bչ { Tf2QRӹ0 r8r¹2 rqZY [pOR18uDt @fS? rt`Pу .6TWu.| u
!.;6Tr.D;u#ru)~a  1fS[pr
2	wUg -IPSQWߗCt#07rmt	t5SF#[ [_ QVfS4ft 'PSsE= s
 "2BRbr#3CcsdtWWUzV  #u	 
 fftF.afSVй-)F3lFffsf@  ff^P.u	4ryqff `-./^sPfP*fXꊝsf-OQ}Ktyr{s0 <̊耫"uX|`f31%*r`f\ 7 r   vr\`NN &]w tR@   @   p f&	UaaPff3ɕT42<	t#<tU<tQ<"tq<P g<o<<<@tɿ    Bf 1!7vpP
t
lG
@@t^@@"fr  ߱   9 P f@ t3Ts1 D&U&g]#QxXa՟4Vx	EW`r? pr1 r& Z_K!o~pr2JX!#@.&Uos
H..&EVW03tNTOp"`EOu4W^VW6QH __^|&=@ ǼP'Ja_.E.]&{fR8f.U .r.&.$?.|^pA谀| .$ s-~ 2Ɋ
.;v.
fr@D}ڐBp$   f/6rYǾѽP6  rCGt~ r3.8	w
	8 r.G.!.
4 7^3cc tEDMw Q!bY&#E_r00!ffڹ)rKQqSgS}1
S  Qw P eGP ?uqzkj Xlp X&]_X R6{.π|t   &E @`lbQ.SӋ[rP@XfֱYޔfP' R~t` uuZYЍpPX< tPm~ z [pl 3RS[rYirO1rFd	r;Q1TmYu)΀t"tt
rfP?ffXSQ t&` u7пr  tt@kr
a`POzr|.:uX  J~3t<`.D fK0pf@wsXp u0G  ( t;(88tLer=6'a Qc|Rt#b
  lcf1S esP}]Z1rRrJ23!r45tt_dsAZq0iYPY]YMY \ >!Rl ]>r@nE]o,SfR	㖞f01
rwfPq 
RrB߀tu f@d%@dp,@bmr!tPet<u #3ZfY_t
!0[# ڹsҸ! 
 sr<RSڃ.[ZxcsPR$U4
?ZXpb1u1٪u1u40َ$qπqπ]pP xq8 ys^wYf(ofu rER.>f!P]rf;u,s
2~Er w s!3rfFߴ ô6{`y  Qu>I@UX]@G*j6TT`~ U}$? GH z  R US @    (<PVd
t?! .x8ty2
t[t	
N.ߚ
t5ffWSTGOq@5/qX@Jp\@Total time for VGA POST:   Seconds 0.000 
 initialization < 10 Milli 
 `fUDmff.<@q.>Eoi.08|Du `Y_)T 11
3fI i0JDf]aPSVMC% t9ȋt,.@
.8tFF.L2t黀Vs^	
>
2.䢊 :
es4Jew4<
|es t$f#o53
Qes>P. u
 tX2pDtbB2퐐A}"
2Dr`3fe.>,uye2 6pt$.pc
fM:0Mef.If.+Ef% pHgegeve`R
&t 芁^QW¨	fπff.>6_s
h
hh 5  0@f`R4kpAgf.8A`teea
`+Uffp@f MmvgI8ŁP<eQwf+Xf-lfowffI sQ% kfKYP.
]Xú#c&π `	 2!ĊRZ$`
s$.LA 26	tA
t*. 	23.  . úUeUuk/&
8.2 e* @    Y  | Pëm                                                                                                                                                                                                                                                                                                                                                                                         < F    t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@byA      %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VW@Vσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀hV$Pwh3 X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{Ynus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &-&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " hg.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ B읜[ hbh:I:  g  P O O 	   hr@῀g h6~BȎ؎zЍeڋwh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` bi j b [cQ  0  a 6  y q6  0J0hp `aϋ;@;Wff . ip
 EϊfQff
fр aVWϤB,S@*(W赢s;_t[s)`)F['_^aWf` f wsu߀p7fffGfY܂ho S1Xfߊ$
)ffw  ~A	S22+{?Qr'!% uf 8s?ҊʠXQ<RP
t0_r#YPY  uf auTf|UPfPfXZ+ ]f0*ff]rffm`f#n {= sMrscB
Cgb߸_ 1f^ ɉw @tr;x >*f@Jkw  ؁C)ѓۿu6ѪȢ+f;q%Nf fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL {^[YrfqXftA3PX}QM} N O蛂PRA` X=PiWU豐_jPԀʡ &AFеW 謱 ]eXÀ-pϋw_P^Z`Wᐋ f} mp_p0                                                                           )D!24#<AC  @@ D
 uj@ t%v v t ArMv . sN-f-υ&A F'N- aύ6`  @Ye3!
tr 	
F (| r
f	u^'Ât %0	k1*50}36r0/5jr,r[
u< r<0s<"N@`  \

u' 
$nvf<0r
ݠsus>Ob.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r20<ss6< s
	OtE""Lt*$Ot"#Ot7%"`!)A
 ؀	.E?F2	
r]ss1I9  <$u2 *<#"< u<@v{<%p!2  Uu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'U&]<rQ[P@ [ osSQtP^Ë^6bmAؠri	DEt v~(LuWMs}Pfߋ} fXr4>bUÍb.p.GTώǿ^ [+.s/LV#:Ttt<~'t9r0#EE&b<DD@ % 5s ~$~@6b 6u0&Mf.bf&]f&}20
࿋`'QVo  B@ n1F tk "aorxtn/+rTO u&~ (u	RmZ<VƎދRoZ^'pqtfR mZnr ŒLr Ynr)8r$gnr"nr
nrxnPp
u  r@!w
u 0!RWBt:ـ?f.Ef߷ffAUffsϱ /GMF F
tSuNfQPĈVbf.WP*f8f'w*f'F'*2t*܊f
VvfVv5PߊFsQU n E]YRP+XtUW:>p_]s=r  "qPRp2BŻ`  1RPюً `jR`0B 0[@( S^l~V :{Pk|觀 5)0 Z^N}lrttRnZlr`a r[sz">biK0jc, V5<s-bO8L<
t" >bߊG< T#w<T$@ N hIb
PX kk   x` `7krzHP{Nkrh!uPpph&RZع^u kr.Ǵt%ttt t	tM% sujrYk	 2P`R^ZrF sH<t<)t<(u;ё>A u/WU>4 #n]_3jr0jC~`,^a*N(PSR 2ZPfFtN+@.;B"Xq;G	F
+#NMM
%J JF
t
R1'WXfS~ t=y~^f~^^~;^~FF
!CFFF  f[fQ
tW 8vNH؈^~nNfnNfˈNnfNn"~*Ċ^
^IfYSQ0PfPv j 8rC"sfZRfXfP.Ff@HFᦈVvP 耱fXr+t@UT3Kp' tff   `Wf+ MYÀLuu$ fr2bt
.ub^K fF! PXpH t<"u<"trV3޾x 4|Q&?s@2  s& p  &ǯG` ` G `  0&O &OfR ef&G ee  A@Wf ag  WUf- _yX 9PVQVW!:W јtNAu~!u .Qw6 u/ ?`O	
 t,6@QoAOGA&&d&D&t&ƟDc<_^YXVy=} w" uRPb
 j ^{   @pG>TPQd[ٰRP  PZpn 䎻<
qCQRs귄3ɺ0[?^p./ 
X `O./ PafV`f  
u 	r [r" s`) @~6	Aaf^U`@*2$ԉNT@׎Ǎ~WF$
&FG &U_Ќ
	 a~W   t2_R `gˀ$0Z`  9`YWYUN
NNOపNz	 @RX$
X"pWXX\PX@@o  IV`غfD   T 쨀t333ۺI u؟F;D ݀u	6!( !v!u!>![!		

	nS$ [øн2r$<25R  4d פp0ff#f' \
Xf05f.4 tff `                                                x  0ؾ  >f#&s  aM6@#a Áf0eRV{SFf3fSjS"fV$
Ѐ
tf@W`DST/S"TSVqfVR׺G%0^ffW LQfPWfVf<0f f'`f^f_f
,  P _
 P Q 0 ,Q   	
,p   _
T 
ڡ   # 
@p 
mP P  0 ;@# 
F
g&*`t3)Na8:pn$5  @
r	 	t0
4r	  @      T u uޠ   1w	^	TU0 Р v0R~  pZt	<p

P
s

 
	
$AB{ @Qz

B"@ 	#"  x  >$ C  D`B&*追aP/u&>*tXRs"R  Zt  ZRu _ Z~ Z艡rYPǰ}NP$u XWP$ K  u!! Xzf`00f   tfeap-\f p= 1   Rg&  
 g& g&GPg&G-P a#  >GpWfQ4gf&	mP E`   $C=f| f ? C_%'!PR-M$MR

Rf`1`M@t } 5iT  = sP P SQa2kY[$
wȐc賚PFf 
tN8tSeFt f% f @PY t0  9t"   t  t	x fX
RV)s Z!
mJ
8
0
$g4  tNff`4eA fu4fafFD f`P2f`* tfFP ^DP s fu
fWvf{0j3#"fF$F(F,Q&0  f3srB޳rf-Ofv,v0hfN,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3с1	![ xN x_fր  pfYf#f#f1~N0 fHfVPf#f@f+¿f;FLvLfFPf)FL%	ff{0ivAfI ) aBwf*̐+6fAN
Xf%	G-fA d!`
;Vt
fAP
Q
ĳ6" O  f%P" a? @" "F'F r0QF) p2F@3 p=f?f#o0K@EVPQRWSӶt"0 &
{_[_ZS`Iw[  躁 0 ߀@HO .kb Ӹa^6u
 @P@Üu8 W  <PQS GT<Z VQ0p ߧW%!ahT! P<11Nt)br(SF<`T F8FWV8.GF< u^_q^R׺s~HrD.\RǊAZHZ1R Ȋ̱CH0QRR ZR  ?ZYol|R밇8AS؀u
RRp	[OP sXE%
cE%	X< $ZT
 
$
t`7VWU_wZwU
uQ6rEt> r2
tC rͲ  r  P 
2!    _^a>2
u[GrVei1sCr"trS ';Wr6"Qr
Er ȝ)ie  
 ` E RK\	\*P')0\;#$ rIW("  kV_!P(B O55B< t[@r}4;3r!-q ,-BF3ɰDiD@DXRʠDGCADF8K8l8}87D 7 8 80 8P 9 9a w9& @ 9 9	 9* : $:Q u@  : @ ;
 ;G U@ ; ;    	0  Hewlett-Packard 68YHV Ver. F.05 07/28/2006@\: }  Z  l~103C_5336AN  ~ a	rKBCsion XX.XX  
 
  _ /	`A#  @  A #U10 Intel(R) { rnal L1 Cachea bi2e	
  6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7B 7C} `+ 
  q 
c
 DIMM #q1?Xb2h!,
0~-"R/ 9@E0"[1 /No bautyW$"8
(_:@$W(= _T*u	 E 
yjt)Ӏut&  5& A)u&u#
u! À8W@} AUU RtY pv;MuG	0bu< u3uOnQtru1_ ta0> S:u@!8*6R:EFu E0P} ~QtTt̀t߀EtL71ƠF -t)> t":& tSuEP$<X?3`Cpt	 tE>I@q u	PXuP3 t? X랓t#%yEQ u]tCWt0c)	'r!q=E31  +x3;r.Dv+W+Xu432c*u!.ð-# s*q!	 2<Gr<Svƀ Ê,G&v{.#$]3v%J u3%
<.r "Lu2C4 %.n2K#0av66rP)<.t<+u
0 uθN<- " uJ,0r& 
56 ;6 e11Ü   C8BBaaƾa$a@0UFfFɷ͋N
~fE F Nu3 'ȷn ]
 cRQP~XÊܹ /FFYNZ1A`Qȴ+Y`Њ  aÇ鋿ً |@"ԃ @ & GA.&?'@'d Z
  c Z` 
G XYZð
Ӱ
7 2 r  `؋  ~P 9   #!
p 	`[臸a@ ؀ `
Uп؎ ]_a	p]3@
AF 1`P C0[o@ˊq$9@`߸ Mu 3 0   fa3S ϻ0YY VQ3AAY^` 
aËf3RQ3ff tff3fRAыf;v+R'TYX0GYf`ffWgfǃ#Eg ^pܺA0vT2gf鰌ogƃ!g u	f@w1  f@f@f_gf1 gffgf_0	a	fQ@;gg&fGfXf7;wf+fṰ f7gggfb	f #fgf&fa\
t@@P	u3
x
ff0
gf3  P
@r@
A
@  gfo3fS̓ Űwff#b ffyZ?'wf3f30n,;wfPf#4߼bf[gf} ӄp2
?ffP	c	i

OfAAXAP
 #W!fكs  +SfVQp g46fFCgYQ  Y`@.f^\ g&GCffT~[(fVfWfSfQfR
2fZfYf[f_f^b@R
uZcf;tf`Ȁ us?*1p t-r(@G<u upt 覈faUQ	UdF @ E] S<t
<t 貪`Y]p40wPWafv2q ^~r^RZYXɓz1jWr2@H	{ ߨt0  t	  ߳iR9`Kw薇r=s +T@H"#@?3F! `80,Nff3u
~0L t"P!" aXg 諫OfF ""Xt$m@Tffۋ@U^c&Q5fPQXLYр)Ya'у{^Ũu8	跨f<tY< u#f!"qtyfaHP]SIMPLOMOTOROLARVP<nV{S@ ~P
HZn0;߸  XPs˻+"1 >;s>;膐 ;﷡} ;t;k@;bsSR &t3-&Z[>;A!;﷟8&;W- &0<x
@`+؋Òc#;r>(; *;﷧ ,;.;@A;r&3&M<St<Mto6I 6 
6^V mOwq!~/*UZ4p\+ 
U^"
` bdrұdfq>hqQm*@mhTj`oUqsUu|KsqA+ 
r)>U;&~
X` 1 a   x P  X@ Y h i j@klm n@o  @ @	 
@
 @p              /S M HffxN0.Nf.NXø 8W31t b<f0๸}Lf1PdfRVWMM OutM`NӎP2@fu_^XQuN@+ FYQf.~0FYÒ 
Lf.LF	ff tf:2fuQǃ06P8 S0ps+Bi &gy  pa
fN@  ]ϰ撧2ðq  S\8&0&G &G&GP    [ !@   栊@@\&\p ~F0 ]
q..O3 и( и   2P
C@@ XWP<w3tݠ*p O $ ! & X _S)@Pޠ Y)X2@)$3F1    ЫR ۳4! fׁu!fQFfYg	[.<3]Ou r 2)fPS=Au@u;Áp u39 u+ f?wufP@u  /Xu
_ffP諭< t裭cN%{AQ{ND|S{_R{@Q  P{{P O{!q ߪ{P %{Wp{UQ   A DDRW*׿Oз\r 2 «3_Z[Q,@@(s Y r3xdn!RQWSP b	$uׁ׀X QרtiPֱw a20>bsXϴ SQ2<	u輪X/2 V_  R9mZ #
!
0PDC[_YZÃU2<UujITYJְB|֊Bv֋Bp j֊Bd ^Iarw!U;Pp
Q@"
g 
"X"S@
u	趋0b ت *êb`[XVWQP Dt!WQ:t
Tu8v
Y_߃&Y_XY_^03ɍ6a.L?.:Ls&3ۿ.Dp.L^` 2`r2@ 2~}Pm u Kw3^t
3t t
t
u!`$3ұ u !5 t>b.} .b u} P JuL   u3p߀uv`bW_tURQRUK2YZ6	u>^
 .D 4+ t#VKڢLG^~ 
6.L7 ]ÅQ3\ |Ys1 u&	 t 	&Uug" Ǎ>^ |  Êö y..| .|!߿^\0hcZPQW 3ۍ}a"_YXP3X0@SQRW%,  .s 8 0f#ffg&'f 7 @o yo_ZYfPRb fZ`$<t'<t#<tNc  t T M_ H<u 5  %l  ߽
 aS  n#n cQVW3xu@   	u1@ ;n n_^Y[rGV 1 Sa mX#<n^rIU$	ppqumà힠uZP s H $tus#sPv#$rW _s	t  CmѾ$
0	`D t`<u
 @&   M!@tA. Auq0k@u  , & ]Xe߁ ?`OͿ  r
 P<Fu@ u$s	} 	uA
 +
u	 X RtGTPRu`6FtEudr_RtZ?xVr t& ?R0-ZYu3Cu
h < $Duh h˃ 
XuhdbX&  U au@ eϑr_10]rr
Trr  d ýPSdE $& 8t   0GQX uSQ^ `H `*C: E81M @@۰dY*578F'()+3457V
t Àu v'5l )p `
x t^t t\7u+tF53< v
<ar5<{s1$P] X$#ôr2հOvrV#su\} "9H2.u%q#߅0$&u!'@t<az<zt, ottt
w
uE2@v`6\-q(j	 /\2A)Pā 	]pt"pr r	<zw0vPQs	} 	~E m~$PnP!_ 7_ _s ufPff  @ fXtfUfp PVfWg]`Drd<f_f^fX]ge333rVd4Ad^;sgu` 
` s M tAt<VrdDg}
^` VWd_^gEdTg};
a}gE `tr	 	t}d8tW<ytu@Dڦ
`PfUf]3
t  tu Ó' <.;Gt -._ u fg6$+' +k`  0 `p	C  #lFpoypOIEMAG  IZ P     	 {
 `# HDA-L  wHDBs A-E r Cu 0USB-[FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M b` ;c!"bF/	<b a ?bCD001EL TORITO SPECIFICATION q="dccc  A " * Gxx  x y 1 " *
x~"x 0   s w_X _y\[8y y `b  T ËEtذE
U ʿ`7
 Mr0 t
:r  ~xf`i2tW &  QF&E3tB&U
&{]@ &E t û(du &E@ !#wfaP$Qd7QPRfdHfSdFQSS+ #SdMd5RQUDJ VX7dP <d;]ttd|d]^  R 3
' ' FǠ  F/<e3 .;v+GuBG
`F/ {@P% 	pXvNuQ
 	0 NY%u'
r0126789ABCDEFSVۻf׆[S3.:ft	Àr2ۊ[2U uPP'Xdd]<to r
t~od8D^u0젎Ps T^u`|r&
yt,ـt&M1&G&a|~`qʇLAAASa+Íu 2pȃt
 Q $FKuWQp
u	ۍY;Y_uS؀u`;u)o4   yA3pPS0
BJ<Zu$ u !N t3 `aqt$t$UNN<Uu$ =OyN#ط$0<:ruPP PK   AfPfr A) fQfVw: (fPgfFf^YPPRt 0	t	tv
 vt	Ȏ؎ Ѝeڋh=i3 WfVSQf恄VF! 躈s^(2۹  ptF   +^D!8u3@_Y[f^P!WVQCuKE3 `!0 w $I^:u:\!u~ ,ڻP`[_0< tG  )M
 Y F@rpP
P
 b
)"d
d
$
gr	S@-jma.CذÀ,@u[û@ 2p n l C  `#  unȰg`2tð
Q =,pLE>p)$zt3(ø
 а	2s s	2  I  m	  {22 	À tN :4
q$>
x$0] zBdN$2
Ujjj)kikkkl:gqgrgug P@ #"U-RG      *[%Q	  ` ``Gd d",!  qa a0Oo 
p  Gr rrs sq]
zs"  
/ 6rP&		 
B
 A ` u _#PC[ $t$?ath@ & r 3u.m3s' ;$ ] xLI<u	.m u< p 2$\   tu0vu	V $
4 }PzS0@ u7d< <u `[ASPfVPfWOe7NO@$mc#joooo  M G"" U*a&00q|!0AbcU]u U0"} 2jÓJRQ%̺ vrY U o ! @Zнvyspo  u(<sW .Qp_.w ÞP'XsQ.u..&+w.	p`@ t^P_.&u @ u42..
t 부wPUU*e* f&u XcY0`nP A3.G
XP. *.rPWЃ_4r:rCrNr]rprrr`d$!<!uy"p`& t"&& x<u&  V<t @}K!D8t( 2 '2233.qfۃ>tѸ"   a ࠿( Ҋp ) ǊȊ&)  * ߊ* >+b#1 d>,ߎ0.- &) r..PR uܿt;6`E6 6 ~3
t,=
p
"=
 
55w<t<F  t< s
& 
0<uaw\wWQu& ` uBv`!AhsPMY6 FF;t2Ät9tGt0tSsM3I"L fINvNM@P4J}aR5JD2JEq3YJХG"I! I'I&I'$I+I dIuGH 2G0G P
 gE
@t"6aD [g 3$sU I~2maaa 
$&&EP&E
E   FW˽	K>]>}
Q..:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 V|s_}|789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+Vs
 GHIKMOPQRSf@ AhE0  $
&að faRМt$tg ȋ`sZp1q)᠑$si #cy$Y ofQfPfRWf0b ff+fQ Мf׸@Yrf2qf_f^fZfXfYf>Hu^f` sUڿ
f6Dڡ UFu6 ; u00tfr> t YQSWfSrf[QSWf`/ r)v!ufPs \OfX߀tā_[Sf<t;f3f t	f ;Op
utǳf3f`
 3 Pvs z$g$/$($$"$/"V"k"
"[!^ZQR@"]Q'B"@"]oO߸ $Iq_б?faZ-u tVx  tcPtt>@ KXSB$x$PqmXr$Qu}!$
BB ׄJJq4HX^ 	S | p2ȅ i  p$ q	 q3۹ 3Ҵ&./@32ƀnuo n"p' м  GK .>~1Br dt4t ߰p`	1y2撰fUfPP`,XZw+ f],fŝf]rPmʸn跐 SWQ  L2t7`Y__ KxA	3" b! _  HP   
 r
R3҄  tZfl f@f=  u =p fl P3Ҏ¿x ȫXRpDZA $PMM O                                                      < AZ?" O?$\s    /%  !FZ]' r JƁ߁4݂N^ `Y	r(D
@ vArHvA.GsNfj@&t FN RV.]aZr# Myu 6`r pt 2reĠ	 v tr&@_&E0nr_"r}20RsUu
FUF -Ð
 [9qp
 /B
r?@e{(
	pk^F&?s  s&Pp  &G&w&GPh&OD
 &	G!.Mf.u E	ffPE]EabgVfQSWf[ffY^f& u#f&GP Wf⺁   4W1P'F#~r .u7 u/sr?`. t8}  tu  2KrV ʀs`,ea	p ]a~t$` t u/~ǉ~ %"NV 1	s^Í6b.|up̺UfZL艙..aa`>` .:Ut@aeaaCWQS-ن? t0.}u.:Mw#.;]	w.:uwPw.o;w	@w[Y_ @o>߀?r.u|
Պ!Ѐ ʋ.E<v mfV{fvdD @؊̲
@NP.eXfwa pP	rs}2

	fX!9
dDΎpp
Uv]f^PR3B-` ' ! ZP4XuUW:>	迦_]sFr  0P
$<~ 1 r#P@Xu>>k Tߤ$@<@PP sXXty>~5+ TP, b
~
 X  PR?g
Z> Ps'`}2@!  ̞%a  XP`  `0arSHmIrcr^t :DvL*Doȱ p u	R蠣mZ
R蕣fmZ@?
u rlRlZ
u2tp1
 VW
 _^ q _u
&:Ev&M
&*E
b
o
foz

urQ
ԢnZrAA&蓢@uq`}`rJ r
tHr(wtu"ZQr r2*-Xt4B uu@uu`  u2#3fPS `*{Q[f iSps;apD
>X`GD<^Ƌ.a`t u a?s!$!"桁;3@PQȎ bJr#bMwq_'0 sq_2:Tt
 YXÀuOua9G  <s& ?O 0_pG3 >b}_uǀ   a  }amaVWi<ua<
uuP H<u>u0x2<t.$S!k4[|u|
v׈|`Azt\_^F] }
u}	| .ia@rq܀}u	a`>륯~@uD?a豥P%'0QV 3۬+^YD&v郔fff?ffJf6 mt
rj@%f F PXifP~ġ=r0&w)EfݩPu fu Cuo~A 6SVt|st t`t2
3^[PfQ
  <  !@ f	t` vaif`fff {B fHff#f+ִ f;wfgP3g&Sg&c
uff+ffaf@7SRr=?$j0Ef`ffX{RRpEZۜssrmu}Zr
w0V2PXZ[ %)_d%&  +%dURfQvV ufufYfPQ@=fA{<\1< uQ !ϱ n -Or.V sfYZ])Tf;¿f;fZWf! rfrR f_f\r
8fSɿ r#|s
sa`

<Sf[TGM	rrBP׷XPr Pup>$Ss[OBMIgREc{/JOQ PfSff[fpDufXE)t fat/+f %#fSǻfQf3xf!X2"ZfYg*Uat?$7 3#t N	Q!Bj0
ð- \ľ!WV@ fSP~WB Q Y_W^9pHlGst6]V! <5u G	F^B^= t薴s.U<5ЙC >'r Xf[2PX^2Y#WfVfUt
P E~_r&< u P_ N_B S߳ f^b$Y PJKKXso ###a$Q$!{$P)
Х ${ C'ð) t1U
 O O$
OO O _N$ N$NNW d$u)o%3+p\t	`
Sq'Y0 ðQ3)+3ð&tFQ!zt	*tEPQS&"
ǆ[ <t<!t
<P	<*`RV#A	0	`p4ZQRu `- ZYE$ 2 ) S8VP֎ލvS<û	 Պ[rpX2G^ ð!@萠 "*Vfۑt tr
D G.,@Q5l^I_3|?|࣐  À˝ н$  <q<`'{^ Jt"GV} ؊B% yLz#؋ rLL*ZðRQoVWPpaX_^YaQmaPYP2b蒊@Љ R[2|@ʁCl\
P'3<0fq1W+ðW"5K	Rb1 5 *pKa޳"S+3Tb-jY:"㠕V/Z<^,UR>*> 1`51o6k25_U27UP	}s
a}6=qc3Rϋ3ۀc&$ t8tDS膔[2}b;ñ_SM_ PМDMI_ 7  $>E@ f3x߿$f
f $RWS221 or .ހ`u K.8s܊w[_fQWp
t)A0r .ff  u .8ufXZ_aX r.pQ3.r:q.t+af.4 v U.
tj.8t	
uaYYSID_  qo _UU AI z   w "! $  `3P$8Uug&?t+aÍo>ma.tp 	
t>b.:Uǀ	 V tMR?kZD.Dtp  u?$Dt} t	^^ Q | Ys3䆊(u*Vh b| ^t
 ߨuxu
cs)t!Rڻ@ ۵u3ێێZ
t	 u
u
 uP@s+XPt eڰ`0z (` tOIu (O$
-Ӏ`,9a%
´+ӴҝVWп t*uҶ$t0 ^ ȿ_^
a
%	$蓿Ҹ %` +$}fa9?P  2XPUv F"	F !Ff ]X"X
PS {${[XPSQ2NF|໊ PFY`uW=2
f݊e݃ذfݰe20 Fa VRqtxSR0#گZ[  Z[K 芽ʐwu? WEȠ92t% s0dZ^`u=nu8>A#B 
ً@DEp =E24 -E0URu<$u7G^p)DDtۋڱ
n
 PGbXU 
 s ]`K:\KxSQ3ɰYڡ1M M>rQ4Ys]\ P 3Z[x0"ۻ`"χP3
ݸH CٸG CS QL 謞QK S
 pN qM C4Cd'#t.(|%mf3gf&ff=SCAFtV1Gqz"ffff Wuf+(#3`fPf\ۛfXs_32_    ̓>kpXoQ  `@ 0 @ PP`p0  R :'߀pfۍ:ufW	Erf+rf[SfW.uOnRf g&$fD  !? 2ۨu<@tĀut.7R˸_ f_[ %	*P' @[TO xOy^ ere$DIsL U]tf r.]q S
r3f% ff UCESY4ry4sffr 3 1f}qu%f#{ p	Lr`t s` u.`줰alfѿf#fp* f~   rĿf e  0Q<t2f3Cr6
+cu g> tt أr7(t uRY.f.[g ip=4T 1t?t
(9r Rf%Z& 8~-t(r!f1utq
J?t:{R!4g  e袢uc?AM8t , tu
@u$2(H	vp)@t'W@uU'*߀tp(t
 /!- 7 t>"I 1@u2BGAHa33q 
t@  t}b[QQI{Xri/p/B/RZ/#rGU/Z3t I@$
 ԰,$t @ZPRÿfVQ! 0fF3Yf^ 0  y $2{gԢn}Է@\H 

O^	 = 4w +SfP[4fXش  [USQWfV~W   _ W
t<5tuf\r Pf^_Y[r譠~p5QRV3P'0f FoKt
 g8uƽ^Z0QfVW蛠fo5 u9EfЎذֿJD@t0	_f^YXu< uEuPPucuZħPPE EPP runtime BIOS - Version 1.1  
 ި(RwȩԩکwU e d]|`um.m ƴr jR.m
ZpQR Pt<rt2[5$ԁ ! 
_ -"  S`5	$ V p[		uR &xuR] SUUc.V=f	`&n ^CO CWU	al _Z0m
 J_ U PSR Bt<3
 j ?Gu 
ty ).> @7S?. 08W
D  D 3R3 AB$ԡ 3ZP1 
(<Pd5bKP&` XW<r؋ǁ  .{_Swt 
'0b r
@ w[e uu0^r!<9	rr&W Qs" r2.t2& r#~[!
s  r> 9q	8pr 	&& rr	MQSs+&' @>' gsa䟡$5sQ
u>[ ]Wpr%p$S r rWq	9 f" $ pXqPm CX#t s屓@t,Radt` bpt t
@uYÜP`
 LCXr`QPPPtQXdYQPQ0 tg	`PXd$!<!tQQ_Q  q&@tPG S ػ@0f.DحO<.Df`2uhf < ҿ 1<k2aúB  $t.Dύ+ݯ *qݰ "Nas@PpzFF
]X `j .  Dv
B:-Mf.N. tI F ~pH p3؊^)@uw t&Du .⭋^^t7a.@t&ڃ.^2Ȏ36t6^2.p @ PSFg
t'.:t	tX._`g }i &  @
˰_d@茠a PSR,:3%  Z r-s(N@rH rr
FјvFr:s5&DC H P>rڋpJNFÉF(t S^$:u [r
F&F$+%&=vHH&
D0&d̠u rcu
	A	πϠ&DB êǪ AHA~0	 rpȯ`^b`ospu fD
E$E F IG q
V yN~tr>u rG DjykA3F) ar\RDQwZr=H r8 Sss#T
P
r
S s~@H $ARVF(`r#!#r脟r`ip!<wt '!r #!F( '&d&Kp#߉V&Ơf)&t N.`RD fX E QRfl f@f=  uf3p fl >t@&?   ХRظ䠄t"
p  u$! !Ҕ&k Xws'` [Wу!  E%a 1	aI Xτ @F$$<r$:u s
ߊqú#t'Rw 
   @(5w  $tVrF.^ࠍ4uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$` ŢF f%U$PG >B(IJq4Pvø fF" PXۋN8NwN 7RpvoZ2NIIIrgQ uIß'vmZIr rufQguAFupDIfYIb2./5/ ^ &u ftg#  3uw _VQB AB uBY^ 
rK `&s
3
'u3` H@
%uètǠt  A: ;V&T tup 
* &u^ô 0]QPXuN%&:L@, r&"THt r@u<utGS.@ BD ? r 1434pG	t$<@t4ٽ14sN !$!ssPR]NZX$$Q^Wá_۞pbdbh}sPBRsMsGEsùFc6sF<P
s
u`Sy[PS3y[
uyyXyaSQRsɄ3-r;áZY[3t  XfPAMS@VW  Ў؀    u
 v  	˻ʆ Λrr vh~F0 & O 
 30&O՝ˁ0FUWn_]v
 ` _^w 1
p P< MB RWp6
$7 D P7&ߋ= @
7&FGvu8v %8p c@u#' F9 *9&` 
;qb9f3ɐfu0::&J 3_ZGF< u  u2D@ UzsN~ t
SrD[ô`PWfPfS h f 
f8h`` f{   H  $pUftEf
 րbf܁Pf[0#t8]f 00؋f% ;tfPff  ffX2{fڴ_O.%t}  ۰}J@> Q`Q.lP ɢ d T q r7*ž4fffqfT @ 

Rfx ffú 5Z`P<XfZ`df@o^_B@ <@ ~f"Q" efw%
 P#5|DpB$_B3EA@1'9)Af`fft~p" QBY ffhfaQfRWf ffӿ fRf3fftf fZfOu_fWryLWtpL=gpkc{LԽrQHL G B = 8 3 . ) $   o ༷<߷ QZ_QTy&GYÀ'<؁bPaðdu-WfVf  u%sz%ft3f^f_f  fZ.at'}A$<u 2w$h < h4 _1qKqUsPws0jat/ s
2{  憐 |="  |  yP.Dt.D
u  ```P&&D aø0 м 
 fZ` j &&E #3Լ{~#QPTP !X@u`.\.T ώǍ>^.L` `qa.D`qaQPƌ@XɎ6hښc fwZaa0AObOb(.G_q¯a==SWma.}
u.:tL u% t>JrSb.[t b.[u t	t_M_\`EfUv"v t Ar Mw .V PXF
Xf]h@ &A 2jG@! frP0qôkĂ
	RVb._6# .t.I.
Lj@s& { |0u 
^SV#0.d.$ʋд^[	觳ã3j0rcOt` 	OtOtLtDObt
mbtabt[b

1u	Ao.<Co.ϋ}h 4$ B(Uu	U`KqtR#Prp
fL\sZfPܵ ɹfP<r|wfwDiu
 auASbSQVWUP؎&Br> ȎXb,Ob> ..>@Zu 
Pa 3PB &Gݾ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^`&?sa s@ s`b 
 ff&GnE oE~Aff	`
 p`SRWP>m޲ yZrv [E<u? mǀLuUE<sfQAM}3 fYr2>bb.  EG!R^`l./8<[Ül_Z[QWV.>utGFr=l.EP .&b>`@A%50~RYlَ~W6b@D^_YSRt5ێËfQfS.&Gf.bf&_f&_P.  Y2[fUf%DTRSf]ûÀuTf`0D @t; @QP:Y,Z6'5 ! faхj>f } ~<P u< l<pc< %Z<	;Q<
~ QH<i?<@6<
-P=:P7< <<p@XفL]WfPCI 2_ u_ fRVWfSt$fѻ"WrȀ`!tN f[_^`Yffⰶ r }u
N`>ou( :  r 2fSPfXZf[轥f\jЊFKЋ5	,s"s t s t  V&= P s&EffX 1 MZPw`;t
X2 *W`
1_ ϰ#tA0X _^ÃNp sRQmϊuf fPf@Ӯff P8s2fYZ  '*13:<GIVS3 .:^_Ku [^* `FC2tS  3۹ S.gF[C3N[QF?tssF2~0)Y@ ø71 _`  _ ø8 %d%`dtq4A%`0%S4 3`E4$ $PЯt"Ĩ@ 0
 ޠ XPJXWP@  t+. s#.*XP药&  ~ &߀X@W fWt_
rrP@u
df%  X 5u6u fy!>f A$  ~ٿR@ uSf[*u;l u
	

  Vf2@  
fb. PN%^  rYulː
K遠[w`Vm[Ac[Y[XO[.E[;
u&fFf ` f&| u=a]	'PfZQfV ?YBUtKf MPTh+{2Ep1 ` &ߋu :ރð  \0Y0vUh &]S^ ]0y>&D0D@ VE& Ofȡ\AL
^ρr09fWs	MTV pOAxft@`ʃu^;pP P&t_ 'f= >x_'+a¡of;M E
P# Wf. pzg~_0qp&30ϟr'Ru
Rff.f_e2Mt Rp]StQYfx tfp,  !fp~tƙ# ,w;5!вU
UEW &E/"Q*rG aD`%hsPfX"'rnOGR0w|R0q1P_@ @4`ˋ '͹`1%@8" 5AC<t/fQ w"YPM 
fȿu f !` Ct(wY05DQs;5 ) T
AE6EgQ"q9R88$%a;"#A() f

f
`	n
	14R@wr('/uQ ">.uf.ߣp - Df`_VQ$$@
 ~qB^3J
ry9
lY^Hg5 ~U5GqX5o"6HeQKv p0=f(GsDPfa>PVУVWTVV KJiLJ  fS{tQؾpQWaS 4@Ef0? S^ hVTTD?T{pffWfQ`WTZBS
`m"R"R`G2RWY }G`f^W^]^@׃Lp]IL@/o(]]\or(V=&	3
7T`TmDTp%uTg1wؾ:!U	4Vh6o`#XXoHXWw	)3!Z%l&#l`kq_W3n pDqu_QtGhQnчn2['hnnsR`$ppyps|z= cpYo,A
1$pf[`oRRRReAqJЎSRbU{riIbxbR r讠>tfК* Z\ `Ua  B@uZYggpA ua`~O{݀    ' r `fHPD1 2]0[#r4sf # R= tJ=Y Cf3fffX=t@fX轑׀fftN]fTCPAt7fS3 f[ p! #  &EtrwPfV䒿$P}xk6ng^Xpzxf^XfSPAaBHxXFa N V!~n$f_  fXSf. "  Ԏff3Ҍfff fm $Q`Pe^T 		Wf0w f_Af`


]
h u ]
!=
fa`rfp farO"f3f~ &  s`kR
Q[Zarf1fH!?r0Mf	}fI`3bcru3.| tFV.D.ty< < t&CF^ t& CI
Z!3_tpf0rqIr 4W3 =` o  < SQP ?$@Xߊu%@A,<XynR$Qt!
߂R=
ERVWf1.1VA c7PuQ<V V <W U  p tT `7VaPfLP >D Hf y6TVs >Pup}f2>yf @uuڸJǝ0yd芟O脟fuڢy .}>} u襟 /R+quY>t芛`aw ` a~ u
fU_^Z2 Y Y[QWVV_^_YÌȰ>%8 S߀r@"_ uaMS  Y#3r@&[UA  r.ܡ]ޏަa /  ߑގRG۽O̐6!@BK w(}\ r`|'	Mހҕ,﹔ ~}ޓa?D	
"_:Rt~\ŗMOϗٗݗCfWP5sA<aȋ$|,u#S(|Sp f3g=SCAF2p U< t
 	<! F ]SQW  迅<w&@I'V3ɊȈCF`oaJ ^ t	_$SQRVV<v^.
tM" ؋,B9^Z (U2"4"]UP Xs.V Ou,]K{K{A $0! շT g K{RRZii#SZ` U_=܉YKepjOK{_ N45%jQ r2t"S"贚*PQ y	["2ɵ">Yz .63Ê$uuﴀ @p} S3ێۻr?4[Pt WGQ߿/q1;Q_~QX(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.W@ AMB C 0&"g]P_t_g}
3_PgE
p ulP_ ^   SQ>_u5M2ôu% r!<3ɸ  3 3SRVP&_PX轙v٘tt#袓 >蓙r_<t<tƝ7 3^ZrV]`|u P	Cir
- "_Z&QGQ =rc
p3O___2(Owvvxx
EZtńPRuuaa@uXXZXp! / -_PR怺NZX Ü=rs
0PPG{  ߸^ DX MwtV.{\k _! !$;諐 1q QjQb;ˁPQN  K :g'  A G y   y " ËEu
$~r3`tW   zd_Ȃa_    !rcs^&D
V rF&DtH 5 
B =r!PresuF. u褽Аڨ$FrQsLEM rr
r*. %EZ
 
FFt PfF" pB@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
 F)tP r4F$
Ft+ F P   !VPXV@"aWPR u	ZX쐅?A(tZXfPS^ۋ^&t` $ueG&uFwttO]]̻( Z=H@0A:gqgrgug%17   6     G  "6! `@ob qu_  _ ` ǀ: wPf PfQ pkPf  U	 Y
 Pf Pf@1lPfBC  dP dQ PfR  dS PfTeU eV_ 	eWXUYAZ[\1]^	t` ta ub juc ud!eqf $mkmImklFllll{bso} p^<
  fV꾰ބu~袿t 3N@f6 Vߊu^ u|`P\@N`R\  ShtE uuu't!_v
Zpj *
]_]f^eU  	    |  pVG$ $  GN N P P  Gh h"Gt1$  G   
G   {$`    0    %
qr 4^S]                                                                  x  ЗS A    AaO IYOO 2|vPtF X .	˸ f&q && f" иf3ff  f._f.]p >` 6ma  !ŀ.P f.""""" ! a
#
Ƚ 
 f3ۻgf+С QR3Ɇt 
tw ZYJa;B;<t&<t"$
tAJF;Bk+;B%T錉 u!uO߿<2䰕f]
 N] d `dPQ3 Δ7y40rdr
` r`f<0|CJQf.øJɊfUfQ`ufVK譊rMfXfu gf@ N V FfYfu(gfFffffMufY2f^0]Ë< 3R+fQSfVffLfTfDfLꀆf^[fYrXt	A3PXføMøNøOfSQfwVfR
WfPt  fRfZ_f]fZf^Yf[PfWPۉ~ wt` uUPPwXY f_ PQ``YXt
 t$?t taz`p  	h/耉`_gRfVpZ fW 
2VSQWf  w#t pr@$r	` _Y[f^ QWV~wy^_YV3۬
Ê^S^ e   SffV1fffaB6,9fff;w	rf;w%0S!?/H>Q LaJ%d@3a/aBR@u$  ذ10= <r <3f@ f
ffʝ f! f- fPSQRW V>,83&G;r_ZY[ASQ <%<0   1Sy9 t	t`Q _f+j  f@ #  @ufPfL4Z4f4f P,p!RfWg&>tq r 	@ Yu f_Zr gf&^f$f tt,$
g&"Fg&
F J*$
g&#Fg&F`K	fN#F	Pfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g&u 	TA1P a3Rf]&^q\QUÀw*VR|   t.Z^O
P .*BBBX$JJ2JBGPܰ t
tJ X?u` _IQ V tA&q JZ  C@ۆA  t*uP= ]Xruŀ̀2	wN
 : (8SQ2<

2ۆ.
$2rqd;<w0
u@ð  ` 0   ~P ء * U'R.:f tGYRu;Y.V.f]$PIR `  A&^` i j b c 1o 0p a L 	  q6  00hbp `3. W =p
_ϊp~
p aVWS;t@t[ 
D[_^SRW3`  Qu_`~aGYh /$_!_V.  3ۍ60v.PvX`PF
Xu!P;<Xu @P.t0a`
  Po@sa~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~pq Q pp		 0``0!$ff$ 0xx004lllll  l 0|x0f 8l8vv `` 20```0 @  <<f0 0  || 0p0  x_8`̃ <l 8`p  xx@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf`bf  ΀ 8l_l8` xx/p$ܱ x0  Px _ƌ2 xp``x  xa"x -s0x|`` p 8l`0
v!`lvf0 x`X`b  P  ! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
bZ! ǀuEf SvN ..l2[]Q
! YQ 8 O ` PRS%` +~ ;w[ZcAAa TAAE eMA9Y.nSS@  Aq( 3
`3Ҵ`Āu N @D|QYR"|r8r|r
2:6 v{|Z aP P2XPCI01 ISA0%-H YV03COMPAQꊙ 07/28/06       F10_  xi؎ ^ Ћ:V ^+3f  Ak L!$F10fPfSfQfRfVfWUfUCES>Y  fB  fZY   tY  t MstpU@p o@t-P u@d@`tڰ 	f  f   tf`   t
^Q @@  AfZf\( 3uq 6l[< tf3
@Z>l[0 Z j]>Z;\ `\f3A3"P1t
 }   2 1@&b@`a@f >r tf` f  tQEpYV ^ GP
]f_f^fZfYf[fX[fVP#3!>\ t
"y	BC$su%&\fXf^PVW 3W V_t
r
>Z_^X \ɰ۾ݷرκʮϵܧ12D_D(|1 8     y:0  ``<~ "!AC=>=  r> @'Yar?  @@@?A@ &cD$	-E	I!!
0T!-A>q

( )))**LLHSJ$$J~B ~B>
y$$$@ $
 ? >""ZFY7dd  #<r R` h3x"'yP7V<DW!2

	" Y	

tI  a~5] 
   At"#1 ((DD!@&ba$$Dc$%#A X)&)`' &Rs[^̃ZbgAvijoWt@CVXeւ\fHݒHoߕύXIۑAOԃBĂeLphd|IeuN͍}JTp\FffnL`FڃMߑIOsځwE\KxuvQƁBȉgjڃymxtԍrmÁFGsʌx݂한쐬ȑ}ł񂠂֎~HS\zԕzmQ{ǑV͈vǎҕKvd`Yi@lǉ십ċNԊO_ӌUiTivI"ىe^qlC~txEؑ{pWoYڏMȍ[hxb]Kj{# - |@  т  0 ` R 	i D  Q @' 'dD ?W" 
 P '1!!#"?& p<
~|u  0
FA~% p? o  !  % )  f"	! ( 02 Ri    0

0ec M.e     UP W F  >"6>%
!` &dEG<"F {) BFLXp0Ԃ H(,`"081+d$Ad|9  1@  ?~!BC ""!B'  /!B#b&2 33`   $*6$1aLX +>=p1@@@a%!> + ,ـ @+Bft,0Ì< @` .0`  Ct6pC R ,B
ۢC@"BD!<| D~D D<P B f<,$$0$l= 2 I@ 3`<k%b<@ѠA |a  %rm  2 Q ? " !aA<a  1$Q$${a?yH ! {HHK` ?x d $PV` @@` 0!cc $2&f# `J0;@Zxxa 
c
{AHxp!
g
 `` !`E  ((@@`)X0$x|pTT T8QC7O-  
	`E0 P $&# ` g8 o & OfT05 B`$c  L $484(d(lD &1< ?! ?&!<? !!# f4cm[\^0  *L@[* R4fBoFJ@qdp1xi?|Cad0a ѱ"i 0`E!cE,1B ,2$9`0po?"#!!;  `07#	4vg 8s  [ @ |enZIi&0xCGP(Z/cc"d{
  zzM@^@40  #2Bb"6T$-`0|p.x3 G(i@@` 0pހ ߆ ?` 0l@MY@0M0s``8xbv' ?HbK)' 
H%0#$ !"*229Hi)""?"!  f '  <p$P$%)*$ $ '` ,!## 4ED`@/$ !   BxM)A$ U\7 ga|"  ""
"4"dQ0O!  0|`bsD% 6s &@Ea! 3?! @F !dF!3#:~?;>}>; r?`8 p9 "} 8F `8R)C)E+D:<  = ~P<  b <$  '  |D!  D|p n%8 >!n??$C @ 1bp΀8 (~l =Od<<$$$8< "***" /"$'$&*"$" ? Db2b2U?1`		
	f?21"`nд `U%2%?' X p $'!E@ox pǌwc 1$&? l@ 2?$?$?bVVppTD`$ ~  <@ D=!<$"  a\5' '$'0p6( g!}@  q6C  H2`
8h(LRN2$2q2DRD" T@""z" ""sN0 
CJ`zz| ʂM@*t<Dtd,%}IHT! ϡ[@AjDfp P
 .:23V!&    D81< @F<qb O=$! @~ 	^`/ P"Tj|>? @1l?jk  3C1(ff2/ =\  | %~j  li 	b`q0@ >)2"b>" "~"B"B>B"33aH  0DP;6[e`}  ) 4 `22"R`2   @UF|Ctd pUD H G1$?$q81 FD @@1#f~(3H2~RHH~HH `~"""6_I 6q"c  2"&	$  c2A*b$?AS%aDh|0  1    wQ_RuL!3p    7  "r0 aVU 01? c0ɟ苠?0S""C 8o`ÈA a d W>sP 1π B %z&6J J)6  #҆ژހ   0H@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>z		E@e%f|Do2D"DvDTDD6 # a ('}/`z" o7 )fb(? 8ctp"}  PpP? ȁ#}
( H k =K0{4РSO  @aBđ=  u4a8	  6 a	`1pp	  6 P>TЅ  pVL D@@Bf$,892k&	aT%@@ BgB(@Pa]1 pxPX	O 4 c!!r! 3"&,0@ġ?0blP<x @ ^ v?$&҂X 8|	(9H ;)*;*$*_%+8"e aRa
BF0L 0y@ D2"##(#`F~TT5VdV!ocp @a>b F a9$i?$	$	`  vx%` 'R	0`
JIC```WHJ  	|!W~@w_*H  K6cccN8x d?~!BC  G#" e jj0P0o!  8&CW0WcCf0` ?~$BdB  a B
BB~1I8"&D$(-( (B ,!1	8Hk
 

=I H<H$H$I$=] @ @ŀ 4R$ze US R !P@555 `6y0 ;6@bPgAwawDp! 3 ?$$$5d$Dd0R< ~   l ݀t  $D$= JGG^Avq! 2T<oDg/$y,(8p(lq$B0' % @ d  H4b2C"cy%5@ߡ0lx<D?  /"?(/(/(hOX wa@`\A %+\ 	ppsD`  0  ""bp $ & "  `c@`?6@M
3iF>D@e Zq@#opa(00of?$P?			?R" N$m|%o38"5U QHU'@S8 0@,yy {	z! p¥>""	& 0">f` |sgAA@ D=  =  2 < % 28= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$TdT?DT n%%">?R $ '$!$34, g A#A B8`nU w$&#f!|ࡖ0i#!`  b6@2~Z*\*joI0A
 PpR 3 `00 B " xBB	 0#B~5G ͈x RRpF H0	   & 	  &a K$# 'kooogp 2`zsb0AB@  F>lxPXHL0F`C0 `<0ʐQ0b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`a8 ?@@DDD! 0!cN 2"$"b)) ?()()~?H!!!aG`_c#40G zRs"r7 rC " `ȄV(  fWWkp" ">a>>b 2  "&"cb@	"00P G  x   <10K3?S"aK@ (! ~I	))iIx	1!c @>~"}`"b>2л
  >A  ;z ?A5A  ? `H ? ?$DX0b)+*{I#F(en} },lbf?"#
 1pxbj|  8 70 S#Q8#C!'8<
`NS`'  > "~&%,?(l)$ -S耝Q@ 2!;VR!q #  x p  "**~*B  h b~B_$fw D0@ @A`#p`$ 
Ei[  ~  O2R2RR 4Bb.	A4[d02 /w" u"p  bB o?~b
(LA68ɽg[]CppC}8@Tl@ l$5?b5d>qc 	()	) ( )H	ߖp `c 5_ 1 aA#?~"! "2&460ba#b @#D/ ZS?!#3"y$G! !?! #! ! ?y@wp7$   @
0y!K! `֜s `7xPe `T@$Bp8p'|"@Acp>'$ , ( $BV@b.F D !ss	\3
D(z

@ 
~~@<$4 7 a  p }#@D"4&0PPP``? ) )?)  ?2"/y1cK{PApP	١ ~"6qw@7  "r"@  ( gd&Ik	? ~!<$d$$$%=6 c`M}R  Pp @ǀC# ~
D@     ހ uUp cu`U  `U	 `}@ ..<3S.:3~hp 83  [<u.<3 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.23` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VP < t	| tL^fat PwDXMCÀt	F- u 2 4.>A3u . 2 13 `.23&1 u2CQ2P Y*2Ȱ&P aB RDr
.B3.C3PSR  && Z[X ` Op@Cp
oo._6l3FF!.W_tOT_G-p
QR.683ƳP ZwY[X  4"2S2OsP2 sP
XÃ <r<0 <rp1@D3  F3.&@Qpu'r!	F33o!a0n3.>l3P20X2$CFAPQRW ((_ZYX. 2.9 t.D3BA	#+D<u<RaN<P<S{<0<<<<w<`< T߰<@<.>>3 t3ػ@ .<3G.>3r3OO#0.<3.w>3p<`X@Y 0..n?3.p30;Pp2  X:޻XUFN
ȋNu	F]s S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV> M> tj6hjFV^Z&  _hEi>LRIW.2o1^Z% = Wۘb	Ga	f"\fff;
]th X)c@vm vM_\/Rg?[X#oX%2$>_	  "JsXNq!?PZRZ'}d!	f>Z%ϼj_t$_Q$8`XX#2
fPZ	(*Ya0$Dt"E*	2C"1lHx)#4BrSDJ "$2UPZF ڲ9:9;gUiS>P\>b~p-6by~ "\$\ Yzl 0ah5"\;GB
x?IK{AƦh?"C"'EBGH`bg=J>
XOt;j9=)S? XPZY'jQZ$/fh  nr[ tTtPZt	fh "Z$Z:tjnA;Q_tfhqL"bb	 >
t][t= tO3>[ tjh[VfhI 
׀>C*
$j hZfjCCfjPt1t<a&\ ta&\fhqQO ] t1+ ]C	!	f3f
~f PFPhPXhD]"Bl!uQhf!3F``Hu:=#~2hR[h R[Mxod V0"5&	hH\pƧB2F3][y]		AHZ%ZhFBhXFP1@ x}j>h!Zp`
	 #Z\h\rAYI $ShZVZBȁO^05O%h01!/4? VsEc*h/xih

$4O	QYs*YA,^_ 2FF\^ F&<
u3L) u&*V&8\tFFP9 1FOuÀыٹ F FIuF"1 F*+҉FV]+;u;uà]% ;Fu	;V@á]% 7*2}]@9A9B.A 
	}
o WQI` fj h`S:C-{ wf f0]0 jX&XjLofPP~]jPaj FP?^`F#AbcP"V=ut_ Va @)# GF| L02,|[X h ߎ&
ʃ F GP	FNuFG0?N7 

yO`4@WV3 #  >A^&@FG|?忀 34]6 "1 ! & FWRQ`ÃI rQ16HF 3d)!! AF߉2N  1p Ro>SA	I6bf?5X#R Gq5$1
2&_Z%  `Z1oX

&B]G2"\%@ +1 1B]j]RSpJP\ @bFu `Z @4	`Zb
RRS
@V!!u1	9bF uF3ǊFrqXS 1jC	
 "`P	Pc`9Q2X%RX1Xj_	3X%Q Xj-	PqQPZ1ja e`h~ 3++ZjDz"!3!)"$E"zUQ &(C"!Z#
P 
$
H"#:#P 5 s%$N"%!Q5g'.i)۔d/jS+*U-4 Zj~B0h1	g#ZZ3Rb1Qp x2dt*!5
A77A:Ft]q8a; ##B]t"yJ<<t#AzޙK?-tQP1XAAZ2{J)0/FQZ&Z'V&@f^Z   ݁A0߀ZQQh a\ZWU Qʢ|S
q} fZP YZV t}JA Q8M8:tA:XRО^POF̌]^F  lF&F~
rO1#rgE#2$` [Jt'@"˕ZB\Aq(YZc*  +V& &g[?&ο[ &` &J[N^ ]@   \Z[ծ@    &\.S r%!Fb쉠	Y`E  p  V6 ^aF@t
1tJu[ e2t_03uY&[[ [ 4 [259pʀt" t 1m0߃ `
! Q`=r	6U0*@U@=
q
q
a{tzO
mu#Y>Q+u̡ *2 V&׈0  l[!j]Z+!r&ZY蒮nnPj*E0A$.'Z$=0` Z P  &Zwj.j j	 j B7vB 7#rcFpe
9VB&D]*&d] &D]5&E +&FC!&GC^&ƇD]d r[_hJk`7qMBJTZBJK@J[&[FVTUQ9 }"qH\$R[	s$&Y(q
<*0=,rv=R[hHϰ+uP4[ [FH\@tr}Q]a@h$	
bBjgZ#RZ	S ] r`  c !XS|I2.A2Ճ02ZM(vgZ\aj2h01 蓀
t%rB aЋF^Nr'~#tp  u^    % F+ c)pj^   ~u +ËFV` VF4Ƃ4~ r~t` q~uKF0v
.u.~ uWt
ƆƆ psyV_sr
z ^ ^Ap)M~  f# F FB F~P|v^ KF^NFFV~ F@NHtDHtqH P 7?|j
$]b`k
^F&? ujvAYDH63([!9& u..Zamj:RXV!<A0YvhYxi@NNF@/\v{ 'FQ5]FF=P]_S^ /GFPv4F]FxiP'1<kZ~XPdGkZ9Z@g2V&W@236@B@~2|FtFʲ*QW^
.6~ʠ6	/4 _/FFVA(FQC94p&~ t;F4]F2~
z u WV~vN^PA@S
!1@
^_C
"j(c
El`

P)@pr ,md(|WVvԋNsOD
PTHD D~(|W~(I0Lt_~@u"rH#}H0IB^F&:W} 
 
.pBҜW!u@##g fXDi-aҶ
%%		 	F*Pg	}`	
g<d-UWVv<Ёߋ~P F
&GFq&'k*V~ʋv!^PFGIub: ^&^&8t #^^}j!#ù
 0GF N% o}p,-Ar  ~ s԰ NFN<+;u0g}03ɋFrAFWC&PfrfF ~hЋsG^AaQ{Fr ~
vЂʀzA~r
CVV,GV~^&FIa&a8FRQ2^ZP1p aV>¾Qd2IUGbf?bm*XX	= Cq0q3$2r
2&_ZW%  9PrA	oɳG̏|"\%@ Q"\1$\j]RѺo Wh N# -& @R	m U	c_bٺ3X%Q
X1Xj`R
2X%"Xj%"}aP!PZ1RZja"]a	 (\=3q$s$ZjD s3T	E v
Q5C		H-N.

SUU aT(	 g"AUi$!~&
3R	1\ jyQ9(**z**,**r.Tt.xr.`0i0{b0i		h 	H'#
4'#3473U- :&ZQZf`f   R[f	 H\   ] Zxi؃2Ш&' 
BZZF?rV!u9Z V=@4#zFRc%C2HSӺBZ3~)QY ?2PcWVvދ~ &F<t<
bcrԻF*;X}7axy_~tF&8toFu|t<r21°DVp~^}u	A(|Ð ~wPfh#  Z`rpwF;rF f{?* F P F*N*ȁ vFoP0	@@|v
u+\^F  FOu]f\ &\wt&\a q0@ ]% = {@*PIRAu_]$<  2]% wFu! = * Au*&]3rW1i]1]A	wu6B	= +ɉN3]33 Љ v^	u&
 = uP``HBAV
2P
u/&	uU##			] 'FO \\\\\	\\\
\\\\\\\"`>Z 4L[>XA?X6 6 &=  t_ @3Ft  괏"\#B-//

	
88qu	 )M7f6Ĵ &&T:aV~S~ t'jPF@:I 22/ u#'j |yqZt=Ë?3A@ >
u
[&["[2[1p   t&[S1`u\ À&\ \Z\[!^"[0#\\[]Q[XPX XZQ[U>u[h hBh R{p2r^@bBr耲sւfR 	Y"		L	
?z
2o  P)MFJ Aݶ0)M W`$< wsrj_ eKڀit&h\ߪX@W&XEaZ&aZMϰ umfh  tfh   vWEbaudW/c
_W!I$!MYC/I ˢrBRX4VF&? t5w(u%&|Rup )u@DPƋV@RPF{FbPxfjA
0  	 P  jE.~puq/ u v&PZpoF>`t 0j  M3= H.=
tc-
t\-! - ; - p  r= M -  -  -  Q- ퟓ  8Qۋ  &9w&EU 6P  VV 6Eˠ   9~o H  1;`!P~
f
fFw>~ Kv&@u?P^;`v_Ĵ 4(fjt0h  <D p <V0|@]  ~jvV>oĭ vVP*^&p^ ɠVP% 
P q h
 h  yRaNF
+F@͋F@!vvo 	F<VNFF@@{uj qCFPNQ=`*Ps``yWVVW  3 3_^es #<V S!F
F3<VG`|.
#
;Fk|!% _F@P!]aVv`NupD/t&@AF삿`Qpc~u< t[t (]`7 P@N5  f2 F
@tሂ~v*VA 
ơ̄Ɗ{* ufU  Vn'] > t=ur3NF\ p]/NZ&8tG[JvNً! ؉^GF
`Ft^ G5A+tp
뎐V^% = @@A3t`ߋ@!A;w êWV> u~#3
1&A *;tsr1A *_
@`!"~F
tn t" `_fh 
CuO@P.B@>H?Vu	.USEHDaS!E`.(EڿrVu`5 3l	#5d7RP3>>Q XZ`E~38tC8 u0~^
AqGPBJN3~(~ ޞ"u j X F;|);YƐbC \߸fUVNVv<%tF` u DD^ù
 +0NÈ ؏u0+	D
TuFD3Djq\們R`V!S@bVctQвO;v~@K^F&u'Ff
b~VbVPW}   m+΋8sgvf3a[ppN&8 uNP=w t&@D/@ѯ܍QZ  Pr?~6 k+IQp^yYNd_!v<aqj oaWV6V&щF3v~Bv0Q&ğ`0(a
;~ANuǋv piFWˁ'RЉ
~[P V \PQP0FP~ ~
~h3ҋ W2`t4]PsvQ \ 	yGW<qbu ^Pa9Fu
01_P v1ѰO9F7VPą0Sv"F9F}+F- P@!I!uCRq_(mFF`J/b" T\Q~EP虁?DPAaHAJP:|Q!0fh  a39> ~jy/Z*9>/u	QoA@0A/\&_7k6m);
G;|2*& PE `8A	׍FqP@j  ʑHjw@V1NVRPAD^AQd>a*'? Iq@Rpy"!i`EA +FFJQPa#
д&0A S Va<;aDPZWQE"#ڠ<>&5 O`,+F+`M*2cQ$R@P9D=aD=F3@*ǐ*A;?}Rvs/V1@Ƕ%g*@F;vwP$4
R14ׁ

uQ#aQC4
eduA84	P
V輜 iBB&-24hXtYY;}`=zy#DȰdf&D&Tp3p ~
{ @@&Fި@u[]@FtdF;@Ʈ]q<ЁN bPO;v}Avѣa<GF;F+F-	@pFF&Ev;v~ Qm~ $	;FF̣	_F	}w t~0Vg~tOC tG\'F?
t/* F T9F_}\LF ;F~AZM
~~2G+F5p~%&L
q DFF 0 @вf@`	Pf@PF^iEAgGTX2s|xb<Fqx o0H&ovSFv.!Fڍ\Β #R@?~U 3'ts~qF+FJFHfh imaR( tTXT4_v`.9~ 4aFePlk6,+F!}pu.@.Z Po &OC@ +ϿQ.v+ǀ
0|wctj[(
ĔPk`yB.=0a"j]1yhm0 'B0rQ !!a2#$QBC}|PCf\pL@>\\j Ww 
Ht8-t-9t- 	t "f 	!QF~ tfFf\F@?F
Pj ̿ v
u} 1ZpAj >PHPVpos
;Ϲ&wCcstBPؠQиN	VV2F
ta@D%E QDbَNQh
VQ6 B tDu33!郤
a_؋!bGv C puDPk*.e H!Mbڿ9>u	 ZwP:QGgJ	R4waiDu(+Huu @uqt j	j_fha8m	"	P^	St^P7qf~
 t

a}EPzU@ ]2FY m DVVjvvұ{xX 6G ]N3?鲯S39900aހPr~]#F10)cPqE~
G jdR[x807+$ }_p  9]t߲ #)#/E=/豿FFPCFGdpg
p ; ;NNNQPL @C7 r򠽋= K = ;  -Pp---xА\MFj  Uk >@]`{ P;v1!;vFPVW>FP~FPG;~~P1% - D- *{-ࠁ#- " e= Pk'K-
|5. G@6- ;sFc?atU tP` `0a~9Fu
VVIVFp9vu@PNPN  PNNF ~9~};V 9vu< uN>0빋v T` 3P Pp7 & !VN;
u逐xA^F;~ma4XS `
$~Du6@] b;|qT/QN;v}O;x6 Vf~ u[FApL倰 9v|GI0Đ0%9F| ~-A{^&+^& 'FK'302Fcm731vGށV0.tCq u^ GCauK  K o.f#{9Pq`m!ohb"rVt ;tt D@m~3tf4Whr
 rး5d@6LWV  Mc [ t\U@ @ d l[
ttALDTau0!O;F~ Ppف
rջN@uOp0
<|Ɓ<7p>R[ u)>H\ td>] tl >Z tt{Z l}Wh6b  ]hfpu"jhXh>V} o
j(h\hPVmZ zd [hVMhZhV= V-
 VY?hV
#[>VaC%P \3%	z Z\#% [% Z%	 Z`k"
 
Zz Y l+(i``+(^_Eps= Ht.- t'`tF-4tc@[Ht- t4AZ/Q#Hjh5pt1xtߤD/ODpU}*䊇D]uA*HЯWvGPL>t0<@v&Sy S5544%65245rޤ659h^@j h	Q I< (.	7Y P	$譫aJj ?hư"Ћ^3&~/tC&  v&8 u@*C;^|ӣAFpP9Qkϡ@]э1d^Ц? tvN~ _"vޠVq߿~ upv@]FG&9 u7~i0Nm0~FR =  -
-oꃑ!RZ0 <5<<V<s<}<R<O<`<Q<P<L<M<G<H<I<7<S<N<J<50PәI-
=\^Ð8:(!;`3C,"uo+~ 
0 @
( `
 
} 
1 $ 0PpIՁŁ@$0PpINtJtytsP tm;u< t>]j*|^@0r~D@F	 p!0    t":uN{j @괳@. Bҋ u
ޡ)jcN3w~* ^
ފ^&8u	F;|  b܄ܐj	蟐 P 	/pыx00p=c4
Z$  *8fuZ_j]8_~u@qE	tP3oPF |n FP\P
t)f3f_ ^fh 륐j h"WI0v*u @g3`PGWF0	!	*>QHt  L= t	Z@ &Z饫锻 qZQu}	7 b	ݦr	z	 &x	&	hh	h =aA4B x	@	@cDtp	@5q
&p	`Q&Z&Zd`\n\aW"  !VFP*^ `	Y@W#'U"%"$CB^FV^ /W^4" D~&C~A~,A~3FB~
A~4	@,0z|#e쐤hZj2pj |	P	PЀfsVxг0zbzW$Vf W " ` t&	} w  	M' +%hG@		) C ^hl[j pȆ2	CV%  P{ RB/ 

~$*ZP$840/0N5pRT5RrRVUd#s pP%3W*
$
.
bDP*=	@-|}9t7-
= Mt%
- Kt0Mtb`Yn= d.ޘڙ,2@0`  8&V0`'WR!"{Ր,20`  PPWu/qU h:>h SN  9XXuX 	(Y&pYd q=W	ZZ	@4 |	!@ VZVZax@Vfhh ۀRY@t߀&
 
@ ACCC	л+	! !	@ZVZV	$
r4! + (# +-+tp*tcm`Kt
-o tu] p&3& tGݯu quhhB
h !wu
j8%Ai&AB
磑#'&$''zÐj)u@
@A&@
)3bPf 2p6
Ap>3+>8>G>E'>&!>n/>'>%>#>Rd𝈞:);; >VtThh
	&Vb
 j` &Vr
>BWuBWpqzaV߂
遠&b
&rb  tj
A!@@G>
>ޒ 5@Gz
8ACD0V?&"@EPWeDǙ|#
h @вR#u+C 5 1;[uE3cB"M:"M@%M@tN,B,",1pCBW`:ŐH`૏	6\t|3
xi &ARr hR3/%u!j
R mpE&C&@	X$Qpa!tDj)V3%,aWoT
wqG 9lWBWLRy}_ȶ.!
q{}p{=$ர0%@D2w$N$ǃu}4W"Ep69P8fǢJJJ[
BWZIQI`
fhahN"hT iyBpHgbHUx
fjjGbX
=˱=e=Y_t,0f*q7@t>tb>f@>@oCor
@Dp0k;W0C iHHp IGIF FZ
@MXDW%I}&
ᱚ^ 貜)4`   Q0dMҠ C% 0U"5@0$TТ@
E
@Մ4RP
UE6f2& 	D4
R' 
""T
S~!@E
/)H4" 	lbvޣG" N1p  a1!`d`z@FXnEW#  "^ab@(DW 2 1 Lfb }
n@( ] fDWf^ZEWfhI[  H
f^ZfA
_7v
uva_Za:i0!`Z0ڗ&DC<!>a? @DC@ARԃaa

@PPd
rohr.EcvɋFFPVhe~Rv
WV 
TJWeHtHtHt$Ht-LHA+́ A@!!>=
G<^pF@ <%EN$y'`8@EEDWG``and5g:֊%B

E
!
Ѐ,  WVf+fF@ ؀  FW^F}΀ F FFFNF}n`FD== @ ߄ -  -tR>  - -*t:-@ ߐ}=`+-  ی bC  - t}Qx$Ht/Ht:#HAC 6 Ƣ (` `!`"!13 O" (A
Fy
t)j pPPfsV`?t2;hXڱY !fFgp h*HF)M~ f fFX^vfvvFPvD5FPu63F`.ʃ~%v슅X :uFG;F :`d~ t
&ހ@~@&UpQ   Q q t&qÃua@?"Ht)3 ?? b~|b{܀&P	q2Q>JW uÎuHj 
3v0 R0"[HWf2fNWf W n ΄ 9FhԦDb R
HoW[13P҂8-9t- 	to #`d
  *@fjj a
i 5	0gu.#JN̐
uh оƐ>W tuqfh  P*	&-NRk>n `6
)Mh5.hB63WX& n  F |b rs0~}ScA_ >p#u>p\t&el6JWɻ hv`te3X13
>N*u	> 0!jj2V3t^;3Be'k?JP t'{80:2R%4;~44 ֱ `~@ qFA!Fa"@[$
k}$64*tS?=<=5
5
#I@a	P@Ba	  fh+rD-qpnp$$#;$ %N/0 X[XXZX[PPr ) Z%  = $4&\ ]1 5
2 Rb
b
 Ԓ
 }Jg
P	
	B
 Gwg0p֢ Dt,-
t%-.t,-	 tE-
otYt1˿- t/C DpʣJW:B~AI _p}}  9oUDcV[t[uo&PñP [tu
PH H[@@@&88  00-Ǿ0@ut%Đ;>}` 퉠 PXr}%2hs`pjtXя6 ]HtHt `t' Q huͨ
^_ WV3ɀ>
 N3
 B:r]Z@HP@FPjR~ ѰBrPNpDt Ѻ&@QHPFV^tFj&'ud,j,,,,,, +,,.l>uh hxih[ h L jhN@c/"j@t) <3҉d65P@;@)}r݋F 
h	΢	
B軽
R豬 5#W<B6f
 ~Ĳf\ v3ɉNv~FV
tut9v~O|܉~*Pӿf X^?3
GF&F 	 u^*ۍF؊F%@-Fn"	[6FV N; 3Vs~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|bnpf,Xfffa|`
`,Xt&4
S4
 TGP$@0X,bqĲ汳B0Xt&$\$
!T
5 H@	d
A	2X"%rD@^3D
ǐ%D
tF^&F!u	 D%0$F0&^EPR	nG2`
rcNQ33=B0=I-tX-+- 9߄=-ɚ= M%-  t!M-Q PN P{= .&4BPj[z/ /  Ȼ22+1 14XJ",2  16CB z!"   Π,X,2*,~.X .-@ 3j[@ jhO&ƾe cg` / /  aP7@ qjwQ53D
l=$'G`v !'o]C؎UfX< A"# X],XX$ t&,
v	&<
,
4.Q <
@D\U@ffhh 1*
fhZ T"2(
Bt@e
(U"HBIHb"
Xu
!
$
@B  fhfh
`  	
h
rZ t>
4Zj `F\u`
6  O hEˈF<tFv
h(V̓ZtF V$!FC|ߊFà6V}vMǰE6X8Xu^0Hud`Ѽl ]JK(Y fd#! Y}bfPY@
SRHEiRͤT@i)	!PUDh0J 1oC*Xn_*Ar=U&^t	2	lVf窣wCb_8XyU
"{$U&}45cjD偕CD

%-3 &@+16]8X"Յ4
`k,"o$oL"oN"o o
(- n
- K{t $bncn0r@skan`ncnȾBRbr¿?ؿ`7ak7m mk`9k aj ; AB@ f:- k<7QZd&7X\ 2 % 냐r ub@R޿;](C	ui!]c")# {q (
ݹ*t {{By w`F!j!r|/$ P AbMPZb֣sfPZf60^Pq@qtA A@!b0*C&D&B..eFFCt &Vh)`܎&? t
&^@V@^*SfC	fUnD	n Av
Uv@~~C	
@PZaq@t&6fhCA}DKa~4"6a>>@}Ld|tlT
<fh`z^_h]
q{ؠR3tfh~h0$z"$"#_h!~,@'1&lDh&rg۠>
VWix>x@x``Cl( fxܓDѠDip@
ŨE,?
 HD)~$
q +] $] ^)] Cpȶ ] (] *]ج`ͫ ˘ˑ  !˶$vĄĞĬ?ĺ  @!Ǣ>@X @[ ab [@\!@@ɬn 2 Lo wŋ	~"\fH "\f>XB]$t	SNB]P> .  %pO  dKQL`LCJB<MbK$O)"OdP"GȤQC"GRIA	h-_ÐJ[t
#&CYAYJ[@T&研Z"L$_4\ܠ]Ӏ&d\@0@utW ;>}`  rhh譸Q-0FDX8V& *DXPeA u$ 4 j hph0Q6  t~@ N>` VFZ:  0P训 j 6DXzpu.&> Fj`w&NV"~qXgF#"' Dt,-
t%-.t,-	 tE-
tY- Ht=- t/>>C D0:> ~/t=}p  QX	@Z"~Vfv
 | ^u  8h HvF@w:tF&<:uFF
*0N&$  0/
uӲF ~ uF	 FW
 =
 
 <  C
v`
HA
jq(^P-Y2
agz 0
~ ~ tmh^7J~ tD;==u5>' ʋ@pp

 3 FPPP!WFF9Fr' % -
 ؋1v v s0d ƨu= wѹBʐtʚʲʾʋ~FP.&py ~ tm 5F Ta ɋ RR F  :PUE "  
t@~dtt' n2t"+FI Nr^~u@P_ W    I P @;FVF^ =uσF6,N'@,,'%uÐWV6jvEhhrε?t*:6 faS ;4ueBh߮@B4AB-AB4ABSAB?gBB712BqFB[9  CG"C,CDB`ћa
 Cp&#=P6f+f{F@ @Xf e XV^aEFP6X؎ऻ )Mv3+Q OYoe& t$F   fFf~ sA(GuhhXڠdPfQVȡXڙRPSQfXfYf3fPfv`fF fh  "OH`fFp;FvjfTzAJLθd PPIW@NNu
MssbhE  p p4  V6`qrGrk		% 6|XD6\\ 6/\|<r"qѡk
|zV0Ð3530.z4q_SrhhgSQ 7FXq	HtHt@sYO pY  > tO"/t?Rk h@op@d>wt0Rgh&hPp"?
_K?.'.?L>)$6>FX+>/ x V6RPfhWXfhUV芰
&HXh`_pމ}^	KKt&-+@
t/@-Kt
- tA,HX2HX% 1p !@@TqYUOP0~HV (:ls c׀&躰 >txJtiju,6hlEBQQQsu/"n fo8Qh@@T P#8m%1^8`YQ;}Y< sѭ uҏ ^a7 2  MHz` KB01.32  K    Restore default system configuration mpleted!  aPlease press [Power Button o shutdWown.a <  drivelock   n B C 	ut`Setup  <F1=About>  File  SInformr  Dispolay   Ds.eC  IgnChanges And? Exit Q 	 With	 S_aving  o Security
PassworoU	e84-OnPort Opa gVarious rtsP #Th`
TDJi%DLFsHmaCard@tHSuppP) TPM Embedde.vicPtat@$Availabil P'Hi &O7et To Fac\7(ettp!sAuthentic7%Cre0tial po.csDia*s@s HDDp3lf-T?A/ctiv`  wMem
Che8 r  stallACc72L@2uag9elect lDT5  of grayQ4field Boo*pLbo*;'dBuilt--t L5#in5PPany key1PT`ue F10=, ESC=?Cancel`JDRAccep/=YesSNo F,PGy o@#r=M ]+Q For ad{di1]al iQq @^
T,  ^]ref] ](>BDMsBUH:wadaPSoft Guide. UbAfollowAP`stK a: n^->  SPACE = Nexi2^=-BACK vJFccTABE#dSHIFTa+&*dgF2@M+= c c^J'Manuf@[r  Note ,k M{odA"Proc v΀Typ@mSpeeZteppCacYSize (L1/L2);Q ROM DM BIOS VersrSer E NuP	V`oRRKe'yboYQ,r0RD{nbQsndqVBatN|y 1|2345fAsWra	
fOwnhip +Ta+$(<d
O3O@
GB1CV&UVX:%$ \DZ.   %F[^JErrorjFm% Wal"00&1&High AddRline!4 Al
0nQePBp,⎾ FloppWarn@: is| 0 will 
 boUh?VrsabqJdiskvue  vcremae/ GNin *t@wR| fR0 A: 
eBd~` was n0jEd`c=) U u P@?Invali<5from
)Ayou wantp  ªI?FOi
`e Qs ib+-A(QuickܠL22 (re`s 3 (S.M.A.R.T.) Eex Qmin): 30#@}&g"0%Suy0@pp@by h0 $
0#!up6:1`'t4	QUnknf0qWR!mZv=oReadS)do1)4G \ɐXrib:&`w01d0aP'bG H  Old pNew gifyc nYBEnc8Off OBi  `A E66vAKr)oE  eбw mu@equPdV
r`i.modtQImPcaus胙ĩabJdch as 00п'HӝNpB!a.`p!Ƶ>T@@loss ൨Y@  ^only1KcSoof agoP{`03~evˀ  2\?ZاcGisshaR_ed? `f\tж JIU"P`"TTool VPPr.$F8TH£ BP fѴsuspenR0Rmp`tWSFP!aqvps .Tcb 8SY?%3%,% `g4% 0#Bf p0tndp ep/cunu=(*R5#n)t `izRPInfrPara%xQs ya#MediarOIWA΁mk`n LAN Ambi6LQPn  US}B 1394cuCb0Slo[xgaa3CD- 2e [BPrqQΠ
7 b!0!PhѶr uRf_Q b0USERMAST `~,6pepnTp@0fcaXrY~Qkeep iuaPe GJ phys0&lEsep@mr# =c. `1EbKc
,XnXW Y]unk  0 lmOOAutoAcE@d @8<H<6" A	T[t HhO
JGJ,durEti !Rb1th`U:j1tw  /k uedoPerh8fqdaffP+ba,xssibqmaQpigiGt V IRs]pl r 4mmR ( ru@Ylm,>repla`{t t(@~ 4]B Ԕ,cH?;2`@v`me,@K֒`)00pyibPty. Ifbdo"pw6BESCQxA.R T NRtyp'<'sqa2F10" qBBrm`$`/},*  qE$ MiBgg Orw:S ay V ACdHSDPAB (left /h!tetqu3vSu`I ZipdmFir @o࣐F`th ifp Ssixa h E!|NhASwap Fn/Ctrl Keys pP җAcU.S ʠдd0cLegacy 
(p6y,<2Pr ~pry Vo a NTSC@AL -JF -M+r`t
BidE?PP ECPd2Asize 32 MB 64a FVAlwaynOi00AC ~veWWAN D Radi |hBluet h@/rS;ch1A Sav~"SATA N KD1CotCCPU'F CPge Agqs#S`3X EPL0"12-d/)#18}@1NetMT KEqn`m1҂23TokR1H 	r m3õl  SpPSt@ TechnologyrtAfUAdap'L0PXE RPL&MPo-pDe7( I0 10  2@ U3 4 5 6@7F9,bYF{125 15@ 3 (Pe@-sl UGTopaWrS NonBIOS DMA r(Transfers VSan* z!AvQtk sFa]2/ mu˂CPbomo s p!  Psle![@e s1P1inb  C dRs e0P賱0 V҃k $ 00.0%le!bi4#Errwdv fy[e R ı cycl\ <F1=o>Bei Si ԇ`|OazeipgYein{lluePP B-kguAiKgn@epd \*nicnehspe ppV/%#S"heitsfunkq-KGenn p 2chalt(OmAQluss1Vp4dpne s.`'rs-ID`@ -
H
O
S@~i"v Usttz!  Շ0>tifiz #  beim 'st\TPMteg"F*tu<7nHsvorr1$"fgbarkGerts m!bnNufR3n zurckAz!6OB 3Xp1@6@Yf_g{mք*prDia09s@HDD-Selbs00X) A1v3;E$:pr4g  < pD =+Dra> swhG3A 4"K2gran FeldsLrtA-e; eK c>F'%hQ(i`<be0bQ
Tq, um9 3fahC`=A
,q=AbbXWIkzetTJ qN\e, JY	=Meh dmbe@9Icaz fiq\0?AbPQt 9KW   AAware-cYoft hmb P9wafolp40n KyXrron:x-> pr@D = Nch Zdnd<-R!;chf`}t-`VoAma'GTabulOators2* Holl+ge:_bmJF2@
28 = ywEsc}lEC側@E-!ll@oYz  uypRr Ntsgesw#i!gY`a"1dC@-E-Gre (L1/L2@EGkapaz_itt P-@Ф -u`אnnumm GrafikR@Tx;`gr-xg!wDesk #-E+2ps0Ck	?8	AkkuD O2OO4EUp_ɠesih0q3(F!k  

o1
oQ
 oq

/WIHd :u$hQi .   %'"bjDr!FeearKH`al?Zero-T<WOne vE0dހbAllPPaurnO$Bew8 IrqM:es7 stpYbisLTn@*  ZiEU,-/W:BbߢleDq_b@_or ATeib>p0i?n LaufM:nf6
lW&ge aKv/+Pt gl`2OL_  MDwirkl@0#  qQ?C$S |ҋQdapь
aie! qQoca
۟\41 (`bn`I82 (UmfandJGQeܒ&fhXdau(Min.): 30a݅d !`%C%`he%O=wu=oGpmp%uFbr@BrG: kan5H	P2aUnbePK#7d4'rvo-LB6.
4Cp`3ShafAttribuHID0a3UC1PS.M.A.R.T.%[0\BQs Neu0s@N Dead§ usaJaS3F/t FaQl9g0?bAfPr9U"4YbIdaDurq<as pesSV  m	g?qidXD!
fQF,L0 +(  srPva. s Zh?C6Âenlust.hb 1sENAnup 䂾@,iceQ-a@s ,s`&؇! Ц B ha0  crgaD	 :	 
Wۓ? {Um FunP}zu , meFYӐjHPQztectTooSec@[ty Manag3v	enoЪ?.F*c1|'QuickLocmkSund01 &PrqM PS.!P#,$biePS0Übkc?hutz  .Adminyo`310h=im$`& "+q A)d~+ H* WX"d9;P#, lsგv :QAm0%I J@cpґZ1 ot-Par/e v:-]$p 1!~7Wake-O0AN L t  USB-PF1394-A% : C<Bus-S@+k9p ExptmECD-ـFee#MZrvV: n %3:md"riveb/Fy@ ABD߁ȁ]E-#F\s m \@GXunbraobar.D3I#T
h,7'bewFLs ^Ta",itnc )uX L.eQ, r1h\-E,  ҭqPcɐDn<Az 2³V3^Begriff \drautomTx~ X76>BohlvEmbedde*V'{}pE>Zw@knUa8@n 1f@&`}%2 [~,Bt bme n Oquf OJ#`СPSN}a!sf!sfemSvt"<sEvXc Aߢ"-%fnDTBXfgOgE`yagubT'qSXūs thaa$B һRŕ 3#B*H<@w  mZursprnӝHD . Esdrq@empf.ч	 d=qzuA1OL$`. _S Е 2s, . 0 9򵦠Q 2 ⶇ 7 @a-BtDenԧraI:t!cant Vf4dibsc-!&Kk&p?l kW
!'o'Z@[a F10eHrh:v m`80 sD l` vMuBayl Qז"IU
k-E! (links)Qtn"-F,abSuBZip U12 3@4U56 7@89QFn/Strg!xtPo%dEaC W (USAЩf-ZePr B@iebssunab/hng`  Dr Grafik-Contr!PrimSek¡ Video- 1gmn4Bidireal GrUs LKf`ipCntzbr WWAN-GfcBluetooth9UnBв/a EgpaNݰ SATAeDualcore-p LAlaA!s!BAkkAgssu6!%(hs0ha}CX-06(o)u`! ֥E@ V7U 1O	203,>To\R CF) 2{}1nAl Qedpp  `hnology	xLx=0
adapQ`p0m2,zCA-!ppoup ( @.) Πdau ԑF9,qfF12eZ IpC IOS-DMA-2.[borayPR5nn0kr T-c2gP7ch emPG5d0c l` A.DٗePЕ` Compr wdVorRa3omRloЎB AThQв"Acibp1YbʲCtr`.y00,0 % abdFcLFe rQYm QT
jA|^	s Zufp{sdM-Zyk opstn <F1=Om> FihSloOplysV< эne Gt`ar$1nUkonf@ 3gn\r nr o fslut Ar 1F
 u]akg m O@nkkd AdN#kodr#K!s\OVp ?hPstilЕ!9h``pp `  qcT0-id Sq	/
[SmL-k0sfwGoddel 'af 7pdO_  TPM I?ndbyggO""'Re
c0pg0zaT  Skj	_ Nu i{l A fabr 0 UAst`Sgs 	7fq]hF%@#+HDD-selvtƠð<Huko1	0 ;ѩ!ainҮh Sprog VǰB 怴mo@/nedtЖt!p3q{(#ErE2B!oA=0>fTryok p$ t0@?F0R =
, ESC=AnnuCFs!ڤ1,JaNesj "O, AQ=M0Om'  YP&a@r M7Z nсSetupy pw!|du i1U _i`jled\n H \Rsoft aru` 0XU]
u: -> r MELLEMRUM = cNqX<-TILBAGEPr1Ԭ* TAB&R%wSKIFTa++zF2@	Z+ = Accegp!!jduc yǾe0c2-typ h@JHpltVce ?(L1/L2X9qo   "psbx~ipA<reviX12a-cDa@z-ba WzcBAri 1Ze2o3o 4z@et-taejи15(=at)	OA3OWITvS :u$ T@Xt .   %YN] ly`!9f0=mis`w 0'st`bD1I$jPQ tnjeaqd!vard:7 DeP h!r sl!%alt`tP2L_holdUAXo Q`/0Jskab-  `NxZ\(਱ k1kyP,Q 
v A:ܒ  blprfxfASU?gyldig/
ffraWAltm  ngiAvrb`Ú n,!pavi H]un?O ic!?@ K"'1 (Hug)#(Omfde-) sl + & (min): #30 "8ٟ% fru'df`"7nsřCqv 	a_fbrudF t: K0Т&Bd!U9CSx")C'$ervo(Lsribut: IDt01(odq?QyY .M.A.R.T.5@Ay1FpF9X Ny  Bekrft nDeaCŦ Fra aAk1: !5Ъ		=P@spG 	0	ry  -k0me, K	Z`es, f.eks.  `pbܑ apntific	@ǲSHǅ< bTata. Du b!un  J flUleQmZPv@	h DYC	X?eD0pTb "A($:ЫHP  tectToolskK Quick pauLssNmus*SkrpPϫamg ,r0GvƠt hTAdLitori8sAa1,$/`H!'#qno0Swۨr, odie ubilpK2"Qll p plr;d Par|ivlash- 7@POQJm@@sΡ04 USB-e o1394  CoBus-sloExssQ$C?d-rom-и cY0BG H)oP2:Be	Au䵇Ahy1EW@eǆ.  b+BRUGER-w OVEDADGANGSKODEN,:`\U aldx@Nus InBi ,opbe /P0S 04&#
{	U8
E# l nTL_AJp\+hjl}pPAutom0DdEPJlejQA`TfSfu6 perma`anv^B>ig. 9}Iyp:,'fys!!1cArbAucompir.`&EDDLQ, tN
s   la+EoplKni@ @ukW#E`Tm0,1 D#-Oda_   ӟD~t. UrdSm pviQ"x0l/cl rkoaӹ Bπ/cY   xbefa=l`<krafpPs,  'Bqˀp /pladЌׁua}
$q"  &cP.a#v "KpCRr1Pd i`$HuA
ybQβ.ю:OtrE3SC. 4액p`eC or`K 'FG'B@e@F10FZ 1Nsg
j/c`D+sie 5 Dk `BrЯwgnOprR-#|pIetkrLDS@-baz MultiBa'y (Lѱ)/%hS)}floGppyE!c#|0 wSsuSbTziprFrЏA1TredjƀFj 0e SjSy2W Os Ni ̃ Ski@mqm F?n/CtrljE lw(aci@sk)pegeen`UQst0!
udPnPŐ"rm-cr Prim Se dz Vo Ou얬¢ Tj`StrL@>1ohguko nэ BB̀p< t6n	r` kO^@trmcgt WWAN-"-spioL_Blueth/A (trodllo.netpP2	@dASATA-n ~vDu`1Core-CPUArS0POi Э UCmsty orh @[V".00Gtop !Q2b&2Ethqt I1K23KToRR H$L	e+	 	 c ="X*ёid%Jv.popupT00k"{(0.8s9,!UAF12[D=!-:B@[begrP;pzaʐϿ BIOS % /DMA-r:b2$W 0( pa@ttF )l@ <{qtCc,<qlu "= P(#zprocesAap瑀rl.|
e00,0%
DСodfejl2spfic Rlkrcyklu  figuK;masiil`qin>asjonVP" HQ´`퀛o4CkEk1"A" Iv l  UR$,la X L@Esgr tp(tQ)@)h&A|P gKZqmBB#tPb(	5-<ۗfunk Sm JH` v|godkja£5+TP=Mpneby H^atusiytЗTilgig
<obake?fabPtO  [7a?iagn=oVkk A$"lpvt  AսY' MbT ЬPbBˁ_= Spr Hel[ Tm5BE >pndt &0eln1h743E
ury$@T ɱV2Q13Ԓ@=!,=Avbry@a BʯA pJaCNei j p&=M`Du fa*`v¶ lSysacbmkS (9Eipl i a-Qadokum`^"bQw {b```  \`Xv@-> r MELLOMROM = NQ'18<-TILBAKEĀrAn* TAB&&ySHIFT++|F2@	-= Go@i`#o  odutatb@k-mllvsegtyp  hN#edѸcbuff~(L1/L2`]MQde ; -a-y(up%TP@Yr0}uS,QkobsABW,aoKTA@  `4@paVs
b=brPC E  >n-%(r@p`bk JoaoAo
dIXRX :$Z.   %\ ok! Fep3R\,_i  "Wal1 0s"-h1jH w Adss пe7"Ve Pn0 Ad:  !0@Azhocldp HGa "/he	-,pŀJ@f$ sPA/klḣnnSpҰA:e1% b ҪregaWm Ugyld"Dfra6q	`)fènEt hxDpZteaen? kcaF iate?M  H.0 1 (R: ) sl l(p): 30x!C`gr ?% fullX ppmvQEa}Qf7: 3Ka#utƖUA7$c%t%0Vo(Les(020!+d0trib`: IDv01s=PS.M.A?.R.T.-f`pÎE F  G̀#Ny0Be0ft njAvo g P3q JɱmP m v likt `` 0Ý2Q0aeaoka@qA3ogsa$wՠgliudaempCel`Fhΐ .
QZ/"!rQ
a=p. br kYu Y  $mP Eベ!&`vice.`uB_?ed(Ф"W 0QI  
H i HP tectTools3curity Manpar.'-N$lq@ lanq6paPpus LsRѵm9Sb&!giew besk02AuR+/- +ຢW%XA  . fvgl`p]nosh,"x@2=$ppQ U. K$RmEaAs0ord- ParơllkwFlashiPPia LAN Lysf O USB2!Cpbus-k(p@qxp(S wCD-г)c[: SHoW2:eGp ЀilgtP(1E h'oسт9 b`BRUKERHOVED-: GN umu@7 VEBi+I12be Ⲅ@ \tryP
P   %$6" #
W,X`A 	'P7Y 0; 4,OMOEBvhjelpautomED!Loc	k 1!byQWdVg PhE`!0oig2Pd.S  Øf b rad=PB$ՠC-or 0C?	|@u/n(P.@&cJA1s 0@dda~. UpR2nommP T2Q@V0YX`G 
:iPneaј:# urWP. Vmnbefa{2 ө G	Q/׃XB} A0k1 Frד`<aoo!1ra كI7$0%0s}0A!Xטd!ans O@E⫑v
, QPEGSC-Qx1 @Bx'Dy'- F10h[bòe:iĶ o  .1NoriFǋOrwe MultiBay'^s Qdnn(vee) Юko.ngsb9a0hhyOB}w Zip-U
Aq A0 !ba@Fn/Ctrle E le(USA)e pekeen`!el` !jermtroaVideo0@p
Tis!rrbp0FViA7ti` Ԑ01 m`Y=gradi`/~trdl |t 
WWAN) OOHOHBluetooth /-ft mи"1|	SATA-CDual Cor?e-pros$
baroi Ag`nss Nsty>iH1Z k.1+Ġ-e02* (vp,c4b/!@1 Eth́u?	n3	3 `'qR1P@N&s0 oo`o/
BD #&KCi2;G1 
P`lx9XC ($uEr`B9-,\]F12-[DS*epute P@FpR?BIOS 'DMARrpĀGQP!ԡ^ 9R TilQagsl قEqs QZA!FC Ȳ :@KɃ׀F.RAj00.0%pll@A
CfFe `{2vQE5Xk f`[sykl`r Configuraci0Gm`adora <F1=Acerca>~rchivowormel SCma^qШsR@a2PNMfdo`c	bfa9 Ign
 ambios y@ Spa A
p gu7  GFnlepidadA@se|K`ciobF1posis_SI>дtific e  "}!ĆKskSm:KC  So݂c0#<) Secty `P9M inc.da EOr9b	WponibilteegofaOcЦ c3ِ8:1fbrp)6cnci@]	cDioagn@co*nprueba HDDc0+OGV'M?emoriar	a)+mPPkAap/+,`.i ; 	JDD`L#= rDamp'coK grI
o:.o?mW#i>H<8&g,rim "P7quiqfec0]VGinO =],A=CaP5lALap=SSNJ1"X, Coa3	=MsBv"fy0obɻd2ei</10rav&Pe,ds6m sancn~SetupδoGuXwadoft . )U@s:iRkP0Y y: E \ o -> = Prxbv+dReces<-y/ AB S	3*# Mays+#1C+/F2!0910`tGs $b#$vuFaI@#el[)\À35ΠA@locVUGuWXTamaAlh (L1/L20 OF chu$Hsǐ0 Aร7meraribhvil2vqMrܑ9aB\coplamQ'`)/ !e .1
I2
3
4
2s
qlQeb{oodEtiq r@pieԉ
I+K (MabrBasoo2oooo4oj? pn:$  ?Probanup.   %w(rssfuErrpQa ;ll2ReoC 00PX1'	lne®di]l+
(#Co00co oFlexAd`:W EѢouir  !eǖQ3.Chhcx /6, 0Dsc e cuA:D fTUu00P| N2qޢנ!련
S^`vpus"(I$<ԠJ0>o(a) PC!@@%w?,oe il@ 5
:1 (Rp`).;2 (l QF3 (S.M.A.R.T.) CslòtieDej@R(@s): 300 Vg`o BT0%0#Db f!ȄEЦ%B ipx0Grrumq
دbH: s,pu @qIS`>nh7S_ervof 4>0Dapoyatatrib`: ID00abRexws  G
X0Yi0"nuev ZDPӆ Apa5gE&S`gODB".		@e@GvocB	b6!ala 
0c Lt!ad ;Ѐ>nsa ے"][֥L7 A*# \ aŋֶm (025o,G1aipUs OF Et(?LL`hقrp}S"f_ Glཱ9al ol XnjAPievjv. qoq  '{v?dvWapaAu9ڱGHPPctTool )%6!EQuickLockQNSuspen! Blo^ratS  6""`nMmeja< :0 +-y	(BI	( !)(P`0r+lg Rt0,"D,0X𶠌uPizQ,. ̔xHOre PunC  rojo%lpWCMLme@7hdem Ino Wake-on-Lanns3luz | :g	s USBE
1394 RanCnbusJEx0:s{rd$qC#D-(
EeQuPc.ChUPr:avPUsio:a@uW5d` 'diDriveA0!@"( tUSUARIO2R PRINCIPAL ѕsoe lp&| ^aSman] p 0. A; y gu ,@~`lugp3b  phj1<@mpgQ.p6.Q @d e`lGS1
!A=bDvab\ppF. U0"hoau bEmch`o@;]HmbeddSityBI ކWcinb   BlO1`PnQX wDRnAd@w( R0עhuhc}y#tGngBn ,@l,Ρsm%m}u@tebooqj<N, !{osBtQ#bŽ!K !=b`yJ!u׀[D0aA!Kcub`\t! @ qШbda`?%k	,b bAgr gِ7Se 9oenf 9Ed 2lic`큠܂ re3az. ?k cu`q Ͳ>Ainҟ#˨2CtTB"fi @[`
@|ܩixpons2u9`, 0iِӲ ESC. `"Ԩ08b'&e's  ,F10 c:L&2sqfМ ŧ7CT/qEspaol OҺ`uMult'iBaBNPb|pxOCDfMbbco+(iz:(jech-  byI0AEʡSu@x
9kdZipcme0ᯀe Te]rIo C 5t#jp x SjOv No&D Cјus Fn/ TIngls (EE.UU.)!aWӱqmpplSo!~ele$ b
b_ a"Ac@ PGְeo MoPu0z~!  BidiΞ Tam`&CmO!i#	si0fuБ BSICAHRP1 WwWAN cor1L BluetoothA
1{Pyqho#ergR( ()yn SATAPUnclepogNp&zbaPsu`	po0osrj nc B7^B(s!3ior)Ethet, aNT 1/,2/L3/Tok0R lO(Or1	23C{qD2ԃbl21- Arranȑ.^p@B?`c<U_D!:PpNgŢPZ P8aH@F9,m GF12OJFJdpJAmbTouchPP o UN`u@T0s#r DQ DMA~dBIOS L~iL5_@6d}op4Cclez½o R4 lPYPersKaHp|2b`<t0Ps8`9.  Aأ`ѐaLa aPO%Ẃ;CP0qc0Ⅎui	N	  GrPs|
$ 00,0%rOletaC  $AE MgavBftFCic1cPdGՇQO֥  <F1=Sobre>`UruI-nԇs@S ePE`$G?4padr0(ˇndr3	sIgn0crp ``pairsp+'seml'Bv;UQna n	hDa0dgOpzar v0~qsW/t  w(@_
@j
&Q$SKt sd⑅O&p
"ƿ  TPM I b`'V`KRn`*6_aS7`cvA
	R@ -U54fbr瀫fautq  8Ij ף1lj[a lagnsĠ%TNGoHDD 1A۟ VGrD?e Mem pPA8= q@ -ciBu?Sele+isx8 8ampoinzq]`G44o?>	VUw
!x;A+C% sss kalt+in ='oSC=CelAceimNAKR, Q%oup=Mais^ o!b\it]t
Wa@vӁ10,sL  seeePSetup!KGuSHBwade Soft UizPsqgw cr u$@0 ->
PAO ?= PrxL\{<-QBACKCEp#{TABP&SHIFT+ !(* F2 	O-: = k  9n`ULgTiP1adsRbVcPPas\nhr@he1/L2Ԧf>a\ ROMAs s N1BWriXVReviAn' m!Aۚ
OBp 4
#cEti`p mFj'B(E epsono o.o	&al fd :Bu$@B}g.   %o0#foWi a v!'Wal ޾oWalkq 0J g1i	apӶtenekl ƮcҫnqGPP !ed0t: @  4edOsac0*VDò/,|i um Lvpu: ŊA': n@Ad N S3`p@ jO"肣Ca	]
 v!@և2ztaI= kTctߐejCa $,C? iӓ͠N >ߟc1 (a2 (Abgf3 (S.M.A.R.T.r>xecuqz0(min.): 30p<%andAB%?q=bucedeA@<p!hostDCRr01#: I0~ss-P$Eg
Che(*armec9 e l %Q3sbPtrib@ɁLD`0^!Oa xaa`Ls waQUUig:Trg`rƂl Ls  ѫLBhaiPArr1rDig@А	sQgp6S%`GQS o%@modCs5>  faz rArACV QaQRs, rigorosa (S"9pcurity)`4ҾrFAfJrPusafer0؆.	 Woq~S]1lLa o2mrvios. )I1{o`&qZp+QV6?eeWPrpk
8ЁnS.e#QuickLock1Suspenso tD¬$u0 ttaR  1W%1n+ mabpdP}0b%eI GAd0X A,$"""@.2Pۦ sa giUiS, o u3sewu s0ema@ExigUJre)PbO0SP 0perme@$Ql0r5Fh0dP&re`a%m"rNs0Xuz ambiQn$s USB1{39SlotCbu&ExHssY!@C#D-1ԯGkP!#Fm1e:dZ@usuAM: Vocc0qI" rҔuRxo0Drive-W WtaqIWUSURIOJbMESTREi0<P ,@1?0D^``apazB Í. An6X4@de-pA$V`is`I3Ep. N9v@ev/w_ ,!` LAiS 
: bB*f;a Ldef[fa5B.H'7{ \ &H. />JЍEmbeddedjho`B
e (1Usuvz%"pnEuo,`$I Ep!a%g,mߡ#́kʐE]RB:a1)X5n   2xqu2=Sip`R`'"!d^ G0tghP岋] af@A]P@, `<aF  4boPPReFa-
f pSRcat{F sub tudC? h&3+Ƶ. -l BKy2XLs"AZ  Lembre %,HvQ1Na+ÔbӦ
@2quiq`mpe< ESC"v`^%`  Р A$Ӽlav
'g'QrF10.rbA:Mr*T°AcV]S1a AAugus OЏѺ˖: MultibayNhdƉD2wp2pbBaa byaPcopld(RPditCRbh
ziprimeir"rc* QutOv ߂cim`InaтAs Fn/CtrlCIngls (E.U.) VQPip)si !1Ay SQhpౢ0tropaCRߡde`xcund a @h LPadrBiQTahOmem	0OBywsempy fuw F>@{ec0CAR 0lm sWWAN)` @dooLokBloothkAAnڀ(a/l EomCEnergp= CPU DC reg.rp.AWa GereA1aIg2JceG21v932o57suЩ070Et0+netg	O `p
/*3/CToken RingOO  oSflexR8@dapҼ9Aa>`hS@PopupW`D`y  3F99,i0F12*9L duplos Var7Na NumV@{s#!7s DDMABIOS@~@es o{Pop5lez"]sbl Id0  PersqM!Eropag1!t RT@xq ys.  A2eьqOG  mC PQzA
	
	'R"P
$ 0/0,0%lOx	a Er°g+`| oif< Cic0eatbA0vTi Wk 9/tukP  <F1 = ja>b!wJrj!lmtQt Nytt v tu`kP PP0 Qo
%jnskon @lhN` mup	 @=l0!ta Lr 
 tallma	t7!WT^Tpou] aurplisu!u/Pan m1KWyn1yMw k La@tt8%Me@
ila.f
p?usnume'- 
t 7lykin  "'
$ nn-u`kiG
' TPM Su#etC0&T `Q0Ǆvy iss Piil's1e-tehdf3fGH" 3t$&j
8a -in`s'cKi`05v`
;s O]t $0k @ a5np<h:m*@G;KielQi@ePpk Nc  ha:1@1/ (2H..2'J"2'C#a!SistgNJatkm	jot  npp =$
,=jD@ơ=Hyvksy~=KyllEi M, JgokuJ=LP@XY Kat$PA#2-[JDte@o-Sohj[ oppa
a`ko+``L.b2&aL`3se`avmiل ->Yi VLINPPINdSd[ <-bASKELPALAUTEdeN!/ÂrSARKA+$#tVAIHTO+0',F2n+_q= 7eQ s"11ajw'io ]ASy'yppRIn cP·askhVx"=1/L2#>qu  ROM-P-vQi%  -@s sar;jaa Vi`]Ndst%abko3jpp)0` `)@~AMk01:b2o33o44m.h q| p|y0qv.(jCoa)
 


\	PZ:e$p\\`^a .   %_c lNp!ivirhaʈepo3i Walkq0 -[1Yloso@QgV?aihtoe@ `Zuvio^'mkkeB@̀us: T-0lGl@T!patvnhp Ns. J` uluoxpzuos-  n,KuirjQonc -pA: L"  eipvu {C1 1 #70A^VHv-ǺHko{E@A:n?kSa r`  ?b/i ((QN :2PQaW3.M.A.oR.T.Ar'ѬPi(min): 30
.%s x%L<d3 Is`Q/ pysљi30&ke ]V8-:#voic
$b%u( ;K*jServomoott0g
Lu7?ma*tuќ@aka-nribti2`P01@ca 6` KsetQJJ=:hUusi Vahx`ba DwdB!2A"+p2ua	-Êk>p t/ v y4Nk@=smys`TPU,,kn v	R$ۡ!R ˀ}e T 	a
@p2 W UOOTjWF7 un!nu߇!kyselvelpahtum`^
ZGzabEJ /vii R⮀7HP P@ectToolscuqger -apu3a\.#6iB!lQuickq
Pa hiirlPVA1(F ]raU '
((Pek`
U$AiT)@xdAy2!apypzyh  p ƣ8&#5Q en R.6ad:uuA0|t	ASAporK_ InfrPnRP"akkais@q |"kБm4emtE5s2lhr` tB1аx@USB-"`1394 nCardb ti8 
LxprlCD-Ѿ-l(( ąc3wQ@%P:`߂Tj<MWAiot'Bsn DeC-(u4,)0$:.P@O"`' KYTTJNC10 PSpSANAN,0f",s"8m.raA- Ԁ(`ltcur0Qm  0]kaR0`bՀ/sir
H.Vn-`P P,~p㖴u1wLLA(gU0nuOW5y  op}s@ %V su`mG2?E9E
,#tuHx	> rr$ Y
 U 7kUr
\'~UrsM. NykylRJ`+RKw00b,n8|
tp`Y. TBxtU@iІ`$ãihqeip=Puper_D<eh? IPa*?-v@f!etHta_0h=c OAojAaiem  wֆtz. є
V qym "3 tbTV@G. 2!`ZX{AF_`fуPĵ e1v w@ o#\X c#3,aTESC-nsR;n,\'¶%'A>!F10Y4aa(:	o .VQ llіxtЁ Ȥys uBbn MulotiBaOpc&06 el miuU (enXa/$oi) q䎂b)aZipEnsimmr 0BbKoelj@}VIi }KRie!mKakp 9Y KymȁaiP Fn/Ctrl"m(ΰEng`(USA`UsP s  a!ҡ-R sѬ&nAʉjBs CڐPsz Volhppq kios2sNc0Jg`uu`ґH Dl Ѥko WWAN-roHLOBluWoth @/F@hA`L%ի-sATA- @s Dual Core -saFa"AgpU VP@Ws `?P}0AGeb 斳31BiE\62V3- 2 (ylosP2OGC|O=Etherp(vn9E Yoeo3o@Tok_gOoH work Q-G {8E޷! CPBDP0Br7 avu']>P `i@ 	(?eoI Q@NF9:`k:pٞ0F12:i ZPatapp=iqkoskж()mK`i mjn BIOS DMA`iedo\`>otf uhd閡! p"Dp}oo Nope  ParaMuQ Tț2!w kki1 `Var`b6o kyt tyS qNQba uho{c9&㘐Qle$ 00,0 %Qiuprhe tatark\ S1n1Ut  asyklipConfiguratiordЕteur  <F1= propde>  Fichier Infor # @.v ,m/Aff Oage R1urer"
`s>Зr df*a c	w duGIgnc#mocdi t	qu1S7pe l'inP:auvegard;ns{regom	\ Scu k8+`e
:p so$@s `a6rt		frecnt @NBl'$IDy'A3
Fq ?SmartCpUr)r * p9h 6  `Ӟb#a +3s<eTPM F	gre ~,priphP qubDnibi:?? Masqu %)#H
8f+98am+>'u l;X?& @r"#c -ta @0c)0s`Ni`1LAct$ᨢGoV6!?mmoir@}c  DO@E!JLang ChభH 1Ind(́mps gXH7d-rU 
Z]\V#,5>U,Ap7puyDsuQDg7oucipo [ub =Sle0or, ECHAP=A@l`hAccep\0=OuiuNA'#Q_,_ N'imeW	ewD
=0nK PQpp0i
m S p, ;rez-vU0Ys`mp r- kMa l!lǊri xplogic s. U Wsr3ai -`  C- :-> ou BARRE ESPACE =+ȣ ~pu%IE|prece vTAB`Cx*'jMAJ+iXF21= !v-#!&`abrpz0ModeuQVab0 TypvJsV`rwXwDbiS]TaiQ'0ca1(L1o/L2)@luCv4FD` ROMƠerg""Numro^P#
Rv Evid1o&qp8rRlav/yoc'auF"	 *2rbe	1/,I2/L3/l4*1iCҫrita[y/((N`6te)q?v0 .OOOoOOe Mii E:$1q*l.   %mrussi ! ErQrq#tp ^c;^Walk0}t1ligd uQfq*nC	odalppifSHg~6 A@ti7t Ca;ePrtruq}a!npWniя&PU`csn񗆦 /!a,) z{ 1՘Pc 	dнr1;A!]@4av
 tro ͠c
 @s	!_ [RpIabE'J.On m:: XfinEzcP"aiҽ{l |A?O@-?+epO>1 (rap`)?2 (clet)u`pexbim@C(m7in)C30!`s CR0% B1mvD;0l'hA+BFerrqF: Gw	Hinnud1'+,voS7
.Lu( 0I~Attrib!QQ: P= 0 oSppk"s S.M.A.R.T`AbanGXY AI N!=aPYE.@7\/@;saς A rP vp KS n';A,(frgco cc 	oQ;mme, vz"I*re4`ʲT	@@^Μ
L`a?pe@a@"cR,s"@u!s1u@?i_B" OVo.,r0bPdpLla ps.Ԅ8z!%ͱpa a-v0nou TQ0$ȡirb.gy	 	֑`ULq'ҮfoncnQ  ^Fq>l1egaQxPA!hHP Pq^Tool<e	y0r =%:/_& ckLocksuspendb~Ű0!ri; E3?S^&olA'Ѝcb qCc8jM)ad@fnur,  x k3//  / L' (Aa
S$
ud!v
 NP
dra+soystinpq8pQ`ZExip)Q@Yred%Pdb  4ra Q8ll0F[flash񯾀rveil"appel rsP_%a#pi`ambi0C	s USB	139U4(n$C@b0<xIe ExPss d C#D-'E8bpalM^@Sү:>?&DɎE Drwive2. SII"J%Kq!dez "deux+(UTILISATEURXPRINCIPAL)*#N	Ф$alori*% N`Dz Ra`` O!!P,*tsr biffe9celu/0ՓDordi 0@s3. AubY ZV@	 (`{W_2oz Ifet c}|E@"0t"~"a"ɣfaD"!GoaopVD [D""eR 0ݑ^N)eFFSanr< `m5#'kH
U#!2//r,B=ϻ!u!  3`a!$! !!{ e`VW
g%
uPRn'R123^ :Hp" "" #opa8uEb#O'}oW'aRi+hw#1originIlRv`O2Caa$ B	u(
vqS"apAQy9ɗt0M
5djavs[oPbce*-$WqaPprs Н ע ?on: to򺑿Qa1ө44Z0pPZabЂt3@k
Q7j,a|uyPK `  ?ECHAP.  hTzR='o', p"CqraDF10Tap0SXр 1xCxY^u}	Uڢ/  FranaOgrAC@tЈiMultiBayul AUR.d2DX,/%socqv']a(ga!)OOFy)m	q7Q&W
jZipXÛ : D hi t@s QuaQCinpSi;xi Seȑ  Hupd NeuvCD`Perm r$(s Fn/Ctrl˓ gAngl0SoA) Pph@$ o1ms A`stanlpàhnNd'00adml!trlS'Tich@&m`
d 9ilidoBidݒ/1 mSmoVlb0@j2EKal ,$Ӳ R o<pr~йWWAN ( @0il)1'gr
LBlooth7Sk/?1ÂPo`$c0i+f @A&oPldoyCwhar rapДmbaSSuG ga^u 1r0WPfexs7?1bloGc-noCB2o
oyu{ @	=ccuodogB Et* 1a,23TokRingo to/EA׵Y:b\AmorCx=5 RetpZTeиec)<0J F9,pnqԗF12.\`apkos0fJix)LD aP?tDpCNA
cunXxP;0BIOS]mQHDMAOaQ@4@T䀡j   jr R6 Zs@Hs va6AsJ$P!Ԁ\fѓl6ѥVnpk QJlpA3cpְÏ	нtruVh	»ֱuc0@ơ% 00.0%aE / I Errv@~dcfCy0|mżalatQc Ipmzl!Nlt <F1=Infoi>p )qemagwisuezza<yRipr0
 faudgř0` aIgnocP*! e=d ci EP l'i
`	sa3lv SQ	etupa@ep 7ssw ҿOC	[ens_Op6ֲpZ ID'8` ID 
h	# x%Sаt CO Su!pcpTPMqgp(S@oRvo)TniϐIPtohe Nasc04
K	)0w7p4i? fabbrpp9	!I3Q2nziPb#[?caa4@`$Rai
% qdi Z(V0R(a me qiAW `=O(%IDL
`}ue 0$Dim@L6 r6aܰsso  eA g@v	v!G7oJ "q DI x9*a|pkalsiaCta$qak"u   =, ESC=AnnuaADteo=SiSN1!T,altro#	=A bba PӰP|`u! SQS,  v`]XpYt=h  h!"OGuida dwq\uoftޱ . UsQeseguGeAun'e:-> o SPAZI7O =suW@vm<-pBACMKCE@c18G~ TAB@C'oMAIUSC+)XH Fa2	.=  Xm"A"I}|e|duttoAAllo NPboo@_Ti
1VePSHStepp!Mkp~/(L1/L2dBD@CROME#a  Num!e(aAڧ	Rp=cVp'4ro0qI2"erMbasGaggancA	~Ba   D4bG`M0 PY  P/MpcѝPq&Ʃ(G)8	2
3D
4Md:$ Ttjzgv .   %OIupZ!·0Eom|lTSprbbit 0 itQTdira	U T`e ['vFlopspy pnso:fD=ŀgger "`uTNch`cA_punS/rR, p  -qmfavq f	P q_'u A:, UA=:@.n  ú0o ciuAN0J I

qQa UNl /YPIO1y×SeՠRvoMgu t2?oiepbRb iwure?oҠp: A?051 (Rap )62 ;(Clet"uti o (): 30>% B56a0"3'hD5 @CA:3sB@ᰇ-l'峆PP (DB-%Aervp̓")L,!0BQ0'	 rib  i0gol:01NR7anŠdeg`Yi S.M.A.R.T.uT0UHvecchfnuo2F0`q(`#U#L c LX?pbi)dʲA {@v! \Ⴊ?Av)6i%  iAmP+AVfASaWa2>K<ng0M"	t 砶`eq^Џm3Cee,<#e ~'.!R^@FovoberdAdKd@ xEff+!Kizsoin`ari9qu^!0`vgaO. Qm 륺 %psn@J͔r@~uQocq|eV1pϾe HP tectTools &/R2y `
ick0su/spen3B#0Z mousп8 M] (X(fO#A#Ъnu p'!oހ&F0 `e$)B
) )@0C4t!`Psm]0v$aa 	,'DUv#Sari lQNR<(|  RVa0  aQ)ǰ㊒eL1`h pa+shmgnASQ.LANn_u0Na!	e USB Slot>@rdbus@S ExssbBo CD- S&,dHf^pp":_C!S`3rqcusanD e..C D>NCX  r]V[l'UTENTEPRINCIPALE  r 2 v!a manqf;fuŀo.	o\VNBfk pPzYp_@A)e1JDPjBP4. l`lPaupUSTj䐉s,fh	pu0`ao@ sb02C:re$^r.!T " 6TAgo`= ! qQkrGH!ty, @",d@(0As!jAs!<πg!rV!luog
Bw 4"B! !GN a|t~ vNA# un" G``By#2дsm f00u4yjC  $"B6|o!ӍPZ4ap !)"(E'Az `DgPd Bi p 	p@1Чp`^l u+{A+u%af$P@QQ;.,Զ`+CB4w0quR`9"
!.BZ)`z !BFG@ AnqPq0d L!RCh,m0"qo E#SCfCN'){)dov1r 'fo'poRm<nF10.  Jk+zs t`\wT AIi 3  O 1:sAp\ $eUM Mi?Bay baǧgga0s$")A ogCh iB 7JQ$SukcZipPP7oPP;Terz POvN@ec AЦ" Fn/Ctrl T fIngl~ I (USA)A@Yi`uO 
mpl B Legacy7pl 5a Ր[ BidpHACapacѪmemq0Y5CqsbFa/lلR2C10wO0s (WWAN){oBluetoothCommu	/ (J)Csm energ`anv?a SATA P^Prapi bѿ0aq*`8$`icut֜.1 N2/2HB2PLa62(P o)ol4sp EthetW V123e Token Ring 'OE3 AV  KC`f܀TU7b|QR4Qq (@#.)SМre`F9,A_NPF12PD %Z27CAC`\Nu@Tras cSDMA BIOStE<AAs2pu0Qab V  RPpxc~oc0tuq\`Rsu.'  AG r q comp08 cQgIC<Qd𮢿cxM CiѮtru1	Ӣ$
L`fsuo0|$ 00.0%!P "a 'Errrs<BCiclȒBupAmup Arkiv S{ysinfotc]s~ >stllfpn<ardYk5Łenuka nd`` 7ochsl [50  
 an0l) S_~ Skerps -l`ȢK(AStPv#olik@yrCorn-IDJa/
t @ld-s5Std fp, !Yav 7 TPM Inbyggd  I s!usi=TillgPigOeaPl(fabrikP#H,Jsbeh"%bsktsagnpi@SjlvtV HDD Akr_V Mi̀4b)a#ģt;  VljПrD C8nedt 00-X*'ck=r2"@$!sX0Tryp valfrin]gT nu ps =,q=Avbry ;aFD!bp XF, V=M`YQ(2P om"y3S f" s`` Kt Cc m i Maskin-MuhQb. MeQ(ljReUP5Sdu  DD: -> ޲r MELЭSLAGSTANGENTEN = NauOyg<-BACKSTEG FregepyK TABfa$O  SKIFT+Hr'qF2`),?="geOwAh"I@tk `, mo7PrO, ty hhAhpugCa-rlek (?L1/L2)=d ROM-0`um|GenummQ6@0#<43b i0VyArsRBqW9B' 1.z234cg 0RU1
o {in/ ( @`;
ITS. :^U$  TaZr.   %EZ!\@k!ðClmisslPades WalBg? 0s - `P f1jHr A{dd s lip˺7Ae P"n#`W k0E@a]r! DhWqstt{idQneh' NBJC[skap` җ/-4Q^i skbN$рAY:`ϓ
feaouI"hеtfqISpeskydWdadawg

*r@iἄfW O᲎np5o  H?ϴ iд?gRӵF0 1PnGabbf`rn" Upp  d kR&d (0): 30Ppgr % kl06`2Tpp3ьvrd(a~it8:@.t q2$	AOkB'S!*1( ervo-L lî, |r*V&`|ttribut: IDz01Bnskҷ.M.A.R.T.M-5 G` gNyVa߁nAv. ? LD4Q Ra6d 0Ҫ CmМ0"m聩 krv's  tG&OmCBrLؠ?Yk`  pap321És t ex!I#S! .X	_ŠTa F;s&AGlo. XGOPm  Thpglm3Adtj`eh`:elGse.!1P `uqucZ`=ǔ3funЮkr  ưAji HP tectToolsF$I	lQuicksv7elge Lwmau Hgk
gbhB)`7sadzi p&n !!!+Pgo"Js14bcliWan`=d`pt. K7!omGip D2`f `"P`l o Flagsh-9 sgSenBom`=Bljus USB-qbus-kplats ExphCD-s{ T(Sx HuvudL An: D`1 q{hrda F.A sC4qB abr ANVHUVUDHdPmavt W.3aP`Hހ`%PQU`0i'ld an-A
U MNuUhxp@ L l%upp<-l!T.A] Po1 _TX3 5bBbVgx@8glng\a1!b  h. !na LAcni nD Sk0hsk@p7c
@E(dim	 
sRG'-Kx_@ktupa*pt,vsojnnsa PWuqmмu9tQatg 0rs+b0\QZyP3yurpungd0APO. Vi  reko@HQmRF	lc	D&rn Dqs`b. AJT ф2l3g@eB1gWA!7-kbe0zfPrse`vm ih@qfljjnsހ. Tr  HESC-tuA 1ܶ>"fPwà23r_'B'9sedtF10Ui2#a:c䧑sh~ Svokca r: D?, M@iBay?pNp[0Bg6h Ba  (`}r  (haҠvawG@x Zip-c<FFj!1Աstto NtRT VxPFn-/CtrlǕ EEl=sp(USApkdAA b mrmsNPtro2w,<ffbbel!SS`plek6Pemo 2nekY1lG"nPa~Inbygg`1siotr1t1K (WWAN)LBluetoooth p/() -v@A=NƔmbeן SATAJxCPU:pSlad)eMkr0rRAgrssBh1aAB #hi [~4 (DEP)C .-1,Ĉ2vy[,pp  &-Ned Eth3& 0	3n ToaRaPN T&"4(rGjtbrp4P 9d/sadapl< `Ddrj%&R (%.>F9-,YF12-| F(Sek)e*ABd StyIrAJPB g BIOS DMAaBsC1۾Qg[ Ȓ1 ZmAnpap ҄ 07 זK$d) GH< Wproc@8F RӒea.
i00,0 % klEB FelAB=g`afiSlumpm CqcykBen@`e@P~a@-  f>]`@ QѪA@& bemconfigu`Wijzig#ne`«q?grammaaq  znr wop sl7aanopBȂs`veiZgqwach'twos. 
`6. A1OaatbhOgl>$ ID's 	WG!\ASmb!GC7 OAJ@ufv@c(c#mȧ`jQK"O
TPM Ge	`N@oe 'Ptusp%sv΀zie2!/ch7ikb0,he3 !  	qFabrieks2ugz@CsVref39opnieuw5OEecpB bzela -jf5eai AcOvGeheuP@1C "h ACgDf-)Dal!a Tel3ec-emK rijsg'ema @Rl 9Ao /97LsD9Qbouw )S&Drup `U0ذ{eYgAL=S
,=Annu@DG0=AccceAJacNee fi,t^=M(00 A`u[P6aoam ݡZ) 
v0t  #dCompur VR]  #Hpel90B0q8P< dw1YofPTre@olp>a`ruaiPqb  X:  -> of SPATIE?BALK =7m <f BACKCEVorqij TABb	c&}SHIFT+%S(
 F2-K1= sa@V cIk@þf-mode5yspebnelRU ppx Om@`jPre (L1/L2 @apac&i@RO+M--sa enumm@d nqrevi!Q F$dpOb`c7m0u 1$23140isЋgIwts atjRe'n+$Ԥ(nW2zijde
  `DKXt`_ :u$&d w0t>g .   %%rhgen1gd!ou  djps7$>0de-0-*1TQpho BasrlQafwisQknd pao!pOа!}Lop: ^t4Ǵqsks 1ege@'t P
"fb!ofWQ A:|gSg-  /t	1TmapӢ3e6ะroffaGGoFa\\f isFd "AB@%a

o@g Van#afWtpwO`h͚'Weu kuP 8Jwil"6Ӂ?С"8"au{?`
ZH.1} a).?2 (Uitw) Pe vmostG (p?.): 300ߠAe$d&%~too 6>P]`ho=c8broa+:o@XqE@geqd'onbfDp42#@kvo-IЬsC&K2G2dezL 7pk:Њ0hMU S.M.A.R.T.-a~afPaSSv`ud(  N"/xS݉aBlok.b   aK-W =V~4qkcm!A00mPVX8
 Vr!5@B@FS "WPA-ke(kunn³9&d,  zopikIv S  ᑶ@A gqG f_W, gF zerlo@G.p8 5((t 1u!b"y0Hf/houd 'H : 0aP`JS̀Q %r2rfɺVHP Pr@c?tToolsH) 'o蠰 $S `g3q# TשmumSt_@H$M"gC zQb 6  erW+$+,Qh8PiP(?(ag( o( S(62b"f k@nP@,@HsMyP+emXAbs  K[>A:@\Q"Չ QpP$t >fr5apd  P  Flash-medialPY Ir` m8!$Aia Pnetw`W`doli BbUSBy-"	1394 ?  Cd-r  'HNQơGHoofHGdI?}f!)! Awutoc DqL>& C`grr#KR ]0HA  
-goedL!`j=Yq6bew1 T sP2PVucomp@' 6[
aAM  n@ P'{50OA"3U1@p1 DA(  zowPbCO O!2JzFF!4A) !6,pMawA B!!t J!. Mo`/oĬP,P    c; $? = p? 5 @hui ѐ,̾dБw~was to/!k @OgeaBj. 0Կ`nvlp<Bׇ kra snjkd;cUE0rkra>8	!6CtoH/) ;ge#t. o
 s vN.dun
`h!LefE&aQgolq O ubܱA,ͪB$~bh Q #ײep3ruk3ESC-  (A9 Ul 2T<Bu'm'typAwv0knRF10 0@T*pZ:KxS4ѳd '3i3X4 - Nel 'g MultiBayk@tiឍV9&Fd]Ѵbase (ks)re"a)#5cÎعKp-B E`we AѪV V Zes?Z @A@:N Fn/Ctryl!wiss1ʶ'0ñSta"MXNijs'appaOu@e Pa@dl "-ij` Vo-aG0A+ Kd`dition S G!vg=uyVilat  ֨䵳ppXdr&pRadio2	l WWAN%-aofLoo_Bluet@h/oP-eniepʠ SATA-us cesP>dubbO @Dl2]secu8PDcu PhѕaVQ r1 `jAefF7(b)̏dkEtـ 1H 2
3aqToRq/- OMow0	23fE⳹a7adap`Pfa> B(pp!.)po/p-upsq#֜I"F9,`FO12 (% OD'gcur ݠtu2+EasyPod-qG DMA-0drB BIOS #ge!z"g\e Saniti6 (n)scA 1 qa` AQp akWjq0gePVtZB tijps ced1u8@sl!I.G|*;`lo`\`B n!.bQt0/0,0% lpIGx] Foua"ld_V<n`leke!Ecycli  Rs[^̃ZbgA` viSETUPj <F1=o W> t@C VXσe ɿւ\܂ fHgɐݒ  Hꏟo׎ <aɖ%ύXɏI } ۑaAȌԂ܃}`eBa L(a
=eLC +p00h̲d8o |g Icv,e#lID B%hu!NSA͍폩T  #}
Ja  		 )0*T3OHTPM S, 0)o,X"p Q \  -/-(x"B6kFظ
= ؖ 9ώ
fM@n1% 6B 9*ZP6t9X!>LɆ; `Fq  ׋? PqFt2Mp1yF)@Hp4BCP#߂AI(D8`Kp
 OPL"`
sHu2-0u"$=V#&$	8L[Cݢ]10=
A/Esc= CXsA5?0=͂@㢂)aRA ^)^;K []` ďڐ\́A w$E0!Aу\ag# K0bhx u[CySetup]vQzI̈ȉ
n gpYA'jaj ?e->F`iy`mk = ER  <-3I[BackSpace] b%+ [Tab!A'&[Shift]+gF2!///x`
pmF/[p"%  z  ɰޯ   ۾  xïݸ  iL1/L2"OM̓t 7&رٔԍUrI  ް ۰ްޮ ޯ` ްwi ޯ 1#2.3N4	
mЁun"p[As ^OŰ? (4Â)	Gc	-3N4hZB[F :$\aw .   %'^"cj`R0!̿G[MsE Walkq0s?1|nC Ш'h1U;p^Ot"so  x:Т2bƁAW ⥳ B`?ĎDHa/p쐬=TA:@o݁ȧ
|
}RO
  FłиW	qX`֎~bXopsOoCǶ  āB`kzɢH  OŇ׌ȯН1iNй2i׮S3.M.A.R.T0 \zsԁi?j: 30נxB% 9 OK z4C7`E~ 	D: @	)gm኱QE3kT{ǂݨd@"A"4MFIDt01 .1Qa  U`UEpDI&ܐV!' /}2B m@!LJr>?(ᕌ檓#ͤDLhv"SDbA?߼ݤtN  Ǘ߽܀|KvQB9AɜRWdPwȂ⬀J& 粨u֌`Ȃ
!WVNBۅ	b^œA"g`
Y@cSԓir	׾Ƃa7dh!f
ݯ?b\@feviHP ProtectToosls!A}lŒǉT s#j.0@oMu %"Tph؃{-EPO'OHpDJ8-.))Tی삪D<D%蕴  gz4 Q(!ϋNb8vӋq" Q ԊOD Gu!~=3V 0QlJpነ_B}Vӌ`6T  USB^D1394&Jpo!Xg ExpressCardFCD-Ia 4
Ud&-}^ Y:'yUKѢ*i KeeC'5D|g `qa>`2*	 ;+@bE`]AT@BaleU#1Bqi	@6	i"!qM	͎-Y  y PSkȠUǂvY )M)N/5/@`fƓRh^C`gC@΢Ɏ
 >BS綂d_pۏ؊ԓ`łb͗Lŏ|Ck@qł`k)/)%)@G &B:J`wvqpbv+̒*6J OJNՁ	(lOQP%a֯)I*A /*!j%p
F*    p_2* b*))g ̬Fpo 衊d=4ɑ8`&ƈ)gO3 fR?ɉweЅ^
fL/)T3"j@3  GD'ȑO"EOCRB@hr4%6f̯ B&L:ȗߨqlӔ5C`!W2h?BG[Egsc]Q@ȍ~%n`oaVn@DriveLock ߤt['F10>t @U   A{a=7$:  ;`A:FSxuJULJڂb O xuioiEcaB$	bXP{p{H Zip&1Ԗ U2b 3 4"5U67B8910r Fn/Ctrl'̐ؑ {_p (USA)ѡ| B#f0CXbKV1(v@Cn_g0 `ƮR}dJ_z r0Io W~ઑo%ACY@OAǐڑPiͧrlbNi!WANj%ML Bluetoot$g/#j?ւpȓdpSATAJC+uURACPUi b튂̍[d @n?sh~0.1620k2o2odhEthernetX& 123 g Pq
AOKO3O0'O3 Intel  SpeedStepR tech?nology⨭N(H0 p_PSdް Ӱ q%9x(b) F9AdF12̱i!bB +_ERE ^`bIB1  BIOS 2 DMAO]t^Ni/aVYpgf 3 œKCcTmɀ @bتc}IڀK	KƏ#xq<Kׯjw00.0%չ̴@LtGoHuf`u I]N                                                                                                                                                                                                                                                            ` a b c d e f gt )M      V   p  	 
   
     $        J        V      bc"  * + @  . / f 0 1   2 3 ,    d  % & V  ' (     xi > 
$ @0) ~ xihxi0xi!xi'xi-xiX3xi 9xi>xiDxixJxi@PxUiC <BB<> ب0`8l v x|v||p/0pc   c 20   =
=$$$<   DD_D  A  O aƄe  i  o䔕 u  y !$n $A   EP%w  I%O Q&U `   Y'N' ~ `' ^    `!c)y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>0( )' +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {{VROM+*'(

C$: |  s+'(?)+'*&83&

OO
\()|O276'6 -=
^~+]}@`)Y;+(:*[{s\_}\|      RgtxiA   Vgxi@ &@  ZxiQ@ ED  f@Ԁ&WxiD@
x@ I o ]PTq R\Tr?r@TsUAsBTtCtDTuԁPvFTvGv; 4 xi9 ([xi.ZxiRXxiYxi\xi]xik@@* D@@U J{Kt|L|Mt}N}Ot~q&  PtQR[H 9 !
	$
 
T 
	^xib
 H`
`
STU*ĄVWąX`[ Z(6{%_>VxiP@ z U  @ʀy
 aZ( 
( 
b^J _ @ a 7 *  } | 8; `	tj$ 	)UD@@*dcP ʀ"b  @Qw u``ʪ4#y9  U4U !TҤ=@@7 2
#Ut t!Cq  "TD G2UÔȔUʔU@

d U d!!d"U"d##d$}$ 6  Uf$&''((	F dI#U&*>@ b!"!C$" з| 5 @3Dr5EdFF 5 *	 D" 
      *	d*	NSx 0ŲE\SGz  :J{" ]   EC  P;878U9:;	<	U=
>
?@UA.O@&^UaDb\bDccdBDe2e%Dfaf(Dg)g3Dh.h/Di0i1 Z
xiUFh*k+dl,la-dmT }2^xi+J+%*T$aM@<6&qdVO` @  : ( Scd 2jjtkltmg &e*[fd\d@G GX
hء Uefb@?`:el: ]mF4 8gW h ijUxR`fvpyj )M@ U  & : V@Uh @5ހ @ U. @ \ j@U @ )M_)M4@ J Uj  @վ @T@ @ V v U@ 5@@ U* @ Z r@U @M
@ 2 U8 b @5  @ UD f  A  @
)M@ 2 > H Z@r @К 	
@ 0 P h @* @5 

@ U> P d v@U @S@ F ` U~ @} )M$@ B P j@   @
)M(@ L x  @ )M@ 0 R n @ @ު @j  @ X p  @܀ @ N   @覀@@ J \  @j @@ ^   @ )M@ " 2 > T@^hv @ @̀@ P p j @2@ f   Z@,T U @րS@@ p   @$)MU6@ d   M@ 9@ ^ U  @؀M
 ?@   U2 F Z@xU @U @ @ T5@    U.@8@F U`@t U@ U@Ā @
+@  AD6 R@n @ƀ *@ < P l @К @ +@ 6* N f ~@A* j @?@    *@"& AUBDHL UP@flv U@ U@ހ S  
@ \ ~ զ @!P@S@ AV\, 6@U<Pn @5Ā"@P@ UZ p  @ղ #T`@ @ T v U@ S$O@ n x Ղ @Ѐ%T)@ ` j  U@ M@&a@ . U> \ r@ ը @'T[@ D n | U@ S( ^@ h  M ) m@ r A @Āj @* m@ 8 J ` v@ @+r@ 4 P j @ @A,S@ > X l @ -Y@ F f  @.@y@ X   @/@e@ R h   Q0@*@ \. V U@ S1@^@ > T Uh @M 2@^@ 6 UB L P@TUZ^ h@ A&3@ p  ڦ 4 V@ | j  @5uT@ \H d@5 6@ Ut   @S 7@@ , F UV b@nxU @5 @
8 l@ U. X | @59@E@ Uf   @S:@@   M ";@l@  5  < z@ |   =T@ x   S > p@ n  M ?}@ X x  @\* @@@ UL z  @U @U܀ @U @MA @ ( U8 N z@% \@\I\\@\B Z@ Z |  @Z C\0 U\ @M D@ h Ւ  @
ERC**  R r@"\| \\D\J\̀\MF @ > UL Z r@5 G@ Ux   @nH@  0 J \@ @I@@ 2 X p @ޚ @J@ NT tt @5 
K@ U2 V  @Ȁ L(@@ \T Z Uh @5ր M@ UJ d ~ @U @SN@@ V f U @؀O@ Al v @ @
P@@ 4 P l ~@ @Q@ 6 J ^ Ax @΀ QR@@ H Z U|@ SS@ > ^ U| @5 @T@  : \ jJ @M  U@ , UJ l ~@@ƀV @ . > V `@hlpT \t~ 5@W @ U\ t  @MԀ
X@@ X j  LY@ B UT  @SZ@ Z f Ut @@̀ @ [@  4 @ R@f @\@ Z |  @ހ]@@ t  Ҧ ^ @ n j  @ _ܪ@ \   @`@ | j  @ a@ t   F@ b@ , @@Rd @ܪ @c@   " *@2:BT \`f| U@ 	@
A  d H X@t @e @ <R R p\@ 
f@@ > T j \A*J @΀@L\g\
&@8> H@N*ht @\U @Sh@@ h   @Ui\, 0 B U^@t M@j@ F UV v @հ @kT@ N b  U@Ul\0 R z U@ Sm@@ D b Uv |@ն @n@  < Z p@ 4@\oE@ Uh   @Mp 8@ X ~ A@ª @Uq\  2 J U^@x @܀rT J@ H b x @A5րs@*@ U, > T j@U @Mt S@ b n  \j @u@@ N p  @  @L\
v (@ L UZ p @U @Sw@ T f v @\ R@\@Mx.@ F Ur  @S$y'@ |  մ @ zTP@ ^ l | U@ S{@2@ t  U @ր@^|A@  T \, >@Pbt \ @"}@-@   Ԛ @ ~ I@ Z   @n@ n  Ț @  W@ T   @S@ `  Ě @0@ j   @@ @ ^ h v@j @@c*@ < J \AZ\@[ \j@ @\ 
$@> r  @܀ 8@ > V r @ @ L j  @ʀV\< `@\@\\HD\\\@K \
 \$@\Rb \x @)x@ H b Uz@ 5@
@ UV   @5΀ @ UH@ b   5@g@ AJ j @ @  w@ n  j @ހ@ R l t @ F@n@  J Up @5 @3@ U4 l  @Mހ@@ P p  @Aj @@ B f | @  @ P p  @Ѐ$@@ p  b @A@@ J j  j@ @ N v  @ր 0 y@   ʚ @@@ J l | @  @@ . \  @ƀT @ L ^ z@U @M@ . U6 @@DUPh @M@@ b Ք  @.T @    ZB UZ ~@M &@  U  @ڀM @ ( U@ L X@lU @΀5  @ Un   @S&@   5 @  @ l   T@    S@ R | բ @T@@    S @ T z դ @ @ L ^ v@ @ : V d t@| @ @ܪ @ @@ V ` lT 
|@R\@S @ `  U @"@@ h @ @@ Z ~  @ڀA*&@@@ B V@\D\U @ЀA  @ > J V h@j 
&@ d   ¨@E @@ * N ` @ @h@ 4 R d ~@j @
R@ > f @] , T |@ @&I@ f ] U@ @@  VR ~ ] ]@@ z   @ @@ B f  A] @
@@ 8 D X t@ؚ@   @ N l  @ܦ @ N t Aؚ @ @ D Z  @@@ 2 R d @@ JT X |@U  S
 @ 4 J U` @M  @ X Up  @ЀM@ : UF \ f@nUx @Ք @T @ L t  M@Ā@  U  @A F +@ ]R Uh@ M@0 @  U  @ހ] . : F@Xn @j @@ n   @(@@     @ B n  @  @ ~   @ l   @"@@      @ v j  @ @ ] d z@j  ]) ]  4@]>H ]PX* `@fn]U@ @
*]@2:Hd @ |@ v ]  \ t@ R ~  @ؚ@W@ f
   A*] @Շ ]ND]nT@]l@ @ ] @ $ J z @Ā")7@ X v \U@ 5@@n@ UB l  @΀ Tp@ : J r U@ c ڀ+@ < \  @j @(@b3 b  @Ā @M@ J \ v  @ @ > F h @ަ  D@ X J  @AS߀{@ . B UX l@zU @ȀS@ < R Uh ~@ @PZ@ AN j@U @5ހ@@ UR v  @ր T w@ P r   @
E@  U8 P `@pU @Me@ P Uh ~ @5 @@ U: H ` p@U~ @U @S@ P l U @S @ h z U @  @ h vj  @ꀈ@ d   @ @ e@ < H ^ t@ @Ԁ @ X   @"@@ r   @@k@ \   @@ V   @@B@ nj   񀐪@    Z@ v  Z @\ U$ : L@dU @ƀS@ % @M J@  U " ,@6U@Z f@lU| @Ȁ @@  0TA`@tU @րM  @ R U~  @SU@ h  5 @@ Q^ A*@%A \\H@jt @j@   @@  * B ^@z &@@@ N ² @j @$@@    @@@ ^   @ڀ @ J r  @܀: B b @  &],@ R ^ | @ &]Ԁ^ 4 J n@ @&]6@ R f  @ &](@ X f  @
I @ f A U@ }@&]@ U( : V j@U @_&]0@ R Un  @΀
 @ AU` ~@ @W&].@ L f Ւ @
	W&]8@ J n Ք @
W&]>@ b  ՠ  
( T j z@
 @&]F@ ^ x  @΀
&]&@ : P r |@ @j @. @ p   6&]h@  ڦ @ ` *  @_8&]N@  5  
@ U   @}&]$@ U2 B Z v@U @5Ѐ@@S@@ V  5 @&@ Ո   *T@    S@ x  M 
 %@ b Ւ  @T@@ z   S @   M 1@ v Ւ  @T-\  6 X Up@ &]@ , < D@NXb l@t~ @ @Ԁ &]@@ JR V 
d I|@ ր@=@ X   @Ě A@ Z   @ !@
@ 8 T r @h A*"=@ < J@\QjD\ U@ @
# (@ LFT P r@5 &$ :@ t   Z `%@@ < R  j@Ҁ&K@ : ^ v @ @'@Y@ B Z p @Ҧ( B@  > b @* )X@ Ub |  @դ *&]"@ 8  V |@Κ @+@   J n @j ,@'@ b   j@ -"@ $ 8 N ^@n j@Ԁ.b@ D ` | j@ʀ
/=@ J j A @0@@@ H f  @ʀ1d@ n | j @2IR@ H x @U @3 ( H ^R n@\ @Ѐ4Tw@ H d  ՞@5T@ 4 D ` j@r~T@ M@6 x@ R Ղ  @7T@E@ t   M@8k@@ R \Ț @9o@ j   :F@ 2 B P h@v : ̀ j@;|@ 0 ^  @ހ< P@ n   @=@ v  ڦ > @ ~   ? e@ xj   @@ f   AV@   ڦ BS@ t j  @C\  ] 4@Rx . \ @욀H  ^ D@@    4@>HV z@ $ @
Ā\ E\6 d  j@؀ҀƩF@@ D ` t @ Gz@ B b  @֨@+H@ F \QbD\SƯ@5 @$I@@ U> R x @ЀJ@ J   ԀSH @S
K@ L l U @ڀM Lv@ < UL n x@ @A My@ 6 X  @Қ @N@ < X ~ @E%@m A O\@ 6 P ~@2 M@n M P @ X U  @S&Q@   jA@R@ . B X f@O)Mp P@D  ؚ@S@ D ` | @A@A T j@ 4 H b x@ @U@ X x  @ V @ < X t  j܀WT@ 2 T z@U @MX@@ " 5@ \ Tw܀U @ʀpV2 ( @YT@ V r  5@Z@ U`   @[ [@@ U^ v@M \@@ V Ul  @ Z Ԫ  ] @ 0 > R X@hvj @^@ N n  j@Ѐ_Ӫ@ ^   ܚ@(`@ t   @)a@ j  @b@  j  @"c@۪@ l   T@ d@@ < X  d@@  @c)M @ @֪ @
e @ A@@ җ)M\0@L$\Z\p@\Ք @fT @ N f t U@ M@&g@@ ` U~  @ڀMh @ V TA*t@ \D\i@   , 4 :@Tb @ @&j@@ x J  @nS,! q@Sk@@ \  5 @l@ U" @ R r@U @Mm@ F U`  @Ѐ{n$)M U@ b @5`@[ 
o @ UR ~  @U @Sp@@ 2 T Ux@ -@qS'@~ U8 b @@ 5Ѐ  r@@ ^   Aj  s J@ 4 J \^@Un @5܀t@ U< T r @5΀u @ Q> A`@U @S
v @ H j U~ @M w@@ L Un  @րMx@@ > Uf z@ @y 3@ * P @j @
z _@ . > z @ @{@@ * .R 2 \6>U\ z@M $|@a@  5  }@ l ~  Қ
~v@ ( D n @@%@    @ @ 0 F R ]* ^^p @0U @SS@ ~  M  @@ \ Ո  @T@@    S~@ p  5 @$@@ Ն   TW@ ~   S[@ ~  5 @ a@ v  @ @O@ 2 D R@Zbh p@x~J @:]@Ȁ )@@ 6 < 
J b@l|$@ S@:@ X n U @_()M<@ KC f U @Ȁ}@ H A*U* ]fx "\D\ @cl  8 >@`t @Ȁؚ @@ \   @Q@ L p U@ M@ o@ T Uh  @̀M @@ . UL X p@e A@ @ `  @ @@@ @ v  @ʚ  y@ H Z x @  @Ro@ D T Ud @S@ @ b Պ @T@F@ H P ^ Uj@v U@ M@^@ , U> P b@tU @ڀ5 A& > XA @@ R z j @@ N ~  Z@& )D `@Aդ @
T@ . D \ U@ M@  @ * U@ n @U @ @T@@   < U`@ @0b   @ D n  @@ 2 Z n @ʚ(@x@ j z  @R@5  w@ U0 B V \@p  W@   *Cp   (@Y@    @ Z j  @ ܪ@ z   5< j j@Ѐ$ r@    $@@ v   @F @ H UZ n ~@U @ @ @
@ B NR Z \f@~I\@2AD @ U` l  @U @S@ ` v U @ʀS@@ V v  A*2 @ \
Q D\>`Uf t@U @ހM   8@ \ Վ  @  @ D Z AV$PnPxi/ /   E     P DSDTDSDT  sHP  nc6420   MSFTC000
 [B
\._PR_CPU0  1
 HCSTH %p
p
 \/_SB_02p34p\/L506``3INI_ g,{78
sISMI
=
 ! PPC_ `
97[6
12
NaA
 t a;pa[#o
a
?BA!C

D`0`
 ͕Qar0rtc3}c
c
T cEc
['b
0\F2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 710ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD1phg	gi
 '12kg 3 phpi 0%f%`'fg`f b 3f 7cufbc'@%~45E
Microsoft Windows ?ME: Millennium Editions NT 019
 jA1+8D5p\_OS_`p
g*.ag)`5
braQ914oua
 !/D	"
6p B[IW` 
%2p?P> SP2PB6JDqp@8@>14A_B !+8'BHC
$fpig
fHiPE g0Ih Frgfata
apaa9aah@*ha `a u
 bbi+ibub`1
\1M0E1DIGI[K
0E_HIDAJ	_CRS-F)
g&	 V 
   W@W U  y 
 C022  3J24 5C@6py7
P26@D"6\F S28X 9 AY S2B pI2A@%D#O_ `
EB9~A7[PF   o
,[	FQn30311	9p[
 32׀ 3B
o[1 0A`
34Q 5 6 7zA8 j39 AH3BA[  @CD@3E@
bFE@[E140P41+42l8 3*44m45Q 6U7 8A9eAB14D!
07P1DAEZF0u50Q 1 2 85345Q67Q590A- !5BCQ[5EF 6D[B(v62|63H665H6@U(7b 8 9"UABCBDEFa70b 1r 2"74@a n76H(77b q79Ar7CMB7D
c!pp4Da}aiapa ib{{ab[ՀG027
_C~ _ADR!:&:  _STAp `{	
Fp
q,V808 .82
T
7C[P:82 qq 81 D30PM8383ED 84?& @? < A285 [#ڰ	6KP87\`p` p`bS83ewe` ap` dpy@cCdc87
{a
 Wb di8U87bbtWd
q9ruR2dcrdl84` dza_
axf Pfuff aPhdu`['A
\a
AL

   Gk;
UsV` H2y {'&89 3[!6 BQCpibpkdrd
edA
d hb @brb

bhb%D  EFV8jqDS9 mE8EcrBbNC090!warp8Aab@obBomo
o
buoatb
-bP cPpa%
o`bac `9$91SKRn`k8A
8D  8Fc)EP}92P=aaÉ`l92@24_S3D{
p 4D
`vv93U< W

vh94h @4[ ~`95 [=6%@ 
"@`Ŀ97
 >a@{^.h2BAI=%D 8
`
[N098p9e9 A "9CRj9`9`9`A0]A1aCA2s 3  sA45 fAAgA6AgoA8  mA9~7AA!AB H
  0HD"aAE
i
@n1EAFvB0 
0xl  @@B121MGQ@M@- 3	B	0BpB627  @B	`wB	Bj0PBBC`ȁxP 0D	 AcBEP
S C	DPC1zC2CyC3C4
<[VC4~ Co5  @ C6 q7C8@
[! Ѓ`CC<CCDGaE_GL_Ҳbp
`{ N [!
dv`J`CBAC?C{h@P jp
p
Hrp"ǐa0CDbQaq	rya
c}cbaaF (8` aD0x0 D1Ahip`y`j0OD2
9hA$8: 21%7+5a+gABV*GvD30i5p@BlA4RMbA
i1MCFy45-+r26p
4C}jBG41D5
@
[+ pDQDQD8 D#DAB CЬDC
A`7`C
	@  z{` pxa 0 
bw
t
	wrabkC
 1@B8(U{c ~t"OL"D
pI6'BDE
y
rw i`H,D9}`"Ba{` ` 
p{z1 wiȀQ{a` pbqrDDb xC1F	_7`p9w
h lcN }p  Q  A12
ccF~E0
l
3E1  .E2 PEr@)e {ky
\0p;E1c} e? j
z2a{`V -xq3p #`b}e
e/\ !`	e `e$}`@@dAyA4{k
\ 	p`:}q8
 D8 y!-8_p?d1n66d D6"7 7e@yE4q E52T c`dyce@
QT@E6hif"f
j
5?
EbdB	!ba'cPx!Dby
PASqFCTH@BIBb(p`oAb	s@b9/cyacaA9w'A`ABe'  dBp@R`TAAp
0)7?`z
ha-LRE8 !E9

E9EEB5_PSWA\EA r0&DPEC&D, 
	Fp				!9	P				FT	p		@P				1 		P			N'[M1F 4
5ù`7c0
[ۂ@F9 wFA
P
[5   FB K6 C!FD O:"F  C100P 1a10.
   3{O`T 942
 ДDP=:s
cp5
  6 0	p;
8! 10$/10' /T/.B 'B//f!e!( .G!G!@(P$3( >N #D(QD//N E@ #G E//A eA !A N A GA "PA  "D X/B 10G 10//m011`03f0 //@a0%1a0%1a0n0 a0G1a0G1a0l11tJ PH3	P4	
#  'y  Q61@h```
0` `apa! py	PWU`	|8`a}'9	pA@q SϷ	A`vr~O@_HIDA_UIcD
p^^03
9!_DIS @x)_SRSa h/_CRS3$WaAr )$^+	b!Br)@4;c1Cr),C 1BM hA Dr)H0}[(iQ(E r)$`k0ja0Fr)4P{8kp8A0r)7 F>B8[!
UVF2[{20121
r 2
 <P3 {[#"G`Q6u[@K204v1(W 5J\._SB_ISMI5k[#\_GL_phC05Bpi` Cpj Da	/ 021O	k['2	5Pmo5BJ80|p 27
,9 28 L9A __S3D
p 4p @2Bޠ({^ C
 hq{55 ` U4Ec6C@KpF
57`
{i}`h`{`hp57{i  @ 4$ qC130tt._DOSq	3
` a![^ 1bb ha[$3``qDCb_2B
 G E SS$F
h@Ҫbh@v34
d
3

%P3
:
A
H
O
V
]
d_BCLu3450O@MC\n8
}b@hp}ha`kar0Q 735uqz
vup 

 b8E2C	8hpdp
`? {\/b/OC6
P"`8D   "Q   PpCwhiAD?`
h'(b\G\/	H hD2u3s4|4"〯139
 ip=C0D2hj	 3hij 6.A
Y?@klF0B5aa{/[I`	_GPE
	
U
Gb bPGf fy R3CRp@r ERR3F040

Z41443`
4/_REG(`pKp* P)	iP3FQ45q[G  @9@46 @ޣ47p # 8!9\)14BCD1E4F5051 5[25355o55 56s la8A59AB C\015EQFPū60Q 1 2 3A4R3s 65!667 ZP8s 9@p6!6BCDP6iEA7Q\71 i2 7A75677Q 8@797A a7C DE_INI %7F Q1Qd81[  Iސ2 @\83&4t3eCt@ 6EI6F!s3C185AvhP"6|`\!`c:p	7	wh
@axa
db`t
@` _@	
a
@}a`1
y`g}`a828 
8x!h azw`
d`xr`
  
@bamu5"9~	7Dw	
A	
7DB
Cs D
bQFV90s 1R9ЄQ3
@١956
Unknown 
NiMH 
LiIon Gp979OD(v `!8r	9dhP4`>EavAW8EF6a7`8E 198FD4#7sPt$t#$5&90#90@@-HA} p8Da{a
p8Dˠ}QH8B!3 
PpQq!C!CDR99	p鰜C 1Q!9A	0bQp
MPN{`#Ip9B
[)h`p{10`
csc
  dzir`a[)}absdb1U/2*(0ccCm$C	hg3
9Ag
x!з8B595{`g0٤(D0)EhdR=C s;52a-6PaF4 59 w{93axra
c 
dcbpbb`944rq6A*6B*`ap$0ABg8B$IC1A0
I+Ep/
 сW ~	ip
q=RC9B!65Cc.Ec60 3T}7
{ ``	{``LFA >ޱ  9RO2ccdp eeez
cpOecpciCt%4? 5p
v9г94%4`p
`4^9@ _54C-2b@+N)p5m0Q-  T(
q_>
>5(P2pz~
 @5^Q%*!6(B+BCpF`*e(a8h/Fெ	A79ata
al
bzch!

60

6Da66
@ rsa 9PQp*upaHf:bc9h6fTi>AUA2;1CU1R=2cU2r?33 [
0A3rAі
HP   a6C
Sp
SIMPLO0SMp
MO?TOROLAr`w0D4A4
p'
  
Ajn00BP00µ00CA5A~(_Q03W<Dq0>4aY0"\A7jlPPR_CPU0
* 1:5P]p[TZpA8 9['`TZ[3_J@
6`p>
J@e2AA
QQ1	1_2 N85vc#Q 
CRB^C#9pO1169ɯ_Bb316

,qԯ
{ (i28Bi4al4
 DA7p
71N`E
FoPA5P'ƻ0pVQ72 3[H tE
}AAF
N4Į C1BB1FjB@B@ [B23@4r !6 F B7QB9!q C DuBBFC0
W[  ACC2CC4CC 87p8pC8BC
Ua9A
ѢC5MCqC8Aa` A$B8`
9֠ 00C9`OqCBQACC # {A q!gcBba?Ac3gDbxaA
CBFc1C=Cya
 d
b
 `bdpdSpc
 c
U@c
9CCBбCAC8`kaٕa
va! albab`b
vbfb`B7BBpb9qp!D#!d9zjY
!%BCF=!E#'6vb`_b	a PbbCFQ
82p5PӠ`6C1D30
B26" 46"_
q1
{C0 B`{  ia` `CAhp!
`!`KD2	CAhABȁt0$b c  d}ydtcc\3AabcA(K D3 p^^0
4c{I_D5L
D6

Gy 1[D8 `<D9	0  DDCrDQ@[APDAG_C  _DDN
oCOM1aDBBuDC6
30Uw"    }8y sS pDCmTA`!DDB11
W+_DIS q0432DB
F_SRgS^h
aE7ErA0)DB@
_C1F

` c
`
Apw$NhA[PoDF   
B@	_ON_a 0_OFFPR0F[L$C1{E0CgM6 C
_G 0" *
W~S*H"[!:@y2K
@@E1 'E2ql^,q0EkDE7AX
zI A * 0
 	E6
r
;в/!E1s 6"S2x""u"30#2\e[4 7m$i$!P%`$ $E7[C:$8m1A9p_`   U~PEA
.G"WEAc0B>EACEAavHH
1 Gxx&xx"٠q)x)xxK Lo r^r_ @_u\RRJQEQ@p%QQ56Q1QN?3?303?<RQV3xrRn*BGm3 *o3dSb qEC44pED4?V!4V55 X5v|wxp
,1CPQ	߈r188!]EQE=]75]0]&2]q5qPoqY:E)EF gp\/0sau02̑33(`O{fx  b|/|Pm{\/0C5
|1F0
. F22F3 ;@4F3TFp pFd0j qF1;F3aF5!pp*	68Pܵ{`h߀`h [EF73\#_UID0;\881_PS0 F40@3 Ò
  "@rpC 1FY9y 
5 aF ^  paC !pF	 z`
a
F9BSRFA FBӗFCQ `v2!BFAGdFD$}1#E`#E#FC200"P  P@P;20b%203j@}!
G``Gpp 	`} ; P@ LpQ4˵50{<b4 0vA1

2a` 	)FFF@&
A
5
=6N$S6
1.0"
7 
8T`7uFGV]$_DSMph`PQ1` b@9hijkJ ic Oj
9jA
 6AKk`M`{נ
V0W
70X< 0~@J
 P!D`2@H}@p20A
     05D
` 
pY81CA:JBK p{z2 
T A	sBBIpk71
7

E e^ 
N nPcEC	p Qy=`}`
`b`P\%#D:9O5 0"  y0RqEE48b@ @ o" [ E2: 
@ǐ͡:     **"@,F%>a a !-wC214AT@
? p Gr r " 1U` `0Gd d"[I1E
" yC13LC14̀P `@p[z215S" !
&sO.k    `_[+6B     `KoC09321`mADR   PW218
D
[ 
9 INI9[AuqBڃK 12W[GC	Z92=0PA13P#7EQ CL
C0l WpE	
pI  q/Di }
^-^q@ E!2
F9B["

`ο5+p[PGPE_L1A`aaA09W
A20
>
[! 01 I	 }
2 BGAm234   
0[  5  @{ 6Aq7bC00M
F
0UFC	a
/dN0q2o -723pa}a~p'| d5a#"126B!6$4.bkeC$
	
=@bJp	q
+00QK`8@D(Jp@`p+RMVr+&_EJD 
\0.P FQ EC 8.pA@0 ЛA$"$%)&NH& 	`3L' J([B@ELB32 3 
";`4Ð
  I`Q<+CE
;
 
 a{a Н0p32ARIE
: !
H!"
D4s
fA5
N6
a	>C>:
?
9</=
#`5H>!5@!߾P006`Iߐ\/a36s_L!O
@33q`Ɯ8
?:
 K<F4cd?	H
CLRI&<H
0bKa#.1ACv G19EIBM   a{`a`
{`1
bb"ALRD	/!4h!ALWRb3hiDALED	.h}o5 {C5-?5A`%	|&pMSdg]
БS3Dr 4p GT0vdk0xdmA4Uvo
@WWRcA)X4W(o[_Z9Z3TbY3T`5!	
# О6O07O08O1BO1CO1DL0\_/PICh?A% MT M
E

q**   UP0Õ## !	 GC

 
	
	 !PA 1 Y
		!`Q 
a5`7E#Q "cG	Љ93!B!:!$ D7G !Aa0-9F@	Fo
IR  "d
d
Primary 
@   
LIon 
Hewlett-Packard EyTraveloka	EAO@ D-i8`q F LcC_gh`/`%
 ?4 
"  
mfFh3A=j0	 3AaŠA3u2A0ha`SEhAyn
_U #O
_BIFBST ApCLqV_4 ;?;:6<IP{@
ACPI3{F?_PSR oR8aJ` $J 0ေs s@uAHPR_CP+U01  > ` Rbpbz04#`A&a
q FCz0y
#pa1(30[:}
*C6  rդ`F
	/15?@SXQ(4p 0
> 2

01 N43jfQ44 45 V 467濢`k!k` u`ph`piaFa ?{qp
 a/0gs }a
aaop`kpap  7 ^4 A4vV44 S_8@w wj`e y`2`{hp}
נyj  Z>`9b1`h)h`pv	8` ibpbasabcpcau`aAA
B Cm`
3CD ! 0b  HELBFi50 p51 5253	г ` p
b P  `pr
` aI4 553ew0p@ e[0wre
 
6q6@932pFAI854p hpO/50SECUp@}AKA1A2^ 7bTbUwr8}U9RA]uB-3jiP
caCc_p


UD
	E
Fa60mr12F@A2
   Ҁ&t09O$ 3x6416Y566"67i2S DR86_"6A4$` ~(130u!21SIMWE6DT____F,O0bPR1JT7͔ YF b W` ar`6ZPASSa:)1SE8aOS6BWC05 p``p!ap	1 a`!CT [SU;2YC'>aasbab P`ab ub N>g3D5F"sm6ph<piKD#MEMF,Fx
ȱq  ESP_WDGD
4_c,E=DAAyB{M4C~ C+KGY@!f )AB L\F˛K^B IK--0AJ<	Q3BC' h5L>j<BD FΘ@pEMEBE ( /2IQv-BF =2=f'C⓭BG  6dBB$BH  5MI
WMAAdijKqW7i,tBqn:0k`pP+E}| !sD R64{h
`?{`53},`(4RВ0b7080
*58    65 Gac9-N

NP,_C5A@#L<<6BMp5ABB36aw{a
 }P` v@A@4; 	5IBE *	a7nKOu68:̯3E817ECB
C ١2q?!h^2h	2MsѮP

1ap04As?a
PE` 
;!m   bpcQc`p @b  ce5E*_	P8)9+ &e[Ah(J0*1
vb\aP
gp
122=Pp
4!Y6
RX4@	p
<
p
	A@hp
c)55AR55F>,
W5717A7KO 60?Eh mR) p;)!LcG}y|pl	
8PE  "RC
pz[{zs #& BFD j ~\TA[bW1[b^bb^b/r[Y2   
@[с [3Pt74Q 5 6 @\7q89AA73
?Ybb 733
3
a	78B"9 q	?
VAza┤b?<CA98ar(DaBN&
BIOS Configuration Change 
 q NGSecurity 
An attempt has been made to Access features uns}ufully

+
Unknown E_vent  e  typeC	_WEDB 㠠0aLpo7B E 'Hsѝћ` `~ !2r WFCsDq'q&D !'EZ F$80 1@P!2C074`A3W
  !2a56 708*9P6AAB!1
19"1x 19193 4
serial port95
infraredG6
P~@)llel P7
My asse0ag8
Enable9
sDi1 A
  w, *hB
* C
 *PXE, RPLr	Dk
 *E
 "F
TA0
*F1,Boot, Allow u| A-rejec`No prop/s.B1
 I*__A2[OA*3Y
G
4
c5
|
6
*AvailHiddenR7
 *68
x9
Q%QB
 0,_ 5, 1p 1 2 2 3p35             DEO       ;F'@	
Ss963 
\Syst[k`\9 Op!a9s|d
`a1 9
9;? B	IeA?	?	?	:	n?	?	=	[I?	?	?	ex?	?	i~qCD-ROM3> 			aD}			Floppy			$		z$
$tern gNetwork Adap0?
?
?
».?
?
	.J<?
:
 Modi

8
SELECT * F"HP_aEnume4WHERE ?Name='' AND Cu{rrValu#x'Rr r2rj>OqGwap Fn/Ctrl Kepb5Device{UH,п	iHA#USB Legacy SupR/
/
/
B.
@/
/
o	RN .Fan ways} pwhile ;ACwer



h

?


Multib7	-ifoifGJash Media Re	]o		mKF9,p0 and2 Delay()@
_A
0
0 
1p 1p2 23pqzDpfJSt0ard , Bidiral, E;PPPECP?
(,=J(E 
,PP@CP _:cEWExp>PopuplׯXXX2oWkWiMОmea+CqRB-OM/d\4WI?3Pp۰wdfSetSIs`=134)`LAN/WP  Switching
=uilt-In )@C>_
_
? e'wmbepd Btth%Radio////  [//? QLp&@








W



 


+^8 Sav**F
?
SS{|

_	ϕBAuthƠHicCKCCy\#mCoCoCoCoC`CV.	%Ava?ilabilMW='R??? ҇
ompc DriveloCckWX */H \
Ptra 
Glio(`l+++?oo
? hRequ  P}Rest{


vПn	I`Data ExP7rev&on	oNoNoNroN
	 ߾+ DMA 2Transfers



^

	^bSATA0tpC 




 _	ޑҿ			O	1394					O:ѷbus Sl?	?	?	?	㽏			9Ϫ		=MMDualMCPUO	O	...	/		Wake @n 		 CW	/	FBAmbinLig=hnnsor



 _
	\Lecoqy Batte Fa=s hargM??

/
N??0*&, Hin? ____Sv a
%	oAcpfate 0Next B?
`/ ${|$y rolic*F1 toR, Allow us@rejec`No prompwONOOOOOOOOOOFq 
c) C2B0CO
!- OrdeRqOcPh .k =ar(C:), Floppy  erCD-`sNet0kttroller, . NYB
;YQN??Multib<  
p? !V 6Z_1G?d*^΃Xul 
kb
 C#
OIbOa$2B

/!
 
>
	HiA
.3JO
[~1\#2	43#`	D43!T5Cd6St764CP%6`d	23 4567r>5NOLqssetcking Nu0ntag PlaHcol@G9IDb!GOw]nhip  tpha&PManufactur

FilenforQmB0,ProductZPqIcor TypP(*JSpee: 
2Mtepp!<'Cache size(L1/L2)qFF"emoSP!C2aDOOO!eZ:'KDi V2Q$ \,H=SeriO=ԟ-^2NPCVideqRяu8_
KeyboAph9`>6 _
0 
 S1p U1S2 2 T3p357ooB8%
Sta1> sBidirp alPP@CP 	WMBH
 ] A2i
pj`p`ap
 bp`b dubub e0fpccC284zP c uc 7ADAF37D7Dc j E FE80\._SB_CW076 E 7F980A?ed
;f eufa /f
7"J9
q Ap/*
 `K` . >u``
 p
u62 u`p`c
 c0u`p
cucr`
cFi|aa 4A
  a
0ߔa
9t ap Aara

a
pp aDc d@dOdAd@ d@d
Adrd

d@d@0d}ya
 dd{d
dpdb e u`p  p
 g *yd *'e9AFd p*B\C019!+ +B dv bugudvgF)
	p
bO'
gp
2sLt7z 04 vbsx@ ;sEz.B1B9eFy/9`)F0 00000B()
p
 ?(?(?(?(?( ?(80?(7(A?(?( ?(?(?(?(;F:(LbWe-7VB5VVVAVCP"7C29809q8 YQEIMk9a9fCKD820Кl Port Modefՠ%'
*g

	 
!`GggF9, F10 z 2 lay() 
0H`m5
У

	  
P0ZJExpr:@ bzPopx ?CInterޠ Netbk Adap01"y,PXEr,;1.RSPL.0OHE@dded +urity,vi Availabil>@ 
%&8lp: 9#g;HiD8?A йv2 Alic#7
F1 t\PP 

@1h
llow usP rej 
mANo promptsACU%Trh
'gFXLracking3SACdap17a a4QeveuduevPb`lVV(Wpdm8B9vo5yp p2H׳wOwn hip\
	mPa066a uap &upugA2Pg)1d~cbvbF-vT\eae1d1c91 2a@uaP@,d  p
auaiuőxBG4m91
Optic@5Disk Dr+ivP4 R53 OHP3(C:BLxJ	USB FlopEp7
8
	@iSupeArqp	~	CD-ROM	t		K9RControz1 E
*P%_R"
 a>3fa4ar
'
_gGpԡ7uAfӮ"a@`@6A+DFr@0A!E
z5f3%qxoaH$130{
gf
 &7Ba7C`	23C
{ep	F(i
 B
! C D
 	
 pj`p`Jbк`b dubuAM[cKcB=BBc  ^C0A(D@vbf eufa ȵRhePAavBB >uaa8rbapalϡ
`afaiςc1Ub`b/b!b  b`b
Abr/b

b`b 0 soood3BC`.ࠇ|7:X(|
A (&((~(oI{WQBCs1/`phbK3  Z3@ECQ bEG2@}181}
 55q 
!iAFh H` ᒈB
/4AS4/cy4dfcBd Ye 
,0* *|q0|f@AELAN/WP  Switch !L{f
z

.z 49A^
 %aBn9k!r		"z"OBluet hRadio7 
2M&fJ0	LP
Nf,FbJ	  fbWm l ! !f!bN__Y,$Di8*FW:)#,CMEIA'A7,AE'A6M1#L666N(MF91KPara`l rŠuf
k8fAMAAءcK1 aKF9, F10 and =2lay(@' kf
ozf
cPB6Express#PopCup3/7//J$p#0$3
1'1='4)2*)5$vd f
*h1l`-+i2m)iggf13h8Bf dusN;{D{{rh
9'{"h)|1[zC0#069U@1BG7OU28O3Qw4hpf481ŅC57
0
6JpwCRDR	E7"
WFO8bV70O9G1OA
aB`QaF7*1c0cr !q7C r1/ apakC4R%a[)!`pA0`
asa
 MHz@ 4!C`$	FCA%DCa2Db3a
d esd
/ fsfegsg
 KB cpcGG!E	Ea  @&b`Gbsb
	D -
q+aD Q]B
A<<B5­; HE;3<egR;74`; 0Ā`;FB@qpa0NG
P  eǢJߠ0B2  g1dgI¸Y82Z04e `<PH`1ie?0`  Kp	bb$04 ,Eaa , a."b 	\ Er	0VC9!agFHJD0W@qG2KPޠ1D0
{
 !b^ bbCAO@OOOOO@KKFgBXCWX3 
%D
"71s2p Hs I WQABFOMB     DS }T% BGFb IA ԟ@~ t(@ "W6`Qv GGnhQ ]R.7w' `T΀ iD!D
qFt~Hp*~:ٜ`r<H  ,4"kcN
a$8%$¥@hl'E,yJIQD6'(%BX&v/ sq1ښĈ,^ʓBHhQ*L0\F)V -@THA<\=rgpIO85f|Ljh8DI=R`w2
^~&=ӊ1!o !#x(|8ӊg  Qav38G +}(|)O5Nw8|dqD99O"'@ày .?@~xH#Dk<B,SE!c|}t z7=.>F~ L>:v?K!#Ɵ|
 Otԁ2A6[@E0"ENZcDy2@{2F\,_p?p
zBS9S5Lg(-| ߙDp)3
x|@ C
`A'*u\aFYƧJc^I}1T7P7g
5LJ5j? j GG8GF \Rp4 G!0_h|ePBBSĳ/?^}
!G!c(_|bPA"Hg@?

@7G!YN|B(tg*#;K&,}	YP?! v pG/ 	Ag!3:$_/=g!u>1MCp0?^WN	,0ȸFmg!A.#!Lć)	E15
,dx
x䟅a{2cY}<%^

53|V{Ѳq#: 
s)|rlV3O B!4DAm
P{9vt6p
:%jg3S	|1^d @Ql"!D3:b¨ cM=_t؈1!&ԗ"XCc7e0Ή]|:yt~2|zha=C8Yไ0; N5} cE]מ鲁Rs /)F0
ЏemxCmo(m@<3n\7 0*)'h
Pn~^	ࢀo oX~ |1
碀o `7(m=!x|98yvLp<hbr48?aG8 VmPa :>8t78T塀q2i(S)IC
<1lduK2Do8Dy߈bgP]ȣB(/F#	AXOőF:x>x!9s{T8N_%L
׀3X>l	,!L`':c/|2|M0"}\oع:hN>(*`U`!C=.s>\gppqippM `
,I&#0() )ؓ0hzL*?0c93$Q';W
qw)+cFr/ul`9 
Xg<i1VaAu?+iGܢ
<ӂcKXl\X!!`IF >8G#}3{:"{ў-|x4B8vHN09y@ۗ6*߈b e., T7__^pq=t 
<0Q1ܷ9Jx;rhBOO>)
&P
>(>x-N✉j8c85$=-#8<2ǐ!yq|ge|.hhd|A0쉳 wP B yV5Jg_pSd
SLuGQMTvZ`g!v]I/Yp ܳ8فup/D2 Q'YI0q WC )8pdxP F{>-9!SŃ1*ivK~sxUi"/{1
}#J=-c wz 8zz y qGP8~lG qCy 
%Rp;.k(!03O1{38Gvx#Cܑ6vp!@dCǎǎ;P10	&LG-c&<!"@> c	W<x~Z]Г9Ǉ,Oq҇Yܠ]k)C'_=YؽOuL9Wv!wI6
!g$~0<
3xG8ˆ|`uQ2;7K>vy3`|4AM{D8_`EC	8P$8/>4y>p{P@=!3=FN٩wf?<~.=
S_>3p
Mχ
pa
Q j/S`hg1TPg1z \> 3#*u>	~6Cf@ph܆
04zq9; ៣Ꮝ`]1۷g+6@NFaPc#<~lph̑ƙh؀Rȱ)>8*W>1]7t_.|1/->!KR!ЀOk>0UW!I
|Ox`ãg%c;xp018PqC`YO_Y<(@ 8*8ۄGL3(a`Pg2pE 9g8C=h=kߢ)\*N ^
|yhh;Q熁;P n!>xTg;ᔎ?N5Gv.`"O	[!{sloaG9=xo>=0pL1-Ptx"G0a c,JWGV8i=l'PU .u} KP P#36cbbO6||}6;~ g@?`*n\( ,HGNrd{!뇇zOcy8±Ntp.N؆#'Z*ŏ!,H{<Gt;KFgW9#Dahv#:.X%DgG:&Ct`ɀ?`4Н]uHwvz.g0Pae zjP \|8ZQ	#X-=}
_C|'% s1FTF;-x8ܳyx8|:^?!p6> G5`+Q9
#
uT]|}"p!^"Q`oQ
0o7V@Ol/j!<tQ
j<a Ql'??<  Ίá# p9*3^ȩ=rJ,TE
WOO18CI _^|1B
?]t1.wV8zgXOX%`X/ƌ0#G-c @1`	
XOPɣ P Gˀ݅1
.a *EkC^8U_	A?4X(~h>{ohzA|6v)P
/<X^x)Kw&ssf4 U<	&y
=MI08Jb?|p! B<H$NI_&<PFy43ЋdWI
~O,u,O1g ya #x
c<*$ÂT<Nz,a| }B
u	Ω pӅdB9i#X:	x #$FpqĹTρS?qyni};\5 aNO%
67Z{p<8eZ]>,$lp,[=]ft6Rq 8!iGC:[/{ه|p4|!:m0'd_XUz	|;{/a	jTE00$s|
фf7o:zH"y>8xRW#lPSa.v,\'쓍O`ǜ}Gih֗kg	@0 Ӵ.)Wx}l|13?HT'"FbhtHp0=s  H7}A]kǍ}gSx?8!^}e7}E	"hC<
ex(>34x /c 5> C20wG
wZMɠG=qQAtlP7qt|18.sᛎGaF`ϼ`f'10Ż>.cEw9M0q0.9Op8G =޻|vbi
!U'0(I:5=Ёh6=2 %\w_BOK=`XÆ^0Pzx#@q3&#&nv*M:L:#!>`3?k FyED`w:('G~I
 t/@>8Γ\Xk|t`\[{gy3	k+8j0-0"{+?d0>Qn`*f<+uhsw);wlO',j///oȾ)=x7)dcM(0l4FX@^. 86'|'}hM'
p<I|ĝ<wey}c$F닏 cX!} .!	4s YGّcEW`9G>~V@cQG$~Ns"88-3%v'%сrсx&P|wC9R;"w q
w07Gp?RhӧFV
(ӠVJ
(b18,%?boLa%pn#P:@XLH 1½bi	X$a@|5 L@z8&
B=0H@W@Mi51
"9C@`
Eby] r旟Hr/ D@(hk& !j0=B
P1,"0pT	h*T 4% S
Bt TP@ޗ D@NB|2 T'#(P s6 Z1 4qs 4;  y	AfBM 'h $AfoY=M"0gq<[ 4#}<0DG"Aj4LAӀP_+ȗHB@@h^An~5A@ȫ&0j d@AL@4'
B|q4L"P}!iAhX x[=8BhmwP T3M  2&tR5`R`&Mp$*DkѨ 4> B 4 "D 4i	PD&)fAh ,

8LP"PKAhl*	,*69PD`DDa@h *
 )@,
C
y.G
B 4W-sx T/%&Xh
sd 4SADã ur S 
;| dR(,\/_SB_C002@ 3[C2D3

[   04 \C1F8
 +\.C1E_INI p\/y![C125 JC130[# l[#\_GL_yh
C05Bpi` Cpj Dpk Ep
 Fp1Fhp `	l[m'['`"5

[ 067L
[T 
891
A
{B 
2DC r DE
 #C2E5
phb 6 @@7KB>D'{h
 ~b{zh
  B69h	C2BF E8 6 C2F0	D
	D7p9	I\_T{Z_FA
Zq wB
F C
<QD
21FM
?
 #   :D v{
}ba۠ 
 C300
=
01	A2s 3
!4
5
637x,Q9uA BC%+A801A9
@	0511AD
&0
D
py
i a{qh a p
`+`ߤ`B
Epi dpdaQj ,h
}d`d{d`dKדad 0e`0bebCe buqc1)b
 {b
 s1c `q
pzabrc
c\/J:06185`KF
qpha
Bi cc0
hr@Q! !C310i `bb11
~/ th ph`i
{r`Qbt b
{b `%p
bE	2pF3C` DbEaEa`+!ba dwd

?drd


  ,1aKt`sc/,uaC  3uP46
p+aA5 B CrDsBEC $ f 1qSA8(p
,(o`
9`qA ` u W`Ca>QTA8!{%].` a/V51q0tcCTZ0__AC00axa

`b11~(brb
ba0CE

b~2__CRTpr 
s
	
 !

7a=Qg>224E?14	Ih
s5<`?bqDv+4E*4FccbpcbA4@sQ
?1(1@ `C_RYbCC8b85bwb

araMpLa`xzPo1E~179aypab2D)aPR9h 0q2+hK a q#O@Ucpb a$1`XhE{Zb1}^c^#{A_b pKha=al`(  v`bBk`Rh :07Zq `D1!>T2
"#_5`h3rb'9S9aJ
V^h `t`J`x`@fUf{
8f
f] qt2;cbbc7WbY`[F=Ca\'a=9>
%f1CAO"CG2ag	jpB1g6*fL07    PR_CPU0 1^[L=7P_STA }`_ON_AE!9A_OsFF#r?e236_LI}5A	5[:D89A]I/[3 PBs.rq_HIDA_U0[U"pSCMH8CUD9E}A[L	i_ALB 1PAL2	A;L3C
El  "1&0`B2F3D3f`$pm
 
_TMP1Pd[sH0PSV L(0-_TSP, TC$Ѓq 2P"[9Au@"Y	[MP	3_ 00V	 ?	Vy1R}J[G y4 H0p
`hhhďph0P	{`
d`w`Ss`rT ED$31F&,0'#,C3_20 1 23 4Җ@3 6 rv0H327026
[ 8@(An`L292A `[ AB Cޱ`U[yA
	 `iڠF@L2D28 aJac
p`rd b}y  baya
a0au20cA  eraye
	 evepe ucdcM2ErDcpcAbpbgC	bdp apbe)ecb20e f}fg
fape`pfafgvdueA1` gTbq20@@$}g~19agg7agubdMv@u2F086`p`!p`cע@"22  3"yC027й8 7  9 " 1h H
bhQrF 9c`da.
e2%-adft`f	ru'Ruc2ftd cg0r:`4b@ 7C3#30a,7&-j5%EF`Q&4/
r`BCpibh31pV31 D2
Uj123"33"@Fp	4 }w6
arF0bq0+ab`babua2aPo `bua 3/@JSQ
PHt3434AQ`t
~30``9XD!

	p        y p335HG	%A3y3VkHD
F37B
^GG  @  [  s3	7	P/ 	 	3{K339=Rm1D4N
zG	 G$ $ GN N AP P Gc c Ge e g gt t     3P A-Й`1FDA


W@Fp{
`q ^^.pE3\_S0O_c 3 )   4  5   M\_PTSphV1HaAp_j 99pP!b40 3AG7\_WAK DcGu-f8 130I
í_
p42A0`y||
 ӯ6||CO
ὤIƀ´ ր=>à*x
 \8
ISMI+
=ᒶD1GSùC:0D&Q 9E
006ӏ140

O1acbcc:c1AA
@
1Q
} q,%8EN0E8A* KF0.\=R;A1!8ACELP4`A{؀C
@qB\_GPEAXC"C_L00 Poj
c?P
`~{` #{`
 }a
a  [{cc`Ԑ 0a71A8} 9a A08@d}dqc76&{P*5Bb5L@1 C	[09`9q0ppC:F9Mo}
٠+cp["P2#TFO	&k 9C227 !YI

I\$_xf&<["
d'G&2q$BBpK58`M
ѐ'0`
Ӡ*.e3
 C27N58 ;?`
!i::I`sM`
_&T&j'$NP	`@0803
rp3B84oDB9 Hy)H?%E*_E*o-Q(((T.$ o,,,Q R,o01Q-B93TC`Das E-1 "M?_L17 !ZAD?`}W@D51DDaP} tQhhisv0P21D@ FPiB<>q1/</<%<`P5KRmipmDD0n}E`U
dA`A
 lC6+`k6P1z3DGC 6 `6O B D J|-d  ZQ " MbC5   p;b!b!`PV6aE	}Y`1oAD/5m60yE%	FC34031CyKWc)
7I1F}hA
BA~BAaa`bPc. 'ĩ{{a(ccBEQ_	$5 ,BxFa6Nhv5w Sup@^ 0["h0SSDTYǥHP ~ HPQNLP" MSFT@P^C_EJ0 91GEP`NAh ; hwPATHD4_ADR  [KpB"A41% E_GTM p
 `P'2 j@(3 (4pC Ӂ{`V!E$3
pa!`OMhO	i 5`p
w aw:` pA` bwb
bw@c@ib Wac  r0  [rc u`E`,!ab14%
2<as3bcapPp![$85d0Fk &9q
 \f!SC&[Ep>8V	CD"H_SDDR	h[	9

>    UA 0DBcDCEDAEds8F#Pd501}h
1Sq p!ApޢBp
p
A 42sC C#,,,P5263O ,,N,,(,- 4--\--7F~1G 
gxp
}4c4pC 53pQq445`*544J
44S
h,T
5J
	 K7777777755
         
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй -s# hfP u	fXc  h ʦZY[Xg&ǅF C9   Ã tfPfS
u	{p  9f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tˎR>tKtETfu
 0]t`t	dpX  f]ZYPSR uyvkryv& 2qStN tCu+?7:ǅ%. *'<t<  
.Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3Ҡ>=  :t ffKf>+)a3  `49f 'D%g$ЊFb	茐 F0蔐r4Vu'v{ o (c^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
Fff.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfV !fKFt!hu\gvu U>tU6f뿢@)_a[af^f!aFV  ^SQ  90Qa@9taT% G苆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRV#u2lr QER= ߳ u  ;&pIS]0`@h1	V( UP " `f3۹ fs_Ձ@T@" V2: 1Bj0 fy=EFfC`?	5	_tt$yGv葕xs~ !"Ⱦ
Ќ (o
d
~uW
1?MSiqp1~uZ/'7FF}u #*V$^fȢO__o0V mX^ҎD	%ÉD	f?r2fpɁ v Ss<v PfUf f fa$f6f> f	>fBfff]X߀ t @PԁfPQ6[f_~RӃf3 cZՐyP5b> t5zV`50@@Y!|p5 ೀ
P}@@x6<{=f;tff* F#cG/$K ëӫq  ~gfEـ>  fù& fσ;t)gfm+ C k H2|`Ekv tߢqzÿzPVw  ^fh3 ;u}; n0;b7yP7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
 xy _P b6_PSS N SPQ O _   _ _  _ _ _ @__  _  _ _ @_ _  ?P@kЦ?1?D?1?4?_>_>W=r;\/D<Z1Hl7HC0H9HF8HI_CST pP H`s;Ga H	#
 


BK `
 
A
of`qI T
9
dGESS@րO3Z `C
*OeA&KG&e@I&C_C1__Q
&"1n6D6nPmo:n\ pC
nIST  43A1OU0(:L*\q 1d`xL
 C}"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)G؟pXq9SAbDAk
 1 CAP0IID  1 2	3sU9S
 E  1c`23?6q 1223ޡp
!
  ki_
p

G}B? !L%A9D3	 
	{ } q[=` 0   [ }I NRJ2`M5kH!7Y!1!q !!!1!1!!!1! !!1!1!1!1"!1!!!S!C!1!1aF!!U1!!!1!%"!1!!1! 4' !
!!1kf`?r^faf`  ufc3pֻ0v , f!6j,gfwP׋F GPrR(W-n<AvPUfVf>n, uf% j ffZ	f_y{, a ufzlfr,鸀, 
\ j,z` 23v1#nf?WfA_fr1f
={rGXZ0r2蜆f`_ rRfGf>|,f r<
r7 	`g&V0fqf+Ug&D
3G&NafaY
! 4f	 g&?u@u 	t`;vڕvu&9OpCqQfRfVfWf-sIg&wOf! ff9
f  +pffff+g&of0^fS$@f[ @    	`@  R|5O;;O SZ !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXhV( UP " @Zf_ >;u<!aPS- pu;;` ;;;/;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; P j0fdQu!;! ȃ uddfdd l >P6Sd d\dtP ʱ(;;P:Ug&t=` T=f]t,>@u%ttt t	tfN tF ߍCr@uAalaCs
 1Qh 6mbuoF . u$
TVێeS tbrtـ?XD@?f `fp`T fffXs "qy#uptLe; ` ; uY^f3ffe;bfWYдe*&;8fw*fF*2t*܊e&;fX^fY[w'!(; kW" b  ĀuBTv;|  tB2|k}SQVWU& t r]_^Y[LS-120ZIP 250PSQRV:1:2:٢2ؑ2PKp
x

~
5	<;2E=k>
s!hfP u	fXc  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfG(`*X*Xu ͠HAZY[0^`u ;Q;;;;;v0 RW1hK1

ma} tE@/_Z[M-SysPDiskOnKeyP#jB ut @  f<x fP f(0QA˹"`z|= 2r 0w"1s ?sU3IH $ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&,c-\w?t,f_߸ A% rLTf<Q?(UP5Qe}$ b
ԯ1p<p< t0h(4t u u2$3=@Af?MpI`N 
fXuײ?0 000J000FF 	  FPRdoK@3W~2>#>;2>
a_YhG; 4  hU| ZXSW0+@0s!$?
u$˄[y_ - ࡥi B t`UA	qAq 	  8
		 
	 						8
 fWQ ˹O?Yf_qD=f; D=;FD
$>;%
ĈD
%詠;IbΉs@s
<rI`d
Qr7R[USBS{u\ t t
U	 	`;KTB <;9١ p arQr,< C0' +% 7F`2PsD QrIt2sQfFa׽fAY{rٜSfigf^qf@FH\
؀eˉ\b$K
prA
x @
`0
!?
0
"7sTq
aWa'"CS#PD=qq0*W.?43'T2'úg0^oZ(ڒZ(
_7
qO_=%t9T$RQ$2Q	@ ?WK@RP2 s с>[bu g&` T=
XS<(fiʐA & y~j6; ~ r}fPQt:A3>Ϳf+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9?y?,B3ПU+*/sG/%QfP<h`gffXY"~Nv0\OސJ?^;G7/Osc`sMoDA b@Ac7e=S$l=38%p;Obt mbt ab`;D$
ƈDaz ϋP!l r
9rYAݿ /p%tFIðtT= 2:t+:u hoety(u~~(rt@Ob=@tmb=tab=`	t[b=Ѝ Obq6`oWfa0V
<8dtd߶}٠rـoپ<8Dt_D$PQFxPhr٠dl^SQEO	8t`g	G	҅< !" !  3  @O 

  !vv xQfWf>_l Fo'#f_YØPSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYf[fRfVgfeG`-PgeG,fQ"!
6'Ps ,P!V _f^V;wfaf]	6&ys'&P/ryRvRr30
?geu t0 AO@ra'P1806*i%AfgfC  ggf	 
s>r8PjQu:YrPiAbp
fMPs
f	 

 { 
!U?W'eGseG`~i_VRP 31P@gZ!
\
(#5W0
S
B
%?q}~r$$ <
`flpcC4C萟s!hccoreeJ1*A<tK< uMf5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl |u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
_ww?`}pR翋qx& r&L&T7 <|PFh3P(Pf_\3VAf?_ffXqf 
qfXuײ? fffW Nfqc:fp]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF}reCRC5P5PI7+6p6P b!1fY♠
W 
KA

$I#j
p QY6BeQep+	Y	xr1 /
U2WQ
s⺑SAOn}%tJ?wA0(PZ`S1_Xf7񇟘Bu 㐊_
u }% 
 !?g!%KO 5Ϟ     }3f  Ptot 	2fp ufxqtp  >tfq f	bCfff@Orfurffɐ+fԐ%ЮQSt3f

 sఠqr`QRޑ0cD?f3fAp@HR
fâPXpAw f>l`_rfC
.@VS&7 ! P`0Uu

C	ݾ3ݎεfmqC &V" PB3
q a1a!@%[pxtff Q)`"(! BRUu@$#o%"*E   u=s5# r,Hr'7
 NPSSg
#[@P)'C,R"G-
"10v)%
!02 }Vf>/U`˝8?&B?f P?!?Dpu%f<E t
t
t&[ sPf
Z͉6/- gwFq	g7gFq gFyps fbB,3u +0+   < t?  ;v?ȉq tv  f@-^fflgf
GGеgG-  	R
 Q
Gfyǁ0ffHfbf@@I1&} t@q qg fy00SfRg fE3A,3;	@t`$2f&߷F tm	DG^^ҵ!  sfu@Q	Ffy  ǀ=`G
  A !Iy>					d+ఃd	@	nO	@	D@4 2@B462=fAى7K"xfݹf59щ"hRa{TboHfuKZ<0i f&$usZ@U t`)% efc	W\Du=F t5f\{lf  f+8f;rߔ      ߔߔ֔ЁЁv"6_WA~____T&䁍ti@____YS __________|___b_____Y___XP_S"^ ______Y3uyU=6Wc(
   ____ 				O	0ScfSc 	Z=&   vA	w.s  q@ D `@  "eE `i @w/
@ АRj@F  Z"z SR  hfP u	fXc  h  Z5=f3fZf[lf M@Q~gfwe@Qw_faEA	>dlu?cl}@fQfCdfld 2hlil%PWf;f+Va++ *@ f=~ ЖfGS	XAhvUftQ3я_;ad̿ /p1Ж$4	C:cl63
f
?)I34ө% 
3и@tBՠEuGf>%2ggefFfGff!g {@]] f2+ǐ?fj-Ѿ@t#of+ qHt-Af
 uh97gk)c)Xt(8{;f	 p~7el A}flf_-c;q `u @Gu
g⺀ele<>tf Wflr lsc`u1ge~M} 	C =OBG рK~f  #$<Pbt΂ t
@ >hP
>i~
 PHj		%PgP3=- 	 ?D9D
eVfrFsr?2 r" f( rFu&&P'Psp_"Sge8Ftff;rqK0D>$O 0 ,d0f7Wl@c 0d	fВ`f! W jgg_$"/ւaj_`e{OeW$kGb plgq2bY!BfβA cGROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
qr   2!	A.>  
 x  x uuo        St[Pu&u u!KrouBuB ?C > XPS tuuu>uuu~ uR[ CruƯKuuuuYQ	`P^K`
3؀`u&svutv3 upVS@t	V[^0QVug&"uvpJ3fu1uq14ߧS1㨿éu跩[^PSVfU>S>zv>ϳ&wvt(
ug&uuN[艳f]^Vt>uu r1߻vuw%0r~@!60aSɫuP  5[6̨TWai`z2穀ОQ	2pUt1vuIh[Zuzv~yvfPSQxvĉY#\SPćuff3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvb?yLr;(qurqsVW@fFtAQ څt(PǴ:vvu 
  gXfC[Yqq q9~ w2vvkY?ⷠuv`Ct&tv8r #>tPw{
$_P#0%uxv.v2 uf? t<CP<tSQ@Kذ&Y[ـ u
lq ` -  i8_ @` @8h
@ 0p*	qk l8 
		
			 				
 

 fWQf&D=QYf_侁gD5 ;6;;ysR.;Py``}D
$&;
Ĉ?D
 1Fs fg&|5 EBr`r  a`|	 		M|0R		`R}H?\
 {;
܉\se7 bb}Qoab}f`ߡg&`r ql=Br`h >;Obt mbt abt;D$
ƟDf-Pfp&߸ &p;W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;连j(wf
T= &Prjrp[bu6;; 6 rDQfP.?f.6;8+܉fX2fXYffrhl*`	 Y*a 		$Z	hb %G0F
/
PsV ` !sJ%|=td%"t+T=:ur?|`B(uq!(~rgOb=@tmb=tab=`	t[b= .ObhK1_2q62ogfaaoVPCL	;t	wPAq$ضR}X <R^ASQ2|O	8tg	G	ßY[i0   0    RoO d q n  A` о 0_0 3`  
& Aa t%  	B%
0 #
	٩*
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
aT S<R"G 3 D%M TVaX'K8'(XAIc  WpI O  x fSf fV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 ffYkf[ f PfHzRf3ۋu#MufVku
 @ fC  ZwW fu$޳ -U~T fP%offXrdqPt@5f90f  f
Wf f;Nf_AS0>߀fz薶r@!fff]f3ɠ  0[  U@ Ԁ   U@\ Ut@dl fVf$f&o~   wt   
f}D`fd.f^<wtP# Q5 R*Nhrz4<t
_t %UV_( UP " Qޠ$0@f"E$!4",޶-PS1#|&3M38t< t 4 v-#tt 0&#V>`OgV8p < @DHPMr:t"`B-Zݡu-.GGa?;-?rfTDaff} DI	fAKfg8u#HDҵqQrf1s
f@ (`+1HSHPS'}? OO&,9`f`hG|(!G@<<t<=t<>t<Ft<Gt
75}5qGN1Z]    %`M3f0V| tf<x  $ fcP   t#@r7fuB aqftQS0^fC`BUc U44`f&V f>/q% }! eIf!ig~>uPi

qCDq; ^r
7rC
°Ro-?  &f ߡ6wf  sZqf9lu gF9u 9u
gF?9еtz2/g-tvVf>l  r?xsFf!` gFqg^ g`A  ^Fq 3:`kF^ t	f#;QoG;.;f@B23
 "4 !Ix	`				D+@i	@	nO	@	r&+롛   0a }BM ;vȉq tv  f@ 
f`3fۡlgG p еgG-PA	qGfxi@U@Y՛f&Y8z"!1gGA&@t@ af9Br SfRqof3_!^5{	@ Sfttt.h.uu7  V  	  i@ Ԁ Copyright (c) 2005 Intel CorporationN1OS@eP%2p`"ѣt2Cqt"Af%  =  ҟ <pdt<tH<tN<tL800uxuju
T4fPF<:f!a<ISGou%fц	f`C s
gJНRVfUf❁z f6bt*ZpGt
B s ` nouhC%t.At#Oǣ4ǣ%>ӥR#S` @ İZ-% ` $fQ]]aUP.W)`t411wgf#f  ϊfYR1txT	ː!,	ba'""ԕR4bSHЏJ
>Pe]֥u}xt*HIT$$*	g&<ж1	2a?5c	07t$N<t/5)
`FO0E	@HK0Rr+5$Ad pT6g%q6jqf$, ;g[S.y1l?lSMQ@	r#<0~^W:XX`q @O0 u(P*P  rwyr} Yr)fߋfWRdhZf_rJPSflp>8Pu	1Pil3 hl&P%P[X} &zs	f d w 68PBA*P?È`
 fd!7P! ȃ ud|d~fddf@l66`>>á0\ dtffd!! d7P!gewP Wttt t	t&}z>t| Ƚs
跽s1|SQVƾbtـ?鰽&Dѱ'߶fATff_fXs2B	x3p&t&L5P 6P ߀uYËiވ5Pb>W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	&  	ma&} 
&_ZS/-e`&-	
[`9t4h(4t1
&u ?&uP@px
W  g&?t?fN(g&~QffÁ 
(r~cfvg& uxrI`@PeA
f  qf  paG,(i
 !m
"sGkO8b <fT tf$B" Qpff
of' f?  ftɥÓ f&
pj V 0 @ s	<W% <t+f R
 %u<  	 z,R
/"?r>f{	%r
 PBg %O +fp_U/ErEF?<p)  
 Ѓ@ η`#ujRca$3'='pf 4"b',f2"u#}   qsZ ] [ \   z @ b  L ` oa e^ @  A @c 7g 2e @ uf @ @  k ij  @(T @  }ն  _ @   6`gVf.VP Zo!f! ( @O |'E$0 fpP	x	s| L Ifl  h@ Bdf?f;  Wfff;sgf9t LSf_ѱ쟣f-q^ZQSf3ퟳ h4OOetowub$r	tf1GI#d4@  $t؃ u˸착ӡеdӸfZfdLfdLDA$Rzh۪W!pw!芔藓hoԀfof~ ea.d@t0WyJf`a؎}  @܀g_fapq23 g&s g&C#gӋbSf3Bpc0zC
uBUÄ~@P>u`zt  X +R0ff%f`O@UՐ Flyp_ZQT0e rcL~" 	
сD. P2Xöf fЀ 0	PR$Z  fPx{^pmCX zCׅC >#sB3"     {B;tgp ~tuftP Мނ讁Ъ2C4"Bt'BG(Bu o9Н VP*0KIQ! Kj
qXSV ж?(sd^@c7#g&wKZ
P4CZ
@ AZV  	
 !#  ! a "avb JQRVWFᭅP   Px;>@"	 &qm)p(ofлpoC!	u*=8=9>9  69p 71	0	w"z{@$w>zQK$33zn!	%puQ#VS&S?3'~1u*uG#> 
Gu`#$?<Su? ߳PΗtF	t
 t 0 jd:u> u4d> u	1 t#u<ufm8dFu<u2!u	I^9 _^Z7g&8!еu	g& B%DtFsPVS Өu h8C^:RV˨Wu^_Z»ۨ 1]u`Uf覀(ot~oxf]1; `zr;f.;t3Uuf={#fË`?{RyË= v	 +v9q3~f́  rf~fP ݆ 6Ã tL;T  ǀwǋ;@t} 1.NҠbL7far9 w0`b hW|Ñ$affNffffROMIfMAGE;uQ;Wtg!3\13KPQpJ 2!fGpZYXu@nwa0GSG "2h|
t"t ` {t	V M?\ cu'f t!AUwbA
G94PG\WG fCftFkK1O0E0b RD;gfT  O 21"Ê+- @pHPC.ШRPa
>1?\aPrbn ##V  U A7v P4$w,SV.etv1q^ Q Pu><;SR $u<v
7=:,> [;ʀ 7Gm^rr )0P_ppJע;  u&xS	ۨGp4p<v<`_:;w/pp
QQ	 tTdV
lw&F0org&уto}rodr%# oKrՎQ |o2s
 Jkh_a	Fo=7	t ()o 2?f#n~
u`$MXp Z$,q[p&p&uc   ? DPeаB?t<СGfVf搩fۯ fސ表!krПcfm\GRБ #aįf f%f
 &'f0fJ	@ sa  f&u&t   
m4 OD 0U ab bGm `g!	O|SQFZ  wNZhFZqR  >b !  '| da 1%,CË $H{`"0sO47f=   0$pY ,X 6ֻD@vfk xfgEܵP^ҵе	*b			f?ʵ5 `݂-Wf>ʵ)_  7_yEq_Qp@f% kP1εffE/2f59 5`xԬt)` ;sff+co f6>ya9t
3T1I!APk
 !
f=ff1 A6 fffp	صf9صOr
f)p @VVf?Vf^  $fӃ_\Q}fq+f%=x h1
[_>Hʢ\/)ρ]/IfVQt> u Q &*:&  PSK!
Xh f Ӡ 8r
Q

h%>~@t t    f*p+SQ	@0*0=tu}f_P9% n0<s<0v{0u@ N_R  ? fLSdx	 krh6%U0of0u @Q f@ Y#hl<`w$hS*t`C! `! ]>ftg:G}vg_fgoV !тIf0nf
~H( X_Wt%hG@	g&Gw 6X|(Jp.p tapܰsf
"ct
p $C7s2Zh)@ fff}1GȐ6\*z * GfGW`dȣc@tU&ax3w6N=t=tO"tC hMOO4r#
uU0 fd&L2
z ]Q:б ;{ nu5fҳuHpw @^}x~f# s<5	u u^t S01Vt)IfufKn? p耀	`s4t_e[}f0uuWrZtL#[]P1Af0UFQ~Yf%
&
m =ps u0_  u*f&;YBx  s~nfr*Ӣ=RSDTu}l`w_$!f=FACPt?f;voVff!Ow uCѧK(bb D!=+4T u 3$pjSu?Pϯf!|fG u	CP`g3m W23f_
 yG	ZƔ^pu#f0₄ 0o铠zgfFf~f>u2fof@ v 6rRp61p>~gp0˂&0vPՋ>BG0~AR ?ZaR Ub c ?dP&ab{pZ& &FddXPR< u@SRgtXr),uRG`SQr9R'Դ$8teߋY[	tr$V簄O㰆HAr(QSFr^(!sqtrp@ppq[`irDrT~fiY0Yd>:t	[ fa> !  rTvyL=a@wf`yt>A _{ G}{faa~h'`qe`>wv>kO/P#P.G ߷ð@ ð Wj@ȰHg&Cp&Cf  @\@t G NH >	W 3sf_ҞVfWbqog@g<P^fZf3gfACDff@rg@?CyP@Љ Qg&;t4g&Ct,g&Cf4@d$s<12Yf٠
t
g&:#tfC_fYFa;tft S er7fg&F t+_`mr! g`Gag&O@` Nb O cz_ QfVuu+rB f? Ur(al
"$
Q3p{tN@Ua \Ubi qT@Q<a[8r p312Kˠ P0U `<r<9Pŀ&Yqtuq "t؀><:sº7g>   5d- ?6# E, M" d 22 /U$ 9( C K U##FPJ	ubUvPmȇF X PSø &ZȌp XȎ[XPSءZȎa>@sXDA ` @@} TfP&̰ơ`gP,`fX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   `    ( ϱS(     ښ      g    h XZ +  ;p?    / Wh S       ~   P           %X%H_&                                                                                  3f3ۻ  f@yfg!)A  f" 0 gf+ >n `hK1fPpu	fXc  h  fUf&af&>m` 6a  !ŀX[ &SP`@ /'ao&Uߡ&WP `XP&EX% &E_YǨ ooooǸoc/  f`	ffN%t$(%p$Ū;%r  .<t
.._/ NA NfafPSRVfpr؀tU./tA
 NUN踾hX|"^Z[fX詿4 h_$&À> tT%`b f
fftQ sPSfQW _fY[X ve i?XøpPR}	B~	Z }	B~	淒3 $ `%>&w%	 
  3  t!   BfQRW0?_Zr q>roPRZ` XfP~3T f;f
 $A%
 ?fh` 1 0 0 00010 0 0aPQfW@@D fg&?t"g&Gbg&Gbu ߀2 uf   λ(  
uf_`a$$
a C PB 밀B;ra`ȾJ~ƀ,ph*p \Q  7a* : ,`
\22R9ĺZP ,ȡ%(؁ Ë;34 b0g&D40Ft*
 <ἢ0"(`0h! :f`1fM2f3f% Pj
 0p!P!q  f
P 0XX!@Kf`1"f gff%? gffP)pA`vBaPfSx,(CP0
K ghC~v CIhFlh Xg&CfXCfqRPfV uf  guugf>u
 yf^X7f  	e@ f
	
	
 bQWfV3  +t-s$   fRF f^_K..6f]f]** End SetActiveDisplays: \  R$Kt5< u )㋗d_ w;t  ^_um Z_QRӸg tuXSQ2tN
͋كY[P  E@t߰ @e < t\ !Q?O
 ?p
; 103t0	p $ - p@lk l߬@_$ TURuws90
G :P0n2:P$} 1:":ċ؀ !:X:X9ZR9u999X9ZugR`9a tQ9P ÀP9QRPSa[X3?tapB!c
K JޒkOu$=r
u.2*qLP8tr$p&` E&]`:@" _ faMq t
{;$<??? 9#ftU]f_f/SW_ð @ ጰ .9trH rp]ޠtQP?	'ftu 蛻&AprKf`f>f8 t`Bf f~ faQ`aYp`T_<_@gfgf2{g\PuFtQ SP܀cuA%X05:t p
ft° d6l&_  RhYrs7Q`1^t,>&t$  =u a3u<w1P$<w	eP1t<T"W> tUuR uI`)B<t>t9~2Ar-r!\ W1tmmG! n_ PnИQ51tZ tgqtKuAr3Ȼ Ls0@G <u$
G諀O } 2@ gfP0G"raȱ0tt7 pp r$ SQVȾ'@ 8t"8t?rO ^^Aet,&
 lr>ut
$sE 3t> u.7"t$	&
?s@ 2P
tok!B	>!2
?t ^.d}:@z@C g$ߙtCƠ P+P  1r,'$  -->w ya>qm	 23t 6 c0q{u g *t%or0.>o uBu
AiS7ˎ (t#4r1ڃPDJbtVFnr->G1.tBH0/-Fra //e5-t_h5tP{ PrBо13! s H E%
 "i275 =5BpVtzu`<طctb;0UsW;TsQn<u	 ~]2u0r u"
uE"
23`<  àvt f )Ơm )PU>kSfW/t
,t`_8؊f_[uXfbsg];rb
]
lޠ)50
M4u$$t$
 $l d?*X` ߎغ   nBnnntnJFn aS pÀ 37!C|&?!Cu3ۏvR .Zhjjf!:^X?W@7x&::2>&?CPu	ЋQWV		
 u	ݓt
+t@QWPзPR怺NhX@.X=X@uX_YZ0P0yu $ q0f.$[:rP*
8Xt@K`uð6_C @B T A2QgffgH g:ff3`֭ffffffߋgfffSc<(.&;BfsD?P
hi"t
W4	fR諷c6U t ͊

(
uXO0 #Юf  fAp `np Mp 0XhцRÃt%tg0&g!ggf`fZRft9tg>E @~ {9g5Cg}gfRVf),g>E %g>B !P(^d`g
ز
. *  f  R"Q2` @`1/YZJRP0 `8P%,Ⱥ:#%h  t
ف     t(  )Xt
 %@  Pé P+o @+3 %tVfGf3ȿ f_ff3u~f>fff#f  fα?*% ΂  HQ0Xj
1".#؃ Ӫ||3p%@DQ#Y3#`a ff%f!
 k0+C@A])15 	 )
K%?
 g&`1h;F4h5
 #o, ڙ	`q= `u3
f0n:u aE2
 V2~2 Rv=wu
f1%0w 腨hBtEf0P tFf6f(f#$$* 5 !q PfqPR!(
 lPn_Rf +c ,3 .uSu
`޴,q005SS414pSH1T& T:1VV,1h&_aw,0Q>h5f~ f #R RSR-0@t3P#*5  PX4{Xtǜ *2}ZfQR3.  u@=m@`>0 @uR+}0t t
w1#022Pu%#f%1gr 37tTKQR(;,;f ,`K!5 @@tfH f!fy +1 { ! z 1Z7RF0E`9;tEP' tfm tF F!( `?t,.028ss!W *!))]+Xyow.USw6M#')X+!>xvye"7SUp*vW7K
~*~\@/#
V)	!%|*`ȺPH P q&aKPfWV V cfǰ    X`fYfXDu1   
桢 hR9ѡ  ( $R`Q  PfffX f B7f0FoP调s"QY   ` 
a!S0]&r&d& 33'#j} 	  if&f C_ f9Gf qP4 Pf%\h ft0t ۳@d   
 E D6
0
f&	_ -(	!	I$	@p bQ(% = u
$= uL={   * @F*&sftQ3%B,@ 0 (eDP 0 qP쫺D }YQ A~ ,A}048|@WY`#B|A%"u  Gi S8hGV( UP "  G   ؿ%P_@G,-./01289iF      `a***$ivwvD&RF7*$aP6oG3"_"
P_[2t0aÜ`>@ l> l!GA lBla}6$?C ! G @ A  B  $0sF  ؎M+n  "M+  BnnnJF$a %JF*P *<* tq ̢}*P *̠ث̡K+ޢL *   llB  ؿ+ lBB@6+ Wl@    @ lI+ТJo+N+&&+'=+C+ /$а 
@  
FF/n  	Un	n	n	n	n	n	nnn 
 I+J+t**a  a*@Cd0`  3nnCy q
p		 nA
` nK+.`4Lq @}|4g&1RP@' V%#/ f     t 
> u" ^QWV   f  ] ^_Y
f`h~Oϯůaf%=t=:0,hNԳ20TofFfAf.:.>:u"f  f ye
  sQ1UfE fRPWf2P f fs  3n{tD
Ah	7:faPz f$gP}a 	gff
30P0~fA_d     t QkЪ8ЄߋhNBfaR'
0
ynhmOS3st*2	覐#02_ u!,0 tf   "00.0pp0B"{@/t	!03Dfg 3psf3 sCX4րRVW سMMffP f
0u_^                       3"0 *X3ɀ$ tpkT Y3OѼ! u BY3K aSR t@B u$Z[0WP VXAg0[f`Q
`g0aPfW3f3ɿ[3f?0<  &P t\4f; XADZ3[ fPfPԫfX,fVЁ`JVJ7E gf^! Wf^	V		)			:		/Z3	^		f	W	Z		_}g&'pf@#cA~Sy! , tO4{ف" hdwTQ =sY}@>uD`ut軁 03SP[C vS3ۀ> tDt]Pt:]PtC  [0=t<w>t8t, 
?轗ñ  S r t,  }PP肗P{
tr["vۀ5P4fP	RAPrA a8	 fXBqt[P	4ā{@At1-w&ؿ㋇P.trwRa	t0
p\:< t
]::@ 0  P@ۀ>@utPaÉ  H

pI J@؃@P2J
s3y@si  Y ݃&
1F0٢3:4:6:m:3:u;pu;thPpP\:b\:-! P ::::tdww
210:r  &	&]
dÀ
v
 >2d022'hǜ>hdwF.	fॐb]]_u0 2f IfSRt F<tv`$rf1a9pZ"/tdQVW[rQq 0 _^ }T EfѰ̠[ft
t%SKy?gfQVv3Qe KP^WSQRWVh?rGыt(
 tuu u0/ttPuʋ軟^_ZY 
W?Vh(Dtbho%hp \Q    6W p 2:> u6 FHt\o hz/4T3Ҭ؋hzB^_fj
{̈́
>
/2
r
ת>T2@OHpш

yr.
rXRYeXZтA.A
XRo@X
/ Xao/ / /  O
XB<RwS2.o@[P а?8fQh_(fY\n=nl"mq0W PIǸ`FXqqzp&G    &Wf&{t ffBf;Pg&Gww~rtwRtpff@h
Pd8͎QgfYghqo;~~mA@f^PS!>taPS  htWhzGDC2f[ C   `    KD  f6Qhf=HIBMQ@ u_jFwff% g.9u
g.RFflǿF "Sf= @t1u  øΉFjQ F| a1&qsNuFgf~ޠtVf  t
fP#ff
{fQzg1"F$yV f;s	f
ء  fV2 |~(Ff )g"f+s
  	@Nf;sfȢF@	rf@f qg&g&fFfGg`L^N &Vf !fA=uTA$<ufIg:]!
g
@tT	f@f 0ߎE   &EE
AUt:r 
8s# 52tr 
tȰV$<
v
ط   tǀ>E t o$
ؐ 
/u$0 u
d w tַBO@׿ [	^hss|E

0d	r	
s	 au _E&EG EEP>E u
8w`fWt# t!_PR怺NZX@:f_`E `R{D {&qWx-G@f] Dft Hf LflPfxQL 8 fU@@Չ@@PPh >$|ft	S@`	f% fBSAP*G<t<t<ј&'PS$<w .Hr PM#G  Ŀ c6h_r>	fO1e  H` I a ! 2!g	[	Q%_f"WZ"W"WVTofpQTfGV tT00@&Ht  {qT`Kff~3fP\ްfPA۸vf<Qf!<w~  <@0T  fXf?f
e8E
ðG_	EɊP\
P XuOBDۈ
bo`vS! uo2R + [G2P ѳ'oX	@2q}P2ۀKˀ~a	i$

|Àu
<X[X=!tP-a9؀ߊa
F2t HP@<KrKX=t7>tLK $>p u0z  Hbw\_r`0u< 8t3r-<t)u
$&4&.:aEft%it2tmLlG Q !p/uIu>Q &tOPR?LZ  .LPRÁBZ s  ""
ZP{P>aTiLiL Jq vJúQ R (J
PBX
	SRذ4ZQSW M/_["h    
@|f ff7Mў RUfFFrR?0fNT!t"pffvPf軐Q] fpfuf Y0fW M " U 0𞛀 G@ +fSY0GT0G }Il
 
UI IP:}rM	 M (P: GQW
&&yޡ &{@Iy_Y`9*z &&|W"߰~ {~{2{0{<	hXofř	'} 	6| h2_$cRO]OhOsO~OOOO3@MYfu3<ENW`z3;DMU[q{cw`CKS[z} T^| 8<AFJc|  Oà@ PP Lظa_X!.,غ:?%  3` .Pȣ  Q fеag33B3oX7!  7EE$vaQ% H$   {8% 1S`S $VRXQEV QE8o8! X% PPPPPVaRûE R ΙP% ݀0.&,˩ߜ@ 
 C KV  0eQof`_2t5fAȣQQfωĉ- fa}CTNI Q0@F f(P7f23@ hQ@ƀ>0QQ25s 2cUV<2`2 ' 3$0z w[.>OK^]2 	X?sҢ tiu%tOhu0<|r7,aP
mďR!`A@uC`
 
  zx@ 8Wq
ppO|<Lf.fI0f.q  _IWI !N rۿ b 
PHNYQ	$%uhAT.=j P<^TS r.HT0wrĀȁ.t D(HtrHwoUu_0h$@OYh2 
03!47)?+t
3NO+t3GNO@UNUTU(NU쪺P aTUSRU`b`q/rz

PXhhh&sMvPUF X PS"͌&U&U&U[XPS2UUUQwQ5SD N=R/NCP bAwuuu&gq гp  ~T[NVN&VV^qLstM ddM`
&"&$S8rdd8rAS<dr
d22`:WhLڠа;y0f> Ѳtޑ)StO$'ָpX&&m}b]~ PqPM &}wXs                                                                                                                     @      /                                                                                                                                                                                                                                                                p( f fo龗h2fP u	fXc  h @   foMgeuge&p #t)fSNW bQ i  f[׽ 1u $  g
ulfe   hp \Q |0uIe	:f f  gf&e /-gg0&&o  P         }   <  D ` d h            b @ U b  "U@H X \E HTk 
 1 
2L 3`4 0                                14   @  8 @@*  0 0J	-T&#,l         Z PXYhijklmno 	

                     - 
_,89:ANNO Oh`hfPfSfW2iPl  Yh'/khs(mf  @`@g&OZ	(Qf g&f f&f~4ffpd PTf_fYfXq [gfXP5Z &g&sjxr*P "vq[f~vXf[XQfRVW f Q  !Q  A!!ȑf%t9uf3f3f.2fff?u_^fZ@
f"uQ ء f' 9ut
f0PR5 % ZXPSVWfQ  maي t
؀ut upf{w h*tr ǀu* pv @uf  fY_^[X) #fVpff
  ffs   'Ct!
    茥f^f_"Ó auEbR5  g +X! ߗfPR0-S0	%|h v@
1`,Ⱥ4Aߋf# uOt0!\f @t1,#%9tf!!Qt1 f0 t0`Sf.zfuf  2YZ02|! z-{;{{|{{ |P||`a|fW C@5 u8  *7t Pt	Eeff_   _à9ffSV<r<whf `@ J<ZuG%rx< PQT ~^f[ v
 臭fp1`	3pú:tptgfPgnc 1N1\ʑ ĠD@)@úd7 u"A$
   t 	jf 0 ; 4P] PQg&`w%PS 7&%yPPbMR(p\`8%>ifPSQRd0|f#f|%P.|4C"8|!''ad 
 ߣ|f3 Q'
f~7|bZYdbR	fנ?P'' |p
f|1fϋ|
s|?qcfb3 %3CbnS؁ihfWV~#t6T;p%ptȿ fft33u0Rg R3һX3t@s9r M
'` ( h%Z re o
 * A4*f&TQ/P~f%\\ _|ar&$eYl PAW؃ߟ22PDðX{Rf\Zh㽬f`ois $ mذgwfa  : !$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KᄡAqqNˆ+[Tω3勛Ԍ2lލ0XΏf`0,tfdP lrFrAPK}G  heܸ:aCQW33 G.%/Njޱ߰_Y 
zn
r' O
( scr)S0@p[f
a`X𥀿[ ftUbEh'ڱ8P4	\_ˀ t KRQhӰ,YtM
pDuS"@@}[} Ch#v5P\ ˈR	\!?
$4)uhrzEhؕ)L&_
1\ ƕ
 Y6D	GD	6u1_47"17!@:7 7(77G~>eORYUXe[ ^SMO!a"d#g$њ32IZf%wf ߺUCESt}0G) 0t`E@a2_"!a\t+ @uY-`@ރ u@.ZstF
8  01蛮2㷀
Ye!dπdf0Pt[xQ %J  B2* qfd;t@@B=RҿkM tD B&G& rѷ@X=F|a' f   fޯifqu"'G'Pz#I t8 t%PR怺NZXw!qvp[4	fPVW\'h֯+r/hufq ^ ȁ v t! Eg  ! '-c2#>    &p1x%f(!C>ãwZ  hŜh%ǝzfzwE`fP g!{:fFfGR5PG:g|< t	 .f_{8 RGfF< SucA%G' +F9*F
 ( *9z
9߃@9`  9f3ɋRD $wf3L MB 
0::jX3733
0  7`SC 3
w TQT!ZB"QPaF2  @FfY$fǪf>I_r	f_@	bf8e#dg&GLU_PV0 'vB+++XQ +Ǖ(	((123ff20.$gNgsVq	f0J@*qfWbP4fV2	}A
0352f^
k+f_rBi _^XPV}"'PfSfQfRfVr RRSSS*SSgf&sB6Ǉ bR2 R
!P&B(B~G@bRH B@t@gT`aT@y@r3tY3 ~ r t	 @@t Pf&ۋ _ t}=FQf	w u&d,fV7 Sf^5 ф	@}? -锲20 f) 
gf;tzg{f=f3Jbffϱt
   50 2 1@`@a@:fBfߨ t1f^fZfYf[f`Zu PwKFaPff#ffдgL rfpa,`-RQ<t2*f3hѦ,O߱fuDOd9g>? t'hԮt  rmI2qR uY [pCMc7LWС \nf1D"_1$&~_؎vEojN(t_

A
r:fuO%_X0r2/F< G0r/8u/ fZYs"&~A     M47 m       _PS  'Op [X0w տ$0l$ʿ  M D=pʳ;)A4)))\))kJ>))oLNtt/)Vs߈P ? t r=gG05+?+<+:8+#r+$q0rQZǂY1LPtD6`K5+lO5
 22fZRLR   ZFfPSD7`TlKJ&C! r
p@e@a	[fQ[
uxKhHo9f7;tA34`dVf`Ȱuas+K1t-r(8) <u0;ou00 t`
РG`ћ !gpA]P	!gf>tq  u7gf!Ѵùb!g!faQfVWo,!`f$؃<t<}Qoa YqpS%P
fu n!!C06	 Y P}Q1fWhtU  </(y
rchMoR"ZY0RVs	w!<S@!qg@ F UoY]W, ,e
mq+fPfS0t0PnZ.%tV
fffۋ&^q
UJ 7SQԢٻ h
p<wNOfWaCfaG?:	f_1p3pNZ  Y[R־<v=mA
tR}s?O0ۊ؋h	}Bhy%f_Zp Pt`iXs? SRrb9wcw_ Z[P0fXf^P1aMgSE@@t8B`d?oD@tB*퀠!!!q$1EZzEf`tfdP lSIMWuUffyCp  p?f ;w(hoޕX@/fapp !f31?SECUtIfuffdqT  {R Phrzܔ'XذV 
u#f%QX!uOB-臶m@ @Y@wUh,/D.S%!sGt<S
 0TTV%V[tP#VXTTtS豵h&
wRL>AG= "%= n =
=ufu>>@ ƀ %]j#ffw	b#
%On& @{f_r@'Af$g&$ ff%g&	 t0ǁ  #9W$dAIfGtt2t~tyf% Kp&鏘 f`8a ,,0?v f 1^u`4
f~ rF`_jr>0:@t, pur%prQY	 cv@  Y% 
Дt`A
A!:0.A2 r&&"

rr(@lRV
\ _rP#j   t
ff;t;2
 + t UD@@D]+^@[,нP<gaq;$FG@V Eߌ،w߾	0R uB	
ff!` 


fffLp pB
grC
`fPfXA3aq&3 vR%ho/G~fQVՃP61=`7:u"Z-*.$f+, 1fY7~@ w.	A_S 
fUfp>	 --

f+0f
"'f]^ -##炃 /I?Xv O?An@u[%f  '  
$$$$$Y3\[Yxry=tf \&{q\A5:
R




gVXl2l9l^l?frAheRwwP& gs/ґy t@R]fV:f^Acgs@A91pl``   ;a ѐ   i "`x}6fu!!	"q&[

9

gs 
pf>_ r @  f 
|lsЋfff_QfAIff)dho1)^1ö@s@KaOLG 8KF!^%QqW0{tCu*!+1΂_ 7f &eͳ,)@2r1 Jҹ
 Ή`f6v#迧s
sN`a GE؀#AGa%UÑQO  3!4f;_Gu Y~б.D&Dh3'	TQr>?S@g&	PfZ!8RQpvP `ff@  R!$^>   3ҀЖ(FffZo5f 
Ƅ
萤
__?_7ҐY@6@VQSv>f"
 OR9B1\#hHQ   P___[1)Z`V/#	
`R  eB.   MWVQh R=
j Y^_S  2 F`&+ؾ8u{ `&
0Y[fPWQ<tU;P5fX"pY_fXk/KfV}f`f&\ta d G&P&Y` X :v
``.f&tr&&far6r5] _P$s  XY
 At   Pfh'Ք 1X(10u쨀t݁	<u <u r+r&h#r _2D8&&t2QOrr,6r֮%}w车pPq}u`0"" QYaBP &` Ob vU~%'/D&* r!ն%%F%&&a cRqpMZQRr#*H)t2в`bٵ3ƀtqg@ultE@>ZYh*#s, ?  hO߃Pa
/r#
35E4 #C$Pٸ Uq<{ _  & &EZP 2 ;&rr8tW2@f`.?&EO.tGS`#1o[&M.α2` t
$ `#S[K85 7WW P74fRo2ɿgbfZr pvw5 &E
, C!	A	o2ahrz
%00`P 0S!^%Pg  Da`6(    j aVī^`W  3 _r-"2˸ fDEDCՀ B DBe O D D4rruX 3W2&*G_YS	  ?&*P.u&}Zu&E_[KH ^TZNF  20¿<Otb	B<tmPo:R:!:IrPF"Tѯ: r1 r, h#UOdd:SQt
pujt)u$<Pt+o'KuҴqayB~@]Y[Qw @s"suDa~Y+V o^W mQfR h(_dtD/>(I>>rN|UtGV@u 5^t1VhqH_ 6f1ׯ^Df@h  D ; Z x     0NmA݊$
Pd_u	q  52tXr	  H3ȃI!ذJ2ȉ{X' ?ŹSQRf݋ .xZp"z_{a  ^`)c$t=r+cc|R] *w0hh|Ed/(#/J+(*f(fYhR`k/n Sf>lQP?H_u(20&fá  dn[`~-r(U1ˉQqˉProzryq#tr}?fSfFfVfWp0>f9t  tf<b @` f  f`fff!02g&g
fKf{Rg g{re h1Ur %8Vh4
a5f=_qfYf[` r  sZfߋbXPSfRj07W6uLt;wEf6fPf8 r/fg&bP Bfg&rfj0  Z[XfWPu
 f   酀> Àff`g0? t]ǀ t
t@  f?
 :N  !@(! _  f` ; 6?fOrv`g}Gwf3ې fPf`kfPwr:p> ff0;w!fVg&f^ufFtf1!Q.Ȋ$pft Qg&$@%D&ǁv@<f=ATADtlf 9&w Ǉs U S3Ua  起b 1 PD} 0o3ɊE@s ~quL`U  EGWP XUЩ.>:^   ub w>u `
߉`
m	`=p$ v0
{ƕ
$_RW8>xϙڻ
=w
Ɠ>W W8JÉ/XwWW8qӆPƫ?XƉ W9ϐ9RĠdXX!XplXNXXKX^AcX:5@a }}/X@EP§Af.\`ȅ~!u<u<~w2@ef=&@T1RS\Pu
f!s
uf 7SXQXSXd0strmXZS!N|M;x_V4t ? {u{_QO[f\f[pR譐ø_ 覐 J`+a,A tu6$Eع" !2s	7>.hؽrd0{QfP g#rvq^sw oOj@cGɯvjhr? h<	`ú@ huq_XQfW@$Q跡Z0YfqR8dd\_" sTL7S͠U	U28"9àP=wf`"t d2r/bQ?fc
f]
f_
aUu<FOH6 } 
~tJ]
/t"(L	_
f c
 ,1u!1](r21]QWAPHuOrJUw&
uuـ t &
&&ƅ]
#X_̡V4MOp3I^TvTVS+r[?ం0ЪPQ>ȐιWc r\d`ђPSCtC>r-t`w 0 r uҊ1 r
-`u`dQ rdItf s`QRP@*ց0SRNr&r!ww3҆r r	9fPRcA@/֋lwrx}SQ PQPs
d Sr	rsV>Rf   dgfY{uwR Z }h ϓkC Z???.Ѱ P " Y0 `2 ,u   P ψh_4R

Z@u
Sذ*` rQ(`( 0PS  I 1' RR ê :r&DC	 4P>otS t3306J* Z`pR
t#4 c ttQÈqF  PQRWV̹+3"a^_Z$"#@~1$G<u0$V 4^W {_ ~"  !(<t̹_ 	J
R
q0<J
g&/ܱ1q;`-r;QWfPR(XJ2u@d eRVа$rN ;rCr<,	r32Ptrr;wҀ tsڋ^ZW
m  а t0u
˾  锠|uu B f [uf_& J33o22t@@ 0	rn
$	"
uƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_..\U.q.q.q.q7r.p.YRE|ȈVPCߊ8úff%
fJ<bsf #g& h"Xf<MMfPf d` zfX!fX V縱0e  /ҕl@!1 SŰwd=	=  #??DHV *#4tSIyC ك"	
ڄ
C"
ڃO f ࠨ r f+fMhggff-Effgfq ۀ fAMSuff>dr^0tq"wSPo6XAgи f|	² PM\fJDJ{Qf \f1rY rEbɎP < u \O/rfR fR_^3_fc
?8.ڜrBȁEP@
PR
`f,t0p A"@`Ņc<tD"zQgr&=t&} tV" GF^rY"G
\AؾDaþ ?	 h2Z_$ϳ
!9
"85?qL2Ȼ ZHó
_rX
_ZPX _y  hY `L~̀RRغ0 t@Z>:thݍXÐ9꿐 < =i <Ѕ2<a
 1M                                                              - UPRPRVFZX0RR30ZO                              Ȏ eڋh3  SfRfWbѕf t4{`7hLflgf&'o  _fh hl^'P?}hrzy@d&#h~f3 
&G4@݋tGGrEBFB
6
f_ !hf]Q  ugh*L   ddh=< d>il th>ndRh6dyCdޢff[fXâ'Qfff f"% f_dSlQ#PffdWlff$ddl fQt fdcl pd[l0_lfdW2f* ufYWf f_#B*J"eRd辁 {ҁgZ1:_u 7"yqC"YpPBWA;=;  t2f0Q1  ;j3 ?hmoB4=_"Rb{ hc\UZ*r\Z~ & t@sp>'E@ r>cr>ZRn%t;7Tg `*0 b0  fRVDhdf^fZf`2 Lrb < tTyrhfapL_f`QIX
RfV>Pf3//< tffOfXT!7"" hyQOf`/)
4O
O
d "	 	 Pb"	/	(	&!`_!!!p!Qj                                                                                                                                                                PQ 蟈tu
P``Ҡu 
XⲰ;؎ Rf쨀u Zl씱nң_
 @(00kిEf 1p `Dp   &E{t"D  $D(@ s `ف&tȀ 4>2@"Q
g&t
 HL &}u?p ?u8&?= r1	&
I$B>r P
` ߰肐 m  m 
 mQ p˹'s 0a` ar * $oOQa	 &? aSQ # $$<@t"h_KuKfZY[<uK&Ku`.>#Gst&3r	#rdgdԋa`prr X ? !tr<0vqww#8:9$[a){fRQS[YfZķt'2Q tu
| tʼ@`蕋0_r&C
ADjG>t  &fP  hiZdruf>&rfffdGf  p&fKffzr<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f뺀
] 0?  f$f[QXffPfXfX*fXaoP                                                              XO AU d              ?p                                                                                      x         
 S2X3                                                                                                                                                                                                                                                                                                                                                                                                 <A -   iW 

> L  
D
		8u  (
U08@ UH P0UX@`PUh`ppUxU

8h '9i  8 )`=i ""#   x        y   PSQRй -s# hfP u	fXc  h ʦZY[Xg&ǅF C9   Ã tfPfS
u	{p  9f[fXRg&u-g&
pIgf&A"fu  uf[_g&Ƴu9g&PMSVfW&jO*f%ug&D= $ <vD# D| u:t?YCk'_^
QRfU
}0tˎR>tKtETfu
 0]t`t	dpX  f]ZYPSR uyvkryv& 2qStN tCu+?7:ǅ%. *'<t<  
.Z"P00  ;@ t;P t t
t4d> ud:>u	d:_uuu  & u
p( 3 uo u_X!
j0ߡd:rjq 2fSQV3Ҡ>=  :t ffKf>+)a3  `49f 'D%g$ЊFb	茐 F0蔐r4Vu'v{ o (c^Yf[PR _
 Z"R:9:q=2;1>'҂;>;=SDD"!S
Fff.>;ufOffpDDfD/fCGtD}QDC= G faD$
D f|uG		_^ B<fQfV !fKFt!hu\gvu U>tU6f뿢@)_a[af^f!aFV  ^SQ  90Qa@9taT% G苆dE @RScf,Rd f@f  rfK2@%90thQRV&>	_>&N N UB@}v4u0FhfDf% ffDm^ZyfqZ`f Udsprb{'Àq.^^nBnj@& ȥoy(Pfpsf
o  ؀RX<ffH:V3`'E8Q3AM ,؍ P0.KSQXQXQXQZ1w0U~PQZ ГSPj< } 			;/^Zh]RrZt&j!梵0C F%fQfRV#u2lr QER= ߳ u  ;&pIS]0`@h1	V( UP " `f3۹ fs_Ձ@T@" V2: 1Bj0 fy=EFfC`?	5	_tt$yGv葕xs~ !"Ⱦ
Ќ (o
d
~uW
1?MSiqp1~uZ/'7FF}u #*V$^fȢO__o0V mX^ҎD	%ÉD	f?r2fpɁ v Ss<v PfUf f fa$f6f> f	>fBfff]X߀ t @PԁfPQ6[f_~RӃf3 cZՐyP5b> t5zV`50@@Y!|p5 ೀ
P}@@x6<{=f;tff* F#cG/$K ëӫq  ~gfEـ>  fù& fσ;t)gfm+ C k H2|`Ekv tߢqzÿzPVw  ^fh3 ;u}; n0;b7yP7BYXf.0Xs- SSDT1HP  Cpu0Ist XINTL E=\._PR_CPU0_PPC P _G_PCT A{CFGD
 {PDC0 ,
 xy _P b6_PSS N SPQ O _   _ _  _ _ _ @__  _  _ _ @_ _  ?P@kЦ?1?D?1?4?_>_>W=r;\/D<Z1Hl7HC0H9HF8HI_CST pP H`s;Ga H	#
 


BK `
 
A
of`qI T
9
dGESS@րO3Z `C
*OeA&KG&e@I&C_C1__Q
&"1n6D6nPmo:n\ pC
nIST  43A1OU0(:L*\q 1d`xL
 C}"v
_INIPxI_HI0_
 HCq H_Pvh
 REVS SIZEph`pt`
 a[h
@wa TEMP@0
P  s ab_OSC
w@)G؟pXq9SAbDAk
 1 CAP0IID  1 2	3sU9S
 E  1c`23?6q 1223ޡp
!
  ki_
p

G}B? !L%A9D3	 
	{ } q[=` 0   [ }I NRJ2`M5kH!7Y!1!q !!!1!1!!!1! !!1!1!1!1"!1!!!S!C!1!1aF!!U1!!!1!%"!1!!1! 4' !
!!1kf`?r^faf`  ufc3pֻ0v , f!6j,gfwP׋F GPrR(W-n<AvPUfVf>n, uf% j ffZ	f_y{, a ufzlfr,鸀, 
\ j,z` 23v1#nf?WfA_fr1f
={rGXZ0r2蜆f`_ rRfGf>|,f r<
r7 	`g&V0fqf+Ug&D
3G&NafaY
! 4f	 g&?u@u 	t`;vڕvu&9OpCqQfRfVfWf-sIg&wOf! ff9
f  +pffff+g&of0^fS$@f[ @    	`@  R|5O;;O SZ !;`  AGM>y>EE]KLMMc>> UWRQSPV rw;t ur6ffWRP0 eXhV( UP " @Zf_ >;u<!aPS- pu;;` ;;;/;;[XF f sf0tf 6  ^X[YZ_]e È;; Q ; P j0fdQu!;! ȃ uddfd԰  >P6Sd ddP ʱ(;;P:Ug&t=` T=f]t,>@u%ttt t	tfN tF ߍCr@uAalaCs
 1Qh 6mbuoF . u$
TVێeS tbrtـ?XD@?f `fp`T fffXs "qy#uptLe; ` ; uY^f3ffe;bfWYдe*&;8fw*fF*2t*܊e&;fX^fY[w'!(; kW" b  ĀuBTv;|  tB2|k}SQVWU& t r]_^Y[LS-120ZIP 250PSQRV:1:2:٢2ؑ2PKp
x

~
5	<;2E=k>
s!hfP u	fXc  h 
rg`/;<tV< uWQZ@f0< g&:D= uFfG(`*X*Xu ͠HAZY[0^`u ;Q;;;;;v0 RW1hK1

ma} tE@/_Z[M-SysPDiskOnKeyP#jB ut @  f<x fP f(0QA˹"`z|= 2r 0w"1s ?sU3IH $ꢋRfQ ff@fPuUst?Lur2g&	u&g&g&,c-\w?t,f_߸ A% rLTf<Q?(UP5Qe}$ b
ԯ1p<p< t0h(4t u u2$3=@Af?MpI`N 
fXuײ?0 000J000FF 	  FPRdoK@3W~2>#>;2>
a_YhG; 4  hU| ZXSW0+@0s!$?
u$˄[y_ - ࡥi B t`UA	qAq 	  8
		 
	 						8
 fWQ ˹O?Yf_qD=f; D=;FD
$>;%
ĈD
%詠;IbΉs@s
<rI`d
Qr7R[USBS{u\ t t
U	 	`;KTB <;9١ p arQr,< C0' +% 7F`2PsD QrIt2sQfFa׽fAY{rٜSfigf^qf@FH\
؀eˉ\b$K
prA
x @
`0
!?
0
"7sTq
aWa'"CS#PD=qq0*W.?43'T2'úg0^oZ(ڒZ(
_7
qO_=%t9T$RQ$2Q	@ ?WK@RP2 s с>[bu g&` T=
XS<(fiʐA & y~j6; ~ r}fPQt:A3>Ϳf+` f^Vu6@+.[Kf.6WKOP5fJYfXfI|G<!`N9?y?,B3ПU+*/sG/%QfP<h`gffXY"~Nv0\OސJ?^;G7/Osc`sMoDA b@Ac7e=S$l=38%p;Obt mbt ab`;D$
ƈDaz ϋP!l r
9rYAݿ /p%tFIðtT= 2:t+:u hoety(u~~(rt@Ob=@tmb=tab=`	t[b=Ѝ Obq6`oWfa0V
<8dtd߶}٠rـoپ<8Dt_D$PQFxPhr٠dl^SQEO	8t`g	G	҅< !" !  3  @O 

  !vv xQfWf>_l Fo'#f_YØPSfQR1:&Ptf MPfIPpta{l  %Pf_ZfYf[fRfVgfeG`-PgeG,fQ"!
6'Ps ,P!V _f^V;wfaf]	6&ys'&P/ryRvRr30
?geu t0 AO@ra'P1806*i%AfgfC  ggf	 
s>r8PjQu:YrPiAbp
fMPs
f	 

 { 
!U?W'eGseG`~i_VRP 31P@gZ!
\
(#5W0
S
B
%?q}~r$$ <
`flpcC4C萟s!hccoreeJ1*A<tK< uMf5  gge:;ufCfF+f
2 Q1
d{P>il u%Pil&P1P*PFXp>hl |u	vsKwq .Mf mf@fPst3ur&geuge_geOP W
_ww?`}pR翋qx& r&L&T7 <|PFh3P(Pf_\3VAf?_ffXqf 
qfXuײ? fffW Nfqc:fp]ao ^@HpJfff3+=Pa5S	2NuS`gGfX;eWҽeGF}reCRC5P5PI7+6p6P b!1fY♠
W 
KA

$I#j
p QY6BeQep+	Y	xr1 /
U2WQ
s⺑SAOn}%tJ?wA0(PZ`S1_Xf7񇟘Bu 㐊_
u }% 
 !?g!%KO 5Ϟ     }3f  Ptot 	2fp ufxqtp  >tfq f	bCfff@Orfurffɐ+fԐ%ЮQSt3f

 sఠqr`QRޑ0cD?f3fAp@HR
fâPXpAw f>l`_rfC
.@VS&7 ! P`0Uu

C	ݾ3ݎεfmqC &V" PB3
q a1a!@%[pxtff Q)`"(! BRUu@$#o%"*E   u=s5# r,Hr'7
 NPSSg
#[@P)'C,R"G-
"10v)%
!02 }Vf>/U`˝8?&B?f P?!?Dpu%f<E t
t
t&[ sPf
Z͉6/- gwFq	g7gFq gFyps fbB,3u +0+   < t?  ;v?ȉq tv  f@-^fflgf
GGеgG-  	R
 Q
Gfyǁ0ffHfbf@@I1&} t@q qg fy00SfRg fE3A,3;	@t`$2f&߷F tm	DG^^ҵ!  sfu@Q	Ffy  ǀ=`G
  A !Iy>					d+ఃd	@	nO	@	D@4 2@B462=fAى7K"xfݹf59щ"hRa{TboHfuKZ<0i f&$usZ@U t`)% efc	W\Du=F t5f\{lf  f+8f;rߔ      ߔߔ֔ЁЁv"6_WA~____T&䁍ti@____YS __________|___b_____Y___XP_S"^ ______Y3uyU=6Wc(
   ____ 				O	0ScfSc 	Z=&   vA	w.s  q@ D `@  "eE `i @w/
@ АRj@F  Z"z SR  hfP u	fXc  h  Z5=f3fZf[lf M@Q~gfwe@Qw_faEA	>dlu?cl}@fQfCdfld 2hlil%PWf;f+Va++ *@ f=~ ЖfGS	XAhvUftQ3я_;ad̿ /p1Ж$4	C:cl63
f
?)I34ө% 
3и@tBՠEuGf>%2ggefFfGff!g {@]] f2+ǐ?fj-Ѿ@t#of+ qHt-Af
 uh97gk)c)Xt(8{;f	 p~7el A}flf_-c;q `u @Gu
g⺀ele<>tf Wflr lsc`u1ge~M} 	C =OBG рK~f  #$<Pbt΂ t
@ >hP
>i~
 PHj		%PgP3=- 	 ?D9D
eVfrFsr?2 r" f( rFu&&P'Psp_"Sge8Ftff;rqK0D>$O 0 ,d0f7Wl@c 0d	fВ`f! W jgg_$"/ւaj_`e{OeW$kGb plgq2bY!BfβA cGROс0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
qr   2!	A.>  
 x  x uuo        St[Pu&u u!KrouBuB ?C > XPS tuuu>uuu~ uR[ CruƯKuuuuYQ	`P^K`
3؀`u&svutv3 upVS@t	V[^0QVug&"uvpJ3fu1uq14ߧS1㨿éu跩[^PSVfU>S>zv>ϳ&wvt(
ug&uuN[艳f]^Vt>uu r1߻vuw%0r~@!60aSɫuP  5[6̨TWai`z2穀ОQ	2pUt1vuIh[Zuzv~yvfPSQxvĉY#\SPćuff3 20RvfZ2F E *  <Fuxv3t	 Dt<Hut2yty VȀ$uPyXuuv Y5rv uB<Ft<Tt<et<t<t<Rw*<Ir&xv
2%ty>wvb?yLr;(qurqsVW@fFtAQ څt(PǴ:vvu 
  gXfC[Yqq q9~ w2vvkY?ⷠuv`Ct&tv8r #>tPw{
$_P#0%uxv.v2 uf? t<CP<tSQ@Kذ&Y[ـ u
lq ` -  i8_ @` @8h
@ 0p*	qk l8 
		
			 				
 

 fWQf&D=QYf_侁gD5 ;6;;ysR.;Py``}D
$&;
Ĉ?D
 1Fs fg&|5 EBr`r  a`|	 		M|0R		`R}H?\
 {;
܉\se7 bb}Qoab}f`ߡg&`r ql=Br`h >;Obt mbt abt;D$
ƟDf-Pfp&߸ &p;W3
	#3rg&D=qWt0b
Y"Q@ Ѓ0#;连j(wf
T= &Prjrp[bu6;; 6 rDQfP.?f.6;8+܉fX2fXYffrhl*`	 Y*a 		$Z	hb %G0F
/
PsV ` !sJ%|=td%"t+T=:ur?|`B(uq!(~rgOb=@tmb=tab=`	t[b= .ObhK1_2q62ogfaaoVPCL	;t	wPAq$ضR}X <R^ASQ2|O	8tg	G	ßY[i0   0    RoO d q n  A` о 0_0 3`  
& Aa t%  	B%
0 #
	٩*
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
aT S<R"G 3 D%M TVaX'K8'(XAIc  WpI O  x fSf fV;-sU'f6/f tGgfNP	g<g8t fI^fg^)f2f%f0 ffYkf[ f PfHzRf3ۋu#MufVku
 @ fC  ZwW fu$޳ -U~T fP%offXrdqPt@5f90f  f
Wf f;Nf_AS0>߀fz薶r@!fff]f3ɠ  0[  U@ Ԁ   U@\ Ut@dl fVf$f&o~   wt   
f}D`fd.f^<wtP# Q5 R*Nhrz4<t
_t %UV_( UP " Qޠ$0@f"E$!4",޶-PS1#|&3M38t< t 4 v-#tt 0&#V>`OgV8p < @DHPMr:t"`B-Zݡu-.GGa?;-?rfTDaff} DI	fAKfg8u#HDҵqQrf1s
f@ (`+1HSHPS'}? OO&,9`f`hG|(!G@<<t<=t<>t<Ft<Gt
75}5qGN1Z]    %`M3f0V| tf<x  $ fcP   t#@r7fuB aqftQS0^fC`BUc U44`f&V f>/q% }! eIf!ig~>uPi

qCDq; ^r
7rC
°Ro-?  &f ߡ6wf  sZqf9lu gF9u 9u
gF?9еtz2/g-tvVf>l  r?xsFf!` gFqg^ g`A  ^Fq 3:`kF^ t	f#;QoG;.;f@B23
 "4 !Ix	`				D+@i	@	nO	@	r&+롛   0a }BM ;vȉq tv  f@ 
f`3fۡlgG p еgG-PA	qGfxi@U@Y՛f&Y8z"!1gGA&@t@ af9Br SfRqof3_!^5{	@ Sfttt.h.uu7  V  	  i@ Ԁ Copyright (c) 2005 Intel CorporationN1OS@eP%2p`"ѣt2Cqt"Af%  =  ҟ <pdt<tH<tN<tL800uxuju
T4fPF<:f!a<ISGou%fц	f`C s
gJНRVfUf❁z f6bt*ZpGt
B s ` nouhC%t.At#Oǣ4ǣ%>ӥR#S` @ İZ-% ` $fQ]]aUP.W)`t411wgf#f  ϊfYR1txT	ː!,	ba'""ԕR4bSHЏJ
>Pe]֥u}xt*HIT$$*	g&<ж1	2a?5c	07t$N<t/5)
`FO0E	@HK0Rr+5$Ad pT6g%q6jqf$, ;g[S.y1l?lSMQ@	r#<0~^W:XX`q @O0 u(P*P  rwyr} Yr)fߋfWRdhZf_rJPSflp>8Pu	1Pil3 hl&P%P[X} &zs	f d w 68PBA*P?È`
 fd!7P! ȃ ud|d~fdf@66`>>á0 dffd!! d7P!gewP Wttt t	t&}z>t| Ƚs
跽s1|SQVƾbtـ?鰽&Dѱ'߶fATff_fXs2B	x3p&t&L5P 6P ߀uYËiވ5Pb>W*&5P8&|w* |*2t*܊&6PfX^Y[SRW1	&  	ma&} 
&_ZS/-e`&-	
[`9t4h(4t1
&u ?&uP@px
W  g&?t?fN(g&~QffÁ 
(r~cfvg& uxrI`@PeA
f  qf  paG,(i
 !m
"sGkO8b <fT tf$B" Qpff
of' f?  ftɥÓ f&
pj V 0 @ s	<W% <t+f R
 %u<  	 z,R
/"?r>f{	%r
 PBg %O +fp_U/ErEF?<p)  
 Ѓ@ η`#ujRca$3'='pf 4"b',f2"u#}   qsZ ] [ \   z @ b  L ` oa e^ @  A @c 7g 2e @ uf @ @  k ij  @(T @  }ն  _ @   6`gVf.VP Zo!f! ( @O |'E$0 fpP	x	s| L Ifl  h@ Bdf?f;  Wfff;sgf9t LSf_ѱ쟣f-q^ZQSf3ퟳ h4OOetowub$r	tf1GI#d4@  $t؃ u˸착ӡеdӸfZfdLfdLDA$Rzh۪W!pw!芔藓hoԀfof~ ea.d@t0WyJf`a؎}  @܀g_fapq23 g&s g&C#gӋbSf3Bpc0zC
uBUÄ~@P>u`zt  X +R0ff%f`O@UՐ Flyp_ZQT0e rcL~" 	
сD. P2Xöf fЀ 0	PR$Z  fPx{^pmCX zCׅC >#sB3"     {B;tgp ~tuftP Мނ讁Ъ2C4"Bt'BG(Bu o9Н VP*0KIQ! Kj
qXSV ж?(sd^@c7#g&wKZ
P4CZ
@ AZV  	
 !#  ! a "avb JQRVWFᭅP   Px;>@"	 &qm)p(ofлpoC!	u*=8=9>9  69p 71	0	w"z{@$w>zQK$33zn!	%puQ#VS&S?3'~1u*uG#> 
Gu`#$?<Su? ߳PΗtF	t
 t 0 jd:u> u4d> u	1 t#u<ufm8dFu<u2!u	I^9 _^Z7g&8!еu	g& B%DtFsPVS Өu h8C^:RV˨Wu^_Z»ۨ 1]u`Uf覀(ot~oxf]1; `zr;f.;t3Uuf={#fË`?{RyË= v	 +v9q3~f́  rf~fP ݆ 6Ã tL;T  ǀwǋ;@t} 1.NҠbL7far9 w0`b hW|Ñ$affNffffROMIfMAGE;uQ;Wtg!313KPQpJ 2!fGpZYXu@nwa0GSG "2h|
t"t ` {t	V M? cu'f t!AUwbA
G94PG}WGfԣ fCfkK1O0E0b RD;gfT ?  21
"+- @pHPC.ШRrPa
>1aPrbn ##[  U A7v P4$,SV.etv1q^ Q Pu><;SR $u<v
7=:,> [;ʀ 7Gm{rr })0PppJ];  u&xS	ۨGp4p<v<`_:?;w/pp
QQ	? tTûdV
lw&F0org&уto}r访odr%# oKWrQ |o2s
 J?kh_a	Fo=7	t ()o G2?f#n
uݩ`$MXp Z$,q[p&p&uc  ? DPxeаB?t<СGfVf搩fo fސ表!krПcfǱm\#GRБ #aįf f%f
 &'f0f+	@ s偀a  f&uҠ&   
4 OD 0U ab bG `g!	OSQFZ  NZhFZqR  &>b !{  '| da %,Cދ #${`뉦0sO47f=   0$ȴpY ,ߐX 6ֻD@vfk xfgEܽP^ҵе&*b			fʵ5 `݂-Wf>ʵ~)  7_yq_Qp@f% kεP1εffE/2f59 5`xt)ځ` ;sff+ÿc f6>a9t
3T1I!A3Pk
 !
f=ff1 A6 fffp	صf9?صr
f)p @VVf?Vf^  $fӃ\Qfq+f%=x h1
[_Hʢ\</)]/IfVQt> u Q &*:&  /PS!
Xh f Ӡ 8r
TQ0

h%>@t t    fp+SQ	@0*0=tuf_P9% n0<s<0v0u@ =N_R  ? fLSdx	 rh6%U0f0u @~Q f@ ߋY#h;l<`w$hS*`C! `! ]>ftg:Gvg_fgV !тIf0ࢂf
~H( X_Wt%hG@	g&߈G 6X(Jup.p tpqsf
"t
p $C7s2Zh)@ fff1GȐ6Ƞ\* * GfGݑW`dȣc@tU˸&ax3w6N=t=tO"tC hMOO4r#
uU0 fd&L2
z ]Q:б ; nu5fuHpw n@^}x~f#~ s<5	u uztI S01Vt)IfufKn p	`s4te[}0uuWrZtuL#[P1Af0UFQ~Yf%
&
 =ps uv0_  u*f&YB  s~nfr*Ӣ=RSDTu}`w_$!f=FACPt?f;vVff!Ow u-Cѧ(bb D!+4T u ,3$pjSuüPf!|fGw u	CP`g3 W23f_
 G	EZƔ^~pu#f0v₄ 0铠zgfFf~f>u2ff@ v 6rRp61p>?~gp0/&0vPՋ>B?G0~AR ZaRT b c dP&abpZ&&FddXPR< u@S/RgtXr),uRG`SQr9R'Դ$8teY[	tr$V簄O㰆HAr(QSFr{(!sq^trp@۴ppq[`irDrT~f>iY0Yd>:t	[ fa !  rTvyLa؟@f`ytI>A _{ G{faa~h'`qe`>w>kO/P#P.}G ð@ ð Wj@ȰHg&Cp&Cf  @\@t> G NH >	W {3sf_ҞVfWbqog@g<P^fZf3gfACDff@rg@?CyP@Љ Qg&;t4g&Ct,g&Cf4@d$<12Yf٠
t
g&:#tfCfYFa;tft ^S e޴r7fg&F t+_`mr! g`Gag&O@` NNb O cz_ QfVuu+rB f Ur(al
"Ȁ$
Q3p{~tN@Ta \UbiQ q@Q<ao8r p312Kˠw P0U `<r<9P&Yqtuq "t؀><?:s7g>   5d- ?6# E, M" d 22 /U$ 9( C K U##FPJ	ubUvPmȇF X PSø &ZȌp X؎[XPSءZȎa@sؠXDA ` @@} TfP&̰ơ`gP,`fX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   `    ?( S(     ښ    ς  g    h Xk   ;p    /\ h S          P          %X%H_&                                                                                   3f3ۻ  f@yfg!)A  f" 0 gf+ >n `hK1fPpu	fXc  h  fUf&af&>` 6a m !ŀߣX[ &SP`@ /'a&U}&WP `XP&EX% &E_Y'Ǩ ooooǸoc/  f`	ffN%t$(%p$Ū;%r쪺  .<t
../ NA NfaÿfPSRVfpr؀tU./tA
 NUN踾hX"^Z[fX詿4 h_$&> tTW%`b f
ffQ sPSfQW _fY[X ve i?XøpPR}	B~	Z }	B~	3 $ `%>&w%	 
  3  t!   BfQRW0_Zr q>rPRZ` XfP3T f݂;f
 $A%
O fh` 1 0 0 00010 0 0aÿPQfW@@D fg&?t"g&Gbg&Gbu ߀2 uf   κ(  
~uf_`a$$
{a C PB B;ra`J~ƀ,ph*p \Q  7a* :V ,`
\22R9ĺZP 쾘,ȡ%π(؁ 34 b0g&Dց40Ft*
 <ἢ0v"(`0h! n:f`1fM2f3f% Pj
 0p!P!q  f
P 0XXw!@Kf`1"f g?ff%? gffPpA`حBaPfS,(CP0
K gvhC~v wCIhFlh Xg&CfXCfqRPfV uf  guugf>u
 ywf^X7f  	e@ f
	
	
 bQWfV3  +t-s$  ? fףRF f^_K..6f]f]** End SetActiveDisplays: \  R$Kt5< u )㋗d_ ߫;t  ^_um Z_QRӸg tuXSQ2tN
͋كY[P  E@t @e < t\ !QO
 \p
; 103t0	p $ - 3p@lk l~@$ TURuw90
G :P0n2:P$} 1:":ċ؀ !:X:X9ZR9֢999X9ZuR`}9a tQ9P ÀVP9QRPSa[X3tapB!c:
xK JkOu$=r
~u.2*qLP8tr$p&` E&]`:@" _ fωaMq t
$<??? 9#ftU]f_f/SW_ð ?@ ጰ .9trH ryp]tQP?	'ftuo &AprKf`f>f8 t`Bf f~ faQ`aYp`T_<_@gfgf2gPuFtQ SP܀cuA%X05:t p
ofܡ° 6&_  RhYrs77Q`1^t,>&t$ 迺 =u a3u<w1P$o<w	eP1ߡ<T"W> tUuR uI`)B<t>t92Ar-r!\ W1tmG! n_M PnИQ51tZ tgqtKuAr3Ȼ Ls0@G <u$
諀]O } 2@ gfP0G?"raȱ0tt萰 pp r$ SQVȾ'@ 8t"8t??r ^^Aet,&
 lr>ut
$sE 3t> u.~7"t$	&
s@ 2P
tk!B	>!2
?t ^.d:@z@C g$tCƠs P+P  c1r,'$ v -->ߴ yԽa>qmk	 v23t 6 cW0q{ްu g *t%or0.> uBu
AoiS7ˎ (t#4rj1PD/JbtVFnr->Go1.tBH0/-Fra //e5-t_h5tP PrB蹻о13! s H E%
 "275 =5BpVtzu`<طctb;0U7sW;TsQn<u	 ~]2u0r u"
߀uE"
23`<  àvt ff ܴ)Ơm\ )PUkSfW/t
,t`_8؊f_[uXߞfbsg];rb
w
{l)50
M4u$$t$
 $l ?*X` غ   nBnnntnJFn aS p 3ێ7!C|&?!C{u3ۏvR .wZhjjf!:^X?W@7x&::2>&CPu	ЋQWV		
 uw	t
+t@QWPзPRNhX@.X=X@uX_Yj0P0u $ q0f.$[:rP*
8Xt@K`uð6C @B T A2QgffgH g~:ff3`ffffffߋgffOfc<u(.&BfsDP
hi"t
W4	fRc6U tg ͊
ܚ
(
u_XO0 #Юf  fAp `軴p Mp }0XhцRÃt%tg0&g!ggf`fZRft9tg>E @ {9g5CggfRVf),g>߈E %g> !P(^d`g
ز
.Ъ   f  R"Q軦2` @`1YZJRP0 `8P%,Ⱥ:#%h  t
ف     t(  )Xt
 %@  Pé P+o @+3 %tVfGf3ȿ f_ff3uf>fff#f  fα?*%;   HQ0X
1".#؃ ӑ||3p%@DQ#Y3o#`a ff%f
 k0+C@tA)15 	 )
K%?
? g&`1hF4h5
 #o, k	`q= `u3
f0:u aE2߀
 V2~2 Rv=u
f]1%0w 迅hBtEf0P tFf6f(f#$$* 5 !q PfσqPR!(
 Pn_Rf +c ,3 .uSou
`޴,q005SS414pSH1T& T:1VV,1h&_a,0Q>h5f~ fu #R RSR-0@t3P#*5  PX4{Xtwǜ *2ZfQR3.  u@=@`>0 @uR+0t ʑt
1#0226Pu%#f%1gr 3t\TKQR(;,;f ,`K!5 @@tfH f!fy +1 { ! z +1Z7RF0E`9;tEP' tf tF F!( `?t,.028ss!W *!))]+Xyow.USw6M#')X+!>xvye"7SUp*vW7K
~*~\@/#
V)	!%|*`ȺPH P q&kaKPfWV V cfǰ_    X`fYfXDu1   
 hR9¡  ( $R`Q  PfffX f B7f0FoP调s"QY   ` 
a!S0]&r&d& 33'#j} 	  if&f C_ f9Gf qP4 Pf%\h f0ܑ ۳@d   
 E D6
0
f&	_ -(	!	I$	@p bQ(% = u
$= uL={   * @F*&sftQ3%B,@ 0 (eDP 0 qP쫺D }YQ A~ ,A}048|@WY`#B|A%"u  Gi S8hGV( UP "  G   ؿ%P_@G,-./01289iF      `a***$ivwvD&RF7*$aP6oG3"_"
P_[2t0aÜ`>@ l> l!GA lBla}6$?C ! G @ A  B  $0sF  ؎M+n  "M+  BnnnJF$a %JF*P *<* tq ̢}*P *̠ث̡K+ޢL *   llB  ؿ+ lBB@6+ Wl@    @ lI+ТJo+N+&&+'=+C+ /$а 
@  
FF/n  	Un	n	n	n	n	n	nnn 
 I+J+t**a  a*@Cd0`  3nnCy q
p		 nA
` nK+.`4Lq @}|4g&1RP@' V%#/ f     t 
> u" ^QWV   f  ] ^_Y
f`h~Oϯůaf%=t=:0,hNԳ20TofFfAf.:.>:u"f  f ye
  sQ1UfE fRPWf2P f fs  3n{tD
Ah	7:faPz f$gP}a 	gff
30P0~fA_d     t QkЪ8ЄߋhNBfaR'
0
ynhmOS3st*2	覐#02_ u!,0 tf   "00.0pp0B"{@/t	!03Dfg 3psf3 sCX4րRVW سMMffP f
0u_^                       3"0 *X3ɀ$ tpkT Y3OѼ! u BY3K aSR t@B u$Z[0WP VXAg0[f`Q
`g0aPfW3f3ɿ[3f?0<  &P t\4f; XADZ3[ fPfPԫfX,fVЁ`JVJ7E gf^! Wf^	V		)			:		/Z3	^		f	W	Z		_}g&'pf@#cA~Sy! , tO4{ف" hdwTQ =sY}@>uD`ut軁 03SP[C vS3ۀ> tDt]Pt:]PtC  [0=t<w>t8t, 
?轗ñ  S r t,  }PP肗P{
tr["vۀ5P4fP	RAPrA a8	 fXBqt[P	4ā{@At1-w&ؿ㋇P.trwRa	t0
p\:< t
]::@ 0  P@ۀ>@utPaÉ  H

pI J@؃@P2J
s3y@si  Y ݃&
1F0٢3:4:6:m:3:u;pu;thPpP\:b\:-! P ::::ww
210:r &	&

v
 >2022'hs>hwIF.	fॐb]|]u0 2f IfSRt F<t`$rf1apZ"tdQVW[rQq 0 _Y^ Έ}TӼ EfѰ2[fot
t/%S/ygflQVv3.Qe P^WSQ?RWVh?rGыt(
 tuu u0/ttPuʋ^_ZY 
WVh(<Dtbho%hp +\Q    6W p 2:> uύ6 FHt\o hz/4T3Ҭ؋hߏzB^_fj
̈́
>
2
r\
[>T2@ODHp

yr.
|rXRYXZтA.A
XR@X
/ Xaao/ / /  O
XB<RwS2.o@[Pø ?8fQh_(fYnn"mq0W PIǸ`FXqqzp&G    &Wf&t ffBf;Pg&G>ww~rtwRtpff@h
Pd8͎QgfYgho;~~A@f^PS!>aPS  htWhzGDC2f[ C   `    KD  f6Qhf=HIBMQ@ u_jFff% g.9u
g.RFflF v"Sf= @t1u  øΉFQ F	| a1&qsNuFgf~ޠtVf  t
fP#ff
fQzg1"F$yV f;s	f
陱ء  fV2 |~(Ff )g"f+s
  	@Nf;sfȢF@	rf@>f qg&g&fFfGg`L^N &Vf !fA~=uTA$<ufIgw:!
g
@tT	럨f@f 0ߎE   &EE
AUt:r 
8s# 52tr 
_tȰV$<
v
ط   tǀ>E t $
ؐ 
/x$0 u
d  tַBO@׊ [	^hs|E
}
0d	r	
s	 au E&EG EEP>E u
8w߀`fWt# t!_PRNZX@:f_`E `R{D &qWx-G@f] D7fܣ Hf LfPfQL 8 fU@@U@@PPh >$|fwt	S@`	f% fBSAP*G<t<t<ј&'P?S$<w .Hr߸ ~PM#G  Ŀ 6h_r	fO1e  Hn` I a ! 2!gց	[	Q%f"Wi"W"WVTfpQTfGV ӈT00@&H_t  {qT`Kff3fyP\fPA۸f<Qf!<w  <@0T  fXff
e8E
G	ٜEɊPĳ\
P ?XuBmD
bo`vS! uo2R + [G2P Ѿ'X	@2q}P2ۀKˀa	i$

|Àu
<X[X!P-a9؀a
F2t HP@<KrKX=t7>LK $>p u0z o Hb_r`0u< 8t3r-<t)u
$&4&.:aEft%it2tLlG Q !p/uIu>Q &tOPRLZ  .LPR^BZ s  ""
ZPP>aTiLiL Jq vJ_úQ R ((
PB/X
	SR4ZQSW M/π_["߀h    
@|f ff7Mў RUfFFrR?藧0fNT!t"pff{vPf萧Q] fpfuf Y_0f M U"  M0𞛀 G@ O+fY0GT0G Il
 q
UI IP:}rM	 M (P: GQW
&&y{ &{@IOy_Y`9*z &&|W"~ {׸~{2{0{ð<	ghXofř	'} 	6|> h2_$cRO]OhOsO~OOOO3@MYfu3<ENW`z3;DMU[qcw`CKS[z T^| 8<AFJc|  Oà@ PP Lظa_X!.,غ:%  3d` .Pȣo  Q՘ еag33Bő3ۿX7!  7EE$aQ% H$   8% 1S`S $VRXQEV QE88! X% PPPPPVaRE Rf P% ݀0.&,˩ߜ@ 
 C KV  0eQf`y_2t5fAȣQQfωĉ- fa}CTNI kQ0@F ҿf(Pn7f23@ hwQ@ƀ>0QQ25s 2cUV<2`2 ' $0z [.>=OK^]2 	X?sҢ tiu%?th?u0<|r7,aP
?mR!`A@uC`_
 
  z@ 8-Wq
ppO|<Lf.fI0f.q  細_IM !N ro迵 b ;
PHNiRQ	$%uhAT.=j P<^TS r.HT0wrĀȁ.t D(HtrH虿wUu_0hI$@OYh_2 
03!47)?+t
3NO+t3GNO@UNUTU(NU쪺P aTUzSRU``q/rz

PXαhhh&sMvPUF X PS"͌&U&U&U[XPS2UUOUQwQ5Sנ N=R/NCP bAwuuu&gq 矀гp  T[NVN&VV^qLs~tM ddMw`
&"&$S8rdd8rAS<dr
㳿d22`:WhLkàа;y0f Ѳtx)St?$'ָpX&÷&}ḇ PqPM &}wXs                                                                                                                           /                                                                                                                                                                                                                                                               p( f foh2fP u	fXc  h @   foMgeuge&p #t)fSN_ bQ i  f[ >1u $  g
ulfe   hp \Q 0uIe	:f f  gf&e /-ggø0&&o  P            <  D ` d h           w b @W  b  U"@H X \E HT?k 
 1w 
2L 3`4 0                                14   @  8 @@*  0+ 0	-T&#,l        Z PXYhijklmno 	

                     - 
_,89:ANNO Oh`hf?PfSfW2iPl  Yh9'/khs(mf  @`ܳ@g&OZ	(Qf g&f f&f4ffpd PTf_fYfXq [fXP5Z &g&jxr*P "vq[f_~vXf[XQfRVW f Q  !Q  A!!ȑf%t9uf3f3f.2fffu_^fZ@
f"Q ء f' 9ut
f0PR5 % ZXPSVWfQ  maي t
؀ut upf h*tr u* pv @uf  fY_^[X) #fVpff
  ffs   'Ct!
    茥_f^f_"Ó| auEbR5   +}X! fPR0-S0	%|h @
1`,Ⱥ}4Af# uOt0!\f @t1,#%9tf!!Qt1 f{0 t0`Sf.zfuf  2YZ02|! z-{;{{|{{ |P||`a|fW C@5 u8  *7/t Pt	Eeff_   _à9ffSV<r<whKf `@ J踳<ZuG%?rxo< PQT ~^f[ v
 sfp1`	pú:tptfPgùc 1N)1\ ĠD@)@údߩ u"A$
   t 	jf 0 ; P] PQg&`w%PS &%y4PPbR(p\`8%ifPSQRd0|f#f?|%P.|C"8|!''ad |
 |f3 Q'
f~|bZYdbR	נ?P'' |p
f|1?f|
s|?qcf3 ]%3C|bnS؁ihfWV#t6T;p%ptȿ fft33u⋏0Rg R3һX3t@߃s9r M
'` ( h%Z re 
 * 4*f&TQ/P~f%C\\ _|ar&җ$Yl PAW؃22PDðX{RfZhάf`ois $ cmgfa  : !$SMM MODULE -- COMPAQVERSION: 1.0$PNP1с1aނ.^jх:KᄡAqqNˆ+[Tω3勛Ԍ2lލ0XΏf`0,fP rFrAPK}G  he:aCQW33۹ G.%/Nޱ߰_Y 
zn
r' O
( scr)S0@p[f
a`X[ ftvUbEh'j8PӦ	\_Êˀ t? KROQh,Yt7
pDuS"@@}[} h#v5P\- R	r!?
$4>)uhrzE?h2)ޟ&_
1\ ƕ
 Y6{D	GߊD	'6u1_427"17!2@:7 777G~L>OeRUYX[M ^MO!aY"d6#g$њ32IZf%f} UCESt0G) 0t`E@a2"!a\t+ @uY-z`@ u@3.Zs׀tF
8  01蛲2
gYe!d?df0Pt[Q %]J  B2* qf@@B=JRkM tD B&{G& rG跲@X=F|a' f   fifqu"'G'P#I t8 t%PR怺NZX!qvp[4	fPVW\'h֯+r/huwfq ^ ȁ v t! ÞE  ! '-c2#>    &p1sx%f(!CãwZ  hŜhǝzfzE`fP g!{:fFfGR5PG:g< t	 .f_ø8 RGfFO< ucA%G' F9*F
 ( *9z
9@9`  9f3ɋRD $fy3L MB 
0::bj3733
0  7`SC 3
w TQ+T!ZB"QPaF2  @FfY$fǪf>Ir	f_Ց@	bf׾8e#dg&GLUPV0 >'vB+`++Q +Ǖ(U	((123ff20.$gNgVq	f0J@*/qfWbPX4fV2	A
-0352f^
k+f_rBi _^XPV"'PfSfQfRfVr ?RRSSS*SSgf&ǇB6Ǉ bR2 ZR
!P&B(B~G@bRH B@tS@g`aT@y@rtY3 ~ r t	 @W@t Pof& _ t=FQfݩ	 u&d,fV7 Sf^5 oф	@} -20 f) 
gf;tzgf=f3Jbffϱt
߁   0 2` 1@`@a@fBfߨ t1f^fZfYf[kf`u PwKFaPff#ffдgL rf7pa,`-RQ<t2*f3hѦ,~OfuDOd9g> t'hԮt  rmI2qR uKY [pCMc7@LW \nf1D2"_1$&~؎vEjN(t_

A
r:fu?%_X0r2F G0r/8u/ fZYs"~DA     M47        _PS } 'Op [X0 轋տ$O0lﶿ$ʿ  M Dpʳ;@)A4)))\))kJ))LNtt/)VsP ? t r=G05+y?+<+:8+#r+q0rQZǂY1LPtD6`K5+O5
 22fZRLR   ZFfPS7`-TlJ&C=! r
p@@a	[fQ[
uxKhHo9f;tA34`dVf`Ȱuas+K1t-r(8) <u0;u00 `
РG`ћ /!gpA]P	!gf>tq  u7gfW!Ѵùb!g!faQfVWo,!`f$؃<to<}QoNa YqpS%P
fu ~n!!C߰߀06	 Y PQ1fWhqtU O </(y
rhMoR"ZIY0Vs	!<M@!g]@ F ¿UYa]W, ,e
m<q+fPfS0t0HPn͂Z.%tV
ffof&^q
UJ 7SQԢٻ h
p<;wNOfWaڇCfG?:	-f_1p3hpN  Y[R֡<vmA
tHR}s?O0ۊOh	}Bh%f_Zp Pt`iXs SRrb9wcw~ Z[=P0fXf^P1aMSE@@t8B`d?oD@tB *!!!q$1EZzEf`fP SIMWuUffCp  pܾf ;w(hyoX@fapp !f3~1?SECUtIfuffqT  R Phrqz'XذV 
u#f'%QX!uOB-臷@ @Y@Uhy,/D.Sw%!sGt<S
 0TTV%V[tP#VXTTtS豏h&
wRLAG=< "%= n_ =
=ufu>_>@ ƀ %]j#ffw	bï#
%On& @{f_r@'Af$g&$ ff%g&	{ t0ǁ  #9W$dAIfGtt2t~tyf^% Kp&> f`8>a ,,0? f 1^wu`4
f r}F`jr>0=:@t, pur%pr}QY	 cv@.  Y% 
Дt`A
A!:0.A2 r&&"

rr(@lRVÐ
\ _rP#j   t
ff;t;2
 + t WD@@uD+^@[нP<gaq$FG@V ߌ،}w	0R uB	
ff!` 


fffGLp pB
gFrC
`wfPfXA3aq&3 vR%αho/G{~fQVWP61`7:u"hZ-*.$bf+, 1fY7@ wY.	A_S 
fUgfp>	 --

fw+0f
"'f]^ -##贂 /I?/Xv O?An@uo%f  '  
$$$$$Y3\[YxGry=tf \&{q\zA5:
R




gŧcVl2l9l^lfrheRwwP& gs/Jy t@R]fV诟:f^AcgWs@A91Jpl`` x  ;a ѐ    i "`x}6f!!	"qn&

9

s 
}pf>w_ r @  +f 
ls̸Ћfff_QfAIfgf)dho1)^ö@s@KaOLG 8KzF!%QqW0tCue*!+1΂_ f &eͳ,@2r1 Jҹ
y Ή`f6v#s
sN衟`a GE؀AGaT%ÑQOm  3!4~f;Gu Yб1.D&Dηh'	TQr>8?S@_g&	sPfZ!8RQvP} `ff@  R!$^>  o 3ҀЖ(FfϋfZo5f 
Ƅ
}萤
__H?_7Y@6@VQSv>f"
 HO9B1\#hHQ   C___[1)Z`V/#	
`R  eB   MWVQh R=
j Y^_S  2ۊ F`&+8u `&
0Y[fPWQ<tU;P5fX"pY_fXkذ/KfV}f`f&a  G&P&Y` X :v
``.f&r&&faõr6r5] P$s  XY
 At   Pfh'Քǰ X(10u쨀t݁	<u <u õr+r&h#r _2D8&&2QOrr,6r%}ޡ车pPqu`0"" QYaBP &` Ob Wv~%'/D&* rW!%%F%&&a cRqpMZQRr#*H)t2в`bٵ3ƀtq@ultE@>ZYh*#s,   h|OPa
/r#j
35E4 #C$Pٸ Uq< _  & &EZP 2 ;&r豂r8tW2@f`.&EO.tGS`1o[&M.;2` t
$ `#S[K85 7WW P74fRo2ɿgbfZr pvw5 &E
, C!	A	2ahrz
%00`P 0S!^%Pg  Da`6(  ƿ  j aV魆ī^`W  3 _r-"2˸ fDEDC{ B DB O D D4rru½X 3W2&*G_YS	  ?&*P.u&}Zu&E_[KH{ TZNF  20<Otb	B<tmP:R:!:IrPF"Tѯ: r1 r, h#UOddo:SQt
pujt)u$<Pty+o'KuҴqayB@]Y[-Qw @s"suDa~Y_+V o^W mQfR h3(_dtD/>(I>>rN|UtGV@u 5^t1VhH_ 6f1^Df@h  D ; Z x     0NmA݊$
Pdu	q  52tXr	  H3ȃI!ذJ2ȉX' ŹSQRft⤋ .xZp"z_a  ^`)c$tr+ccR *0hyhE9d/(#/J#+(*f(:fYhR`k/n Sf>QPH_u(2찋0&fá  Ի[`-rU(1ˉQq}Pro~zryq#tr訽?fSfFfVfWp0>f9t  tf<ֶb @` f  f`fff!02g&g
fKfRg gre h1Ur %8Vh4
a5f_qfYf[` r  sZfbXPSfRj07W6uLt;wEf6wfPf8 r/fg&bP Bfg&rfj0  Z7[XfWPu
 f   > Àfof`g0? t]ǀ t
t@  f?
: :  @(,! _  {f` ; 6f<rv`gGwf3ې fPf`kfPr:p> ff{0;w!fVg&f^ufFztf1΀!Q.Ȋ$pft QOg&$@%D&v@<f=ATADtlf 9&Ǉ ǇUs  SU3a  赖b 1 PD 0o3ɊE@s quL`U  EGWP XUЩ.>:{   ub >u }`
`
	`p$ v0
ƕ
$_RW8>xϯڻ
=
Ɠ>}W W8JÉ/XwWW8qӆPƫ?XƉſ W9ϐ9RĠdXX!XplXNXXKX^AcX:5@a }}/X@EP§Af.`~!u<u<~w2@ef&@T1R/SPӿu
f!s
uf 7SXQXSX0strmXZS!NM;xV4t ? u{_QO[ff[pR譐ø 覐 J`+a,A tu6$Eع" !2䇤s	7>.hؽr0{QfP gk#rǢq^swoOjd@cGɯvjhr h<䝧	`ú@ hu_XQfW@$QZ0YfqR8_" TL75SU	7U28"9àP=f`" 2r/bQ?fc
f]
f_
aUuFOH6  
~tJ]
/t"(L	_
f c
 o,1u!](r21]QWAPHuOrJUw&
uuـ t &
&&ƅ]
X_V4MOp3I^TvTVS+r[ం0ЪPQ>ιWc r\d`ђPSCtC>r-t`w 0 r uҊ1 r
-`u`dQ rdItf s`QRP@*[0SRNr&r!ww3r r	fPRcA@/Pދr}SQ PQPs
d Sr	rV>Rf   dgfY{uwR Z ?}h ϓkC Z???.Ѱ P迗 " Y0 `2 ,u   P? h_4R

Z@u
Sذ*` rQ(`( 0PS  I 1' RR  r&LDC	 4P>tS t3306J* Z`pRމ
t#4 c ttQÈqF  PQRWV̹+3"a^_Z$"#@1$G<u0$V 4^W _ ~	"  !(<t )	
R
q0J
g&/ܱ1q;`-r;QWPR(X֕J2u@d eRVа$rN ;rCr<,	r32Ptrr;wҀ tsڋ^ZW
m  а t0u
˾  |uu B߂ fo uf_& J3322t@@ 0	rn
$	"
uƋ߱d;sRZo3QFqF2t
2t	u˸
S_ø
_..W.q.q.q.qr.p.YRE|ȈVPC8úf_f%
fJ<bsf #g& h"XfMMfPf d` zfX!fX Vø0e  ҕ@! SŰwd=	X=  #??"DV *#tSIyC ي	
ڄ
Ch"
O f ࠨ r f+fMhggff-EfПffqm  fAMSuff>r^0q"wSP6XAgи f|	²4 PfJDJQf \f1rY rEbɎP < u sO/r5fR fR_^_fc
?8.ڜrBȁE>P@
_PR
`f,t0p A߃"@`Ņc<tD"ЎzQgr&=t&} tV" GF^rYՃ"G
\AؾDaþ 	 h2Z<_$
!
"85?qL2Ȼ ZHó
_X
_ZPX _y?  hY `L~̀RRغ0 t߃@Z>:twhXÐ9 < =i <Ѕ2<a
 1M                                                              - UPRPRVFZX}0RR30ZO                              ޥ Ȏ Ѝeڋh3  SfRfW٠bѕfw t4`7hLflgf&' } fh hl^'P}hrzy@d&#hf3 
&G4@݋tGGrBFB
6
f_ !hfwQ Ր gh*L   ddh=< d>il thndRh6dCdyff[fXâ'Qfff f"% fdSlQ#PffdWlff$ddol fQt fdcl pdǣ[l0_lfdW2fW* ufY޳Wf f_#B*J"eRd辁 ҁZ1:u 7yqCYpPBWA;T/; g t2f0Q1  ;j3 hmoB4_"Rb hcU\ZrT\Z & t@πp>'E r>cr>ZR%t;7T `*0 b0 ? fRVDhdf^fZf`s2 |Lrb < tTyrhfa~pLf`QIX
RfV>Pf3//< tff?fXT!7"" h=Qf`/)
4O
O
d "	 	 P"	/	(	&!_!!!p!Qj                                                                                                                                                                PQ 蟈tu
oP``Ҡu 
XⲰ; Rfu ZlS챦Jn_
 @(00k϶ిEf p `Dp   &Et"D  $D(@ s `ف&tȀɿ 4>2@"۰Q
g&t
 HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m 
 Gm p-'s 0a` aװr * $OQa	 & aSQ # $$<@t"h_ϥKuKfZY[<uK&Ku`.>#Gst&3r	#rdgdԋaô`prr X ? !trK<0vqw#8:9$[a){fRQS輻[YfZt'2Q tu
| t{ʼ@`蕋0r&C
ADjG>  &fP  hiZdruf>&rfffGf  p&fKffzr<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f뺀
 0?  f$fӃW[QXffPfXf[X*fXaoP                                                               sXO AU d              p                                                                                      x   x  {S    
 MBA U<<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.4 
Copyright (C) 2000,P 5 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:\` 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  t\`A%D
hX p t `SfQfRfVv&  &\f?UNDIt?h o
}
3EC4:  ROM ID structure was not found. Gs<hh^ '5is invaliPPj Sj < uf. fGf;sfA7 f   u `Ef
@ &6 +&p fRSfP& ߎfA%3ffJtuہ 3fX[fZNwp' W.;	s.
`6&PfP WfUj j f2 R0	RVQ캐	&v &D_6E  U   
 
 Ff 0'VuH6U9Whw
˃f6UfV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6'drivimag{'.8: A!0c_.S.*c1fsegabp
pgNV+.> >u=h2!a! +%93C44f)J4Nf04^f.P sLhP  roo  AH" ԴN'rv&D &L. &;D&s_&D&Q- @] Bq.HPeJR&DBVB&(Dv
AzEA	666Wj 1_\0
0 uvv| t  uj@GH F_F  R{Xt&t1u1f
G HF+F)F[fSVW |1N  6,
òTۑ IfT     f`_^f[PA^@@f]f_f[fXw t8sVTUf1 ڑPUUJt u VYY1i< fo^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  
 s@8r &f.+RQA)ufqAA	f]r.ۀ>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to aborMt?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZ~ 	AxS@xf>f . . .P 2`<t8hnE^WOpѰKrequi
 DD?IM supS=f0'  ˂)B	.<0g~fh fRjfj0~fЃhQplrzfu0h|%{
I# PMM func>2
numbec` u)hgE allocufP~pfprgfgfff_-.kJah   .tf.>J r$t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j ( |  LIENT MAC ADDR:A  #x     GUID{: DHCPPXECli:Arch:@00:A 0# I5P PSKePROXY3@
GATEWA MD  BD` 
Auto-sel:
  BOOT ?SERVER)    -->  MTFTPTT l! A1Hed@roxyser?vice d 51replyJ?est  @> 4011.  ul25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[>/cred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeo{utcopen+EQ - F@ NAcchViolrg SrecedPom ##unknop!c$re*	<	connp!pRB NoS7p6)offers we	'  ]f#nam %e.RAPI}e 5u{ICPr multicastdwh~0thr /)PHY+figur3lDataL+@)aW8EEPM7i
sett<a,rrup(too many /packsdF ; MediGa tAE7,D8cable NBYPabi o=basE> BCQ4FdiscopDsFlim6H-u a7nd/)mpHC CPFO&%s`DQ,nE6jbn-mq.Pp  /-\r]
SM/DMQIŏe Hd+_Us_u	 Db
 
`~ uː  u^& 鐃>.3 u3^.3h]t0F-  r- vHHt
- r 뾐w:: MP3   fv?FF)~! o'Ґ f  -u
hx9~P\FmCt\놂[mo{cA벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t¿ Mff99f2 hR99@t{Jtq ^h
LShSF` S^TF9*9Fr䡸9N KpL?2#ZQ"1KNJHJ t0 tEVPhSp"
FPH*9Fu9R 9뮐3>'u> (t
KjJ!
; 
ta@0`9^0   V@/[0.+Ҋ*A FVF	$FVu3^Ã>гt3y(3*3(wh2v Es05	(3;7f(3 fpsEy O뜐WT3Q44h96:6@ 636H3 |38tְE<2u}% 0ҀĀ FVfF^}IFf+	`v6 FoV7u>P>f6(bK
:	@" 9IW:XF@V^fGPVr$=NVu^F^G(P	eYD^  G-- v%0&iGN ^& u*&GO=p u6`&&G G#7&r&`O0 	[!W8"`7u7'G P99HG9@Gf9  fP2 VH@&#P6VS*&	&R&(G G0FF`FF9G6@NfNfQhA UVU U^*&O;~S*Q
u3s  S3#G$PpTqQ(G	\1'G!EI<<hW;?.3%lB  t&} }??XgFdְSV RPV`T 
 C3& _2,Ph!o&Gk3?F3:Yw			7pf(21sK,  8-tHHu9N5COBv-*}OO$+SEA20 GP)a b   Q  u  P  Hx3cV";{G& 4@ P`_

6D/*WE T3WAe1kDiuQX\(PB@	=3 =2{ }NcwE-6 t`KiuhBC 8f#30QG.o'Dp'P3Bm"ol~N~ tI01DR{fQ [:×3URF)v; 			[
";S`
 HǍG0**c&W7p![ 0XFP V1Y+`ppp q`q$JfjFH$*F $ t
{! HËFFt|y#fÐBaf'dUmB`G?F$ 5dg2
I2
 2
8
1
I~zf0fFB
%a "2
P 7,G9bF&$U'b
81_H~fPo'F萟{FPtM +;Vr
w;FvF@F3!h3F^>M@Q"dP򻐘p (Fb +ﾭaޠ+)6H)ࠩ?FN)z) t)hE)`WuC` WV2! \t2^_2&spO( IP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Mf2fx{3RN|r!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"DH			th&Dժ	#Eh.dDf>	 t.ڳa Fp&J>1u(as$])I)K &^lQ_@	+&`aL h6npVIǺ
  /daF^q ur}t ,1R#F&3GF>t'h*FFb5-0wf% JZ3M.3:F!^333&PF63_9F|׃>> B.3Bf FgQfG9m9!Kбh: C$-h:LiHPV3 Qa BFgjƒCG<Dp w o@*DNHL刁i	TX\.
`Nh#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^- t@9vO0j>`c  Pjqn@mv0*-< -`d.F;Ƌ}	r58X	 1"o@*F69Fr3pqQ#z{#=4PhK{0Htz0ӽNh - j F<B&&B$6'GIr(p7l)q&W#qNxCpA&tiG]		$ 5$"qG$Bs!FQc"  =! @$[W
vS12Uc~j,hPWb	,5,ԚD+,&_*&G|&_~-5ps0-+@)t- t:' t $ u&  u
&0B2)?tₑ&9Guf& u   t؍G){
p*tP\WJDvvv87Vj
 &fXfYffff99A : ;SFqTjФP+hB`ix  qS2CRPT
ix &nF}Ljp3#b F=zӂP0z07u~ t	Ơ`82[Dlp@aAg3kp-`'C<  ǆr Dӯe8}8 u9c9*`Ӳȍt0 t^u_f~}R9Glu]"pu $%#Aqm Qn4!"&`afP
bq;2ge2dp&O#a77# q8#8u)̋- Dt-guB%t) upuh)5'@D04Ȍ#XP}Piܠ,)oP-)I
#p&&b``y
FP11&Æo%ca;iv1t u-iF f"3u30RӖ
Rv35erѲ,u1}.iv; 
t۶0=>P-"RhQ,"-

uۡ	? )&j&hy4B{sX5tۢdtxuHC$N"lT=1AiFUPA9=% pXD` 2?	 9t>2Pc
4 c_*\6p^p0)HtHti 4H
5&6
2{-Ęo4F@Ch92 < c+|<, 4t	"]
5lW
!!
~
3iF 2pah36!1$30 #םqpqQ&$ ;' cb;
D?'0
	!5
0
ndu>2; tpy)j{pn:9&Y` RP3@"{4dtq  u
ѨC D ~ rq rરlFP ^ V Cu~3?++v^F1*"  SRPW^Qu0@|1a}1̿P M"8k@1au`ug\p1:O790qiv<"ĘT1 F9GwxO#N; ~w taRVEPV9
4P`XG&W%?:FVЭAi39Fsq93u93ut[~o tHS`׋Fa-2ovi~`؎FQ@>PSS;\u>St
FR`_s	.!P`V\7hbn21f>&fp9f9thx轌 p~hq9 t@3ޠf 1ƹ +uh?1 .9Ps!1rh1^`2
b2 f|
fPȡp`:޳1h:U777ubQ^dF@R1Ċ 9F~A !@ux  k^ ^}
 ̽L  ?   }/^ۋ  FPС0eޠgQ&>pSp8Qe @
uTRRS pېF~!uU @u1rBK+o t'Muft1eРxy҃yy \t1{Ðfv0pߌ 5b# qO4 t&Gt,!@ &!t&lŀ (| ubl t | ~GlpS u0pUxTxTp _ {t--Ű%`Ez G+3Bf&)f1F?FtbQ~ t^ݰuK{ 률ؙ99̴ t
w^MQ5ף:pθ #^85:FFu_	63PaX`ɀ	* 5*6 FuH^4H3 u9,3ܒ	4<  4  t^Q`u
43	VVCg `= = > w$1,̋V; -^Gqك#tOaf6 K10*da@&ğɤV*@L"A!i2P8PR&73c 
pI3T f+@F^h
&F>pS^qecNF#	9FsA^b?	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 0(q@;EP tutp@6~ t]z>_T9PI0hw*Z*#$(pK@|%0z&F
`](R0>z`c 
Zs	
hfp w/			/	&			cu^ABsI>0_)FyV)vf&0a`_f`~^NvVFn
fa
@P~ǿ  hRP&$ RNh^V6  u*	gA$d t^!U$tfX u	   $uy$T u
vxay%2     v wr#@4
XpnXs$htfuCwt&h⸻=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw~d\ `n`t`1 t\nr0eR
Nx!
\^%
R
"


 Gq(e
OR
d'3`&8g &3;v
軖&`Frb@s
hu8p@?Ht',ha&)&Q[NExE#i3o+Ǎ&k&K!%}%"_%+`Is)tr %eH!up%  )fǆl @ Ɔhj%2&  %hJ% 0O&= Btw3-O-,u 1!?0hI! t#*Bb- [t- 
tQ Ğ&8t& `	
uAp@_*h$ǆȁ
 v}/$׃Ƞ ɋ$
̃ P#&
h [4j*"8gb X9A	
@R$ơR
9FrF
0r%*+P/Їvߎf`fߥ^z2hXfhp VoV3QP
wPʿfh  pv>)vp+- PY3 $=.t = t -ot ) [ tNfhs
V
$q

pc
g
U鿀=K_F{0=ikI'HS-	t-
߄-= K-w- 9t-
t- ,Mt- ttrV>Pu$ >=T 9  r'9>
 tFu'^ !^ fq q24RPV>90
 ^)@Zu)°N J?63L3١FVx'p#) rt	tp	M ht3h9 2~9
 8 .!L3 (R 6 jPP ff92uvf u:9u1Sʰ~(v(;w l!d  f9S&:Qt?F3u*֡Ju9L3 =2 g2 
>J3`kE~F vN3'@'toHHt	H?Z !"(~ u"hdhl{p  ڰEP ظ; \&u< Ou	=  6 t?4ft3DpuxPp
 `_7N3? >r-&+'Ht
&pVtge9ԑ&- P9pQ~L~~?? ?D#)>2 u@ܿ9 Pp:?h2 $7"0-2C{ur_? ScjRY~O d< #@@=t9느p
Fߊf=E` v`W W QM [(3*3'$v_	v	1b
 g}^c    	-C$а=Jv9s!vp29a|Y&v9P31%PQv9X#> l
GڰSM>4J4Mېp9$ G*GLQ?MV?tfG[GGID:D/p
L
3LL9 3t\Ni2uY@:ADE5 9莠(뻁>? K9Y#9U]-U"Us>":Pe 3df;ÐnP3|t 1*䊇N tqu; wb ѐ:Аv+{2@Вfj
 fXfYffffF~"FwF`^)FX@/9Fv	F_F ;Fs"O=~#vPp ?F~s}{@~f+f:uP63
H3r~tR}P? tH9}b  3OF
z:Aj` mP
  E03v9f"0fPfF  FQ3?2 23-6@|p[~6g{!H~FP@2R}Y	9"
C<	vaRs
9" *vOb__{P @X)W) ffаHYj&ڙڿN^+wFV;r
w;ȏv:k@+؋F K@H$d +3
`6@3s/ pq(~6F:7`6t 843[`Ff(3f@ 9Fg-/	
 SP]dF\

ׄt)2|3a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*N-008 t` 0rn 9v҃ F~   WVA?P0bNq؋ɻB  RV3^_V @'=@Sw~u!tF0T QN?V
 FXơD!@
P"{
 ވv3 vaufpocteσF t  q9[EuEc>f4avm3dҕ%|! c~~ t?!(r4@q0]B3^
0A 	 r"h V3 V3X3LY)Z3@03\3`3pa3Kbr`qpȣl38n3p8`aͣ9Х99p399ֱ9!ʰ9~Zv?r:qd3vh3 f `ZP	@M^ X3
 UCb!ggu	W3 &?r"` wh83t\A۲ 1  >kuёaa_{	`{V` FV
22##b&w#2#62;u5;+u1`=1;Sa7`N
 Z3;aǨS$Sp"p-}`f`m  3AF
a%RV x
b- PZFp ^ $ !tF f+F;FwSGsp"8@O+V  " 	2  @3QFFf>6 tK;8rBw;6v:j> '
?+v6 68{P 
@и@;"	P~t;Vwr_;FvQdau> uBuХ12122;Fu$<ut
f>W  po M% Ht pZM"69@2$ t*f`Ŧ^&G&tp&9&9WZF N%  F9FИu t6"u
ǷFe P$ 0V `Mr0M97AM@MQ@M 99~ u-B1N =tu1QO
p
  t6_F^r't"&
9F29FXa2"cK	
$`$a8	 
B@Au.n tohXASF9?F{P<@F= ^\l3n;FDVFRq@  9F9nJi	+QmlpmKv	~`-t<1Z΃e_q0!v`$,)P(_%4 18r6\dk^9u9ukF?P!d0ABs
 uߺhh? 3}!Ƈ¢h9 迵9P9P
9Ȼh9
 fPSS3&R39p9p9 34G2p9 эG
Paf
! :
":ukFC	qB*siQC


w
t!9

	
|`ЮAf@o= uE 6"~ {
C 0\
u[
 ufs9u6a 苀6X_6PPR@`霁@^#br`@Q {a	 Sf f h:F3Sp099oh.:  tPá'`b ?q3[g5wt38FPj9&_0`Ð*GKC!ՍFu:~aua J~Ku.~Tu(~Bu~Pu?
  st`" Đz   ǆ~ /x ~bB F  !MSQ @@  ;sY[S `F@0Fآݮ֣Rԣ`ң9"\FHb	X AW`FFV6!ZPFFw~oFH  FFF^0ċFFFF u0F&uF@ͨB 0FFF%'?A`VF *|k%ōFP#
L@.OXf* PWQRU>@ ~> j>*]/ us>@ ul>_L |is b w[>* L &D F +ȋѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tF.."
0 .!
<!
0t9а r   fa.>O.O! 9r & ӄt"QfpO u8Pwh3ظfP&.O&G.O[i Y0HYKSQ3ۿËȋ$tFhf_tbY[Pf.OI f.p	PpPQRvo`q
˃ӈ`
  .O
X tZYXÿ."˒O
jЄV3pӋû^]
 PY@ pσt2W  _^]Q  2sY >[
 u[
`lZ
OX
 ^!PX
R5?T
V
aaaX
c_  p}b> uV+T
VfTm
sff  2p+9Vwr@wA)
i댐>
 tZF  ץв` hl} * %w^$9N P m@NQhUAn`PV7$
F 8Ft)F ~ t/$$* ^ u`+OJ F ⟡Rq$Toh`y?	-t-,tzPWVVN ^4~&&Q#2#222##;u;u3Fsޠ7f9 usD99r;u;uo'^_`VA;Ftip9^Qaf	L24	9a9FPt4ŷͱuPPR"`fSfQfR?f`<`Pf;sf;wf;r v s@fZfYf[]SQr QY[ PS [2BppFt%&?	u
h*tЯF
Qm!:P'  0Őw0: .W9'1:aqa*'I+@0>ɱMQ 
p~q&Gf \DR 
4Cn9w*d !۔	u$
wdw
ڤD1u`2Ru	s2G2ZPRZXPRZXp6aIP
 w F`N0C L2aGÀ0v0V^  F+2@ @tHH  ÿ\`^^
 t\
!f`
fq d?
-	k d
 @hc td
37d
+
@2f
9pucf>`0i4ߣ@h
0f`
fj
+j
l
f6j
2+[TQUp΋d
)R%0PÃ>S j
^0]uݡmV+ɉNFu3P\^f&@gp ws0WI &O
NԀPU `FF&9wv1hV_ a9GtS
uжVdoY@vthn?
V	`an
 `܊q ܂ rrÌ ơOVfWOˋf V0 +N uf3lf3@fƉFfFfF /lVVgv ^`^~320Uf_f^]н2Z
OfCORPfEODOMf`ްW'fufuf=23AIt
f=46AI`(࠸[`^_`p< htFqKV1Ym`ЋV
l/FtSYnF&PU #@P*C#~ ~ON.`xDN;׋Vw"?WV~ӤyÇWVRft x⠅.F&%G<ar<zw, arzw :wr? `SpwਉGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ϒໆ^FV m*&'*@?@ &l &n of%$Pf P%#f#f#f#f#f#f#fXS & [Ì؞WVS3й}G@9ڃVp 
VN3Q||8 pVفKu~f
r;Vwr;FvN3ҖOu؃ [^_N
Ȑu	!Sf
΂Ӣ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@uP{09t
 t`Cr< u	ZXCu33_[ö΀__SM__v_DMI_0 _a$PnPB@_M_SYSID_BP ʡ1/ tc'dD@3NtaA t䞊аȑ +tۂ6 0S                                   5k   
 UNDIUL+B    @ ` d$ UNDI  ; :`PCIR$I  w      ?L 	 #$PnP ]u_ !
HP Ethernet Boot Agent v8.3.9 Copyright (C) 2000,P 5 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 A  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tx\.  <`!68\.	 VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX3S2.ur*= eu 4= ]f   @g@0  .9u
>l :@ tIu[SY@ @@ WuB    1*WSR..>f&=QEu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E u}qGG1G؀}|E$t2Z[_ϋ]  .Vf p .f XtfX; fRSfPp u'fXff)Q)0*	f ffX[fZ? sf 1f  f
f
kf
fa PfRfQ`
 q\
f'Rs
f_ufdQ
fIu sfݺf$qV
5fYfZ` 9
 sf3(
V3qfR	fQz
fPh  u
f`h  u0zf&	Iu`}^(u
1 *40"t*	3tt"t!
tuA- .-0h  fPh p @ &eKPy)}v ohSQfRWVsf.> t.@   ځ>  Uts r r hPH 
X%
nEC1: Base-code ROM ID structure was n`{found.   3r덊  t	}Sfj j Rel>  t;sf>BC$uErPj W"뛌ێÅ0 2B ʀ
  w.6C6Q   j Ph
	D
CZDt'h.	RRBX
BC_#~() ==  srp@hY	M0F: Exiting P6 X^_fZY["
fXgX=eKt}, q . fТ 0l S&t  D
c&6 +&p F& Do3ffJtuہ 32F,G.0	pi6&ԋbIPTWfUj j @RV{0l&@.6E.{ ..ā.e
`Y{v(VVE6UYW0f6U_fV  !eX t tk Ȱ6 ɀ4WPoO3203IOS extended mry c` error66:3driv0image is invali5%98: !$o8b8;seg9:NV+%GFjXGWhIf "` p)ӎF.3v wFV 5pI3ICOII=f^f sDh
PFx5  AH@Rdrvf&DFO&D@ B!U H`PeJR&DPVS&(DovAE@	ǃO6O6C6Wj 
&\P
/nf "zp WhX6 u96} t2 QL ` N ?b 6EF` 6]
076u7]/fS˶ RfZ  YpjUu
 [$8v uj@OH F FRvXtauPtfыG HF +F )F[fSVWFU  6@e0(!(pQfT`k   f`_^f[^i?f]f_f[a!8s]T\0 !%P\\Jt uw ]`)`T%T0pofPp = t.. ﾭmޡ.s	N]&}t	q t+{f&} us.z9wf&+f&;Esp `_fXRw/=  
 s@8r&f.+EQAuf  A1f]e3_` GY  ГPb tMtAC< ޣ@^p.G3. G3Z O0 Ra_Q Q Q^p0p	 aTTR!U'U$郑H.w 16%_%IOs
  ]'uTtTs
 Ჺ	`&<jt.;60 r }RMXrإM=< u wG&DA 0S  &LpS&S S"]GT(T*T!T0PV8UV2Vi:1QWXzUqUQrt }VV,rUY˲Gu*.
n T
 b	$ZD	R$?``f[]s,$ QSxQ/'f[ B :$|0K ! 2Rf.>2fPh7fA @SV ; pp m@f{raPpEs6 <u-ftq຿  O,m~ 7F`uP4!T1h@$"uz	!X taN@ M ۊl 	:p u@X2@+`TRp f
`RúfffZSYPsfXSQȡ8tYQf`S Gf;ta#U	CODOtSfQh= u.fU f
af= tAg(of<ac rp"uX3.P.P #.QW.m@P	P@@..( SXf%/bx]Etherneot Bo Agp v8.3.9
Cright (C) 2000,P 5 Hewlett-Packard Develop Company, L{.P0All 2s reserve MBAnfiguration Menu `  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"ChanpValue3$FieldRSave Thop2
@1selectable1     Dis   En 9                 $Protocol  eb&Execu"EnvironR#(j@)Rpteqgram Load (RPL)! *ap (BOOTPx 1W}S-6  #  X/S"Type  Auto`-t BSI218h 9 	ix@π  Hi0Setumpt 1he9:displaypdurin}ginitiz5 6 { G@ Y]`anKeyok`5SP+B6B  kPcs ` t!1c; u 1 @Bann Mess!Timeout  1  Q6  2 `9  3 45y6I78910 5 7	7
7  NonB  ;HUbo|4'3F y   LHSpeed&Neg.10Mbps Half	FuT( M]m}M%810;@ :-;Wa@On LANp)1Bc9АC ff tf5 fQjOuIuЖQ@ #-_WsZf ؠ> u
fUPf]T ` dff˾!@΋f< qf0f	u 
2
E,=
u=nu % P> t 4 011auyH9=П0|
E2`u
F)fZ_W VfEPE`ff%>! t0@ƀf¾>0	BD`	
>u
>s 1pȅ		E` ff Ns*2˸ᶪ`Ԫ
Q##ѬY[_q 3KtRMtpPtHt.ct>  Ρ =C} Cs }h 륃} t=P u7} uEEH _E 22@;Ev3& b.# @uUC)RVUmP	Xum
>n ]^ZQP>*=; uXYWQUQR=m uUZƄ]Y_PRR0 ZXQR	 ZR {  ϰm  [ ZYQR 2f4RvO裿 xS2_SQ  Y[P<P>FXô
PSQUE  >
]Y[XUP3>F 
tEA@]PQS >	o  &
 [YXø  RU n 
uP	]Z(*q3ɺO	f`
   `!p:ޅ 1.? PbXL7RZRZP0L>
[3faCWa.f8B  ` of܆ܫ`4Hsp [ .1LPu"=!OQX?tP۾Rm c@ffptN ]#
t=`aiwu	 Pf_f#Hpd ݇\!_ tÐga`8 ~ f%5t|  s5u&f @S%	f(U|PwuJZ/$yohrm uC}!kfnr!afRmQg.	Itf{f]s`};d}f1^`zrp{fSs.k3r05t.?0zmy pAxf@! b_$t$t
%	t nqxf ,u1 n2q t#T3QCG34F"u+tf  'o)[T$t:+t:AhSr;1BPq(Pq})
f y%T$[Q0r rffR2 u	! ޅ7f7&7'7`8
݃Iu_cM37ro.Je_da [qQ ۻP?_SM_ts OvQj Sjo `jA u ЀwrgrafG24tWOpQШ Yuf= wSX,g8It#gfXfg f@@:g@tgef&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[e3?t2)W >u>^> Mu	>p GufQb` Pfj D< uf> f^s PQ1߸fAf t;h_)cYP2
PXE-E07:  PCI BIOS calls nsupported. .	uL.;D u3 tnh/*U1: Un6Device! hb*׊P^	4: Error readQ
space. f3ffwY}~ hxjkBus =# FuncAQW *_YSSϬs<f f rfh*.Ph*$PP*rP׿fX53QUf
|70M&V ] YAUi ٻӰp`!.>B@P5 .]f[j  wPРXu
U |U.P  >.{@[TORPu$.SAFus
.B ` t'?hUp    vh!Q .P 2 <t@h,PH X}U.6: OpB#ROM %quires DDIM.. 9c7~ ~f;G0jfjf.`9afPj,(-?fQ˃Qlu0hH-Ԑ2=x
Invali0MM f'"-number0- u&h{-6E;:oc/e1. @@Cf	 `frgfgfff_ .f.>1 &փ0t=t	 tz` b 3fd @d f   $ Ph   ^.(%tf'P r
 1	. Qr 
 < pxcDIX+802.3 Media test failure, checkMble 
CLIENT MAC ADDR:ownload"ed

`SearchFfGRPL Server ...  AbQBCM570?X FounERVER NODE

Transf`Kdata fromrs,xne NControl to program @  :   /-\|@ ă tttttWS ˌt& 0ˍ$Aȍ!`X)R#ڀ| df `  fNV+S,#/E@ @f`G#?VfPF= t
= twM. ~
F&LێӼUh@ WPC
P \Xf^tq[f3]1pu
 /` jv
]w.6 j p>
f0<
	g]g}
wcr^c
f&H؎p
fU
S

f]
f501&7uPPf]f܃>Dj v[SJJ/f@Aa@ . 3h p f&D []` 9h uf. fh ``  V hg&5+g& ^RЀ+?>S_\[$`0	eP
fX&
=PVuwNVf. sf ]ϝ# 0$ . . SR[.9,up r   aVSv"q GfD[^]f`p1 > t;u Tb%@ ߰ Wfabp-. °t!  r Nӄt"Qaf֠48Pw h3 &.@&G. [i YpYйÜSQ3ێËy`#tFhz'09t`Y[*P#~ Hkp	03PQRv`q
˃ӈ`
BOp
X tZYXï"kO
ZSKJ7L_PHK+ 73TuVV6R6pgK^ySKK3tڋVN[tUVKJ:2	3V}Ȱwf~ PH   u^&Uꐳ ;FS{Fk @ϐ{C5A#cE{됣C逩Uq gCY]SރI#{?5c+g	!	C
= tw%= w@."= tw!-
lHqQ v {HtFj+=~w
-~- t-ڠϐ~@ː!>54 t^pj  h12uV&G)4p *4E+q - /Q1
3419r <:54!Oqu|C3A3!
% 2}
&1c ېV"!+f"43F4fUF3^|@lAGK T>3ua@B .<b	  	a? >4{	B
P/p20o54	}	Nt	\Of"4SP
L/	!	;p/	#	 		-S F1p&%@ F+PvnP TFFA#9Gw"^;)q c''t""n3*" xFw1F(GNR  ba0E&

z

F

^
FV]0+  V7!&;F^Î 	
w 00	PPX	F9F~'}*ffP <	 " ttf
fjmr	RuQPF?(; ^<#fNpG F^sF`=p{  t.&ЂN
P
~}-^v&.F&E"
|P O6F*DHtH|pH~I)b FF^/Nft0vQOR\0Fb e0Fv:f&p &@
R
p@
 w뻐+GfGFG0G2 4G6u<tfG"fG8$?, G
AFar93RK-B9999Q99x?zdIVZ%2F3v!ވR3@0f#|eff*C=G=G=D=!e49'	l
a/E[uE^a
adG"G!nGS.S]G
 ,H ?ZY@REա{1.J20tQGf 
ffEqrE|1hnSaRRv=Pjcvǰn:nj^$_&G	c .rG`"Pzss _WG  
-v9l1s
 +4#AfF @8MfsGЍ3 @\2\Fn#t7qW?K_t"
|@#'@@b05 FБHt- rP `ȸ0DVc+
0[ <	 u' f#Fkf0ee 菥 mJƇReG$PsfPh蜂/Gf3>PNt
4F} r\>t& 3{W_Pl
pR%ڠ6P| *G7i  xpj0|^!^vb
*&oFD: A`lu+lu$@mu#z") Fɠ1@08?&cD - t- t鑤 {^K
Gu!Hb @ 7N~XFǃ1F~w}&*t1) Gy+3  @5l4E<<69Gu9Wt +V-(++ *+ :++8t!U0ufhr0fj22,,1@`ރ8Ë mu2ÂP#SVp 0pNo9u2vv@VGGPlÐO p@RPx,,A,1P,`|10e|0b0k GG؉FG5 _^ Va5@ 
~qG_Q"HOW #@0GfuF@>*b{u tfwl`$""02F0Vp(ډ`p ``f~
t2 t(CMtn{t~t
#mu
Ƈ'  ,/=(u uPڈ@	<}t	ވ!fj  w/@ ZS`/T8hPuC% p Pu?p]   uǇ`.hfƇ^a\ږ1 t&b ě}#Ft^p{tq qtǐ@  Ǉ_ڰƇ]O f'rw% i}G
~uc]`.R&'T&	BTveK"Fm XS"%0 +- tQ $F8
%  P- t/5@% - tQ 	Иc00ZfC t_P@T 4t.'(,d
먃u0	Bt Ft' +w  p@⿹tR/a ,f5'0a>(DfG - 4.va:s ]A;P- u~ .|<Ǉ, dK fch j3lnp rtv&0 FV VFFuP0--$ suV@ L?ՀFV H*AHFFa c?VĊUSǻFAvQFރ~|~auae8`#u(psu)w)s+ҊԊ*A SjD2 >% 0# V		V!#B  Kt@^ $#Ƈ&E  $-@ ` =0 tuС6 9C1еU  6#P10{@c t+
u0-I5u~ptt~t~ux2Ln`ugƇMЏ5 0j!	RpP. `D- 4-p --t~ tF	@7'gtrTfu ށh E3of@7wZ=Uufux+<<s,@Mr AA  s$p>K$[`]?u>@(V?-bq	`!wVwixgHHt ABib=Fi\`c*n?C$bA$Ibg uxDq 0AyRHQ0C)¸ 襴  [Î  U¢sr``% WT̀P-װ9Fސ^WPF"~!]" wǇBP1ƇzP /0q!9Yv(kD]pG`]0!!ǐfv
Gv)6gG
P_ pc uu# (x ]zPP|@hCwSAVEpQO@xN/lp t譀lBp\% o@'FCC h@jt! 2"ʹ!ѫAuǇT p+V|PVT P-t0.ˡfFPsPPV"eeB_f 	pP `ue `-aqT4 $vfj@Dՠ t q @`@]4
8Q`4 _P?$0~p=Pr#Lq`@ A>-/(遰T`smğ`vf&0B`fV-  fj 0#&VP$A@T ^!"XX `  \fjH*P h!GfP,g{ӸMǇl& &YLp  B   [ Nc
J?s
$q
Q/
PwHÇ(`Oru Z4r rRר t`B| ٔR>c**䊇*   %5vP8Bfh<5  &dP(p
_ @b 506q@c 
fh fj s:d'<K h , lp`t( 8`^Sw<@yu0o4a$$@T %D`GT	 P	8A
*
B+0 p`
 -4T aLsπUHZs P`P(PJ0dA
CSLW<H 05O(腠 8 0ޣ qg7{82S. P8I?  +\ Z߇tP\s1W\\XXXh`!P +HtHtHtHtHt3.   Hi2ҧ ō&J]
wQ^'ss1p!2*RP_+yDȋ+p13w4+Nѣ4ha낲PxPzfps!!s tfah PF1tt2gQu; UP[S5A`GW$ Rh~s3|hcPOEWlRP}hlt*"#+!"+3@ЁJ3  PSV7؋GFF H߃00$[ F I	07FFPn4p`
v@%IfDrRېb0f)OGp0`8И$sw*^f@Q @@p@+Fц^ GW BcNA#FF+9W߇ r]O0E`͉@WrBੋV `+;Fu;Vܠr"wYr@$%'8E
	
FM=F M99Y讵 6  y~0>c(  R%3{f@HZ WFtWf  @BfF֠NfPV!`!S aP@NvMZx z_P___FX! ^ҁ+ FVڊF$F$`Fހff  Nfffvށ 	B	RF9߇)v frpN\~|DSV^^^@_[&遹Q^iW']un.ab";p0 6X  P54F~skF|FlBEP
PwPHPP@G69Gu9Wt*w ?@aI^1::}DUPS~ tL ;
 qQ;4`G~qP	QBCJW߉FV!f?9Fд0a߀W _ t a F@'Z- GGQp3Gof Gr !KV=PC
wW0{s@lPS;C;^ |Sq졐 0f#Ff0dBf@@== u; t뇌q t
NO	pONFBtIFt)` tF{t  7 t1 *]#" @	q+^XtDC
PQcvg\ěE( S
x:0 uh $3qǇ *IS
F~}PtpSt}Ru]h%`  F u<h@QWhfaW$Pea	-	 u&`7`3x}qF]9{aJ )0O
 ,B=q 3t9I^C@}!A % = u݁ksut`F-a2S+u
h,}SV=(u# u^q ^ '2FF`  F䋇 RVH! h=A \ > Pz!p?D@@  P  3@a#!u- = w.2F2P2\2h2t22
:!v}&vC 	 m~@}<))Kk M CŇkjֳ#_ hp0 0
 %1J]
x tP,Ht0B#~ t']C1 }0B1>Ft@2Kuz= u\ t:C	Ra.a{䐏TQfN	*䐶  F9F~BoNuN,  x䊧puq'! `xtohcʚ;{u%Q= w3"4W40  X"   *VV!"89w!/3`	9_fj"gZA q&?00VAQjP
@ wNpML௑*ө  uFQu#QJ INRPQi	U }RPxm߸ 21
@` 1FMm@t]F~|߄c 	@վ@D^b{`TveK ۸P ]p ,~ޣ=` unB
RjްBa5``X   V ޠ| P q޸(grPh~n胠g ww (u:@ t\q>Q 
Mu
@s@98 ss=ut	 
m
QDPfB @t |蟇݀ ݆*RP=
0t0A u PJ T&#	I
Nz+,fj@P$ 6"ݔ tutAP 7Fp	}+Fn&ΐf!Ftfv? `9F}@͊ *+1F1VC
Ң@ Wh{ <l a [0
1ీ_0)'Wh@ba0bP p:`(~ `V@CO3Α5fq"f% A WVd uBfh /RPfXfYf3ff	fQAv~pt8AV*@?pSfh4  Fj dݝ`Q Pp
Ra{t!W
;E(A#^_S``u
 uP2u'u
6`c$	Sct<S=8H:"4@LAڸ zЯƇdGh%?%  e`tku75|@F۾}pu:Q8{ٶ` u
 a8u@q62P A/{P5$<q,t %u<فfvP28̰QspRtK|t?fj7 $j#]Paoy u
RPِ!ff_Q!"s`ɂSh j1#h;"h h@EhPC`Ma0tT֋PtHt<Vt0"$(x$@uï2Ç!@`'P*"40ك~g
})`'ЖRiQE@AX9FuΊF$u%U`)8R. `p;Ft 
RE˰2Rpuu1ݥ?u0SPCWqZ'zQ_0%j Oth ^RB"b| ur?v= @v#` uv	Ѿ@vl hM" @ҽP?+`R@R"|h |
 ؈}^Bo0tfb_uDPn yu8fhU a! n=u;tdN"d|ݸ[4<bfj`Mқ@VPSƒG`
PG` (9Gu,B)`@+wac9Wu2{>|7@0P)G}GpuGNW9HvYG`k@	3yO>@W ?`8_GGf׋Gt@f9FtgH6XP^Wi`P	ۋGpˏ$I#+5< !ufGxf8A^P(GtWvc`w6"xgh2 =t(MCuF 爇h %fh@D>f+f|a?Ǉ  sG dUfSh j#[lnp r!DvtDƇP֠>>P` a? ? {a@ @O ">H= wsvC&C2C:C?BCJCRCᨐN<NFXඡX+9W$rLw9G"vE&e-iPЩwGA"Gi^ðU8$Wl뤉V) rOw90vG  [GtQsP&YlS"W$a|g1"
@Qe[Pu9ïFNFPaA+K F &@BEE?PS;FtN@  l &gn c of5^A\и GA1@BP409FvߪB+F 3p7::`f!f6ulGFAfhA880ؾÐ3S/P /P/P/P/P/P+PA"G 2f
#f  Q0  РȺff-$˝]WO@>"f_] H2C@@!PQRN;ssZ?YX]1t
X	S[`[PMVB^H& p 1蘼H4hh4J4 JK4fS4Jp¡ʰ	p^,*n3*sk at$?h: 倨߰G hZ e@Ccvވп: >RN:uFo~rѳ q 0hn  tfb4qA>f4 v:W4 }D
wq'h  3 h 軔PÀ>u+0C$Pj
 .{S4Tf

YJ4*HtHHt7K>O4}H<O4uU~]
@Q4wV4Q4Q	HB7`F\a|^<`Okc	@! 	rqސX	!G@WB`%'&!(0&:@#|< Q
&c	A(r]/1Av	P0OXif`<@s}" SE,;$?~'|6"A˲0P@Vµ1⟁~Gefqf+G0 43<ga׋G" 8Pȋk,*C
N"ha<u AM؋G PS  G1GpGQmE @ BW  0W	@ !W#%
 'W) t+@
  -W/;=@1T<|@ 7׉W9;ߺ( 虃<W>$ {臣@WBhPDB|PNNs	LH4B3
N 6
G@R ~u	BS3
XQ1Z Phߨ Gad gCRjLC][4C^ceѫQhaP baK4ߋM42kG/WwIe#JG,) w γC}a	YC	=2U"r1nq@!6F^^&߇}^Љ- ^?a׀ Y QG0G QF=C]$Ht	HH~ : W	=@W
t=WtueNu	f{   }Cp@}-uf0\ߊ@"|N t݀N@AW4[}btt3R!G<]0 h Bb ||/` wu_h oflqw  uG G tGWnP^4`0W@t)GWRI Nb4d4f06-f^4fߠ^4%F @@ +^40ua)	)h Z
p1蕷`t1Yw h Ih
d4
h"[
0

!a*`` +`ġA׳rV1ʱ {+{q.|&-q_ P@_RVFeЀ^&9G,~_! &x2 ~G f&p.1@2w
!1PpXq)F|@Ε1@ _1 	`1}PV3q qPѶ@;fP L^@Mp6hFf #8vY' QP<s9PV3P~22ooooooodЀ>1 u111p 1oRQ?11a1#苧@! u  V+10퉿Vf1 sf  rp+9Vwrw V)
q댤F, 8`,ߊF,q t$*$* 	v	6aĊf!V¾pȋp֊n* VԊ:	 	-t-,u!GAdapter - BCM570x NetXtreme Family B57HHardwareDriverMLID}  
 QTo  UE Q   /	  
R 
 ^<      < ]@   ¡pO   5  
ں  _W@   BUFUUub1!XWWzX"]rYWX{WXhYX]XXXXXXXYYYYZ'Z"]! YY[XUV4 8Y+& Uu[X  	 
 ]˺wW<SVsrt*ݕ+V^[ø.V* &D&Tr++D&5&].Vù VøtK
t(S [;Wrw;GrWڋR [;u+uo+DDuP Xه\.Et. ǃPG*_G,_.O7HuR.4U tlUu4  glvgn@w7 ñ..V.V"Vr0]7GûV  7t&&TW?L+0`~< .:uOu+.V&V+.: uuL
Lt\
DPX~u< 0s"UU+Ұ.:Vt+EZV]~  &V0B_OΌOWt&PDB#V ^uV&U+pE"u.Va!".VVV^cEU觫.QuMZY`Q Xu.VeZYQ.>V u _u;BVp Wu(gVVD,ث+|t#6"UPU <rg3.U.U &u&D=vV U3ɈM .Ɛ&0\`!##Atʢ.9Vu.9Vu.9Vt@0.UrF;wrtI着tJE ]P9
UD&D tz}R@Mt>2 s.
 @_ Q&|u~`dE

E
ED)7
 Y@۱PQ<wpU
Dxt.VU;wŉ5EEEU.>UtE  m.PM
u+P.UEP E E
EPVE.;Vu"VuJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.	U3Ã
Ëŋ+HstCP
u&PIٽ{r+\2!&/GIu*\  KBPUSQRWYkX_ZY[]XA6D*VV+tV,T+ێÊ&S&G[ú<V|w! Lr	t+񬿪u+<VTLʉLuIuËD頋D@ V^\uA߃!D<w<XøWø~Vø.UøUWVQ.U0]P U.$UVP  Q   AVY^_PS [X FFt%&?	?u
h00S`&F}QÀ? uޡ~\ V ӣpV~පu20QR 3ɺO@ 30`ᰠV
 Ftf~ t _F&VRPWV~@N{V^_< $~ӤAWVS3}GVpVF

VN 3Fp ӳ80pV`ٱu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3E^	۲	ɰ	ȱ	f		+FV
?+FV	Vhoi^b&$0<9vF%@܁                                                                                                                           -     P16X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                               .6                                                                                                                                                                                                                                                              eUPQRVW3fu@F(.;3s0k@.$~ ˁ ;u
t.$t@~ f^rf(_^ZYXWQ3.>32 .ǅ$?.ƅ$ ` P@hc .3 Y_$
fPSfQW	3.3^h ^ hRNwFk@"~ hσ 
N~f.$=&@.$2.>m <$u4.B$f<t	f!h.$< F.4 
_fY[fVF~r$F F;F FBu~ww
fF@ M~UfNf!t
fN!$pu
ffsfF;^P2$p4Q$
fqDF$<u&f36$F # ~$wp` $.
u0 <u8 P^`)V.k63@..3;.`/^V0&0
09t@-2x@2-
E/^S 65^5#5$u+:Nt@?ֻ_^13$::
t3-S9)Q9$um8Nuw_^7fPf3Vuh  fhA] ?^fYfP%
S?  $(t uq5u0j !0 `*-fVWfpF(3Fq(('F~Պ^^h<֊FՈF 0ff
J,F f^Vf^qu? @  QV3 fz ufZ^Y诿ft23fN Nf~ tFt"f~ 09FvAFH;F{`0Z 	Q}I Af9Fv9fHf;F!:F׊F8F uE3!:fuI"<`<Af+ ;NsGf?.\ :^3(tf+fD;<
I;f0Q~uK~ ktE2aP_F?.3NnP3I3@K_fd'ag	i"?
S#0K"# Lt#^`#F  FψF$
$F$Vf` ^$". $$ "`UqVڀ"ư NҀ" tFt'fځ"U"tmj"+d"b1"a2"f;>1"7 %A/ %'%S %#% %ъF8F 4  NhhU"  $&(U,VP2@Dc ffbh.$Ntt(sPeSQd?9FvI" 3f%h   f. (쟊Ϳ  BykN0z30b
t
F%  .`, q> hă~O t!~/ h) < VWUhC t  ?f yy@N f?Ah 5 PhQe 6 h<rg&>Ut2g&FP3EXYPьX_\P0(vX0}f	][Xf`Sffff h-3   f;r[hU WX
_ WH_S^SJ {rPgNAOg	rH. u \fawWfgf&Qfؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY_zU!yg^&N;=g =fb> U?  q^6-A])QRWV^NV v0Wt6Q4pdCY$DʫξE^_Z QкК tYfWV3ff1%^f_cfSVR߶ÉFon1Z^f[ffABRffLЀ`2fTf;w
2ZǖfPRft#f3رzfdpZfffNN 8ss4
t}7u+%
u	afFf `^^ZuW0ZF8^~nI^B"8uAffF@b_QWVfvnAF׼ϋ~f3`RiAМ$ч45SV ޾3; t	 r^[à,Vk߼pPW#A[S?^@俊$*&t@;v7!tk~@t 1;FtFk^% Bk^P؊ap 3҃  V3k`Ջ
C*;FuR3t7*t-k		# a
@S
+FHu
4uGrvFvVBs0;4VW@B΂tSދ[NuVp 3ҋ-`@_^P@ʠ**ˣ^S(IRl2XH⠻-HP$뷋A37Z  fGVRfQFu   kv@kF.b~$$I$@frDfw;=< u r,.$<u r_ s0	 @vFfYZu@0.3FNf1Պ~߲d
t".tt؍׍pvXv둀~ }ZPRρ00;F~f!20a㐥""0P2N~ tKv њ0`X9lq.A\$`
fPQ3I> FfP"f
	M SQh3	_ \PBfq23QR.3Ѯtf.7&3.`.83tYflPRWfQ
(5.'{ "  u߿8ufY_ZXNW!` u1V#3
6G_@+fz`  Pfj7/@
xVfWf.
ۉ^2ۊ~$=`&	?ftufP f.3| 1cf.@( hYS
uF,8Fuf_@EbgR.>3s$	Q.k63.3VЁ #eq 8
 v@a
#3t#ًËȁ :u!d;  v t'f#~pffBpp=prc#n;VǯF"y:` up/oBqr[tހ~u (i/ t>x"`{(`Z J I<`:<F?  .3;2;sN0 t4v;2&;zf~~FN@I.3Ƹe:2fV4P]b0)6SJJe{([tҋ\fۂf`K8faS/ $ x!V V03  1@ ^Y?X@Qu~ O u0V833LitQn
tw
ɻu7Yο y	ǫ_^Ha? nchppL" "  ta#2JP Xu	Axu/ u5   (ru.LÀA. $0G Wo?C                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   A     TPM U(    G  N K 3 U fWfVfSˎێf3  _f=G<t<t
<t<ti  f[f^g.$`f_tIFXTPMDRV-MP-SEG16 v0.95 Copyright 2005, Infineon Technologies	QfSfR
gf. 
g.a3g.1Ƈ3 4 Ǉ,J gf   u u  fP< fXf1ZYcQ讱Ot[RS  gq	o <  3[Z0 
  
2%uP 	xcst	 0	f{
A
2

 WDF<		
g1$u	
E|C3f
f%Q`&3ɽ
$f6Kfff˰ gCA 7u3gF b`RfgD`"gC"f(g3fGf߹ \"agf4$ +Iffg` fG(  (	Z	_fGg'3gf`Ufr)tfJrr`i,Z4.;gM1"2.3N4g1  f_fY`>Zf^f}PA9!F3RQT/ʃ`ʊP a  3YZRfQSڃ <u1 u%t<u u3
߹ w 0 <	IR	컊T		 0 tϸ 93 s d _ psOJu0t  $&&A	ML'a
pn qv2fR&St2p  f  `OQ f"FB? 49 f t|gf> tup ~ tmށ  te t]ffֶ-N0.^.6A\RZf;sEA\u
 ',[5 1 
@JB$
gb +\^Ðdr
3ҷqBH ` u
5J
0bu"K ЃuBw1dUogG"GH!G[I#JHf<k>gu0hph~@ Y	uBjd<u/
uG u\  OƀtHDt$2ED$@ff+f+#Z舢qu  q^rQQBNL$K		v
u YpC0b%3 wz}ǀ 7ujPbT[4\ tL2`Qxff3ff%f  gf!a	QRdgAbetff<f;s gb
fgucgB`ZSoVo oA!o'oBmpEqfgPR%S%"R%Q%
iEgxr	S t9
 [_Ҩ% Ƈz1yn 吞RБ tk [@eP{m `rCfRS2 !@^R nook n```` s
@l  @nr
 蓦 PagdTf_3g3-3-t
1#H GCCQw	000
000 0j=ݱP>~p%a"Q,k+A-$#qrqrtP Dtt%53Q . ) t  tA@tt
 22: T,.bFg%65f fQ! !Nql݊q5qt21?  0w6a`qtnf+fH  gV ]M6kLPaG.O_!t4DY+*+s0,rF`"atfSuN3 (`H0  W. usIu3PiY mX7PS[`4 !6&  SIuއY[Xp$
pqS oq[ჿA tKC>X p3P   = pr" fR
4A1f}f+8f#b%  t	fˁf{jf%j
tpe/$z Fidk&   x < BufН         2 8   ^      SEC3(     SUW3_3 G܍M  S.{0.r ۏ R f= uf&TCPA W HPD1\_][U˳ "P		  @ z
  @  A   < t.` t<w!3ۊ.;@ !W 
 t_  @  4  `) nzp
`<wX1R[1a b > 3@ upawP.Q< `0~ u~tPfAi /@
t%f=uaebS
RuCfUf   0k "q  
 FC1ލ
u
 
s4"#@A0f] Íݷ&]0'7F!'4s  iR !}j]@

% 
@
fǗ  %?34QR
_u" 8?	%:U	0?H
2%8L8  6WX
hrsqˉX
WFR#_  "-H  u7fEfp2<#5#6
M)F <0<Q6=U6fPvFWfX(> ?U@?΀?? @U @7@@X@p@E A@AA BWBTH2QBHH@83 ]. 6us9]Յ@κ軃%"c᪥tK%
%
\\"
I%v5	u;2# 	t	1
T
Rfu aZRwn u
1PYUjc1@1VmP@aPaul=qG`fQot<tvq `,^,YPu_ƋA'ar	u_̴ٍq6QlC
{u/FfvuQo}uxA k e0Mw@\
q~
~P:
@a `mbcPhpuf]ZVSvbrl蝻vZR8_`q9hgA;gBrQR`p|ZYqUCŻaDtxw3&uwԄB{ux$ pP|N9`tA|ba f;tCC` 7C@C
o0bC3ffFfCfr#=qLsuM4@pNF CO`,OP
tpTP,OTtWK{@Yff_fC@XPS
rYUY D~!֋sKRp5ӜqaoOfUV1(a Zё#a ѫoXCr'C m)%!	*ѢDVPV^t@up H
CXPq8VWx_^ tKS[t^8srN)P^rNfǷ u  fF3sSV+1-$ 끻qD;w4ƀ1W_r#^?[Vs1	Vfu1+^&F QVW/$q}Y3^ѻ TA FKZtVW7{ P^?                                                                                                                                         0    o ]FprT@F"` qqSb@ eCompressed BIOS codeOther     Calling INT 19hReturnP
 via#8hBootBCV Device 6E6    IPLCPU _patch                                                                                                                  #EgvT2b`4  WWsհǃPǃqǃ9ᐉǃ01wЊƃ1r u
@ow*`Q  	@g@_p
ȫ_a`Q;d&GX7 ;w+В +ȃ73󪋒@&ast@3CÍV_3P Q 3ff@r	#3Sɰa pw#@ yZ1'w33n!;wP##X~ܼ	2b[
fۄſPAbc"aW	RX APۂA𓍳&a    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  
xBByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$P       VBT             $VBT CALISTOGA      d 0   0                   BIOS_DATA_BLOCK   o  d1305Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 1270 PC Dev    12/12/2005                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ i              
  4 (  8 H 0         2 D Y
 c
 m
 w
 
 
 
 
 m `   `   `    @`   D`   `   H`   L`   `                                !                                         0                      @   H `   H  b                                               =                       $    (     
 
                                                                                                                                                                   !0 R`SI-1362-A   p          @                                P                                `                                                                                                  I   <     <
 2	 Z a-  	
                                                                                          	                                                                                                                                                                                              <                        <                        <                        <                        <                        <                                 0H d @A &06      0* Q 0@0p      /xQ&@X      H?@0b2@@      ( 6     6     6    6     (              @ @ @ @ ,@ @ @ @ ,   (  s     ) S	(		
	(		
	(
'

1
(_
q

{
(



(

(=O
Y(
(
(-
7(ew
(
(

(C
U
_
(


(

*   @ Y  ' 0 h  	 `"      6      X   @ Y  ' 0 h    1X (      6      X   @ Y  ' 0 h  d @A &06      6        < @ Y  ' 0 h  0* Q 0@0p      6     x < @ Y  ' 0 h  0*x Q@p      6    x < @ Y  ' 0 h  /xQ&@X      6    @ < @ Y  ' 0 h  H?@0b2@@      6          @ Y  ' 0 h   P 
00 *      6     @ < @ Y  ' 0 h  ,@`@0 *      6 	     < @ Y  ' 0 h  (<p#@0 *      6 
         @ Y  ' 0 h  d @A &06      6          @ Y  ' 0 h  d @A &06      6          @ Y  ' 0 h  d @A &06      6 
         @ Y  ' 0 h   P 00C      6      X   @ Y  ' 0 h   pQX 8      6          @ Y  ' 0 h  d @A &06      6     +a NU XN  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                      sU)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ,8   07/28/06YVHU(   2 G  N            N   U      WVS3    _3   G<t#<t
<t
<ti        	:  [^.$   _tIFXTPMDRV-MP-SEG32 v0.95 Copyright 2005, Infineon Technologies   QSR  .   .   3f.   f%  Ƈ  Ƈ  fǇ  J '     u#  f u   f u3P9   X   Z[YfQfSR3.     f t	   3   Zf[fYfQfRfS      f%    f             f3f[fZfYfQfRS          f%      .     .   u .    3     R   Q  .   t	  >   5     
  0  f t   u
  f JK   f u?   j
     `
    $u
   <
    $u
   (
  f3[fZfYÜVRSQW3f ?  f   5  ލ,  f 3f fǇ0    z  f W  f3ۊ  f@  ff ,      (  Gf \   57  4$f f+ffI߇Gf( \   5U  4$f( f+ffI߇Gf	 \   5~  4$f	 f+ffI߇Gf5  4$fG5  4$GffJrZ5  4$f5  4$5  4$G5  4$G5  4$G5  4$3
f f _Y[Z^<t.!   f3fRfQf%  ff`fʊfʰafʊff3fYfZfRQfSf%  ff+  ff<u9ff<u+ff<t<uff< uf3f 
f	 f  Cff[YfZfRfQf%  ff!`ffʰaffʰ f tf f3fYfZfRfQf3  fs*f fd f   f3   fs
fJuf f3fYfZfRfQf%  ff0ff3tf f ff3fYfZfRfQf%  ff&ff3f%  fʰ'ff%  ff3fYfZfRfQf%  ffpfʀfʰqfʊff3fYfZR.   ff3t2f2ff3ZR.   fZ VSRQf       	       fǇ0    tw> tr~ tl~ tf~ t`   ֋N^63f  f;s  uf
 4    f u  f u	2   f 
f f fǇ0    fظ   o  3fYZ[^QVSRf3ҷ  f      f      fu  f 8     fu  f   fuB&  f   f             $3   fu   f   f    @ pf	u    f   f um@   Jfu
o  :f
uJ)  f uf S  d  f uTƀtMt$8  2D$t$++ȋt$  '  f uƀt  f u      f  Z[^YVQt$L$	  f u	t$f3 Y^SRQf3F      f u7t      f u"3Ɋ    tff t  YZ[SQfR    3f  t tf;sf          fZY[fSQV3f 5    f uv  ^Yf[fSQ  Ƈ          Yf[fSQV3f 5  (  ^Yf[fSQVR    fS      f3ۈ    3f 5     f[  Z^Yf[fSQVR<    fS       f3ۈ  Ƈ  3f 5     .      f[  Z^Yf[fRfS     ff     f t     f f[fZfRfS     ff t   f t   g  f f[fZRfSf2 f  K   f u.   f nf3
f f f[Zf3f sf f f3f fRfQfrf
   fr
fJuf f3fYfZ RQ3Ҋ    t   f uOf        ;w(     f u  f t  f f YZS  s   f u+    frfrtDtt*<f :f 4f .؀f t#f t؀@f t
f	 tf
 [fSQV3f 5  ;   ^Yf[fSQV3f 5     f u5  f% tf ^Yf[RfSQf2 f {f u.   flf3
f f Yf[ZRf2 f A2f u.   fff3f Z QVR3f 5  ,  3f+HHdf u  c   f t	   f3Z^YQRS3f  .   7   f tZf tf f3[ZYf3Yf f sf3f3Bff rf3 Q."   tf  uf3   f      fr   fsfIuf3fP   m   fX."   tfYfPfSfQ."   tfC   fB   0   f '   fsfIu   ."   tffYf[fXp$
pqfSfp$
pfqf[.    tUf tJ   Y   fs
   3      9   fr
      3'     S'     [S'  #   [Ë%  t     %  t  '  $IFXTPMz       $IFXTPMFidk                                                                                                $IFXTPMBuf                                                                                                                                              f   ff   2fff   ff3.7tZf.;|u.Dtf   f   f30fy   f  f\0fnf30f   f3f30f   f   2"2B     9                               &`"L1^9M|ȵ-M0%V\FWFVՄI/N#~j0
\3GVcz7PAF
͹"MWa
&i,#,γŔ(4İٖD'9m	yι7sM'pUgrDkA[JN

΂5hqYTV?z2oKqYs!Ј]vFwl|g<۲^пIS!A w`J_
s
	_KPP{V+{+~6ooXi(?>ֻ>aPU|G)XbHc!d[bcSy,\ޜ~N
_Y
(V,HgRQк'XS#@K^alf\г EW"YFh&}=tU@	5syz[s~q]To,M[
$+X)f7ꛮm$TȪ~%<?ԐBR4Fvc߬znuNax$iZDxoI:'0"֖߫S-ӭa;ya
"|4'",wK(`sRO8YZD۩|;ȱ84h$]DVJ^:F]^H.jc@> >޿K8f^ u.I(֜SM8rն{~Z/,ATOk@**El_}#	;l}(QS[!8}TeiԔv2ʄ"y,^묆-+oXÄcXAJ<H_|+f"́&DsKƵ+8l~cr+$@m#%LCh.E"s&7}8emg-ϧKv1T}QR5BaiN*W?[3F	߆1,Hb'EBޒ_s6v>i Iċ"#k/SԋOm#,\䎧ܿT0Hͩc,#rд~!Q^GhMm_[` npkm4R{`Y;/ 2NS\
Ub2y,PP"d1-y(Q
ЯJg q=`*q̼F4-|^ŵ_~ExcJ3'tfW8;("x (,Đ<rC֓Ftu0ls,LS5mWg$EكGf%f9l ڀzFM[9p06LMVP4SX>~?%Jcg~qc6XFO4U*a`ɣe /t-zc`|QMe鎝jz#̗~k\&hFq0l%F#l`;TsC lk+O[>T##G 'j/q>8[6ie>::D#.2" K6ɥ馺t6`6IQO"ɆLb]LE}}cPgҝ靼` U"ܖ6Cg#OJ
j\CidyfuB+^zp~&$`!}_+@P0oBCO3'Oh@ONpU5ه y
T)ئqmո.a8DߗF#7!m
0`/[uٓj8ehxy8j
L>GgoO.8g6Ɇ~7GG#2g^	D/W/J	OlKت(x՞s?0I+֧xa}*b>$V{=[u[_6mRn>*YZBn&Z*Oy$$d1rW|/c ,&\>W]~:xjM=я&
/Ը]U"=!9a!Cʄ1Fp.\^7\lUI#ȆN
%â)-)Cdg*cFQ׾F'E7lU\=|8|5embBA$!}!4o|4řb??R
)g`t,t.VثbkHdT`pQ_PT<q%툐H.
7SVsh:nIs?$jL- D^t6.W?d$xHGʏ\պH|lEk#[{68C~U#+7X
]v&e*%[GDmg*	QIf*W>jLNJXSbZi~`5={
.$	tRbN0z_hTw(# T<NXQ[16;6Ƒ{-tr1Bw8.rXX3HK(͉r.J
%ah5$3~Ԅo,-D#zI7[z;3sD^>$έ^si
Ad9dttQQz@0cZ|f-]>И'?|@ٓN=;Dt~y8`mSѬ7}'CޞK0po/8_ߑ]66Sbu:	Z?xqLGO&jM@cNbBjfo[Z*cs$ʻ߆g70N]Ɯ~h	.HyWٞ21<AbZĜqZC(}dq[eTsٹYqލ@nP.BU"z(Qb[ pE0GH	ѿ2Ƭ񃄗Sf	wS:}$AL.M4Ys%ȯH0[׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   T      fp                        c~l݁|TL3cOE1@HJCI'>zηן+H?.
Wynl,,>"D:2)y-zf܉t	=]]%>|QlR(ݖR!kV>
Ky!gx|8<ޱd'C5%LK&t3`(.lHwKCG@Y*\.Ɯ)Efed%*B<fw\lu	`#_i2l Z0)3%>{u?2aC×)R'Y:ʞ!Wˊ?ZȺ0*Нm$Wꯒ@j;S
 pƯ=eUix~;dڋ7 ؟vkndX̠\\Y_8g7tuȦYd(1Iք|+<Z-J+\e25[,57-閔 7xRC1i\L %
8/lLjۇ+sԄjP5,HdsKJs$֑{k(!-w?n=1 Vc	S/TORu.M7ԛ'
ܩm <k@9 G<9N퍥5)4i<u3(A\8 	nW !;aS>~<JVüC#3㛟0נn?Ê*:ES'G3ޚ`Wؾ#Qx9v=QMH][.3t;aN 脓7l,(a4Bb2 VuFW82
֞4?&,Sr A0-pjۼ;AOsN"m[to_ց=h%CKQW6ή+.
cV?H&+u>G(^*"mxuwĠoo)&@R+<{ug	Ҹ3NcRf^Hōփ~Hޤ" ts<MkfXc퇪ws9P'ܛoj3k8XN5w}4{01*߼Q\Y@^	A2/4^AO._c̡;ͨ:ߒZ.[W4C
`N XiK_denЄ9#CL8%|Us6 7[(AV
,0gDx&8<Q&_'W)9ȴ\Gc4>Ȩۀam!KN!M_X=2th(dn9O'|^J»l!"=1܅h=/D	C'^Q<@P|>@@V?;Y-b1ɾ
 \FhAX%46)unҮ/1h87C6ʅ|޾LEgŵk]LV64gz/!=)M?+sqZJSJ],)qȱ!>øYx%ok,-29td] 0
nxnZE+zb5mҫf7Q$-"S,(Y(W@Ϯm[L'TY9>JqUna7UgKeJo83T\cp, Wij(X
<euB2I(N-d,0ժ	_>^3졗pLs-ZBǻBѣljs5KJhxF9"ۚcJ!9[w+KXzݷ=6bΫz{܁׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEc
1FCvx=T-~߯ilΘsމ5:nK%aťxC=E$'=?oxlߒ.*?4z7	Iw8WDC{EpfX`*dU8&b/)<TA<E[zd)G5TKQ._Jq2PH SEcx=N,E|n:C'>@1y4VҸ/\b*IIm ʸh+);vKj=~do{>s,[7<[o!	q3$?ūkW$F޲7x]K2ώ|R]j>%ϖJйVXrxEC<ʆM:#CTUŉ9bw 4f>#){~qŖ62B6	%]7LRކ
@d|
}
Xi>'MJ	1ȫw)0,a@oaޒy	ǉ }eûH}_FrJ?)1^,0)oWEt+n#b#
Mf>t_OGzp3	T8fs2dNGdiP &ҍ82ɢjbˇ7ScnkA'vaOΏMi!"r/|׏#&2̴"ت/Powz0!3{[n8}I	b$BJh!fH"PNŗ${	ÊHG?--kqxå^bS,1e!H5fjdjāk1Gu'Jh>*:M<ۿga|hb-
K`8 D%Iɘ,ɯ[5>   6    #  ZU                        @-w`VM|RJ O9/byOWه#2KجPꆜU˝_2:HB["0#huM4˝'<Ÿ[_Ŷ[IA1|[dKF.Ɠ<jp>`3iFݟ
a+mQ fF;"	 Sҝ iu*A [`Z\]4 \]8
M̒_]+ۊod
U	g|J#	jMè|(B楌ͼ]CMz˂u3Z&daQs;[F,D~s;DZ6ݩl#Fw]@I=.ُ7	(9RżҷĜ qg(	P*1"8Yr-mfjt։:ZjͲ6xͨS!kJ`~
P+;|N 6_qRnq	>!ctydBggٖ\U6)
ۙ!	s9|ct{ 8_nm]vJgfBdᇙMÕ,ԯչ)Z!&"<iJ4B"dUfBSjDl'	ܚ= ;AJU"# P5J&W}zQB4JһN1'ĉ$\O4Ru<y
2Cƕ.}k82NBG?kTHJR#ϗi+2EEչba^!(ySns
lIЇ2̟&4؊EEwzg@DȻ3{xR2e$$Gxbp.IW=)0L5uatWx@ϻQ
@Rx@Pl&ݩd|];λ;i(cs?Z2놫mJ;})Ӹ_캸LC'~e0}ހ._'dߧ4s*C`O6҈T
UP;`j0Z)=#Xr2
OWH
ty"!RE%T#4m?̗57`|6	
zO`_P|mi!h9hZv᯸; &Dtwt,:%9>-VG%.Ro7[>[''<Bw<zi_>.$xD7{וs 8-慪 {U*\.hCc6+32ѹ	qL>ρ.ů,CpTÃ7iG׮q7Ժ_
φ6׭(>Ӌ:itӨÓwPz
(qMaHiEb拉]+E_f34=do:Fckb\A
?&XO,}'9lŹI؉Cpf﹈LSJ6l0N]+9k+d=>!S<o786Texa
C^wiږAvcov~Bq兦(RR*""J(b}ڬ4+>":Cf=,fݬ:NRK~";+50%`W~Q \(z=يE+
o	XuM驤Taфяjcw+wW)K&HD2>e7RՀ0yAf9w@,[2
V>-3p^3e
e\ˉR.Ռ-\n2iK"C;&|8hI$ZTK6Ҝĕe`=29H 30j;/:LoF8,.>~iue$Cft<~wԀR3$rN]a1oXҵD_ɤojяOu	d;S2`/|Swa	Fi6_4$Mp'B}3Tɉ5UL,0VJyvMΖ@GXT7UzF؋hKAWl.'!kkdt
m2\1h\)
<^V6D";m*]}ъpqz~n}*~[.	iwJ`<%O;m[m]SH<pצH/%ӐEL НHD"CPn o)4҆A#SWRK*H^0
x寑|i.4EDE޲0r-'_Q1c&h&Zw rDQL}xuv/KN@i(a6#ǢR/
-)ƵpnwcC{w҉ZOm_FQ?Ɇ
嚠93HmRf \'sAϊ;ХӋYzǞb0Bk+-!@^o7Mڞ۹O0`/~Y%ie7{wNM`Rgd'<ާ%pbR9qg+
	!L
j@ՋZ%raAR}rL,37Ydkj\"%"hX#-FQj =m
+v&Lq pْks]j}'l;	>q֚Mѹeޔ7"s',LI_{+N٣ÚIGӓ	Tvt+FHv(js ΆkV^`7?1GǻϗEIc5]	ǲ5oDM拆}
uҋQ7*cz`n?Ĝs{ou*!Pݕc~XT3a֒53n 1q#Dd7\](".m>PFn&UԜlJP/aCZc׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   H      }                        #=Byf[WsgqF oy|.'E6=3zToh@ǿyc'խBKSCT<ң]坆峮|	n+UnujrY$>ii[bcamuP35&Rʟt;)+E*%}0!`2Qn_RK~RoE@ɟuXV@|ɞRMߑkFƺ9uK@ay5q]{D 
+W;1Ucʹ8Hza4	L*♀6qTy}9ASƶƒO*BJH
݊c)<LƙCmR5lsErrmYڠW3ϑ/FH{yj&'4ɴl1ܿ3ڼg8BjNƒbȏVK
2M73@q=BC
ނsc2H7\>'So7ۢtv
uCapQ {qżs^jJ8ꧾ3#o1rf&ɱ2ȧ/QEʼq!
K,s<ɂ@eʱ۔Qd.}U
i( 
ٜ9frFˑTFm"򦉝z17ԇ%IJ}Тd'5JP˭$;?.Vσn/<%$Y-@.DUCRIMDwG	UR eE;Q(M^;|aRΘ8.^H4 tJc48w<$jk2M.g|5z߂JaAbS.˶G]ZzȜxH4q;!xND35p@Hnj;g4Ȭ0ϺYOeYɚ\i@d4
NV'H4W77s^:R	KaWyƀ]MC@E~b}>j?cԓTa5ovJ/G{?̡0&{er:_1ove3˃wh8 fˡO@Ζn6B&]Uy]hUV*ML缟JP<<DD蕋Z
=*)!Nh8&6FD# ml2p?OP=.66'Mp~*3k+:R%zF5\	f6=?x1VYvv~a}a,HQmRݜzNo.^A4Wd22:>qUK+PK?~$4WSTtD|"2D!/2n>p\5)mpTgrK<D}-i'"g/,wpr9{HW9М :t K*Tv$2lOwy{]% n"C9M(c *3CI6@c?/f*bK@
?[kM8t˓:w<%{"pA#J91FLMv')\xm;{aPPVnMA2ARl;4!ZɽX-K6%FV/;&͌yӃ%12u?hK͇Dn*"I0BeM7f	ߣ4Sm"o o=ేFȲ1w0{+*K;Wk6ƣ(IۀAl2Upa{E6,.\JiզBu%y
g38Ya5&R&md.y"gnM |x@w /J˦F0lҥo&z5iQ0&#N4^A6a;Qu%/RuWeG+WgVR+F`Z]s8x V[-T>H_
O};w]kwȒobm 2M\:p
x{xdCG:L_ ;KmojŘ:fd<.*e %@b1یyq骾Ǔ@W(C!ΪZDkb3LQ2 grG&^Z"E((XW*s5:MC[˪[G|5lױ/?`2V25V!F3*,$~M#r\,C3`W!.|VC2^J
><Xpnm܌x4#jftXzn6;A:cóݺcU 'tZnK#wp<3ȗINN؁syoSuQQS\GKxAClcb!?#{%WB:F-HlܐPGt} 8{)7F79y|c{I^You8WKނ97og, buJ&vza;p

t良/^e5N2f<ߤa'F=$բWp
]&uUސ99
\0I9<ѳNГn):}z

k<to]'A})L*~_x7BiVsQTW|z};3!lR[1[NKIKʐɰ]Sm2l[Hqp-jGɺ`d5IZjYUŸf#o ݸR`&6pжF-@K)	 "/`FTd	1a-9MǅZoxGQʍG!#P+|RJG1dUӋr֭EmE
TQlL	J0ۿdB۞PZsv]JF)׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H       fffsf fsf f
   fffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsffffsf fsf f
   ffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf f  tf3f)U  fsf 9r!f   tf   fLU  fsf f~fsf fsfff%   ff  g.02fU  fsf vrgfU  fsf  rRfU  fsf 8r=fU  fsf gr(fU  fsf rfU  fsf f fsff@Cg&;f(V  fsf f;V  fsf f   u
tsf fsffoV  fsf Rf@Cg&;fV  fsf zf   tt"ssŀ2ɀ@v8sfV  fsf  f@Cg&;f fsfs退@s,fW  fsf  f@Cg&;f fsfrBfQW  fsf pfdW  fsf  f   uf   t
f fsfr'@s+fW  fsf f@Cg&;f fsf$fAg&$;g&$;fBf u
g&'g&'g&f fsffffsf fsf f$Agf&;@gf&$;f3f tf@f   ufAg&fffffsf fsf f   gf&gf&   f~fsfBgf&f uff~fsf fsf猸N匋 f
   "猸N匋f   fY  fsf f   uf  g&t猸N匋f>Y  fsf 猸N匋fgY  fsf 猸N匋fY  fsf 猸N匋fY  fsf fY  fsf 猸N匋fY  fsf A	o猸N匋fZ  fsf o	F猸	N匋f@Z  fsf 	猸N匋fiZ  fsf U猸N匋fZ  fsf 猸N匋fZ  fsf *猸N匋fZ  fsf y猸N匋f
[  fsf P猸N匋f3f9[  fsf $猸N匋fb[  fsf f|[  fsf C
f: f	"f   f[  fsf f   uf  g&tfffsf fsf f   f   f \  fsf f~fsf\  fsf 
A猸N匋f4Lf  gf&f Lgf&fff,  g.fLg&g&'g&f\  fsf (1猸N匋f\  fsf 
猸N匋f\  fsf 	猸 N匋f\  fsf _i猸!N匋f]  fsf 猸"N匋f?]  fsf 猸#N匋fa]  fsf 猸$N匋f]  fsf u猸%N匋f]  fsf !猸&N匋f]  fsf "猸'N匋f]  fsf G猸(N匋f^  fsf  猸)N匋f-^  fsf &猸0N匋f   ufX^  fsf "猸1N匋fz^  fsf !猸2N匋f^  fsf &猸3N匋Ћ猸4N匋f^  fsf &猸5N匋f^  fsf 猸6N匋f_  fsf &猸7N匋f3_  fsf "'猸N匋 f%"f   t
fC1'1焋儺N匋f  f_  fsf tv$f  f_  fsf f  f_  fsf f  f_  fsf tf  f    ff   ff  fIuf  f(`  fsf 4f fsff   f  ff   fb`  fsf tff   f`  fsf Gf   tff̀   f Ag&u\f`  fsf %r8u=f`  fsf %u$f3f   u
ffuf  tf fsffLg&   f  tfOg& t'f   tfOg& tfOg& f  f{a  fsf $f  fa  fsf f  fa  fsf f  fa  fsf f  f    ff   ff  fIu fLg&  f fsff   fuff/b  fsf $t,fMb  fsf g$8uf   uffuf fsfff   ftfb  fsf $$tf@ff  uf fsfff   ftIfb  fsf #$<t,<t2fc  fsf #uf	ff	ff  uf fsfff   ft+
fVc  fsf ^#<t<tf
ff
ff  uf fsf8f   ftfc  fsf 
#t"ff  uf  tuf fsffffsf fsf ff @  f   fd  fsf h$t5<w&t<u ff @  ff    ff f:  f~fsfffsf fsf ff   f fd  fsf "2ff fff+ff4  g.fd  fsf !<  ff `  ffg.:w%g.Ffe  fsf !<  g.:Gv;fffcff `  f    f;thff `  ffff  "ffftfu	f   	f    fe  fsf 'f~fsf fsff3f@  ff `  f
fg.ff   2ff   f   ft6ff  fsf  < tff8fsftff  uffff fsff3f@  ff `  f
fg.ff   2ff   ft,ff  fsf  < t8sfwff  uff ff fsff3f@  ff `  f
fg.ff   2ff   ft,f3g  fsf < t8sfwff  uffff fsff   f    ft*fg  fsf $t<s
f   <tff  ufff fsff   ftfg  fsf uff  uf fsffffsf fsf f3f@  ff `  f
fg.ff   2ff   ft,$fwh  fsf =< t8sfw$ff  uf~fsffff fsffffsf fsf f3f@  ff `  f
fg.ff3f3f3f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t3f   t@ tfҌ  g.;sf3tff  T2fffff  f~fsff fsf3f   fu5f	ftfftf
fC  2ffg.<u f  t2kf  uff  uflj  fsf ,uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsffffsf fsf f   f    f   f%k  fsf f    f    3f   ftfYk  fsf fftfvk  fsf fftfk  fsf fftfk  fsf 8uf Bgf&'gf&f   4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   f~fsf fsffffsf fsf fLf   f3f3ftx2fsl  fsf At	ffffl  fsf <	rLаfl  fsf <
r1$,
	
2g&	ff  rf~fsff fsff   fm  fsf d稀uxf   f   f   tf    f   f    f   f   f  uf3f   uf   f   uf3 f   u|f   tf   f   f   tf   uVf   f   Hf   f   f  uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsffffsf fsf fLf3g&f   fu	ffffˌ  fg.f	ftf	f~fsf fsffffsf fsf fffsf fsf f3fLg&'sf   f   fo  fsf f%   f	ff Lgf&ffft
ft f Lgf&ff%ff  ff% `  f
ffff; ffgf&f L fffsf fsf f  fo  fsf $f  fo  fsf nf~fsfgf&fff   gf&f   gf&'jf~fsf~fsf fsffffsf fsf f Lgf&fff Lgf&fpfff  ftf  fthfp  fsf {f Lgf&fff{  tff  t+f Lgf&fpfffq  fsf f~fsf fsff|Cg&'g&fCg&'g&f`Cg&'g&flCg&' fCg&' fq  fsf fq  fsf fq  fsf 4f fsffBgf&f   fq  fsf < u	f   u}fr  fsf Zf@Cg&fCg&fBg&$g&_
ó{fAg&G$fAg&_
ócx 5f@Cg& 3fCg& 1fB$g&'g&g&gg&_ fA$g&gg&GfAg&gg&_f$Agf&@fAgf&@f$Agf&'fAgf&'fKgf&f fsffBg&'g& ff% `  f
fc  ffgf.gf.Vf Cf   gf&gf&Ggf&   gf&   ff fsff(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsff30t
0t}f  ffg.fDg&1f
  ffffg.fDg&g.FfDg&f3f{  0t	fffffffsf fsf ffDf   g.g&ff0   fDf   g.g&ff0   f  f~fsff Ef   gf.f@   ffffsf fsf f  ffffsf fsf f   gf.f~fsf~fsf0   ff@tf Efǀ   f{  f   gf.f Dgf&f%f
  gf&f Dgf&   f fsffff8Af   gf.ffAf   gf.f fsffffBf   gf.f fsff   fAg&' fAg&' ft#fffftf  ug&Pg&ff   tfAf  uf fsff@@gf&f0Bgf&f fsffffsf fsf f Agf&gf&'fAgf&gf&'f   tf Agf&   fhw  fsf 
f{w  fsf fw  fsf ff%   ffftfftfffff~fsfffsf fsf ff%   fffffff ffffffAgf&'gf&	fAgf&'gf&	f   ff% `  f= @  ufCfffAgf&'gf&	fAgf&'gf&	fAgf&'gf&  t fAgf&'gf&  t f3f Lg&$<ufff% `  f= @  ufff%   ffg.ڌ  fAgf&'g&	fAgf&'g&	f~fsfffsf fsf f3fff fff8ffff   fff  f
fff   fff `  f @  rf   fAgf&' gf&	fAgf&' gf&	ff% `  2f=    r\tfffsf fsf fLg&%f   ؃ ttKu
fuff~fsffAgf&'?gf&	fAgf&'?gf&	fAgf&'fAgf&'fAgf&f%   f
ff `  f
f  f tfw  ftf,  ff3 f+ff3ff%  ff `  ff  fgf.ffAgf&'   gf&	fAgf&'   gf&	f~fsf fsff$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsffffsf fsf fdAgf&   fAgf&   fLf3g&f   fp~  f~  fffsf fsf f fffˌ  fg.f   uf   t	f   ugf.zg&'gf.:g&'ff	ftf	gf.:g&'ff~fsfffsf fsf ffffό  fg.f	fu$f	gf.>g&ff~fsfffsf fsf if    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsffffsf fsf fff  f~fsfAff%  f   g&t3fAg&f   tf   f~  fsf LՋf   f+~  fsf V֨t	 v  v f   fZ~  fsf f~fsf fsf AAAAAAAAA	AAAfBgf&f%?f
 
  gf&fBgf&gf&gf&Pgf&fBf  ugf&   	gf&   f   ugf&   @	gf&   f  tf$Agf&   f   tfAgf&   f fsffBgf&@@  gf&   ff%f=  tfhAg&gfAg&gfK  ff%   fffhAgf.gf&'  gf&	fAgf&'  gf&	fgf.flAgf&'gf&	fAgf&'gf&	f fsffAg&' gf&0fAg&' g&0f$Agf&   fAgf&   fD@gf& f fsffBgf&'?gf&  fBg&@f Bgf&'gf&  ! f$Bgf&'gf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsff3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f    fŀ   uf   f   tf   fgf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f uf=   u fffsf fsf ff   ffAff~fs@f   tfffsf fsf f   t
 
 fgf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfgf&f~fsf Bgf&'gf&   f   f   tf 8  ffgf&f Bgf&'gf&   fgf&f}ifAf  fffgf.~gf.6g&? tg&g&&fAuf   t2f   uf8tf   tfff fsf AAAAAAAAf Bf   tgf&'gf&   fӄ  fsf 1f@@gf&'f0Bgf&'f8Bgf&'gf& f fsffAf   tg&f   tg&fAf   tg&f   tg&f fsff   uf   f   f Agf&'gf&	fAgf&'gf&	f fsff Bgf&   f fsff Dgf&'f fsffBgf&   fDgf&f Dgf&   f   f(  fsf Y<twf Bg&$uf Dgf&`f fsff  fn  fsf $f  f  fsf f fsf fŀ   u<f fsffffsf fsf  fff.0ffH $ttf~fsf fsf䐕 	
P`=P0E       I   &&&&&&&&""""""""333333333333333333333333DDDDDDDDDDDDDDDDDDDD        """""                                  DD D DDDDD D D DDDDD D DDD D DDDDD D D DDDDD D DDDDDDD D  DDDDDD D  D DDDDDDDD D  DDDDDD D  D DD3333 3333 3333 3333 3333DDDD DDDD DDDD DDDD DDDD    " " " " "                                                                		


 "$&(*-049		



!#&)-159?


!#%')(*,.02 !"#$%&'()+-/13579;=  	

	

 	
	



"%(+/258;>>>>>>		


"%(+/258;>>>>>>		


 "$&(*-049		



!#&)-159?                                                                                                    @                               "3D  , 0  @  P   P Q  P U  P      P    P       P    P       Pfffsf fsf f Lgf&ffff% `  f
f;|ff% `  ff% `  fff~fsf fsffffsf fsf 
f  f  fsf w3f   f   fsf $< t<tM<t! <sfNgf&f   t&f   fN  fsf 3$p2<u f   ft  fsf 
Ɗ< ufLg&'fNgf&f   uc   ff% `  f= @   f=    tf Lgf&f#f Lgf&ffufLg&'fu_f   f  fsf f
   fffsf fsf ff   fR  fsf Qf~fsf  ft  fsf %f  f  fsf Yó fNgf&f   t@&f   fď  fsf $p2<uf  f  fsf $
f  f  fsf Uf  f   fsf aĳ

f  f=  fsf Àf  fY  fsf Àf  fu  fsf f~fsf fsfnnfLg&nIw	. hῺ! jǐ {Ԑ f3n          D  @    L      @       H   H       `       T  
$   	L 	L  	L  	L!	> @
$  	>         		       
H@,@      ā    Ё    (            $    (    4    8           @      
B  
B 
B0 T     T    T0 !   L     L    L0    D    P   X     `  D    X      P    h     `               	 J             
  @      I         	  	4@	04
    	' 
 
> 
H> 
> 
N> 4    	1 	 4	$	  	  	  	  	 
D1d 
B1e 
@1P 
# 	P 	          @  4 $       	4		 		0   4      @ 	
. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /  . a /   . p /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L  	 j        0      4                                                        d  ` h   X  '      @@       A   \   \   Z 	  X 	     ? \   Z 	  X 	     ? \   Z 	  X 	     ?                                        '     >   !    8      ,B      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N    T           0           <fjHf%f  $f$
tppqtwffupppppq˙fיfupppppqf  f  gffLggf^gfngnff   f*fupppppq ؎gf
  fJf`Rfupppppqg-  f)ffff  @$f@$
= u$<T)fٚff  @$f@$
и f  D$fD$
аf f% = uf<vf fQaf %  fmEfU../0./.	/`./a. /0./. B쨀u?ff d< ufܛfd< t<t
u掰ff䎊fff(f掺<ufLffV2>  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ怺Nf gf&   ufT  g&'g& ^@'f3
f  i t
^
ppq<&uf  $f$
tpqq$q
p&q+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  $f$
а f  $f$
и f  $f$
аf  $f$
аf  $f$
и=f  ff| ff  @$f@$
= uQf  ff ff4g&`g&&g&f  H$fH$
и f  L$fL$
а08fffUN&N䄰`O'N䄰ON8tf  ff9 ff  ffL f N U
BJ<Zt. U
BJ<Z B0JBJU0
BJ<Z0BTJ1BJ2BJ3BJ4BJ5BJ7BJ B$JB$J&B J'B JB$JBJ(B J$BJLN33LN3N BJ<uj"BJ&BJ)BJBJ`BJaB8J0BJ)BJt8B B tf  ff    f8ffff   9f gf&   u(f  8對 f    < tgfSf  g&  u
gf&>uf[68YHV   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    焋猰怺N匋 so1 f    QsY 焋猰怺N匋f]  ffP  f   tf ff]  rfBY 焋猰怺N匋Yf3gC[f3f   焋猰怺N匋[fHrHf f焋猰怺N匋儰f焋猰怺N匋rfFf   f   r% 焋猰怺N匋(s 撰焋猰怺N匋3c.H&f  f   f焋猰怺N匋fSj(f[f   f   3f   f  焋猰怺N匋g&7(fFfCg焋猰怺N匋o&fPfSfQf   fQf3یff]  fYsfYf[fXSgu]  ;u[fPfSfQfRfWf   f3یff]  	 pfBf   [f3g}]    fg]  r%fG;wg}]  f_fZfYf[fX                                   	            !      Pp     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  )C vZ[XPSR Z-Z[XPSR  )C v
 K-Z[XfPf   .>&u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
+ɈD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4* (f`  fg&Ft+vugf&>tgf&6f٢*ɰ &f+~f^Y[fXPSRfV tA % +g&ƅ    f{  1\g&  	uf^Z[XPSRfV tA % +g&ƅ    f{  1g&  	uf^Z[XPSR   +  *Z[XSR  :'C vZ[PSRRZZ[XÃ<t  *  *  *PRt)t<ZXfPfSQfRV%&  &f3۹ f   gfdT gfdTgfdTgfdTf   &"UC v 4*  8 c&qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  %fA vY[fXf` f;."t
f."! b%  >%$C vf3 
 f    fgf&E   >! uF! f[  gf;tgf+gfkf0f0  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f{  1 < ? f  9g&"  @v@ g&  s ?f  9>* u&g&.  ug&.  ug&/  uD
f^Z[XÃ t                          / 0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    l    焋猰怺N匋儽(焋猰怺N匋儽İffff[ðff9ffR f%"f#f-)3İf?sfIfU]f a]İfmEfwðf/f f
   `"	f   f3f30f  0ffxf   f f    0f  f f   0fffP  0f  f   f    0f  f f   0	 f%"f<vff.lf.` f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.rf.ff  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
              p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`>, tVg&4  g&;  ĀuH g&  vYɐ, f[  IG >f0  A(ɸfaPSQV܋L	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 -f6YɻQjs>-t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&.
gF
&.ɻQsw>-taf`fP  gF
$&0
gF
&0ɻQs@f  g&|5  t>-tVfarfWr<f_    f`f)ߴf   g&D= (fgf&T=fg&D=rL6&& G &r6QfPf   f>)߹ gf&D5 gf&fff>)fXYsufa`f  &.ɹ gF
$
gF
f  QsF>-tma        PȎfD   H>_ tQtus>a Q O \  >Orf\gR  R ( r\  0\NZ>\Q\fSfD@>\7\fSfJfJrfJfDf>D wfD   >\\fSfJ%fJWAfJfDf>D trWf>D wfD   >\\SF>\\S,'q>\h\Sff   fJ>\A\SU0>\'\SU>\
\SfUf \N >\ \fSfJ'fJW6r$fJfDf>D tWrf>D wѰNfD    \O F >\uu\Sg>\u`\ScR\ D>\u=\SP/>\u(\fS 
N\-  \>\	r\  H
s 撰at XÏNhhv|fSgef[gefPfR>Qu
_.fZfXfSfR_$$8u4@fZf[P$4XfPfSfRf@@
 >Q u= 4_tsfZf[fXË_.usfZf[fXPRa tċaZXfSfRf@@
 >Q uA :H@tBs*_؃,-@u's_.fZf[Ra쨜u	u
saZ                             "                               @  
     @  
 Uf`ircgf&=  f  gf&f  fffFffFff^fF   f  fì  f^fF   faUf`f  / gf&Fp  gf&F    gf&F`  fgf&~f  gf.>f  fffFffFff~fF   f   fǠ  f~fF   fVf   f  fVf  0 f    gf&f^f   f  f    lff  0 f   gf&f^f   fǸ  f~fF"   fF   3f~gf ulfVfOLPHsf  . ff  ! f  ! f   f  ff4 0  gf&f^f   fǸ  f~fF"   fF    f  g&]
  t
ucgf&  f% f   uLf   f  f~fF   fF   g f   f  f~fF   fF   A faú`U` B<u(``B`apB`0B`f` f"(  ؎Њf      f%" 3؎faUf`f   f"  ؎ff3Ҍffh fC  fPg6D* gf6|*fg6l* f%" 3؎ffa            `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva3b f
   `"	f3f3f   0 f%"	@ ttu! 0
 Ds3ig&+g&ô b uR Zts+R Z<u+R Z<u<uR  ZfSf. g;xxf[ú          Tf  ?   f1  +   fE     fY  W  f   fHt	f쨎tf<w' H$tt
ffPf fЀfXfPRf 0ZfXfPg& g&gf&{gf&CXg&Cg&CXg&Cg&Cg&#sPR$ZXPR$ZXPR|$ZXPRnZXgfgfgfgf&Ggf  f  gf{Tg&s g&C   PHR            f`ffWgfǃ  #Eggfǃ  gfǃ  ܺgfǃ  vT2gfǃ  gf  gƃ   g  u	f@w4  f@f@f_gf   gffgffaf`fQgf;gdg&fGfXf7   f;wf+f@   f+f7g  f3ggf  fffgffgf&faf@   g  tf@gf3g  gf   f` gffgf@ ffgffgf3fgf3fgf3fgf@rfaf`gf  gf  f   gf3fSgf  gf  gf  wff#ff#ffyZ?'wf3f3fn,;wfPf#f#ffXf#ffܼf3f3fbf[gf  fgf   gf  fffPgf  gf  gf  gf  gf  fgf  gf  gf  fXgf  AP
gf  gf   gfgf&ffa  fPfSfQfR3Yf  @]f  $f$
f  ܺ$f$
ЋfZfYf[fXfPfRfS3f @ Uf  $f$
؃f  ܺ$f$
Ћf[fZfXfSfW3f3f  Bg&cg&C
uf_f[ztP.>Hu.H  t.H .6HXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X               .KV.M^ð@ ð  fSfQfWf36>ct	f  se>Ptf  rf  sJg&C g&Cf  @@tf  G f   f  G 	f  W g&s g&C f_fYf[fSfQf3>ct	f  sK>Ptf  rf  s0g&C g&Cf  @qf  g@<tbg&s g&C fYf[fSfQf3.>ct	f  sk>Ptf  rf  sPff?g&Lg&D<?u9g&C g&Cg&Kf  @fg@?fg&s g&C fYf[Q f  / fp  fPQgf0f  f    n YfXf    fPSfRff  ! gf&V2gf&;Ftg&~ u
u
gf&vfgf&NfZ[fXgf~gfNgfVgf!fPfSfQfWK<w#f.
tf:f_fYf[fX焋猰怺N匋fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fXfQfWfVf @  f   f  gff^f_fYfQfWfVf   f    f  gff^f_fY                           0 k PS㋇[XPSQRW0  3  3  3  3_ZY[XPSȎػ       !    A    a   f   /       w  l[XR # 1 ZSQW   '_Y[SQW   _Y[SQW   _Y[SQW   _Y[         PUN
NNOపNzXfPR3t3$UNN<Uu#NNO<u N҉_ZfXfPQRU0
BJ<ZuW0
BJ<Zu$BJ<u !N BJ<t3 `BJaBJt$w u-@u&UNN<Uu$NNO<u Nu3҉at;B B at	 ZYfXPRt ZX               焋猰怺N匋3ظ  м{ f
騦ff镦fBf0邦f                                           Q  YPSR+;wZ[Xf>@ tf@tf`f  
tf  f    f3f3f3f @ gfffCgftftfaf@   {f@uQYfVfSfQf]  f   fJSrfJfYf[f^          fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     2ø     5  @     07/27/06YVHq  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        