<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions">

<!-- GUI Constants -->				
	<!-- Power supply status comparison constants -->
	<xsl:variable name="PS_FULL" select="'PS_FULL'" />
	<xsl:variable name="PS_UNKNOWN" select="'PS_UNKNOWN'" />
	<xsl:variable name="PS_CONSERVE" select="'PS_CONSERVE'" />
	<xsl:variable name="PS_LOW" select="'PS_LOW'" />
	<xsl:variable name="PS_SLEEP" select="'PS_SLEEP'" />

    <!-- Powered constants -->
    <xsl:variable name="POWER_ON" select="'POWER_ON'" />
    <xsl:variable name="POWER_OFF" select="'POWER_OFF'" />
    <xsl:variable name="POWER_STAGED_OFF" select="'POWER_STAGED_OFF'" />
    <xsl:variable name="POWER_SLEEP" select="'POWER_SLEEP'" />
    <xsl:variable name="POWER_OFF_IMMEDIATE" select="'POWER_OFF_IMMEDIATE'" />
    <xsl:variable name="POWER_REBOOT_IMMEDIATE" select="'POWER_REBOOT_IMMEDIATE'" />
    <xsl:variable name="POWER_REBOOT" select="'POWER_REBOOT'" />
    
    <!-- Powered management constants -->
    <xsl:variable name="PM_PRESENT" select="'PM_PRESENT'" />
    <xsl:variable name="PM_ABSENT" select="'PM_ABSENT'" />
  
	<!-- Presence comparison constants -->
	<xsl:variable name="ABSENT" select="'ABSENT'" />
	<xsl:variable name="PRESENT" select="'PRESENT'" />
	<xsl:variable name="SUBSUMED" select="'SUBSUMED'" />
	
	<!-- Status comparison constants -->
	<xsl:variable name="STATUS_OK" select="'STATUS_NORMAL'" />
	<xsl:variable name="STATUS_DEGRADED" select="'STATUS_DEGRADED'" />
	<xsl:variable name="STATUS_FAILED" select="'STATUS_FAILED'" />
	<xsl:variable name="STATUS_TESTING" select="'STATUS_TESTING'" />
	<xsl:variable name="STATUS_UNKNOWN" select="'STATUS_UNKNOWN'" />
    <xsl:variable name="STATUS_DISABLED" select="'STATUS_DISABLED'" />
	
	<xsl:variable name="FAULT_OK" select="'FAULT_OK'" />
	<xsl:variable name="FAULT_UNKNOWN" select="'FAULT_UNKNOWN'" />
	<xsl:variable name="FAULT_CPU" select="'FAULT_CPU'" />
	<xsl:variable name="FAULT_PPM" select="'FAULT_PPM'" />
	
	<xsl:variable name="THERMAL_OK" select="'THERMAL_OK'" />
	<xsl:variable name="THERMAL_UNKNOWN" select="'THERMAL_UNKNOWN'" />
	<xsl:variable name="THERMAL_WARM" select="'THERMAL_WARM'" />
	<xsl:variable name="THERMAL_CAUTION" select="'THERMAL_CAUTION'" />
	<xsl:variable name="THERMAL_CRITICAL" select="'THERMAL_CRITICAL'" />
	
	<!-- UID status comparison constants -->
	<xsl:variable name="UID_ON" select="'UID_ON'" />
	<xsl:variable name="UID_OFF" select="'UID_OFF'" />
    <xsl:variable name="UID_BLINK" select="'UID_BLINK'" />

    <!-- UID Image locations -->
    <xsl:variable name="UID_ON_IMAGE" select="'/mxportal/bladeime/skin/images/uid_blue_on.gif'" />
    <xsl:variable name="UID_OFF_IMAGE" select="'/mxportal/bladeime/skin/images/uid_blue_off.gif'" />
    <xsl:variable name="UID_BLINK_IMAGE" select="'/mxportal/bladeime/skin/images/uid_blink.gif'" />

    <!-- Blade background image locations -->
	<xsl:variable name="BLADE_ABSENT_IMAGE" select='"server_absent.gif"'></xsl:variable>
	<xsl:variable name="SWITCH_ABSENT_IMAGE" select='"switch_absent.gif"'></xsl:variable>
	
	<!-- Interconnect bay background image locations -->
    <!-- TODO: Remove reference to overlord in images -->
	<xsl:variable name="IB_ABSENT_IMAGE" select="concat($C_SWITCH_PATH,'switch_blank.gif')"/>
	<xsl:variable name="C_SWITCH_PATH" select='"/mxportal/bladeime/skin/images/c-class/rearview/switch/"'></xsl:variable>
	
	<!-- Status image locations -->
	<xsl:variable name="STATUS_OK_IMAGE" select='"/mxportal/bladeime/skin/images/icon_status_normal.gif"' />
	<xsl:variable name="STATUS_DEGRADED_IMAGE" select='"/mxportal/bladeime/skin/images/icon_status_minor.gif"' />
	<xsl:variable name="STATUS_FAILED_IMAGE" select='"/mxportal/bladeime/skin/images/icon_status_critical.gif"' />
	<xsl:variable name="STATUS_UNKNOWN_IMAGE" select='"/mxportal/bladeime/skin/images/icon_status_unknown.gif"' />
	<!-- TODO: Get status image for TESTING code -->
	<xsl:variable name="STATUS_TESTING_IMAGE" select='"/mxportal/bladeime/skin/images/icon_status_normal.gif"' />
    <xsl:variable name="STATUS_DISABLED_IMAGE" select='"/mxportal/bladeime/skin/images/icon_status_disabled.gif"' />
	
	<!-- UID image locations -->
	<xsl:variable name="UID_IMAGE_ON" select='"/mxportal/bladeime/skin/images/small_uid_on.gif"' />
	<xsl:variable name="UID_IMAGE_OFF" select='"/mxportal/bladeime/skin/images/small_uid_off.gif"' />
	<xsl:variable name="UID_IMAGE_TOGGLE" select='"/mxportal/bladeime/skin/images/small_uid_toggle.gif"' />
	
	<!-- Fan image locations -->
    <!-- TODO: Remove reference to overlord in images -->
	<xsl:variable name="FAN_PRESENT_TOP_IMAGE" select=" concat($FAN,'enclosure_fan_top.gif')"/>
	<xsl:variable name="FAN_PRESENT_BOT_IMAGE" select=" concat($FAN,'enclosure_fan_bot.gif')"/>
	<xsl:variable name="FAN_ABSENT_IMAGE" select=" concat($FAN,'overlord_fan_absent.gif')"/>
    <xsl:variable name="FAN" select="'/mxportal/bladeime/skin/images/c-class/rearview/fan/'"/>	
	
	<!-- E-Class images path -->
	<xsl:variable name="ECLASS_REAR_PATH" select=" '/mxportal/bladeime/skin/images/e-class/rearview/'"/>
	
	
	<!-- Enclosure manager image locations -->
	<xsl:variable name="EM_PRESENT_IMAGE" select=" concat($EM_PATH,'oa.gif')"/>
	<xsl:variable name="EM_ABSENT_IMAGE" select=" concat($EM_PATH,'oa_absent.gif')"/>
	<xsl:variable name="EM_PATH" select='"/mxportal/bladeime/skin/images/c-class/rearview/oa/"' />
	<xsl:variable name="EM_LINKNICS_IMAGE" select='"/mxportal/bladeime/skin/images/c-class/rearview/nic/link_nics.gif"' />
	
	<!-- Rear of power supplies background image -->
	<xsl:variable name="PS_REAR_IMAGE" select='"/mxportal/bladeime/skin/images/c-class/rearview/power/rear_ps.gif"' />

   <!-- Types Of Hardware -->
   <xsl:variable name="P_CLASS" select='"p-Class"' />
   <xsl:variable name="C_CLASS" select='"c-Class"' />
   <xsl:variable name="E_CLASS" select='"e-Class"' />
   
   <!-- Path Names of images -->
   <xsl:variable name="E_SERVER_FRNT" select='"/mxportal/bladeime/skin/images/e-class/frontview/server/"' />
   <xsl:variable name="E_REAR" select='"/mxportal/bladeime/skin/images/e-class/rearview/"' />
   <xsl:variable name="C_SERVER_FRNT" select='"/mxportal/bladeime/skin/images/c-class/frontview/server/"' />
   <xsl:variable name="C_PU_FRNT" select='"/mxportal/bladeime/skin/images/c-class/frontview/power/"' />
   <xsl:variable name="P_PU_FRNT" select='"/mxportal/bladeime/skin/images/p-class/frontview/power/"' />
   <xsl:variable name="P_PU_REAR" select='"/mxportal/bladeime/skin/images/p-class/rearview/power/"' />
   <xsl:variable name="P_SRV_REAR" select='"/mxportal/bladeime/skin/images/p-class/rearview/server/"' />
   <xsl:variable name="P_SWTCH_FRNT" select='"/mxportal/bladeime/skin/images/p-class/frontview/switch/"' />
   <xsl:variable name="STATUS_PATH" select="'/mxportal/bladeime/skin/images/status/'"/>
   <xsl:variable name="E_REAR_IMAGE" select="concat($E_REAR,'rear.gif')"/>
   
  	<!-- Power supply background image locations -->
	<xsl:variable name="PS_PRESENT_IMAGE" select="concat($C_PU_FRNT,'ps.gif')"></xsl:variable>
	<xsl:variable name="PS_ABSENT_IMAGE" select="concat($C_PU_FRNT,'ps_absent.gif')"></xsl:variable>
    
   <!-- Rear View Ecnlsure back plane image location -->
   <xsl:variable name="SRVENCL_BKPLANE" select="'/mxportal/bladeime/skin/images/p-class/rearview/backplane.gif'"/>
   <xsl:variable name="P_SERVER_FRNT" select='"/mxportal/bladeime/skin/images/p-class/frontview/server/"' />
   
 
  <!-- P-Class Server empty slot location -->
    <xsl:variable name="EMPT_SLT_REAR" select="'/mxportal/bladeime/skin/images/p-class/rearview/emptySlot.gif'" />
  <!-- P-Class Switch Rear (Dukes) location -->
    <xsl:variable name="DUKES_SWITCH" select="'/mxportal/bladeime/skin/images/p-class/rearview/switch/dukes.gif'" />
    
  
  <!-- Blank spaces images location -->
  <xsl:variable name="ONE_WHITE"  select="'/mxportal/bladeime/skin/images/misc/one_white.gif'"/>
  <xsl:variable name="ONE_GRAY"  select="'/mxportal/bladeime/skin/images/misc/one_gray.gif'"/>
  <xsl:variable name="ONE_EMPTY"  select="'/mxportal/bladeime/skin/images/misc/one_empty_encl.gif'"/>

<!-- Misc Images URL -->

  <xsl:variable name="IMAGE_MIN"  select="'/mxportal/bladeime/skin/images/misc/win_shrink.gif'"/>
  <xsl:variable name="IMAGE_MAX"  select="'/mxportal/bladeime/skin/images/misc/win_expand.gif'"/>
  <xsl:variable name="IMAGE_RIGHT"  select="'/mxportal/bladeime/skin/images/misc/right.gif'"/>
  <xsl:variable name="IMAGE_LEFT"  select="'/mxportal/bladeime/skin/images/misc/left.gif'"/>

<xsl:variable name="ECLASS_ENCL_FRMREV" select="1.4" />
<!-- Enclosure Constants -->


	<!--
	Blade size constants used for table row and column calculation
	Taken from mmHeight and mmWidth fields.
	-->
	<xsl:variable name="BLADE_HEIGHT" select="133" />
	<xsl:variable name="BLADE_WIDTH" select="22" />
	
	<!-- The number of blades in each row of the enclosure -->
	<!--
	<xsl:variable name="BAYS_PER_ENCLOSURE" select="$enclosureInfoDoc//hpoa:enclosureInfo/bladeBays" />
	-->
	<xsl:variable name="BAYS_PER_ENCLOSURE" select="16" />
	
	<!--
	The number of rows of bays per each enclosure. NOTE: It is assumed
	that there are currently only two rows of bays in this enclosure.
	-->
	<xsl:variable name="BAY_ROWS_PER_ENCLOSURE" select="2" />
	
	<!--
	The number of blades in each row of the enclosure found by dividing the total
	number of bays in the enclosure by the total number of rows in the enclosure.
	-->
	<xsl:variable name="BLADES_PER_ROW" select="$BAYS_PER_ENCLOSURE div $BAY_ROWS_PER_ENCLOSURE" />
	
	<!-- The number of power supply bays in the enclosure -->
	<!--<xsl:variable name="PSBAYS_PER_ENCLOSURE" select="$enclosureInfoDoc//hpoa:enclosureInfo/psBays" />-->
	<xsl:variable name="PSBAYS_PER_ENCLOSURE" select="6" />
	
	<!-- The number of fans in the enclosure -->
	<!--<xsl:variable name="FANS_PER_ENCLOSURE" select="$enclosureInfoDoc//hpoa:enclosureInfo/fanBays" />-->
	<xsl:variable name="FANS_PER_ENCLOSURE" select="10" />
	
	<!--
	The number of rows of fans on the rear of the enclosure.
	NOTE: It is assumed that there are only two rows of fans.
	-->
	<xsl:variable name="FAN_ROWS_PER_ENCLOSURE" select="2" />
	
	<xsl:variable name="FANS_PER_ROW" select="$FANS_PER_ENCLOSURE div $FAN_ROWS_PER_ENCLOSURE" />
	
	<!--
	Bay size constants. Based on a single bay's width and height.
	Used when drawing the blade front view table.
	-->
	
	<!-- Device Constants -->
		<xsl:variable name="SERVER" select="'Server'"/>
		<xsl:variable name="SWITCH" select="'Switch'"/>
		<xsl:variable name="STORAGE" select="'Storage'"/>
	
	
	
	
	
	<!-- We maintain only half bay's dimentions as the rest can be computed -->

	<xsl:variable name="PE_HALF_BAY_WIDTH" select="24"/>
	<xsl:variable name="C_HALF_BAY_WIDTH" select="26"/>
	<xsl:variable name="HALF_BAY_HEIGHT" select="75"/>
	<xsl:variable name="FULL_BAY_HEIGHT" select="2*number($HALF_BAY_HEIGHT)"/>
<xsl:variable name="E_HALF_BAY_HEIGHT" select="93"/>

	<xsl:variable name="P_NUM_SRV_BAYS" select="8"/>
	<xsl:variable name="P_NUM_SWTCH_BAYS" select="2"/>

	<xsl:variable name="C_NUM_SRV_BAYS" select="8"/>
	<xsl:variable name="C_NUM_SWTCH_BAYS" select="8"/>
	
	<!-- The enclosure height and width are same for p-Class and c-Class server enclosures, Only that the p-Class server enclosures will have 8(/16) servers 
		  and 2 swtiches and the c-Class server enclosure will have 8 servers , The switches 8 reside in the rear view for c-Class ServerEnclosure -->
	<xsl:variable name="P_ENCL_WIDTH" select="number(240)+number(0)"/>
	<xsl:variable name="C_ENCL_WIDTH" select="number(210)+number(8)"/>
	<xsl:variable name="PC_ENCL_HEIGHT" select=" (number($FULL_BAY_HEIGHT)) "/>
	<!-- P and C class enclosure{power and server} have a width is 250px -->

	<xsl:variable name="E_NUM_SRV_BAYS" select="20"/>
	<xsl:variable name="E_NUM_SWTCH_BAYS" select="0"/>

	<xsl:variable name="E_ENCL_WIDTH" select="   number($PE_HALF_BAY_WIDTH) * (number($E_NUM_SRV_BAYS) +number($E_NUM_SWTCH_BAYS)  )    "/>
	<xsl:variable name="E_ENCL_HEIGHT" select=" number($E_HALF_BAY_HEIGHT) "/>	

	<!-- E class server enclosure  have a width is 500px {25*20}-->
	
	<!-- P/C/E Class Front+Rear Images height
		150          44+106 p-class server enclosure = 150+150 = 300
		150+25   28+(18*4)+19+28+25+4=172+4 = 175+175=350
		93	75+18 = 186     
	-->

	<xsl:variable name="P_SRVENCL_IMG_HT" select="'300'"/>
	<xsl:variable name="C_SRVENCL_IMG_HT" select="'350'"/>
	<xsl:variable name="E_SRVENCL_IMG_HT" select="'186'"/>	 	
	<xsl:variable name="P_PWRENCL_THREEU_IMG_HT" select="'150'"/>
	<xsl:variable name="P_PWRENCL_ONEU_IMG_HT" select="'50'"/>	 	
	
	
	<xsl:variable name="ONEU_HEIGHT" select="25"/>
	<!-- Dimenstions Of Server Enclosure -->
	<xsl:variable name="HGT_POWERRTPANE" select= "355"/>
	<xsl:variable name="HEIGHT_POWER_SLIDER" select= "$HGT_POWERRTPANE+ number(67)"/>
	<xsl:variable name="WHITE_SPACE3U" select= "200"/> 
	<xsl:variable name="WHITE_SPACE1U" select= "$WHITE_SPACE3U + number(100)"/>	
	<xsl:variable name="WHITE_SPACE_ECLASS" select= "125"/> 
	<xsl:variable name="ServerEnc" select= "'ServerEnc'"/> 
	<xsl:variable name="PowerEnc" select= "'PowerEnc'"/>
	<xsl:variable name="BPV" select= "'bpv'"/>
	<xsl:variable name="NOT_AVAILABLE" select= "'Not Available'"/>

	<!-- Model Names of all p-class Switches -->
	<xsl:variable name="CISCO_MODEL_PATTERN" select="'Cisco'"/>
	<xsl:variable name="GBE_MODEL_PATTERN" select="'GbE'"/>
	<!-- Model Names of all c-class Switches -->
	<xsl:variable name="PASS_MODEL_PATTERN" select="'Pass'"/>
	<xsl:variable name="SAN_MODEL_PATTERN" select="'SAN'"/>
	<xsl:variable name="MELLANOX_MODEL_PATTREN" select="'DDR IB'"/>
	<xsl:variable name="VC_ENET_MODEL_PATTERN" select="'VC-Enet'"/>
	<!-- Model Names of all c-class Servers -->
	<xsl:variable name="BL685C_MODEL_PATTERN" select="'BL685c'"/>
	
</xsl:stylesheet>

  
  