<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
    <xsl:include href="constants.xsl" />
    <xsl:include href="globalTemplates.xsl" />
	<xsl:include href="proxy.xsl" />
	<xsl:param name="deviceSubType"/>
	<xsl:param name="typeOfDisplay"/>
	
	<xsl:template match="/">
		<xsl:call-template name="Head"/>
		<table border="0" cellpadding="0" cellspacing="0" id="RackBPV" width="100%">
			<tbody>
				<!-- View As Combo box -->
				  <xsl:choose>
					<xsl:when  test="//Rack[@Empty='true']">
						<tr>
							<td align="left">
							<font color="#cc0000" ><xsl:value-of select="//I18N/L10NEmptyRackMessage"/></font>
							</td>
						</tr>	
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td align="left">
								<xsl:if test="$typeOfDisplay=$BPV">
									<xsl:call-template name="renderViewAsBox"/>
								</xsl:if>
							</td>
						</tr>
						<!-- Seperator -->
						<tr>
							<td>
								<img width="5" >
									<xsl:attribute name="src">
										<xsl:value-of select="$ONE_WHITE"/>
									</xsl:attribute>
								</img>	
							</td>
						</tr>	
						<tr>
						<!--Select checkboxes-->
							<td>
								<table border="0" cellpadding="0" cellspacing="0">
									<tr>
										<td>	<xsl:value-of select="//I18N/L10NSelect"/> 
										<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
										<xsl:text>&#160;&#160;&#160;</xsl:text>
										</td>
										<xsl:call-template name="drawCheckBox">
											<xsl:with-param name="checkBoxName" select="//I18N/L10NAllBlades"/>
											<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
											<xsl:with-param name="checkBoxId" select="'All Blades'"/>
										</xsl:call-template>
										<xsl:call-template name="drawCheckBox">
											<xsl:with-param name="checkBoxName" select="//I18N/L10NAllInterconnectSwitches"/>
											<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
											<xsl:with-param name="checkBoxId" select="'All Switches'"/>
										</xsl:call-template>
										<xsl:if test="//@type=$C_CLASS">
											<xsl:call-template name="drawCheckBox">
												<xsl:with-param name="checkBoxName" select="//I18N/L10NAllEMs"/>
												<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
												<xsl:with-param name="checkBoxId" select="'All EMs'"/>
											</xsl:call-template>
										</xsl:if>	
									</tr>
								</table>
							</td>
						</tr>
					<!-- Seperator -->
					<tr>
						<td>
							<img width="5" >
								<xsl:attribute name="src">
									<xsl:value-of select="$ONE_WHITE"/>
								</xsl:attribute>
							</img>	
						</td>
					</tr>		
						<xsl:for-each select="//Rack/BladeEnclosure">
							<tr>
								<td>
										<xsl:call-template name="renderBPV">
											<xsl:with-param name="encName">
													<xsl:call-template name="getMemberAttr">
													<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
														<xsl:with-param name="location"><xsl:text>RackView</xsl:text></xsl:with-param>
												</xsl:call-template>
											</xsl:with-param>
											<xsl:with-param name="enclSerialNum">
												<xsl:call-template name="getMember">
													<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
												</xsl:call-template>
											</xsl:with-param>
											<xsl:with-param name="typeOfView"><xsl:text>RackView</xsl:text></xsl:with-param> 
											<xsl:with-param name="deviceSubType" select="$ServerEnc"/>
											<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
										</xsl:call-template>
								</td>
							</tr>
						</xsl:for-each>
						<xsl:for-each select="//PowerSupplyEnclosure">
						<tr>
							<td>
								<xsl:call-template name="renderBPV">
									<xsl:with-param name="encName">
										<xsl:call-template name="getMember">
											<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
										</xsl:call-template>
									</xsl:with-param>
									<xsl:with-param name="enclSerialNum">
										<xsl:call-template name="getMember">
											<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
										</xsl:call-template>
									</xsl:with-param>
									<xsl:with-param name="typeOfView"><xsl:text>RackView</xsl:text></xsl:with-param> 
									<xsl:with-param name="deviceSubType" select="$PowerEnc"/>
									<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
								</xsl:call-template>
							</td>
						</tr>		
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>		
			</tbody>
		</table>
</xsl:template>
</xsl:stylesheet>
