<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions">


    <!--
		Include the gui and enclosure constants files.
		NOTE: The enclosure constants file is dependant on the $enclosureInfoDoc variable.
	 -->

    <xsl:include href="constants.xsl" />
    <xsl:include href="globalTemplates.xsl" />
	<xsl:include href="proxy.xsl" />
	<xsl:include href="attributes.xsl" />

    <!-- $ServerEnc  and  $PowerEnc -->
	<xsl:param name="deviceSubType"/>
	<xsl:param name="typeOfDisplay" />
	<xsl:param name="typeOfView">EnclosureView</xsl:param>
	
	<xsl:template match="*">
	<xsl:call-template name="Head"/>
				<table border="0" cellpadding="0" cellspacing="0" width="100%" align="left" id="EnclosureBPV">
					<tbody>
						<tr>
							<td  width="70%" valign="top" id="LEFT_PANE">
								<table border="0" cellpadding="0" cellspacing="0" width="100%">
									<tr>
										<td>
											<table border="0" cellpadding="0" cellspacing="0" width="100%">
												<xsl:if test="$typeOfDisplay = 'bpv'">
													<tr>
														 <td>
															 <!-- The View As combo box is rendered only for the server enclosure -->
															 <xsl:if test="$deviceSubType=$ServerEnc">
																<xsl:call-template name="renderViewAsBox"/>
															</xsl:if>
														</td>
													</tr>
													<tr>
														<td>
															<img width="10">
																<xsl:attribute name="src">
																	<xsl:value-of select="$ONE_WHITE"/>
																</xsl:attribute> 	
															</img>
														</td>
													</tr>
												</xsl:if>
													 <tr>
														 <td  valign="top">
															 <div id="renderProperties">
															<xsl:call-template name="renderProperties">
																<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
															</xsl:call-template>
															</div>
														</td>
													</tr>
											</table>	
										</td>
									</tr>
								</table>	
							</td>
							
							<!-- Center PANE -->
							<td width="1%" id="CENTER_PANE">
								<table border="0" cellpadding="0" cellspacing="0" id="enclosureBPV" width="100%">
									<tbody>
										<tr>
											<td>
												<img width="100%">
													<xsl:attribute name="src">
														<xsl:value-of select="$ONE_WHITE"/>
													</xsl:attribute>
												</img>
											</td>
										</tr>	
									</tbody>
								</table>
							</td>		
							
							<!-- BPV is draw here -->
							<td valign="top" id="RIGHT_PANE" width="25%">
								<table cellpadding="0" cellspacing="0" id="enclosureBPV" width="100%" border="0">
									<tbody>
										<!-- The height is set by the js method setSliderHeight, This is to horizontally align the bpv and properties table -->
										<tr>
											<td height="" id="emptySpaceAboveBPV"></td>
										</tr>
										<tr>
											<td>
												<table cellpadding="0" cellspacing="0">
													<tbody>
														<tr>
															<td>
																<xsl:choose>
																	<xsl:when test="$typeOfDisplay = $BPV">
																			<a href="javascript:void(0);">
																				<xsl:element name="img">
																					<xsl:attribute name="onclick">slideEnclosure('renderBPV', this,'<xsl:value-of select="//I18N/L10NSlideLeft"/>', ' <xsl:value-of select="//I18N/L10NSlideRight"/>');</xsl:attribute> 
																					<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NSlideRight"/></xsl:attribute>
																					<xsl:attribute name="src"><xsl:value-of select="$IMAGE_RIGHT" /></xsl:attribute>
																					<xsl:attribute name="width">11</xsl:attribute>
																					<xsl:attribute name="height">11</xsl:attribute>
																					<xsl:attribute name="border">0</xsl:attribute>
																				</xsl:element>
																			</a>
																	</xsl:when>
																	<xsl:otherwise>
																			<img  width="11" height ="11" border="0" >
																				<xsl:attribute name="src"><xsl:value-of select="$IMAGE_RIGHT" /></xsl:attribute>
																			</img>	
																	</xsl:otherwise>
																</xsl:choose>	
															</td>
														</tr>
														<tr>
															<td>
																<img width="11" name="Power_Slider">
																	<xsl:attribute name="height">
																		<xsl:choose>
																			<xsl:when test="//BladeEnclosure[@type=$P_CLASS]"><xsl:value-of select="$P_SRVENCL_IMG_HT"/></xsl:when>
																			<xsl:when test="//BladeEnclosure[@type=$C_CLASS]"><xsl:value-of select="$C_SRVENCL_IMG_HT"/></xsl:when>
																			<xsl:when test="//PowerSupplyEnclosure[@type=$P_CLASS and @size='3U']"><xsl:value-of select="$P_PWRENCL_THREEU_IMG_HT"/></xsl:when>
																			<xsl:when test="//PowerSupplyEnclosure[@type=$P_CLASS and @size='1U']"><xsl:value-of select="$P_PWRENCL_ONEU_IMG_HT"/></xsl:when>
																			<xsl:when test="//BladeEnclosure[@type=$E_CLASS]"><xsl:value-of select="$E_SRVENCL_IMG_HT"/></xsl:when>
																		</xsl:choose>
																	</xsl:attribute>
																	<xsl:attribute name="src">
																		<xsl:value-of select="$ONE_GRAY"/>
																	</xsl:attribute>
																</img>
															</td>
														</tr>
													</tbody>
												</table>
											</td> 
											<td valign="top" id="renderBPVDIV">
											<!-- Start BPV -->
													<div id="BigPictureView">
												<xsl:choose>
													<xsl:when test="$deviceSubType=$ServerEnc">
														<xsl:for-each select="//BladeEnclosure">
															<xsl:call-template name="renderBPV">
																<xsl:with-param name="encName">
																	<xsl:call-template name="getMemberAttr">
																		<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
																		<xsl:with-param name="location"><xsl:text>RackView</xsl:text></xsl:with-param>
																	</xsl:call-template>
																</xsl:with-param>
																<xsl:with-param name="enclSerialNum">
																	<xsl:call-template name="getMember">
																		<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
																	</xsl:call-template>
																</xsl:with-param>
																<xsl:with-param name="deviceSubType" select="$deviceSubType"/>
																<xsl:with-param name="typeOfView" select="$typeOfView"/>
																<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
															</xsl:call-template>
													</xsl:for-each>
												</xsl:when>
												<xsl:otherwise>
													<xsl:for-each select="//PowerSupplyEnclosure">
														<xsl:call-template name="renderBPV">
															<xsl:with-param name="encName">
																<xsl:call-template name="getMember">
																	<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NEnclosureName"/></xsl:with-param>
																</xsl:call-template>
															</xsl:with-param>
															<xsl:with-param name="enclSerialNum">
																<xsl:call-template name="getMember">
																	<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
																</xsl:call-template>
															</xsl:with-param>
															<xsl:with-param name="deviceSubType" select="$deviceSubType"/>
															<xsl:with-param name="typeOfView" select="$typeOfView"/>
															<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>						
														</xsl:call-template>
													</xsl:for-each>
											</xsl:otherwise>
										</xsl:choose>	
											</div>
										<!-- End : Draw bpv -->			
										</td>
								</tr>
							</tbody>
						</table>
					</td>
				</tr>
			</tbody>
		</table>				
</xsl:template>

</xsl:stylesheet>