function init() 
{
	var pageTitle = "Rack Overview";
	top.mainPage.getRightSideFrame().setTitle(pageTitle);
}
	
function selectEnclosure(num, name) 
{
	top.mainPage.getNavigationFrame().selectEnclosure(num, name);
}
	
function toggleEnclosureVisible(encId, expandImage,titleMax,titleMin,titleBarId)
{
	var enclosure = document.getElementById(encId);
	var enclosurePadding = document.getElementById(encId + "Padding");
	if (enclosure != null)
	{
		if (enclosure.style.display == 'none')
		{
			enclosure.style.display = 'block';
			expandImage.src = '/mxportal/bladeime/skin/images/misc/win_shrink.gif';
			expandImage.title = titleMin;
		}
		else
		{
			enclosure.style.display = 'none';				
			expandImage.src = '/mxportal/bladeime/skin/images/misc/win_expand.gif';
			expandImage.title = titleMax;
		}
	}

	tdNodeCollection = document.getElementsByTagName("td");

	for (var i=0;i<tdNodeCollection.length;i++)
	{
		tdColumn = tdNodeCollection[i];
		tdId = tdColumn.getAttribute("id");
		if (tdId == "minimizeBpv")
		{
			tdColumn.height="400";
		}
	}
	setTitleBarWidth(titleBarId);
}	

function toggleSectionVisible(encId, expandImage)
{
	var enclosure = document.getElementById(encId);
	var enclosurePadding = document.getElementById(encId + "Padding");
	if (enclosure != null)
	{
		if (enclosure.style.display == 'none')
		{
			enclosure.style.display = 'block';
			expandImage.src = '/mxportal/bladeime/skin/images/section_tree_contract.gif';
			enclosurePadding.style.display = 'none';				
		}
		else
		{
			enclosure.style.display = 'none';				
			expandImage.src = '/mxportal/bladeime/skin/images/section_tree_expand.gif';
			enclosurePadding.style.display = 'block';
		}
	}
}	
	
function displayEnclosure(url)
{
	document.location.replace(url);
}	

// ISSUE0000279332 Fix
function makeSelection(guid)
{
	var count = 0;
	var inputNodeCollection = window.document.getElementsByTagName("input");

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if ((inputNodeCollection[i].getAttribute("id")=="serverCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="switchCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="oaCheckBox") &&
			inputNodeCollection[i].getAttribute("guid")==guid)
		{
			inputNodeCollection[i].checked=true;
			count++;
		}
	}
		
	makeButtonSelection(count);
}

guidList = "";
// ISSUE0000279332 Fix
function applySelection(inputID)
{
	var inputNodeCollection = window.document.getElementsByTagName("input");

	if (inputID.getAttribute("id")=="All Blades")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			}
		}
	}

	if (inputID.getAttribute("id") == "All Switches")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			}
		}
	}

	if (inputID.getAttribute("id") == "All EMs")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			}
		}
	}

	guidList = applyMulitpleGlobalSelection();

	toggleMultiNodeSelection(guidList);
}


function applySelectiononzoom(inputID)
{

   	var inputNodeCollection = window.document.getElementsByTagName("input");
	if (inputID.getAttribute("id")=="All Blades")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
				
			if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
			    if (inputID.checked)
				zoomCount++;
				//applyMulitpleGlobalSelection(inputNodeCollection[i]);
				toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
			}
		}
	}

	if (inputID.getAttribute("id") == "All Switches")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
				if (inputID.checked)
					zoomCount++;
                //applyMulitpleGlobalSelection(inputNodeCollection[i]);
				toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
			}
		}
	}

	if (inputID.getAttribute("id") == "All EMs")
	{
		for (var i=0; i<inputNodeCollection.length;i++) 
		{
			if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox")
			{
				inputNodeCollection[i].checked = inputID.checked;
				if (inputID.checked)
				  zoomCount++;
                 
				//applyMulitpleGlobalSelection(inputNodeCollection[i]);
                 toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
			}
		}
	}
	
 }

// ISSUE0000279332 Fix
function applyMulitpleGlobalSelection()
{
	var count = 0;
	var inputNodeCollection = window.document.getElementsByTagName("input");
	var selectedGUIDList = "";
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if ((inputNodeCollection[i].getAttribute("id")=="serverCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="switchCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="oaCheckBox") && 
			inputNodeCollection[i].checked)
		{
			count++;
			selectedGUIDList = selectedGUIDList + "|" + inputNodeCollection[i].getAttribute("guid");
		}
	}
	
	makeButtonSelection(count);	

	return selectedGUIDList;
}

// ISSUE0000279332 Fix
function applyGlobalSelection(inputNodeCollection, inputID)
{
	var count = 0;
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if ((inputNodeCollection[i].getAttribute("id")=="serverCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="switchCheckBox" || 
			inputNodeCollection[i].getAttribute("id")=="oaCheckBox") && 
			inputNodeCollection[i].checked)
		{
			count++;
			
			//added to check
			if(zoomCount>0)
            {
			 toggleNodeSelection(inputNodeCollection[i],inputNodeCollection[i].getAttribute("guid"),zoomCount);
  			 zoomCount++;
			}
			//end
		}
	}
	if(zoomCount==0)
	toggleNodeSelection(inputID,inputID.getAttribute("guid"),count);
	else
	toggleNodeSelection(inputID,inputID.getAttribute("guid"),zoomCount);
	
	makeButtonSelection(count);
}

// ISSUE0000279332 Fix
function globalSelection(inputID)
{
	var inputNodeCollection = window.document.getElementsByTagName("input");

	applyGlobalSelection(inputNodeCollection, inputID); 
	checkAllServersAndSwitches();
}

// ISSUE0000279332 Fix
function checkAllServersAndSwitches(inputNodeCollection)
{
	var inputNodeCollection = window.document.getElementsByTagName("input");

	var allSwichesSelected = checkAllSwitchesSelected(inputNodeCollection);
	var allServersSelected = checkAllBladesSelected(inputNodeCollection);
	var allOAsSelected = checkAllOAsSelected(inputNodeCollection);

	makeAllServersAndSwitchesChoice(inputNodeCollection, allSwichesSelected, allServersSelected, allOAsSelected);
}

// ISSUE0000279332 Fix
function checkAllSwitchesSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}		

	return isSwitchPresent(inputNodeCollection);
}

// ISSUE0000279332 Fix
function checkAllBladesSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}				
	
	return isBladePresent(inputNodeCollection);
}

function checkAllOAsSelected(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox" && !inputNodeCollection[i].checked)
		{
			return false;
		}
	}		

	return isOAPresent(inputNodeCollection);
}

function isOAPresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="oaCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}

// ISSUE0000279332 Fix
function isSwitchPresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="switchCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}

// ISSUE0000279332 Fix
function isBladePresent(inputNodeCollection)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="serverCheckBox")
		{
			return true;
		}
	}		
	
	return false;
}

// ISSUE0000279332 Fix
function makeAllServersAndSwitchesChoice(inputNodeCollection, allSwichesSelected, allServersSelected, allOAsSelected)
{
	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All Switches")
		{
			inputNodeCollection[i].checked = allSwichesSelected;
			break;
		}
	}

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All Blades")
		{
			inputNodeCollection[i].checked = allServersSelected;
			break;
		}
	}

	for (var i=0; i<inputNodeCollection.length;i++) 
	{
		if (inputNodeCollection[i].getAttribute("id")=="All EMs")
		{
			inputNodeCollection[i].checked = allOAsSelected;
			break;
		}
	}
}

// ISSUE0000279332 Fix
function drillDown(url)
{
	document.location.replace(url);
}

//This method is called to open an new window with the URL as the argument.
function drillDownforack(url)
{
	window.open(url);
}

/*
 * This method is called once the user clicks the View As combo box from Rack/Enclosure 
 */
function onViewChange(e)
{
    if (e.value != "")
    {
        parent.document.location.replace(e.value);
    }
}

//This method is called to open an new window with the URL as the argument.
//Currently its being used to open SMH from a device status icon from the BPV
var windows=new Array();
function openNewWindow(url)
{
	for(i=0;i<windows.length;i++){
		if(windows[i]==url){
			window.open(url, "win"+i);	
			return;
		}
	}
	window.open(url, "win"+windows.length);
	windows[windows.length]=url;
}

//This method is used to slide the enclosure(power/server) when the user clicks the left/right icon 
// in the Enclosure BPV
function slideEnclosure(encId, image, titleSlideLeft, titleSlideRight)
{
	var leftPane = document.getElementById('LEFT_PANE');
	var enclosure = document.getElementById(encId);
	if (enclosure != null) {	
		// Currently hidden click to show.
		if (enclosure.style.display == 'none') {
			enclosure.style.display = 'block';
			image.src = '/mxportal/bladeime/skin/images/misc/right.gif';
			image.title = titleSlideRight;
			leftPane.setAttribute("width","70%");
		}
		else { // Currently Visisble click to hide
			enclosure.style.display = 'none';				
			image.src = '/mxportal/bladeime/skin/images/misc/left.gif';
			image.title = titleSlideLeft;
			leftPane.setAttribute("width","99%");
			pausecomp(100);
		}
	}
}	

function pausecomp(millis) 
{
date = new Date();
var curDate = null;

do { var curDate = new Date(); } 
while(curDate-date < millis);
} 

/* The function sets the height of the slider and the BPV table in proportion to the height of
the properties displayed to the left of the BPV.*/

function setSliderHeight(view) 
{

	/* 
		Set the height of emptySpaceAboveBPV {td} above the bpv to the height of the 
		height of View as combo box {td id=ViewAsCombo} + the 8px which is the height
		of the empty space btw the combo box and the properties.
	*/
	var viewAsBox = document.getElementById("ViewAsCombo");
	var spaceBox = document.getElementById("emptySpaceAboveBPV");
	if(spaceBox!=null) { // For RackView space is null.
		if(viewAsBox!=null) { //For enclosure view ViewAs is present.
			spaceBox.setAttribute("height",viewAsBox.offsetHeight+8);	
		}else { //For power enclosure the View as combo is absent.
			if(view == 'bpv') {
				spaceBox.setAttribute("height",10);	
			}
		}
	}	
	//Set the height of the slider
    var renderBPVElem = document.getElementById("renderBPV")
	var renderHtElem = document.getElementById("renderProperties")
	if(renderBPVElem == null || renderHtElem==null) {
		return;
	}
	
	var bpvHeight = renderBPVElem.offsetHeight;
	var renderHeight = renderHtElem.offsetHeight;
	var errorCorrection = 0;
	var all_images = window.document.getElementsByTagName("img");
	var finalBPVHeight;
	var sliderElement;
	var bpvEmptySpaceEle;
	for (var i=0; i<all_images.length;i++) 
	{
		if (all_images[i].getAttribute("name")=="Power_Slider")
		{
				var newSliderHeight = 0;
				var curBPVHgt = all_images[i].getAttribute("height");
				var titleBarHght = document.getElementById("enclTitleBar").offsetHeight;
				var chkBox = document.getElementById("checkBoxEncl");
				var chkBoxHght;
				var error;
				if(chkBox==null) { //PowerEncl
					chkBoxHght = 0;
					error=74;
				}
				else {
					chkBoxHght = document.getElementById("checkBoxEncl").offsetHeight;
					error=72;
				}
				var finalHt = eval(curBPVHgt+ '+' + titleBarHght + '+' + chkBoxHght + '+' + error);
				sliderElement = all_images[i];
				sliderElement.setAttribute("height",finalHt);
				finalBPVHeight = finalHt;
		}
	}

	for (var i=0; i<all_images.length;i++) 
	{
		if (all_images[i].getAttribute("id")=="BPV_EMPTY_SPACE")
		{
				var incrBPVHeight = eval(renderHeight+'-'+finalBPVHeight+'-'+'9');
				if(incrBPVHeight>0) {
					bpvEmptySpaceEle = all_images[i];
					bpvEmptySpaceEle.setAttribute("height",incrBPVHeight);
				}
		}
	}
	if(renderHeight>finalBPVHeight) {
		sliderElement.setAttribute("height",eval(renderHeight+'-'+'10'));
	}
}

function hideProgressBar() {
	var progressBar = document.getElementById('progressBar');
	if(progressBar!=null) {
		progressBar.style.display = 'none';				
	}
}

function splitPowerRedundancyInfo()
{
	tableNodeCollection = window.document.getElementsByTagName("table");
	tdCollection= window.document.getElementsByTagName("td");
	//To display the Power Redundancy Information in an Enclosure BPV
	for(var j=0;j<tdCollection.length;j++)
	{
		tdNode=tdCollection[j];
		if(tdNode.className=="propertyValue")
		{
			redundancyInfo = tdNode.getAttribute("PowerRedundancyValue");
			if(tdNode.getAttribute("PowerRedundancyName")!=null)
			{
				redundancyName = tdNode.getAttribute("PowerRedundancyName");
			}

			if(redundancyInfo!=null)
			{
				redundancy = redundancyInfo.split("/");
				
				for(var k=0;k<redundancy.length;k++)
				{
					powerRedundancyColumnText = document.createTextNode(redundancy[k]);
					tdNode.appendChild(powerRedundancyColumnText);
					powerRedundancySecondRow = document.createElement("tr");
					powerRedundancySecondColumn = document.createElement("th");
					powerRedundancySecondRow.appendChild(powerRedundancySecondColumn);
					tdNode.appendChild(powerRedundancySecondRow);
				}
			}
			
		}
	}
	//To display the Power Redundancy Information in Rack BPV
	for(var i=0;i<tableNodeCollection.length;i++)
	{
		 tableNode = tableNodeCollection[i];
		 if (tableNode.getAttribute("id")=="AttributeTable")
		 {
			redundancyInfo = tableNode.getAttribute("PowerRedundancyValue");
			if(tableNode.getAttribute("PowerRedundancyName")!=null)
			{
				redundancyName = tableNode.getAttribute("PowerRedundancyName");
			}

			if(redundancyInfo!=null)
			{
				redundancy = redundancyInfo.split("/");
				tbodyList = tableNode.getElementsByTagName("tbody");
				tbody = tbodyList[0];
				powerRedundancyFirstRow = document.createElement("tr"); 
				powerThermalfirstColumn = document.createElement("td");
				powerRedundancyColumnText=document.createTextNode(redundancyName);
				powerThermalfirstColumn.appendChild(powerRedundancyColumnText);
				powerRedundancyFirstRow.appendChild(powerThermalfirstColumn);
				for(var k=0;k<redundancy.length;k++)
				{
					powerRedundancyColumn= document.createElement("td");
					powerRedundancyColumnText = document.createTextNode(redundancy[k]);
					powerRedundancyColumn.appendChild(powerRedundancyColumnText);
					powerRedundancyFirstRow.appendChild(powerRedundancyColumn);
					powerRedundancyColumn.setAttribute("nowrap","");
					powerRedundancySecondRow = document.createElement("tr");
					powerRedundancySecondColumn = document.createElement("td");
					powerRedundancySecondRow.appendChild(powerRedundancySecondColumn);
					
					tbody.appendChild(powerRedundancyFirstRow);
					powerRedundancyFirstRow=powerRedundancySecondRow;
				}
			}
		}
	}
}

function loadDeviceInfoTip(e, toolTip) {
	positionTT(e);
	document.onmousemove = positionTT;
	var canvas=document.getElementById("toolText");
	canvas.innerHTML="";
	toolTip = toolTip.split(",");
	var tt="";
	for(var k=0;k<toolTip.length;k++) {
		tt += toolTip[k]+"<br>"
	}

	toolTip=tt;
	canvas.innerHTML=toolTip;
	canvas.style.visibility="visible";

	if(e){
		e.stopPropagation();
	}else {
		event.cancelBubble=true;
	}
}

function positionTT(e) {
		
	var canvas=document.getElementById("toolText");
	var isIE=true;
	if(!document.all){
		isIE=false;
		document.captureEvents(Event.MOUSEMOVE)
	}
	var mX,mY;
	if (isIE) { 
		mX = event.clientX + document.body.scrollLeft;
		mY = event.clientY + document.body.scrollTop;
	}else {  
		mX = e.pageX;
		mY = e.pageY;
	}

	var winWidth;
	if(document.all){
		winWidth=document.body.clientWidth;
	}else{
		winWidth=window.innerWidth;
	}
	var w = (mX + canvas.offsetWidth);
	if( w >= winWidth ){
		mX = mX - canvas.offsetWidth;
	}
	if(mX<0) {
		mX=0;
	}
	canvas.style.top=mY+20;
	canvas.style.left=mX;
}

function removeDeviceInfoTip() {
var canvas=document.getElementById("toolText");
canvas.style.visibility="hidden";
canvas.innerHTML="";
}