
PRODNAME="HP BladeSystem Integrated Manager 2.2"
HPSIMNAME="HP Systems Insight Manager 5.0.2"

####################################
#
# file and directory locations
#
####################################
SIM_BIN="/opt/mx/bin"
SIM_LIB="/opt/mx/lib"
SIM="/opt/mx"
SIM2="/var/opt/mx"
SIM3="/etc/opt/mx"
SIM_TOOLS="/var/opt/mx/tools"
SIM_PORTAL="/opt/hpwebadmin/webapps/ROOT/mxportal"
MXVERSION="${SIM_BIN}/mxversion"
MXTOOL="${SIM_BIN}/mxtool -l f -t BogusToolName"
MXSTOP="${SIM_BIN}/mxstop"
MXSTART="${SIM_BIN}/mxstart"
SLEEP=/bin/sleep
EXPR=expr

####################################
#
# version strings for matching
#
####################################
VERSION_52="C.05.00.02.00"


#############################################################
#
# Function: GetSIMStatus()
#
# Checks to see if HP SIM is running
#
# Returns 0 if HP SIM is running and 1 if it is not
#
#############################################################

GetSIMStatus()
{
    $MXTOOL > /dev/null 2>&1

    # if return value of 200, we know that HP SIM is not started
    if [ $? = 200 ]
    then
        return 1
    fi

    return 0
}

#############################################################
#
# Main: start of the main script execution
#
#############################################################

echo
echo
echo ====================================================
echo HP BladeSystem Integrated Manager 2.2 Uninstall 
echo This will move HP BladeSystem Integrated Manager 2.2
echo to 2.1
echo
echo Enter "'y'" to continue this uninstall of 
echo HP BladeSystem Integrated Manager 2.2 
echo ====================================================

read x
if [ "$x" != 'y' -a "$x" != 'Y' ]; then
	echo "Uninstall was not chosen.  No changes being made."
	exit 50
fi

echo 

# Check to see if the user is the root user
user=`whoami`
if [ "$user" != "root" ] 
then
    echo "This patch must be run by the root user.  No changes being made."
    exit 100
fi

# Check if the "mxversion" utility can be found
if [ ! -e "${MXVERSION}" ]
then
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 200
fi

# execute "mxversion" and store the result
simVersion=`$MXVERSION`

echo $cmsOS

# if "mxversion" failed to execute properly then exit
if [ $? -ne 0 ]
then
    echo "Failed to execute $MXVERSION .  No changes being made."
    exit 300
fi

# extract the version string from the "mxversion" output
cmsOS=$(uname -s)
verString="$(echo $simVersion | sed 's/^.*- Linux \([^ ]*\).*$/\1/')"
verString="$(echo $verString | sed 's/^.*- HP-UX \([^ ]*\).*$/\1/')"
verString="$(echo $verString | sed 's/^Systems Insight Manager \([^ ]*\).*$/\1/')"
if [ $cmsOS = "HP-UX" ]
then
    verString="$(echo $verString | sed 's/.[^.]*$//')"
fi
echo $verString
# Check to see if we can recognize the version of SIM
if [ "$verString" != "$VERSION_52" ]
then 
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 500
fi
echo
echo "${HPSIMNAME} found."

# Check to see if HP SIM was started
wasSIMStarted="FALSE"
GetSIMStatus

if [ -e ${SIM}/bsimbackup/bladeime.bck ]
then

# if HP SIM was running then stop it
if [ $? = 0 ]
then
    # Stop the HP SIM services
    echo
    echo "Stopping the ${HPSIMNAME} daemons..."
    $MXSTOP  

    # Remember that HP SIM was running so we can restart it at the end
    wasSIMStarted="TRUE"
fi

# Delay 30 seconds
x=0
while [ $x -lt 10 ]; do
	echo -n .
	$SLEEP 3
	x=`$EXPR $x + 1`
done
echo

# install new files
x=$(pwd)
cd ${SIM_LIB}
echo "Starting HP BladeSystem Integrated Manager 2.1 Restore"
#echo "RESTORE bladeime.jar"
cp ${SIM}/bsimbackup/bladeime.bck ${SIM_LIB}/bladeime.jar
               
#echo "RESTORE MonteroSystemPageIntegration.xml"
cp ${SIM}/bsimbackup/MonteroSystemPageIntegration.bck ${SIM3}/config/SystemPage/MonteroSystemPageIntegration.xml
	
#echo "RESTORE BladeSystem.xml"
cp ${SIM}/bsimbackup/bladeSystem.bck ${SIM3}/config/identification/noderelationships/bladeSystem.xml
	
#echo "RESTORE MxBPV.jsp"
cp ${SIM}/bsimbackup/MxBPV.bck ${SIM_PORTAL}/home/MxBPV.jsp 
	
#echo "RESTORE skin.js"
cp ${SIM}/bsimbackup/skin.bck ${SIM_PORTAL}/bladeime/skin/js/skin.js 

#echo "RESTORE BladeIMEPrintView.jsp"
cp ${SIM_PORTAL}/bladeime/bpv/BladeIMEPrintView.jsp  ${SIM}/bsimbackup/BladeIMEPrintView.bck

#echo "RESTORE BladeIMEZoomOutBPV.jsp"
cp ${SIM_PORTAL}/bladeime/bpv/BladeIMEZoomOutBPV.jsp  ${SIM}/bsimbackup/BladeIMEZoomOutBPV.bck

#echo "RESTORE BladeIMENodeCheck.jsp"
cp ${SIM_PORTAL}/bladeime/bpv/BladeIMENodeCheck.jsp  ${SIM}/bsimbackup/BladeIMENodeCheck.bck
	
#echo "RESTORE AssociatedBlade.jsp"
cp $x/AssociatedBlade.jsp ${SIM_PORTAL}/bladeime/tabs/system
	
#echo "REMOVE server_1X_1Y_storage.gif"
#rm ${SIM_PORTAL}/bladeime/skin/images/c-class/frontview/server/server_1X_1Y_storage.gif
		
#echo "REMOVE server_1X_2Y_BL685C.gif"
#rm ${SIM_PORTAL}/bladeime/skin/images/c-class/frontview/server/server_1X_2Y_BL685C.gif

#echo "REMOVE io_mac_x_sm.gif"
#rm ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch/io_mac_x_sm.gif
		
#echo "REMOVE io_vc-enet.gif"
#rm ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch/io_vc-enet.gif

#echo "RESTORE io_cisco.gif"
cp ${SIM}/bsimbackup/io_cisco.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch/io_cisco.gif 

#echo "RESTORE HLEP DOCS"
cp -R ${SIM}/bsimbackup/en /opt/hpwebadmin/webapps/mxhelp/bladeime
cp -R ${SIM}/bsimbackup/ja /opt/hpwebadmin/webapps/mxhelp/bladeime

echo "File copy is complete"
echo "Restarting ${HPSIMNAME} daemons..."
echo "This would take couple of minutes..."
$MXSTART 
sleep 120
cd ${SIM_TOOLS}
	if [ -e bladeimeVersion.xml ] 
	then
		cp ${SIM}/bsimbackup/bladeimeVersion.bck ${SIM_TOOLS}/bladeimeVersion.xml
	 	echo "HP BLADESYSTEM INTERAGTED MANAGER VERSION FILE COPIED"
	   
	  	if [ -e ${SIM_BIN}/mxtool ] 
	  		then
	   	        ${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/bladeimeVersion.xml
		        ${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/bladeimeVersion.xml
	   	        rm -rf ${SIM}/bsimbackup
			echo "HP BLADESYSTEM INTEGRATED MANAGER 2.1 RESTORE COMPLETE"		
	    	else
		    	echo "MXTOOL DOES NOT EXIST"	
		    	echo "HP BLADESYSTEM INTEGRATED MANAGER 2.1 RESTORE FAILED"
		exit			
		fi	
				  
	else
	        echo "HP BLADESYSTEM INTEGRATED MANAGER 2.1 VERSION CHANGE FAILED"
        exit
	fi		
else
echo "HP BLADESYSTEM INTEGRATED MANAGER 2.1 BACKUP NOT FOUND. RESTORE FAILED"
exit
fi
