
PRODNAME="HP BladeSystem Integrated Manager 2.2"
HPSIMNAME="HP Systems Insight Manager 5.0.2"

####################################
#
# file and directory locations
#
####################################
SIM_BIN="/opt/mx/bin"
SIM_LIB="/opt/mx/lib"
SIM="/opt/mx"
SIM2="/var/opt/mx"
SIM3="/etc/opt/mx"
SIM_TOOLS="/var/opt/mx/tools"
SIM_PORTAL="/opt/hpwebadmin/webapps/ROOT/mxportal"
MXVERSION="${SIM_BIN}/mxversion"
MXTOOL="${SIM_BIN}/mxtool -l f -t BogusToolName"
MXSTOP="${SIM_BIN}/mxstop"
MXSTART="${SIM_BIN}/mxstart"
SLEEP=/bin/sleep
EXPR=expr

####################################
#
# version strings for matching
#
####################################
VERSION_52="C.05.00.02.00"


#############################################################
#
# Function: GetSIMStatus()
#
# Checks to see if HP SIM is running
#
# Returns 0 if HP SIM is running and 1 if it is not
#
#############################################################

GetSIMStatus()
{
    $MXTOOL > /dev/null 2>&1

    # if return value of 200, we know that HP SIM is not started
    if [ $? = 200 ]
    then
        return 1
    fi

    return 0
}

#############################################################
#
# Main: start of the main script execution
#
#############################################################

echo
echo
echo ====================================================
echo HP BladeSystem Integrated Manager 2.2
echo 
echo This product is an enhanced management plug-in for
echo ${HPSIMNAME}.  The installation
echo will stop and restart ${HPSIMNAME}
echo if it is currently running.
echo 
echo Enter "'y'" to continue this installation.
echo ====================================================

read x
if [ "$x" != 'y' -a "$x" != 'Y' ]; then
	echo "Installation was not chosen.  No changes being made."
	exit 50
fi

echo 

# Check to see if the user is the root user
user=`whoami`
if [ "$user" != "root" ] 
then
    echo "This patch must be run by the root user.  No changes being made."
    exit 100
fi

# Check if the "mxversion" utility can be found
if [ ! -e "${MXVERSION}" ]
then
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 200
fi

# execute "mxversion" and store the result
simVersion=`$MXVERSION`




echo $cmsOS

# if "mxversion" failed to execute properly then exit
if [ $? -ne 0 ]
then
    echo "Failed to execute $MXVERSION .  No changes being made."
    exit 300
fi

# extract the version string from the "mxversion" output
cmsOS=$(uname -s)
verString="$(echo $simVersion | sed 's/^.*- Linux \([^ ]*\).*$/\1/')"
verString="$(echo $verString | sed 's/^.*- HP-UX \([^ ]*\).*$/\1/')"
verString="$(echo $verString | sed 's/^Systems Insight Manager \([^ ]*\).*$/\1/')"
if [ $cmsOS = "HP-UX" ]
then
    verString="$(echo $verString | sed 's/.[^.]*$//')"
fi
echo $verString
# Check to see if we can recognize the version of SIM
if [ "$verString" != "$VERSION_52" ]
then 
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 500
fi

echo
echo "${HPSIMNAME} found."

# Check to see if HP SIM was started
wasSIMStarted="FALSE"
GetSIMStatus

# if HP SIM was running then stop it
if [ $? = 0 ]
then
    # Stop the HP SIM services
    echo
    echo "Stopping the ${HPSIMNAME} daemons..."
    $MXSTOP  

    # Remember that HP SIM was running so we can restart it at the end
    wasSIMStarted="TRUE"
fi

# Delay 30 seconds
x=0
while [ $x -lt 10 ]; do
	echo -n .
	$SLEEP 3
	x=`$EXPR $x + 1`
done
echo

# install new files
x=$(pwd)
cd ${SIM_LIB}
if [ ! -e ${SIM}/bsimbackup/bladeime.bck ]
then
   	mkdir ${SIM}/bsimbackup
        # Backup the current bladeSystem files
        echo "Starting Backup up of existing files..."
	#echo "BACKUP bladeime.jar"
	cp ${SIM_LIB}/bladeime.jar ${SIM}/bsimbackup/bladeime.bck            
	#echo "BACKUP MonteroSystemPageIntegration.xml"
	cp ${SIM3}/config/SystemPage/MonteroSystemPageIntegration.xml ${SIM}/bsimbackup/MonteroSystemPageIntegration.bck
	#echo "BACKUP BladeSystem.xml"
        cp ${SIM3}/config/identification/noderelationships/bladeSystem.xml ${SIM}/bsimbackup/bladeSystem.bck
	#echo "BACKUP MxBPV.jsp"
        cp ${SIM_PORTAL}/home/MxBPV.jsp  ${SIM}/bsimbackup/MxBPV.bck	
	#echo "BACKUP skin.js"
        cp ${SIM_PORTAL}/bladeime/skin/js/skin.js  ${SIM}/bsimbackup/skin.bck
	#echo "BACKUP BladeIMEPrintView.jsp"
        cp ${SIM_PORTAL}/bladeime/bpv/BladeIMEPrintView.jsp  ${SIM}/bsimbackup/BladeIMEPrintView.bck
	#echo "BACKUP BladeIMEZoomOutBPV.jsp"
        cp ${SIM_PORTAL}/bladeime/bpv/BladeIMEZoomOutBPV.jsp  ${SIM}/bsimbackup/BladeIMEZoomOutBPV.bck
        #echo "BACKUP BladeIMENodeCheck.jsp"
        cp ${SIM_PORTAL}/bladeime/bpv/BladeIMENodeCheck.jsp  ${SIM}/bsimbackup/BladeIMENodeCheck.bck
	#echo "BACKUP io_cisco.gif"
        cp ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch/io_cisco.gif ${SIM}/bsimbackup/io_cisco.gif
       #echo "BACKUP doc"
        cp -R /opt/hpwebadmin/webapps/mxhelp/bladeime/en ${SIM}/bsimbackup
	cp -R /opt/hpwebadmin/webapps/mxhelp/bladeime/ja ${SIM}/bsimbackup
       
        # Copy New BladeSystem Manager Files
        echo "Starting Copy of new files..."
        #echo "COPY bladeime.jar"
        cp $x/bladeime.jar ${SIM_LIB}
        #echo "COPY MonteroSystemPageIntegration.xml"
        cp $x/MonteroSystemPageIntegration.xml ${SIM3}/config/SystemPage
        #echo "COPY BladeSystem.xml"
        cp $x/bladeSystem.xml ${SIM3}/config/identification/noderelationships/bladeSystem.xml
        #echo "COPY MxBPV.jsp"
        cp $x/MxBPV.jsp ${SIM_PORTAL}/home/MxBPV.jsp
        #echo "COPY skin.js"
        cp $x/skin.js ${SIM_PORTAL}/bladeime/skin/js/skin.js
	#echo "COPY BladeIMEPrintView.jsp"
        cp $x/BladeIMEPrintView.jsp ${SIM_PORTAL}/bladeime/bpv/BladeIMEPrintView.jsp
        #echo "COPY BladeIMEZoomOutBPV.jsp"
        cp $x/BladeIMEZoomOutBPV.jsp ${SIM_PORTAL}/bladeime/bpv/BladeIMEZoomOutBPV.jsp
         #echo "COPY BladeIMENodeCheck.jsp"
        cp $x/BladeIMENodeCheck.jsp ${SIM_PORTAL}/bladeime/bpv/BladeIMENodeCheck.jsp
	mkdir ${SIM_PORTAL}/bladeime/tabs
        mkdir ${SIM_PORTAL}/bladeime/tabs/system
        #echo "AssociatedBlade.jsp"
        cp $x/AssociatedBlade.jsp ${SIM_PORTAL}/bladeime/tabs/system
        #echo "COPY server_1X_1Y_storage.gif"
        cp $x/server_1X_1Y_storage.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/frontview/server
        #echo "COPY server_1X_2Y_BL685C.gif"
        cp $x/server_1X_2Y_BL685C.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/frontview/server
        #echo "COPY io_mac_x_sm.gif"
        cp $x/io_mac_x_sm.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch
        #echo "COPY io_vc-enet.gif"
        cp $x/io_vc-enet.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch
        #echo "COPY io_cisco.gif"
        cp $x/io_cisco.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch/io_cisco.gif
        #echo COPY help docs
        cp -R $x/en /opt/hpwebadmin/webapps/mxhelp/bladeime
        cp -R $x/ja /opt/hpwebadmin/webapps/mxhelp/bladeime

else	
        # Copy New BladeSystem Manager Files
        echo "Starting Copy of new files..."
	#echo "COPY bladeime.jar"
        cp $x/bladeime.jar ${SIM_LIB}
        #echo "COPY MonteroSystemPageIntegration.xml"
        cp $x/MonteroSystemPageIntegration.xml ${SIM3}/config/SystemPage
        #echo "COPY BladeSystem.xml"
        cp $x/bladeSystem.xml ${SIM3}/config/identification/noderelationships/bladeSystem.xml      
        #echo "COPY MxBPV.jsp"
        cp $x/MxBPV.jsp ${SIM_PORTAL}/home/MxBPV.jsp
	#echo "COPY skin.js"
        cp $x/skin.js ${SIM_PORTAL}/bladeime/skin/js/skin.js
        #echo "COPY BladeIMEPrintView.jsp"
        cp $x/BladeIMEPrintView.jsp ${SIM_PORTAL}/bladeime/bpv/BladeIMEPrintView.jsp        
        #echo "COPY BladeIMEZoomOutBPV.jsp"
        cp $x/BladeIMEZoomOutBPV.jsp ${SIM_PORTAL}/bladeime/bpv/BladeIMEZoomOutBPV.jsp
	#echo "COPY BladeIMENodeCheck.jsp"
        cp $x/BladeIMENodeCheck.jsp ${SIM_PORTAL}/bladeime/bpv/BladeIMENodeCheck.jsp
	mkdir ${SIM_PORTAL}/bladeime/tabs
        mkdir ${SIM_PORTAL}/bladeime/tabs/system
	#echo "AssociatedBlade.jsp"
        cp $x/AssociatedBlade.jsp ${SIM_PORTAL}/bladeime/tabs/system
        #echo "COPY server_1X_1Y_storage.gif"
        cp $x/server_1X_1Y_storage.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/frontview/server		
        #echo "COPY server_1X_2Y_BL685C.gif"
        cp $x/server_1X_2Y_BL685C.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/frontview/server
        #echo "COPY io_mac_x_sm.gif"
        cp $x/io_mac_x_sm.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch		
        #echo "COPY io_vc-enet.gif"
        cp $x/io_vc-enet.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch
        #echo "COPY io_cisco.gif"
        cp $x/io_cisco.gif ${SIM_PORTAL}/bladeime/skin/images/c-class/rearview/switch/io_cisco.gif 
        #echo COPY help docs
	cp -R $x/en /opt/hpwebadmin/webapps/mxhelp/bladeime
	cp -R $x/ja /opt/hpwebadmin/webapps/mxhelp/bladeime
 fi
	echo "Restarting ${HPSIMNAME} daemons...."
	echo "This would take couple of minutes...."
	$MXSTART
	sleep 120
	cd ${SIM_TOOLS}
	if [ -e bladeimeVersion.xml ] 
		then
		cp bladeimeVersion.xml ${SIM}/bsimbackup/bladeimeVersion.bck
	 	cp $x/bladeimeVersion.xml . 
	 	#echo "HP BLADESYSTEM INTERAGTED MANAGER VERSION FILE COPIED"
	   
	  	if [ -e ${SIM_BIN}/mxtool ] 
	  		then
	   	        ${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/bladeimeVersion.xml
		        ${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/bladeimeVersion.xml
	   	        echo "HP BLADESYSTEM INTEGRATED MANAGER 2.2 UPDATE COMPLETE. YOU CAN DELETE THE EXTRACTED FOLDER"		 
	  	else
		    	echo "MXTOOL DOES NOT EXIST"	
		    	echo "HP BLADESYSTEM INTEGRATED MANAGER 2.2 UPDATE FAILED"
		exit			
		fi	
				  
	else
		echo "HP BLADESYSTEM INTEGRATED MANAGER 2.2 UPDATE FAILED"
        exit
	fi		

