/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.database.DatabaseManager;
import com.hp.mx.portal.ui.MxLoginBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MonteroSQLUtils {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private StringBuffer m_systemNameQuery = null;
    private StringBuffer m_bldGUIDQuery = null;
    private PreparedStatement m_sqlsysName = null;
    private Connection m_connection = null;
    private boolean m_bNewConnection = false;
    private PreparedStatement m_sqlbldGUID = null;
    private MxLoginBean m_loginBean = null;

    public MonteroSQLUtils(MxLoginBean loginBean) {
        this.m_loginBean = loginBean;
        this.m_systemNameQuery = new StringBuffer("SELECT CIM_CHASSIS.dc_SystemName FROM CIM_CHASSIS INNER JOIN CIM_RACK ");
        this.m_systemNameQuery.append("ON CIM_CHASSIS.NODEID = CIM_RACK.NODEID AND CIM_CHASSIS.SNAPSHOTID = ");
        this.m_systemNameQuery.append("CIM_RACK.SNAPSHOTID WHERE CIM_CHASSIS.SERIALNUMBER=?");
        this.m_bldGUIDQuery = new StringBuffer("select MxGUID from devices where Name =? or fulldnsname =?");
    }

    public PreparedStatement createPreparedStatement(String query) {
        PreparedStatement statement;
        block3: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("MonteroSQLUtils.createPreparedStatement(" + query + ")"));
            }
            statement = null;
            try {
                statement = this.m_connection.prepareStatement(query);
            }
            catch (SQLException sqlException) {
                if (!log_.isEnabledFor((Priority)Level.ERROR)) break block3;
                log_.error((Object)("MonteroSQLUtils.createPreparedStatement(" + query + ")"), (Throwable)sqlException);
            }
        }
        return statement;
    }

    public void pollConnection() {
        block4: {
            try {
                if (this.m_connection == null || this.m_connection.isClosed()) {
                    this.m_connection = DatabaseManager.getDefaultDatabase().getConnection("MonteroSQLUtils.pollConnection()");
                    this.m_bNewConnection = true;
                } else {
                    this.m_bNewConnection = false;
                }
            }
            catch (SQLException sqlException) {
                if (!log_.isEnabledFor((Priority)Level.ERROR)) break block4;
                log_.error((Object)"MonteroSQLUtils.pollConnection()", (Throwable)sqlException);
            }
        }
    }

    public String getBladeGuidIDPowerSupply(String serialNo) {
        String mxGuidBld;
        block11: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("MonteroSQLUtils.getBladeGuidIDPowerSupply(" + serialNo + ")"));
            }
            ResultSet resultSetsysName = null;
            ResultSet resultSetbldGUID = null;
            mxGuidBld = null;
            try {
                String systemName = null;
                this.pollConnection();
                if (this.m_sqlsysName == null || this.m_bNewConnection) {
                    this.m_sqlsysName = this.createPreparedStatement(this.m_systemNameQuery.toString());
                    this.m_sqlsysName.clearParameters();
                    this.m_sqlsysName.setString(1, serialNo);
                }
                resultSetsysName = this.m_sqlsysName.executeQuery();
                while (resultSetsysName.next()) {
                    systemName = resultSetsysName.getString(1);
                    if (systemName != null && !systemName.equals("")) {
                        this.pollConnection();
                        if (this.m_sqlbldGUID == null || this.m_bNewConnection) {
                            this.m_sqlbldGUID = this.createPreparedStatement(this.m_bldGUIDQuery.toString());
                            this.m_sqlbldGUID.clearParameters();
                            this.m_sqlbldGUID.setString(1, systemName);
                            this.m_sqlbldGUID.setString(2, systemName);
                        }
                        resultSetbldGUID = this.m_sqlbldGUID.executeQuery();
                        while (resultSetbldGUID.next()) {
                            mxGuidBld = resultSetbldGUID.getString(1);
                        }
                    }
                    if (mxGuidBld == null || mxGuidBld.equals("")) continue;
                }
                if (log_.isEnabledFor((Priority)Level.INFO)) {
                    log_.info((Object)("MonteroSqlUtils.getBladeGuidIDPowerSupply(" + serialNo + "): guid of the device " + mxGuidBld));
                }
            }
            catch (SQLException sqlException) {
                if (log_.isEnabledFor((Priority)Level.ERROR)) {
                    log_.error((Object)("MonteroSqlUtils.getBladeGuidIDPowerSupply(" + serialNo + "): SQLException" + sqlException));
                }
            }
            catch (Exception e) {
                if (!log_.isEnabledFor((Priority)Level.ERROR)) break block11;
                log_.error((Object)("MonteroSqlUtils.getBladeGuidIDPowerSupply(" + serialNo + "): Exception" + e));
            }
        }
        return mxGuidBld;
    }

    public MxLoginBean getM_loginBean() {
        return this.m_loginBean;
    }
}

