/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.protocol.snmp.SnmpRequest;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.associations.SnmpProtocolDataHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.nodesecurity.MxNodeSecurityHandler;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MonteroSNMPUtils {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private MxLoginBean m_loginBean;

    public MonteroSNMPUtils(MxLoginBean loginBean) {
        this.m_loginBean = loginBean;
    }

    public synchronized ArrayList getSNMPData(MxNode deviceObject, String pOid, boolean convert) {
        BladeIMELogger.log("Start:MonteroSNMPUtils.getSNMPData()");
        BladeIMELogger.log("pOid:" + pOid);
        BladeIMELogger.log("device Name:" + deviceObject.getNameString());
        String status = null;
        try {
            status = deviceObject.getOverallStatus().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> snmpData = new ArrayList<String>();
        if (status != null && !status.equalsIgnoreCase(DeviceStatusType.CRITICAL.toString())) {
            if (!this.checkSNMP(deviceObject)) {
                if (log_.isEnabledFor((Priority)Level.ERROR)) {
                    log_.error((Object)("MonteroSNMPUtils.getSNMPData(" + deviceObject + ", " + pOid + ", " + convert + "): SNMP Not supported , SNMP Data will not be retrieved for this device."));
                }
            } else {
                SnmpRequest snmpReq = new SnmpRequest();
                snmpReq.setDeviceAddress(deviceObject.getWorkingAddress());
                snmpReq.setCommunityName(MxNodeSecurityHandler.getSnmpMonitorCommunityString((MxNode)deviceObject));
                snmpReq.setTimeout("" + deviceObject.getSnmpTimeOut());
                snmpReq.setNumberOfRetries("" + deviceObject.getSnmpRetry());
                SnmpResponseVarBind vb = null;
                snmpReq.setAsn1Numbers(pOid + "[0]");
                while (true) {
                    snmpReq.SnmpGetNext();
                    SnmpResponse curResp = snmpReq.getResponseVarbinds();
                    vb = curResp.findById(0);
                    if (vb == null || vb.isError()) {
                        if (!log_.isEnabledFor((Priority)Level.DEBUG)) break;
                        log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + "*End of reading the MIB Tree for the device with IP*:" + deviceObject.getWorkingAddress()));
                        break;
                    }
                    String val = vb.getValue();
                    String oid = vb.getOid();
                    if (!oid.startsWith(pOid)) break;
                    if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                        log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + "Value from the Tree:" + val));
                    }
                    if (convert) {
                        try {
                            val = Integer.toString(vb.getIntValue());
                        }
                        catch (NumberFormatException numFmtException) {
                            val = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
                            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                                log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + numFmtException));
                            }
                        }
                        catch (Exception e) {
                            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                                log_.error((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":Exception while retreiving data from SNMP:" + e));
                            }
                            e.printStackTrace();
                        }
                    }
                    if (val == null || val == "" || val.length() == 0) {
                        val = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
                    }
                    snmpData.add(val.trim());
                    if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                        log_.debug((Object)("SNMPDataCollector.getSNMPData(" + deviceObject + "," + pOid + "," + convert + ")" + ":" + "Value from the Tree:" + val));
                    }
                    snmpReq.clearSnmpReqInfo();
                    snmpReq.addSnmpGetVarbind(oid, "0");
                }
            }
        }
        BladeIMELogger.log("End:MonteroSNMPUtils.getSNMPData()");
        return snmpData;
    }

    public static HashMap getMIBData(String oid, SnmpProtocolDataHandler snmpPdh, boolean isOidKey) {
        BladeIMELogger.log("Start:MonteroSNMPUtils.getMIBData(" + oid + ")");
        HashMap<String, String> dataFrmMIB = new HashMap<String, String>();
        String oidFrmMIB = null;
        String uid = null;
        SnmpRequest req = snmpPdh.getSnmpRequest();
        if (req == null) {
            BladeIMELogger.log("SnmpRequest is null");
            BladeIMELogger.log("End:MonteroSNMPUtils.getMIBData(" + oid + ")");
            return dataFrmMIB;
        }
        snmpPdh.getSnmpRequest().setAsn1Numbers(oid);
        String data = null;
        while (true) {
            snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
            uid = oid.substring(oid.indexOf(91) + 1, oid.indexOf(93));
            SnmpResponseVarBind resVarBnd = uid == null || uid.length() <= 0 ? curResp.findResponse(oid) : curResp.findById(Integer.parseInt(uid));
            if (resVarBnd == null || resVarBnd.isError()) break;
            oidFrmMIB = resVarBnd.getOid();
            BladeIMELogger.log("oidFrmMIB:" + oidFrmMIB);
            BladeIMELogger.log("vb0.getValueType():" + resVarBnd.getValueType());
            if (!oidFrmMIB.startsWith(oid.substring(0, oid.indexOf(91)))) break;
            data = resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : (resVarBnd.getValueType().equals("INTEGER") ? resVarBnd.getIntValue() + "" : (resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : (resVarBnd.getValueType().equals("OCTETSTRING") ? resVarBnd.getMACAddrValue() : resVarBnd.getValue())));
            BladeIMELogger.log("dataFrmMIB :" + data);
            if (data == null || data.length() == 0 || data.equals("")) {
                data = "";
            }
            if (data != null) {
                if (!isOidKey) {
                    dataFrmMIB.put(data, oidFrmMIB);
                } else {
                    dataFrmMIB.put(oidFrmMIB, data);
                }
            }
            snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            if (uid == null || uid.length() <= 0) {
                uid = "0";
            }
            snmpPdh.getSnmpRequest().addSnmpGetVarbind(oidFrmMIB, uid);
        }
        BladeIMELogger.log("End:MonteroSNMPUtils.getMIBData(" + oid + ")");
        return dataFrmMIB;
    }

    public static String getMIBDataValue(String oid, SnmpProtocolDataHandler snmpPdh) {
        BladeIMELogger.log("Start:MonteroSNMPUtils.getMIBDataValue(" + oid + ")");
        String dataFrmMIB = null;
        String oidFrmMIB = null;
        String uid = null;
        SnmpRequest req = snmpPdh.getSnmpRequest();
        if (req == null) {
            BladeIMELogger.log("SnmpRequest is null");
            BladeIMELogger.log("End:MonteroSNMPUtils.getMIBData(" + oid + ")");
            return dataFrmMIB;
        }
        snmpPdh.getSnmpRequest().setAsn1Numbers(oid);
        snmpPdh.getSnmpRequest().SnmpGet();
        SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
        uid = oid.substring(oid.indexOf(91) + 1, oid.indexOf(93));
        SnmpResponseVarBind resVarBnd = uid == null || uid.length() <= 0 ? curResp.findResponse(oid) : curResp.findById(Integer.parseInt(uid));
        if (resVarBnd == null || resVarBnd.isError()) {
            return dataFrmMIB;
        }
        oidFrmMIB = resVarBnd.getOid();
        BladeIMELogger.log("oidFrmMIB:" + oidFrmMIB);
        BladeIMELogger.log("vb0.getValueType():" + resVarBnd.getValueType());
        dataFrmMIB = resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : (resVarBnd.getValueType().equals("INTEGER") ? resVarBnd.getIntValue() + "" : (resVarBnd.getValueType().equals("IPADDRESS") ? resVarBnd.getIPAddrValue() : resVarBnd.getValue()));
        BladeIMELogger.log("dataFrmMIB :" + dataFrmMIB);
        BladeIMELogger.log("End:MonteroSNMPUtils.getMIBDataValue(" + oid + ")");
        return dataFrmMIB;
    }

    private boolean checkSNMP(MxNode deviceObject) {
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        boolean retVal = true;
        if (!snmpEnabled.equals("checked")) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.error((Object)("SNMPDataCollector.checkSNMP(" + deviceObject + ")" + ":" + "SNMP is disabled for " + deviceObject.getWorkingAddress()));
            }
            retVal = false;
        }
        if (deviceObject.getWorkingAddress() == null) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.error((Object)("SNMPDataCollector.checkSNMP(" + deviceObject + ")" + ":" + "Ipaddress is null for this deviceObject. "));
            }
            retVal = false;
        }
        if (!deviceObject.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                log_.error((Object)("SNMPDataCollector.checkSNMP(" + deviceObject + ")" + ":" + "SNMP Protocol not supported by device with IP:" + deviceObject.getWorkingAddress()));
            }
            retVal = false;
        }
        return retVal;
    }
}

