/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OLBlade;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.Iterator;

public class AssociatedDevice {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(AssociatedDevice.class);
    private MxNode m_devNode;
    private MxNode m_assocDevNode;
    private String m_assocDevType;
    private boolean m_isAssocNodePresent;
    private int m_associatedBay;

    public AssociatedDevice(MxNode node, String assocDevType) {
        this.m_devNode = node;
        this.m_isAssocNodePresent = false;
        this.m_assocDevType = assocDevType;
        this.m_associatedBay = -1;
        if (this.m_devNode != null) {
            this.setAssociatedNode();
        }
    }

    private void setAssociatedNode() {
        LOGGER.enter("AssciatedBlade.getAssociatedNode()");
        OAHelper oaHelper = OAHelper.getOAHelper();
        OLBlade bladeObj = null;
        try {
            bladeObj = (OLBlade)oaHelper.getOLDevice(this.m_devNode, this.m_devNode);
        }
        catch (OAException e) {
            LOGGER.fine("OAException:" + e);
            return;
        }
        String asscSrvSlot = bladeObj.getAssociatedBay();
        LOGGER.fine("Node Name:" + this.m_devNode.getNameString());
        LOGGER.fine("DeviceType:" + this.m_devNode.getDeviceType());
        LOGGER.fine("asscSrvSlot:" + asscSrvSlot);
        if (asscSrvSlot != null && asscSrvSlot.length() > 0) {
            int assSrvBay = Integer.parseInt(asscSrvSlot);
            try {
                NodeAssociations srvNodeAsscs = NodeAssociationsManager.getDefaultManager().getNodeAssociations(this.m_devNode.getDeviceKey());
                int enclDevKey = srvNodeAsscs.getParentDeviceKey();
                ArrayList deviceMxNodeList = MxBPVServerEnclosure.getDeviceAtSlotNumber(enclDevKey, assSrvBay);
                Iterator iter = deviceMxNodeList.iterator();
                MxNode node = null;
                while (iter.hasNext()) {
                    NodeAssociations nodeNodeAsscs;
                    node = (MxNode)iter.next();
                    if (node == null || (nodeNodeAsscs = NodeAssociationsManager.getDefaultManager().getNodeAssociations(node.getDeviceKey())).getSlotNumber() != assSrvBay || !node.getDeviceType().equalsIgnoreCase(this.m_assocDevType)) continue;
                    this.m_isAssocNodePresent = true;
                    this.m_assocDevNode = node;
                    this.m_associatedBay = assSrvBay;
                    break;
                }
            }
            catch (NodeAssociationsPersistenceException e) {
                LOGGER.fine("Unable to obtain the NodeAssociationsManagerthe group will not be disaplyed" + (Object)((Object)e));
                this.m_isAssocNodePresent = false;
            }
        }
        LOGGER.fine("isAssocNodePresent:" + this.m_isAssocNodePresent);
        LOGGER.fine("m_associatedBay:" + this.m_associatedBay);
        LOGGER.exit("AssocatedBlade.meetsCondition()");
    }

    public boolean isAssocNodePresent() {
        return this.m_isAssocNodePresent;
    }

    public MxNode getAssociatedDevNode() {
        return this.m_assocDevNode;
    }

    public int getAssociatedDevBay() {
        return this.m_associatedBay;
    }
}

