/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.skin;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OnboardAdministrator;
import com.hp.mx.portal.portMapping.DevicePortMapping;
import com.hp.mx.portal.skin.SkinParser;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;

public class PortMappingSkin {
    MxNode m_node = null;
    JspWriter m_out = null;
    MxLoginBean m_loginBean;
    String m_portMapXml = null;

    public void initializeNode(MxNode node, JspWriter out, MxLoginBean loginBean) {
        this.m_node = node;
        BladeIMELogger.log("Node initialized in the PortMappingSkin is:" + this.m_node);
        this.m_out = out;
        this.m_loginBean = loginBean;
    }

    public void applyPortMappingSkin(boolean isExpired) {
        BladeIMELogger.log("PortMapping.applyPortMappingSkin(isExpired " + isExpired);
        DevicePortMapping devicePortMapping = new DevicePortMapping(this.m_loginBean, this.m_node);
        String PORTMAP2 = "PortMap";
        int enclDeviceKey = -1;
        if (this.m_node.getDeviceType().equalsIgnoreCase("Server")) {
            try {
                if (isExpired) {
                    enclDeviceKey = NodeAssociationsManager.getDefaultManager().getAssociatedDeviceKey(this.m_node.getDeviceKey(), "ServerToEnclosure");
                    BladeIMELogger.log("the Page is expired.So Update the Port Mapping information from Underdog");
                    this.updatePortMappingInfo(enclDeviceKey);
                    this.m_portMapXml = devicePortMapping.renderXMLForBlade();
                }
            }
            catch (NodeAssociationsPersistenceException e) {
                BladeIMELogger.log((Exception)((Object)e), "NodeAssociationsPersistenceException in PortMappingSkin.applyPortMappingSkin");
            }
            if (this.m_portMapXml == null || this.m_portMapXml.length() == 0) {
                BladeIMELogger.log("PortMapping XML is null.So construct the XML by fetching the values from DB");
                this.m_portMapXml = devicePortMapping.renderXMLForBlade();
            }
            BladeIMELogger.log("The device type:Server");
            this.applyXSL("ServerPortMap");
        } else if (this.m_node.getDeviceType().equalsIgnoreCase("Switch")) {
            try {
                if (isExpired) {
                    enclDeviceKey = NodeAssociationsManager.getDefaultManager().getAssociatedDeviceKey(this.m_node.getDeviceKey(), "SwitchToEnclosure");
                    BladeIMELogger.log("The Page is expired.So Update the Port Mapping information from Underdog");
                    this.updatePortMappingInfo(enclDeviceKey);
                    this.m_portMapXml = devicePortMapping.renderXMLForSwitch();
                }
            }
            catch (NodeAssociationsPersistenceException e) {
                BladeIMELogger.log((Exception)((Object)e), "NodeAssociationsPersistenceException in PortMappingSkin.applyPortMappingSkin");
            }
            if (this.m_portMapXml == null || this.m_portMapXml.length() == 0) {
                BladeIMELogger.log("PortMapping XML is null.So construct the XML by fetching the values from DB");
                this.m_portMapXml = devicePortMapping.renderXMLForSwitch();
            }
            BladeIMELogger.log("The device type:Switch");
            this.applyXSL("SwitchPortMap");
        }
    }

    private void applyXSL(String nameOfXSL) {
        try {
            SkinParser skinParser = new SkinParser();
            skinParser.configure(nameOfXSL);
            if (this.m_portMapXml != null) {
                skinParser.parseXML(this.m_portMapXml, this.m_out);
            } else {
                BladeIMELogger.log("The XML For Port Mapping is null");
            }
        }
        catch (BladeSystemException e) {
            e.printStackTrace();
        }
    }

    public String getSSOLinkToOA() {
        BladeIMELogger.log("PortMappingSkin.getSSOLinkToOA");
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.m_node.getDeviceKey());
            MxNode enclNode = nodeAssociations.getParent();
            String ssoURL = "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + enclNode.getSerialNumber() + "&deviceType=OA";
            return ssoURL;
        }
        catch (NodeAssociationsPersistenceException e) {
            BladeIMELogger.log((Exception)((Object)e), "NodeAssociationsPersistenceException in PortMappingSkin.getSSOLinkToOA");
            return null;
        }
    }

    public void updatePortMappingInfo(int enclDeviceKey) {
        BladeIMELogger.log("PortMappingSkin.updatePortMappingInfo(int " + enclDeviceKey + ")");
        try {
            MxNode enclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDeviceKey);
            BladeIMELogger.log("The Node Name is:" + enclDevice);
            try {
                Vector OADeviceKeys = NodeAssociationsManager.getDefaultManager().getAssociatedDevicesUsingATNs(enclDeviceKey, "MgmtProcToEnclosure");
                MxNode oANode = this.getPrimaryOANode(OADeviceKeys);
                BladeIMELogger.log("The Primary Node:" + oANode);
                OAHelper.getOAHelper().refreshData(oANode, this.m_node.getDeviceKey());
            }
            catch (NodeAssociationsPersistenceException e) {
                BladeIMELogger.log((Exception)((Object)e), "NodeAssociationsPersistenceException in PortMappingSkin.updatePortMappingInfo");
            }
            catch (BladeSystemException e) {
                BladeIMELogger.log(e, "BladeSystemException in PortMappingSkin.updatePortMappingInfo");
            }
        }
        catch (MxUndefinedNodeException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxUndefinedNodeException in PortMappingSkin.updatePortMappingInfo");
        }
    }

    private MxNode getPrimaryOANode(Vector OADeviceKeys) throws BladeSystemException {
        BladeIMELogger.log("MxBPVOverlordEnclosure.getPrimaryOANode(Vector " + OADeviceKeys + ")");
        OnboardAdministrator oAObj = null;
        OAHelper oaHelper = OAHelper.getOAHelper();
        int noOfOADevices = OADeviceKeys.size();
        MxNode oADevice = null;
        try {
            for (int i = 0; i < noOfOADevices; ++i) {
                oADevice = MxNodeController.getDefaultControllerNoEx().getNodeByKey(Integer.parseInt(OADeviceKeys.get(i).toString()));
                oAObj = (OnboardAdministrator)oaHelper.getOLDevice(oADevice, oADevice);
                if (!oAObj.getIsPrimary()) continue;
                BladeIMELogger.log("The Primary OA node:" + oADevice.getNameString());
                return oADevice;
            }
        }
        catch (MxUndefinedNodeException e) {
            e.printStackTrace();
        }
        catch (OAException oae) {
            oae.printStackTrace();
        }
        throw new BladeSystemException("OA Not found to update the Port Mapping details");
    }
}

