/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance;

import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.license.PMPLicense;
import com.hp.mx.portal.performance.DeviceInfoBean;
import com.hp.mx.portal.performance.UITable;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.MxCMS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Utilization {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private UITable m_cpuUITable;
    private UITable m_diskUITable;
    private UITable m_phyMemUITable;
    private UITable m_fanUITable;
    private UITable m_tempUITable;
    private static String[] m_dskHeader;
    private static String[] m_memHeader;
    private static String[] m_cpuHeader;
    private static String[] m_fanHeader;
    private static String[] m_temperatureHeader;
    private MonteroBean m_monteroBean;
    private DeviceInfoBean m_deviceInfoBean;
    private JspWriter m_out;
    private MxNode m_node;
    private boolean m_isUpdate;
    private boolean m_isLicensedPMP = false;
    MonteroResourceManager m_manager = MonteroResourceManager.getInstance();

    public void initialize(DeviceInfoBean deviceInfoBean, JspWriter out) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Start:Utilization.initialize(" + deviceInfoBean + ")"));
        }
        BladeIMELogger.log("Out object:" + out);
        BladeIMELogger.log("m_Out object:" + this.m_out);
        if (this.m_out != out) {
            this.m_out = out;
        }
        if (this.m_node == null || !this.m_node.getGUID().toString().equals(deviceInfoBean.getMxNode().getGUID().toString())) {
            BladeIMELogger.log("We are in a new node.");
            BladeIMELogger.log("Initializing Utilization.");
            this.m_monteroBean = deviceInfoBean.getMonteroBean();
            this.m_deviceInfoBean = deviceInfoBean;
            this.m_node = this.m_deviceInfoBean.getMxNode();
            m_cpuHeader = MonteroResourceManager.getInstance().getCpuUtilTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            m_dskHeader = MonteroResourceManager.getInstance().getDiskInfoTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            m_memHeader = MonteroResourceManager.getInstance().getmainMemInfoTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            m_fanHeader = MonteroResourceManager.getInstance().getFanTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
            m_temperatureHeader = MonteroResourceManager.getInstance().getTemperatureTableHeaders(this.m_monteroBean.getLoginBean().getLocale());
        }
    }

    private ArrayList getDiskUtilizationTable() {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"Start:Utilization.getDiskUtilizationTable()");
        }
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList diskUtilData = new ArrayList();
        diskUtilData = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.2", false);
        diskUtilData.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.3", true));
        diskUtilData.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.4.1.1.5", true));
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Size Of diskUtilData:" + diskUtilData.size()));
            m_log.debug((Object)"End:Utilization.getDiskUtilizationTable()");
        }
        return diskUtilData;
    }

    private void renderCPUUtilTable() {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Start:Utilization.renderCPUUtilTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString()));
        }
        BladeIMELogger.log("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            BladeIMELogger.log("Getting the latest data from SNMP for CPU Utililzation");
            MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
            this.m_cpuUITable = new UITable(MonteroResourceManager.getInstance().getString("PROCESSOR", this.m_monteroBean.getLoginBean().getLocale()), m_cpuHeader);
            ArrayList tableList = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.3.1.1.3", true);
            if (tableList.size() == 0) {
                this.m_cpuUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), m_cpuHeader.length);
            } else {
                for (int i = 0; i < tableList.size(); ++i) {
                    this.m_cpuUITable.addRow(new String[]{i + "", (String)tableList.get(i)});
                }
            }
            this.m_cpuUITable.terminateTable();
        }
        this.m_cpuUITable.displayTable(this.m_out);
    }

    private void renderDiskUtilTable() {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Start:Utilization.renderDiskUtilTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString()));
        }
        BladeIMELogger.log("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            BladeIMELogger.log("Getting the latest data from SNMP for Disk Utililzation");
            this.m_diskUITable = new UITable(MonteroResourceManager.getInstance().getString("LOGICALDISK", this.m_monteroBean.getLoginBean().getLocale()), m_dskHeader);
            String numDrivesStr = this.m_deviceInfoBean.getNumberLogicalDrives() + "";
            int numDrives = Integer.parseInt(numDrivesStr);
            if (numDrives <= 0) {
                this.m_diskUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), m_dskHeader.length);
            } else {
                ArrayList tableList = this.getDiskUtilizationTable();
                if (tableList.size() == 0) {
                    this.m_diskUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), m_memHeader.length);
                } else {
                    numDrives = tableList.size() / 3;
                    for (int i = 0; i < numDrives; ++i) {
                        this.m_diskUITable.addRow(new String[]{(String)tableList.get(i), (String)tableList.get(i + numDrives), (String)tableList.get(i + numDrives * 2)});
                    }
                }
            }
            this.m_diskUITable.terminateTable();
        }
        this.m_diskUITable.displayTable(this.m_out);
    }

    private void renderPhyMemoryTable() {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Start:Utilization.renderPhyMemoryTable():m_isUpdate" + this.m_isUpdate + "Node Name:" + this.m_node.getNameString()));
        }
        BladeIMELogger.log("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            BladeIMELogger.log("Getting the latest data from SNMP for Phy Mem Utililzation");
            MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
            this.m_phyMemUITable = new UITable(MonteroResourceManager.getInstance().getString("MEMORY", this.m_monteroBean.getLoginBean().getLocale()), m_memHeader);
            ArrayList tableList = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.11.2.13", true);
            if (tableList.size() == 0) {
                this.m_phyMemUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), m_memHeader.length);
            } else {
                this.m_phyMemUITable.addRow(new String[]{(String)tableList.get(0), (String)tableList.get(1), (String)tableList.get(2), (String)tableList.get(3)});
            }
            this.m_phyMemUITable.terminateTable();
        }
        this.m_phyMemUITable.displayTable(this.m_out);
    }

    private void renderPMP() throws MxInvalidTransactionException, IOException {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"Start:Utilization.renderPMP()");
        }
        if (this.m_isUpdate) {
            PMPLicense pmpLicMgr = PMPLicense.getLicenseManager();
            this.m_isLicensedPMP = pmpLicMgr.isNodePMPLicensed(this.m_node.getDeviceKey());
        }
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Is the device Licensed for PMP:" + this.m_isLicensedPMP));
        }
        this.m_out.print("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" class=\"dataTable\"><caption>" + MonteroResourceManager.getInstance().getString("PMPTOOLS", this.m_monteroBean.getLoginBean().getLocale()) + "</caption>");
        if (this.m_isLicensedPMP) {
            String[][] toolList = MonteroResourceManager.getInstance().getPMPTools(this.m_monteroBean.getLoginBean().getLocale());
            for (int i = 0; i < toolList.length; ++i) {
                this.m_out.println("<tr class=\"altRowColor\">");
                try {
                    String tId = this.m_monteroBean.getToolId(toolList[i][1]);
                    this.m_out.println("<td class=\"propertyValue\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"javascript:MxPortalWorkspaceCreate('" + tId + "')\">" + toolList[i][0] + "</a></td>");
                }
                catch (BladeSystemException bex) {
                    BladeIMELogger.log("The tool with id" + toolList[i][1] + "was not found.");
                }
                this.m_out.println("</tr>");
            }
        } else {
            String jaPMPURL = "http://www.hp.com/jp/servers/pmp";
            String enPMPURL = "http://www.hp.com/servers/proliantessentials/pmp";
            String pmpURL = null;
            pmpURL = this.m_monteroBean.getLoginBean().getLocale().equals(Locale.JAPANESE) ? "http://www.hp.com/jp/servers/pmp" : (this.m_monteroBean.getLoginBean().getLocale().equals(Locale.US) ? "http://www.hp.com/servers/proliantessentials/pmp" : "http://www.hp.com/servers/proliantessentials/pmp");
            this.m_out.print("<tr class=\"altRowColor\"><td class=\"propertyValue\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b><a href =\" " + pmpURL + "\" TARGET=\"RESOURCE WINDOW\">" + MonteroResourceManager.getInstance().getPMP_Msg(this.m_monteroBean.getLoginBean().getLocale()) + "</a></td></tr>");
        }
        this.m_out.print("</table>");
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"End:Utilization.renderPMP()");
        }
    }

    public void renderPerformanceTab(boolean update) throws IOException, MxInvalidTransactionException {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Start:Utilization.renderPerformanceTab(" + update + ")" + "m_isUpdate: " + this.m_isUpdate + " Node Name:" + this.m_node.getNameString()));
        }
        this.m_isUpdate = update;
        this.m_out.print("<br>");
        this.m_out.print(MonteroResourceManager.getInstance().getString("CPU_TYPE", this.m_monteroBean.getLoginBean().getLocale()) + ": " + this.m_deviceInfoBean.getCpuType());
        this.m_out.print("<br><br>");
        this.renderCPUUtilTable();
        this.m_out.print("<br>");
        this.renderDiskUtilTable();
        this.m_out.print("<br>");
        this.renderPhyMemoryTable();
        this.m_out.print("<br>");
        this.renderFanDetails();
        this.m_out.print("<br>");
        this.renderTemperatureDetails();
        this.m_out.print("<br>");
        boolean isMSSQL = false;
        String dbType = GlobalSettings.getProperty((String)"dbType");
        if (dbType != null && dbType.equalsIgnoreCase("mssql")) {
            isMSSQL = true;
        }
        if (MxCMS.isWindows() && isMSSQL) {
            this.renderPMP();
        }
    }

    private ArrayList getFanDetails() {
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList fanDetails = new ArrayList();
        fanDetails = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.2.0", true);
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.3.0", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.4.0", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.6.0", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.8.0", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.9.0", true));
        fanDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.7.1.10.0", true));
        return fanDetails;
    }

    public void renderFanDetails() {
        BladeIMELogger.log("Utilization:renderFanDetails()");
        BladeIMELogger.log("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            BladeIMELogger.log("Getting the latest data from SNMP for Fan Details");
            this.m_fanUITable = new UITable(MonteroResourceManager.getInstance().getString("FanTableName", this.m_monteroBean.getLoginBean().getLocale()), m_fanHeader);
            ArrayList fanDetails = this.getFanDetails();
            if (fanDetails.size() == 0) {
                this.m_fanUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), m_fanHeader.length);
            } else {
                int noOfCol = fanDetails.size() / (m_fanHeader.length + 1);
                for (int i = 0; i < noOfCol; ++i) {
                    BladeIMELogger.log("Display the Fan row if the fan is present");
                    if (!fanDetails.get(i + noOfCol * 2).toString().equalsIgnoreCase("3")) continue;
                    this.m_fanUITable.addRow(new String[][]{{fanDetails.get(i).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol).toString()) - 1, 0, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {fanDetails.get(i + noOfCol * 4).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 3).toString()) - 1, 1, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 5).toString()) - 1, 2, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(fanDetails.get(i + noOfCol * 6).toString()) - 1, 3, this.m_monteroBean.getLoginBean().getLocale()), "false"}});
                }
            }
            this.m_fanUITable.terminateTable();
        }
        this.m_fanUITable.displayTable(this.m_out);
    }

    private ArrayList getTemperatureDetails() {
        BladeIMELogger.log("Utilization:getTemperatureDetails()");
        MonteroSNMPUtils snmpBean = this.m_deviceInfoBean.getMonteroBean().getSNMPUtil();
        ArrayList thermalDetails = new ArrayList();
        thermalDetails = snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.2.0", true);
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.3.0", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.4.0", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.5.0", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.6.0", true));
        thermalDetails.addAll(snmpBean.getSNMPData(this.m_node, "1.3.6.1.4.1.232.6.2.6.8.1.7.0", true));
        return thermalDetails;
    }

    public void renderTemperatureDetails() {
        BladeIMELogger.log("Utilization:renderTemperatureDetails()");
        BladeIMELogger.log("m_isUpdate:" + this.m_isUpdate);
        if (this.m_isUpdate) {
            BladeIMELogger.log("Getting the latest data from SNMP for Temperature Details");
            this.m_tempUITable = new UITable(MonteroResourceManager.getInstance().getString("TemperatureTableName", this.m_monteroBean.getLoginBean().getLocale()), m_temperatureHeader);
            ArrayList temperatureDetails = this.getTemperatureDetails();
            if (temperatureDetails.size() == 0) {
                this.m_tempUITable.addRow(MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_monteroBean.getLoginBean().getLocale()), m_temperatureHeader.length);
            } else {
                int noOfCol = temperatureDetails.size() / m_temperatureHeader.length;
                for (int i = 0; i < noOfCol; ++i) {
                    this.m_tempUITable.addRow(new String[][]{{temperatureDetails.get(i).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol).toString()) - 1, 0, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {temperatureDetails.get(i + noOfCol * 2).toString(), "false"}, {temperatureDetails.get(i + noOfCol * 3).toString(), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol * 4).toString()) - 1, 1, this.m_monteroBean.getLoginBean().getLocale()), "false"}, {this.m_manager.getFanAndThermalValue(Integer.parseInt(temperatureDetails.get(i + noOfCol * 5).toString()) - 1, 4, this.m_monteroBean.getLoginBean().getLocale()), "false"}});
                }
            }
            this.m_tempUITable.terminateTable();
        }
        this.m_tempUITable.displayTable(this.m_out);
    }
}

