/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DeviceInfoBean {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private MxNode m_node = null;
    MonteroBean m_MonteroBean = null;
    private int m_deviceKey = -1;
    private String m_strCpuType = "";
    private int m_numLogicalDrives = 0;
    private PreparedStatement m_sqlCPUQuery = null;
    private PreparedStatement m_sqlNumDrivesQuery = null;

    public void initialize(MonteroBean monteroBean, int deviceKey) {
        block7: {
            if (this.m_deviceKey != -1 && this.m_deviceKey == deviceKey) {
                if (m_log.isDebugEnabled()) {
                    m_log.debug((Object)("DeviceInfoBean is already initialized for nodeId:" + deviceKey));
                }
                return;
            }
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("Start: Initializing the MonteroDeviceBean for nodeId:" + deviceKey));
            }
            this.m_deviceKey = deviceKey;
            this.m_MonteroBean = monteroBean;
            this.m_MonteroBean.getSQLUtil().pollConnection();
            if (this.m_sqlCPUQuery == null || this.m_sqlNumDrivesQuery == null) {
                String cpuTypeQuery = "select Name,CurrentClockSpeed FROM CIM_Processor where Name != '' and NodeId = ?";
                String numDrivesQuery = "select count(*) FROM CIM_LogicalDisk WHERE NodeId = ?";
                this.m_sqlNumDrivesQuery = this.m_MonteroBean.getSQLUtil().createPreparedStatement(numDrivesQuery.toString());
                this.m_sqlCPUQuery = this.m_MonteroBean.getSQLUtil().createPreparedStatement(cpuTypeQuery.toString());
            }
            try {
                this.m_node = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                this.m_numLogicalDrives = this.getDiskDrivesFromDb();
                this.m_strCpuType = this.getCpuInfoFromDb();
            }
            catch (Exception e) {
                if (!m_log.isEnabledFor((Priority)Level.ERROR)) break block7;
                m_log.error((Object)"Error initializing deviceinfoBean: ", (Throwable)e);
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("End: Initializing the MonteroDeviceBean for nodeId:" + deviceKey));
        }
    }

    public String getCpuType() {
        return this.m_strCpuType;
    }

    public MxNode getMxNode() {
        return this.m_node;
    }

    public int getNumberLogicalDrives() {
        return this.m_numLogicalDrives;
    }

    private String friendlyCPUSpeed(String strSpeed) {
        int speed;
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("DeviceInfoBean.friendlyCPUSpeed(" + strSpeed + ")"));
        }
        StringBuffer sb = new StringBuffer();
        try {
            speed = Integer.parseInt(strSpeed);
        }
        catch (NumberFormatException ex) {
            speed = 0;
            m_log.debug((Object)"Default CPU speed assumed", (Throwable)ex);
        }
        if (speed > 0) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(2);
            if ((double)speed >= 1000.0) {
                sb.append(nf.format((double)speed / 1000.0));
            } else {
                sb.append(nf.format(speed));
            }
            sb.append(" ");
            sb.append(MonteroResourceManager.getInstance().getString("cpu.abbreviation.mhz", this.m_MonteroBean.getLoginBean().getLocale()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getCpuInfoFromDb() {
        StringBuffer cpuInfo;
        block24: {
            ResultSet resultSet;
            block23: {
                if (m_log.isDebugEnabled()) {
                    m_log.debug((Object)"Start:DeviceInfoBean.getCpuInfoFromDb()");
                }
                cpuInfo = new StringBuffer(MonteroResourceManager.getInstance().getString("UNKNOWN", this.m_MonteroBean.getLoginBean().getLocale()));
                resultSet = null;
                this.m_sqlCPUQuery.setInt(1, this.m_node.getDeviceKey());
                resultSet = this.m_sqlCPUQuery.executeQuery();
                int cpuCount = 0;
                String cpuDescription = "";
                String cpuSpeed = "";
                while (resultSet.next()) {
                    if (cpuCount == 0) {
                        cpuDescription = resultSet.getString(1);
                        cpuSpeed = this.friendlyCPUSpeed(resultSet.getString(2));
                    }
                    ++cpuCount;
                }
                if (cpuCount <= 0 || cpuSpeed.length() <= 0 || cpuDescription.length() <= 0) break block23;
                cpuInfo.delete(0, cpuInfo.length());
                cpuInfo.append(cpuCount);
                cpuInfo.append(" x ");
                cpuInfo.append(cpuSpeed);
                cpuInfo.append(" ");
                cpuInfo.append(cpuDescription);
            }
            Object var7_8 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block24;
            }
            catch (SQLException sqlException2) {
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.error((Object)"Exception in finally clause", (Throwable)sqlException2);
                }
                break block24;
            }
            {
                catch (SQLException sqlException) {
                    if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                        m_log.error((Object)"SQL Exception:", (Throwable)sqlException);
                    }
                    Object var7_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block24;
                    }
                    catch (SQLException sqlException2) {
                        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                            m_log.error((Object)"Exception in finally clause", (Throwable)sqlException2);
                        }
                        break block24;
                    }
                }
                catch (Exception ex) {
                    if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                        m_log.error((Object)"Exception:", (Throwable)ex);
                    }
                    Object var7_10 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block24;
                    }
                    catch (SQLException sqlException2) {
                        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                            m_log.error((Object)"Exception in finally clause", (Throwable)sqlException2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block25: {
                    Object var7_11 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sqlException2) {
                        if (!m_log.isEnabledFor((Priority)Level.DEBUG)) break block25;
                        m_log.error((Object)"Exception in finally clause", (Throwable)sqlException2);
                    }
                }
                throw throwable;
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Type Of CPU :" + cpuInfo.toString()));
            m_log.debug((Object)"End:DeviceInfoBean.getCpuInfoFromDb()");
        }
        return cpuInfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getDiskDrivesFromDb() {
        int count;
        block21: {
            ResultSet resultSet;
            block20: {
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)"DeviceInfoBean.getDiskDrivesFromDb()");
                }
                resultSet = null;
                count = 0;
                this.m_sqlNumDrivesQuery.setInt(1, this.m_node.getDeviceKey());
                resultSet = this.m_sqlNumDrivesQuery.executeQuery();
                if (!resultSet.next()) break block20;
                count = resultSet.getInt(1);
            }
            Object var5_3 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block21;
            }
            catch (SQLException sqlException2) {
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.error((Object)"DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", (Throwable)sqlException2);
                }
                break block21;
            }
            {
                catch (SQLException sqlException) {
                    if (m_log.isEnabledFor((Priority)Level.ERROR)) {
                        m_log.error((Object)"DeviceInfoBean.getCpuInfoFromDb()", (Throwable)sqlException);
                    }
                    Object var5_4 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block21;
                    }
                    catch (SQLException sqlException2) {
                        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                            m_log.error((Object)"DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", (Throwable)sqlException2);
                        }
                        break block21;
                    }
                }
                catch (Exception ex) {
                    if (m_log.isEnabledFor((Priority)Level.ERROR)) {
                        m_log.error((Object)("DeviceInfoBean.getCpuInfoFromDb():" + ex));
                    }
                    Object var5_5 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block21;
                    }
                    catch (SQLException sqlException2) {
                        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                            m_log.error((Object)"DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", (Throwable)sqlException2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Object var5_6 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sqlException2) {
                        if (!m_log.isEnabledFor((Priority)Level.DEBUG)) break block22;
                        m_log.error((Object)"DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", (Throwable)sqlException2);
                    }
                }
                throw throwable;
            }
        }
        return count;
    }

    public MonteroBean getMonteroBean() {
        return this.m_MonteroBean;
    }
}

