/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.iLOXml;

import com.hp.mx.portal.iLOXml.ILOAllQueryConstants;
import com.hp.mx.portal.iLOXml.ILOICMBConstants;
import com.hp.mx.portal.iLOXml.InValidDataException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Element;

public class ILOParser {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private static ILOParser m_iLOParser = null;

    private ILOParser() {
    }

    public static ILOParser getInstance() {
        if (m_iLOParser == null) {
            m_iLOParser = new ILOParser();
        }
        return m_iLOParser;
    }

    public ILOAllQueryConstants processAllQueryXml(Element rootElement) {
        List rkNodes;
        ILOAllQueryConstants iLOConstants = new ILOAllQueryConstants();
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("iLOParser.processXml(Element" + rootElement + ")"));
        }
        Element mpAttribute = rootElement.getChild("MP");
        iLOConstants.iloFWRI = mpAttribute.getChildText("FWRI");
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("iLO Fw within iLOParser:" + iLOConstants.iloFWRI));
        }
        if (iLOConstants.iloFWRI == null) {
            iLOConstants.iloFWRI = "";
            return iLOConstants;
        }
        Element infraAttribute = rootElement.getChild("INFRA");
        if (infraAttribute != null) {
            iLOConstants.infraIcmbAddr = infraAttribute.getChildText("ICMB_ADDR");
        }
        if ((rkNodes = rootElement.getChildren("RK_TPLGY")) != null) {
            Iterator l = rkNodes.iterator();
            while (l.hasNext()) {
                Element rkAttribute = (Element)l.next();
                List rkIcmbList = rkAttribute.getChildren("ICMB");
                Iterator k = rkIcmbList.iterator();
                while (k.hasNext()) {
                    Element rkIcmbAttributes = (Element)k.next();
                    Vector<String> rkTplgy = new Vector<String>();
                    iLOConstants.rkTplgyenclprodId = rkIcmbAttributes.getAttributeValue("PROD_ID");
                    if (iLOConstants.rkTplgyenclprodId == null || !iLOConstants.rkTplgyenclprodId.trim().equals("0x0003") && !iLOConstants.rkTplgyenclprodId.trim().equals("0x0005")) continue;
                    rkTplgy.add(iLOConstants.rkTplgyenclprodId);
                    iLOConstants.rkTplgyenclSer = rkIcmbAttributes.getAttributeValue("SER");
                    rkTplgy.add(iLOConstants.rkTplgyenclSer);
                    iLOConstants.rkTplgyencladdr = rkIcmbAttributes.getAttributeValue("ADDR");
                    rkTplgy.add(iLOConstants.rkTplgyencladdr);
                    iLOConstants.rkTplgyHolder.add(rkTplgy);
                }
            }
        }
        return iLOConstants;
    }

    public ILOICMBConstants processICMBQueryXml(Element rootElement, boolean enclType) throws InValidDataException {
        Element errorEle;
        ILOICMBConstants iLOConstants = new ILOICMBConstants();
        Element encl = rootElement.getChild("Enclosure");
        if (encl == null) {
            encl = rootElement.getChild("enclosure");
        }
        if ((errorEle = encl.getChild("error")) != null) {
            String errorMsg = errorEle.getChildText("message");
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("Xml data contains error:" + errorMsg));
            }
            throw new InValidDataException(errorMsg);
        }
        List encNodes = rootElement.getChildren("Enclosure");
        if (encNodes == null || encNodes.isEmpty()) {
            encNodes = rootElement.getChildren("enclosure");
        }
        if (encNodes != null) {
            Iterator l = encNodes.iterator();
            while (l.hasNext()) {
                List pwrComponents;
                Iterator j;
                Iterator k;
                Element attribute = (Element)l.next();
                iLOConstants.encSerialNo = attribute.getChildText("ENCL_SN");
                iLOConstants.encUUID = attribute.getChildText("UUID");
                iLOConstants.encFWRI = attribute.getChildText("FWRI");
                iLOConstants.encHWRI = attribute.getChildText("HWRI");
                iLOConstants.encMAXNUMBERSLOTSX = attribute.getChildText("MAX_NUMBER_SLOTS_X");
                iLOConstants.encMAXNUMBERSLOTSY = attribute.getChildText("MAX_NUMBER_SLOTS_Y");
                iLOConstants.encPwrZone = attribute.getChildText("pwrZone");
                iLOConstants.encUidStatus = attribute.getChildText("uidStatus");
                iLOConstants.encTemperature = attribute.getChildText("Temperature");
                if (iLOConstants.encTemperature == null) {
                    iLOConstants.encTemperature = attribute.getChildText("temperature");
                }
                if (enclType) {
                    List srvComponents = attribute.getChildren("ServerComponents");
                    if (srvComponents == null || srvComponents.isEmpty()) {
                        srvComponents = attribute.getChildren("serverComponents");
                    }
                    k = srvComponents.iterator();
                    while (k.hasNext()) {
                        Element srvAttributes = (Element)k.next();
                        List srvComponent = srvAttributes.getChildren("ServerComponent");
                        if (srvComponent == null || srvComponent.isEmpty()) {
                            srvComponent = attribute.getChildren("serverComponent");
                        }
                        j = srvComponent.iterator();
                        while (j.hasNext()) {
                            Vector<String> srvHolder = new Vector<String>();
                            Element srvAttribute = (Element)j.next();
                            iLOConstants.srvLocation = srvAttribute.getChildText("Location");
                            if (iLOConstants.srvLocation == null) {
                                iLOConstants.srvLocation = srvAttribute.getChildText("location");
                            }
                            srvHolder.add(iLOConstants.srvLocation);
                            iLOConstants.srvFuseA = srvAttribute.getChildText("FuseA");
                            if (iLOConstants.srvFuseA == null) {
                                iLOConstants.srvFuseA = srvAttribute.getChildText("fuseA");
                            }
                            srvHolder.add(iLOConstants.srvFuseA);
                            iLOConstants.srvFuseB = srvAttribute.getChildText("FuseB");
                            if (iLOConstants.srvFuseB == null) {
                                iLOConstants.srvFuseB = srvAttribute.getChildText("fuseB");
                            }
                            srvHolder.add(iLOConstants.srvFuseB);
                            iLOConstants.srvProdId = srvAttribute.getChildText("PROD_ID");
                            srvHolder.add(iLOConstants.srvProdId);
                            iLOConstants.srvComponentsHolder.add(srvHolder);
                        }
                    }
                    List netWrkComponents = attribute.getChildren("NetworkComponents");
                    if (netWrkComponents == null || netWrkComponents.isEmpty()) {
                        netWrkComponents = attribute.getChildren("networkComponents");
                    }
                    Iterator k2 = netWrkComponents.iterator();
                    while (k2.hasNext()) {
                        Element netWrkAttributes = (Element)k2.next();
                        List netWrkComponent = netWrkAttributes.getChildren("NetworkComponent");
                        if (netWrkComponent == null || netWrkComponent.isEmpty()) {
                            netWrkComponent = netWrkAttributes.getChildren("networkComponent");
                        }
                        Iterator j2 = netWrkComponent.iterator();
                        while (j2.hasNext()) {
                            Vector<String> netWrkHolder = new Vector<String>();
                            Element netWrkAttribute = (Element)j2.next();
                            iLOConstants.netWrkLocation = netWrkAttribute.getChildText("Location");
                            if (iLOConstants.netWrkLocation == null) {
                                iLOConstants.netWrkLocation = netWrkAttribute.getChildText("location");
                            }
                            netWrkHolder.add(iLOConstants.netWrkLocation);
                            iLOConstants.netWrkFuseA = netWrkAttribute.getChildText("FuseA");
                            if (iLOConstants.netWrkFuseA == null) {
                                iLOConstants.netWrkFuseA = netWrkAttribute.getChildText("fuseA");
                            }
                            netWrkHolder.add(iLOConstants.netWrkFuseA);
                            iLOConstants.netWrkFuseB = netWrkAttribute.getChildText("FuseB");
                            if (iLOConstants.netWrkFuseB == null) {
                                iLOConstants.netWrkFuseB = netWrkAttribute.getChildText("fuseB");
                            }
                            netWrkHolder.add(iLOConstants.netWrkFuseB);
                            iLOConstants.netWrkProdId = netWrkAttribute.getChildText("PROD_ID");
                            netWrkHolder.add(iLOConstants.netWrkProdId);
                            iLOConstants.netWrkComponentsHolder.add(netWrkHolder);
                        }
                    }
                    continue;
                }
                iLOConstants.pwrEncTemperatureA = attribute.getChildText("TemperatureA");
                if (iLOConstants.pwrEncTemperatureA == null) {
                    iLOConstants.pwrEncTemperatureA = attribute.getChildText("temperatureA");
                }
                iLOConstants.pwrEncTemperatureB = attribute.getChildText("TemperatureB");
                if (iLOConstants.pwrEncTemperatureB == null) {
                    iLOConstants.pwrEncTemperatureB = attribute.getChildText("temperatureB");
                }
                iLOConstants.pwrEnclRedundancy = attribute.getChildText("RedundancyBits");
                iLOConstants.pwrEncLoadbalWire = attribute.getChildText("LoadBalWire");
                if (iLOConstants.pwrEncLoadbalWire == null) {
                    iLOConstants.pwrEncLoadbalWire = attribute.getChildText("loadBalWire");
                }
                if ((pwrComponents = attribute.getChildren("PowerComponents")) == null || pwrComponents.isEmpty()) {
                    pwrComponents = attribute.getChildren("powerComponents");
                }
                k = pwrComponents.iterator();
                while (k.hasNext()) {
                    Element pwrAttributes = (Element)k.next();
                    List pwrComponent = pwrAttributes.getChildren("PowerComponent");
                    if (pwrComponent == null || pwrComponent.isEmpty()) {
                        pwrComponent = pwrAttributes.getChildren("powerComponent");
                    }
                    j = pwrComponent.iterator();
                    while (j.hasNext()) {
                        Vector<String> pwrHolder = new Vector<String>();
                        Element pwrAttribute = (Element)j.next();
                        if (pwrAttribute.getChildren().isEmpty()) {
                            if (!log_.isEnabledFor((Priority)Level.DEBUG)) continue;
                            log_.debug((Object)"Ignoring an empty power supply unit");
                            continue;
                        }
                        iLOConstants.pwrLocation = pwrAttribute.getChildText("Location");
                        if (iLOConstants.pwrLocation == null) {
                            iLOConstants.pwrLocation = pwrAttribute.getChildText("location");
                        }
                        pwrHolder.add(iLOConstants.pwrLocation);
                        iLOConstants.pwrFWRI = pwrAttribute.getChildText("FWRI");
                        if (iLOConstants.pwrFWRI == null) {
                            iLOConstants.pwrFWRI = "";
                        }
                        pwrHolder.add(iLOConstants.pwrFWRI);
                        iLOConstants.pwracInput = pwrAttribute.getChildText("acInput");
                        if (iLOConstants.pwracInput == null) {
                            iLOConstants.pwracInput = "";
                        }
                        pwrHolder.add(iLOConstants.pwracInput);
                        iLOConstants.pwrcurrent = pwrAttribute.getChildText("Current");
                        if (iLOConstants.pwrcurrent == null) {
                            iLOConstants.pwrcurrent = pwrAttribute.getChildText("current");
                        }
                        pwrHolder.add(iLOConstants.pwrcurrent);
                        iLOConstants.pwrmaxCurrent = pwrAttribute.getChildText("MaxCurrent");
                        if (iLOConstants.pwrmaxCurrent == null) {
                            iLOConstants.pwrmaxCurrent = pwrAttribute.getChildText("maxCurrent");
                        }
                        pwrHolder.add(iLOConstants.pwrmaxCurrent);
                        iLOConstants.pwrinputTemp = pwrAttribute.getChildText("InputTemp");
                        if (iLOConstants.pwrinputTemp == null) {
                            iLOConstants.pwrinputTemp = pwrAttribute.getChildText("inputTemp");
                        }
                        pwrHolder.add(iLOConstants.pwrinputTemp);
                        iLOConstants.pwrinputTempTrip = pwrAttribute.getChildText("InputTempTrip");
                        if (iLOConstants.pwrinputTempTrip == null) {
                            iLOConstants.pwrinputTempTrip = pwrAttribute.getChildText("inputTempTrip");
                        }
                        pwrHolder.add(iLOConstants.pwrinputTempTrip);
                        iLOConstants.pwrinputTempFail = pwrAttribute.getChildText("InputTempFail");
                        if (iLOConstants.pwrinputTempFail == null) {
                            iLOConstants.pwrinputTempFail = pwrAttribute.getChildText("inputTempFail");
                        }
                        pwrHolder.add(iLOConstants.pwrinputTempFail);
                        iLOConstants.pwroutputTemp = pwrAttribute.getChildText("OutputTemp");
                        if (iLOConstants.pwroutputTemp == null) {
                            iLOConstants.pwroutputTemp = pwrAttribute.getChildText("outputTemp");
                        }
                        pwrHolder.add(iLOConstants.pwroutputTemp);
                        iLOConstants.pwroutputTempTrip = pwrAttribute.getChildText("OutputTempTrip");
                        if (iLOConstants.pwroutputTempTrip == null) {
                            iLOConstants.pwroutputTempTrip = pwrAttribute.getChildText("outputTempTrip");
                        }
                        pwrHolder.add(iLOConstants.pwroutputTempTrip);
                        iLOConstants.pwroutputTempFail = pwrAttribute.getChildText("OutputTempFail");
                        if (iLOConstants.pwroutputTempFail == null) {
                            iLOConstants.pwroutputTempFail = pwrAttribute.getChildText("outputTempFail");
                        }
                        pwrHolder.add(iLOConstants.pwroutputTempFail);
                        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                            log_.debug((Object)("power supply unit :" + pwrHolder.size()));
                        }
                        iLOConstants.pwrComponentsHolder.add(pwrHolder);
                    }
                    if (!log_.isEnabledFor((Priority)Level.DEBUG)) continue;
                    log_.debug((Object)("power supply units :" + iLOConstants.pwrComponentsHolder.size()));
                }
            }
        }
        return iLOConstants;
    }
}

