/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.DeviceAssociationObject;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVContainer;
import com.hp.mx.portal.bpv.MxBPVContainerObjectFactory;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVObjectFactory;
import com.hp.mx.portal.bpv.MxBPVTyphoonSlot;
import com.hp.mx.portal.iLOXml.EnclosureNodeUpdater;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.sun.xml.bind.JAXBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Content;
import org.jdom.Element;

public abstract class MxBPVServerEnclosure
extends MxBPVContainer {
    private static Logger log_ = Logger.getLogger((String)"Montero");

    public static MxBPVServerEnclosure create(MxNode enclNode, MxBPVElement rackElement, MxLoginBean loginBean) throws Exception {
        BladeIMELogger.log("Start:MxBPVServerEnclosure.create(" + enclNode + "," + rackElement + "," + loginBean + ")");
        MxBPVServerEnclosure serverEnclosure = null;
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(enclNode.getKey());
        int numSlots = nodeAssociations.getMaxNumItems();
        String enclSubType = MxBPVServerEnclosure.getEnclosureSubType(enclNode);
        MxBPVContainerObjectFactory containerObject = MxBPVContainerObjectFactory.getContainerFactoryInstance();
        serverEnclosure = containerObject.getContainerObject(enclSubType, numSlots, enclNode, rackElement, loginBean);
        BladeIMELogger.log("MxBPVContainerObjectFactory of ServerEnclosure" + serverEnclosure.getName());
        BladeIMELogger.log("End:MxBPVServerEnclosure.create(" + enclNode + "," + rackElement + "," + loginBean + ")");
        return serverEnclosure;
    }

    protected MxBPVServerEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        this.deviceType = "ServerEnc";
    }

    public abstract int getNumSlots();

    public abstract int getFirstSlotNumber();

    public Element renderXML() throws MxBPVException {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"MxBPVServerEnclosure.renderXML()");
        }
        BPVXML bpvXml = BPVXML.getInstance();
        Element serverEncl = bpvXml.createBladeEnclosure(this, this.loginBean);
        Iterator iter = this.iterator();
        MxBPVElement childElement = null;
        while (iter.hasNext()) {
            Object elementList = iter.next();
            if (elementList instanceof MxBPVElement) {
                childElement = (MxBPVElement)elementList;
                this.renderDevice(childElement, serverEncl);
                continue;
            }
            ArrayList switchList = (ArrayList)elementList;
            if (switchList == null) continue;
            for (int i = 0; i < switchList.size(); ++i) {
                childElement = (MxBPVElement)switchList.get(i);
                this.renderDevice(childElement, serverEncl);
            }
        }
        bpvXml.createRearView(this, serverEncl);
        return serverEncl;
    }

    private void renderDevice(MxBPVElement childElement, Element serverEncl) throws MxBPVException {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("MxBPVServerEnclosure.createFrontDevice(" + childElement + "," + serverEncl));
            log_.debug((Object)("MxBPVServerEnclosure.createFrontDevice(ElemntName" + childElement.getName() + ",ServerEnc Name:" + serverEncl.getName()));
        }
        if (childElement != null) {
            if (childElement instanceof MxBPVTyphoonSlot) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("MxBPVServerEnclosure.renderXML(): " + childElement.getName()));
                }
                ((MxBPVTyphoonSlot)childElement).renderXML(serverEncl);
            } else {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("MxBPVServerEnclosure.renderXML()" + childElement.getName()));
                }
                Element device = childElement.renderXML();
                serverEncl.addContent((Content)device);
            }
        }
    }

    protected ArrayList getElementsForSlot(MxNodeClient nodeClient, NodeAssociations nodeAssociations, int slotNumber) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("Start:MxBPVServerEnclosure.getVectorElementForSlot(" + nodeClient + "," + nodeAssociations + ",{SlotNumber:}" + slotNumber));
        }
        ArrayList deviceMxNodeList = MxBPVServerEnclosure.getDeviceAtSlotNumber(this.getKey(), slotNumber);
        ArrayList<MxBPVElement> deviceElementList = new ArrayList<MxBPVElement>();
        for (int i = 0; i < deviceMxNodeList.size(); ++i) {
            deviceElementList.add(this.getElementForSlot(nodeClient, nodeAssociations, (MxNode)deviceMxNodeList.get(i)));
        }
        return deviceElementList;
    }

    protected MxBPVElement getElementForSlot(MxNodeClient nodeClient, NodeAssociations nodeAssociations, MxNode device) {
        block9: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("Start:MxBPVServerEnclosure.getElementForSlot(" + nodeClient + "," + nodeAssociations + "," + device));
            }
            if (device == null) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)"Returning null as there wasnt any MxNode object at this slot,this might be an empty slot or we have issues.");
                    log_.debug((Object)("End:MxBPVServerEnclosure.getElementForSlot(" + nodeClient + "," + nodeAssociations + "," + device));
                }
                return null;
            }
            try {
                MxNode node = nodeClient.getNodeByKey(device.getDeviceKey(), false);
                ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
                nodeIDs.add(node.getObjectID());
                List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("authorizedTools size:" + authorizedTools.size()));
                }
                if (authorizedTools.size() > 0) {
                    if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                        log_.debug((Object)"returning the MxBPVElement for the device at this slot");
                        log_.debug((Object)("End:MxBPVServerEnclosure.getElementForSlot(" + nodeClient + "," + nodeAssociations + "," + device));
                    }
                    MxBPVObjectFactory factory = new MxBPVObjectFactory();
                    return factory.createObject(device, this, this.getLoginBean());
                }
            }
            catch (Exception e) {
                if (!log_.isEnabledFor((Priority)Level.DEBUG)) break block9;
                log_.debug((Object)"MxBPVServerEnclosure.getElementForSlot()", (Throwable)e);
            }
        }
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("Returning null as the user is not autorized to use any tools on this serverot there is an exception.Name:" + this.node.getNameString()));
        }
        return null;
    }

    public static ArrayList getDeviceAtSlotNumber(int enclDeviceKey, int slotNumber) {
        ArrayList<MxNode> deviceList;
        block12: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("Start:MxBPVServerEnclosure.getDeviceAtSlotNumber({enclDeviceKey:}" + enclDeviceKey + ",{SlotNumber:}" + slotNumber));
            }
            DeviceAssociationObject dao = null;
            deviceList = new ArrayList<MxNode>();
            try {
                NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
                Vector bladeVec = myNodeAssociationsManager.getDevicesThatHaveAssociations(enclDeviceKey, true);
                NodeAssociations na = null;
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("bladeVec size:" + bladeVec.size()));
                }
                for (int i = 0; i < bladeVec.size(); ++i) {
                    dao = (DeviceAssociationObject)bladeVec.elementAt(i);
                    MxNode tmpDev = null;
                    try {
                        tmpDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(dao.getDeviceKey());
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("MxNode of the device @ index " + i + ":" + tmpDev));
                    }
                    if (tmpDev == null) continue;
                    na = myNodeAssociationsManager.getNodeAssociations(dao.getDeviceKey());
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("The node associations object of device with key: " + dao.getDeviceKey() + ":" + na));
                        log_.debug((Object)("Slot number in the node associations object:" + na.getSlotNumber()));
                        log_.debug((Object)("Slot number we are quering:" + slotNumber));
                    }
                    if (na == null || na.getSlotNumber() != slotNumber) continue;
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("Found the Mxnode so add it to the list: " + tmpDev));
                    }
                    deviceList.add(tmpDev);
                }
            }
            catch (NodeAssociationsPersistenceException nape) {
                if (!log_.isEnabledFor((Priority)Level.DEBUG)) break block12;
                log_.debug((Object)"Exception:MxBPVServerEnclosure.getDeviceAtSlot()", (Throwable)nape);
            }
        }
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("The device list that this method returns.Size:" + deviceList.size()));
            for (int i = 0; i < deviceList.size(); ++i) {
                log_.debug((Object)("The device object:" + deviceList.get(i)));
            }
            log_.debug((Object)("End:MxBPVServerEnclosure.getDeviceAtSlotNumber({enclDeviceKey:}" + enclDeviceKey + ",{SlotNumber:}" + slotNumber));
        }
        return deviceList;
    }

    protected MxBPVElement getElementForSlot(MxNodeClient nodeClient, NodeAssociations nodeAssociations, int slotNumber) {
        block9: {
            MxNode device;
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("Start:MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber));
            }
            if ((device = nodeAssociations.getDeviceBySlotNumber(slotNumber)) == null) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)"Returning null as getDeviceBySlotNumber() returned null,this might be an empty slot or we have issues.");
                    log_.debug((Object)("NodeAssociations device Key:" + nodeAssociations.getDeviceKey()));
                    log_.debug((Object)("End:MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber));
                }
                return null;
            }
            try {
                MxNode node = nodeClient.getNodeByKey(device.getDeviceKey(), false);
                ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
                nodeIDs.add(node.getObjectID());
                List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)("authorizedTools size:" + authorizedTools.size()));
                }
                if (authorizedTools.size() > 0) {
                    if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                        log_.debug((Object)"returning the MxBPVElement for the device at this slot");
                        log_.debug((Object)("End:MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber));
                    }
                    MxBPVObjectFactory factory = new MxBPVObjectFactory();
                    return factory.createObject(device, this, this.getLoginBean());
                }
            }
            catch (Exception e) {
                if (!log_.isEnabledFor((Priority)Level.DEBUG)) break block9;
                log_.debug((Object)"Exception:MxBPVServerEnclosure.getElementForSlot()", (Throwable)e);
            }
        }
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("Returning null as the user is not autorized to use any tools on this serverot there is an exception.Name:" + this.node.getNameString()));
            log_.debug((Object)("End:MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber));
        }
        return null;
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }

    public static String getEnclosureSubType(MxNode srvEnclNode) {
        BladeIMELogger.log("Start:mxBPVServerEnclosure.setDeviceSubTypeOfEncl(" + srvEnclNode.getName() + ")");
        String subTypeOfEncl = null;
        List enclSubTypeList = srvEnclNode.getDeviceSubTypes();
        if (enclSubTypeList.contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
            subTypeOfEncl = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
        } else if (enclSubTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            subTypeOfEncl = NodeSubTypeMapper.CCLASS_SUBTYPE.toString();
        } else if (enclSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            subTypeOfEncl = NodeSubTypeMapper.ECLASS_SUBTYPE.toString();
        } else if (srvEnclNode != null) {
            MxNode rackNode = EnclosureNodeUpdater.getRackNode(srvEnclNode);
            List rackSubTypeList = rackNode.getDeviceSubTypes();
            if (rackSubTypeList.contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
                subTypeOfEncl = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
            } else if (rackSubTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                subTypeOfEncl = NodeSubTypeMapper.CCLASS_SUBTYPE.toString();
            } else if (rackSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                subTypeOfEncl = NodeSubTypeMapper.ECLASS_SUBTYPE.toString();
            } else {
                BladeIMELogger.log("The sub-type of server enclosure is not set in the rack node also and we were not able to obtain thedeviceSubtype from the server enclosure so we are setting it to P-Class to avoid any NullPointerExceptions.");
                subTypeOfEncl = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
            }
        }
        BladeIMELogger.log("subTypeOfEncl:" + subTypeOfEncl);
        BladeIMELogger.log("End:mxBPVServerEnclosure.setDeviceSubTypeOfEncl(" + srvEnclNode.getName() + ")");
        return subTypeOfEncl;
    }

    public MxBPVElement getElementForSlot(int enclDeviceKey, int slotNumber, String deviceType) {
        BladeIMELogger.log("Start:MxBPVServerEnclosure.getElementForSlot({enclDeviceKey:}" + enclDeviceKey + ",{SlotNumber:}" + slotNumber + ",{deviceType}:" + deviceType);
        Object dao = null;
        try {
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            Vector devices = this.getDevicesVector(enclDeviceKey, deviceType);
            NodeAssociations na = null;
            BladeIMELogger.log("Device Vector size:" + devices.size());
            Integer devKey = null;
            for (int i = 0; i < devices.size(); ++i) {
                devKey = (Integer)devices.get(i);
                BladeIMELogger.log("devKey:" + devKey);
                MxNode device = MxNodeController.getDefaultControllerNoEx().getNodeByKey(devKey);
                if (device == null) continue;
                na = myNodeAssociationsManager.getNodeAssociations(device.getDeviceKey());
                BladeIMELogger.log("The node associations object of device with key: " + device.getDeviceKey() + ":" + na);
                BladeIMELogger.log("Slot number in the node associations object:" + na.getSlotNumber());
                if (na == null || na.getSlotNumber() != slotNumber) continue;
                BladeIMELogger.log("The MxNode at the SlotNumber:" + slotNumber + " is:" + device);
                return this.getDeviceElement(device);
            }
        }
        catch (NodeAssociationsPersistenceException nape) {
            BladeIMELogger.log((Exception)((Object)nape), "Exception:MxBPVServerEnclosure.getDeviceAtSlot()");
        }
        return null;
    }

    private Vector getDevicesVector(int enclDeviceKey, String deviceType) {
        BladeIMELogger.log("MxBPVServerEnclsoure.getDevicesVector(enclDeviceKey " + enclDeviceKey + ",deviceType " + deviceType);
        Vector devices = new Vector();
        try {
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            if (deviceType.equalsIgnoreCase("Server")) {
                devices = myNodeAssociationsManager.getAssociatedDevicesUsingATNs(enclDeviceKey, "ServerToEnclosure");
            } else if (deviceType.equalsIgnoreCase("Switch")) {
                devices = myNodeAssociationsManager.getAssociatedDevicesUsingATNs(enclDeviceKey, "SwitchToEnclosure");
            } else if (deviceType.equalsIgnoreCase("MgmtProc")) {
                devices = myNodeAssociationsManager.getAssociatedDevicesUsingATNs(enclDeviceKey, "MgmtProcToEnclosure");
            }
        }
        catch (NodeAssociationsPersistenceException e) {
            e.printStackTrace();
        }
        return devices;
    }

    private MxBPVElement getDeviceElement(MxNode device) {
        BladeIMELogger.log("MxBPVServerEnclosure.getDeviceElement(device:" + device.getNameString() + ")");
        ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
        nodeIDs.add(device.getObjectID());
        try {
            List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("authorizedTools size:" + authorizedTools.size()));
            }
            if (authorizedTools.size() > 0) {
                MxBPVObjectFactory factory = new MxBPVObjectFactory();
                return factory.createObject(device, this, this.getLoginBean());
            }
        }
        catch (MxException e) {
            e.printStackTrace();
        }
        catch (BladeSystemException e) {
            e.printStackTrace();
        }
        return null;
    }
}

