/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVIceServerEnclosure;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.DeviceType;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Status;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.AssociatedDevice;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import javax.xml.bind.JAXBException;
import org.jdom.Element;

public class MxBPVServer
extends MxBPVElement {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVServer.class);
    private int numSlotsUsed;
    private int numSlotsUsedXDir;
    private int numSlotsUsedYDir;
    ObjectFactory m_objFactory = new ObjectFactory();

    public MxBPVServer(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        LOGGER.enter("MxBPVServer.MxBPVServer(" + node + "," + parent + "," + loginBean + ")");
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.numSlotsUsed = nodeAssociations.getNumBladeSlotsUsed();
        this.numSlotsUsedXDir = nodeAssociations.getNumBladeSlotsUsedXDir();
        this.numSlotsUsedYDir = nodeAssociations.getNumBladeSlotsUsedYDir();
        if (parent instanceof MxBPVIceServerEnclosure) {
            this.numSlotsUsedYDir = 2;
        }
        if (this.numSlotsUsedXDir * this.numSlotsUsedYDir != this.numSlotsUsed) {
            this.numSlotsUsedXDir = this.numSlotsUsed;
            this.numSlotsUsedYDir = 2;
        }
        this.deviceType = "BladeServer";
        LOGGER.exit("MxBPVServer.MxBPVServer(" + node + "," + parent + "," + loginBean + ")");
    }

    public int getNumSlotsUsed() {
        return this.numSlotsUsed;
    }

    public int getNumSlotsUsedXDir() {
        return this.numSlotsUsedXDir;
    }

    public int getNumSlotsUsedYDir() {
        return this.numSlotsUsedYDir;
    }

    String getDrillDownURL(String drillDownType) {
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + drillDownType + "&globalselection=true";
    }

    public Element renderXML() {
        BPVXML bpvXml = BPVXML.getInstance();
        Element server = bpvXml.createDevice(this, false);
        return server;
    }

    public JAXBObject renderJAXBXML() {
        LOGGER.enter("MxBPVServer.renderJAXBXML");
        try {
            Device device = this.m_objFactory.createDevice();
            device.setBayType(this.getNode().getDeviceType());
            device.setLocation("Front");
            this.setSlotsInfoForDevice(device);
            this.setCommonInfoForDevice(device);
            Status status = this.m_objFactory.createStatus();
            String deviceStatus = this.getStatus();
            LOGGER.fine("Server status:" + deviceStatus);
            if (deviceStatus == null) {
                deviceStatus = "Unknown";
            }
            String deviceStatTitle = MonteroResourceManager.getInstance().getString("xml." + deviceStatus, this.getLoginBean().getLocale());
            status.setUID(deviceStatus);
            status.setTitle(deviceStatTitle);
            device.setStatus(status);
            this.setAutomationStatus(device);
            this.setAssociatedBlade(device);
            LOGGER.exit("MxBPVServer.renderJAXBXML");
            return (JAXBObject)device;
        }
        catch (JAXBException je) {
            LOGGER.fine("JAXBException in MxBPVServer:renderJAXBXML()" + (Object)((Object)je));
            LOGGER.exit("MxBPVServer.renderJAXBXML");
            return null;
        }
    }

    private void setAssociatedBlade(DeviceType device) {
        LOGGER.enter("MxBPVServer.setAssociatedBlade");
        MxNode devNode = this.getNode();
        try {
            DeviceType.AssociatedBladeType assocBlade = this.m_objFactory.createDeviceTypeAssociatedBladeType();
            String assocDevType = "Storage";
            if (devNode.getDeviceType().equalsIgnoreCase("Storage")) {
                assocDevType = "Server";
            }
            AssociatedDevice assocDev = new AssociatedDevice(devNode, assocDevType);
            int assocBay = assocDev.getAssociatedDevBay();
            MxNode assocSrvNode = assocDev.getAssociatedDevNode();
            if (assocSrvNode != null) {
                assocBlade.setBay(assocBay);
                assocBlade.setName(assocSrvNode.getNameString());
                assocBlade.setIsPresent("Yes");
            } else {
                assocBlade.setIsPresent("No");
            }
            device.setAssociatedBlade(assocBlade);
        }
        catch (JAXBException jexec) {
            LOGGER.fine("exception" + (Object)((Object)jexec));
        }
        LOGGER.exit("MxBPVServer.setAssociatedBlade");
    }

    private void setSlotsInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVServer.setSlotsInfoForDevice");
        try {
            device.setSlotNumber(this.slotNumber);
            device.setHasDevice("PRESENT");
            SlotsUsed slots = this.m_objFactory.createSlotsUsed();
            LOGGER.fine("X Direction:" + this.numSlotsUsedXDir);
            LOGGER.fine("Y Direction:" + this.numSlotsUsedYDir);
            slots.setXDirection(this.numSlotsUsedXDir);
            slots.setYDirection(this.numSlotsUsedYDir);
            device.setSlotsUsed(slots);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVServer.setSlotsInfoForDevice" + (Object)((Object)e));
        }
    }

    private void setCommonInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVServer.setCommonInfoForDevice");
        try {
            DeviceType.CommonType common = this.m_objFactory.createDeviceTypeCommonType();
            common.setName(this.getDeviceName());
            common.setProduct(this.node.getModel());
            common.setSerialNum(this.node.getSerialNumber());
            common.setNodeId(this.node.getGUID().toString());
            common.setDrillDownURL(this.getDrillDownURL(MxDrillDown.DEVICE_NAME_DRILL_DOWN));
            MxDrillDown drilldown = new MxDrillDown(this.getLoginBean(), this.getKey(), MxDrillDown.HW_STATUS_DRILL_DOWN);
            boolean window = drilldown.launchInSeparateWindow();
            if (window) {
                common.setHomePageURL(this.getDrillDownURL(MxDrillDown.HW_STATUS_DRILL_DOWN));
            }
            device.setCommon(common);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVServer.setCommonInfoForDevice" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVServer.setCommonInfoForDevice");
    }

    private void setAutomationStatus(DeviceType device) {
    }

    private String getDeviceName() {
        String name = this.node.getNameString();
        if (name == null) {
            name = this.node.getWorkingAddress();
        }
        LOGGER.fine("MxBPVServer.getDeviceName returns:The Server name:" + name);
        return name;
    }
}

