/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.portal.OAXml.DeviceFansType;
import com.hp.mx.portal.OAXml.DeviceTempsType;
import com.hp.mx.portal.OAXml.EnclosurePowerSupplyType;
import com.hp.mx.portal.OAXml.EnclosurePowerType;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OLEnclosure;
import com.hp.mx.portal.OAXml.OnboardAdministrator;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVEmptySlot;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVOnboardAdministrator;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVSwitch;
import com.hp.mx.portal.bpv.MxBPVTyphoonSlot;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Attribute;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.BladeEnclosure;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.FANS;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Power;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.PowerSupplyUnit;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Status;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Temperature;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.TemperatureType;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.VCMType;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.iLOXml.EnclosureNodeUpdater;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.sun.xml.bind.JAXBObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

class MxBPVOverlordEnclosure
extends MxBPVServerEnclosure {
    private final int numServerSlots = 8;
    private final int numSwitchSlots = 8;
    private final int numOASlots = 2;
    private final int firstSlotNumber = 1;
    private MonteroResourceManager m_manager = MonteroResourceManager.getInstance();
    private Vector m_switchContents;
    private Vector m_oAContents;
    ObjectFactory m_objFactory = new ObjectFactory();
    OAHelper m_oaHelper = OAHelper.getOAHelper();
    OLEnclosure m_enclosureObj = this.m_oaHelper.getOLEnclosure(this.node);

    public MxBPVOverlordEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
    }

    public int getFirstSlotNumber() {
        return 1;
    }

    public int getNumSlots() {
        return 8;
    }

    public void populateAll() throws MxBPVException {
        this.populateServerSlots();
        this.populateSwitchSlots();
        this.populateOASlots();
    }

    private void populateServerSlots() throws MxBPVException {
        BladeIMELogger.log("MxBPVOverlordEnclosure.populateServerSlots()");
        int slotNumber = this.getFirstSlotNumber();
        this.setSize(9);
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException nape) {
            throw new MxBPVException("MxBPVOverlordEnclosure.createServer" + nape.getMessage());
        }
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        while (slotNumber < 9) {
            MxBPVElement element;
            MxBPVElement top = element = this.getElementForSlot(this.getKey(), slotNumber, "Server");
            MxBPVElement bottom = this.getElementForSlot(nodeClient, nodeAssociations, slotNumber + 8);
            try {
                if (top != null && bottom != null) {
                    top.slotNumber = slotNumber;
                    bottom.slotNumber = slotNumber + 8;
                    BladeIMELogger.log("The typhoon elements " + top + " and " + bottom + " are added at " + "Slotnumbers " + slotNumber + " and " + slotNumber + 8);
                    this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                    ++slotNumber;
                    continue;
                }
                if (top != null && bottom == null) {
                    if (top.getNumSlotsUsedYDir() == 1) {
                        bottom = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                        top.slotNumber = slotNumber;
                        bottom.slotNumber = slotNumber + 8;
                        BladeIMELogger.log("The typhoon elements " + top + " and " + bottom + " are added at " + "Slotnumbers " + slotNumber + " and " + slotNumber + 8);
                        this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                    } else {
                        BladeIMELogger.log("Set the Ice Blade the container");
                        this.set(slotNumber, top);
                    }
                    slotNumber += top.getNumSlotsUsedXDir();
                    continue;
                }
                if (top == null && bottom != null) {
                    top = new MxBPVEmptySlot(false, slotNumber, 1, 1);
                    top.slotNumber = slotNumber;
                    bottom.slotNumber = slotNumber + 8;
                    BladeIMELogger.log("The typhoon elements " + top + " and " + bottom + " are added at " + "Slotnumbers " + slotNumber + " and " + slotNumber + 8);
                    this.set(slotNumber, new MxBPVTyphoonSlot(top, bottom, this, this.getLoginBean()));
                    ++slotNumber;
                    continue;
                }
                MxBPVEmptySlot emptySlot = new MxBPVEmptySlot(false, slotNumber, 1, 2);
                emptySlot.slotNumber = slotNumber;
                emptySlot.setDeviceTypeForEmptySlot("Server");
                BladeIMELogger.log("Set the Empty slot to the container");
                this.set(slotNumber, emptySlot);
                ++slotNumber;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void populateSwitchSlots() throws MxBPVException {
        BladeIMELogger.log("MxBPVOverlordEnclosure.populateSwitchSlots()");
        int slotNumber = this.getFirstSlotNumber();
        this.m_switchContents = new Vector();
        this.m_switchContents.setSize(9);
        while (slotNumber < 9) {
            MxBPVElement element = this.getElementForSlot(this.getKey(), slotNumber, "Switch");
            if (element != null && element instanceof MxBPVSwitch) {
                MxBPVSwitch switchElement = (MxBPVSwitch)element;
                this.setOverlordDevices(slotNumber, switchElement, false);
                BladeIMELogger.log("Number of slots occupied along X-dir by switch:" + switchElement.getNumSlotsUsedXDir());
                slotNumber += switchElement.getNumSlotsUsedXDir();
                continue;
            }
            BladeIMELogger.log("No switch at slotnumber:" + slotNumber);
            MxBPVEmptySlot emptyElement = new MxBPVEmptySlot(true, slotNumber, 1, 1);
            emptyElement.setDeviceTypeForEmptySlot("Switch");
            this.setOverlordDevices(slotNumber, emptyElement, false);
            ++slotNumber;
        }
    }

    private void populateOASlots() throws MxBPVException {
        BladeIMELogger.log("MxBPVOverlordEnclosure.populateOASlots()");
        int slotNumber = this.getFirstSlotNumber();
        this.m_oAContents = new Vector();
        this.m_oAContents.setSize(3);
        while (slotNumber < 3) {
            MxBPVElement element = this.getElementForSlot(this.getKey(), slotNumber, "MgmtProc");
            if (element != null) {
                this.setOverlordDevices(slotNumber, element, true);
                BladeIMELogger.log("Number of slots occupied along X-dir by OA:" + element.getNumSlotsUsedXDir());
                slotNumber += element.getNumSlotsUsedXDir();
                continue;
            }
            MxBPVEmptySlot emptyElement = new MxBPVEmptySlot(true, slotNumber, 1, 1);
            emptyElement.setDeviceTypeForEmptySlot("MgmtProc");
            this.setOverlordDevices(slotNumber, emptyElement, true);
            ++slotNumber;
        }
    }

    public Element renderXML() throws MxBPVException {
        BladeIMELogger.log("MxBPVOverlordEnclosure.renderXML()");
        Element enclosureRoot = null;
        try {
            BladeEnclosure enclosure = this.m_objFactory.createBladeEnclosure();
            this.setEnclosureAttributes(enclosure);
            this.createEnclosureAttributes(enclosure);
            this.createEnclPwrThermalAttributes(enclosure);
            List devices = enclosure.getDevice();
            this.renderServerDevices(devices);
            this.renderOverlordDevices(this.m_switchContents, devices);
            this.renderOverlordDevices(this.m_oAContents, devices);
            this.renderFANDetails(enclosure);
            this.renderPowerUnitDetails(enclosure);
            this.renderVCMDetails(enclosure);
            JAXBContext jc = JAXBContext.newInstance((String)"com.hp.mx.portal.bpv.OABPVXmlJaxb");
            Marshaller xmlMarshaller = jc.createMarshaller();
            xmlMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter string = new StringWriter(3000);
            xmlMarshaller.marshal((Object)enclosure, (Writer)string);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(string.toString()));
            enclosureRoot = doc.getRootElement();
            BladeIMELogger.log("Overlord Enclosure Element:" + enclosureRoot.toString());
        }
        catch (PropertyException pe) {
            BladeIMELogger.log((Exception)((Object)pe), "MxBPVOverlordEnclosure.renderXML()");
            throw new MxBPVException(pe.getMessage());
        }
        catch (JAXBException jaxbe) {
            BladeIMELogger.log((Exception)((Object)jaxbe), "MxBPVOverlordEnclosure.renderXML()");
            throw new MxBPVException(jaxbe.getMessage());
        }
        catch (JDOMException jdome) {
            BladeIMELogger.log((Exception)((Object)jdome), "MxBPVOverlordEnclosure.renderXML()");
            throw new MxBPVException(jdome.getMessage());
        }
        catch (IOException ioe) {
            BladeIMELogger.log(ioe, "MxBPVOverlordEnclosure.renderXML()");
            throw new MxBPVException(ioe.getMessage());
        }
        return enclosureRoot;
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }

    private void setEnclosureAttributes(BladeEnclosure enclosure) {
        BladeIMELogger.log("Start:setEnclosureAttributes():");
        enclosure.setRackName(this.node.getRackName());
        enclosure.setEnclUUID(this.getValue(this.m_enclosureObj.getEnclosureUUID()));
        enclosure.setType("c-Class");
        enclosure.setTitleStatus(MonteroResourceManager.getInstance().getString("xml." + this.getHealthStatus(this.getStatus()), this.getLoginBean().getLocale()));
        enclosure.setUIDStatus(this.getValue(this.m_enclosureObj.getEnclosureUUIDStatus()));
        BladeIMELogger.log("m_enclosureObj.getEnclosureUUIDStatus():" + this.m_enclosureObj.getEnclosureUUIDStatus());
        BladeIMELogger.log("getValue:" + this.getValue(this.m_enclosureObj.getEnclosureUUIDStatus()));
        BladeIMELogger.log("End:setEnclosureAttributes():");
    }

    private void renderServerDevices(List devices) {
        Iterator iter = this.iterator();
        MxBPVElement childElement = null;
        while (iter.hasNext()) {
            Object elementList = iter.next();
            if (elementList == null) continue;
            if (elementList instanceof MxBPVTyphoonSlot) {
                BladeIMELogger.log("Render the XML for Typhoon device");
                ((MxBPVTyphoonSlot)elementList).renderJAXBXML(devices);
                continue;
            }
            BladeIMELogger.log("Render the XML for the device which is not Typhoon");
            childElement = (MxBPVElement)elementList;
            JAXBObject device = childElement.renderJAXBXML();
            devices.add((Device)device);
        }
    }

    private void renderOverlordDevices(Vector deviceVector, List devices) {
        BladeIMELogger.log("Start:renderOverlordDevices()");
        MxBPVElement childElement = null;
        for (int j = 1; j < deviceVector.size(); j += childElement.getNumSlotsUsedXDir()) {
            Object oAElement = deviceVector.get(j);
            childElement = (MxBPVElement)oAElement;
            JAXBObject device = childElement.renderJAXBXML();
            devices.add((Device)device);
        }
        BladeIMELogger.log("End:renderOverlordDevices()");
    }

    private void renderFANDetails(BladeEnclosure enclosure) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.renderFANDetails()");
        List fans = enclosure.getFANS();
        DeviceFansType fansType = this.m_enclosureObj.getDeviceFansType();
        List fanList = fansType.getDeviceFanTypeList();
        FANS fan = null;
        ArrayList<String> fanBayList = new ArrayList<String>();
        DeviceFansType.DeviceFanType fanType = null;
        DeviceFansType.DeviceFanType.DeviceFanBayOccupanType connectionType = null;
        String bayOccupiedByFan = null;
        try {
            for (int i = 0; i < fanList.size(); ++i) {
                fanType = (DeviceFansType.DeviceFanType)fanList.get(i);
                connectionType = fanType.getDeviceFanBayOccupanType();
                fan = this.m_objFactory.createFANS();
                bayOccupiedByFan = connectionType.getCONNECTION();
                BladeIMELogger.log("The Bay Occupied by the Slot:" + bayOccupiedByFan);
                fanBayList.add(bayOccupiedByFan);
                fan.setBayNumber(Integer.parseInt(this.getValue(bayOccupiedByFan)));
                fan.setHasDevice("PRESENT");
                Status status = this.m_objFactory.createStatus();
                String fanStatus = this.getHealthStatusValue(fanType.getStatus());
                status.setUID(fanStatus);
                status.setTitle(MonteroResourceManager.getInstance().getString("xml." + fanStatus, this.getLoginBean().getLocale()));
                fan.setStatus(status);
                fan.setPartNumber(this.getValue(fanType.getPN()));
                fan.setPowerUsed(this.getValue(fanType.getPWRDUsed()));
                fan.setSpeed(this.getValue(fanType.getRPMCur()));
                fans.add(fan);
            }
            this.createEmptyFans(fanBayList, fans);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxBPVOverlordEnclosure.renderFANDetails");
        }
    }

    private String getHealthStatusValue(String overStatus) {
        BladeIMELogger.log("Start:MxBPVOverlordEnclosure.getHealthStatusValue(" + overStatus + ")");
        String status = "Unknown";
        status = overStatus == null ? "Unknown" : (overStatus.equalsIgnoreCase("ok") || overStatus.equalsIgnoreCase("normal") || overStatus.equalsIgnoreCase("completed") ? "Normal" : (overStatus.equalsIgnoreCase("other") || overStatus.equalsIgnoreCase("unknown") || overStatus.equalsIgnoreCase("NO CONTACT") ? "Unknown" : (overStatus.equalsIgnoreCase("POWER MODE") || overStatus.equalsIgnoreCase("DORMANT") || overStatus.equalsIgnoreCase("STARTING") || overStatus.equalsIgnoreCase("STOPPING") || overStatus.equalsIgnoreCase("informational") ? "Informational" : (overStatus.equalsIgnoreCase("IN SERVICE") || overStatus.equalsIgnoreCase("disabled") ? "Disabled" : (overStatus.equalsIgnoreCase("DEGRADED") || overStatus.equalsIgnoreCase("STRESSED") || overStatus.equalsIgnoreCase("minor") || overStatus.equalsIgnoreCase("STOPPED") ? "Minor" : (overStatus.equalsIgnoreCase("PREDICTIVE FAILURE") || overStatus.equalsIgnoreCase("ABORTED") || overStatus.equalsIgnoreCase("SUPPORTING ENTITY IN ERROR") || overStatus.equalsIgnoreCase("major") ? "Major" : (overStatus.equalsIgnoreCase("ERROR") || overStatus.equalsIgnoreCase("Critical") || overStatus.equalsIgnoreCase("NON-RECOVERABLE ERROR") || overStatus.equalsIgnoreCase("LOST COMMUNICATION") ? "Critical" : (overStatus.equalsIgnoreCase("WARNINIG_STATUS") || overStatus.equalsIgnoreCase("WARNINIG") ? "Warning" : "Unknown"))))))));
        BladeIMELogger.log("Return Value:" + status);
        BladeIMELogger.log("End:MxBPVOverlordEnclosure.getHealthStatusValue(" + overStatus + ")");
        return status;
    }

    private void createEmptyFans(List fanBayList, List fans) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.createEmptyFans");
        int FANS_NUMBER = 10;
        FANS fan = null;
        BladeIMELogger.log("Total number of Fans present in the OverlordEnclosure:" + fanBayList.size());
        try {
            for (int i = 1; i <= 10; ++i) {
                if (fanBayList.contains("" + i)) continue;
                fan = this.m_objFactory.createFANS();
                fan.setBayNumber(i);
                fan.setHasDevice("ABSENT");
                fans.add(fan);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxBPVOverlordEnclosure.createEmptyFans");
        }
    }

    private void renderPowerUnitDetails(BladeEnclosure enclosure) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.renderPowerUnitDetails(JaxBObject " + enclosure);
        List powerUnitsList = enclosure.getPowerSupplyUnit();
        EnclosurePowerType powerType = this.m_enclosureObj.getEnclosurePowerType();
        List powerUnitTypeList = powerType.getEnclosurePowerSupplyTypeList();
        PowerSupplyUnit powerUnit = null;
        EnclosurePowerSupplyType powerUnitType = null;
        List attributeList = null;
        ArrayList<String> pwrUnitsBayList = new ArrayList<String>();
        int noOfPowerUnits = powerUnitTypeList.size();
        BladeIMELogger.log("Total number of Power units present in the enclosure:" + noOfPowerUnits);
        try {
            for (int i = 0; i < noOfPowerUnits; ++i) {
                powerUnitType = (EnclosurePowerSupplyType)powerUnitTypeList.get(i);
                powerUnit = this.m_objFactory.createPowerSupplyUnit();
                powerUnit.setHasDevice("PRESENT");
                int powerUnitBayNumber = powerUnitType.getConnection();
                BladeIMELogger.log("Add the Power Unit BayNumber " + powerUnitBayNumber + " to the List");
                pwrUnitsBayList.add("" + powerUnitBayNumber);
                powerUnit.setBayNumber(powerUnitBayNumber);
                String acInput = this.getHealthStatusValue(powerUnitType.getACInput());
                powerUnit.setACInput(acInput);
                String puStatus = this.getHealthStatusValue(powerUnitType.getStatus());
                Status status = this.m_objFactory.createStatus();
                status.setUID(puStatus);
                status.setTitle(MonteroResourceManager.getInstance().getString("xml." + puStatus, this.getLoginBean().getLocale()));
                powerUnit.setStatus(status);
                attributeList = powerUnit.getAttribute();
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.firmwareRevision", this.loginBean.getLocale()), this.getValue(powerUnitType.getFRWI())));
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.partNumber", this.loginBean.getLocale()), this.getValue(powerUnitType.getPN())));
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.serialNumber", this.loginBean.getLocale()), this.getValue(powerUnitType.getSN())));
                attributeList.add(this.getAttribute("Power Supply Unit", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.ACInput", this.loginBean.getLocale()), this.getValue(this.getHealthStatus(powerUnitType.getACInput()))));
                powerUnitsList.add(powerUnit);
                this.renderPowerUnitPowerDetails(powerUnit, powerUnitType);
            }
            this.createEmptyPowerUnits(pwrUnitsBayList, powerUnitsList);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVOverlord.renderPowerUnitDetails()");
        }
    }

    private void renderVCMDetails(BladeEnclosure enclosure) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.renderVCMDetails(JaxBObject " + enclosure);
        boolean vcmMode = this.m_enclosureObj.getEnclosureVCMMode();
        String vcmURL = this.m_enclosureObj.getEnclosureVCMURL();
        String vcmDomainName = this.m_enclosureObj.getEnclosureVCMDomainName();
        String vcmDomainID = this.m_enclosureObj.getEnclosureVCMDomainID();
        BladeIMELogger.log("vcmMode:" + vcmMode);
        BladeIMELogger.log("vcmURL:" + vcmURL);
        BladeIMELogger.log("vcmDomainName:" + vcmDomainName);
        BladeIMELogger.log("vcmDomainID:" + vcmDomainID);
        try {
            String normalizedURL;
            VCMType vcm = this.m_objFactory.createVCMType();
            vcm.setVcmMode(vcmMode);
            vcm.setVcmDomainName(vcmDomainName);
            vcm.setVcmURL(vcmURL);
            vcm.setVcmDomainID(vcmDomainID);
            enclosure.setVCM(vcm);
            if (vcmURL != null && vcmURL.trim().length() > 0 && !vcmURL.equalsIgnoreCase("empty") && (normalizedURL = this.normalizeURL(vcmURL)) != null) {
                List attributeList = enclosure.getAttribute();
                attributeList.add(this.getAttribute("Identification", "Both", null, "true", vcmURL, "true", "Virtual Connect Manager", normalizedURL));
                if (vcmDomainName != null && vcmDomainName.trim().length() > 0) {
                    attributeList.add(this.getAttribute("Identification", "Both", null, null, null, "false", "VCM Domain Name", vcmDomainName));
                }
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVOverlord.renderVCMDetails()");
        }
    }

    private String normalizeURL(String URLpattern) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.normalizeURL");
        try {
            URL url = new URL(URLpattern);
            return url.getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void createEmptyPowerUnits(List pwrUnitsBayList, List powerUnitsList) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.createEmptyPowerUnits");
        int POWERUNITS_NUMBER = 6;
        PowerSupplyUnit powerUnit = null;
        BladeIMELogger.log("Total number of Power Units present in the Overlord Enclsoure:" + pwrUnitsBayList.size());
        try {
            for (int i = 1; i <= 6; ++i) {
                if (pwrUnitsBayList.contains("" + i)) continue;
                powerUnit = this.m_objFactory.createPowerSupplyUnit();
                powerUnit.setBayNumber(i);
                powerUnit.setHasDevice("ABSENT");
                powerUnitsList.add(powerUnit);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "MxBPVOverlordEnclosure.createEmptyPowerUnits");
        }
    }

    private void renderPowerUnitPowerDetails(PowerSupplyUnit jaxbPowerUnit, EnclosurePowerSupplyType powerUnitType) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.renderPowerUnitPowerDetails");
        try {
            Power jaxbPower = this.m_objFactory.createPower();
            jaxbPower.setPowerAvailable(this.getValue(powerUnitType.getCapacity()));
            jaxbPower.setPowerUsed(this.getValue(powerUnitType.getActualOutput()));
            jaxbPowerUnit.setPower(jaxbPower);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVOverlordEnclosure.renderPowerUnitPowerDetails");
        }
    }

    private void createEnclosureAttributes(BladeEnclosure enclosure) {
        List attributeList = enclosure.getAttribute();
        Object attribute = null;
        BladeIMELogger.log("Enclosure Status:" + this.getStatus());
        attributeList.add(this.getAttribute("System Status", "Both", "true", null, null, null, this.m_manager.getString("xml.status", this.loginBean.getLocale()), this.getHealthStatus(this.getStatus())));
        attributeList.add(this.getAttribute("Identification", "RackView", null, "true", "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + this.node.getGUID() + "&drillDownType=DrillDownType-DeviceName&globalselection=true", null, this.m_manager.getString("xml.enclosureName", this.loginBean.getLocale()), this.getValue(this.node.getNameString())));
        attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.enclosureName", this.loginBean.getLocale()), this.getValue(this.node.getNameString())));
        attributeList.add(this.getAttribute("Identification", "Both", null, null, null, null, this.m_manager.getString("xml.serialNumber", this.loginBean.getLocale()), this.getValue(this.node.getSerialNumber())));
        attributeList.add(this.getAttribute("Identification", "Both", null, null, null, null, this.m_manager.getString("xml.uuid", this.loginBean.getLocale()), this.getValue(this.node.getAgentUUID())));
        MxNode rackNode = EnclosureNodeUpdater.getRackNode(this.node);
        if (rackNode != null) {
            attributeList.add(this.getAttribute("Identification", "EnclosureView", null, "true", "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + rackNode.getGUID().toString() + "&drillDownType=DrillDownType-DeviceName&globalselection=true", null, this.m_manager.getString("xml.rName", this.loginBean.getLocale()), this.getValue(rackNode.getNameString())));
            attributeList.add(this.getAttribute("Identification", "RackView", null, null, null, null, this.m_manager.getString("xml.rName", this.loginBean.getLocale()), this.getValue(rackNode.getNameString())));
        } else {
            attributeList.add(this.getAttribute("Identification", "EnclosureView", null, null, null, null, this.m_manager.getString("xml.rName", this.loginBean.getLocale()), this.m_manager.getString("NOT_AVAILABLE", this.loginBean.getLocale())));
        }
        attributeList.add(this.getAttribute("Identification", "Both", "false", null, null, null, this.m_manager.getString("xml.uidStatus", this.loginBean.getLocale()), this.getValue(this.m_enclosureObj.getEnclosureUUIDStatus())));
        String oaName = this.m_manager.getString("xml.OALink", this.loginBean.getLocale());
        try {
            oaName = this.returnPrimaryOANode().getNameString();
        }
        catch (MxBPVException bpvExcep) {
            BladeIMELogger.log("Could not get the OA Name from the Node,Hence setting OnBoardAdministrator as the value for the SSO link in Rack/Enclosure view.");
        }
        attributeList.add(this.getAttribute("Identification", "Both", null, "true", "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + this.node.getSerialNumber() + "&deviceType=" + NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString(), "true", this.m_manager.getString("xml.OALink", this.loginBean.getLocale()), oaName));
    }

    private void createEnclPwrThermalAttributes(BladeEnclosure enclosure) {
        BladeIMELogger.log("MxBPVOverlordEnclosure:createAttributes(MxNode " + this.node.getNameString() + "BladeEnclosure " + enclosure);
        List attributeList = enclosure.getAttribute();
        Object inputTemp = null;
        Object outputTemp = null;
        DeviceTempsType deviceTemps = this.m_enclosureObj.getDeviceTempsType();
        this.renderTemperatureInfo(deviceTemps.getDeviceTempTypeList(), enclosure.getTemperature());
        EnclosurePowerType powerType = this.m_enclosureObj.getEnclosurePowerType();
        attributeList.add(this.getAttribute("Power And Thermal", "Both", null, "true", "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + this.node.getSerialNumber() + "&deviceType=" + NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString(), "true", this.m_manager.getString("xml.powerRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(powerType.getRedundancy())));
        DeviceFansType fansType = this.m_enclosureObj.getDeviceFansType();
        attributeList.add(this.getAttribute("Power And Thermal", "Both", null, "true", "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + this.node.getSerialNumber() + "&deviceType=" + NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString(), "true", this.m_manager.getString("xml.FanRedundancy", this.loginBean.getLocale()), this.getRedundancyValue(fansType.getRedundancy())));
    }

    private String getRedundancyValue(String redundancy) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.getRedundancyValue(String " + redundancy + ")");
        String value = null;
        value = redundancy != null && redundancy.equalsIgnoreCase("NON_REDUNDANT") ? this.m_manager.getString("xml.NonRedundant", this.loginBean.getLocale()) : (redundancy != null && redundancy.equalsIgnoreCase("REDUNDANT") ? this.m_manager.getString("xml.Redundant", this.loginBean.getLocale()) : this.m_manager.getString("xml.Unknown", this.loginBean.getLocale()));
        BladeIMELogger.log("The Redundancy Value is:" + value);
        return value;
    }

    private void setOverlordDevices(int index, MxBPVElement element, boolean OA) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.setOverlordDevices(int " + index + ",MxBPVElement " + element + ",boolean " + OA);
        if (!OA) {
            BladeIMELogger.log("Set the Element:" + element + "to the enclosure contents at:" + index);
            BladeIMELogger.log("m_switchContents:" + this.m_switchContents);
            BladeIMELogger.log("m_switchContents.get(index)" + this.m_switchContents.get(index));
            this.m_switchContents.set(index, element);
        } else {
            BladeIMELogger.log("Set the Element:" + element + "to the enclosure contents at:" + index);
            this.m_oAContents.set(index, element);
            BladeIMELogger.log("m_oAContents:" + this.m_oAContents);
        }
    }

    private MxNode returnPrimaryOANode() throws MxBPVException {
        BladeIMELogger.log("MxBPVOverlordEnclosure.returnPrimaryOANode()");
        MxBPVElement element = null;
        MxNode oANode = null;
        OnboardAdministrator oAObj = null;
        int oASize = this.m_oAContents.size();
        try {
            for (int i = 0; !(i >= this.m_oAContents.size() || (element = (MxBPVElement)this.m_oAContents.get(i)) instanceof MxBPVOnboardAdministrator && (oAObj = (OnboardAdministrator)this.m_oaHelper.getOLDevice(oANode = element.getNode(), oANode)).getIsPrimary()); ++i) {
            }
        }
        catch (OAException e1) {
            BladeIMELogger.log(e1, "Exception in MxBPVOverlordEnclsoure.returnPrimaryOANode()");
        }
        if (oANode == null) {
            throw new MxBPVException("OA Not found to update the Enclosure details");
        }
        BladeIMELogger.log("The Primary OA node:" + oANode.getNameString());
        return oANode;
    }

    public void updateOverlordDeviceDetails() {
        BladeIMELogger.log("MxBPVOverlordEnclosure.updateOverlordDeviceDetails()");
        try {
            MxNode oANode = this.returnPrimaryOANode();
            if (oANode != null) {
                BladeIMELogger.log("The OANode is not null.So update the Data on the respective devices");
                this.m_oaHelper.refreshData(oANode);
            } else {
                BladeIMELogger.log("The OANode is null.So cannot update the Data on the respective devices");
            }
        }
        catch (OAException oae) {
            BladeIMELogger.log(oae, "OAException in MxBPVOverlordEnclosure.updateOverlordDeviceDetails()");
        }
        catch (MxBPVException mxbpve) {
            BladeIMELogger.log(mxbpve, "The BPV will be displayed with stale information");
        }
    }

    private void renderTemperatureInfo(List deviceTempInfoList, List jaxbTempList) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.renderTemperatureInfo(List " + deviceTempInfoList + ",List " + jaxbTempList + ")");
        DeviceTempsType.DeviceTempType deviceTemp = null;
        Temperature jaxbTemperature = null;
        Object atrribute = null;
        int deviceTempSize = deviceTempInfoList.size();
        Object attributeList = null;
        String tempDescription = null;
        String temperature = null;
        BladeIMELogger.log("The temperature List size:" + deviceTempSize);
        try {
            for (int i = 0; i < deviceTempSize; ++i) {
                deviceTemp = (DeviceTempsType.DeviceTempType)deviceTempInfoList.get(i);
                tempDescription = deviceTemp.getDESC();
                BladeIMELogger.log("Temperature Description:" + tempDescription);
                if (tempDescription == null || !tempDescription.equalsIgnoreCase("AMBIENT")) continue;
                jaxbTemperature = this.m_objFactory.createTemperature();
                temperature = deviceTemp.getC();
                if (temperature == null || temperature.equalsIgnoreCase("")) {
                    jaxbTemperature.setCurrent(this.m_manager.getString("NOT_AVAILABLE", this.loginBean.getLocale()));
                } else {
                    jaxbTemperature.setCurrent(temperature);
                }
                this.renderThreshold(deviceTemp, jaxbTemperature);
                jaxbTempList.add(jaxbTemperature);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "Exception in MxBPVOverlordenclsoure.renderTemperatureInfo()");
        }
    }

    private void renderThreshold(DeviceTempsType.DeviceTempType deviceTempInfo, Temperature jaxbTemperature) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.renderThreshold");
        List thresholdList = deviceTempInfo.getDeviceThreashold();
        int thresholdSize = thresholdList.size();
        String thresholdDesc = null;
        BladeIMELogger.log("The Threshold List size:" + thresholdSize);
        try {
            TemperatureType.ThresholdType jaxbThreshold = this.m_objFactory.createTemperatureTypeThresholdType();
            for (int i = 0; i < thresholdSize; ++i) {
                DeviceTempsType.DeviceTempType.DeviceThresholdType thresholdInfo = (DeviceTempsType.DeviceTempType.DeviceThresholdType)thresholdList.get(i);
                thresholdDesc = thresholdInfo.getDescription();
                BladeIMELogger.log("Threshold Description:" + thresholdDesc);
                if (thresholdDesc != null && thresholdDesc.equalsIgnoreCase("CAUTION")) {
                    jaxbThreshold.setCaution(this.getValue(thresholdInfo.getC()));
                    continue;
                }
                if (thresholdDesc == null || !thresholdDesc.equalsIgnoreCase("CRITICAL")) continue;
                jaxbThreshold.setCritical(this.getValue(thresholdInfo.getC()));
            }
            jaxbTemperature.setThreshold(jaxbThreshold);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVOverlordEnclosure.renderThreshold");
        }
    }

    private String getValue(String value) {
        BladeIMELogger.log("MxBPVOverlordEnclosure.getValue(String " + value + ")");
        if (value == null || value.equalsIgnoreCase("")) {
            return this.m_manager.getString("NOT_AVAILABLE", this.loginBean.getLocale());
        }
        return value;
    }

    private String getHealthStatus(String value) {
        if (value == null) {
            return "Unknown";
        }
        return value;
    }

    private Attribute getAttribute(String section, String location, String displayAsImage, String displayAsURL, String URL2, String displayInWindow, String name, String value) {
        Attribute attribute = null;
        try {
            attribute = this.m_objFactory.createAttribute();
            if (section != null) {
                attribute.setSection(section);
            }
            if (location != null) {
                attribute.setLocation(location);
            }
            if (displayAsImage != null) {
                attribute.setDisplayAsImage(displayAsImage);
            }
            if (displayAsURL != null) {
                attribute.setDisplayAsURL(displayAsURL);
            }
            if (URL2 != null) {
                attribute.setURL(URL2);
                attribute.setDispInWindow(displayInWindow);
            }
            attribute.setName(name);
            attribute.setValue(value);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "Exception in MxBPVOverlordEnclosure.getAttribute()");
        }
        return attribute;
    }
}

