/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.portal.bpv.MxBPVDesktop;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVEmptySlot;
import com.hp.mx.portal.bpv.MxBPVServer;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import java.util.ArrayList;
import java.util.List;

public class MxBPVGardianServerEnclosure
extends MxBPVServerEnclosure {
    private final int numSlots = 20;
    private final int firstSlotNumber = 1;

    public MxBPVGardianServerEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
    }

    public int getNumSlots() {
        return 20;
    }

    public int getFirstSlotNumber() {
        return 1;
    }

    public void populateAll() throws Exception {
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.setSize(this.getFirstSlotNumber() + this.getNumSlots());
        int slotNumber = this.getFirstSlotNumber();
        while (slotNumber < this.getFirstSlotNumber() + this.getNumSlots()) {
            boolean foundSomethingInSlot = false;
            MxNode device = nodeAssociations.getDeviceBySlotNumber(slotNumber);
            if (device != null) {
                MxNode childNode = nodeClient.getNodeByKey(device.getDeviceKey(), false);
                ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
                nodeIDs.add(childNode.getObjectID());
                List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
                if (authorizedTools.size() > 0) {
                    if (childNode.getDeviceType().equals("Server")) {
                        MxBPVServer serverElement = new MxBPVServer(childNode, this, this.getLoginBean());
                        this.set(slotNumber, serverElement);
                        slotNumber += serverElement.getNumSlotsUsed();
                        foundSomethingInSlot = true;
                    } else if (childNode.getDeviceType().equals("Desktop")) {
                        MxBPVDesktop desktopElement = new MxBPVDesktop(childNode, this, this.getLoginBean());
                        this.set(slotNumber, desktopElement);
                        ++slotNumber;
                        foundSomethingInSlot = true;
                    }
                }
            }
            if (foundSomethingInSlot) continue;
            this.set(slotNumber, new MxBPVEmptySlot(false, slotNumber, 1, 2));
            ++slotNumber;
        }
    }
}

