/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.querymanager.Query;
import com.hp.mx.core.querymanager.QueryType;
import com.hp.mx.core.querymanager.UndefinedQueryException;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObject;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObjectFactory;
import com.hp.mx.core.tools.identification.associations.SnmpProtocolDataHandler;
import com.hp.mx.core.tools.identification.mgmtproc.MgmtProcessorParser;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVOverlordEnclosure;
import com.hp.mx.portal.bpv.MxBPVPowerSupplyEnclosure;
import com.hp.mx.portal.bpv.MxBPVRack;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.iLOXml.EnclosureNodeUpdater;
import com.hp.mx.portal.iLOXml.ILOAllQueryConstants;
import com.hp.mx.portal.iLOXml.ILOICMBConstants;
import com.hp.mx.portal.iLOXml.ILOParser;
import com.hp.mx.portal.iLOXml.InValidDataException;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MxBPV {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private MxBPVElement m_element = null;
    private MxLoginBean m_loginBean = null;
    private String m_listViewURL = "";
    private String m_iconViewURL = "";
    private String m_treeViewURL = "";
    private int m_listViewId = -1;
    private int m_iconViewId = -1;
    private int m_treeViewId = -1;
    private String m_devicesubType = null;
    private String m_discoveredName = null;

    public void initialize(String guid, MxLoginBean loginBean) throws BladeSystemException {
        MxNode node;
        block21: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("MxBPV.initialize(" + guid + "," + loginBean));
            }
            this.m_loginBean = loginBean;
            node = null;
            try {
                node = this.m_loginBean.getNodeClient().getNode(new MxObjectID(new MxGUID(guid)), false);
                if (node.getDeviceType().equals("Rack")) {
                    this.m_element = new MxBPVRack(node, this.m_loginBean);
                    break block21;
                }
                if (node.getDeviceType().equals("Enclosure")) {
                    List subTypes = node.getDeviceSubTypes();
                    if (subTypes.contains("PowerEnc")) {
                        this.m_devicesubType = "PowerEnc";
                        this.m_element = new MxBPVPowerSupplyEnclosure(node, null, this.m_loginBean);
                    } else {
                        BladeIMELogger.log("The subType list size:" + subTypes.size());
                        this.m_devicesubType = "ServerEnc";
                        this.m_element = MxBPVServerEnclosure.create(node, null, this.m_loginBean);
                    }
                    break block21;
                }
                throw new BladeSystemException("Selected container is neither a Rack/Enclosure");
            }
            catch (Exception e) {
                if (log_.isEnabledFor((Priority)Level.FATAL)) {
                    log_.fatal((Object)("Error initializing BPV: MxBPV.initialize(" + guid + "," + this.m_loginBean + "Error :" + e));
                }
                throw new BladeSystemException("Exception while initializing MxBPV");
            }
        }
        try {
            this.getListViewURL();
            this.getIconViewURL();
            this.getTreeViewURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        log_.debug((Object)("MxBPV.initialize() : element : " + this.m_element));
        if (node.getDeviceType().equals("Rack")) {
            MxBPVRack rackElement = (MxBPVRack)this.m_element;
            Iterator iter = rackElement.iterator();
            log_.debug((Object)"Within if");
            while (iter.hasNext()) {
                log_.debug((Object)"With while");
                MxBPVElement childElement = (MxBPVElement)iter.next();
                if (childElement.getNode().getDeviceSubTypes().contains("c-Class")) {
                    if (log_.isEnabledFor((Priority)Level.FATAL)) {
                        log_.fatal((Object)("Update the Enclosure for the OverlordEnclosure:" + childElement.getNode().getNameString()));
                    }
                    MxBPVOverlordEnclosure overlordEncl = (MxBPVOverlordEnclosure)childElement;
                    overlordEncl.updateOverlordDeviceDetails();
                    continue;
                }
                if (childElement.getDeviceType().equalsIgnoreCase("ServerEnc") || childElement.getDeviceType().equalsIgnoreCase("Enclosure")) {
                    log_.debug((Object)("With Server Enc:" + childElement.getNode().getNameString()));
                    this.getILOData(childElement.getNode());
                    continue;
                }
                if (!childElement.getDeviceType().equalsIgnoreCase("PowerEnc")) continue;
                log_.debug((Object)("With Server Enc:" + childElement.getNode().getNameString()));
                this.getILOData(childElement.getNode());
            }
        } else {
            log_.debug((Object)("Its a enclosure:" + node.getNameString()));
            if (node.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                MxBPVOverlordEnclosure overlordEncl = (MxBPVOverlordEnclosure)this.m_element;
                overlordEncl.updateOverlordDeviceDetails();
            } else if (node.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                log_.debug((Object)("With e-class server Enc:" + node.getNameString()));
                this.getPowerSupplyDetailsFromIA(node);
            } else if (node.getDeviceSubTypes().contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
                this.getILOData(node);
            }
        }
    }

    public void getPowerSupplyDetailsFromIA(MxNode enclosureNode) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("MxBPV.getPowerSupplyDetails(" + enclosureNode + ") Node Name: " + enclosureNode.getNameString()));
        }
        try {
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            log_.debug((Object)("enclosureNode.getDeviceKey():" + enclosureNode.getDeviceKey()));
            Vector IAKeyVect = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(enclosureNode.getDeviceKey(), "MgmtProcToEnclosure");
            Integer vectKey = (Integer)IAKeyVect.elementAt(0);
            int theIADeviceKey = vectKey;
            log_.debug((Object)("theIADeviceKey:" + theIADeviceKey));
            MxNode theIADevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theIADeviceKey);
            log_.debug((Object)("MxBPV.getPowerSupplyDetails : IANODE(" + theIADevice + ") Node Name: " + theIADevice.getNameString()));
            Vector powerDetails = this.getRackPowerSupplyDetailsAndSetOnEncl(theIADevice);
            if (powerDetails.size() > 0) {
                this.setPowerDetailsOnEnclosure(powerDetails, enclosureNode);
            }
        }
        catch (Exception e) {
            log_.debug((Object)("MxBPV.getPowerSupplyDetailsFromIA :exception:" + e));
        }
    }

    public Vector getRackPowerSupplyDetailsAndSetOnEncl(MxNode IANode) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"MxBPV.getRackPowerSupplyDetailsAndSetOnEncl()");
        }
        boolean endOfTable = false;
        String enclSerNoOID = null;
        String powerSupplyIndexOID = null;
        String powerSupplySerialNumOID = null;
        String powerSupplyPosOID = null;
        Vector powerSupplyDetails = new Vector();
        int counter = 0;
        Vector PowerDetails = new Vector();
        SnmpProtocolDataHandler snmpPdh = new SnmpProtocolDataHandler(IANode);
        snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.5.1.1.1.3[0],1.3.6.1.4.1.232.22.2.5.1.1.1.5[1],1.3.6.1.4.1.232.22.2.5.1.1.1.11[2],1.3.6.1.4.1.232.22.2.5.1.1.1.18[3]");
        while (!endOfTable) {
            snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            powerSupplyIndexOID = vb0.getOid();
            log_.debug((Object)("The powerSupplyIndexOID : " + powerSupplyIndexOID));
            SnmpResponseVarBind vb1 = curResp.findById(1);
            if (vb1 == null || vb1.isError()) break;
            powerSupplySerialNumOID = vb1.getOid();
            log_.debug((Object)(" The powerSupplySerialNumOID : " + powerSupplySerialNumOID));
            SnmpResponseVarBind vb2 = curResp.findById(2);
            if (vb2 == null || vb2.isError()) break;
            powerSupplyPosOID = vb2.getOid();
            log_.debug((Object)(" powerSupplyPosOID: " + powerSupplyPosOID));
            SnmpResponseVarBind vb3 = curResp.findById(3);
            if (vb3 == null || vb3.isError()) break;
            enclSerNoOID = vb3.getOid();
            log_.debug((Object)(" The enclSerNoOID: " + enclSerNoOID));
            if (enclSerNoOID.startsWith("1.3.6.1.4.1.232.22.2.5.1.1.1.18.")) {
                Vector<String> tplgy = new Vector<String>();
                String enclosureSerialNumber = vb3.getValue();
                log_.debug((Object)("enclosureSerialNumber:" + enclosureSerialNumber));
                if (enclosureSerialNumber != null && enclosureSerialNumber.trim().length() > 0 && enclosureSerialNumber.trim().length() >= 10 && !enclosureSerialNumber.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureSerialNumber);
                } else {
                    tplgy.add("");
                }
                String powerSupplyIndex = vb0.getValue();
                log_.debug((Object)("powerSupplyIndex:" + powerSupplyIndex));
                if (powerSupplyIndex != null) {
                    tplgy.add(powerSupplyIndex);
                } else {
                    tplgy.add("");
                }
                String powerSupplySerialNum = vb1.getValue();
                log_.debug((Object)("powerSupplySerialNum:" + powerSupplySerialNum));
                if (powerSupplySerialNum != null) {
                    tplgy.add(powerSupplySerialNum);
                } else {
                    tplgy.add("");
                }
                String powerSupplyPos = vb2.getValue();
                if (powerSupplyPos != null) {
                    tplgy.add(powerSupplyPos);
                } else {
                    tplgy.add("");
                }
                PowerDetails.add(tplgy);
                ++counter;
                snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyIndexOID, "0");
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplySerialNumOID, "1");
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyPosOID, "2");
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclSerNoOID, "3");
                continue;
            }
            log_.debug((Object)("enclosure serial number oid was not correct" + enclSerNoOID));
            break;
        }
        return PowerDetails;
    }

    public void setPowerDetailsOnEnclosure(Vector powerDetails, MxNode enclosureNode) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"MxBPV.setPowerDetailsOnEnclosure()");
        }
        boolean leftPowerSupPresent = false;
        boolean rightPowerSupPresent = false;
        for (int i = 0; i < powerDetails.size(); ++i) {
            Vector tplgy = (Vector)powerDetails.elementAt(i);
            String powerSupIndex = (String)tplgy.elementAt(1);
            String powerSupSerialNum = (String)tplgy.elementAt(2);
            log_.debug((Object)("powerSupIndex:" + powerSupIndex));
            log_.debug((Object)("powerSupSerialNum:" + powerSupSerialNum));
            if (powerSupIndex.equals("00000001") && powerSupSerialNum != null && powerSupSerialNum != "") {
                leftPowerSupPresent = true;
            }
            if (!powerSupIndex.equals("00000002") || powerSupSerialNum == null || powerSupSerialNum == "") continue;
            rightPowerSupPresent = true;
        }
        log_.debug((Object)("leftPowerSupPresent:" + leftPowerSupPresent));
        log_.debug((Object)("rightPowerSupPresent:" + rightPowerSupPresent));
        try {
            enclosureNode.setClientAttribute("leftPowerSupply", String.valueOf(leftPowerSupPresent));
            enclosureNode.setClientAttribute("rightPowerSupply", String.valueOf(rightPowerSupPresent));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void getILOData(MxNode node) {
        block16: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("MxBPV.getILOData(" + node + ") Node Name: " + node.getNameString()));
            }
            try {
                String advILO_IP = node.getClientAttribute("AdviLO.AdvanedILO_IP");
                if (advILO_IP != null) {
                    StringBuffer allQueryURL = new StringBuffer("http://");
                    allQueryURL.append(advILO_IP);
                    allQueryURL.append("/xmlData?item=All");
                    log_.debug((Object)("ALL Query URL:" + allQueryURL.toString()));
                    ILOParser iLOParser = ILOParser.getInstance();
                    MgmtProcessorParser mpp = new MgmtProcessorParser();
                    String xmlAllData = mpp.sendTheRequest(allQueryURL.toString());
                    if (log_.isEnabledFor((Priority)Level.FATAL)) {
                        log_.fatal((Object)"Xml Data from ILO :");
                        log_.fatal((Object)xmlAllData);
                    }
                    mpp.setXmlData(xmlAllData);
                    if (xmlAllData != null) {
                        Element rootElement = mpp.getXmlRootElement();
                        ILOAllQueryConstants iLOConstants = iLOParser.processAllQueryXml(rootElement);
                        String icmbAddr = iLOConstants.infraIcmbAddr;
                        StringBuffer icmbURL = new StringBuffer("http://");
                        icmbURL.append(advILO_IP);
                        icmbURL.append("/xmlData?item=icmb&addr=");
                        String enclPRD_ID = node.getClientAttribute("AdviLO.pwrEncl.Prod_ID");
                        boolean enclType = false;
                        String url = null;
                        if (enclPRD_ID == null || enclPRD_ID.equalsIgnoreCase("")) {
                            enclType = true;
                            StringBuffer serverEnclURL = new StringBuffer(icmbURL.toString());
                            serverEnclURL.append(icmbAddr);
                            url = serverEnclURL.toString();
                        } else {
                            Vector powerEnclInfo = iLOConstants.rkTplgyHolder;
                            for (int j = 0; j < powerEnclInfo.size(); ++j) {
                                Vector powerEncl = (Vector)powerEnclInfo.elementAt(j);
                                if (node.getSerialNumber() == null || !powerEncl.elementAt(1).equals(node.getSerialNumber())) continue;
                                StringBuffer powerEnclURL = new StringBuffer(icmbURL.toString());
                                powerEnclURL.append(powerEncl.elementAt(2));
                                url = powerEnclURL.toString();
                            }
                        }
                        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                            log_.debug((Object)("ICMB Query URL:" + url));
                        }
                        String icmbData = mpp.sendTheRequest(url);
                        if (log_.isEnabledFor((Priority)Level.FATAL)) {
                            log_.fatal((Object)"Xml Data from ILO ICMB");
                            log_.fatal((Object)icmbData);
                        }
                        mpp.setXmlData(icmbData);
                        if (icmbData != null) {
                            Element icmbElement = mpp.getXmlRootElement();
                            ILOICMBConstants icmbConstants = iLOParser.processICMBQueryXml(icmbElement, enclType);
                            EnclosureNodeUpdater.updateEnclNode(node, icmbConstants, enclType);
                            EnclosureNodeUpdater.display(node, enclType);
                            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), node, false);
                        }
                    }
                } else if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)"MxBPV.getILOData() iloIP not found for the device ");
                }
            }
            catch (InValidDataException ex) {
                if (log_.isEnabledFor((Priority)Level.ERROR)) {
                    log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
                }
            }
            catch (Exception e) {
                if (!log_.isEnabledFor((Priority)Level.ERROR)) break block16;
                log_.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)e);
            }
        }
    }

    public MxLoginBean getLoginBean() {
        return this.m_loginBean;
    }

    public String getEnclosureType() {
        return this.m_devicesubType;
    }

    public String getXML() throws MxBPVException {
        MxNode currentNode = this.m_element.getNode();
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("MxBPV.getXML():Node Name " + currentNode.getNameString()));
        }
        Element root = this.renderXML();
        if (!this.m_element.getDeviceType().equalsIgnoreCase("PowerEnc")) {
            String temp = "Section:NavigationURL,Selected:No,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.List", this.m_loginBean.getLocale());
            Element attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, this.m_listViewURL);
            root.addContent((Content)attribute);
            temp = "Section:NavigationURL,Selected:No,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.Tree", this.m_loginBean.getLocale());
            attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, this.m_treeViewURL);
            root.addContent((Content)attribute);
            temp = "Section:NavigationURL,Selected:No,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.Icons", this.m_loginBean.getLocale());
            attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, this.m_iconViewURL);
            root.addContent((Content)attribute);
            temp = "Section:NavigationURL,Selected:Yes,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.Picture", this.m_loginBean.getLocale());
            attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, "");
            root.addContent((Content)attribute);
        }
        Element i18n = BPVXML.createElement("I18N", null);
        i18n.addContent((Content)BPVXML.createElement("L10NFrontView", MonteroResourceManager.getInstance().getString("xml.FrontView", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRearView", MonteroResourceManager.getInstance().getString("xml.RearView", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAllBlades", MonteroResourceManager.getInstance().getString("xml.AllBlades", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAllInterconnectSwitches", MonteroResourceManager.getInstance().getString("xml.AllInterconnectSwitches", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPowerAndThermal", MonteroResourceManager.getInstance().getString("xml.powerAndThermal", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NViewAs", MonteroResourceManager.getInstance().getString("xml.ViewAs", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSelect", MonteroResourceManager.getInstance().getString("xml.Select", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NIdentification", MonteroResourceManager.getInstance().getString("xml.Identification", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSystemStatus", MonteroResourceManager.getInstance().getString("xml.SystemStatus", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPowerSupplyUnit", MonteroResourceManager.getInstance().getString("xml.powerSupplyUnit", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NILOUpdateMessage", MonteroResourceManager.getInstance().getString("xml.iloUpdateMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEmptyBay", MonteroResourceManager.getInstance().getString("xml.emptyBay", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NBay", MonteroResourceManager.getInstance().getString("xml.bay", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMinimize", MonteroResourceManager.getInstance().getString("xml.minimize", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMaximize", MonteroResourceManager.getInstance().getString("xml.maximize", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSlideLeft", MonteroResourceManager.getInstance().getString("xml.slideLeft", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSlideRight", MonteroResourceManager.getInstance().getString("xml.slideRight", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEmptyRackMessage", MonteroResourceManager.getInstance().getString("xml.EmptyRackMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTheEmptyRackMessage", MonteroResourceManager.getInstance().getString("xml.TheEmptyRackMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NHealthStatus", MonteroResourceManager.getInstance().getString("xml.status", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFirmwareRevision", MonteroResourceManager.getInstance().getString("xml.firmwareRevision", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTableHdrFrmRev", MonteroResourceManager.getInstance().getString("xml.TableHdrFrmRev", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NACInput", MonteroResourceManager.getInstance().getString("xml.acInput", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTemp", MonteroResourceManager.getInstance().getString("xml.Temp", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTrip", MonteroResourceManager.getInstance().getString("xml.Trip", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFail", MonteroResourceManager.getInstance().getString("xml.Fail", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NCF", MonteroResourceManager.getInstance().getString("xml.CF", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NStatus", MonteroResourceManager.getInstance().getString("xml.Status", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NInputTemperature", MonteroResourceManager.getInstance().getString("xml.InputTemperature", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NGraph", MonteroResourceManager.getInstance().getString("xml.Graph", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NOutputTemperature", MonteroResourceManager.getInstance().getString("xml.OutputTemperature", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NA", MonteroResourceManager.getInstance().getString("xml.BayA", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NB", MonteroResourceManager.getInstance().getString("xml.BayB", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("HWStatusToolTip", MonteroResourceManager.getInstance().getString("xml.tooltip.HWSTATUS", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("AMStatusToolTip", MonteroResourceManager.getInstance().getString("xml.tooltip.AMSTATUS", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("DetailsToolTip", MonteroResourceManager.getInstance().getString("tooltip.DetailMsg", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPhase", MonteroResourceManager.getInstance().getString("xml.pwrUnitPhase", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSerialNumber", MonteroResourceManager.getInstance().getString("xml.serialNumber", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPartNumber", MonteroResourceManager.getInstance().getString("xml.partNumber", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPowerConsumption", MonteroResourceManager.getInstance().getString("xml.PowerConsumption", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NType", MonteroResourceManager.getInstance().getString("TYPE", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEnclosureName", MonteroResourceManager.getInstance().getString("xml.enclosureName", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NNormalStatus", MonteroResourceManager.getInstance().getString("xml.Normal", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMajorStatus", MonteroResourceManager.getInstance().getString("xml.Major", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NCriticalStatus", MonteroResourceManager.getInstance().getString("xml.Critical", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFANS", MonteroResourceManager.getInstance().getString("xml.Fans", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NWatts", MonteroResourceManager.getInstance().getString("xml.Watts", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10OUPCAP", MonteroResourceManager.getInstance().getString("xml.OutCap", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEClass14Message", MonteroResourceManager.getInstance().getString("xml.eClassMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NCautionStatus", MonteroResourceManager.getInstance().getString("xml.caution", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPOWERSUPPLY", MonteroResourceManager.getInstance().getString("xml.PowerSupply", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NLeftPSU", MonteroResourceManager.getInstance().getString("xml.LeftPSU", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRightPSU", MonteroResourceManager.getInstance().getString("xml.RightPSU", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NProductName", MonteroResourceManager.getInstance().getString("xml.Name", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NProductModel", MonteroResourceManager.getInstance().getString("xml.productModel", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRole", MonteroResourceManager.getInstance().getString("xml.Role", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NHostServer", MonteroResourceManager.getInstance().getString("xml.HostServer", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NStorageServer", MonteroResourceManager.getInstance().getString("xml.StorageServer", this.m_loginBean.getLocale())));
        if (MxBPVServerEnclosure.getEnclosureSubType(this.m_element.getNode()).equalsIgnoreCase(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            i18n.addContent((Content)BPVXML.createElement("L10NAllEMs", MonteroResourceManager.getInstance().getString("xml.EnclosureManager", this.m_loginBean.getLocale())));
            i18n.addContent((Content)BPVXML.createElement("L10NEnclosureAmbientTemp", MonteroResourceManager.getInstance().getString("xml.ENCLAMBTEMP", this.m_loginBean.getLocale())));
            i18n.addContent((Content)BPVXML.createElement("L10NPowerUsed", MonteroResourceManager.getInstance().getString("xml.POWERUSED", this.m_loginBean.getLocale())));
            i18n.addContent((Content)BPVXML.createElement("L10NCurSpeedRPM", MonteroResourceManager.getInstance().getString("xml.RPMSPEED", this.m_loginBean.getLocale())));
            i18n.addContent((Content)BPVXML.createElement("L10NFAN", MonteroResourceManager.getInstance().getString("xml.Fan", this.m_loginBean.getLocale())));
            i18n.addContent((Content)BPVXML.createElement("L10NACTIVEOA", MonteroResourceManager.getInstance().getString("xml.activeOA", this.m_loginBean.getLocale())));
            i18n.addContent((Content)BPVXML.createElement("L10NSTANDBYOA", MonteroResourceManager.getInstance().getString("xml.passiveOA", this.m_loginBean.getLocale())));
            i18n.addContent((Content)BPVXML.createElement("L10NPIM", MonteroResourceManager.getInstance().getString("xml.pim", this.m_loginBean.getLocale())));
        }
        root.addContent((Content)i18n);
        Document xmlDoc = root.getDocument();
        if (xmlDoc == null) {
            xmlDoc = new Document(root);
        }
        String nodeXml = null;
        try {
            XMLOutputter serializer = new XMLOutputter();
            serializer.setFormat(Format.getPrettyFormat());
            serializer.getFormat().setLineSeparator(System.getProperty("line.separator"));
            nodeXml = serializer.outputString(xmlDoc);
        }
        catch (Exception e) {
            if (log_.isEnabledFor((Priority)Level.ERROR)) {
                // empty if block
            }
        }
        return nodeXml;
    }

    public Element renderXML() throws MxBPVException {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"Start:MxBPV.renderXML()");
        }
        if (this.m_element != null) {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("Name of Element:" + this.m_element.getName()));
            }
            return this.m_element.renderXML();
        }
        return null;
    }

    public String getListViewURL() throws Exception {
        if (this.m_element == null) {
            return "";
        }
        MxNode node = this.m_element.getNode();
        if (this.m_listViewURL.equals("") || !node.getDiscoveredName().equalsIgnoreCase(this.m_discoveredName)) {
            this.m_discoveredName = node.getDiscoveredName().toString();
            MxQueryClient queryClient = this.m_loginBean.getQueryClient();
            Query query = null;
            try {
                query = queryClient.getQuery(node.getNameString() + "_bpvList");
            }
            catch (UndefinedQueryException e) {
                // empty catch block
            }
            if (query != null) {
                this.m_listViewId = query.getQueryId();
            } else {
                CriteriaDataObjectFactory criteriaFactory = queryClient.getCriteriaFactory();
                CriteriaDataObject criteria = node.getDeviceType().equals("Rack") ? criteriaFactory.getObject("CriteriaByRack") : criteriaFactory.getObject("CriteriaByEnclosure");
                criteria.addCriteriaValue(node.getNameString());
                Query newQuery = new Query(node.getNameString() + "_bpvList", QueryType.DEVICE.toString());
                newQuery.setDynamic(true);
                newQuery.addCriteriaObject(criteria, this.m_loginBean.getLocale());
                this.m_listViewId = queryClient.addQuery(newQuery, this.m_loginBean.getLocale());
            }
            this.m_listViewURL = "/ui/jsp/XeHdr.jsp?PageName=viewContentsDevices&viewid=" + Integer.toString(this.m_listViewId) + "&topMenuIndex=1&BigPictureView=" + Integer.toString(node.getKey()) + "&ViewType=DeviceViews&retainSelection=1" + "&queryDisplayName=" + node.getNameString() + "&expandAll=true";
        }
        return this.m_listViewURL;
    }

    public String getTreeViewURL() throws Exception {
        if (this.m_element == null) {
            return "";
        }
        MxNode node = this.m_element.getNode();
        if (this.m_treeViewURL.equals("") || !node.getDiscoveredName().equalsIgnoreCase(this.m_discoveredName)) {
            this.m_discoveredName = node.getDiscoveredName().toString();
            MxQueryClient queryClient = this.m_loginBean.getQueryClient();
            Query query = null;
            try {
                query = queryClient.getQuery(node.getNameString() + "_bpvTree");
            }
            catch (UndefinedQueryException e) {
                // empty catch block
            }
            if (query != null) {
                this.m_treeViewId = query.getQueryId();
            } else {
                CriteriaDataObjectFactory criteriaFactory = queryClient.getCriteriaFactory();
                CriteriaDataObject criteria = criteriaFactory.getObject("CriteriaByName");
                criteria.addCriteriaValue(node.getNameString());
                Query newQuery = new Query(node.getNameString() + "_bpvListTree", QueryType.DEVICE.toString());
                newQuery.setDynamic(true);
                newQuery.addCriteriaObject(criteria, this.m_loginBean.getLocale());
                this.m_treeViewId = queryClient.addQuery(newQuery, this.m_loginBean.getLocale());
            }
            this.m_treeViewURL = "/ui/jsp/XeHdr.jsp?PageName=viewContentsDevices&viewid=" + Integer.toString(this.m_listViewId) + "&treeViewId=" + Integer.toString(this.m_treeViewId) + "&topMenuIndex=1&BigPictureView=" + Integer.toString(node.getKey()) + "&ViewType=DeviceViews&retainSelection=1" + "&queryDisplayName=" + node.getNameString() + "&expandAll=true" + "&viewMode=tree";
            this.m_listViewURL = this.m_listViewURL + "&treeViewId=" + Integer.toString(this.m_treeViewId);
            this.m_iconViewURL = this.m_iconViewURL + "&treeViewId=" + Integer.toString(this.m_treeViewId);
        }
        return this.m_treeViewURL;
    }

    public String getIconViewURL() throws Exception {
        if (this.m_element == null) {
            return "";
        }
        if (this.m_iconViewURL.equals("") && !this.getListViewURL().equals("")) {
            this.m_iconViewURL = this.getListViewURL() + "&viewMode=icon";
            this.m_iconViewId = this.m_listViewId;
        }
        return this.m_iconViewURL;
    }
}

