/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.portal.bpv.MxBPVDesktop;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVPowerSupplyEnclosure;
import com.hp.mx.portal.bpv.MxBPVServer;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVSwitch;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.device.MxDeviceBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.iLOXml.EnclosureNodeUpdater;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Content;
import org.jdom.Element;

public class BPVXML {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private static BPVXML m_bpvXml = null;
    private MonteroResourceManager manager = MonteroResourceManager.getInstance();
    private double powerConsumedEncl = 0.0;
    private double powerSuppliedEncl = 0.0;
    private String m_subTypeOfEncl;

    private BPVXML() {
    }

    public static BPVXML getInstance() {
        if (m_bpvXml == null) {
            m_bpvXml = new BPVXML();
        }
        return m_bpvXml;
    }

    private void setDeviceSubTypeOfEncl(MxBPVElement element) {
        this.m_subTypeOfEncl = MxBPVServerEnclosure.getEnclosureSubType(element.getNode());
    }

    public String getDeviceSubTypeOFEncl() {
        return this.m_subTypeOfEncl;
    }

    public Element createDevice(MxBPVElement element, boolean isEmptyBay) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createDevice(MxBPVElement " + element + "boolean" + isEmptyBay + ")"));
        }
        Element deviceEle = BPVXML.createElement("Device", null);
        String[] deviceAttr = new String[]{"location", "bayType"};
        int slotsUsedXDirection = element.getNumSlotsUsedXDir();
        int slotsUsedYDirection = element.getNumSlotsUsedYDir();
        if (!isEmptyBay) {
            MxNode node = element.getNode();
            deviceEle.addContent((Content)BPVXML.createElement("SerialNum", node.getSerialNumber()));
            deviceEle.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
            Element status = BPVXML.createElement("Status", null);
            status.addContent((Content)BPVXML.createElement("UID", element.getStatus()));
            status.addContent((Content)BPVXML.createElement("Title", this.manager.getString("xml." + element.getStatus(), element.getLoginBean().getLocale())));
            deviceEle.addContent((Content)status);
            Element common = BPVXML.createElement("Common", null);
            common.addContent((Content)BPVXML.createElement("Name", node.getNameString()));
            String productName = " ";
            productName = BPVXML.checkClientAttribute(node, "AdviLO.server.ProdName") ? node.getClientAttribute("AdviLO.server.ProdName") : node.getModel();
            common.addContent((Content)BPVXML.createElement("Product", productName));
            common.addContent((Content)BPVXML.createElement("NodeId", node.getGUID().toString()));
            if (element instanceof MxBPVServer) {
                MxBPVServer server = (MxBPVServer)element;
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("BPVXML.createDevice Server Status" + element.getStatus()));
                }
                common.addContent((Content)BPVXML.createElement("DrillDownURL", server.getDrillDownURL(MxDrillDown.DEVICE_NAME_DRILL_DOWN)));
                MxDeviceBean deviceBean = new MxDeviceBean();
                deviceBean.initialize(element.getNode().getGUID().toString(), element.getLoginBean());
                if (element.getNode().getIsProtocolSupported(MgmtProtoType_t.SMH_PROTO)) {
                    common.addContent((Content)BPVXML.createElement("HomePageURL", server.getDrillDownURL(MxDrillDown.HW_STATUS_DRILL_DOWN)));
                } else {
                    common.addContent((Content)BPVXML.createElement("HomePageURL", null));
                }
                deviceEle.addContent((Content)common);
                String[] deviceValues = new String[]{"Front", "Server"};
                this.setAttributes(deviceEle, deviceAttr, deviceValues);
                Element slots = BPVXML.createElement("SlotsUsed", null);
                slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
                slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
                deviceEle.addContent((Content)slots);
            } else if (element instanceof MxBPVDesktop) {
                MxBPVDesktop desktop = (MxBPVDesktop)element;
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("BPVXML.createDevice desktop Status" + element.getStatus()));
                }
                common.addContent((Content)BPVXML.createElement("DrillDownURL", desktop.getDrillDownURL()));
                deviceEle.addContent((Content)common);
                String[] deviceValues = new String[]{"Front", "Server"};
                this.setAttributes(deviceEle, deviceAttr, deviceValues);
                Element slots = BPVXML.createElement("SlotsUsed", null);
                slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
                slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
                deviceEle.addContent((Content)slots);
            } else if (element instanceof MxBPVSwitch) {
                MxBPVSwitch switches = (MxBPVSwitch)element;
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("BPVXML.createDevice Switch Status" + element.getStatus()));
                }
                String DUKES_ATTRIBUTE = node.getClientAttribute("LOCATION");
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("BPVXML.createDevice() DUKES_ATTRIBUTE:" + DUKES_ATTRIBUTE));
                }
                String location = "Front";
                if (DUKES_ATTRIBUTE != null && DUKES_ATTRIBUTE.equalsIgnoreCase("RearUpperCube")) {
                    if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                        m_log.debug((Object)("BPVXML.createDevice() Dukes Switch:" + element.getName().toString()));
                    }
                    location = "Rear";
                    slotsUsedXDirection = 1;
                    slotsUsedYDirection = 1;
                }
                common.addContent((Content)BPVXML.createElement("DrillDownURL", switches.getDrillDownURL()));
                deviceEle.addContent((Content)common);
                Element slots = BPVXML.createElement("SlotsUsed", null);
                slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
                slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
                deviceEle.addContent((Content)slots);
                String[] deviceValues = new String[]{location, "Switch"};
                this.setAttributes(deviceEle, deviceAttr, deviceValues);
            }
        } else {
            String typeOfEnclosure = this.getDeviceSubTypeOFEncl();
            if (typeOfEnclosure.equalsIgnoreCase(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                slotsUsedXDirection = 1;
                slotsUsedYDirection = 1;
            }
            String bayType = "Server";
            if (element.getSlotNumber() == 0 || element.getSlotNumber() == 9999) {
                bayType = "Switch";
            }
            String[] deviceValues = new String[]{"Front", bayType};
            this.setAttributes(deviceEle, deviceAttr, deviceValues);
            Element slots = BPVXML.createElement("SlotsUsed", null);
            slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
            slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
            deviceEle.addContent((Content)slots);
            deviceEle.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        }
        deviceEle.addContent((Content)BPVXML.createElement("SlotNumber", "" + element.getSlotNumber()));
        return deviceEle;
    }

    public Element createPowerSupplyEnclosure(MxBPVElement element, MxLoginBean loginBean) {
        this.powerConsumedEncl = 0.0;
        this.powerSuppliedEncl = 0.0;
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createPowerSupplyEnclosure(MxBPVElement " + element + "MxLoginBean " + loginBean));
        }
        boolean iloPresent = false;
        MxNode powerEnclNode = element.getNode();
        Element powersupply = this.createRoot("PowerSupplyEnclosure");
        MxBPVPowerSupplyEnclosure powerElement = (MxBPVPowerSupplyEnclosure)element;
        String sizeOfEnc = powerElement.getTypeOfEnclosure();
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("PowerSupplyEnlcousure:Type" + sizeOfEnc));
        }
        iloPresent = BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.AdvanedILO_IP");
        Element powerSupplyUnit = null;
        String location = null;
        String acInput = null;
        Element attribute = null;
        int loc = 1;
        Element emptyPowerSupplyUnit = null;
        String inputTemp = null;
        String inputTempTrip = null;
        String inputTempFail = null;
        String outputTemp = null;
        String outputTempTrip = null;
        String outputTempFail = null;
        String ZERO = "0";
        ArrayList<String> pwrunitsStatus = new ArrayList<String>();
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            Element status;
            powerSupplyUnit = BPVXML.createElement("PowerSupplyUnit", null);
            String hasDevice = "ABSENT";
            location = "-1";
            acInput = "0";
            loc = -1;
            inputTemp = "0";
            inputTempTrip = "0";
            inputTempFail = "0";
            outputTemp = "0";
            outputTempTrip = "0";
            outputTempFail = "0";
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.Loc" + i)) {
                hasDevice = "PRESENT";
                location = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.Loc" + i);
                loc = Integer.parseInt(location);
            }
            powerSupplyUnit.addContent((Content)BPVXML.createElement("hasDevice", hasDevice));
            m_log.debug((Object)("BPVXML.creatPowerSupplyEnclosre():Location" + loc));
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.FWRI" + i)) {
                String pUnitFrmRev = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.FWRI" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("FrmRev", pUnitFrmRev));
            }
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.ACInput" + i)) {
                acInput = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.ACInput" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("ACInput", acInput));
            }
            if (BPVXML.checkClientAttribute(powerEnclNode, "IAdviLO.pwrCmp.nputTemp" + i)) {
                inputTemp = powerEnclNode.getClientAttribute("IAdviLO.pwrCmp.nputTemp" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("InputTempC", inputTemp));
            }
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.InputTrip" + i)) {
                inputTempTrip = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.InputTrip" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("InTempTripC", inputTempTrip));
            }
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.InputFail" + i)) {
                inputTempFail = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.InputFail" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("InTempFailC", inputTempFail));
            }
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.OutputTemp" + i)) {
                outputTemp = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.OutputTemp" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("OutTempC", outputTemp));
            }
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.OutputTrip" + i)) {
                outputTempTrip = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.OutputTrip" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("OutputTempTripC", outputTempTrip));
            }
            if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrCmp.OutputFail" + i)) {
                outputTempFail = powerEnclNode.getClientAttribute("AdviLO.pwrCmp.OutputFail" + i);
                powerSupplyUnit.addContent((Content)BPVXML.createElement("OutTempFailC", outputTempFail));
            }
            for (int k = j + 1; k < loc; ++k) {
                emptyPowerSupplyUnit = BPVXML.createElement("PowerSupplyUnit", null);
                emptyPowerSupplyUnit.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
                emptyPowerSupplyUnit.addContent((Content)BPVXML.createElement("BayNumber", String.valueOf(k)));
                status = BPVXML.createElement("Status", null);
                status.addContent((Content)BPVXML.createElement("Value", "Informational"));
                status.addContent((Content)BPVXML.createElement("Title", this.manager.getString("xml.Informational", loginBean.getLocale())));
                emptyPowerSupplyUnit.addContent((Content)status);
                pwrunitsStatus.add("Unknown");
                powersupply.addContent((Content)emptyPowerSupplyUnit);
                ++j;
            }
            powerSupplyUnit.addContent((Content)BPVXML.createElement("BayNumber", String.valueOf(j + 1)));
            String puStatus = this.getPUStatus(location, acInput, iloPresent, Double.parseDouble(inputTemp), Double.parseDouble(inputTempTrip), Double.parseDouble(inputTempFail), Double.parseDouble(outputTemp), Double.parseDouble(outputTempTrip), Double.parseDouble(outputTempFail));
            status = BPVXML.createElement("Status", null);
            status.addContent((Content)BPVXML.createElement("Value", puStatus));
            status.addContent((Content)BPVXML.createElement("Title", this.manager.getString("xml." + puStatus, loginBean.getLocale())));
            powerSupplyUnit.addContent((Content)status);
            pwrunitsStatus.add(puStatus);
            powersupply.addContent((Content)powerSupplyUnit);
            ++i;
        }
        String status = null;
        if (m_log.isEnabledFor((Priority)Level.FATAL)) {
            for (int i2 = 0; i2 < pwrunitsStatus.size(); ++i2) {
                m_log.fatal((Object)("Power Unit Status:" + pwrunitsStatus.get(i2)));
            }
        }
        status = pwrunitsStatus.contains("Critical") ? "Critical" : (pwrunitsStatus.contains("Minor") ? "Minor" : (pwrunitsStatus.contains("Normal") ? "Normal" : "Unknown"));
        this.setValuesToAttribute(powersupply, powerEnclNode, loginBean, false);
        String[] pwrSupplyStrings = new String[]{"name", "size", "iloPresent", "type", "titleStatus"};
        String[] pwrSupplyValues = new String[]{powerEnclNode.getNameString(), sizeOfEnc, iloPresent ? "Yes" : "No", NodeSubTypeMapper.PCLASS_SUBTYPE.toString(), this.manager.getString("xml." + status, loginBean.getLocale())};
        this.setAttributes(powersupply, pwrSupplyStrings, pwrSupplyValues);
        attribute = BPVXML.createElement("Attribute", null);
        String attrString = "Section:System Status,location:Both,displayAsImage:true,Name:" + this.manager.getString("xml.status", loginBean.getLocale());
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createPowerEnclosure.status " + status));
        }
        this.setAttribute(attribute, attrString, status);
        powersupply.addContent((Content)attribute);
        if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrEncl.PowerRedundancy")) {
            String powerRedundancyStr = "Section:Power And Thermal,location:EnclosureView,isMultiValued:true,Name:" + this.manager.getString("xml.powerRedundancy", loginBean.getLocale());
            String powerRedundancyValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            powerRedundancyValue = powerEnclNode.getClientAttribute("AdviLO.pwrEncl.PowerRedundancy");
            HashMap pwrRedundancy_hashmap = this.getPowerRedundancyInfo(powerRedundancyValue, loginBean);
            StringBuffer pwrRedundancy = new StringBuffer();
            String temp_pwrRedundancy = null;
            if (m_log.isEnabledFor((Priority)Level.FATAL)) {
                m_log.fatal((Object)"Power Redundancy Information");
            }
            for (int i3 = 1; i3 <= 7; ++i3) {
                temp_pwrRedundancy = (String)pwrRedundancy_hashmap.get("" + i3);
                if (temp_pwrRedundancy == null) continue;
                if (m_log.isEnabledFor((Priority)Level.FATAL)) {
                    m_log.fatal((Object)temp_pwrRedundancy.toString());
                }
                pwrRedundancy.append(temp_pwrRedundancy);
                pwrRedundancy.append("/");
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, powerRedundancyStr, pwrRedundancy.toString());
            powersupply.addContent((Content)attribute);
        }
        if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrEncl.LoadBalWire")) {
            String loadBal = "Section:Power And Thermal,location:Both,Name:" + this.manager.getString("xml.loadBalWire", loginBean.getLocale());
            String loadBalValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            loadBalValue = powerEnclNode.getClientAttribute("AdviLO.pwrEncl.LoadBalWire");
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, loadBal, loadBalValue);
            powersupply.addContent((Content)attribute);
        }
        String sideATemp = "Section:Power And Thermal,location:EnclosureView,displayAsTemp:True,Name:" + this.manager.getString("xml.sideATemp", loginBean.getLocale());
        String sideATempValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrEncl.TempA")) {
            sideATempValue = powerEnclNode.getClientAttribute("AdviLO.pwrEncl.TempA");
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, sideATemp, sideATempValue);
        powersupply.addContent((Content)attribute);
        String centerTemp = "Section:Power And Thermal,location:EnclosureView,displayAsTemp:True,Name:" + this.manager.getString("xml.CenterTemp", loginBean.getLocale());
        String centerTempValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.encl.Temp")) {
            centerTempValue = powerEnclNode.getClientAttribute("AdviLO.encl.Temp");
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, centerTemp, centerTempValue);
        powersupply.addContent((Content)attribute);
        String sideBTemp = "Section:Power And Thermal,location:EnclosureView,displayAsTemp:True,Name:" + this.manager.getString("xml.sideBTemp", loginBean.getLocale());
        String sideBTempValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.pwrEncl.TempB")) {
            sideBTempValue = powerEnclNode.getClientAttribute("AdviLO.pwrEncl.TempB");
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, sideBTemp, sideBTempValue);
        powersupply.addContent((Content)attribute);
        Element common = BPVXML.createElement("Common", null);
        common.addContent((Content)BPVXML.createElement("Name", powerEnclNode.getNameString()));
        common.addContent((Content)BPVXML.createElement("Product", sizeOfEnc));
        String pwrZonevalue = "NOT_AVAILABLE";
        if (BPVXML.checkClientAttribute(powerEnclNode, "AdviLO.encl.PowerZone")) {
            pwrZonevalue = powerEnclNode.getClientAttribute("AdviLO.encl.PowerZone");
        }
        common.addContent((Content)BPVXML.createElement("PowerZone", pwrZonevalue));
        powersupply.addContent((Content)common);
        return powersupply;
    }

    private String getPUStatus(String location, String acInput, boolean iloPresent, double pwrSupplyInputTemp, double pwrSupplyInputTempTrip, double pwrSupplyInputTempFail, double pwrSupplyOutputTemp, double pwrSupplyOutputTempTrip, double pwrSupplyOutputTempFail) {
        String status;
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Location:" + location));
            m_log.debug((Object)("InputTemp:" + pwrSupplyInputTemp));
            m_log.debug((Object)("InputTempTrip:" + pwrSupplyInputTempTrip));
            m_log.debug((Object)("InputTempFail:" + pwrSupplyInputTempFail));
            m_log.debug((Object)("OutputTemp:" + pwrSupplyOutputTemp));
            m_log.debug((Object)("OutputTempTrip:" + pwrSupplyOutputTempTrip));
            m_log.debug((Object)("OutputTempFail:" + pwrSupplyOutputTempFail));
        }
        if (location != null && location.equalsIgnoreCase("-1")) {
            status = "Unknown";
        } else if (acInput.equalsIgnoreCase("Good")) {
            status = "Normal";
            if (pwrSupplyInputTemp < pwrSupplyInputTempTrip && pwrSupplyOutputTemp < pwrSupplyOutputTempTrip) {
                status = "Normal";
            } else if (pwrSupplyInputTemp > pwrSupplyInputTempTrip && pwrSupplyOutputTemp > pwrSupplyOutputTempTrip) {
                status = "Minor";
            } else if (pwrSupplyInputTemp > pwrSupplyInputTempFail && pwrSupplyOutputTemp > pwrSupplyOutputTempFail) {
                status = "Critical";
            }
        } else {
            status = !location.equalsIgnoreCase("-1") ? "Critical" : (iloPresent ? "noStatus" : "Unknown");
        }
        return status;
    }

    public Element createBladeEnclosure(MxBPVElement element, MxLoginBean loginBean) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createBladeEnclosure(MxBPVElement " + element + "MxLoginBean " + loginBean));
        }
        MxNode bladeEnclNode = element.getNode();
        Element bladeEncl = this.createRoot("BladeEnclosure");
        String[] bladeEnclStrings = new String[]{"type", "titleStatus"};
        this.setDeviceSubTypeOfEncl(element);
        String typeOfEnclosure = this.getDeviceSubTypeOFEncl();
        boolean isEClassEnclosure = false;
        if (typeOfEnclosure.equalsIgnoreCase(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            isEClassEnclosure = true;
        }
        String[] bladeEnclValues = new String[]{typeOfEnclosure, this.manager.getString("xml." + element.getStatus(), loginBean.getLocale())};
        this.setAttributes(bladeEncl, bladeEnclStrings, bladeEnclValues);
        this.setValuesToAttribute(bladeEncl, bladeEnclNode, loginBean, isEClassEnclosure);
        Element attribute = BPVXML.createElement("Attribute", null);
        String attrString = "Section:System Status,location:Both,displayAsImage:true,Name:" + this.manager.getString("xml.status", loginBean.getLocale());
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("MxBPVServerEnclosure.status " + element.getStatus()));
        }
        String attrValue = element.getStatus();
        this.setAttribute(attribute, attrString, attrValue);
        bladeEncl.addContent((Content)attribute);
        if (!isEClassEnclosure) {
            MxNode enclNode = element.getNode();
            String temp = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.Temperature", loginBean.getLocale());
            String temperature = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            if (BPVXML.checkClientAttribute(enclNode, "AdviLO.encl.Temp")) {
                String tempValue = enclNode.getClientAttribute("AdviLO.encl.Temp");
                double temperatureC = (double)((int)(((double)Integer.parseInt(tempValue) * 1.8 + 32.0) * 100.0)) / 100.0;
                temperature = tempValue + " / " + temperatureC;
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, temp, temperature);
            bladeEncl.addContent((Content)attribute);
            Element common = BPVXML.createElement("Common", null);
            String pwrZonevalue = "NOT_AVAILABLE";
            if (BPVXML.checkClientAttribute(element.getNode(), "AdviLO.encl.PowerZone")) {
                pwrZonevalue = element.getNode().getClientAttribute("AdviLO.encl.PowerZone");
            }
            common.addContent((Content)BPVXML.createElement("PowerZone", pwrZonevalue));
            bladeEncl.addContent((Content)common);
        }
        return bladeEncl;
    }

    public Element createRack(MxBPVElement element, MxLoginBean loginBean, boolean hasChildren) {
        BladeIMELogger.log("Start:BPVXML.createRack(" + element.toString() + ")");
        MxNode rackNode = element.getNode();
        Element root = this.createRoot("Rack");
        List deviceSubTypes = element.getNode().getDeviceSubTypes();
        String subtype = null;
        if (deviceSubTypes.contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
            BladeIMELogger.log("The Subtype of the Rack is p-Class");
            subtype = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
        } else if (deviceSubTypes.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            BladeIMELogger.log("The Subtype of the Rack is c-Class");
            subtype = NodeSubTypeMapper.CCLASS_SUBTYPE.toString();
        }
        if (!hasChildren) {
            root.setAttribute("Empty", "true");
        } else {
            root.setAttribute("Empty", "false");
        }
        root.setAttribute("type", subtype);
        Element common = BPVXML.createElement("Common", null);
        common.addContent((Content)BPVXML.createElement("Name", rackNode.getNameString()));
        common.addContent((Content)BPVXML.createElement("Product", rackNode.getDeviceType()));
        common.addContent((Content)BPVXML.createElement("NodeId", rackNode.getObjectID().toString()));
        common.addContent((Content)BPVXML.createElement("DrillDownURL", "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + rackNode.getGUID().toString() + "&drillDownType=DrillDownType-DeviceName&globalselection=true"));
        root.addContent((Content)common);
        root.addContent((Content)BPVXML.createElement("SerialNum", "TODO"));
        String[] nameStrings = new String[]{"Section:General,Name:RUID", "Section:General,Name:Rack Name,location:Both", "Section:System Status,Name:Health Status,location:Both,displayAsImage:true"};
        String[] nameValues = new String[]{"TODO", rackNode.getNameString(), element.getStatus()};
        Element attribute = null;
        for (int i = 0; i < nameValues.length; ++i) {
            attribute = BPVXML.createElement("Attribute", "");
            this.setAttribute(attribute, nameStrings[i], nameValues[i]);
            root.addContent((Content)attribute);
        }
        BladeIMELogger.log("End:BPVXML.createRack(" + element.toString() + ")");
        return root;
    }

    public void setValuesToAttribute(Element element, MxNode node, MxLoginBean loginBean, boolean isEClassEnclosure) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("  BPVXML.setValuesToAttribute(Element " + element + ",MxNode " + node.getNameString() + "loginBean " + loginBean + ")"));
        }
        Element attribute = null;
        String enclName = "Section:Identification,URL:/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + node.getGUID() + "&drillDownType=DrillDownType-DeviceName" + "&globalselection=true" + ",displayAsURL:true,location:RackView,Name:" + this.manager.getString("xml.enclosureName", loginBean.getLocale());
        String enclNameVal = node.getNameString();
        if (enclNameVal.equalsIgnoreCase("") || enclNameVal == null) {
            enclNameVal = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", loginBean.getLocale());
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, enclName, enclNameVal);
        element.addContent((Content)attribute);
        String serialNo = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.serialNumber", loginBean.getLocale());
        String serialNoValue = node.getSerialNumber();
        if (serialNoValue.equalsIgnoreCase("") || serialNoValue == null) {
            serialNoValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, serialNo, serialNoValue);
        element.addContent((Content)attribute);
        if (!isEClassEnclosure) {
            String uuid = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.uuid", loginBean.getLocale());
            String uuidValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            uuidValue = node.getAgentUUID();
            BladeIMELogger.log("AgentUUID:" + uuidValue);
            BladeIMELogger.log("node.getAgentUUID():" + node.getAgentUUID());
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, uuid, uuidValue);
            element.addContent((Content)attribute);
            MxNode rackNode = EnclosureNodeUpdater.getRackNode(node);
            String rackValue = null;
            String rackName = null;
            if (rackNode != null) {
                rackName = "Section:Identification,URL:/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + rackNode.getGUID().toString() + "&drillDownType=DrillDownType-DeviceName&globalselection=true" + ",displayAsURL:true,location:" + "EnclosureView,Name:" + this.manager.getString("xml.rName", loginBean.getLocale());
                rackValue = rackNode.getNameString();
            } else {
                rackName = "Section:Identification,location:EnclosureView,Name:" + this.manager.getString("xml.rName", loginBean.getLocale());
                BladeIMELogger.log("The rack device node is not created.Server Name:" + element.getName());
            }
            if (rackValue == null || rackValue.equalsIgnoreCase("")) {
                rackValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, rackName, rackValue);
            element.addContent((Content)attribute);
            String FWStr = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.firmwareRevision", loginBean.getLocale());
            String FWValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            if (BPVXML.checkClientAttribute(node, "AdviLO.encl.FWRI")) {
                FWValue = node.getClientAttribute("AdviLO.encl.FWRI");
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, FWStr, FWValue);
            element.addContent((Content)attribute);
            String pwrZoneString = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.powerZone", loginBean.getLocale());
            String pwrZonevalue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            if (BPVXML.checkClientAttribute(node, "AdviLO.encl.PowerZone")) {
                pwrZonevalue = node.getClientAttribute("AdviLO.encl.PowerZone");
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, pwrZoneString, pwrZonevalue);
            element.addContent((Content)attribute);
            String LEDStr = "Section:Identification,location:Both,displayAsImage:false,Name:" + this.manager.getString("xml.uidStatus", loginBean.getLocale());
            String LEDValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            if (BPVXML.checkClientAttribute(node, "AdviLO.encl.UuidStatus")) {
                LEDValue = node.getClientAttribute("AdviLO.encl.UuidStatus");
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, LEDStr, LEDValue);
            element.addContent((Content)attribute);
        }
    }

    public Element createImage(String statusVal, String frontVal, String rearVal, MxLoginBean loginBean) {
        Element image = BPVXML.createElement("Image", null);
        image.addContent((Content)BPVXML.createElement("Status", statusVal));
        if (loginBean != null && !statusVal.equalsIgnoreCase("NoStatus")) {
            image.addContent((Content)BPVXML.createElement("titleStatus", this.manager.getString("xml." + statusVal, loginBean.getLocale())));
        }
        image.addContent((Content)BPVXML.createElement("Front", frontVal));
        if (rearVal != null) {
            image.addContent((Content)BPVXML.createElement("Rear", rearVal));
        }
        return image;
    }

    public static Element createElement(String name, String value) {
        Element element = new Element(name);
        if (value != null) {
            element.setText(value);
        }
        return element;
    }

    public void setAttributes(Element element, String[] attrNames, String[] attrValues) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"BPVXML.setAttributes(Element,String[],String[])");
        }
        for (int i = 0; i < attrNames.length; ++i) {
            element.setAttribute(attrNames[i], attrValues[i]);
        }
    }

    public void setAttribute(Element element, String attrs, String value) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.setAttribute(Element " + element + ",String " + attrs + ",String" + value));
        }
        StringTokenizer tokens = new StringTokenizer(attrs, ":,", false);
        String token = null;
        String tokenValue = null;
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            tokenValue = tokens.nextToken();
            if (token.compareToIgnoreCase("Name") != 0) {
                element.setAttribute(token, tokenValue);
                continue;
            }
            element.addContent((Content)BPVXML.createElement(token, tokenValue));
            element.addContent((Content)BPVXML.createElement("Value", value));
        }
    }

    public Element createRoot(String name) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createRoot(String " + name));
        }
        Element root = new Element(name);
        return root;
    }

    public void createRearView(MxBPVElement enclsoureElement, Element enclosure) {
        String typeOfEnclosure = this.getDeviceSubTypeOFEncl();
        if (typeOfEnclosure.equalsIgnoreCase(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
            this.createPClassRearDevice(enclsoureElement, enclosure);
        } else if (typeOfEnclosure.equalsIgnoreCase(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            this.createEClassRearView(enclsoureElement, enclosure);
        }
    }

    public void createEClassRearView(MxBPVElement bpvEnclEle, Element xmlEnclEle) {
        BladeIMELogger.log("Start:BPVXML.createEClassRearView(" + bpvEnclEle + "," + xmlEnclEle + ")");
        MxNode servEncl = bpvEnclEle.getNode();
        if (servEncl == null) {
            BladeIMELogger.log("Error: Unable to retrieve the MxNode object from MxBPVElement object of e-Class server enclosure.");
            return;
        }
        String leftPowerSupply = servEncl.getClientAttribute("leftPowerSupply");
        if (leftPowerSupply == null) {
            xmlEnclEle.setAttribute("firmwareRev", "1.3");
            BladeIMELogger.log("The firmware revision of e-Class server enclosureis < 1.4.");
            BladeIMELogger.log("End: BPVXML.createEClassRearView()");
            return;
        }
        xmlEnclEle.setAttribute("firmwareRev", "1.4");
        Element leftPwrXMLElem = BPVXML.createElement("Device", null);
        String[] deviceAttr = new String[]{"location", "bayType"};
        String[] powerSupAttrValues = new String[]{"Rear", "PowerSupply"};
        this.setAttributes(leftPwrXMLElem, deviceAttr, powerSupAttrValues);
        leftPwrXMLElem.addContent((Content)BPVXML.createElement("position", "left"));
        if (leftPowerSupply.equalsIgnoreCase("true")) {
            leftPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
        } else {
            leftPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        }
        xmlEnclEle.addContent((Content)leftPwrXMLElem);
        String rightPowerSupply = servEncl.getClientAttribute("rightPowerSupply");
        Element rightPwrXMLElem = BPVXML.createElement("Device", null);
        this.setAttributes(rightPwrXMLElem, deviceAttr, powerSupAttrValues);
        rightPwrXMLElem.addContent((Content)BPVXML.createElement("position", "right"));
        if (rightPowerSupply.equalsIgnoreCase("true")) {
            rightPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
        } else {
            rightPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        }
        xmlEnclEle.addContent((Content)rightPwrXMLElem);
        int switchDevKey = 0;
        try {
            NodeAssociationsManager nodeAssocMgr = NodeAssociationsManager.getDefaultManager();
            Vector swtchDevKeyLst = nodeAssocMgr.getAssociatedDevicesUsingATNs(servEncl.getDeviceKey(), "SwitchToEnclosure");
            String[] swtchAttr = new String[]{"location", "bayType"};
            String[] swtchAttrValues = new String[]{"Rear", "Switch"};
            MxNode switchNode = null;
            for (int i = 0; i < swtchDevKeyLst.size(); ++i) {
                Element switchXMLElem = BPVXML.createElement("Device", null);
                this.setAttributes(switchXMLElem, swtchAttr, swtchAttrValues);
                switchDevKey = (Integer)swtchDevKeyLst.get(i);
                switchNode = MxNodeController.getDefaultController().getNodeByKey(switchDevKey);
                if (switchNode == null) {
                    switchXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
                    xmlEnclEle.addContent((Content)switchXMLElem);
                    continue;
                }
                switchXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
                switchXMLElem.addContent((Content)BPVXML.createElement("SerialNum", switchNode.getSerialNumber()));
                Element statusElem = BPVXML.createElement("Status", null);
                String status = switchNode.getOverallStatus().toString();
                status = status.charAt(0) + status.substring(1, status.length()).toLowerCase();
                statusElem.addContent((Content)BPVXML.createElement("UID", status));
                statusElem.addContent((Content)BPVXML.createElement("Title", status));
                switchXMLElem.addContent((Content)statusElem);
                Element commonElem = BPVXML.createElement("Common", null);
                commonElem.addContent((Content)BPVXML.createElement("Name", switchNode.getNameString()));
                commonElem.addContent((Content)BPVXML.createElement("Product", switchNode.getModel()));
                commonElem.addContent((Content)BPVXML.createElement("NodeId", switchNode.getGUID().toString()));
                commonElem.addContent((Content)BPVXML.createElement("DrillDownURL", "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + switchDevKey + "&drillDownType=" + MxDrillDown.DEVICE_NAME_DRILL_DOWN));
                switchXMLElem.addContent((Content)commonElem);
                xmlEnclEle.addContent((Content)switchXMLElem);
            }
            if (swtchDevKeyLst.size() == 0) {
                Element switchXMLElem = BPVXML.createElement("Device", null);
                this.setAttributes(switchXMLElem, swtchAttr, swtchAttrValues);
                switchXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
                xmlEnclEle.addContent((Content)switchXMLElem);
            }
        }
        catch (NodeAssociationsPersistenceException nodePers) {
        }
        catch (MxUndefinedNodeException e) {
            e.printStackTrace();
        }
        catch (MxObjectPersistenceException e) {
            e.printStackTrace();
        }
        BladeIMELogger.log("End:createEClassRearDevice(" + bpvEnclEle + "," + xmlEnclEle + ")");
    }

    public void createPClassRearDevice(MxBPVElement enclsoureElement, Element enclosure) {
        String rearLoc = "Rear";
        String switchType = "Switch";
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createPClassRearDevice(" + enclsoureElement + "," + enclosure));
            m_log.debug((Object)("BPVXML.createPClassRearDevice(Element Name" + enclsoureElement.getName() + ",Enclosure Name" + enclosure.getName()));
            m_log.debug((Object)("BPVXML.createPClassRearDevice(MxBPVElement " + enclsoureElement.getName()));
        }
        if (enclsoureElement.getNumDukesSwitches() == 0) {
            Element device1 = this.createEmptySlot(0, 1, 1, switchType, rearLoc);
            enclosure.addContent((Content)device1);
            Element device3 = this.createEmptySlot(9999, 1, 1, switchType, rearLoc);
            enclosure.addContent((Content)device3);
        } else if (enclsoureElement.getNumDukesSwitches() == 1) {
            if (enclsoureElement.getDukesSlotNumbers(0) == 1) {
                Element device3 = this.createEmptySlot(9999, 1, 1, switchType, rearLoc);
                enclosure.addContent((Content)device3);
            } else if (enclsoureElement.getDukesSlotNumbers(1) == 1) {
                Element device3 = this.createEmptySlot(0, 1, 1, switchType, rearLoc);
                enclosure.addContent((Content)device3);
            }
        }
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createRearDevice(MxBPVElement " + enclsoureElement.getName() + "***Number Of Dukes Switches****:" + enclsoureElement.getNumDukesSwitches()));
        }
    }

    public static boolean checkClientAttribute(MxNode node, String attribute) {
        String attributeValue = node.getClientAttribute(attribute);
        return attributeValue != null && !attributeValue.trim().equalsIgnoreCase("");
    }

    public Element createEmptySlot(int slotNumber, int slotsUsedXDirection, int slotsUsedYDirection, String bayType, String pos) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("BPVXML.createEmptySlot(int " + slotNumber + ",int" + slotsUsedXDirection + ",int " + slotsUsedYDirection + ",String " + bayType + ",String " + pos));
        }
        Element emptySlot = BPVXML.createElement("Device", null);
        String[] deviceAttr = new String[]{"location", "bayType"};
        String[] deviceValues = new String[]{pos, bayType};
        this.setAttributes(emptySlot, deviceAttr, deviceValues);
        emptySlot.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        emptySlot.addContent((Content)BPVXML.createElement("SlotNumber", "" + slotNumber));
        Element slotsUsed = BPVXML.createElement("SlotsUsed", null);
        slotsUsed.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
        slotsUsed.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
        emptySlot.addContent((Content)slotsUsed);
        return emptySlot;
    }

    private HashMap getPowerRedundancyInfo(String redundancyBit, MxLoginBean loginBean) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("getPowerRedundancyInfo(String " + redundancyBit + ",MxLoginBean " + loginBean));
        }
        String[] redundancyBit_hex = new String[]{"0000", "0001", "0002", "0004", "0008", "0010", "0020", "0040", "0080", "0100", "0200", "0400", "0800", "1000", "2000", "4000", "8000"};
        int[] redundancuBit_Dec = new int[17];
        for (int i = 0; i < redundancyBit_hex.length; ++i) {
            redundancuBit_Dec[i] = Integer.parseInt(redundancyBit_hex[i].trim(), 16);
        }
        int redundancyBit_iLO = Integer.parseInt(redundancyBit.trim(), 16);
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("Decimal value for the RedundancyBit retrieved from iLO:" + redundancyBit_iLO));
        }
        HashMap<String, String> redundancyInfo = new HashMap<String, String>();
        redundancyInfo.put("1", this.manager.getString("xml.PowerRedundancy1", loginBean.getLocale()));
        redundancyInfo.put("2", this.manager.getString("xml.PowerRedundancy2", loginBean.getLocale()));
        redundancyInfo.put("6", this.manager.getString("xml.PowerRedundancy3", loginBean.getLocale()));
        for (int j = 0; j < redundancuBit_Dec.length; ++j) {
            if (redundancyBit.equalsIgnoreCase(redundancyBit_hex[j])) {
                this.updatePowerRedundacyInfo(redundancyBit_iLO, redundancyInfo);
                continue;
            }
            int resultBit = redundancyBit_iLO & redundancuBit_Dec[j];
            if (resultBit == 0 || resultBit != redundancuBit_Dec[j]) continue;
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("Value part of the redundancy bit:" + redundancyBit_hex[j]));
            }
            this.updatePowerRedundacyInfo(Integer.parseInt(redundancyBit_hex[j]), redundancyInfo);
        }
        return redundancyInfo;
    }

    private void updatePowerRedundacyInfo(int redundancyBit, HashMap redundancyInfo) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("updatePowerRedundacyInfo(int " + redundancyBit + ",HashMap " + redundancyInfo.toString()));
        }
        ResourceBundle bundle = ResourceBundle.getBundle("com.hp.mx.portal.iLOXml.PowerRedundancy");
        switch (redundancyBit) {
            case 1: {
                redundancyInfo.put("1", bundle.getString("0001"));
                break;
            }
            case 2: {
                redundancyInfo.put("2", bundle.getString("0002"));
                break;
            }
            case 20: {
                redundancyInfo.put("3", bundle.getString("0020"));
                break;
            }
            case 40: {
                redundancyInfo.put("4", bundle.getString("0040"));
                break;
            }
            case 80: {
                redundancyInfo.put("5", bundle.getString("0080"));
                break;
            }
            case 100: {
                redundancyInfo.put("6", bundle.getString("0100"));
                break;
            }
            case 200: {
                redundancyInfo.put("7", bundle.getString("0200"));
            }
        }
    }
}

