/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.DeviceFansType;
import com.hp.mx.portal.OAXml.DeviceTempsType;
import com.hp.mx.portal.OAXml.EnclosurePowerType;
import com.hp.mx.portal.OAXml.ICMB;
import com.hp.mx.portal.OAXml.Invoker;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OAUtil;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BAYINFOType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BLADEType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.ENCLMGRType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.OVERLORDINFRAType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.RACKNEIGHBORType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.RACKTOPOLOGYType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.RIMPType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.SWITCHType;
import com.hp.mx.portal.OAXml.OLBlade;
import com.hp.mx.portal.OAXml.OLDevice;
import com.hp.mx.portal.OAXml.OLSwitch;
import com.hp.mx.portal.OAXml.OnboardAdministrator;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class OLEnclosure {
    private String enclosureSerialNumber;
    private String enclosureProductName;
    private String enclosureName;
    private String enclosureAsset;
    private String enclosureUUID;
    private String enclosureUUIDStatus;
    private String enclosureStatus;
    private String enclosureAddress;
    private String enclosurePartNumber;
    private int enclosureHeight;
    private int encloureWidth;
    private int enclosureDepth;
    private String rackName;
    private String rackUUID;
    private List icmbList = new ArrayList();
    private List bladeList = new ArrayList();
    private List switchList = new ArrayList();
    private List oaList = new ArrayList();
    private String uniqueIdentifier;
    private DeviceTempsType deviceTempsType = new DeviceTempsType();
    private DeviceFansType deviceFansType = new DeviceFansType();
    private EnclosurePowerType enclosurePowerType = new EnclosurePowerType();
    private boolean vcmMode;
    private String vcmURL;
    private String vcmDomainName;
    private String vcmDomainId;
    private final String[] CLIENTATTRIBUTES = new String[]{"ENCL_UIDST", "ENCL_ADDR", "ENCL_PART_NUM", "VCM_MODE", "VCM_URL", "VCM_DOMIAN_NAME", "VCM_DOMAIN_ID"};

    public OLEnclosure(MxNode enclosureMxNode, String deviceUniqueIdentifier) {
        BladeIMELogger.log("OLEnclosure(" + enclosureMxNode + "," + deviceUniqueIdentifier + ")");
        this.uniqueIdentifier = deviceUniqueIdentifier;
        BladeIMELogger.log("enclosureMxNode.getClientAttribute(CLIENTATTRIBUTES[0]):" + enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0]));
        BladeIMELogger.log("enclosureMxNode.getClientAttribute(CLIENTATTRIBUTES[1]):" + enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1]));
        BladeIMELogger.log("enclosureMxNode.getClientAttribute(CLIENTATTRIBUTES[2]):" + enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2]));
        BladeIMELogger.log("enclosureMxNode.getClientAttribute(CLIENTATTRIBUTES[3])):" + enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3]));
        BladeIMELogger.log("enclosureMxNode.getClientAttribute(CLIENTATTRIBUTES[4]):" + enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[4]));
        BladeIMELogger.log("enclosureMxNode.getClientAttribute(CLIENTATTRIBUTES[5]):" + enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[5]));
        this.enclosureUUIDStatus = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0]);
        this.enclosureAddress = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1]);
        this.enclosurePartNumber = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2]);
        this.vcmMode = Boolean.valueOf(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3]));
        this.vcmURL = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[4]);
        this.vcmDomainName = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[5]);
        this.vcmDomainId = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[6]);
        this.deviceFansType.init(enclosureMxNode, this.uniqueIdentifier);
        this.deviceTempsType.init(enclosureMxNode, this.uniqueIdentifier);
        this.enclosurePowerType.init(enclosureMxNode, this.uniqueIdentifier);
        this.print("OLEnclosure DB");
    }

    public OLEnclosure(RIMPType rimpType) {
        BladeIMELogger.log("OLEnclosure(" + rimpType + ")");
        Invoker.init("initializeINFRA2", rimpType.getINFRA2().getContent(), OLEnclosure.class, this);
        Invoker.init("initializeRKTPLGY", rimpType.getRKTPLGY().getContent(), OLEnclosure.class, this);
        this.validateAttributes();
        this.initUniqueIdentifier();
        this.print("OLEnclosure JAXB");
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_RACKImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_RACKImpl(" + element + ")");
        this.rackName = OAUtil.trimAttribute(((OVERLORDINFRAType.RACK)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ENCLImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ENCLImpl(" + element + ")");
        this.enclosureName = OAUtil.trimAttribute(((OVERLORDINFRAType.ENCL)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_PNImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_PNImpl(" + element + ")");
        this.enclosureProductName = OAUtil.trimAttribute(((OVERLORDINFRAType.PN)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ASSETImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ASSETImpl(" + element + ")");
        this.enclosureAsset = OAUtil.trimAttribute(((OVERLORDINFRAType.ASSET)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_STATUSImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_STATUSImpl(" + element + ")");
        this.enclosureStatus = OAUtil.trimAttribute(((OVERLORDINFRAType.STATUS)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ENCLSNImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ENCLSNImpl(" + element + ")");
        this.enclosureSerialNumber = OAUtil.trimAttribute(((OVERLORDINFRAType.ENCLSN)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_PARTImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_PARTImpl(" + element + ")");
        this.enclosurePartNumber = OAUtil.trimAttribute(((OVERLORDINFRAType.PART)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_UUIDImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_UUIDImpl(" + element + ")");
        this.enclosureUUID = OAUtil.trimAttribute(((OVERLORDINFRAType.UUID)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_UIDSTATUSImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_UIDSTATUSImpl(" + element + ")");
        this.enclosureUUIDStatus = OAUtil.trimAttribute(((OVERLORDINFRAType.UIDSTATUS)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_ADDRImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_ADDRImpl(" + element + ")");
        this.enclosureAddress = OAUtil.trimAttribute(OAUtil.getHexString(((OVERLORDINFRAType.ADDR)element).getValue()));
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_DIMImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_DIMImpl(" + element + ")");
        OVERLORDINFRAType.DIM dim = (OVERLORDINFRAType.DIM)element;
        this.enclosureHeight = dim.getMmHeight().intValue();
        this.encloureWidth = dim.getMmWidth().intValue();
        this.enclosureDepth = dim.getMmDepth().intValue();
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_BLADESImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_BLADESImpl(" + element + ")");
        OVERLORDINFRAType.BLADES blades = (OVERLORDINFRAType.BLADES)element;
        List tempBladeList = blades.getBLADE();
        List tempBladeBayList = blades.getBAYS().getBAY();
        for (int i = 0; i < tempBladeList.size(); ++i) {
            this.bladeList.add(new OLBlade((BLADEType)tempBladeList.get(i), (BAYINFOType)tempBladeBayList.get(i)));
        }
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_SWITCHESImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_SWITCHESImpl(" + element + ")");
        OVERLORDINFRAType.SWITCHES switches = (OVERLORDINFRAType.SWITCHES)element;
        List tempSwitchList = switches.getSWITCH();
        List tempSwitchBayList = switches.getBAYS().getBAY();
        for (int i = 0; i < tempSwitchList.size(); ++i) {
            this.switchList.add(new OLSwitch((SWITCHType)tempSwitchList.get(i), (BAYINFOType)tempSwitchBayList.get(i)));
        }
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_MANAGERSImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_MANAGERSImpl(" + element + ")");
        OVERLORDINFRAType.MANAGERS managers = (OVERLORDINFRAType.MANAGERS)element;
        List tempManagerList = managers.getMANAGER();
        List tempManagerBayList = managers.getBAYS().getBAY();
        for (int i = 0; i < tempManagerList.size(); ++i) {
            this.oaList.add(new OnboardAdministrator((ENCLMGRType)tempManagerList.get(i), (BAYINFOType)tempManagerBayList.get(i)));
        }
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_FANSImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_FANSImpl(" + element + ")");
        OVERLORDINFRAType.FANSType fansType = (OVERLORDINFRAType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_TEMPSImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((OVERLORDINFRAType.TEMPSType)element).getContent());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_POWERImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_POWERImpl(" + element + ")");
        this.enclosurePowerType.init(((OVERLORDINFRAType.POWERType)element).getContent());
    }

    public void initializeRKTPLGY_RACKTOPOLOGYTypeImpl_RUIDImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeRKTPLGY_RACKTOPOLOGYTypeImpl_RUIDImpl(" + element + ")");
        this.rackUUID = OAUtil.trimAttribute(((RACKTOPOLOGYType.RUID)element).getValue());
    }

    public void initializeINFRA2_OVERLORDINFRATypeImpl_VCMImpl(Object element) {
        BladeIMELogger.log("OlEnclosure.initializeINFRA2_OVERLORDINFRATypeImpl_VCMImpl(" + element + ")");
        OVERLORDINFRAType.VCM vcm = (OVERLORDINFRAType.VCM)element;
        this.vcmMode = vcm.isVcmMode();
        this.vcmURL = OAUtil.trimAttribute(vcm.getVcmUrl());
        this.vcmDomainName = OAUtil.trimAttribute(vcm.getVcmDomainName());
        this.vcmDomainId = OAUtil.trimAttribute(vcm.getVcmDomainId());
        BladeIMELogger.log("vcmMode:" + this.vcmMode);
        BladeIMELogger.log("vcmURL:" + this.vcmURL);
        BladeIMELogger.log("vcmDomainName:" + this.vcmDomainName);
        BladeIMELogger.log("vcmDomainId:" + this.vcmDomainId);
    }

    public void initializeRKTPLGY_RACKTOPOLOGYTypeImpl_ICMBImpl(Object element) {
        BladeIMELogger.log("OLEnclosure.initializeRKTPLGY_RACKTOPOLOGYTypeImpl_ICMBImpl(" + element + ")");
        RACKTOPOLOGYType.ICMB rackTOPOLOGYICMB = (RACKTOPOLOGYType.ICMB)element;
        ICMB icmb = new ICMB();
        icmb.setUUID(OAUtil.trimAttribute(rackTOPOLOGYICMB.getUUID()));
        icmb.setSerialNumber(rackTOPOLOGYICMB.getSER());
        RACKNEIGHBORType rackTOPOLOGYICMBLeft = rackTOPOLOGYICMB.getLEFT();
        icmb.setLeftUUID(OAUtil.trimAttribute(rackTOPOLOGYICMBLeft.getUUID()));
        icmb.setLeftSerialNumber(OAUtil.trimAttribute(rackTOPOLOGYICMBLeft.getSER()));
        RACKNEIGHBORType rackTOPOLOGYICMBRight = rackTOPOLOGYICMB.getRIGHT();
        icmb.setRightUUID(OAUtil.trimAttribute(rackTOPOLOGYICMBRight.getUUID()));
        icmb.setRightSerialNumber(OAUtil.trimAttribute(rackTOPOLOGYICMBRight.getSER()));
        this.icmbList.add(icmb);
    }

    private void initUniqueIdentifier() {
        this.uniqueIdentifier = this.enclosureUUID;
        if (this.uniqueIdentifier == null || this.uniqueIdentifier.trim().length() == 0) {
            this.uniqueIdentifier = this.enclosureSerialNumber;
        }
    }

    public void update(MxNode enclosureMxNode) {
        BladeIMELogger.log("OLEnclosure.update(" + enclosureMxNode + ")");
        this.clean(enclosureMxNode);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[0], this.enclosureUUIDStatus);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[1], this.enclosureAddress);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[2], this.enclosurePartNumber);
        BladeIMELogger.log("vcmMode:" + this.vcmMode);
        BladeIMELogger.log("vcmURL:" + this.vcmURL);
        BladeIMELogger.log("vcmDomainName:" + this.vcmDomainName);
        BladeIMELogger.log("vcmDomainId:" + this.vcmDomainId);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[3], new Boolean(this.vcmMode).toString());
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[4], this.vcmURL);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[5], this.vcmDomainName);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[6], this.vcmDomainId);
        this.deviceFansType.update(enclosureMxNode, this.uniqueIdentifier);
        this.deviceTempsType.update(enclosureMxNode, this.uniqueIdentifier);
        this.enclosurePowerType.update(enclosureMxNode, this.uniqueIdentifier);
        OAUtil.commit(enclosureMxNode);
    }

    private void cleanDataFromEnclosure(MxNode enclosureMxNode) {
        BladeIMELogger.log("OLEnclosure.cleanDataFromEnclosure(" + enclosureMxNode + ")");
        this.deviceFansType.clean(enclosureMxNode, this.uniqueIdentifier);
        this.deviceTempsType.clean(enclosureMxNode, this.uniqueIdentifier);
        this.enclosurePowerType.clean(enclosureMxNode, this.uniqueIdentifier);
    }

    private void clean(MxNode enclosureMxNode) {
        BladeIMELogger.log("OLEnclosure.clean(" + enclosureMxNode + ")");
        try {
            BladeIMELogger.log("OLEnclosure.clean.Cleaning enclosure data uniqueIdentifier " + this.uniqueIdentifier);
            OAHelper.getOAHelper().getOLEnclosure(enclosureMxNode).cleanDataFromEnclosure(enclosureMxNode);
            BladeIMELogger.log("OLEnclosure.clean.Cleaning done from enclosure uniqueIdentifier " + this.uniqueIdentifier);
        }
        catch (OAException e) {
            BladeIMELogger.log("OLEnclosure.clean. Unable to find old OLEnclosure. Cleanup failed uniqueIdentifier " + this.uniqueIdentifier);
        }
    }

    public List getSwitchList() {
        return this.switchList;
    }

    public List getBladeList() {
        return this.bladeList;
    }

    public List getOAList() {
        return this.oaList;
    }

    public OLDevice resolveBladeDevice(String deviceSerialNumber) throws OAException {
        BladeIMELogger.log("OLEnclosure.resolveBladeDevice(" + deviceSerialNumber + ")");
        return this.resolveDevice(this.bladeList, deviceSerialNumber);
    }

    public OLDevice resolveSwitchDevice(String deviceSerialNumber) throws OAException {
        BladeIMELogger.log("OLEnclosure.resolveSwitchDevice(" + deviceSerialNumber + ")");
        return this.resolveDevice(this.switchList, deviceSerialNumber);
    }

    public OLDevice resolveOADevice(String deviceSerialNumber) throws OAException {
        BladeIMELogger.log("OLEnclosure.resolveOADevice(" + deviceSerialNumber + ")");
        return this.resolveDevice(this.oaList, deviceSerialNumber);
    }

    private OLDevice resolveDevice(List deviceList, String deviceSerialNumber) throws OAException {
        BladeIMELogger.log("OLEnclosure.resolveDevice(" + deviceList + "," + deviceSerialNumber + ")");
        OLDevice device = null;
        for (int i = 0; i < deviceList.size(); ++i) {
            device = (OLDevice)deviceList.get(i);
            if (!device.getDeviceSerialNumber().equalsIgnoreCase(deviceSerialNumber)) continue;
            return device;
        }
        throw new OAException("Unable to resolve device " + deviceSerialNumber);
    }

    public OLDevice resolveCurrentOADevice(String MGMTPROC_ADDRESS) throws OAException {
        BladeIMELogger.log("OLEnclosure.resolveCurrentOADevice(" + MGMTPROC_ADDRESS + ")");
        OLDevice olDevice = null;
        for (int i = 0; i < this.oaList.size(); ++i) {
            olDevice = (OLDevice)this.oaList.get(i);
            if (!olDevice.getDeviceMgmtProcIp().equalsIgnoreCase(MGMTPROC_ADDRESS)) continue;
            return olDevice;
        }
        throw new OAException("Unable to resolve current OA device");
    }

    public String getRackName() {
        return this.rackName;
    }

    public String getEnclosureSerialNumber() {
        return this.enclosureSerialNumber;
    }

    public String getEnclosureProductName() {
        return this.enclosureProductName;
    }

    public String getEnclosureName() {
        return this.enclosureName;
    }

    public String getEnclosureAsset() {
        return this.enclosureAsset;
    }

    public String getEnclosureUUID() {
        return this.enclosureUUID;
    }

    public String getEnclosureUUIDStatus() {
        return this.enclosureUUIDStatus;
    }

    public String getEnclosureStatus() {
        return this.enclosureStatus;
    }

    public String getEnclosureAddress() {
        return this.enclosureAddress;
    }

    public String getEnclosurePartNumber() {
        return this.enclosurePartNumber;
    }

    public int getEnclosureHeight() {
        return this.enclosureHeight;
    }

    public int getEnclosureWidth() {
        return this.encloureWidth;
    }

    public int getEnclosureDepth() {
        return this.enclosureDepth;
    }

    public boolean getEnclosureVCMMode() {
        return this.vcmMode;
    }

    public String getEnclosureVCMURL() {
        return this.vcmURL;
    }

    public String getEnclosureVCMDomainName() {
        return this.vcmDomainName;
    }

    public String getEnclosureVCMDomainID() {
        return this.vcmDomainId;
    }

    public String getRackUUID() {
        return this.rackUUID;
    }

    public List getICMBList() {
        return this.icmbList;
    }

    public DeviceTempsType getDeviceTempsType() {
        return this.deviceTempsType;
    }

    public DeviceFansType getDeviceFansType() {
        return this.deviceFansType;
    }

    public EnclosurePowerType getEnclosurePowerType() {
        return this.enclosurePowerType;
    }

    private void validateAttributes() {
        if (this.enclosureSerialNumber == null || this.enclosureSerialNumber.trim().length() == 0) {
            this.enclosureSerialNumber = "";
        }
        if (this.enclosureProductName == null || this.enclosureProductName.trim().length() == 0) {
            this.enclosureProductName = "";
        }
        if (this.enclosureName == null || this.enclosureName.trim().length() == 0) {
            this.enclosureName = "";
        }
        if (this.enclosureAsset == null || this.enclosureAsset.trim().length() == 0) {
            this.enclosureAsset = "";
        }
        if (this.enclosureUUID == null || this.enclosureUUID.trim().length() == 0) {
            this.enclosureUUID = "";
        }
        if (this.enclosureUUIDStatus == null || this.enclosureUUIDStatus.trim().length() == 0) {
            this.enclosureUUIDStatus = "";
        }
        if (this.enclosureStatus == null || this.enclosureStatus.trim().length() == 0) {
            this.enclosureStatus = "";
        }
        if (this.enclosureAddress == null || this.enclosureAddress.trim().length() == 0) {
            this.enclosureAddress = "";
        }
        if (this.enclosurePartNumber == null || this.enclosurePartNumber.trim().length() == 0) {
            this.enclosurePartNumber = "";
        }
        if (this.rackName == null || this.rackName.trim().length() == 0) {
            this.rackName = "";
        }
        if (this.rackUUID == null || this.rackUUID.trim().length() == 0) {
            this.rackUUID = "";
        }
    }

    public MxNode getDeviceMxNode() throws OAException {
        BladeIMELogger.log("OLEnclosure.getDeviceMxNode()");
        MxNode enclosureMxNode = null;
        try {
            enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.enclosureUUID);
        }
        catch (MxException e) {
            BladeIMELogger.log((Exception)((Object)e), "OLEnclosure.getDeviceMxNode unable to find enclosure node by UUID " + this.enclosureUUID);
            try {
                enclosureMxNode = OAUtil.getNodeBySerialNumber(this.enclosureSerialNumber);
            }
            catch (OAException oe) {
                BladeIMELogger.log((Exception)((Object)e), "OLEnclosure.getDeviceMxNode unable to find enclosure node by sn " + this.enclosureSerialNumber);
                throw new OAException(oe, "OLEnclosure.getDeviceMxNode unable to find enclosure node by sn " + oe);
            }
        }
        return enclosureMxNode;
    }

    protected void print(String SOURCE) {
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("OLEnclosure.enclosureSerialNumber " + this.enclosureSerialNumber);
        BladeIMELogger.log("OLEnclosure.enclosureProductName " + this.enclosureProductName);
        BladeIMELogger.log("OLEnclosure.enclosureName " + this.enclosureName);
        BladeIMELogger.log("OLEnclosure.enclosureAsset " + this.enclosureAsset);
        BladeIMELogger.log("OLEnclosure.enclosureUUID " + this.enclosureUUID);
        BladeIMELogger.log("OLEnclosure.enclosureUUIDStatus " + this.enclosureUUIDStatus);
        BladeIMELogger.log("OLEnclosure.enclosureStatus " + this.enclosureStatus);
        BladeIMELogger.log("OLEnclosure.enclosureAddress " + this.enclosureAddress);
        BladeIMELogger.log("OLEnclosure.enclosurePartNumber " + this.enclosurePartNumber);
        BladeIMELogger.log("OLEnclosure.enclosureHeight " + this.enclosureHeight);
        BladeIMELogger.log("OLEnclosure.encloureWidth " + this.encloureWidth);
        BladeIMELogger.log("OLEnclosure.enclosureDepth " + this.enclosureDepth);
        BladeIMELogger.log("OLEnclosure.rackName " + this.rackName);
        BladeIMELogger.log("OLEnclosure.rackUUID " + this.rackUUID);
        BladeIMELogger.log("OLEnclosure.uniqueIdentifier " + this.uniqueIdentifier);
        BladeIMELogger.log("OLEnclosure.vcmMode " + this.vcmMode);
        BladeIMELogger.log("OLEnclosure.vcmURL " + this.vcmURL);
        BladeIMELogger.log("OLEnclosure.vcmDomainName " + this.vcmDomainName);
        BladeIMELogger.log("OLEnclosure.vcmDomainId " + this.vcmDomainId);
        BladeIMELogger.log("OLEnclosure.bladeList.size() " + this.bladeList.size());
        BladeIMELogger.log("OLEnclosure.switchList.size() " + this.switchList.size());
        BladeIMELogger.log("OLEnclosure.oaList.size() " + this.oaList.size());
        BladeIMELogger.log("OLEnclosure.icmbList.size() " + this.icmbList.size());
        ICMB icmb = null;
        for (int i = 0; i < this.icmbList.size(); ++i) {
            icmb = (ICMB)this.icmbList.get(i);
            BladeIMELogger.log("icmb.getUUID() " + icmb.getUUID());
            BladeIMELogger.log("icmb.getSerialNumber() " + icmb.getSerialNumber());
            BladeIMELogger.log("icmb.getLeftUUID() " + icmb.getLeftUUID());
            BladeIMELogger.log("icmb.getLeftSerialNumber() " + icmb.getLeftSerialNumber());
            BladeIMELogger.log("icmb.getRightUUID() " + icmb.getRightUUID());
            BladeIMELogger.log("icmb.getRightSerialNumber() " + icmb.getRightSerialNumber());
        }
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }
}

