/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.OAXml.DeviceFansType;
import com.hp.mx.portal.OAXml.DeviceTempsType;
import com.hp.mx.portal.OAXml.OAUtil;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.List;

public abstract class OLDevice {
    protected int connection;
    protected List occupiesList;
    protected int slotsUsedInXDirection;
    protected int slotsUsedInYDirection;
    protected int width;
    protected int height;
    protected int depth;
    protected String side;
    protected String mgmtIPAddress;
    protected String spn;
    protected String bsn;
    protected String manufacturer;
    protected String status;
    protected String uidStatus;
    protected String uuid;
    protected String uniqueIdentifier;
    protected DeviceTempsType deviceTempsType = new DeviceTempsType();
    protected DeviceFansType deviceFansType = new DeviceFansType();
    private final String[] CLIENTATTRIBUTES = new String[]{"DEV_CON_", "DEV_SLT_X_", "DEV_SLT_Y_", "DEV_WID_", "DEV_HEIG_", "DEV_DEP_", "DEV_BSN_", "DEV_SPN_", "DEV_ST_", "UUID_", "DEV_SIDE_", "DEV_MGMTIP_", "DEV_MANFACT_", "DEV_UIDST_"};

    public OLDevice() {
    }

    public OLDevice(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        BladeIMELogger.log("OLDevice(" + initFromMxNode + "," + deviceUniqueIdentifier + ")");
        this.uniqueIdentifier = deviceUniqueIdentifier;
        if (initFromMxNode.getDeviceType().equals("Enclosure")) {
            this.initFromEnclosure(initFromMxNode);
        } else {
            this.initFromDevice(initFromMxNode);
        }
        this.deviceFansType.init(initFromMxNode, this.uniqueIdentifier);
        this.deviceTempsType.init(initFromMxNode, this.uniqueIdentifier);
    }

    private void initFromEnclosure(MxNode enclosureMxNode) {
        try {
            this.connection = OAUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + this.uniqueIdentifier));
            this.slotsUsedInXDirection = OAUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + this.uniqueIdentifier));
            this.slotsUsedInYDirection = OAUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + this.uniqueIdentifier));
            this.width = OAUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3] + this.uniqueIdentifier));
            this.height = OAUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[4] + this.uniqueIdentifier));
            this.depth = OAUtil.getIntValue(enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[5] + this.uniqueIdentifier));
            this.bsn = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[6] + this.uniqueIdentifier);
            this.spn = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[7] + this.uniqueIdentifier);
            this.status = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[8] + this.uniqueIdentifier);
            this.side = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[10] + this.uniqueIdentifier);
            this.mgmtIPAddress = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[11] + this.uniqueIdentifier);
            this.manufacturer = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[12] + this.uniqueIdentifier);
            this.uidStatus = enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[13] + this.uniqueIdentifier);
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "OLDevice.initFromEnclosure.Exception. " + e);
        }
    }

    private void initFromDevice(MxNode deviceMxNode) {
        this.side = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[10] + this.uniqueIdentifier);
        this.mgmtIPAddress = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[11] + this.uniqueIdentifier);
        this.manufacturer = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[12] + this.uniqueIdentifier);
        this.uidStatus = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[13] + this.uniqueIdentifier);
    }

    protected void initUniqueIdentifier() {
        this.uniqueIdentifier = this.uuid;
        if (this.uniqueIdentifier == null || this.uniqueIdentifier.trim().length() == 0) {
            this.uniqueIdentifier = this.bsn;
        }
    }

    protected void updateDataOnDevice(MxNode deviceMxNode) {
        BladeIMELogger.log("OLDevice.updateDataOnDevice(" + deviceMxNode + ")");
        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[9] + this.uniqueIdentifier, this.uniqueIdentifier);
        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[10] + this.uniqueIdentifier, this.side);
        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[11] + this.uniqueIdentifier, this.mgmtIPAddress);
        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[12] + this.uniqueIdentifier, this.manufacturer);
        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[13] + this.uniqueIdentifier, this.uidStatus);
        this.deviceFansType.update(deviceMxNode, this.uniqueIdentifier);
        this.deviceTempsType.update(deviceMxNode, this.uniqueIdentifier);
    }

    protected void updateDataOnEnclosure(MxNode enclosureMxNode) {
        BladeIMELogger.log("OLDevice.updateDataOnEnclosure(" + enclosureMxNode + ")");
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + this.uniqueIdentifier, String.valueOf(this.connection));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + this.uniqueIdentifier, String.valueOf(this.slotsUsedInXDirection));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + this.uniqueIdentifier, String.valueOf(this.slotsUsedInYDirection));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[3] + this.uniqueIdentifier, String.valueOf(this.width));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[4] + this.uniqueIdentifier, String.valueOf(this.height));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[5] + this.uniqueIdentifier, String.valueOf(this.depth));
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[6] + this.uniqueIdentifier, this.bsn);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[7] + this.uniqueIdentifier, this.spn);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[8] + this.uniqueIdentifier, this.status);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[9] + this.uniqueIdentifier, this.uniqueIdentifier);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[10] + this.uniqueIdentifier, this.side);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[11] + this.uniqueIdentifier, this.mgmtIPAddress);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[12] + this.uniqueIdentifier, this.manufacturer);
        enclosureMxNode.setClientAttribute(this.CLIENTATTRIBUTES[13] + this.uniqueIdentifier, this.uidStatus);
        this.deviceFansType.update(enclosureMxNode, this.uniqueIdentifier);
        this.deviceTempsType.update(enclosureMxNode, this.uniqueIdentifier);
    }

    public String getDeviceSerialNumber() {
        return this.bsn;
    }

    public String getDeviceProductName() {
        return this.spn;
    }

    public int getDeviceSlot() {
        return this.connection;
    }

    public String getDeviceMgmtProcIp() {
        return this.mgmtIPAddress;
    }

    public String getDeviceSide() {
        return this.side;
    }

    public int getDeviceSlotsInXDirection() {
        return this.slotsUsedInXDirection;
    }

    public int getDeviceSlotsInYDirection() {
        return this.slotsUsedInYDirection;
    }

    public int getDeviceWidth() {
        return this.width;
    }

    public int getDeviceDepth() {
        return this.depth;
    }

    public int getDeviceHeight() {
        return this.height;
    }

    public String getDeviceManufacturer() {
        return this.manufacturer;
    }

    public String getDeviceStatus() {
        return this.status;
    }

    public String getDeviceUIDStatus() {
        return this.uidStatus;
    }

    public String getDeviceUUID() {
        return this.uuid;
    }

    public abstract String getDeviceType();

    public abstract List getSubTypeList();

    public abstract MxNode getDeviceMxNode();

    public abstract void update(MxNode var1, MxNode var2);

    public abstract boolean isUniqueIdentifierExists();

    public DeviceTempsType getDeviceTempsType() {
        return this.deviceTempsType;
    }

    public DeviceFansType getDeviceFansType() {
        return this.deviceFansType;
    }

    protected void calculateDirection(int MAX_SLOTS_IN_XDIRECTION) {
        int FIRST_OCCUPIED_SLOT;
        BladeIMELogger.log("OLDevice.calculateDirection(" + MAX_SLOTS_IN_XDIRECTION + ")");
        int TOTAL_SLOTS_OCCUPIED = this.occupiesList.size() + 1;
        this.slotsUsedInYDirection = 1;
        if (this.occupiesList.size() > 0 && (this.occupiesList.contains(String.valueOf((FIRST_OCCUPIED_SLOT = Integer.parseInt((String)this.occupiesList.get(0))) + MAX_SLOTS_IN_XDIRECTION)) || this.connection + MAX_SLOTS_IN_XDIRECTION == FIRST_OCCUPIED_SLOT)) {
            this.slotsUsedInYDirection = 2;
        }
        this.slotsUsedInXDirection = TOTAL_SLOTS_OCCUPIED / this.slotsUsedInYDirection;
    }

    public void move(MxNode toMxNode, MxNode fromMxNode) {
        BladeIMELogger.log("OLDevice.move(" + toMxNode + "," + fromMxNode + ")");
        for (int i = 9; i < this.CLIENTATTRIBUTES.length; ++i) {
            toMxNode.setClientAttribute(this.CLIENTATTRIBUTES[i] + this.uniqueIdentifier, fromMxNode.getClientAttribute(this.CLIENTATTRIBUTES[i] + this.uniqueIdentifier));
            fromMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + this.uniqueIdentifier);
        }
        this.deviceFansType.move(toMxNode, fromMxNode, this.uniqueIdentifier);
        this.deviceTempsType.move(toMxNode, fromMxNode, this.uniqueIdentifier);
    }

    public void remove(MxNode enclosureMxNode) {
        BladeIMELogger.log("OLDevice.remove(" + enclosureMxNode + ")");
        for (int i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + this.uniqueIdentifier);
        }
    }

    protected void cleanDataFromDevice(MxNode deviceMxNode) {
        BladeIMELogger.log("OLDevice.cleanDataFromDevice(" + deviceMxNode + ")");
        this.deviceFansType.clean(deviceMxNode, this.uniqueIdentifier);
        this.deviceTempsType.clean(deviceMxNode, this.uniqueIdentifier);
    }

    protected void cleanDataFromEnclosure(MxNode enclosureMxNode) {
        BladeIMELogger.log("OLDevice.cleanDataFromEnclosure(" + enclosureMxNode + ")");
        this.deviceFansType.clean(enclosureMxNode, this.uniqueIdentifier);
        this.deviceTempsType.clean(enclosureMxNode, this.uniqueIdentifier);
    }

    protected void validateAttributes() {
        if (this.side == null || this.side.trim().length() == 0) {
            this.side = "";
        }
        if (this.mgmtIPAddress == null || this.mgmtIPAddress.trim().length() == 0) {
            this.mgmtIPAddress = "";
        }
        if (this.spn == null || this.spn.trim().length() == 0) {
            this.spn = "";
        }
        if (this.bsn == null || this.bsn.trim().length() == 0) {
            this.bsn = "";
        }
        if (this.manufacturer == null || this.manufacturer.trim().length() == 0) {
            this.manufacturer = "";
        }
        if (this.status == null || this.status.trim().length() == 0) {
            this.status = "";
        }
        if (this.uidStatus == null || this.uidStatus.trim().length() == 0) {
            this.uidStatus = "";
        }
        if (this.uuid == null || this.uuid.trim().length() == 0) {
            this.uuid = "";
        }
    }

    protected void print(String SOURCE) {
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("OLDevice.connection " + this.connection);
        BladeIMELogger.log("OLDevice.occupiesList " + this.occupiesList);
        if (this.occupiesList != null) {
            BladeIMELogger.log("OLDevice.occupiesList.size() " + this.occupiesList.size());
        }
        BladeIMELogger.log("OLDevice.slotsUsedInXDirection " + this.slotsUsedInXDirection);
        BladeIMELogger.log("OLDevice.slotsUsedInYDirection " + this.slotsUsedInYDirection);
        BladeIMELogger.log("OLDevice.width " + this.width);
        BladeIMELogger.log("OLDevice.height " + this.height);
        BladeIMELogger.log("OLDevice.depth " + this.depth);
        BladeIMELogger.log("OLDevice.side " + this.side);
        BladeIMELogger.log("OLDevice.mgmtIPAddress " + this.mgmtIPAddress);
        BladeIMELogger.log("OLDevice.spn " + this.spn);
        BladeIMELogger.log("OLDevice.bsn " + this.bsn);
        BladeIMELogger.log("OLDevice.manufacturer " + this.manufacturer);
        BladeIMELogger.log("OLDevice.status " + this.status);
        BladeIMELogger.log("OLDevice.uidStatus " + this.uidStatus);
        BladeIMELogger.log("OLDevice.uuid " + this.uuid);
        BladeIMELogger.log("OLDevice.uniqueIdentifier " + this.uniqueIdentifier);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }
}

