/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAUtil;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BLADEPortMap;
import com.hp.mx.portal.OAXml.OLConstants;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class OLBladePortMap {
    private String status;
    private List mezzTypeList = new ArrayList();
    private final String[] CLIENTATTRIBUTES = new String[]{"BL_PRTMAP_ST_", "MEZ_CNT_"};

    void init(MxNode deviceMxNode, String uniqueIdentifier) {
        BladeIMELogger.log("OLBladePortMap.init(" + deviceMxNode + "," + uniqueIdentifier + ")");
        this.status = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier);
        BladeIMELogger.log("OLBladePortMap.init.status " + this.status);
        try {
            int OLBLADEPORTMAP_MEZZ_COUNT = OAUtil.getIntValue(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + uniqueIdentifier));
            BladeIMELogger.log("OLBladePortMap.init.OLBLADEPORTMAP_MEZZ_COUNT " + OLBLADEPORTMAP_MEZZ_COUNT);
            MezzType mezzType = null;
            for (int i = 0; i < OLBLADEPORTMAP_MEZZ_COUNT; ++i) {
                mezzType = this.getMezzType();
                mezzType.init(deviceMxNode, uniqueIdentifier, i);
                this.addMezzType(mezzType);
            }
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "OLBladePortMap.init(DB).Unable to initialize MezzType " + e);
        }
        this.print("OLBLADEPORTMAP.init DB");
    }

    void init(BLADEPortMap bladePortMap) {
        BladeIMELogger.log("OLBladePortMap.init(" + bladePortMap + ")");
        try {
            this.status = OAUtil.trimAttribute(bladePortMap.getSTATUS());
            List tempMezzList = bladePortMap.getMEZZ();
            MezzType mezzType = null;
            for (int i = 0; i < tempMezzList.size(); ++i) {
                try {
                    mezzType = this.getMezzType();
                    mezzType.init((BLADEPortMap.MEZZType)tempMezzList.get(i));
                    this.addMezzType(mezzType);
                    continue;
                }
                catch (OAException e) {
                    BladeIMELogger.log(e, "OLBladePortMap.init(JAXB).OAException " + e);
                }
            }
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "OLBladePortMap.init(JAXB).OAException " + e);
        }
        this.print("OLBladePortMap.init JAXB");
    }

    void update(MxNode mxNode, String uniqueIdentifier) {
        BladeIMELogger.log("OLBladePortMap.update(" + mxNode + "," + uniqueIdentifier + ")");
        BladeIMELogger.log("OLBladePortMap.update.status " + this.status);
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier, this.status);
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + uniqueIdentifier, String.valueOf(this.mezzTypeList.size()));
        for (int i = 0; i < this.mezzTypeList.size(); ++i) {
            ((MezzType)this.mezzTypeList.get(i)).update(mxNode, uniqueIdentifier, i);
        }
    }

    void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("OLBladePortMap.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier));
            enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        for (i = 0; i < this.mezzTypeList.size(); ++i) {
            ((MezzType)this.mezzTypeList.get(i)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i);
        }
    }

    void clean(MxNode deviceMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("OLBladePortMap.clean(" + deviceMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        for (i = 0; i < this.mezzTypeList.size(); ++i) {
            ((MezzType)this.mezzTypeList.get(i)).clean(deviceMxNode, uniqueIdentifier, i);
        }
    }

    private void print(String SOURCE) {
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("OLBladePortMap.status " + this.status);
        BladeIMELogger.log("OLBladePortMap.mezzTypeList.size() " + this.mezzTypeList.size());
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }

    private MezzType getMezzType() {
        return new MezzType();
    }

    private void addMezzType(MezzType mezzType) {
        this.mezzTypeList.add(mezzType);
    }

    public String getStatus() {
        return this.status;
    }

    public List getMezzTypeList() {
        return this.mezzTypeList;
    }

    public class MezzType {
        private String number;
        private SlotType slotType = new SlotType();
        private DeviceType deviceType = new DeviceType();
        private final String[] CLIENTATTRIBUTES = new String[]{"MEZTYPE_NUM_"};

        private void init(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("OLBladePortMap.MezzType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            this.number = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
            this.print("OLBLADEPORTMAP.MezzType.init DB");
            this.slotType.init(deviceMxNode, uniqueIdentifier, i);
            this.deviceType.init(deviceMxNode, uniqueIdentifier, i);
        }

        private void init(BLADEPortMap.MEZZType tempMezzType) throws OAException {
            BladeIMELogger.log("OLBladePortMap.MezzType.init(" + tempMezzType + ")");
            try {
                this.number = OAUtil.trimAttribute(tempMezzType.getNUMBER().toString());
                this.print("OLBladePortMap.MezzType.init JAXB");
                this.slotType.init(tempMezzType.getSLOT());
                this.deviceType.init(tempMezzType.getDEVICE());
            }
            catch (Exception e) {
                throw new OAException(e, "OLBladePortMap.MezzType.init(JAXB).Exception " + e);
            }
        }

        private void update(MxNode mxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("OLBladePortMap.MezzType.update(" + mxNode + "," + uniqueIdentifier + "," + i + ")");
            BladeIMELogger.log("OLBladePortMap.MezzType.update.number " + this.number);
            BladeIMELogger.log("OLBladePortMap.MezzType.update.slotType " + this.slotType);
            BladeIMELogger.log("OLBladePortMap.MezzType.update.deviceType " + this.deviceType);
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.number);
            this.slotType.update(mxNode, uniqueIdentifier, i);
            this.deviceType.update(mxNode, uniqueIdentifier, i);
        }

        private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("OLBladePortMap.MezzType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            for (int j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty));
                enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
            }
            this.slotType.move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i);
            this.deviceType.move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i);
        }

        private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("OLBladePortMap.MezzType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            for (int j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
            }
            this.slotType.clean(deviceMxNode, uniqueIdentifier, i);
            this.deviceType.clean(deviceMxNode, uniqueIdentifier, i);
        }

        private void print(String SOURCE) {
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
            BladeIMELogger.log("OLBladePortMap.MezzType.number " + this.number);
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
        }

        public String getNumber() {
            return this.number;
        }

        public SlotType getSlotType() {
            return this.slotType;
        }

        public DeviceType getDeviceType() {
            return this.deviceType;
        }

        public class DeviceType {
            private String name;
            private String type;
            private String status;
            private List portTypeList = new ArrayList();
            private final String[] CLIENTATTRIBUTES = new String[]{"MEZ_DEV_NAME_", "MEZ_DEV_TYPE_", "MEZ_DEV_ST_", "MEZ_DEV_PRT_CNT_"};

            private void init(MxNode deviceMxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                this.name = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
                this.type = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty);
                this.status = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty);
                try {
                    int OLBLADEPORTMAP_MEZZTTYPE_DEVICETYPE_PORT_COUNT = Integer.parseInt(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty));
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.init.OLBLADEPORTMAP_MEZZTTYPE_DEVICETYPE_PORT_COUNT " + OLBLADEPORTMAP_MEZZTTYPE_DEVICETYPE_PORT_COUNT);
                    PortType portType = null;
                    for (int j = 0; j < OLBLADEPORTMAP_MEZZTTYPE_DEVICETYPE_PORT_COUNT; ++j) {
                        portType = this.getPortType();
                        portType.init(deviceMxNode, uniqueIdentifier, i, j);
                        this.addPortType(portType);
                    }
                }
                catch (Exception e) {
                    BladeIMELogger.log(e, "OLBladePortMap.MezzType.DeviceType.init(DB).Unable to initialize PortType " + e);
                }
                this.print("OLBLADEPORTMAP.MezzType.DeviceType.init DB");
            }

            private void init(BLADEPortMap.MEZZType.DEVICEType tempDeviceType) throws OAException {
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.init(" + tempDeviceType + ")");
                try {
                    if (tempDeviceType != null) {
                        this.name = tempDeviceType.getNAME();
                        this.type = tempDeviceType.getTYPE();
                        this.status = tempDeviceType.getSTATUS();
                        List tempPortList = tempDeviceType.getPORT();
                        BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.init.tempPortList.size() " + tempPortList.size());
                        this.print("OLBladePortMap.MezzType.DeviceType JAXB");
                        PortType portType = null;
                        for (int i = 0; i < tempPortList.size(); ++i) {
                            try {
                                portType = this.getPortType();
                                portType.init((BLADEPortMap.MEZZType.DEVICEType.PORTType)tempPortList.get(i));
                                this.addPortType(portType);
                                continue;
                            }
                            catch (OAException e) {
                                BladeIMELogger.log(e, "OLBladePortMap.MezzType.DeviceType.init(JAXB).OAException " + e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new OAException(e, "OLBladePortMap.MezzType.DeviceType.init(JAXB).Exception " + e);
                }
            }

            private void update(MxNode mxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.update(" + mxNode + "," + uniqueIdentifier + "," + i + ")");
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.update.type " + this.type);
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.update.status " + this.status);
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.name);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.type);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, this.status);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty, String.valueOf(this.portTypeList.size()));
                for (int j = 0; j < this.portTypeList.size(); ++j) {
                    ((PortType)this.portTypeList.get(j)).update(mxNode, uniqueIdentifier, i, j);
                }
            }

            private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i) {
                int j;
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                    deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty));
                    enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
                }
                for (j = 0; j < this.portTypeList.size(); ++j) {
                    ((PortType)this.portTypeList.get(j)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i, j);
                }
            }

            private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i) {
                int j;
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                    deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
                }
                for (j = 0; j < this.portTypeList.size(); ++j) {
                    ((PortType)this.portTypeList.get(j)).clean(deviceMxNode, uniqueIdentifier, i, j);
                }
            }

            private void print(String SOURCE) {
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.name " + this.name);
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.type " + this.type);
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.status " + this.status);
                BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.portTypeList.size() " + this.portTypeList.size());
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
            }

            public String getName() {
                return this.name;
            }

            public String getType() {
                return this.type;
            }

            public String getStatus() {
                return this.status;
            }

            private PortType getPortType() {
                return new PortType();
            }

            private void addPortType(PortType portType) {
                this.portTypeList.add(portType);
            }

            public List getPortTypeList() {
                return this.portTypeList;
            }

            public class PortType {
                private String number;
                private String wwpn;
                private String type;
                private String status;
                private final String[] CLIENTATTRIBUTES = new String[]{"MEZ_DEV_PRT_NUM_", "MEZ_DEV_PRT_WWPN_", "MEZ_DEV_PRT_TYPE_", "MEZ_DEV_PRT_ST_"};

                private void init(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    this.number = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
                    this.wwpn = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty);
                    this.type = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty);
                    this.status = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty);
                    this.print("OLBLADEPORTMAP.MezzType.DeviceType.PortType.init DB");
                }

                private void init(BLADEPortMap.MEZZType.DEVICEType.PORTType tempPortType) throws OAException {
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.init(" + tempPortType + ")");
                    try {
                        this.number = tempPortType.getNUMBER().toString();
                        this.wwpn = tempPortType.getWWPN();
                        this.type = tempPortType.getTYPE();
                        this.status = tempPortType.getSTATUS();
                    }
                    catch (Exception e) {
                        throw new OAException(e, "OLBladePortMap.MezzType.DeviceType.PortType.init(JAXB).Exception " + e);
                    }
                    this.print("OLBladePortMap.MezzType.DeviceType.PortType.init JAXB");
                }

                private void update(MxNode mxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.update(" + mxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.number);
                    mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.wwpn);
                    mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, this.type);
                    mxNode.setClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty, this.status);
                }

                private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty));
                        enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty);
                    }
                }

                private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                        deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty);
                    }
                }

                private void print(String SOURCE) {
                    BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.number " + this.number);
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.wwpn " + this.wwpn);
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.type " + this.type);
                    BladeIMELogger.log("OLBladePortMap.MezzType.DeviceType.PortType.status " + this.status);
                    BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
                }

                public String getNumber() {
                    return this.number;
                }

                public String getWWPN() {
                    return this.wwpn;
                }

                public String getType() {
                    return this.type;
                }

                public String getStatus() {
                    return this.status;
                }
            }
        }

        public class SlotType {
            private String type;
            private List portTypeList = new ArrayList();
            private final String[] CLIENTATTRIBUTES = new String[]{"MEZ_SLT_TYPE_", "MEZ_SLT_PRTCNT_"};

            private void init(MxNode deviceMxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                this.type = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
                this.print("OLBladePortMap.MezzType.SlotType DB");
                try {
                    int OLBLADEPORTMAP_MEZZTTYPE_SLOTTYPE_PORTCOUNT = OAUtil.getIntValue(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty));
                    PortType portType = null;
                    for (int j = 0; j < OLBLADEPORTMAP_MEZZTTYPE_SLOTTYPE_PORTCOUNT; ++j) {
                        portType = this.getPortType();
                        portType.init(deviceMxNode, uniqueIdentifier, i, j);
                        this.addPortType(portType);
                    }
                }
                catch (Exception e) {
                    BladeIMELogger.log(e, "OLBladePortMap.MezzType.SlotType.init(DB).Unable to initialize SlotType " + e);
                }
            }

            private void init(BLADEPortMap.MEZZType.SLOTType tempSlotType) throws OAException {
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.init(" + tempSlotType + ")");
                try {
                    this.type = tempSlotType.getTYPE();
                    this.print("OLBladePortMap.MezzType.SlotType.init JAXB");
                    List tempPortTypeList = tempSlotType.getPORT();
                    PortType portType = null;
                    for (int i = 0; i < tempPortTypeList.size(); ++i) {
                        try {
                            portType = this.getPortType();
                            portType.init((BLADEPortMap.MEZZType.SLOTType.PORTType)tempPortTypeList.get(i));
                            this.addPortType(portType);
                            continue;
                        }
                        catch (OAException e) {
                            BladeIMELogger.log(e, "OLBladePortMap.init(JAXB).OAException " + e);
                        }
                    }
                }
                catch (Exception e) {
                    throw new OAException(e, "OLBladePortMap.MezzType.SlotType.init(JAXB).Exception " + e);
                }
            }

            private void update(MxNode mxNode, String uniqueIdentifier, int i) {
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.update(" + mxNode + "," + uniqueIdentifier + "," + i + ")");
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.update.type " + this.type);
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.type);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, String.valueOf(this.portTypeList.size()));
                for (int j = 0; j < this.portTypeList.size(); ++j) {
                    ((PortType)this.portTypeList.get(j)).update(mxNode, uniqueIdentifier, i, j);
                }
            }

            private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i) {
                int j;
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                    deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty));
                    enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
                }
                for (j = 0; j < this.portTypeList.size(); ++j) {
                    ((PortType)this.portTypeList.get(j)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i, j);
                }
            }

            private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i) {
                int j;
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
                for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                    deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
                }
                for (j = 0; j < this.portTypeList.size(); ++j) {
                    ((PortType)this.portTypeList.get(j)).clean(deviceMxNode, uniqueIdentifier, i, j);
                }
            }

            private void print(String SOURCE) {
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.type " + this.type);
                BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.portTypeList.size() " + this.portTypeList.size());
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
            }

            public String getType() {
                return this.type;
            }

            private PortType getPortType() {
                return new PortType();
            }

            private void addPortType(PortType portType) {
                this.portTypeList.add(portType);
            }

            public List getPortTypeList() {
                return this.portTypeList;
            }

            public class PortType {
                private String number;
                private String trayBayNumber;
                private String trayPortNumber;
                private final String[] CLIENTATTRIBUTES = new String[]{"MEZ_SLT_PRT_NUM_", "MEZ_SLT_PRT_BAY_", "MEZ_SLT_PRT_PRTNUM_"};

                private void init(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    this.number = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
                    this.trayBayNumber = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty);
                    this.trayPortNumber = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty);
                    this.print("OLBladePortMap.MezzType.SlotType.PortType.init DB");
                }

                private void init(BLADEPortMap.MEZZType.SLOTType.PORTType tempPortType) throws OAException {
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.init(" + tempPortType + ")");
                    try {
                        this.number = tempPortType.getNUMBER().toString();
                        this.trayBayNumber = tempPortType.getTRAYBAYNUMBER().toString();
                        this.trayPortNumber = tempPortType.getTRAYPORTNUMBER().toString();
                    }
                    catch (Exception e) {
                        throw new OAException(e, "OLBladePortMap.MezzType.SlotType.PortType.init(JAXB).Exception " + e);
                    }
                    this.print("OLBladePortMap.MezzType.SlotType.PortType.init JAXB");
                }

                private void update(MxNode mxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.update(" + mxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    this.print("OLBladePortMap.MezzType.SlotType.PortType.update");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.number);
                    mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.trayBayNumber);
                    mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, this.trayPortNumber);
                }

                private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                        deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty));
                        enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty);
                    }
                }

                private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                    String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                    for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                        deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty);
                    }
                }

                private void print(String SOURCE) {
                    BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.number " + this.number);
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.trayBayNumber " + this.trayBayNumber);
                    BladeIMELogger.log("OLBladePortMap.MezzType.SlotType.PortType.trayPortNumber " + this.trayPortNumber);
                    BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
                }

                public String getNumber() {
                    return this.number;
                }

                public String getTrayBayNumber() {
                    return this.trayBayNumber;
                }

                public String getTrayPortNumber() {
                    return this.trayPortNumber;
                }
            }
        }
    }
}

