/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.Invoker;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OAUtil;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BAYINFOType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BAYOCCUPANTType;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BLADEPortMap;
import com.hp.mx.portal.OAXml.OAXmlJaxb.BLADEType;
import com.hp.mx.portal.OAXml.OLBladePortMap;
import com.hp.mx.portal.OAXml.OLConstants;
import com.hp.mx.portal.OAXml.OLDevice;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class OLBlade
extends OLDevice {
    private String type;
    private String assocDevBay;
    private OLBladePortMap olBladePortMap = new OLBladePortMap();
    private final String[] BLADECLIENTATTRIBUTES = new String[]{"BL_TYPE_", "BL_STRG_ASSOC_"};

    public OLBlade(MxNode initFromMxNode, String deviceUniqueIdentifier) {
        super(initFromMxNode, deviceUniqueIdentifier);
        BladeIMELogger.log("OLBlade(" + initFromMxNode + "," + this.uniqueIdentifier + ")");
        this.print("OLBlade DB");
        this.assocDevBay = initFromMxNode.getClientAttribute(this.BLADECLIENTATTRIBUTES[1] + initFromMxNode.getAgentUUID());
        this.olBladePortMap.init(initFromMxNode, this.uniqueIdentifier);
    }

    public OLBlade(BLADEType bladeType, BAYINFOType bayInfoType) {
        BladeIMELogger.log("OLBlade(" + bladeType + "," + bayInfoType + ")");
        Invoker.init("initializeINFRA2", bladeType.getContent(), OLBlade.class, this);
        this.calculateDirection(8);
        this.height = bayInfoType.getMmHeight().intValue() * this.slotsUsedInYDirection;
        this.width = bayInfoType.getMmWidth().intValue() * this.slotsUsedInXDirection;
        this.depth = bayInfoType.getMmDepth().intValue();
        this.side = OAUtil.trimAttribute(bayInfoType.getSIDE());
        this.validateAttributes();
        this.initUniqueIdentifier();
        this.print("OLBlade JAXB");
    }

    public void initializeINFRA2_BLADETypeImpl_BAYImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_BAYImpl(" + element + ")");
        BAYOCCUPANTType bayOCCUPANTType = (BAYOCCUPANTType)element;
        this.connection = OAUtil.getIntValue(bayOCCUPANTType.getCONNECTION());
        this.occupiesList = bayOCCUPANTType.getOCCUPIES();
    }

    public void initializeINFRA2_BLADETypeImpl_MGMTIPADDRImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_MGMTIPADDRImpl(" + element + ")");
        this.mgmtIPAddress = OAUtil.trimAttribute(((BLADEType.MGMTIPADDR)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_SPNImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_SPNImpl(" + element + ")");
        this.spn = OAUtil.trimAttribute(((BLADEType.SPN)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_BSNImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_BSNImpl(" + element + ")");
        this.bsn = OAUtil.trimAttribute(((BLADEType.BSN)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_TYPEImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_TYPEImpl(" + element + ")");
        this.type = OAUtil.trimAttribute(((BLADEType.TYPE)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_MANUFACTURERImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_MANUFACTURERImpl(" + element + ")");
        this.manufacturer = OAUtil.trimAttribute(((BLADEType.MANUFACTURER)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_STATUSImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_STATUSImpl(" + element + ")");
        this.status = OAUtil.trimAttribute(((BLADEType.STATUS)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_UIDSTATUSImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_UIDSTATUSImpl(" + element + ")");
        this.uidStatus = OAUtil.trimAttribute(((BLADEType.UIDSTATUS)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_PORTMAPImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_PORTMAPImpl(" + element + ")");
        this.olBladePortMap.init((BLADEPortMap)element);
    }

    public void initializeINFRA2_BLADETypeImpl_UUIDImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_UUIDImpl(" + element + ")");
        this.uuid = OAUtil.trimAttribute(((BLADEType.UUID)element).getValue());
    }

    public void initializeINFRA2_BLADETypeImpl_TEMPSImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_TEMPSImpl(" + element + ")");
        this.deviceTempsType.init(((BLADEType.TEMPSType)element).getContent());
    }

    public void initializeINFRA2_BLADETypeImpl_FANSImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_FANSImpl(" + element + ")");
        BLADEType.FANSType fansType = (BLADEType.FANSType)element;
        this.deviceFansType.init(fansType.getFAN(), fansType.getREDUNDANCY());
    }

    public void initializeINFRA2_BLADETypeImpl_ASSOCIATEDBLADEImpl(Object element) {
        BladeIMELogger.log("OLBlade.initializeINFRA2_BLADETypeImpl_ASSOCIATEDBLADEImpl(" + element + ")");
        this.assocDevBay = OAUtil.trimAttribute(((BLADEType.ASSOCIATEDBLADE)element).getValue());
    }

    protected void updateDataOnDevice(MxNode deviceMxNode) {
        int assocBay;
        super.updateDataOnDevice(deviceMxNode);
        BladeIMELogger.log("OLBlade.updateDataOnDevice(" + deviceMxNode + ")");
        if (this.assocDevBay != null && this.assocDevBay.matches("\\d*") && (assocBay = Integer.parseInt(this.assocDevBay)) != 0) {
            deviceMxNode.setClientAttribute(this.BLADECLIENTATTRIBUTES[1] + this.uniqueIdentifier, this.assocDevBay);
        }
        this.olBladePortMap.update(deviceMxNode, this.uniqueIdentifier);
    }

    protected void updateDataOnEnclosure(MxNode enclosureMxNode) {
        super.updateDataOnEnclosure(enclosureMxNode);
        BladeIMELogger.log("OLBlade.updateDataOnEnclosure(" + enclosureMxNode + ")");
        enclosureMxNode.setClientAttribute(this.BLADECLIENTATTRIBUTES[0] + this.uniqueIdentifier, this.type);
        this.olBladePortMap.update(enclosureMxNode, this.uniqueIdentifier);
    }

    public void update(MxNode deviceMxNode, MxNode enclosureMxNode) {
        BladeIMELogger.log("OLBlade.update(" + deviceMxNode + "," + enclosureMxNode + ")");
        if (deviceMxNode != null) {
            try {
                BladeIMELogger.log("OLBlade.update.Cleaning device data from OLBlade uniqueIdentifier " + this.uniqueIdentifier);
                OAHelper.getOAHelper().getOLDevice(deviceMxNode, deviceMxNode).cleanDataFromDevice(deviceMxNode);
                BladeIMELogger.log("OLBlade.update.Cleaning done from OLBlade uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (OAException e) {
                BladeIMELogger.log("OLBlade.update.Unable to find old OLDevice. Cleanup failed uniqueIdentifier " + this.uniqueIdentifier);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLBlade.update.Exception " + this.uniqueIdentifier);
            }
            try {
                BladeIMELogger.log("OLBlade.update.updating device data on itself uniqueIdentifier " + this.uniqueIdentifier);
                this.updateDataOnDevice(deviceMxNode);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLBlade.update.Exception " + this.uniqueIdentifier);
            }
            OAUtil.commit(deviceMxNode);
        } else {
            try {
                BladeIMELogger.log("OLBlade.update.Cleaning device data from enclosure uniqueIdentifier " + this.uniqueIdentifier);
                this.cleanDataFromEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLBlade.update.Exception " + this.uniqueIdentifier);
            }
            try {
                BladeIMELogger.log("OLBlade.update.updating device data on enclosure node uniqueIdentifier " + this.uniqueIdentifier);
                this.updateDataOnEnclosure(enclosureMxNode);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLBlade.update.Exception " + this.uniqueIdentifier);
            }
            OAUtil.commit(enclosureMxNode);
        }
    }

    protected void cleanDataFromDevice(MxNode deviceMxNode) {
        super.cleanDataFromDevice(deviceMxNode);
        BladeIMELogger.log("OLBlade.cleanDataFromDevice(" + deviceMxNode + ")");
        this.olBladePortMap.clean(deviceMxNode, this.uniqueIdentifier);
    }

    protected void cleanDataFromEnclosure(MxNode enclosureMxNode) {
        super.cleanDataFromEnclosure(enclosureMxNode);
        BladeIMELogger.log("OLBlade.cleanDataFromEnclosure(" + enclosureMxNode + ")");
        this.olBladePortMap.clean(enclosureMxNode, this.uniqueIdentifier);
    }

    public void move(MxNode toMxNode, MxNode fromMxNode) {
        super.move(toMxNode, fromMxNode);
        BladeIMELogger.log("OLBlade.move(" + toMxNode + "," + fromMxNode + ")");
        this.olBladePortMap.move(toMxNode, fromMxNode, this.uniqueIdentifier);
        OAUtil.commit(toMxNode);
        OAUtil.commit(fromMxNode);
    }

    public void remove(MxNode enclosureMxNode) {
        super.remove(enclosureMxNode);
        BladeIMELogger.log("OLBlade.remove(" + enclosureMxNode + ")");
        for (int i = 0; i < this.BLADECLIENTATTRIBUTES.length; ++i) {
            enclosureMxNode.removeClientAttribute(this.BLADECLIENTATTRIBUTES[i] + this.uniqueIdentifier);
        }
        OAUtil.commit(enclosureMxNode);
    }

    public String getDeviceType() {
        for (int i = 0; i < OLConstants.OL_BLADE_TYPE.length; ++i) {
            if (!this.type.equalsIgnoreCase(OLConstants.OL_BLADE_TYPE[i][0])) continue;
            return OLConstants.OL_BLADE_TYPE[i][1];
        }
        return OLConstants.OL_BLADE_TYPE[0][1];
    }

    public OLBladePortMap getOLBladePortMap() {
        return this.olBladePortMap;
    }

    public List getSubTypeList() {
        ArrayList<String> subTypeList = new ArrayList<String>();
        subTypeList.add(NodeSubTypeMapper.BLADE_SUBTYPE.toString());
        subTypeList.add(NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
        subTypeList.add("HPProLiant");
        return subTypeList;
    }

    protected void validateAttributes() {
        super.validateAttributes();
        if (this.type == null || this.type.trim().length() == 0) {
            this.type = "";
        }
    }

    public MxNode getDeviceMxNode() {
        BladeIMELogger.log("OLBlade.getDeviceMxNode()");
        MxNode deviceMxNode = null;
        try {
            deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(this.uuid);
        }
        catch (MxException e) {
            BladeIMELogger.log("Unable to find Blade MxNode having uuid " + this.uuid);
        }
        return deviceMxNode;
    }

    public boolean isUniqueIdentifierExists() {
        return this.uuid != null && this.uuid.trim().length() != 0;
    }

    public String getAssociatedBay() {
        return this.assocDevBay;
    }

    protected void print(String SOURCE) {
        super.print(SOURCE);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("OLBlade.type " + this.type);
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }
}

