/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.toolmanager.filter.MxFilterOperator_t;
import com.hp.mx.core.toolmanager.filter.MxNameValueOperator;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

class OAUtil {
    private OAUtil() {
    }

    static MxNode getNodeBySerialNumber(String SERIAL_NUMBER) throws OAException {
        BladeIMELogger.log("OAUtil.getNodeBySerialNumber(" + SERIAL_NUMBER + ")");
        ArrayList filters = new ArrayList();
        ArrayList<MxNameValueOperator> currentFilter = new ArrayList<MxNameValueOperator>();
        filters.add(currentFilter);
        MxNameValueOperator namevaluePair = null;
        try {
            namevaluePair = new MxNameValueOperator("SerialNumber", MxFilterOperator_t.OPERATOR_EQ, SERIAL_NUMBER);
        }
        catch (MxException e) {
            throw new OAException(e, "There is no device matching serial number " + SERIAL_NUMBER + " MxException in OAHelper.getNodeBySerialNumber");
        }
        currentFilter.add(namevaluePair);
        List nodeList = MxNodeController.getDefaultControllerNoEx().getFilterNodes((MxTransaction)new MxCoreTransaction(), filters);
        BladeIMELogger.log("OAUtil.getNodeBySerialNumber.nodeList.size() " + nodeList.size());
        if (nodeList.size() > 0) {
            return (MxNode)nodeList.get(0);
        }
        throw new OAException("There is no device matching serial number " + SERIAL_NUMBER);
    }

    static void commit(MxNode deviceMxNode) {
        BladeIMELogger.log("OAUtil.commit(" + deviceMxNode + ")");
        try {
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceMxNode, false);
        }
        catch (MxException e) {
            BladeIMELogger.log("OAUtil.commit : MxException " + (Object)((Object)e));
        }
    }

    static String getHexString(byte[] byteArray) {
        BladeIMELogger.log("OAUtil.getHexString(" + byteArray + ")");
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer hexStringBuffer = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            char[] array = new char[]{hexDigit[byteArray[i] >> 4 & 0xF], hexDigit[byteArray[i] & 0xF]};
            hexStringBuffer.append(array);
        }
        return hexStringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static String getXMLData(MxNode oaMxNode) {
        StringBuffer xmlBuffer;
        block12: {
            BladeIMELogger.log("OAUtil.getXMLData(" + oaMxNode + ")");
            BufferedReader br = null;
            xmlBuffer = new StringBuffer();
            String workingAddress = oaMxNode.getWorkingAddress();
            BladeIMELogger.log("OAUtil.getXMLData.workingAddress " + workingAddress);
            br = new BufferedReader(new FileReader("C:\\Program Files\\HP\\Systems Insight Manager\\hpwebadmin\\webapps\\ROOT\\mxportal\\bladeime\\OA\\" + workingAddress + ".xml"));
            String line = null;
            while ((line = br.readLine()) != null) {
                xmlBuffer.append(line);
            }
            Object var6_6 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block12;
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (Exception e) {
                    BladeIMELogger.log(e, "OAUtil.Exception while reading " + workingAddress + ".xml file " + e);
                    Object var6_7 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block12;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return xmlBuffer.toString();
    }

    public static String trimAttribute(String value) {
        if (value == null || value.trim().length() == 0) {
            value = "";
        }
        return value.trim();
    }

    public static int getIntValue(String value) {
        return (value = OAUtil.trimAttribute(value)).equalsIgnoreCase("") ? -1 : Integer.parseInt(value);
    }

    public static float getFloatValue(String value) {
        return (value = OAUtil.trimAttribute(value)).equalsIgnoreCase("") ? -1.0f : Float.parseFloat(value);
    }
}

