/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.DeviceManager;
import com.hp.mx.portal.OAXml.OADataManager;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OLDevice;
import com.hp.mx.portal.OAXml.OLEnclosure;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.List;

public class OAHelper {
    private static OAHelper oaHelper = null;

    private OAHelper() {
    }

    public static OAHelper getOAHelper() {
        if (oaHelper == null) {
            oaHelper = new OAHelper();
        }
        return oaHelper;
    }

    public OLDevice getOLDevice(MxNode deviceMxNode, MxNode initFromMxNode) throws OAException {
        BladeIMELogger.log("OAHelper.getOLDevice(" + deviceMxNode + "," + initFromMxNode + ")");
        return DeviceManager.getDeviceManager().getOLDevice(deviceMxNode, initFromMxNode);
    }

    public OLEnclosure getOLEnclosure(MxNode enclosureMxNode) throws OAException {
        BladeIMELogger.log("OAHelper.getOLEnclosure(" + enclosureMxNode + ")");
        return DeviceManager.getDeviceManager().getOLEnclosure(enclosureMxNode, enclosureMxNode);
    }

    public MxNode getDeviceNodeHavingProperty(String uniqueIdentifier) throws OAException {
        BladeIMELogger.log("OAHelper.getDeviceNodeHavingProperty(" + uniqueIdentifier + ")");
        List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("UUID_" + uniqueIdentifier, uniqueIdentifier);
        BladeIMELogger.log("OAHelper.getDeviceNodeHavingProperty.allDevicesWithThisProperty " + allDevicesWithThisProperty);
        BladeIMELogger.log("OAHelper.getDeviceNodeHavingProperty.allDevicesWithThisProperty.size() " + allDevicesWithThisProperty.size());
        MxNode mxNode = null;
        for (int i = 0; i < allDevicesWithThisProperty.size(); ++i) {
            int deviceKey = (Integer)allDevicesWithThisProperty.get(i);
            BladeIMELogger.log("OAHelper.getDeviceNodeHavingProperty.deviceKey " + deviceKey);
            try {
                mxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                BladeIMELogger.log("OAHelper.getDeviceNodeHavingProperty.mxNode " + mxNode);
                BladeIMELogger.log("OAHelper.getDeviceNodeHavingProperty.mxNode.getDeviceType() " + mxNode.getDeviceType());
                return mxNode;
            }
            catch (MxException ex) {
                continue;
            }
        }
        throw new OAException("Unable to get MxNode having property " + uniqueIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData(MxNode oaMxNode) throws OAException {
        BladeIMELogger.log("OAHelper.refreshData(" + oaMxNode + ")");
        BladeIMELogger.log("OAHelper.refreshData.oaMxNode.getDeviceType() " + oaMxNode.getDeviceType());
        BladeIMELogger.log("OAHelper.refreshData.oaMxNode has OA subtype " + oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()));
        BladeIMELogger.log("OAHelper.refreshData.oaMxNode has cClass subtype " + oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString()));
        OADataManager oaDataManager = new OADataManager(oaMxNode);
        OLEnclosure olEnclosure = oaDataManager.getEnclosureDevice();
        MxNode enclosureMxNode = olEnclosure.getDeviceMxNode();
        NodeAssociations myEnclosureNodeAssociations = null;
        try {
            myEnclosureNodeAssociations = NodeAssociationsManager.getDefaultManager().getNodeAssociations(enclosureMxNode.getDeviceKey());
        }
        catch (NodeAssociationsPersistenceException e) {
            BladeIMELogger.log((Exception)((Object)e), "OAHelper.refreshData.NodeAssociationsPersistenceException " + (Object)((Object)e));
        }
        NodeAssociations nodeAssociations = myEnclosureNodeAssociations;
        synchronized (nodeAssociations) {
            olEnclosure.update(enclosureMxNode);
            this.refreshOLDevice(olEnclosure.getBladeList(), enclosureMxNode);
            this.refreshOLDevice(olEnclosure.getSwitchList(), enclosureMxNode);
            this.refreshOLDevice(olEnclosure.getOAList(), enclosureMxNode);
        }
    }

    private void refreshOLDevice(List deviceList, MxNode enclosureMxNode) {
        BladeIMELogger.log("OAHelper.refreshOLDevice(" + deviceList + "," + enclosureMxNode + ")");
        OLDevice olDevice = null;
        MxNode deviceMxNode = null;
        BladeIMELogger.log("OAHelper.refreshOLDevice.deviceList.size() " + deviceList.size());
        for (int i = 0; i < deviceList.size(); ++i) {
            olDevice = (OLDevice)deviceList.get(i);
            BladeIMELogger.log("OAHelper.refreshOLDevice.olDevice.getClass().getName() " + olDevice.getClass().getName());
            BladeIMELogger.log("OAHelper.refreshOLDevice.olDevice.getDeviceUUID() " + olDevice.getDeviceUUID());
            BladeIMELogger.log("OAHelper.refreshOLDevice.olDevice.getDeviceSerialNumber() " + olDevice.getDeviceSerialNumber());
            if (!olDevice.isUniqueIdentifierExists()) {
                BladeIMELogger.log("OAHelper.refreshOLDevice : No Unique Identifier. Skipping Node Refresh");
                continue;
            }
            deviceMxNode = olDevice.getDeviceMxNode();
            BladeIMELogger.log("OAHelper.refreshOLDevice.deviceMxNode " + deviceMxNode);
            olDevice.update(deviceMxNode, enclosureMxNode);
        }
    }

    public void refreshData(MxNode oaMxNode, int deviceKey) throws OAException {
        BladeIMELogger.log("OAHelper.refreshData(" + oaMxNode + "," + deviceKey + ")");
        OADataManager oaDataManager = new OADataManager(oaMxNode);
        OLEnclosure olEnclosure = oaDataManager.getEnclosureDevice();
        MxNode enclosureMxNode = olEnclosure.getDeviceMxNode();
        BladeIMELogger.log("OAHelper.refreshData.enclosureMxNode " + enclosureMxNode);
        try {
            this.refreshOLDevice(olEnclosure.getBladeList(), enclosureMxNode, deviceKey);
            this.refreshOLDevice(olEnclosure.getSwitchList(), enclosureMxNode, deviceKey);
        }
        catch (OAException e) {
            BladeIMELogger.log(e, "OAHelper.refreshData.OLDevice updated successfully " + e);
        }
    }

    private void refreshOLDevice(List deviceList, MxNode enclosureMxNode, int deviceKey) throws OAException {
        BladeIMELogger.log("OAHelper.refreshOLDevice(" + deviceList + "," + enclosureMxNode + "," + deviceKey + ")");
        OLDevice olDevice = null;
        MxNode deviceMxNode = null;
        for (int i = 0; i < deviceList.size(); ++i) {
            olDevice = (OLDevice)deviceList.get(i);
            BladeIMELogger.log("OAHelper.refreshOLDevice.olDevice " + olDevice);
            deviceMxNode = olDevice.getDeviceMxNode();
            BladeIMELogger.log("OAHelper.refreshOLDevice.deviceMxNode " + deviceMxNode);
            if (deviceMxNode == null) continue;
            BladeIMELogger.log("OAHelper.refreshOLDevice.deviceMxNode.getDeviceKey() " + deviceMxNode.getDeviceKey());
            if (deviceMxNode.getDeviceKey() != deviceKey) continue;
            BladeIMELogger.log("OAHelper.refreshOLDevice.Refreshing OLDevice Now " + olDevice.getClass().getName());
            olDevice.update(deviceMxNode, enclosureMxNode);
            throw new OAException("OLDevice updated successfully");
        }
    }
}

