/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.identification.mgmtproc.MgmtProcessorParser;
import com.hp.mx.portal.OAXml.JAXBCustomValidationEventHandler;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAXmlJaxb.RIMPType;
import com.hp.mx.portal.OAXml.OLEnclosure;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class OADataManager {
    private OLEnclosure olEnclosureDevice;

    public OADataManager(MxNode oaMxNode) throws OAException {
        BladeIMELogger.log("OADataManager(" + oaMxNode + ")");
        this.olEnclosureDevice = new OLEnclosure(this.processXMLData(oaMxNode));
    }

    private RIMPType processXMLData(MxNode oaMxNode) throws OAException {
        BladeIMELogger.log("OADataManager.processXMLData(" + oaMxNode + ")");
        JAXBContext jaxbContext = null;
        Unmarshaller unmarshaller = null;
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.hp.mx.portal.OAXml.OAXmlJaxb");
            BladeIMELogger.log("OADataManager.processXMLData.jaxbContext " + jaxbContext);
            unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JAXBCustomValidationEventHandler());
            BladeIMELogger.log("OADataManager.processXMLData.unmarshaller " + unmarshaller);
        }
        catch (JAXBException je) {
            BladeIMELogger.log((Exception)((Object)je), "OADataManager.processXMLData.JAXBException Unable to get jaxbContext/unmarshaller" + (Object)((Object)je));
            throw new OAException(je);
        }
        String WORKING_ADDRESS = oaMxNode.getWorkingAddress();
        BladeIMELogger.log("OADataManager.processXMLData.WORKING_ADDRESS " + WORKING_ADDRESS);
        RIMPType rimpType = null;
        try {
            rimpType = this.getRIMPType(unmarshaller, this.getURL(WORKING_ADDRESS, "https://"));
            BladeIMELogger.log("OADataManager.processXMLData.rimpType from https:// is success " + rimpType);
        }
        catch (OAException oe) {
            BladeIMELogger.log(oe, "OADataManager.processXMLData.rimpType from https:// is failed " + oe);
            try {
                rimpType = this.getRIMPType(unmarshaller, this.getURL(WORKING_ADDRESS, "http://"));
                BladeIMELogger.log("OADataManager.processXMLData.rimpType from http:// is success " + rimpType);
            }
            catch (OAException oe1) {
                BladeIMELogger.log(oe1, "OADataManager.processXMLData.rimpType from http:// is failed " + oe1);
                throw new OAException(oe1);
            }
        }
        return rimpType;
    }

    private String getURL(String WORKING_ADDRESS, String PROTOCOL) {
        BladeIMELogger.log("OADataManager.getURL(" + WORKING_ADDRESS + "," + PROTOCOL + ")");
        StringBuffer oaURL = new StringBuffer(PROTOCOL);
        oaURL.append(WORKING_ADDRESS);
        oaURL.append("/xmldata?item=all");
        return oaURL.toString();
    }

    private RIMPType getRIMPType(Unmarshaller unmarshaller, String OAURL) throws OAException {
        BladeIMELogger.log("OADataManager.getRIMPType(" + unmarshaller + "," + OAURL + ")");
        RIMPType rimpType = null;
        MgmtProcessorParser mpp = new MgmtProcessorParser();
        try {
            String oaXMLResponse = mpp.sendTheRequest(OAURL);
            BladeIMELogger.log("OADataManager.getRIMPType oaXMLResponse " + oaXMLResponse);
            if (oaXMLResponse == null) {
                throw new OAException("OA XML response is null for OAURL " + OAURL);
            }
            rimpType = (RIMPType)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(oaXMLResponse)));
            BladeIMELogger.log("OADataManager.getRIMPType success " + OAURL);
        }
        catch (JAXBException je) {
            BladeIMELogger.log("OADataManager.getRIMPType failed " + OAURL);
            throw new OAException(je);
        }
        return rimpType;
    }

    public OLEnclosure getEnclosureDevice() {
        return this.olEnclosureDevice;
    }

    public OADataManager(String xmlString) throws OAException {
        BladeIMELogger.log("OADataManager(" + xmlString + ")");
        this.olEnclosureDevice = new OLEnclosure(this.processXMLData(xmlString));
    }

    private RIMPType processXMLData(String xmlString) throws OAException {
        BladeIMELogger.log("OADataManager.processXMLData()");
        RIMPType rimpType = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.hp.mx.portal.OAXml.OAXmlJaxb");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JAXBCustomValidationEventHandler());
            rimpType = (RIMPType)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xmlString)));
            BladeIMELogger.log("OADataManager.processXMLData.rimpType " + rimpType);
        }
        catch (JAXBException je) {
            BladeIMELogger.log((Exception)((Object)je), "OADataManager.processXMLData.JAXBException " + (Object)((Object)je));
            throw new OAException(je);
        }
        return rimpType;
    }
}

