/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAUtil;
import com.hp.mx.portal.OAXml.OAXmlJaxb.TEMPType;
import com.hp.mx.portal.OAXml.OLConstants;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class DeviceTempsType {
    private List deviceTempTypeList = new ArrayList();
    private final String[] CLIENTATTRIBUTES = new String[]{"TMP_CNT_"};

    void init(MxNode deviceMxNode, String uniqueIdentifier) {
        BladeIMELogger.log("DeviceTempsType.init(" + deviceMxNode + "," + uniqueIdentifier + ")");
        try {
            int TEMP_COUNT = OAUtil.getIntValue(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier));
            BladeIMELogger.log("DeviceTempsType.init.TEMP_COUNT " + TEMP_COUNT);
            DeviceTempType deviceTempType = null;
            for (int i = 0; i < TEMP_COUNT; ++i) {
                deviceTempType = this.getDeviceTempType();
                deviceTempType.init(deviceMxNode, uniqueIdentifier, i);
                this.addDeviceTempType(deviceTempType);
            }
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "DeviceTempsType.init(DB).Unable to initialize DeviceTempType " + e);
        }
        this.print("DeviceTempsType DB");
    }

    void init(List tempList) {
        BladeIMELogger.log("DeviceTempsType.init(" + tempList + ")");
        BladeIMELogger.log("DeviceTempsType.init.tempList.size() " + tempList.size());
        this.print("DeviceTempsType JAXB");
        DeviceTempType deviceTempType = null;
        for (int i = 0; i < tempList.size(); ++i) {
            try {
                deviceTempType = this.getDeviceTempType();
                deviceTempType.init((TEMPType)tempList.get(i));
                this.addDeviceTempType(deviceTempType);
                continue;
            }
            catch (OAException e) {
                BladeIMELogger.log(e, "DeviceTempsType.init(JAXB).OAException " + e);
            }
        }
    }

    void update(MxNode mxNode, String uniqueIdentifier) {
        BladeIMELogger.log("DeviceTempsType.update(" + mxNode + "," + uniqueIdentifier + ")");
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier, String.valueOf(this.deviceTempTypeList.size()));
        for (int i = 0; i < this.deviceTempTypeList.size(); ++i) {
            ((DeviceTempType)this.deviceTempTypeList.get(i)).update(mxNode, uniqueIdentifier, i);
        }
    }

    void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("DeviceTempsType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier));
            enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        for (i = 0; i < this.deviceTempTypeList.size(); ++i) {
            ((DeviceTempType)this.deviceTempTypeList.get(i)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i);
        }
    }

    void clean(MxNode deviceMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("DeviceTempsType.clean(" + deviceMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        for (i = 0; i < this.deviceTempTypeList.size(); ++i) {
            ((DeviceTempType)this.deviceTempTypeList.get(i)).clean(deviceMxNode, uniqueIdentifier, i);
        }
    }

    private void print(String SOURCE) {
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("DeviceTempsType.deviceTempTypeList.size() " + this.deviceTempTypeList.size());
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }

    public List getDeviceTempTypeList() {
        return this.deviceTempTypeList;
    }

    private DeviceTempType getDeviceTempType() {
        return new DeviceTempType();
    }

    private void addDeviceTempType(DeviceTempType value) {
        this.deviceTempTypeList.add(value);
    }

    public class DeviceTempType {
        private String description;
        private String c;
        private List deviceThresholdList = new ArrayList();
        private String location;
        private String minC;
        private String maxC;
        private final String[] CLIENTATTRIBUTES = new String[]{"TMP_THLD_CNT_", "TMP_LOC_", "TMP_DESC_", "TMP_C_", "TMP_MNC_", "TMP_MXC_"};

        private void init(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("DeviceTempType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            this.location = OAUtil.trimAttribute(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty));
            this.description = OAUtil.trimAttribute(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty));
            this.c = OAUtil.trimAttribute(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty));
            this.minC = OAUtil.trimAttribute(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[4] + clientAttributeProperty));
            this.maxC = OAUtil.trimAttribute(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[5] + clientAttributeProperty));
            this.print("DeviceTempType DB");
            try {
                DeviceThresholdType deviceThresholdType = null;
                int TEMP_THRESHOLD_COUNT = Integer.parseInt(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty));
                BladeIMELogger.log("DeviceTempType.init.TEMP_THRESHOLD_COUNT " + TEMP_THRESHOLD_COUNT);
                for (int j = 0; j < TEMP_THRESHOLD_COUNT; ++j) {
                    deviceThresholdType = this.getDeviceThresholdType();
                    deviceThresholdType.init(deviceMxNode, uniqueIdentifier, i, j);
                    this.addThresholdType(deviceThresholdType);
                }
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "DeviceTempsType.DeviceTempType.init(DB).Unable to initialize DeviceThresholdType " + e);
            }
        }

        private void init(TEMPType tempType) throws OAException {
            BladeIMELogger.log("DeviceTempType.init(" + tempType + ")");
            try {
                this.description = OAUtil.trimAttribute(tempType.getDESC());
                if (tempType.getC() != null) {
                    this.c = OAUtil.trimAttribute(tempType.getC().toString());
                }
                if (tempType.getLOCATION() != null) {
                    this.location = OAUtil.trimAttribute(tempType.getLOCATION().toString());
                }
                if (tempType.getMIN() != null) {
                    this.minC = OAUtil.trimAttribute(tempType.getMIN().toString());
                }
                if (tempType.getMAX() != null) {
                    this.maxC = OAUtil.trimAttribute(tempType.getMAX().toString());
                }
                this.print("DeviceTempType JAXB");
                DeviceThresholdType deviceThresholdType = null;
                List tempThresholdList = tempType.getTHRESHOLD();
                if (tempThresholdList != null) {
                    BladeIMELogger.log("DeviceTempType.init.tempThresholdList.size() " + tempThresholdList.size());
                    for (int j = 0; j < tempThresholdList.size(); ++j) {
                        try {
                            deviceThresholdType = this.getDeviceThresholdType();
                            deviceThresholdType.init((TEMPType.THRESHOLDType)tempThresholdList.get(j));
                            this.addThresholdType(deviceThresholdType);
                            continue;
                        }
                        catch (OAException e) {
                            BladeIMELogger.log(e, "DeviceTempType.init.threshold exception " + e);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new OAException(e, "DeviceTempType.init(JAXB).Exception " + e);
            }
        }

        private void update(MxNode mxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("DeviceTempType.update(" + mxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, String.valueOf(this.deviceThresholdList.size()));
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.location);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, this.description);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty, this.c);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[4] + clientAttributeProperty, this.minC);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[5] + clientAttributeProperty, this.maxC);
            for (int j = 0; j < this.deviceThresholdList.size(); ++j) {
                ((DeviceThresholdType)this.deviceThresholdList.get(j)).update(mxNode, uniqueIdentifier, i, j);
            }
        }

        private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i) {
            int j;
            BladeIMELogger.log("DeviceTempType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + ")");
            StringBuffer clientAttributeProperty = null;
            for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[j]);
                clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, uniqueIdentifier));
                deviceMxNode.setClientAttribute(clientAttributeProperty.toString(), enclosureMxNode.getClientAttribute(clientAttributeProperty.toString()));
                enclosureMxNode.removeClientAttribute(clientAttributeProperty.toString());
            }
            for (j = 0; j < this.deviceThresholdList.size(); ++j) {
                ((DeviceThresholdType)this.deviceThresholdList.get(j)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i, j);
            }
        }

        private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            int j;
            BladeIMELogger.log("DeviceTempType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            StringBuffer clientAttributeProperty = null;
            for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[j]);
                clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, uniqueIdentifier));
                deviceMxNode.removeClientAttribute(clientAttributeProperty.toString());
            }
            for (j = 0; j < this.deviceThresholdList.size(); ++j) {
                ((DeviceThresholdType)this.deviceThresholdList.get(j)).clean(deviceMxNode, uniqueIdentifier, i, j);
            }
        }

        private void print(String SOURCE) {
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
            BladeIMELogger.log("DeviceTempType.description " + this.description);
            BladeIMELogger.log("DeviceTempType.c " + this.c);
            BladeIMELogger.log("DeviceTempType.location " + this.location);
            BladeIMELogger.log("DeviceTempType.minC " + this.minC);
            BladeIMELogger.log("DeviceTempType.maxC " + this.maxC);
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
        }

        private DeviceThresholdType getDeviceThresholdType() {
            return new DeviceThresholdType();
        }

        public String getDESC() {
            return this.description;
        }

        public String getC() {
            return this.c;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMINC() {
            return this.minC;
        }

        public String getMAXC() {
            return this.maxC;
        }

        public List getDeviceThreashold() {
            return this.deviceThresholdList;
        }

        private void addThresholdType(DeviceThresholdType deviceThresholdType) {
            this.deviceThresholdList.add(deviceThresholdType);
        }

        public class DeviceThresholdType {
            private String description;
            private String c;
            private String status;
            private final String[] CLIENTATTRIBUTES = new String[]{"TMP_THLD_DESC_", "TMP_THLD_C_", "TMP_THLD_ST_"};

            private void init(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("DeviceThresholdType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                this.description = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
                this.c = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty);
                this.status = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty);
                this.print("DeviceThresholdType DB");
            }

            private void init(TEMPType.THRESHOLDType tempThreshold) throws OAException {
                BladeIMELogger.log("DeviceThresholdType.init(" + tempThreshold + ")");
                try {
                    this.description = OAUtil.trimAttribute(tempThreshold.getDESC());
                    if (tempThreshold.getC() != null) {
                        this.c = OAUtil.trimAttribute(tempThreshold.getC().toString());
                    }
                    this.status = OAUtil.trimAttribute(tempThreshold.getSTATUS());
                }
                catch (Exception e) {
                    throw new OAException(e, "DeviceThresholdType.init(JAXB).Exception " + e);
                }
                this.print("DeviceThresholdType JAXB");
            }

            private void update(MxNode mxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("DeviceThresholdType.update(" + mxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.description);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.c);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, this.status);
            }

            private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("DeviceThresholdType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                StringBuffer clientAttributeProperty = null;
                for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                    clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[k]);
                    clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier));
                    deviceMxNode.setClientAttribute(clientAttributeProperty.toString(), enclosureMxNode.getClientAttribute(clientAttributeProperty.toString()));
                    enclosureMxNode.removeClientAttribute(clientAttributeProperty.toString());
                }
            }

            private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("DeviceThresholdType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                StringBuffer clientAttributeProperty = null;
                for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                    clientAttributeProperty = new StringBuffer(this.CLIENTATTRIBUTES[k]);
                    clientAttributeProperty.append(OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier));
                    deviceMxNode.removeClientAttribute(clientAttributeProperty.toString());
                }
            }

            private void print(String SOURCE) {
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
                BladeIMELogger.log("DeviceThresholdType.description " + this.description);
                BladeIMELogger.log("DeviceThresholdType.c " + this.c);
                BladeIMELogger.log("DeviceThresholdType.status " + this.status);
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
            }

            public String getDescription() {
                return this.description;
            }

            public String getStatus() {
                return this.status;
            }

            public String getC() {
                return this.c;
            }
        }
    }
}

