/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class SnmpRackMibHandler
extends RackEnclosureTopologyHandler {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private String rackName = null;
    private String rUid = null;
    private MxNode rackNode;
    private String bladeSerialNumber = null;
    private String bladeUUID = null;
    private int bladeSlot = -1;
    private int bladeHeight = -1;
    private int bladeWidth = -1;
    private int bladeDepth = -1;
    private int maxNumBlades = 0;
    private int maxNumBladesXDir = 0;
    private int maxNumBladesYDir = 1;
    private int bladeSlotsUsed = 1;
    private int bladeSlotsUsedXDir = 1;
    private int bladeSlotsUsedYDir = 1;
    private int switchesPresent = 0;
    private boolean leftSwitchPresent = false;
    private boolean rightSwitchPresent = false;
    private int switchSlot = -1;
    private String leftSwitchSerialNumber = null;
    private String rightSwitchSerialNumber = null;
    private String enclosureSerialNum = null;
    private String switchSerialNum = null;
    private Vector topology = new Vector();
    private int serverEnclosureIndex = -1;

    public abstract void getAssociationData(MxNode var1, DeviceIdentificationData var2);

    public abstract void cleanUpAssociationData(MxNode var1);

    public abstract NodeAssociations loadAssociationDataFromDb(MxNode var1);

    public abstract void setAssociationType(String var1);

    public abstract String getUIStringToDisplayInList(String var1, String var2);

    public abstract boolean shouldBeInList(String var1);

    public abstract NodeAssociations buildContainerTree(NodeAssociations var1, MxNode var2, MxNode var3);

    public SnmpRackMibHandler(MxNode d) {
        super(d);
    }

    public void getRackAttributesFromTheMib() {
        boolean endOfTable = false;
        String rackNameOID = null;
        String rUidOID = null;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.2.1.1.2[0],1.3.6.1.4.1.232.22.2.2.1.1.3[1]");
        while (!endOfTable) {
            SnmpResponseVarBind vb2;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            rackNameOID = vb.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The RACK Name OID : " + rackNameOID));
            }
            if ((vb2 = curResp.findById(1)) == null || vb2.isError()) break;
            rUidOID = vb2.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The RUID OID : " + rUidOID));
            }
            if (!rackNameOID.startsWith("1.3.6.1.4.1.232.22.2.2.1.1.2.")) break;
            this.rackName = vb.getValue();
            if (this.rackName.trim().equalsIgnoreCase("unknown")) {
                this.rackName = "";
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Rack Name for device " + this.device.getDeviceName() + " is " + this.rackName));
            }
            this.rUid = vb2.getValue();
            if (this.rUid.trim().equalsIgnoreCase("unknown")) {
                this.rUid = "";
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("RUID for device " + this.device.getDeviceName() + " is " + this.rUid));
            }
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rackNameOID, "0");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rUidOID, "1");
        }
    }

    public void getCommonEnclosureAttributesAndTopologyFromTheMib() {
        if (m_log.isEnabledFor((Priority)Level.INFO)) {
            m_log.debug((Object)"SnmpRackMibHandler.getCommonEnclosureAttributesAndTopologyFromTheMib()");
        }
        boolean endOfTable = false;
        String enclSerNoOID = null;
        String enclNameOID = null;
        String leftNgbrNameOID = null;
        String rgtNgbrNameOID = null;
        String hasSrvrBladesOID = null;
        String hasPwrBladesOID = null;
        String leftNgbrSerNoOID = null;
        String rgtNgbrSerNoOID = null;
        String enclUidOID = null;
        String leftNgbrUidOID = null;
        String rgtNgbrUidOID = null;
        String productIDOID = null;
        String productIDOIDPrev = null;
        String productIDOIDNext = null;
        String productID = null;
        String productIDleft = null;
        String productIDrgt = null;
        int counter = 0;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.1.1.1.7[0],1.3.6.1.4.1.232.22.2.3.1.1.1.9[1],1.3.6.1.4.1.232.22.2.3.1.1.1.10[2],1.3.6.1.4.1.232.22.2.3.1.1.1.11[3],1.3.6.1.4.1.232.22.2.3.1.1.1.17[4],1.3.6.1.4.1.232.22.2.3.1.1.1.18[5],1.3.6.1.4.1.232.22.2.3.1.1.1.24[6],1.3.6.1.4.1.232.22.2.3.1.1.1.25[7],1.3.6.1.4.1.232.22.2.3.1.1.1.30[8],1.3.6.1.4.1.232.22.2.3.1.1.1.31[9],1.3.6.1.4.1.232.22.2.3.1.1.1.32[10],1.3.6.1.4.1.232.22.2.3.1.1.1.27[11],1.3.6.1.4.1.232.22.2.3.1.1.1.28[12],1.3.6.1.4.1.232.22.2.3.1.1.1.29[13]");
        while (!endOfTable) {
            SnmpResponseVarBind prodIDNext;
            SnmpResponseVarBind prodIDPrev;
            SnmpResponseVarBind prodID;
            SnmpResponseVarBind vb10;
            SnmpResponseVarBind vb9;
            SnmpResponseVarBind vb8;
            SnmpResponseVarBind vb7;
            SnmpResponseVarBind vb6;
            SnmpResponseVarBind vb5;
            SnmpResponseVarBind vb4;
            SnmpResponseVarBind vb3;
            SnmpResponseVarBind vb2;
            SnmpResponseVarBind vb1;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            enclSerNoOID = vb0.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure Serial NO. OID : " + enclSerNoOID));
            }
            if ((vb1 = curResp.findById(1)) == null || vb1.isError()) break;
            enclNameOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Enclosure Name OID : " + enclNameOID));
            }
            if ((vb2 = curResp.findById(2)) == null || vb2.isError()) break;
            leftNgbrNameOID = vb2.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Left Neighbor Name OID : " + leftNgbrNameOID));
            }
            if ((vb3 = curResp.findById(3)) == null || vb3.isError()) break;
            rgtNgbrNameOID = vb3.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Right Neighbor Name OID : " + rgtNgbrNameOID));
            }
            if ((vb4 = curResp.findById(4)) == null || vb4.isError()) break;
            hasSrvrBladesOID = vb4.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The HasServerBlades OID : " + hasSrvrBladesOID));
            }
            if ((vb5 = curResp.findById(5)) == null || vb5.isError()) break;
            hasPwrBladesOID = vb5.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The HasPowerSupplyBlades OID : " + hasPwrBladesOID));
            }
            if ((vb6 = curResp.findById(6)) == null || vb6.isError()) break;
            leftNgbrSerNoOID = vb6.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Left Neighbor Serial Number OID : " + leftNgbrSerNoOID));
            }
            if ((vb7 = curResp.findById(7)) == null || vb7.isError()) break;
            rgtNgbrSerNoOID = vb7.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Right Neighbor Serial Number OID : " + rgtNgbrSerNoOID));
            }
            if ((vb8 = curResp.findById(8)) == null || vb8.isError()) break;
            enclUidOID = vb8.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Enclosure UUID OID : " + enclUidOID));
            }
            if ((vb9 = curResp.findById(9)) == null || vb9.isError()) break;
            leftNgbrUidOID = vb9.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Left Neighbor UUID OID : " + leftNgbrUidOID));
            }
            if ((vb10 = curResp.findById(10)) == null || vb10.isError()) break;
            rgtNgbrUidOID = vb10.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Right Neighbor UUID OID : " + rgtNgbrUidOID));
            }
            if ((prodID = curResp.findById(11)) == null || prodID.isError()) break;
            productIDOID = prodID.getOid();
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler. The product OID : " + productIDOID));
            }
            if ((prodIDPrev = curResp.findById(12)) == null || prodIDPrev.isError()) break;
            productIDOIDPrev = prodIDPrev.getOid();
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.  The left product OID : : " + productIDOIDPrev));
            }
            if ((prodIDNext = curResp.findById(13)) == null || prodIDNext.isError()) break;
            productIDOIDNext = prodIDNext.getOid();
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.  The Right product OID : : " + productIDOIDPrev));
            }
            if (enclSerNoOID.startsWith("1.3.6.1.4.1.232.22.2.3.1.1.1.7.")) {
                String enclRgtUuid;
                String enclLeftUuid;
                int val;
                String enclosureName;
                Vector<String> tplgy = new Vector<String>();
                String enclosureUuid = vb8.getValue();
                if (enclosureUuid != null && enclosureUuid.trim().length() > 0 && enclosureUuid.trim().length() >= 10 && !enclosureUuid.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureUuid);
                } else {
                    tplgy.add("");
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Enclosure Serial NUmber/Uuid for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(0)));
                }
                if ((enclosureName = vb1.getValue()) != null && !enclosureName.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(vb1.getValue());
                } else {
                    tplgy.add("");
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Enclosure Name for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(1)));
                }
                tplgy.add(vb2.getValue());
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Left Neighbor Name for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(2)));
                }
                tplgy.add(vb3.getValue());
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Right Neighbor Name for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(3)));
                }
                if ((val = vb4.getIntValue()) == 1) {
                    tplgy.add("false");
                } else {
                    tplgy.add("true");
                    this.serverEnclosureIndex = counter;
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("SERVER ENCLOSURE INDEX :  " + this.serverEnclosureIndex));
                    }
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Has Server Blades value  for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(4)));
                }
                if ((val = vb5.getIntValue()) == 2) {
                    tplgy.add("true");
                } else {
                    tplgy.add("false");
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Has Power Supply blades value for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(5)));
                }
                if ((enclLeftUuid = vb9.getValue()) != null && enclLeftUuid.trim().length() > 0 && enclLeftUuid.trim().length() >= 10) {
                    tplgy.add(enclLeftUuid);
                } else {
                    tplgy.add("");
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Left Neighbor UUID for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(6)));
                }
                if ((enclRgtUuid = vb10.getValue()) != null && enclRgtUuid.trim().length() > 0 && enclRgtUuid.trim().length() >= 10) {
                    tplgy.add(enclRgtUuid);
                } else {
                    tplgy.add("");
                }
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Right Neighbor UUID for device " + this.device.getDeviceName() + " is " + tplgy.elementAt(7)));
                }
                String enclSerNo = vb0.getValue();
                String leftSerNo = vb6.getValue();
                String rgtSerNo = vb7.getValue();
                productID = prodID.getValue();
                productIDleft = prodIDPrev.getValue();
                productIDrgt = prodIDNext.getValue();
                if (enclSerNo != null && !enclSerNo.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclSerNo);
                    if (Integer.parseInt(productID) != 0) {
                        this.prodIdList.put(enclSerNo, productID);
                    }
                } else {
                    tplgy.add("");
                }
                if (leftSerNo != null) {
                    tplgy.add(leftSerNo);
                    if (Integer.parseInt(productIDleft) != 0) {
                        this.prodIdList.put(leftSerNo, productIDleft);
                    }
                } else {
                    tplgy.add("");
                }
                if (rgtSerNo != null) {
                    tplgy.add(rgtSerNo);
                    if (Integer.parseInt(productIDrgt) != 0) {
                        this.prodIdList.put(rgtSerNo, productIDrgt);
                    }
                } else {
                    tplgy.add("");
                }
                this.topology.add(tplgy);
                ++counter;
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclSerNoOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclNameOID, "1");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(leftNgbrNameOID, "2");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rgtNgbrNameOID, "3");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(hasSrvrBladesOID, "4");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(hasPwrBladesOID, "5");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(leftNgbrSerNoOID, "6");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rgtNgbrSerNoOID, "7");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclUidOID, "8");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(leftNgbrUidOID, "9");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(rgtNgbrUidOID, "10");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(productIDOID, "11");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(productIDOIDPrev, "12");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(productIDOIDNext, "13");
                continue;
            }
            containerDeviceDebug.log(10, "enclosure serial number oid was not correct" + enclSerNoOID);
            break;
        }
    }

    public void getCommonEnclosureAttributesAndTopologyFromTheSANMib() {
        if (m_log.isEnabledFor((Priority)Level.INFO)) {
            m_log.debug((Object)"SnmpRackMibHandler.getCommonEnclosureAttributesAndTopologyFromTheSANMib()");
        }
        boolean endOfTable = false;
        String enclosureSerialNumberOID = null;
        String enclosureNameOID = null;
        int counter = 0;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.1.1.1.7[0],1.3.6.1.4.1.232.22.2.3.1.1.1.9[1]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse snmpResponse = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind cpqRackCommonEnclosureSerialNumVB = snmpResponse.findById(0);
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.cpqRackCommonEnclosureSerialNumVB " + cpqRackCommonEnclosureSerialNumVB));
                m_log.debug((Object)("SnmpRackMibHandler.cpqRackCommonEnclosureSerialNumVB.isError() " + cpqRackCommonEnclosureSerialNumVB.isError()));
            }
            if (cpqRackCommonEnclosureSerialNumVB == null || cpqRackCommonEnclosureSerialNumVB.isError()) break;
            enclosureSerialNumberOID = cpqRackCommonEnclosureSerialNumVB.getOid();
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.enclosureSerialNumberOID " + enclosureSerialNumberOID));
            }
            SnmpResponseVarBind cpqRackCommonEnclosureNameVB = snmpResponse.findById(1);
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.cpqRackCommonEnclosureNameVB " + cpqRackCommonEnclosureNameVB));
                m_log.debug((Object)("SnmpRackMibHandler.cpqRackCommonEnclosureNameVB.isError() " + cpqRackCommonEnclosureNameVB.isError()));
            }
            if (cpqRackCommonEnclosureNameVB == null || cpqRackCommonEnclosureNameVB.isError()) break;
            enclosureNameOID = cpqRackCommonEnclosureNameVB.getOid();
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.enclosureNameOID " + enclosureNameOID));
            }
            if (enclosureSerialNumberOID.startsWith("1.3.6.1.4.1.232.22.2.3.1.1.1.7.")) {
                Vector<String> tplgy = new Vector<String>();
                tplgy.add("");
                String enclosureName = cpqRackCommonEnclosureNameVB.getValue();
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("SnmpRackMibHandler.enclosureName " + enclosureName));
                }
                if (enclosureName != null && !enclosureName.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureName);
                } else {
                    tplgy.add("");
                }
                tplgy.add("");
                tplgy.add("");
                tplgy.add("true");
                tplgy.add("false");
                tplgy.add("");
                tplgy.add("");
                String enclosureSerialNumber = cpqRackCommonEnclosureSerialNumVB.getValue();
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("SnmpRackMibHandler.enclosureSerialNumber " + enclosureSerialNumber));
                }
                if (enclosureSerialNumber != null && !enclosureSerialNumber.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureSerialNumber);
                } else {
                    tplgy.add("");
                }
                tplgy.add("");
                tplgy.add("");
                this.topology.add(tplgy);
                ++counter;
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclosureSerialNumberOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclosureNameOID, "1");
                continue;
            }
            if (!m_log.isEnabledFor((Priority)Level.DEBUG)) break;
            m_log.debug((Object)("SnmpRackMibHandler.enclosure serial number oid was not correct " + enclosureSerialNumberOID));
            break;
        }
    }

    public void getServerEnclosureAttributesFromTheMib() {
        m_log.debug((Object)" SNMPRACKHAndler :getServerEnclosureAttributesFromTheMib");
        boolean endOfTable = false;
        String maxNumBladesOID = null;
        String maxNumBladesInXDirOID = null;
        String maxNumBladesInYDirOID = null;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.2.1.1.4[0],1.3.6.1.4.1.232.22.2.3.2.1.1.5[1],1.3.6.1.4.1.232.22.2.3.2.1.1.6[2]");
        while (!endOfTable) {
            SnmpResponseVarBind vb3;
            SnmpResponseVarBind vb2;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb1 = curResp.findById(0);
            if (vb1 == null || vb1.isError()) break;
            maxNumBladesOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure Max NUM Blades OID : " + maxNumBladesOID));
            }
            if ((vb2 = curResp.findById(1)) == null || vb2.isError()) break;
            maxNumBladesInXDirOID = vb2.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure Max NUM Blades in the X Direction OID : " + maxNumBladesInXDirOID));
            }
            if ((vb3 = curResp.findById(2)) == null || vb3.isError()) break;
            maxNumBladesInYDirOID = vb3.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure Max NUM Blades in the Y Direction OID : " + maxNumBladesInYDirOID));
            }
            if (!maxNumBladesOID.startsWith("1.3.6.1.4.1.232.22.2.3.2.1.1.4.")) break;
            this.maxNumBlades = vb1.getIntValue();
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Enclosure Maximum Number of Blades for device " + this.device.getDeviceName() + " is " + this.maxNumBlades));
            }
            if (maxNumBladesInXDirOID.startsWith("1.3.6.1.4.1.232.22.2.3.2.1.1.5.")) {
                this.maxNumBladesXDir = vb2.getIntValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Enclosure Maximum Number of Blades in X DIR for device " + this.device.getDeviceName() + " is " + this.maxNumBladesXDir));
                }
            } else {
                this.maxNumBladesXDir = 0;
            }
            if (maxNumBladesInYDirOID.startsWith("1.3.6.1.4.1.232.22.2.3.2.1.1.6.")) {
                this.maxNumBladesYDir = vb3.getIntValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Enclosure Maximum Number of Blades in Y DIR for device " + this.device.getDeviceName() + " is " + this.maxNumBladesYDir));
                }
            } else {
                this.maxNumBladesYDir = 1;
            }
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(maxNumBladesOID, "0");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(maxNumBladesInXDirOID, "1");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(maxNumBladesInYDirOID, "2");
        }
    }

    public void getServerBladeAttributesFromTheMib(boolean getSerialNumber, String theSerialNumber) {
        m_log.debug((Object)"getServerBladeAttributesFromTheMib");
        boolean endOfTable = false;
        String bladeSerialNumberOID = null;
        String bladeSlotOID = null;
        String bladeWidthOID = null;
        String bladeDepthOID = null;
        String bladeHeightOID = null;
        String bladeSlotsUsedOID = null;
        String bladeUUIDOID = null;
        String bladeSlotsUsedXDirOID = null;
        String bladeSlotsUsedYDirOID = null;
        boolean thisIsTheOne = true;
        SnmpResponseVarBind vb6 = null;
        SnmpResponseVarBind vb9 = null;
        StringBuffer sb = new StringBuffer();
        if (!getSerialNumber) {
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.8[0],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.9[1],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.10[2],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.11[3],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.15[4],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.19[5],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.20[6]");
        } else {
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.8[0],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.9[1],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.10[2],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.11[3],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.15[4],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.19[5],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.20[6],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.16[7],");
            sb.append("1.3.6.1.4.1.232.22.2.4.1.1.1.18[8]");
        }
        this.snmpPdh.getSnmpRequest().setAsn1Numbers(sb.toString());
        while (!endOfTable) {
            SnmpResponseVarBind vb8;
            SnmpResponseVarBind vb7;
            SnmpResponseVarBind vb5;
            SnmpResponseVarBind vb4;
            SnmpResponseVarBind vb3;
            SnmpResponseVarBind vb2;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            bladeSlotOID = vb.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Blade Slot OID : " + bladeSlotOID));
            }
            if ((vb2 = curResp.findById(1)) == null || vb2.isError()) break;
            bladeHeightOID = vb2.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Blade Height OID : " + bladeHeightOID));
            }
            if ((vb3 = curResp.findById(2)) == null || vb3.isError()) break;
            bladeWidthOID = vb3.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Blade Width OID : " + bladeWidthOID));
            }
            if ((vb4 = curResp.findById(3)) == null || vb4.isError()) break;
            bladeDepthOID = vb4.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The Blade Depth OID : " + bladeDepthOID));
            }
            if ((vb5 = curResp.findById(4)) == null || vb5.isError()) break;
            bladeSlotsUsedOID = vb5.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" Number of Blade Slots Used OID : " + bladeSlotsUsedOID));
            }
            if ((vb7 = curResp.findById(5)) == null || vb7.isError()) break;
            bladeSlotsUsedXDirOID = vb7.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" Number of Blade Slots Used in the X Direction OID : " + bladeSlotsUsedXDirOID));
            }
            if ((vb8 = curResp.findById(6)) == null || vb8.isError()) break;
            bladeSlotsUsedYDirOID = vb8.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" Number of Blade Slots Used in the Y Direction OID : " + bladeSlotsUsedYDirOID));
            }
            if (getSerialNumber) {
                vb6 = curResp.findById(7);
                if (vb6 == null || vb6.isError()) break;
                bladeSerialNumberOID = vb6.getOid();
                if (containerDeviceDebug.check(45)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Blade SerialNumber OID : " + bladeSerialNumberOID));
                }
                if ((vb9 = curResp.findById(8)) == null || vb9.isError()) break;
                bladeUUIDOID = vb9.getOid();
                if (containerDeviceDebug.check(45)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Blade UUID OID : " + bladeUUIDOID));
                }
            }
            if (!bladeSlotOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.8.")) break;
            if (getSerialNumber) {
                this.bladeUUID = vb9.getValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("\n\nBLADE UUID from MIB " + this.device.getDeviceName() + "  is '" + this.bladeUUID.trim() + "'"));
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("UUID for actual blade server " + this.device.getDeviceName() + " is '" + this.device.getAgentUUID() + "'"));
                }
                this.bladeSerialNumber = vb6.getValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("\n\nBLADE Ser NUm for device " + this.device.getDeviceName() + "  is '" + this.bladeSerialNumber.trim() + "'"));
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Server Ser NUm for device " + this.device.getDeviceName() + " is '" + theSerialNumber.trim() + "'"));
                }
                boolean isHaloBlade = this.bladeSerialNumber.trim().equalsIgnoreCase(theSerialNumber.trim());
                if (this.bladeUUID != null && this.bladeUUID.trim().length() > 0 && this.device.getAgentUUID().trim().length() > 0) {
                    isHaloBlade = this.bladeUUID.trim().equalsIgnoreCase(this.device.getAgentUUID().trim());
                }
                if (isHaloBlade) {
                    int tempVal;
                    this.bladeSlot = vb.getIntValue();
                    m_log.debug((Object)("bladeSlot:" + this.bladeSlot));
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("BLADE Slot for device " + this.device.getDeviceName() + " is " + this.bladeSlot));
                    }
                    this.bladeHeight = vb2.getIntValue();
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Height for device " + this.device.getDeviceName() + " is " + this.bladeHeight));
                    }
                    this.bladeWidth = vb3.getIntValue();
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Width for device " + this.device.getDeviceName() + " is " + this.bladeWidth));
                    }
                    this.bladeDepth = vb4.getIntValue();
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Depth for device " + this.device.getDeviceName() + " is " + this.bladeDepth));
                    }
                    this.bladeSlotsUsed = vb5.getIntValue();
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Slots Used for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsed));
                    if (bladeSlotsUsedXDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.19")) {
                        tempVal = vb7.getIntValue();
                        if (tempVal != -1 || tempVal != 0) {
                            this.bladeSlotsUsedXDir = tempVal;
                        }
                        m_log.debug((Object)("Blade Slots Used X DIR for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedXDir));
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Slots Used X DIR for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedXDir));
                    } else {
                        this.bladeSlotsUsedXDir = 1;
                    }
                    if (bladeSlotsUsedYDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.20")) {
                        tempVal = vb8.getIntValue();
                        if (tempVal != -1 || tempVal != 0) {
                            this.bladeSlotsUsedYDir = tempVal;
                        }
                        m_log.debug((Object)("Blade Slots Used Y Dir for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedYDir));
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Slots Used Y Dir for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedYDir));
                    } else {
                        this.bladeSlotsUsedYDir = 1;
                    }
                    endOfTable = true;
                    continue;
                }
            } else {
                int tempVal;
                this.bladeSlot = vb.getIntValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("BLADE Slot for device " + this.device.getDeviceName() + " is " + this.bladeSlot));
                }
                this.bladeHeight = vb2.getIntValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Height for device " + this.device.getDeviceName() + " is " + this.bladeHeight));
                }
                this.bladeWidth = vb3.getIntValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Width for device " + this.device.getDeviceName() + " is " + this.bladeWidth));
                }
                this.bladeDepth = vb4.getIntValue();
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Depth for device " + this.device.getDeviceName() + " is " + this.bladeDepth));
                }
                this.bladeSlotsUsed = vb5.getIntValue();
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Slots Used for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsed));
                if (bladeSlotsUsedXDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.19")) {
                    tempVal = vb7.getIntValue();
                    if (tempVal != -1 || tempVal != 0) {
                        this.bladeSlotsUsedXDir = tempVal;
                    }
                    m_log.debug((Object)("Blade Slots Used X DIR for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedXDir));
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Slots Used X DIR for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedXDir));
                }
                if (bladeSlotsUsedYDirOID.startsWith("1.3.6.1.4.1.232.22.2.4.1.1.1.20")) {
                    tempVal = vb8.getIntValue();
                    if (tempVal != -1 || tempVal != 0) {
                        this.bladeSlotsUsedYDir = tempVal;
                    }
                    m_log.debug((Object)("Blade Slots Used Y Dir for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedYDir));
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Blade Slots Used Y Dir for device " + this.device.getDeviceName() + " is " + this.bladeSlotsUsedYDir));
                }
                endOfTable = true;
                continue;
            }
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotOID, "0");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeHeightOID, "1");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeWidthOID, "2");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeDepthOID, "3");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotsUsedOID, "4");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotsUsedXDirOID, "5");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSlotsUsedYDirOID, "6");
            if (!getSerialNumber) continue;
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeSerialNumberOID, "7");
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(bladeUUIDOID, "8");
        }
    }

    public void getSwitchAttributesFromTheMib() {
        boolean endOfTable = false;
        String switchesPresentOID = null;
        String switchesLocationOID = null;
        String swserialNumberOID = null;
        Vector sp = new Vector();
        String cpqRacknetConnectorIndexOID = null;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.6.1.1.1.12[0],1.3.6.1.4.1.232.22.2.6.1.1.1.13[1],1.3.6.1.4.1.232.22.2.6.1.1.1.3[2],1.3.6.1.4.1.232.22.2.6.1.1.1.7[3]");
        while (!endOfTable) {
            SnmpResponseVarBind vb3;
            SnmpResponseVarBind vb1;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            switchesLocationOID = vb.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure - Switches Location OID : " + switchesLocationOID));
            }
            if ((vb1 = curResp.findById(1)) == null || vb1.isError()) break;
            switchesPresentOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure - Switches Present OID : " + switchesPresentOID));
            }
            if ((vb3 = curResp.findById(3)) == null || vb3.isError()) break;
            swserialNumberOID = vb3.getOid();
            if (!switchesLocationOID.startsWith("1.3.6.1.4.1.232.22.2.6.1.1.1.12.")) break;
            String temp = vb.getValue().trim();
            if (temp.equalsIgnoreCase("A") || temp.equalsIgnoreCase("Left Side") || temp.equalsIgnoreCase("Network Side A")) {
                if (vb1.getIntValue() == 3) {
                    this.leftSwitchSerialNumber = vb3.getValue();
                    this.leftSwitchPresent = true;
                    this.switchSlot = 0;
                }
            } else if ((temp.equalsIgnoreCase("B") || temp.equalsIgnoreCase("Right Side") || temp.equalsIgnoreCase("Network Side B")) && vb1.getIntValue() == 3) {
                this.rightSwitchSerialNumber = vb3.getValue();
                this.rightSwitchPresent = true;
                this.switchSlot = 9999;
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Switches Present for device " + this.device.getDeviceName() + " is left " + this.leftSwitchPresent + " and right " + this.rightSwitchPresent));
            }
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.temp " + temp));
            }
            if (temp.equalsIgnoreCase("Upper Cube")) {
                SnmpResponseVarBind cpqRacknetConnectorIndexVB = curResp.findById(2);
                if (cpqRacknetConnectorIndexVB == null || cpqRacknetConnectorIndexVB.isError()) break;
                cpqRacknetConnectorIndexOID = cpqRacknetConnectorIndexVB.getOid();
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("SnmpRackMibHandler.cpqRacknetConnectorIndexOID " + cpqRacknetConnectorIndexOID));
                }
                int DUKES_LOCATION = cpqRacknetConnectorIndexVB.getIntValue();
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("SnmpRackMibHandler.DUKES_LOCATION " + DUKES_LOCATION));
                    m_log.debug((Object)("SnmpRackMibHandler.vb1.getIntValue() " + vb1.getIntValue()));
                }
                if (vb1.getIntValue() == 3) {
                    if (DUKES_LOCATION == 1) {
                        this.rightSwitchSerialNumber = vb3.getValue();
                        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                            m_log.debug((Object)("Dukes.rightSwitchSerialNumber " + this.rightSwitchSerialNumber));
                        }
                        this.switchSlot = 9999;
                    } else if (DUKES_LOCATION == 2) {
                        this.leftSwitchSerialNumber = vb3.getValue();
                        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                            m_log.debug((Object)("Dukes.leftSwitchSerialNumber " + this.leftSwitchSerialNumber));
                        }
                        this.switchSlot = 0;
                    }
                }
            }
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("SnmpRackMibHandler.switchSlot " + this.switchSlot));
            }
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(switchesPresentOID, "0");
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Left Switch  : " + this.leftSwitchPresent));
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Right Switch  : " + this.rightSwitchPresent));
    }

    public void getEClassSwitchAttributesFromMib() {
        boolean endOfTable = false;
        String enclSerNoOID = null;
        String switchConnectorIndexOID = null;
        String switchSerNoOID = null;
        String switchModelOID = null;
        boolean counter = false;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.6.1.1.1.3[0],1.3.6.1.4.1.232.22.2.6.1.1.1.6[1],1.3.6.1.4.1.232.22.2.6.1.1.1.7[2],1.3.6.1.4.1.232.22.2.6.1.1.1.15[3]");
        while (!endOfTable) {
            SnmpResponseVarBind vb3;
            SnmpResponseVarBind vb2;
            SnmpResponseVarBind vb1;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            switchConnectorIndexOID = vb0.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The switchConnectorIndexOID : " + switchConnectorIndexOID));
            }
            if ((vb1 = curResp.findById(1)) == null || vb1.isError()) break;
            switchModelOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The  switchModelOID : " + switchModelOID));
            }
            if ((vb2 = curResp.findById(2)) == null || vb2.isError()) break;
            switchSerNoOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The  switchSerNoOID : " + switchSerNoOID));
            }
            if ((vb3 = curResp.findById(3)) == null || vb3.isError()) break;
            enclSerNoOID = vb3.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The  enclSerNoOID : " + enclSerNoOID));
            }
            if (enclSerNoOID.startsWith("1.3.6.1.4.1.232.22.2.6.1.1.1.15.")) {
                String switchConnectorIndex;
                String enclSerialNumber = vb3.getValue();
                if (enclSerialNumber != null && enclSerialNumber.trim().length() > 0 && !enclSerialNumber.trim().equalsIgnoreCase("unknown")) {
                    this.enclosureSerialNum = enclSerialNumber;
                }
                if (vb2.getValue() != null && vb2.getValue().trim().length() > 0 && !vb2.getValue().trim().equalsIgnoreCase("unknown")) {
                    this.switchSerialNum = vb2.getValue();
                }
                if ((switchConnectorIndex = vb0.getValue()) != null) {
                    this.switchesPresent = 1;
                }
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(switchConnectorIndexOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(switchModelOID, "1");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(switchSerNoOID, "2");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclSerNoOID, "3");
                continue;
            }
            containerDeviceDebug.log(10, "enclosure serial number oid was not correct" + enclSerNoOID);
            break;
        }
    }

    public Vector getCommonEnclosureFanDetails() {
        if (m_log.isEnabledFor((Priority)Level.INFO)) {
            m_log.debug((Object)"SnmpRackMibHandler.getCommonEnclosureFanDetails()");
        }
        boolean endOfTable = false;
        String enclSerNoOID = null;
        String fanIndexOID = null;
        String fanLocationOID = null;
        String fanRedundantOID = null;
        String fanPresentOID = null;
        Vector FanDetails = new Vector();
        int counter = 0;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.1.3.1.3[0],1.3.6.1.4.1.232.22.2.3.1.3.1.5[1],1.3.6.1.4.1.232.22.2.3.1.3.1.8[2],1.3.6.1.4.1.232.22.2.3.1.3.1.9[3],1.3.6.1.4.1.232.22.2.3.1.3.1.12[4]");
        while (!endOfTable) {
            SnmpResponseVarBind vb4;
            SnmpResponseVarBind vb3;
            SnmpResponseVarBind vb2;
            SnmpResponseVarBind vb1;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            fanIndexOID = vb0.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Fan Idex . OID : " + fanIndexOID));
            }
            if ((vb1 = curResp.findById(1)) == null || vb1.isError()) break;
            fanLocationOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The fanLocationOID : " + fanLocationOID));
            }
            if ((vb2 = curResp.findById(2)) == null || vb2.isError()) break;
            fanPresentOID = vb2.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" ThefanPresentOID : " + fanPresentOID));
            }
            if ((vb3 = curResp.findById(3)) == null || vb3.isError()) break;
            fanRedundantOID = vb3.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The fanRedundantOID : " + fanRedundantOID));
            }
            if ((vb4 = curResp.findById(4)) == null || vb4.isError()) break;
            enclSerNoOID = vb4.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The enclSerNoOID : " + enclSerNoOID));
            }
            if (enclSerNoOID.startsWith("1.3.6.1.4.1.232.22.2.3.1.3.1.12.")) {
                Vector<String> tplgy = new Vector<String>();
                String enclosureSerialNumber = vb4.getValue();
                if (enclosureSerialNumber != null && enclosureSerialNumber.trim().length() > 0 && !enclosureSerialNumber.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureSerialNumber);
                } else {
                    tplgy.add("");
                }
                String fanIndex = vb0.getValue();
                if (fanIndex != null) {
                    tplgy.add(fanIndex);
                } else {
                    tplgy.add("");
                }
                String fanLocation = vb1.getValue();
                if (fanLocation != null) {
                    tplgy.add(fanLocation);
                } else {
                    tplgy.add("");
                }
                String fanPresent = vb2.getValue();
                if (fanPresent != null) {
                    tplgy.add(fanPresent);
                } else {
                    tplgy.add("");
                }
                String fanRedundant = vb3.getValue();
                if (fanRedundant != null) {
                    tplgy.add(fanRedundant);
                } else {
                    tplgy.add("");
                }
                FanDetails.add(tplgy);
                ++counter;
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(fanIndexOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(fanLocationOID, "1");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(fanPresentOID, "2");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(fanRedundantOID, "3");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclSerNoOID, "4");
                continue;
            }
            containerDeviceDebug.log(10, "enclosure serial number oid was not correct" + enclSerNoOID);
            break;
        }
        return FanDetails;
    }

    public Vector getRackPowerSupplyDetails() {
        if (m_log.isEnabledFor((Priority)Level.INFO)) {
            m_log.debug((Object)"SnmpRackMibHandler.getRackPowerSupplyDetails()");
        }
        boolean endOfTable = false;
        String enclSerNoOID = null;
        String powerSupplyIndexOID = null;
        String powerSupplySerialNumOID = null;
        String powerSupplyPosOID = null;
        Vector powerSupplyDetails = new Vector();
        int counter = 0;
        Vector PowerDetails = new Vector();
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.5.1.1.1.3[0],1.3.6.1.4.1.232.22.2.5.1.1.1.5[1],1.3.6.1.4.1.232.22.2.5.1.1.1.11[2],1.3.6.1.4.1.232.22.2.5.1.1.1.18[3]");
        while (!endOfTable) {
            SnmpResponseVarBind vb3;
            SnmpResponseVarBind vb2;
            SnmpResponseVarBind vb1;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            powerSupplyIndexOID = vb0.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The powerSupplyIndexOID : " + powerSupplyIndexOID));
            }
            if ((vb1 = curResp.findById(1)) == null || vb1.isError()) break;
            powerSupplySerialNumOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The powerSupplySerialNumOID : " + powerSupplySerialNumOID));
            }
            if ((vb2 = curResp.findById(2)) == null || vb2.isError()) break;
            powerSupplyPosOID = vb2.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" powerSupplyPosOID: " + powerSupplyPosOID));
            }
            if ((vb3 = curResp.findById(3)) == null || vb3.isError()) break;
            enclSerNoOID = vb3.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)(" The enclSerNoOID: " + enclSerNoOID));
            }
            if (enclSerNoOID.startsWith("1.3.6.1.4.1.232.22.2.5.1.1.1.18.")) {
                Vector<String> tplgy = new Vector<String>();
                String enclosureSerialNumber = vb3.getValue();
                if (enclosureSerialNumber != null && enclosureSerialNumber.trim().length() > 0 && !enclosureSerialNumber.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureSerialNumber);
                } else {
                    tplgy.add("");
                }
                String powerSupplyIndex = vb0.getValue();
                if (powerSupplyIndex != null) {
                    tplgy.add(powerSupplyIndex);
                } else {
                    tplgy.add("");
                }
                String powerSupplySerialNum = vb1.getValue();
                if (powerSupplySerialNum != null) {
                    tplgy.add(powerSupplySerialNum);
                } else {
                    tplgy.add("");
                }
                String powerSupplyPos = vb2.getValue();
                if (powerSupplyPos != null) {
                    tplgy.add(powerSupplyPos);
                } else {
                    tplgy.add("");
                }
                PowerDetails.add(tplgy);
                ++counter;
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyIndexOID, "0");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplySerialNumOID, "1");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyPosOID, "2");
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclSerNoOID, "3");
                continue;
            }
            containerDeviceDebug.log(10, "enclosure serial number oid was not correct" + enclSerNoOID);
            break;
        }
        return PowerDetails;
    }

    public String getEnclosureSerialNum() {
        return this.enclosureSerialNum;
    }

    public String getSwitchSerialNum() {
        return this.switchSerialNum;
    }

    public String getRackName() {
        return this.rackName;
    }

    public String getRuid() {
        return this.rUid;
    }

    public MxNode getRack() {
        return this.rackNode;
    }

    public int getMaxNumBlades() {
        return this.maxNumBlades;
    }

    public int getMaxNumBladesXDir() {
        return this.maxNumBladesXDir;
    }

    public int getMaxNumBladesYDir() {
        return this.maxNumBladesYDir;
    }

    public Vector getContainerEnclosureInformation() {
        if (this.topology != null && this.topology.size() != 0) {
            return (Vector)this.topology.get(0);
        }
        return null;
    }

    public int getSwitchesPresent() {
        return this.switchesPresent;
    }

    public boolean getLeftSwitchPresent() {
        return this.leftSwitchPresent;
    }

    public boolean getRightSwitchPresent() {
        return this.rightSwitchPresent;
    }

    public int getSwitchSlot() {
        return this.switchSlot;
    }

    public String getLeftSwitchSerialNumber() {
        return this.leftSwitchSerialNumber;
    }

    public String getRightSwitchSerialNumber() {
        return this.rightSwitchSerialNumber;
    }

    public int getBladeSlot() {
        return this.bladeSlot;
    }

    public int getBladeHeight() {
        return this.bladeHeight;
    }

    public int getBladeWidth() {
        return this.bladeWidth;
    }

    public int getBladeDepth() {
        return this.bladeDepth;
    }

    public int getBladeSlotsUsed() {
        return this.bladeSlotsUsed;
    }

    public int getBladeSlotsUsedXDir() {
        return this.bladeSlotsUsedXDir;
    }

    public int getBladeSlotsUsedYDir() {
        return this.bladeSlotsUsedYDir;
    }

    public int getServerEnclosureIndex() {
        return this.serverEnclosureIndex;
    }

    public Vector getTopology() {
        return this.topology;
    }

    public void createTopologyToStoreTopologyInfo(MxNode enclNode) {
    }
}

