/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.DeviceAssociationObject;
import com.hp.mx.core.nodemanager.MxDuplicateNodeException;
import com.hp.mx.core.nodemanager.MxInvalidIPAddressException;
import com.hp.mx.core.nodemanager.MxInvalidNodeNameException;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.querymanager.criteria.DeviceByRackDataObject;
import com.hp.mx.core.querymanager.criteria.RackEnclosureObject;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.BaseNodeRelationshipHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class RackEnclosureTopologyHandler
extends BaseNodeRelationshipHandler {
    private MxNode theRackDevice;
    private static final int BOGUS_DEVKEY = -1;
    private static final int NEITHER_NEIGHBOR_EMPTY = 1;
    private static final int BOTTOM_NEIGHBOR_EMPTY = 2;
    private static final int TOP_NEIGHBOR_EMPTY = 3;
    protected HashMap prodIdList = new HashMap();
    private boolean hasTopologyChanged = false;
    private String useThisIdForNamingEnclosures = "";
    private static Integer syncEnclAdds = new Integer(0);
    private static Integer syncRackMoves = new Integer(1);
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private static final DebugSubsystem debugOutput = new DebugSubsystem(RackEnclosureTopologyHandler.class);
    public static DebugSubsystem rackTopologyDebug = DebugOutput.getDebugSubsystem((String)"ServerSideRackTopology", (String)"Turn this on to 20 to see simple container information - level 40 or more to see more detailed container information");

    public void getAssociationData(MxNode device, DeviceIdentificationData idInfo) {
    }

    public void cleanUpAssociationData(MxNode device) {
    }

    public void setAssociationType(String associationType) {
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode theDevice) {
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int deviceDbKey = theDevice.getDeviceKey();
        NodeAssociations tempNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
        try {
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    if (!associationTypeNumber.equalsIgnoreCase("EnclosureToRack")) continue;
                    MxNode dev1 = null;
                    if (deviceKey1 == deviceDbKey) {
                        dev1 = theDevice;
                    } else {
                        try {
                            dev1 = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey1);
                        }
                        catch (MxUndefinedNodeException ex) {
                            dev1 = null;
                        }
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("load assn for " + deviceDbKey + " k1 " + deviceKey1 + " k2 " + deviceKey2 + " dev1 " + dev1));
                    if (dev1 == null || !dev1.getDeviceType().equals("Enclosure")) continue;
                    if (deviceKey1 == deviceDbKey) {
                        tempNodeAssociations.setInContainer(true);
                        tempNodeAssociations.initializeTopologyTree();
                        tempNodeAssociations.setParent(deviceKey2);
                        tempNodeAssociations.setTheAssociation(deviceKey1, deviceKey2, "EnclosureToRack", false);
                        continue;
                    }
                    if (deviceKey2 != deviceDbKey) continue;
                    tempNodeAssociations.initializeTopologyTree();
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + tempNodeAssociations.inContainer() + " parent " + tempNodeAssociations.getParent()));
                }
                tempNodeAssociations = this.loadContainerTree(deviceDbKey, tempNodeAssociations);
                tempNodeAssociations = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, tempNodeAssociations);
            }
            catch (SQLException myException) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                Object var13_15 = null;
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                this.myNodeRelationshipManager.update(tempNodeAssociations);
                return tempNodeAssociations;
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
                Object var13_16 = null;
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                this.myNodeRelationshipManager.update(tempNodeAssociations);
                return tempNodeAssociations;
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            this.myNodeRelationshipManager.update(tempNodeAssociations);
            throw throwable;
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        this.myNodeRelationshipManager.update(tempNodeAssociations);
        return tempNodeAssociations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadContainerTree(int theDeviceKey, NodeAssociations na) {
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block24: {
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            debugOutput.log(5, "In Loading Container Tree for " + theDeviceKey);
            MxNode theDevice = null;
            String deviceName = null;
            try {
                theDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theDeviceKey);
                deviceName = theDevice.getDeviceNameStandard();
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            if (theDevice == null) {
                debugOutput.log(5, "Device association error, could not load on delete!! " + theDeviceKey);
                return na;
            }
            try {
                DeviceAssociationObject dao;
                Vector containedDevices;
                if (theDevice.getDeviceType().equals("Enclosure")) {
                    debugOutput.log(5, "Loading container Tree for ENCLOSURE : " + deviceName);
                    myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                    myStatement = myConnection.createStatement();
                    myResultSet = myStatement.executeQuery("select * from rackTopology where Encl_DeviceKey=" + theDeviceKey);
                    if (myResultSet.next()) {
                        Integer bottomDeviceKey = new Integer(myResultSet.getInt("Right_Neighbor_DeviceKey"));
                        if (bottomDeviceKey != -1) {
                            na.setBottomNeighborDeviceKey(bottomDeviceKey.intValue());
                            debugOutput.log(5, "Setting the enclosure's bottom neighbor to " + bottomDeviceKey);
                        } else {
                            na.setBottomMostItem(true);
                            debugOutput.log(5, "Bottom Neighboring Enclosure for Enclosure " + deviceName + " in the RACK  : is null");
                        }
                        Integer topDeviceKey = new Integer(myResultSet.getInt("Left_Neighbor_DeviceKey"));
                        if (topDeviceKey != -1) {
                            na.setTopNeighborDeviceKey(topDeviceKey.intValue());
                            debugOutput.log(5, "Setting the enclosure's top neighbor to " + topDeviceKey);
                        } else {
                            na.setTopMostItem(true);
                            debugOutput.log(5, "Top Enclosure for Enclosure " + deviceName + " in the RACK  : is null");
                        }
                    }
                    containedDevices = this.myNodeRelationshipManager.getDevicesThatHaveAssociations(theDeviceKey, true);
                    debugOutput.log(5, "Vector contained Devices : " + containedDevices.size());
                    for (int i = 0; i < containedDevices.size(); ++i) {
                        dao = (DeviceAssociationObject)containedDevices.elementAt(i);
                        debugOutput.log(5, "Adding device key is " + dao.getDeviceKey());
                        MxNode daoDev = null;
                        try {
                            daoDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(dao.getDeviceKey());
                        }
                        catch (MxUndefinedNodeException ex1) {
                            // empty catch block
                        }
                        if ((daoDev == null || daoDev.getDeviceType().equals("MgmtProc")) && (!daoDev.getDeviceType().equals("MgmtProc") || !daoDev.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()))) continue;
                        this.addDeviceToTopologyTree(na, dao.getDeviceKey());
                        na.setTheAssociation(dao.getDeviceKey(), theDeviceKey, dao.getAssociationType(), false);
                    }
                }
                if (!theDevice.getDeviceType().equals("Rack")) break block24;
                debugOutput.log(5, "Loading container Tree for RACK : " + theDevice);
                containedDevices = this.myNodeRelationshipManager.getDevicesThatHaveAssociations(theDeviceKey, true);
                int topDeviceKey = -1;
                int bottomDeviceKey = -1;
                MxNode bottomDev = null;
                MxNode topDev = null;
                debugOutput.log(5, "Vector contained Devices : " + containedDevices.size());
                for (int i = 0; i < containedDevices.size(); ++i) {
                    dao = (DeviceAssociationObject)containedDevices.elementAt(i);
                    Integer theEnclDeviceKey = new Integer(dao.getDeviceKey());
                    topDeviceKey = -1;
                    bottomDeviceKey = -1;
                    topDev = null;
                    bottomDev = null;
                    debugOutput.log(5, "Enclosure " + i + " in the RACK  : device Key: " + dao.getDeviceKey());
                    try {
                        MxNode theEnclDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey.intValue());
                        NodeAssociations tmpEnclNA = this.myNodeRelationshipManager.getNodeAssociations(theEnclDeviceKey.intValue());
                        topDeviceKey = tmpEnclNA.getTopNeighborDeviceKey();
                        bottomDeviceKey = tmpEnclNA.getBottomNeighborDeviceKey();
                        if (topDeviceKey != -1) {
                            topDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(topDeviceKey);
                        }
                        if (bottomDeviceKey != -1) {
                            bottomDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(bottomDeviceKey);
                        }
                        this.addTreeNodeToTopologyTree(na, theEnclDev, topDev, bottomDev);
                        continue;
                    }
                    catch (MxUndefinedNodeException ex4) {
                        containerDeviceDebug.exception((Throwable)ex4);
                    }
                }
            }
            catch (SQLException myException) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                }
            }
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        return na;
    }

    public RackEnclosureTopologyHandler(MxNode device) {
        super(device);
    }

    public RackEnclosureTopologyHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations getRackInformation(String rackName, String rUid, int theEnclDeviceKey) {
        NodeAssociations theRackNodeAssociations = null;
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("Storing Rack Information from Device " + this.device.getDeviceName()));
        rackName = rackName.trim();
        rUid = rUid.trim();
        try {
            Integer n = syncRackMoves;
            synchronized (n) {
                MxNode theRackDevice = null;
                try {
                    theRackDevice = rUid.indexOf("Rack") == -1 ? MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID("Rack_" + rUid) : MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(rUid);
                }
                catch (MxUndefinedNodeException ex1) {
                    // empty catch block
                }
                if (rackName != null) {
                    rackName = this.validateName(rackName);
                }
                if (theRackDevice != null && theRackDevice.getDeviceType().equals("Rack")) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Rack Device : " + theRackDevice.getDeviceName() + " is not null"));
                    if (theRackDevice.getDeviceName() != null && rackName != null && !theRackDevice.getDeviceName().equalsIgnoreCase(rackName) && !theRackDevice.getDeviceName().equalsIgnoreCase(rackName + "_" + rUid)) {
                        MxNode otherRackDevice = MxNodeController.getDefaultControllerNoEx().getDeviceByName(rackName);
                        MxNode origNode = (MxNode)theRackDevice.clone();
                        if (otherRackDevice != null) {
                            theRackDevice.setDeviceName(rackName + "_" + rUid);
                        } else {
                            theRackDevice.setDeviceName(rackName);
                        }
                        MxNodeController.getDefaultControllerNoEx().renameNode((MxTransaction)new MxCoreTransaction(), origNode, theRackDevice);
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Just updated the rack device name to " + theRackDevice.getDeviceName()));
                    }
                    if (theRackDevice.getSnoozeTime() != -2) {
                        theRackDevice.setSnoozeTime(-2);
                    }
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theRackDevice, false);
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Just updated the rack device name to " + theRackDevice.getDeviceName()));
                } else if (theRackDevice == null) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"Rack device is null");
                    boolean foundRackInDb = false;
                    if (rUid != null && rUid.trim().length() > 0 && !rUid.equalsIgnoreCase("unknown")) {
                        theRackDevice = new MxNode();
                        if (rackName != null && rackName.trim().length() > 0 && !rackName.equalsIgnoreCase("unknown")) {
                            MxNode otherRackDevice = MxNodeController.getDefaultControllerNoEx().getDeviceByName(rackName);
                            if (otherRackDevice != null) {
                                if (!otherRackDevice.getAgentUUID().equalsIgnoreCase(rUid)) {
                                    theRackDevice.setDeviceName(rackName + "_" + rUid);
                                } else {
                                    foundRackInDb = true;
                                    this.theRackDevice = otherRackDevice;
                                }
                            } else {
                                theRackDevice.setDeviceName(rackName);
                            }
                        } else {
                            theRackDevice.setDeviceName("Rack_" + rUid);
                        }
                        if (!foundRackInDb) {
                            theRackDevice.setAgentUUID("Rack_" + rUid);
                            theRackDevice.setDeviceType("Rack");
                            theRackDevice.setSnoozeTime(-2);
                            MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), theRackDevice);
                            theRackNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theRackDevice.getDeviceKey());
                            theRackNodeAssociations.initializeTopologyTree();
                            this.theRackDevice = theRackDevice;
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Created the new rack device " + theRackDevice.getDeviceName()));
                        }
                    }
                }
                MxNode theEnclDevice = null;
                try {
                    theEnclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                if (theEnclDevice != null && theEnclDevice.getDeviceType().equals("Enclosure")) {
                    NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclDevice.getDeviceKey());
                    if (theRackDevice != null) {
                        int parentRackDeviceKey = theEnclNodeAssociations.getParentDeviceKey();
                        if (parentRackDeviceKey != theRackDevice.getDeviceKey() && parentRackDeviceKey != -1) {
                            NodeAssociations tempRackNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(parentRackDeviceKey);
                            tempRackNodeAssociations.removeDeviceFromTopologyTree(new Integer(theEnclDevice.getDeviceKey()));
                            this.myNodeRelationshipManager.update(tempRackNodeAssociations);
                            this.myNodeRelationshipManager.resetDeviceAssociations(parentRackDeviceKey);
                        }
                        theEnclNodeAssociations.setTheAssociation(theEnclDevice.getDeviceKey(), theRackDevice.getDeviceKey(), "EnclosureToRack", false);
                        theEnclNodeAssociations.setInContainer(true);
                        theEnclNodeAssociations.setParent(theRackDevice.getDeviceKey());
                        this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                    }
                    this.theRackDevice = theRackDevice;
                    this.myNodeRelationshipManager.update(theRackNodeAssociations);
                }
            }
        }
        catch (Exception ex) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Exception in storing rack information for device" + this.device.getDeviceName() + " " + ex));
            containerDeviceDebug.exception((Throwable)ex);
        }
        return theRackNodeAssociations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeAssociations getEnclosureInformation(Vector enclosureInfo, String rackName, String rUid) {
        NodeAssociations theEnclNodeAssociations = null;
        MxNode theEnclDevice = null;
        try {
            block22: {
                try {
                    block24: {
                        String hasPowerBlades;
                        String hasServerBlades;
                        String enclSerialNumber;
                        String enclName;
                        String enclUUID;
                        block25: {
                            int theEnclDeviceKey;
                            block23: {
                                String tmpStr = null;
                                enclUUID = null;
                                enclName = null;
                                enclSerialNumber = null;
                                hasServerBlades = null;
                                hasPowerBlades = null;
                                if (enclosureInfo != null) {
                                    tmpStr = (String)enclosureInfo.elementAt(0);
                                    if (tmpStr != null) {
                                        enclUUID = tmpStr.trim();
                                    }
                                    if ((tmpStr = (String)enclosureInfo.elementAt(1)) != null) {
                                        enclName = tmpStr.trim();
                                    }
                                    if ((tmpStr = (String)enclosureInfo.elementAt(8)) != null) {
                                        enclSerialNumber = tmpStr.trim();
                                    }
                                    hasServerBlades = (String)enclosureInfo.elementAt(4);
                                    hasPowerBlades = (String)enclosureInfo.elementAt(5);
                                }
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("Encl Serial num : '" + enclUUID + "'"));
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ENclosure Name : '" + enclName + "'"));
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("Has Server Blades  : " + hasServerBlades));
                                if (enclName != null) {
                                    enclName = this.validateName(enclName);
                                }
                                if (hasServerBlades == null || !hasServerBlades.trim().equalsIgnoreCase("true")) break block22;
                                theEnclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclSerialNumber, 14);
                                try {
                                    theEnclDevice = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclUUID);
                                }
                                catch (MxUndefinedNodeException ex1) {
                                    // empty catch block
                                }
                                if (theEnclDevice == null || !theEnclDevice.getDeviceType().equals("Enclosure")) break block23;
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure Device is already there in the dB " + theEnclDevice.getDeviceName()));
                                this.useThisIdForNamingEnclosures = enclUUID;
                                if (theEnclDevice.getDeviceName() != null && enclName != null && !theEnclDevice.getDeviceName().equalsIgnoreCase(enclName) && enclName.trim().length() > 0 && !theEnclDevice.getDeviceName().equalsIgnoreCase(enclName + "_" + this.useThisIdForNamingEnclosures)) {
                                    MxNode otherDevice = MxNodeController.getDefaultControllerNoEx().getDeviceByName(enclName);
                                    if (otherDevice != null) {
                                        theEnclDevice.setDeviceName(enclName + "_" + this.useThisIdForNamingEnclosures);
                                    } else {
                                        theEnclDevice.setDeviceName(enclName);
                                    }
                                    theEnclDevice.setEnclosureName(theEnclDevice.getDeviceName());
                                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                                }
                                break block24;
                            }
                            if (theEnclDeviceKey == 0) break block25;
                            theEnclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure Device is already there in the dB " + theEnclDevice.getDeviceName()));
                            if (theEnclDevice.getDeviceName() != null && enclName != null && !theEnclDevice.getDeviceName().equalsIgnoreCase(enclName) && enclName.trim().length() > 0 && !theEnclDevice.getDeviceName().equalsIgnoreCase(enclName + "_" + enclSerialNumber)) {
                                MxNode origEnclNode = (MxNode)theEnclDevice.clone();
                                MxNode otherDevice = null;
                                try {
                                    otherDevice = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(enclName, false);
                                }
                                catch (MxUndefinedNodeException ex2) {
                                }
                                catch (MxInvalidNodeNameException ex2) {
                                    // empty catch block
                                }
                                if (otherDevice != null) {
                                    theEnclDevice.setDeviceName(enclName + "_" + enclSerialNumber);
                                } else {
                                    theEnclDevice.setDeviceName(enclName);
                                }
                                theEnclDevice.setRackName("");
                                theEnclDevice.setEnclosureName(theEnclDevice.getDeviceName());
                                MxNodeController.getDefaultControllerNoEx().renameNode((MxTransaction)new MxCoreTransaction(), origEnclNode, theEnclDevice);
                            }
                            break block24;
                        }
                        if (enclSerialNumber != null && enclSerialNumber.trim().length() > 0) {
                            theEnclDevice = this.getEnclosureDevice(enclUUID, enclSerialNumber, enclName, hasServerBlades, hasPowerBlades, this.theRackDevice);
                        }
                    }
                    if (theEnclDevice != null && theEnclDevice.getSnoozeTime() != -2) {
                        theEnclDevice.setSnoozeTime(-2);
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                    }
                }
                catch (Exception ex) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Exception in storing enclosure information for device" + this.device.getDeviceName() + " " + ex));
                    containerDeviceDebug.exception((Throwable)ex);
                    Object var17_21 = null;
                    if (theEnclDevice == null) return theEnclNodeAssociations;
                    return this.myNodeRelationshipManager.getNodeAssociations(theEnclDevice.getDeviceKey());
                }
            }
            Object var17_20 = null;
            if (theEnclDevice == null) return theEnclNodeAssociations;
            return this.myNodeRelationshipManager.getNodeAssociations(theEnclDevice.getDeviceKey());
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            if (theEnclDevice == null) return theEnclNodeAssociations;
            return this.myNodeRelationshipManager.getNodeAssociations(theEnclDevice.getDeviceKey());
        }
    }

    public void storeTopologyInformation(Vector topology, MxNode theRackDevice) {
        try {
            String enclUUID = null;
            String enclName = null;
            String enclSerialNumber = null;
            String leftNeighborName = null;
            String leftNeighborUUID = null;
            String leftNeighborSerNo = null;
            String rghtNeighborName = null;
            String rghtNeighborUUID = null;
            String rghtNeighborSerNo = null;
            String hasServerBlades = null;
            String hasPowerBlades = null;
            Vector topologyElement = null;
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"CREATING AND STORING TOPOLOGY INFORMATION");
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"\n*******************************************************************************************************************\n");
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("TOPOLOGY Vector Size : " + topology.size()));
            NodeAssociations theEnclNodeAssociations = null;
            NodeAssociations theTopEnclNodeAssociations = null;
            NodeAssociations thebottomEnclNodeAssociations = null;
            for (int i = 0; i < topology.size(); ++i) {
                topologyElement = (Vector)topology.elementAt(i);
                enclUUID = ((String)topologyElement.elementAt(0)).trim();
                enclName = ((String)topologyElement.elementAt(1)).trim();
                if (enclName != null) {
                    enclName = this.validateName(enclName);
                }
                leftNeighborName = (String)topologyElement.elementAt(2);
                rghtNeighborName = (String)topologyElement.elementAt(3);
                hasServerBlades = (String)topologyElement.elementAt(4);
                hasPowerBlades = (String)topologyElement.elementAt(5);
                leftNeighborUUID = ((String)topologyElement.elementAt(6)).trim();
                rghtNeighborUUID = ((String)topologyElement.elementAt(7)).trim();
                enclSerialNumber = ((String)topologyElement.elementAt(8)).trim();
                leftNeighborSerNo = ((String)topologyElement.elementAt(9)).trim();
                rghtNeighborSerNo = ((String)topologyElement.elementAt(10)).trim();
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure UUID. [" + i + "] is " + enclUUID));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Enclosure Name [" + i + "] is " + enclName));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Top Neighbor Name [" + i + "] is " + leftNeighborName));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Bottom Neighbor Name [" + i + "] is " + rghtNeighborName));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Has Server Blades [" + i + "] is " + hasServerBlades));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Has Power Blades [" + i + "] is " + hasPowerBlades));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Top Neighbor serial No. : [" + i + "] is " + leftNeighborUUID));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Bottom neighbor serial no. [" + i + "] is " + rghtNeighborUUID));
                MxNode theEnclosure = this.getEnclosureDevice(enclUUID, enclSerialNumber, enclName, hasServerBlades, hasPowerBlades, theRackDevice);
                MxNode itsTopNeighbor = this.getEnclosureDevice(leftNeighborUUID, leftNeighborSerNo, leftNeighborName, null, null, theRackDevice);
                MxNode itsBottomNeighbor = this.getEnclosureDevice(rghtNeighborUUID, rghtNeighborSerNo, rghtNeighborName, null, null, theRackDevice);
                if (theEnclosure != null) {
                    NodeAssociations theRackNodeAssociations;
                    theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
                    Vector children = new Vector(1);
                    this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), theEnclosure.getDeviceKey());
                    if (itsTopNeighbor == null && itsBottomNeighbor == null) {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), -1, -1, 1);
                        this.cutOldNeighborLink(theEnclosure, true);
                        this.cutOldNeighborLink(theEnclosure, false);
                    } else if (itsTopNeighbor == null && itsBottomNeighbor != null) {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), -1, itsBottomNeighbor.getDeviceKey(), 1);
                        theEnclNodeAssociations.setTopMostItem(true);
                        children = this.myNodeRelationshipManager.getAllDevsInContainer(itsBottomNeighbor.getDeviceKey());
                        if (children.size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - bottom enclosure empty (top null): " + itsBottomNeighbor.getDeviceName()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsBottomNeighbor, true);
                        }
                        this.cutOldNeighborLink(theEnclosure, true);
                    } else if (itsBottomNeighbor == null && itsTopNeighbor != null) {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), itsTopNeighbor.getDeviceKey(), -1, 1);
                        theEnclNodeAssociations.setBottomMostItem(true);
                        children = this.myNodeRelationshipManager.getAllDevsInContainer(itsTopNeighbor.getDeviceKey());
                        if (children.size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - top enclosure empty (bottom null): " + itsTopNeighbor.getDeviceName()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsTopNeighbor, false);
                        }
                        this.cutOldNeighborLink(theEnclosure, false);
                    } else {
                        this.storeNeighborInfoInDb(theEnclosure.getDeviceKey(), itsTopNeighbor.getDeviceKey(), itsBottomNeighbor.getDeviceKey(), 1);
                        children = this.myNodeRelationshipManager.getAllDevsInContainer(itsTopNeighbor.getDeviceKey());
                        if (children.size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - top enclosure empty: " + itsTopNeighbor.getDeviceName()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsTopNeighbor, false);
                        }
                        if ((children = this.myNodeRelationshipManager.getAllDevsInContainer(itsBottomNeighbor.getDeviceKey())).size() == 0) {
                            if (containerDeviceDebug.check(40)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in storeTopologyInformation - bottom enclosure empty: " + itsBottomNeighbor.getDeviceName()));
                            }
                            this.fixEmptyNeighbor(theEnclosure, itsBottomNeighbor, true);
                        }
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"Getting ready to store the neighbor info in dB");
                    if (itsTopNeighbor != null) {
                        theTopEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(itsTopNeighbor.getDeviceKey());
                        theTopEnclNodeAssociations.setBottomNeighborDeviceKey(theEnclosure.getDeviceKey());
                        theEnclNodeAssociations.setTopNeighborDeviceKey(itsTopNeighbor.getDeviceKey());
                        this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), itsTopNeighbor.getDeviceKey());
                    }
                    if (itsBottomNeighbor != null) {
                        thebottomEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(itsBottomNeighbor.getDeviceKey());
                        thebottomEnclNodeAssociations.setTopNeighborDeviceKey(theEnclosure.getDeviceKey());
                        theEnclNodeAssociations.setBottomNeighborDeviceKey(itsBottomNeighbor.getDeviceKey());
                        this.getRackInformation(theRackDevice.getNameString(), theRackDevice.getAgentUUID(), itsBottomNeighbor.getDeviceKey());
                    }
                    if (theRackDevice == null || (theRackNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theRackDevice.getDeviceKey())) == null) continue;
                    this.addTreeNodeToTopologyTree(theRackNodeAssociations, theEnclosure, itsTopNeighbor, itsBottomNeighbor);
                    continue;
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)"The middle enclosure is null : ");
            }
            if (this.hasTopologyChanged && theRackDevice != null) {
                NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(theRackDevice.getDeviceKey());
                this.updateDevContainerAndRoleNames(theRackDevice);
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public MxNode getTheRackDevice() {
        return this.theRackDevice;
    }

    public void removeOldAssociationsFromThisSlot(int newDeviceKey, int theEnclDeviceKey) {
        int numSlotsUsed = this.myNodeRelationships.getNumBladeSlotsUsed();
        int slotNumber = this.myNodeRelationships.getSlotNumber();
        NodeAssociations theEnclDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclDeviceKey);
        if (theEnclDeviceNodeAssociations != null) {
            MxNode tmpDevice = theEnclDeviceNodeAssociations.getDeviceBySlotNumber(slotNumber);
            containerDeviceDebug.log(10, "IN REMOVE OLD ASSOCIATIONS for " + theEnclDeviceKey);
            containerDeviceDebug.log(10, "Slot number - " + slotNumber);
            containerDeviceDebug.log(10, "Number of slots used - " + numSlotsUsed);
            containerDeviceDebug.log(10, "Current device over there - " + tmpDevice);
            containerDeviceDebug.log(10, "New device wanting to be in that slot - " + newDeviceKey);
            if (tmpDevice != null && tmpDevice.getDeviceKey() != newDeviceKey) {
                for (int i = slotNumber; i < slotNumber + numSlotsUsed; ++i) {
                    tmpDevice = theEnclDeviceNodeAssociations.getDeviceBySlotNumber(i);
                    if (tmpDevice == null) continue;
                    this.myNodeRelationshipManager.removeBladeFromTopology(tmpDevice.getDeviceKey());
                    theEnclDeviceNodeAssociations.setContainerDeviceTree(this.removeBladeFromTopology(tmpDevice.getDeviceKey(), theEnclDeviceNodeAssociations.getContainerDeviceTree()));
                }
            }
        }
    }

    protected void removeOldDeviceAssociationsFromThisSlot(NodeAssociations myDeviceNodeAssociations, NodeAssociations myEnclosureNodeAssociations, String DEVICE_TYPE) {
        BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot(" + myDeviceNodeAssociations + "," + myEnclosureNodeAssociations + "," + DEVICE_TYPE + ")");
        int NUM_SLOTS_USED = myDeviceNodeAssociations.getNumBladeSlotsUsed();
        int SLOT_NUMBER = myDeviceNodeAssociations.getSlotNumber();
        BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.NUM_SLOTS_USED " + NUM_SLOTS_USED);
        BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.SLOT_NUMBER " + SLOT_NUMBER);
        if (myEnclosureNodeAssociations != null) {
            MxNode deviceMxNode = this.getDeviceAtSlot(myEnclosureNodeAssociations.getDeviceKey(), DEVICE_TYPE, SLOT_NUMBER);
            BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.deviceMxNode " + deviceMxNode);
            if (deviceMxNode != null) {
                BladeIMELogger.log("RackEnclosureTopologyHandler.deviceMxNode.getDeviceKey() " + deviceMxNode.getDeviceKey());
                BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.myDeviceNodeAssociations.getDeviceKey() " + myDeviceNodeAssociations.getDeviceKey());
            }
            if (deviceMxNode != null && deviceMxNode.getDeviceKey() != myDeviceNodeAssociations.getDeviceKey()) {
                for (int i = SLOT_NUMBER; i < SLOT_NUMBER + NUM_SLOTS_USED; ++i) {
                    deviceMxNode = this.getDeviceAtSlot(myEnclosureNodeAssociations.getDeviceKey(), DEVICE_TYPE, i);
                    BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.deviceMxNode At " + i + " " + deviceMxNode);
                    if (deviceMxNode == null) continue;
                    BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.Removing old device at slot " + i + " for device " + DEVICE_TYPE);
                    try {
                        BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.Deleting node " + deviceMxNode.getName());
                        MxNodeController.getDefaultControllerNoEx().deleteNode((MxTransaction)new MxCoreTransaction(), deviceMxNode);
                        BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.Deletion success");
                        continue;
                    }
                    catch (MxException e) {
                        BladeIMELogger.log("RackEnclosureTopologyHandler.removeOldDeviceAssociationsFromThisSlot.Deletion failed");
                    }
                }
            }
        }
    }

    private MxNode getDeviceAtSlot(int ENCLOSURE_DEVICE_KEY, String DEVICE_TYPE, int SLOT_NUMBER) {
        BladeIMELogger.log("RackEnclosureTopologyHandler.getDeviceAtSlot(" + ENCLOSURE_DEVICE_KEY + "," + DEVICE_TYPE + "," + SLOT_NUMBER + ")");
        Vector associatedDeviceList = this.myNodeRelationshipManager.getDevicesThatHaveAssociations(ENCLOSURE_DEVICE_KEY, true);
        BladeIMELogger.log("RackEnclosureTopologyHandler.getDeviceAtSlot.associatedDeviceList.size " + associatedDeviceList.size());
        NodeAssociations na = null;
        DeviceAssociationObject dao = null;
        for (int i = 0; i < associatedDeviceList.size(); ++i) {
            dao = (DeviceAssociationObject)associatedDeviceList.elementAt(i);
            MxNode deviceMxNode = null;
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(dao.getDeviceKey());
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            BladeIMELogger.log("RackEnclosureTopologyHandler.getDeviceAtSlot.deviceMxNode " + deviceMxNode);
            if (deviceMxNode == null) continue;
            na = this.myNodeRelationshipManager.getNodeAssociations(dao.getDeviceKey());
            BladeIMELogger.log("RackEnclosureTopologyHandler.getDeviceAtSlot.deviceMxNode " + deviceMxNode);
            BladeIMELogger.log("RackEnclosureTopologyHandler.getDeviceAtSlot.na " + na);
            BladeIMELogger.log("RackEnclosureTopologyHandler.getDeviceAtSlot.deviceMxNode.getDeviceType() " + deviceMxNode.getDeviceType());
            if (na != null) {
                BladeIMELogger.log("RackEnclosureTopologyHandler.getDeviceAtSlot.na.getSlotNumber() " + na.getSlotNumber());
            }
            if (na == null || na.getSlotNumber() != SLOT_NUMBER || !deviceMxNode.getDeviceType().equalsIgnoreCase(DEVICE_TYPE)) continue;
            return deviceMxNode;
        }
        return null;
    }

    private void fixEmptyNeighbor(MxNode theEnclosure, MxNode emptyNeighbor, boolean emptyNeighborOnBottom) {
        NodeAssociations theEnclosureNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclosure.getDeviceKey());
        NodeAssociations emptyNeighborNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(emptyNeighbor.getDeviceKey());
        if (containerDeviceDebug.check(35)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in fixEmptyNeighbor - enclosure: " + theEnclosure.getDeviceName() + " emptyNeighbor: " + emptyNeighbor.getDeviceName() + " bottom: " + new Boolean(emptyNeighborOnBottom)));
        }
        if (emptyNeighborOnBottom) {
            this.storeNeighborInfoInDb(emptyNeighbor.getDeviceKey(), theEnclosure.getDeviceKey(), -1, 2);
        } else {
            this.storeNeighborInfoInDb(emptyNeighbor.getDeviceKey(), -1, theEnclosure.getDeviceKey(), 3);
        }
        MxNode theEnclRack = theEnclosureNodeAssociations.getParent();
        MxNode theEmptyRack = emptyNeighborNodeAssociations.getParent();
        if (theEnclRack != null && theEmptyRack != null && theEnclRack.getDeviceKey() != theEmptyRack.getDeviceKey()) {
            MxNode rackDev = theEnclRack;
            if (rackDev != null) {
                if (containerDeviceDebug.check(35)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in fixEmptyNeighbor - setting new rack association for enclosure: " + emptyNeighbor.getDeviceName()));
                }
                this.myNodeRelationshipManager.setNewRack(emptyNeighbor.getDeviceKey(), rackDev.getDeviceKey());
                emptyNeighborNodeAssociations.setParent(rackDev.getDeviceKey());
                this.myNodeRelationshipManager.update(emptyNeighborNodeAssociations);
                this.hasTopologyChanged = true;
            }
        } else if (containerDeviceDebug.check(35) && theEnclosureNodeAssociations.getParent() != null && emptyNeighborNodeAssociations.getParent() != null) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in fixEmptyNeighbor - both enclosures have same rack - enclosure: " + theEnclosure.getDeviceName() + " (" + new Integer(theEnclosureNodeAssociations.getParent().getDeviceKey()) + ")" + " empty encl.: " + emptyNeighbor.getDeviceName() + " (" + new Integer(emptyNeighborNodeAssociations.getParent().getDeviceKey()) + ")"));
        }
    }

    private void cutOldNeighborLink(MxNode enclDev, boolean topNeighbor) {
        int neighborKey = -1;
        MxNode neighborDev = null;
        NodeAssociations theEnclDevNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclDev.getDeviceKey());
        if (topNeighbor) {
            neighborKey = theEnclDevNodeAssociations.getTopNeighborDeviceKey();
            try {
                neighborDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(neighborKey);
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            if (neighborKey != -1) {
                NodeAssociations theNeighborNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(neighborDev.getDeviceKey());
                this.storeNeighborInfoInDb(enclDev.getDeviceKey(), -1, -1, 2);
                if (neighborDev != null && theNeighborNodeAssociations.getBottomNeighborDeviceKey() == enclDev.getDeviceKey()) {
                    this.storeNeighborInfoInDb(neighborKey, -1, -1, 3);
                }
            }
        } else {
            neighborKey = theEnclDevNodeAssociations.getBottomNeighborDeviceKey();
            try {
                neighborDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(neighborKey);
            }
            catch (MxUndefinedNodeException ex1) {
                // empty catch block
            }
            if (neighborKey != -1) {
                NodeAssociations theNeighborNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(neighborDev.getDeviceKey());
                this.storeNeighborInfoInDb(enclDev.getDeviceKey(), -1, -1, 3);
                if (containerDeviceDebug.check(35)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in cutOldNeighborLink - bottom neighbor: " + neighborDev + " neighbor's top neighbor: " + theNeighborNodeAssociations.getTopNeighborDeviceKey()));
                }
                if (neighborDev != null && theNeighborNodeAssociations.getTopNeighborDeviceKey() == enclDev.getDeviceKey()) {
                    this.storeNeighborInfoInDb(neighborKey, -1, -1, 2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDevContainerAndRoleNames(MxNode rackDev) {
        String rackName = rackDev.getDeviceName();
        StringBuffer sqlStr = new StringBuffer(250);
        Statement myStatement = null;
        Connection myConnection = null;
        sqlStr.append("update devContainerAndRole set RackName='");
        sqlStr.append(rackName);
        sqlStr.append("' where ");
        RackEnclosureObject reObj = new RackEnclosureObject(new Integer(rackDev.getDeviceKey()), rackDev.getDeviceName(), rackDev.getAgentUUID(), new Integer(13), null, null);
        if (reObj != null) {
            DeviceByRackDataObject.buildSQLQuery((StringBuffer)sqlStr, (RackEnclosureObject)reObj, (int)0, (boolean)false);
            if (containerDeviceDebug.check(35)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in updateDevContainerAndRoleNames - sqlStr: " + sqlStr.toString()));
            }
            try {
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("rackEnclosureTopologyHandler:updateDevContainerAndRoleNames");
                myStatement = myConnection.createStatement();
                myStatement.executeUpdate(sqlStr.toString());
                myStatement.close();
                myStatement = null;
                Vector devsInRack = this.myNodeRelationshipManager.getAllDevsInContainer(rackDev.getDeviceKey());
                for (int i = 0; i < devsInRack.size(); ++i) {
                    Integer tmpDevKey = (Integer)devsInRack.elementAt(i);
                    MxNode tmpDev = null;
                    try {
                        tmpDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(tmpDevKey.intValue());
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    if (tmpDev == null || !tmpDev.getDeviceType().equals("Enclosure") || (reObj = new RackEnclosureObject(new Integer(tmpDev.getDeviceKey()), tmpDev.getDeviceName(), tmpDev.getAgentUUID(), new Integer(14), null, null)) == null) continue;
                    sqlStr.setLength(0);
                    sqlStr.append("update devContainerAndRole set EnclosureName='");
                    sqlStr.append(tmpDev.getDeviceName());
                    sqlStr.append("' where ");
                    DeviceByRackDataObject.buildSQLQuery((StringBuffer)sqlStr, (RackEnclosureObject)reObj, (int)0, (boolean)false);
                    myStatement = myConnection.createStatement();
                    if (containerDeviceDebug.check(35)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in updateDevContainerAndRoleNames - sqlStr: " + sqlStr));
                    }
                    myStatement.executeUpdate(sqlStr.toString());
                    myStatement.close();
                    myStatement = null;
                }
            }
            catch (SQLException e) {
                containerDeviceDebug.exception((Throwable)e);
            }
            finally {
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void storeNeighborInfoInDb(int theEnclDeviceKey, int topNeighbor, int bottomNeighbor, int neighborEmpty) {
        block32: {
            SQLException myException222222;
            ResultSet myResultSet;
            Connection myConnection;
            Statement myStatement;
            block28: {
                block27: {
                    myStatement = null;
                    myConnection = null;
                    myResultSet = null;
                    myConnection = DatabaseManager.getDefaultDatabase().getConnection("rackEnclosureTopologyHandler:storeNeighborInfoInDb");
                    myStatement = myConnection.createStatement();
                    myResultSet = myStatement.executeQuery("select * from rackTopology where Encl_DeviceKey=" + theEnclDeviceKey);
                    if (myResultSet.next()) {
                        int tNeighbor = myResultSet.getInt(1);
                        int bNeighbor = myResultSet.getInt(2);
                        if (tNeighbor != topNeighbor || bNeighbor != bottomNeighbor) {
                            myResultSet.close();
                            myResultSet = null;
                            myStatement.close();
                            myStatement = null;
                            myStatement = myConnection.createStatement();
                            String sqlStr = null;
                            sqlStr = neighborEmpty == 3 ? "update rackTopology set Right_Neighbor_DeviceKey=" + bottomNeighbor + "  where Encl_DeviceKey=" + theEnclDeviceKey : (neighborEmpty == 2 ? "update rackTopology set Left_Neighbor_DeviceKey=" + topNeighbor + "  where Encl_DeviceKey=" + theEnclDeviceKey : "update rackTopology set Right_Neighbor_DeviceKey=" + bottomNeighbor + ", Left_Neighbor_DeviceKey=" + topNeighbor + "  where Encl_DeviceKey=" + theEnclDeviceKey);
                            if (containerDeviceDebug.check(35)) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("in storeNeighborInfoInDb - query: " + sqlStr));
                            }
                            myStatement.executeUpdate(sqlStr);
                            this.hasTopologyChanged = true;
                        }
                        break block27;
                    }
                    myResultSet.close();
                    myResultSet = null;
                    myStatement.close();
                    myStatement = null;
                    myStatement = myConnection.createStatement();
                    myStatement.executeUpdate("insert into rackTopology values(" + theEnclDeviceKey + "," + bottomNeighbor + "," + topNeighbor + ")");
                }
                Object var12_12 = null;
                if (myResultSet == null) break block28;
                try {
                    myResultSet.close();
                    myResultSet = null;
                }
                catch (SQLException myException222222) {
                    // empty catch block
                }
            }
            if (myStatement != null) {
                try {
                    myStatement.close();
                    myStatement = null;
                }
                catch (SQLException myException222222) {
                    // empty catch block
                }
            }
            if (myConnection != null) {
                try {
                    DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                }
                catch (SQLException myException222222) {}
            }
            break block32;
            {
                catch (SQLException myException3) {
                    SQLException myException222222;
                    Object var12_13 = null;
                    if (myResultSet != null) {
                        try {
                            myResultSet.close();
                            myResultSet = null;
                        }
                        catch (SQLException myException222222) {
                            // empty catch block
                        }
                    }
                    if (myStatement != null) {
                        try {
                            myStatement.close();
                            myStatement = null;
                        }
                        catch (SQLException myException222222) {
                            // empty catch block
                        }
                    }
                    if (myConnection != null) {
                        try {
                            DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                        }
                        catch (SQLException myException222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException myException222222;
                Object var12_14 = null;
                if (myResultSet != null) {
                    try {
                        myResultSet.close();
                        myResultSet = null;
                    }
                    catch (SQLException myException222222) {
                        // empty catch block
                    }
                }
                if (myStatement != null) {
                    try {
                        myStatement.close();
                        myStatement = null;
                    }
                    catch (SQLException myException222222) {
                        // empty catch block
                    }
                }
                if (myConnection != null) {
                    try {
                        DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                    }
                    catch (SQLException myException222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MxNode getEnclosureDevice(String enclUUID, String enclSerialNumber, String enclName, String hasServerBlades, String hasPowerBlades, MxNode theRackDevice) {
        MxNode theEnclDevice = null;
        if (enclName.trim().equalsIgnoreCase("unknown")) {
            return theEnclDevice;
        }
        int theEnclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclSerialNumber, 14);
        try {
            Integer n = syncEnclAdds;
            synchronized (n) {
                try {
                    theEnclDevice = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclUUID);
                }
                catch (MxUndefinedNodeException ex) {
                    // empty catch block
                }
                if (theEnclDevice == null) {
                    if (theEnclDeviceKey == 0) {
                        if (enclSerialNumber != null && enclSerialNumber.trim().length() > 0) {
                            theEnclDevice = new MxNode();
                            String productId = (String)this.prodIdList.get(enclSerialNumber);
                            if (productId != null) {
                                theEnclDevice.setProductId(productId);
                            }
                            if (containerDeviceDebug.check(10)) {
                                containerDeviceDebug.log(10, "New ENclosure Device Created: ");
                            }
                            theEnclDevice.setSerialNumber(enclSerialNumber);
                            if (enclUUID != null && enclUUID.trim().length() > 0) {
                                this.useThisIdForNamingEnclosures = enclUUID;
                                theEnclDevice.setAgentUUID(enclUUID);
                            } else {
                                this.useThisIdForNamingEnclosures = enclSerialNumber;
                                theEnclDevice.setAgentUUID(enclSerialNumber);
                            }
                            if (enclName != null && enclName.trim().length() > 0) {
                                MxNode otherDevice = null;
                                try {
                                    otherDevice = MxNodeController.getDefaultControllerNoEx().getNodeByNodeOrHostName(enclName, false);
                                }
                                catch (MxUndefinedNodeException ex2) {
                                }
                                catch (MxInvalidNodeNameException ex2) {
                                    containerDeviceDebug.exception((Throwable)ex2);
                                }
                                if (otherDevice != null) {
                                    if (otherDevice.getAgentUUID().equalsIgnoreCase(theEnclDevice.getAgentUUID()) && otherDevice.getSerialNumber().equalsIgnoreCase(theEnclDevice.getSerialNumber())) {
                                        return otherDevice;
                                    }
                                    theEnclDevice.setDeviceName(enclName + "_" + this.useThisIdForNamingEnclosures);
                                } else {
                                    theEnclDevice.setDeviceName(enclName);
                                }
                            } else {
                                theEnclDevice.setDeviceName("Encl_" + this.useThisIdForNamingEnclosures);
                            }
                            theEnclDevice.setDeviceType("Enclosure");
                            if (hasServerBlades != null && hasServerBlades.equalsIgnoreCase("true")) {
                                theEnclDevice.addDeviceSubType("ServerEnc");
                            } else if (hasPowerBlades != null && hasPowerBlades.equalsIgnoreCase("true")) {
                                theEnclDevice.addDeviceSubType("PowerEnc");
                            }
                            if (theRackDevice != null) {
                                theEnclDevice.setRackName(theRackDevice.getDeviceName());
                            }
                            theEnclDevice.setSnoozeTime(-2);
                            try {
                                MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), theEnclDevice);
                            }
                            catch (MxInvalidIPAddressException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            catch (MxInvalidNodeNameException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            catch (MxDuplicateNodeException ex3) {
                                theEnclDevice = this.getEnclosureDevice(enclUUID, enclSerialNumber, enclName, hasServerBlades, hasPowerBlades, theRackDevice);
                            }
                            catch (MxObjectPersistenceException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            catch (MxInvalidTransactionException ex3) {
                                containerDeviceDebug.exception((Throwable)ex3);
                            }
                            theEnclDeviceKey = theEnclDevice.getDeviceKey();
                            NodeAssociations theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theEnclDeviceKey);
                            theEnclNodeAssociations.initializeTopologyTree();
                            theEnclNodeAssociations.setInContainer(true);
                            theEnclNodeAssociations.setSource("Enclosure");
                            if (theRackDevice != null) {
                                theEnclNodeAssociations.setParent(theRackDevice.getDeviceKey());
                                theEnclNodeAssociations.setTheAssociation(theEnclDeviceKey, theRackDevice.getDeviceKey(), "EnclosureToRack", false);
                                if (containerDeviceDebug.check(40)) {
                                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)("in RackEnclosureTopologyHandler.getEnclosureDevice - setting RackName for enclosure: " + theRackDevice.getDeviceName()));
                                }
                            }
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Device key for enclosure : " + theEnclDeviceKey));
                            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                        }
                    } else {
                        try {
                            theEnclDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
                        }
                        catch (MxUndefinedNodeException ex1) {
                            // empty catch block
                        }
                        if (hasServerBlades != null && hasServerBlades.equalsIgnoreCase("true")) {
                            theEnclDevice.addDeviceSubType("ServerEnc");
                        } else if (hasPowerBlades != null && hasPowerBlades.equalsIgnoreCase("true")) {
                            theEnclDevice.setDeviceSubTypes(new ArrayList());
                            theEnclDevice.addDeviceSubType("PowerEnc");
                        }
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                    }
                } else {
                    if (hasServerBlades != null && hasServerBlades.equalsIgnoreCase("true")) {
                        theEnclDevice.addDeviceSubType("ServerEnc");
                    } else if (hasPowerBlades != null && hasPowerBlades.equalsIgnoreCase("true")) {
                        theEnclDevice.addDeviceSubType("PowerEnc");
                    }
                    if (theEnclDevice.getSnoozeTime() != -2) {
                        theEnclDevice.setSnoozeTime(-2);
                    }
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), theEnclDevice, false);
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
        return theEnclDevice;
    }

    protected void addNodeTypeSubType(MxNode node, String strNodeSubType) {
        boolean bModify = false;
        List nodeSubTypeList = node.getDeviceSubTypes();
        if (nodeSubTypeList.isEmpty()) {
            bModify = true;
            node.addDeviceSubType(strNodeSubType);
        } else if (strNodeSubType != null && !nodeSubTypeList.contains(strNodeSubType)) {
            bModify = true;
            node.addDeviceSubType(strNodeSubType);
        }
        if (bModify) {
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), node, false);
            }
            catch (MxException aMxException) {
                System.out.println("RackEnclosureTopologyHandler::addNodeTypeSubType(): exception " + (Object)((Object)aMxException));
            }
        }
    }

    public void addDeviceToTopologyTree(NodeAssociations theNodeAssociations, int deviceKey) {
        try {
            DefaultMutableTreeNode topologyTree = theNodeAssociations.getContainerDeviceTree();
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)20, (String)("Trying to add device " + deviceKey + " into the topology tree"));
            if (topologyTree != null) {
                int treeCount = topologyTree.getChildCount();
                int treeChildDeviceKey = -1;
                for (int i = 0; i < treeCount; ++i) {
                    treeChildDeviceKey = (Integer)((DefaultMutableTreeNode)topologyTree.getChildAt(i)).getUserObject();
                    if (treeChildDeviceKey != deviceKey) continue;
                    return;
                }
            } else {
                theNodeAssociations.initializeTopologyTree();
                topologyTree = theNodeAssociations.getContainerDeviceTree();
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new Integer(deviceKey));
            topologyTree.add(childNode);
            theNodeAssociations.setContainerDeviceTree(topologyTree);
            int theEnclDeviceKey = theNodeAssociations.getDeviceKey();
            MxNode d = null;
            d = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(theEnclDeviceKey));
            MxNode d1 = null;
            d1 = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
            List nodeSubTypeList = d1.getDeviceSubTypes();
            if (d != null && (nodeSubTypeList.contains(NodeSubTypeMapper.BLADE_SUBTYPE.toString()) || d1.getDeviceType().equals("Switch") || nodeSubTypeList.contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()))) {
                if (nodeSubTypeList.contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
                    this.addNodeTypeSubType(d, NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                } else if (nodeSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                    this.addNodeTypeSubType(d, NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
                } else if (nodeSubTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                    this.addNodeTypeSubType(d, NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
                }
            }
            this.printDebugTreeInformation(NodeAssociationsManager.getDefaultManager(), topologyTree, deviceKey);
        }
        catch (Exception ex) {
            containerDeviceDebug.exception((Throwable)ex);
        }
    }

    public void addTreeNodeToTopologyTree(NodeAssociations theNodeAssociations, int theEnclosureDeviceKey, MxNode topEnclosure, MxNode bottomEnclosure) {
        MxNode theEnclosure = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(theEnclosureDeviceKey));
        this.addTreeNodeToTopologyTree(theNodeAssociations, theEnclosure, topEnclosure, bottomEnclosure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeNodeToTopologyTree(NodeAssociations theNodeAssociations, MxNode theEnclosure, MxNode topEnclosure, MxNode bottomEnclosure) {
        DefaultMutableTreeNode topologyTree = theNodeAssociations.getContainerDeviceTree();
        try {
            if (rackTopologyDebug.check(20)) {
                rackTopologyDebug.log(20, "\n\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                rackTopologyDebug.log(20, "                Adding Tree Nodes to Topology Tree        ");
                rackTopologyDebug.log(20, "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                rackTopologyDebug.log(20, "ROOT OF THE TOPOLOGY TREE : " + topologyTree.getRoot().toString());
            }
            if (theEnclosure == null) {
                return;
            }
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations theEnclDA = myNodeAssociationsManager.getNodeAssociations(theEnclosure.getDeviceKey());
            DefaultMutableTreeNode childNode = theEnclDA.getContainerDeviceTree();
            DefaultMutableTreeNode top = null;
            DefaultMutableTreeNode bottom = null;
            NodeAssociations topDA = null;
            NodeAssociations bottomDA = null;
            int index = 0;
            if (childNode == null) {
                rackTopologyDebug.log(20, "Container Tree for Child Node is null " + theEnclosure.toString());
                return;
            }
            if (topEnclosure != null) {
                topDA = myNodeAssociationsManager.getNodeAssociations(topEnclosure.getDeviceKey());
                top = topDA.getContainerDeviceTree();
                rackTopologyDebug.log(20, "GOING TO ADD enclosures 1: " + topEnclosure.getDeviceName() + " and '" + top + "'");
            }
            rackTopologyDebug.log(20, "GOING TO ADD enclosures 2: " + theEnclosure.getDeviceName() + " and '" + childNode + "'");
            if (bottomEnclosure != null) {
                bottomDA = myNodeAssociationsManager.getNodeAssociations(bottomEnclosure.getDeviceKey());
                bottom = bottomDA.getContainerDeviceTree();
                rackTopologyDebug.log(20, "GOING TO ADD enclosures 3: " + bottomEnclosure.getDeviceName() + " and '" + bottom + "'");
            }
            rackTopologyDebug.log(20, "Tree Nodes : Top is " + top + " and middle " + childNode + " and bottom " + bottom);
            if (top == null && bottom != null) {
                rackTopologyDebug.log(20, "1 Top node is null so middle must be the first one in the rack");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    topologyTree.insert(childNode, 0);
                    theEnclDA.setTopMostItem(true);
                    theEnclDA.setTopNeighborDeviceKey(-1);
                    rackTopologyDebug.log(20, "2 Middle node did not exist in the rack tree so added it and set topmost property to true and top neighbor to -1");
                    if (!this.doesTreeNodeExist(bottom, topologyTree) && bottom != null) {
                        topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                        rackTopologyDebug.log(20, "3 Bottom neighbor does not exist and so inserted it at index 1");
                    } else {
                        int topNeighborDK = bottomDA.getTopNeighborDeviceKey();
                        rackTopologyDebug.log(20, "4 Bottom node does exist and its top neighbor device key is " + topNeighborDK);
                        if (topNeighborDK != theEnclosure.getDeviceKey() && bottom != null) {
                            bottomDA.setTopNeighborDeviceKey(theEnclosure.getDeviceKey());
                            int middleIndex = topologyTree.getIndex(childNode);
                            if (topologyTree.getIndex(bottom) != middleIndex + 1) {
                                rackTopologyDebug.log(20, "5a Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                                this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                            }
                            rackTopologyDebug.log(20, "5 Made the bottom encl to be next to the middle encl");
                        } else {
                            rackTopologyDebug.log(20, "6 Bottom node was the neighbor of middle so do nothing");
                        }
                    }
                    theEnclDA.setBottomNeighborDeviceKey(bottomEnclosure.getDeviceKey());
                } else if (!theEnclDA.isTopMostItem()) {
                    rackTopologyDebug.log(20, "7 Middle node exists and is not the topmost item");
                    topologyTree = this.moveNodeAndOtherNeighborsToTopOfTree(topologyTree, childNode, myNodeAssociationsManager);
                }
                return;
            }
            if (bottom == null && top != null) {
                rackTopologyDebug.log(20, "9 The bottom node is null so middle node must be the last one in the rack");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    rackTopologyDebug.log(20, "10 Middle node does not exist in the tree");
                    topologyTree.add(childNode);
                    theEnclDA.setBottomMostItem(true);
                    theEnclDA.setBottomNeighborDeviceKey(-1);
                    rackTopologyDebug.log(20, "11 Added middle node to the end of the rack tree and set bottomMost property to true and bottom neighbor DK to -1");
                    if (!this.doesTreeNodeExist(top, topologyTree)) {
                        index = topologyTree.getIndex(childNode);
                        if (index - 1 >= 0) {
                            topologyTree.insert(top, index);
                            rackTopologyDebug.log(20, "12 Top node did not exist and so added it to before middle node");
                        } else {
                            rackTopologyDebug.log(20, "12a Top node did not exist but middle node was at index " + index);
                        }
                    } else {
                        int bottomNeighborDK = topDA.getBottomNeighborDeviceKey();
                        rackTopologyDebug.log(20, "13 Top node does exist and its bottom neighbor DK : " + bottomNeighborDK);
                        if (bottomNeighborDK != theEnclosure.getDeviceKey()) {
                            topDA.setBottomNeighborDeviceKey(theEnclosure.getDeviceKey());
                            topologyTree.remove(top);
                            int middleIndex = topologyTree.getIndex(childNode);
                            if (middleIndex - 1 >= 0) {
                                if (topologyTree.getIndex(top) != middleIndex - 1) {
                                    rackTopologyDebug.log(20, "13a Top exists in the tree but is out of place so moving it and neighbors to before middle");
                                    topologyTree = this.moveNodeAndOtherNeighborsToBeforeAnotherNode(topologyTree, top, childNode, myNodeAssociationsManager);
                                }
                                rackTopologyDebug.log(20, "14 Top node's bottom neighbor was not the middle encl so moved things around to make that happen");
                            } else {
                                rackTopologyDebug.log(20, "14a Top node's bottom neighbor was not the middle encl but index was " + middleIndex);
                            }
                        } else {
                            rackTopologyDebug.log(20, "15 Top node's bottom neighbor was the middle node so do nothing");
                        }
                    }
                    theEnclDA.setTopNeighborDeviceKey(topEnclosure.getDeviceKey());
                } else if (!theEnclDA.isBottomMostItem()) {
                    rackTopologyDebug.log(20, "16 Yes, the middle node exists in the tree and it is not the bottom most");
                    topologyTree = this.moveNodeAndOtherNeighborsToBottomOfTree(topologyTree, childNode, myNodeAssociationsManager);
                }
                return;
            }
            if (top == null && bottom == null) {
                if (theEnclosure.getDeviceSubType().equals("ServerEnc") && childNode.getChildCount() == 0) {
                    myNodeAssociationsManager.removeEnclosureFromTopology(((Integer)childNode.getUserObject()).intValue());
                    theEnclDA.setInContainer(false);
                    rackTopologyDebug.log(20, "17 Only middle node is not null, doesn't exist in tree and is empty so remove the enclosure to rack association");
                } else {
                    rackTopologyDebug.log(20, "17a Before adding the middle node, checking to see if it exists");
                    if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                        topologyTree.add(childNode);
                        rackTopologyDebug.log(20, "17 Only middle node is not null, doesn't exist in tree and is not empty so add to the tree");
                    } else {
                        rackTopologyDebug.log(20, "17b Only middle node is not null, but it exists in tree so do nothing");
                    }
                }
                return;
            }
            rackTopologyDebug.log(20, "18 This means that all three enclosures exist.  But, do they exist in the tree?");
            if (!this.doesTreeNodeExist(top, topologyTree)) {
                rackTopologyDebug.log(20, "19 Top node does not exist");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    rackTopologyDebug.log(20, "20 Middle node does not exist");
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.log(20, "21 Bottom node does not exist");
                        rackTopologyDebug.log("The topology Tree count : " + topologyTree.getChildCount());
                        if (topologyTree.getChildCount() > 0) {
                            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)topologyTree.getFirstChild();
                            if (myNodeAssociationsManager.getNodeAssociations(new Integer(tmp.toString()).intValue()).isTopMostItem()) {
                                rackTopologyDebug.log(20, "21a Tree already has a topmost item that should be at the top");
                                tmp = (DefaultMutableTreeNode)topologyTree.getLastChild();
                                if (myNodeAssociationsManager.getNodeAssociations(new Integer(tmp.toString()).intValue()).isBottomMostItem()) {
                                    rackTopologyDebug.log(20, "21b Tree already has a bottommost item that should be at the bottom");
                                } else {
                                    topologyTree.add(top);
                                    topologyTree.add(childNode);
                                    topologyTree.add(bottom);
                                    rackTopologyDebug.log(20, "22 Inserted top, middle and bottom at end of the tree");
                                }
                            } else if (topEnclosure.getDeviceSubType().equals("PowerEnc") || theEnclosure.getDeviceSubType().equals("PowerEnc") || bottomEnclosure.getDeviceSubType().equals("PowerEnc")) {
                                topologyTree.add(top);
                                topologyTree.add(childNode);
                                topologyTree.add(bottom);
                            } else {
                                topologyTree.insert(top, 0);
                                topologyTree.insert(childNode, topologyTree.getIndex(top) + 1);
                                topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                                rackTopologyDebug.log(20, "22 Inserted top at 0, middle at 1 and bottom at 2");
                            }
                        } else {
                            topologyTree.add(top);
                            topologyTree.add(childNode);
                            topologyTree.add(bottom);
                            rackTopologyDebug.log(20, "22 Inserted top, middle and bottom at end of the tree");
                        }
                    } else {
                        rackTopologyDebug.log(20, "23 Bottom node exists");
                        topologyTree.insert(childNode, topologyTree.getIndex(bottom));
                        topologyTree.insert(top, topologyTree.getIndex(childNode));
                        rackTopologyDebug.log(20, "24 Inserted middle before bottom and top before middle");
                    }
                } else {
                    rackTopologyDebug.log(20, "25 Middle node exists");
                    index = topologyTree.getIndex(childNode);
                    if (index > 0) {
                        topologyTree.insert(top, index);
                    } else {
                        topologyTree.insert(top, 0);
                    }
                    rackTopologyDebug.log(20, "26 Inserted top node before middle");
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.log(20, "27 bottom does not exist");
                        topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                        rackTopologyDebug.log(20, "28 Inserted bottom after middle");
                    } else {
                        rackTopologyDebug.log(20, "29 bottom already exists in the tree at index " + this.getIndex(bottom, topologyTree));
                        rackTopologyDebug.log(20, "29 Index for child node (middle) in the tree : " + this.getIndex(childNode, topologyTree));
                        if (this.getIndex(bottom, topologyTree) != this.getIndex(childNode, topologyTree) + 1) {
                            rackTopologyDebug.log(20, "29a Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                            this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                        }
                    }
                }
            } else {
                rackTopologyDebug.log(20, "30 Top node exists");
                if (!this.doesTreeNodeExist(childNode, topologyTree)) {
                    rackTopologyDebug.log(20, "31 Middle node does not exist");
                    int topIndex = topologyTree.getIndex(top);
                    rackTopologyDebug.log(20, "31a Index of Top Node : " + topIndex + " And no. of children-1 : " + (topologyTree.getChildCount() - 1));
                    if (topIndex == topologyTree.getChildCount() - 1) {
                        topologyTree.add(childNode);
                    } else {
                        topologyTree.insert(childNode, topIndex + 1);
                    }
                    rackTopologyDebug.log(20, "32 Added middle node after the top");
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.log(20, "33 Bottom does not exist");
                        int middleIndex = topologyTree.getIndex(childNode);
                        if (middleIndex == topologyTree.getChildCount() - 1) {
                            topologyTree.add(bottom);
                        } else {
                            topologyTree.insert(bottom, middleIndex + 1);
                        }
                        rackTopologyDebug.log(20, "34 Inserted bottom after middle");
                    } else {
                        rackTopologyDebug.log(20, "34a bottom already exists in the tree");
                        if (topologyTree.getIndex(bottom) != topologyTree.getIndex(childNode) + 1) {
                            rackTopologyDebug.log(20, "34a Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                            this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                        }
                    }
                } else {
                    rackTopologyDebug.log(20, "35 Middle node exists");
                    int tempTopIndex = topologyTree.getIndex(top);
                    int tempMiddleIndex = topologyTree.getIndex(childNode);
                    if (tempTopIndex != -1 && tempMiddleIndex != -1 && tempTopIndex != tempMiddleIndex - 1) {
                        rackTopologyDebug.log(20, "35a Top exists in the tree but is out of place so moving it and neighbors to before middle");
                        topologyTree = this.moveNodeAndOtherNeighborsToBeforeAnotherNode(topologyTree, top, childNode, myNodeAssociationsManager);
                    }
                    if (!this.doesTreeNodeExist(bottom, topologyTree)) {
                        rackTopologyDebug.log(20, "36 Bottom node does not exist");
                        topologyTree.insert(bottom, topologyTree.getIndex(childNode) + 1);
                        rackTopologyDebug.log(20, "37 Inserted bottom after middle");
                    } else {
                        rackTopologyDebug.log(20, "37a bottom already exists in the tree");
                        rackTopologyDebug.log(20, "37a PRINTING THE INDICES bottom " + topologyTree.getIndex(bottom) + " and childNode (MIDDLE) : " + topologyTree.getIndex(childNode));
                        int tempBottomIndex = topologyTree.getIndex(bottom);
                        if (tempBottomIndex != -1 && tempMiddleIndex != -1 && tempBottomIndex != tempMiddleIndex + 1) {
                            rackTopologyDebug.log(20, "37b Bottom exists in the tree but is out of place so moving it and neighbors to after middle");
                            this.moveNodeAndOtherNeighborsToAfterAnotherNode(topologyTree, bottom, childNode, myNodeAssociationsManager);
                        }
                    }
                }
            }
            topDA.setBottomNeighborDeviceKey(theEnclosure.getDeviceKey());
            theEnclDA.setTopNeighborDeviceKey(topEnclosure.getDeviceKey());
            theEnclDA.setBottomNeighborDeviceKey(bottomEnclosure.getDeviceKey());
            bottomDA.setTopNeighborDeviceKey(theEnclosure.getDeviceKey());
        }
        catch (Exception e) {
            rackTopologyDebug.log(20, "Exception in adding node to the tree " + e.getMessage());
            containerDeviceDebug.exception((Throwable)e);
        }
        finally {
            theNodeAssociations.setContainerDeviceTree(topologyTree);
        }
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToTopOfTree(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        int i;
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.insertElementAt(childNode, 0);
        boolean lastOneAdded = false;
        for (i = topologyTree.getIndex(childNode); i < topologyTree.getChildCount() - 1; ++i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i + 1);
            MxNode firstDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)first.getUserObject());
            MxNode secondDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)second.getUserObject());
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getBottomNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.add(second);
            rackTopologyDebug.log(20, "8 Added node " + second.toString() + " to the tmp tree");
        }
        for (i = 0; i < tmpVector.size(); ++i) {
            topologyTree.insert((MutableTreeNode)tmpVector.get(i), i);
        }
        return topologyTree;
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToBottomOfTree(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.add(childNode);
        for (int i = topologyTree.getIndex(childNode); i > 0; --i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i - 1);
            MxNode firstDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)first.getUserObject());
            MxNode secondDev = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)second.getUserObject());
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getTopNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.insertElementAt(second, 0);
            rackTopologyDebug.log(20, "17 Added node " + second.toString() + " to the tmp tree");
        }
        for (int j = 0; j < tmpVector.size(); ++j) {
            topologyTree.add((MutableTreeNode)tmpVector.get(j));
        }
        return topologyTree;
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToAfterAnotherNode(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode bottom, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        int i;
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.insertElementAt(bottom, 0);
        MxNode firstDev = null;
        MxNode secondDev = null;
        rackTopologyDebug.log(40, " PRINTING THE Indices : Bottom : " + topologyTree.getIndex(bottom) + " and Middle " + topologyTree.getIndex(childNode));
        for (i = topologyTree.getIndex(bottom); i < topologyTree.getChildCount() - 1; ++i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i + 1);
            try {
                firstDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)first.getUserObject()).intValue());
                secondDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)second.getUserObject()).intValue());
            }
            catch (MxUndefinedNodeException ex) {
                containerDeviceDebug.exception((Throwable)ex);
                continue;
            }
            rackTopologyDebug.log(40, " i " + i + " comparison between " + myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getBottomNeighborDeviceKey() + " and " + secondDev.getDeviceKey());
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getBottomNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.add(second);
            rackTopologyDebug.log(40, " Added node " + second.toString() + " to the tmp tree");
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)40, (String)"Going to print the list of nodes in the vector");
        for (i = 0; i < tmpVector.size(); ++i) {
            rackTopologyDebug.log(40, " Contents of vector at " + i + " is " + tmpVector.get(i));
        }
        boolean addToEndOfTree = false;
        int i2 = topologyTree.getIndex(childNode) + 1;
        for (int j = 0; j < tmpVector.size(); ++j) {
            if (topologyTree.getIndex(childNode) == topologyTree.getChildCount() - 1 || addToEndOfTree) {
                addToEndOfTree = true;
                topologyTree.add((MutableTreeNode)tmpVector.get(j));
            } else {
                topologyTree.insert((MutableTreeNode)tmpVector.get(j), i2);
            }
            rackTopologyDebug.log(40, " Inserted " + tmpVector.get(j) + " from vector into position " + i2);
            ++i2;
        }
        return topologyTree;
    }

    private DefaultMutableTreeNode moveNodeAndOtherNeighborsToBeforeAnotherNode(DefaultMutableTreeNode topologyTree, DefaultMutableTreeNode top, DefaultMutableTreeNode childNode, NodeAssociationsManager myNodeAssociationsManager) {
        int i;
        Vector<DefaultMutableTreeNode> tmpVector = new Vector<DefaultMutableTreeNode>();
        tmpVector.insertElementAt(top, 0);
        MxNode firstDev = null;
        MxNode secondDev = null;
        for (i = topologyTree.getIndex(top); i > 0; --i) {
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            DefaultMutableTreeNode second = (DefaultMutableTreeNode)topologyTree.getChildAt(i - 1);
            try {
                firstDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)first.getUserObject()).intValue());
                secondDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(((Integer)second.getUserObject()).intValue());
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
            if (myNodeAssociationsManager.getNodeAssociations(firstDev.getDeviceKey()).getTopNeighborDeviceKey() != secondDev.getDeviceKey()) break;
            tmpVector.insertElementAt(second, 0);
            rackTopologyDebug.log(20, "17 Added node " + second.toString() + " to the tmp vector");
        }
        i = topologyTree.getIndex(childNode);
        for (int j = 0; j < tmpVector.size(); ++j) {
            try {
                topologyTree.insert((MutableTreeNode)tmpVector.get(j), i);
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
            ++i;
        }
        return topologyTree;
    }

    public boolean doesTreeNodeExist(DefaultMutableTreeNode childNode, DefaultMutableTreeNode topologyTree) {
        int treeCount = topologyTree.getChildCount();
        for (int i = 0; i < treeCount; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            if (tmp == null || childNode == null || !tmp.toString().equals(childNode.toString())) continue;
            rackTopologyDebug.log(20, "DOES TREE NODE Exist : Yes, and the tree node at " + i + " is " + tmp.toString());
            return true;
        }
        return false;
    }

    public int getIndex(DefaultMutableTreeNode childNode, DefaultMutableTreeNode topologyTree) {
        int treeCount = topologyTree.getChildCount();
        for (int i = 0; i < treeCount; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
            if (tmp == null || childNode == null || !tmp.toString().equals(childNode.toString())) continue;
            rackTopologyDebug.log(20, "INDEX of childNode " + childNode.toString() + " is " + i);
            return i;
        }
        return -1;
    }

    public DefaultMutableTreeNode removeBladeFromTopology(int deviceKey, DefaultMutableTreeNode topologyTree) {
        if (topologyTree != null) {
            int treeCount = topologyTree.getChildCount();
            int treeChildDeviceKey = -1;
            for (int i = 0; i < treeCount; ++i) {
                treeChildDeviceKey = (Integer)((DefaultMutableTreeNode)topologyTree.getChildAt(i)).getUserObject();
                if (treeChildDeviceKey != deviceKey) continue;
                topologyTree.remove(i);
                this.myNodeRelationshipManager.reLoadDeviceAssociations(deviceKey);
                break;
            }
        }
        TableModelHandler.notifyViewTopoHasChanged();
        return topologyTree;
    }

    public void printDebugTreeInformation(NodeAssociationsManager myNodeAssociationsManager, DefaultMutableTreeNode topologyTree, int deviceKey) {
        if (containerDeviceDebug.check(5)) {
            try {
                if (topologyTree != null) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"\n\n");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("                TOPOLOGY TREE    - for " + deviceKey));
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                    MxNode dev3 = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)((DefaultMutableTreeNode)topologyTree.getRoot()).getUserObject());
                    if (dev3 != null) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("----- " + dev3.getDeviceName() + "   (" + (Integer)((DefaultMutableTreeNode)topologyTree.getRoot()).getUserObject() + ")"));
                        int treeCount = topologyTree.getChildCount();
                        for (int i = 0; i < treeCount; ++i) {
                            MxNode dev1;
                            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)topologyTree.getChildAt(i);
                            if (childNode == null || (dev1 = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)childNode.getUserObject())) == null) continue;
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"  |   ");
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("   ----- " + dev1.getDeviceName() + "   (" + (Integer)childNode.getUserObject() + ") at Index : " + i));
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("   ----------- Top Neighbor : " + myNodeAssociationsManager.getNodeAssociations(dev1.getDeviceKey()).getTopNeighborDeviceKey()));
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("   ----------- Bot Neighbor : " + myNodeAssociationsManager.getNodeAssociations(dev1.getDeviceKey()).getBottomNeighborDeviceKey()));
                            for (int j = 0; j < childNode.getChildCount(); ++j) {
                                MxNode dev2;
                                DefaultMutableTreeNode childNode2 = (DefaultMutableTreeNode)childNode.getChildAt(j);
                                if (childNode2 == null || (dev2 = MxNodeController.getDefaultControllerNoEx().getNodeByKey((Integer)childNode2.getUserObject())) == null) continue;
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"    |     ");
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("     ----- " + dev2.getDeviceName() + "   (" + (Integer)childNode2.getUserObject() + ")"));
                            }
                        }
                    }
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"\n\n");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"         END  TOPOLOGY TREE              ");
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)"*****************************************");
                }
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    public String validateName(String nameToValidate) {
        if (nameToValidate.indexOf(32) != -1) {
            nameToValidate = nameToValidate.replace(' ', '_');
        }
        return nameToValidate;
    }

    public MxNode findOtherLogicalNode(MxNode enclNode, MxNode physicalNode, String asscType) {
        MxNode associatedServDevice = null;
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            Vector associatedDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(enclNode.getDeviceKey(), asscType);
            int associatedDeviceKey = 0;
            for (int index = 0; associatedDeviceKeyVect != null && index < associatedDeviceKeyVect.size(); ++index) {
                Integer vectKey = (Integer)associatedDeviceKeyVect.elementAt(index);
                associatedDeviceKey = vectKey;
                if (associatedDeviceKey == 0 || associatedDeviceKey == physicalNode.getDeviceKey() || (associatedServDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey)).getSerialNumber() != physicalNode.getSerialNumber()) continue;
                return associatedServDevice;
            }
        }
        catch (Exception e) {
            log_.debug((Object)("exception :" + e));
        }
        return null;
    }

    public void replaceLogicalNodeWithPhysicalNode(MxNode enclNode, MxNode physicalNode, MxNode logicalNode, String strEnclAssociationType) {
        if (enclNode == null || physicalNode == null || logicalNode == null || strEnclAssociationType == null) {
            return;
        }
        this.replaceNodeForThisAssociation(enclNode, physicalNode, logicalNode, strEnclAssociationType);
    }

    public void replaceNodeForThisAssociation(MxNode containeeNode, MxNode containerNode, MxNode nodeToBeReplaced, String strAssociationType) {
        this.cleanUpAssociationData(nodeToBeReplaced, strAssociationType);
        if (strAssociationType.compareToIgnoreCase("ServerToEnclosure") == 0) {
            this.myNodeRelationships.setTheAssociation(containeeNode.getDeviceKey(), containerNode.getDeviceKey(), strAssociationType, false);
        } else if (strAssociationType.compareToIgnoreCase("SwitchToEnclosure") == 0) {
            this.myNodeRelationships.setTheAssociation(containeeNode.getDeviceKey(), containerNode.getDeviceKey(), strAssociationType, false);
        } else {
            this.myNodeRelationships.setTheAssociation(containeeNode.getDeviceKey(), containerNode.getDeviceKey(), strAssociationType, true);
        }
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
    }

    private void cleanUpAssociationData(MxNode node, String strAssociationType) {
        try {
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), strAssociationType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

