/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OLBlade;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class OverlordServerHandler
extends SnmpRackMibHandler {
    private String associationType = "";

    public OverlordServerHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode serverNode, DeviceIdentificationData idInfo) {
        BladeIMELogger.log("In OverlordServerHandler.getAssocaitionData(" + serverNode + "," + idInfo + ")");
        if (!serverNode.getDeviceType().equals("Server")) {
            this.cleanUpAssociationData(serverNode);
            return;
        }
        String workingAddress = serverNode.getWorkingAddress();
        if (workingAddress == null) {
            BladeIMELogger.log("Overlord ServerHandler : Working Address is null for device : " + serverNode.getDeviceName());
            return;
        }
        if (serverNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            try {
                this.doEnclosureDeviceProcessing(serverNode);
                this.doILODeviceProcessing(serverNode);
                MxNode theEnclDevice = this.getAssociatedDeviceNode(serverNode, "ServerToEnclosure");
                MxNode theRackDevice = this.getAssociatedDeviceNode(theEnclDevice, "EnclosureToRack");
                serverNode.setEnclosureName(theEnclDevice.getDeviceName());
                serverNode.setRackName(theRackDevice.getDeviceName());
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverNode, false);
            }
            catch (Exception e) {
                BladeIMELogger.log("Overlors server handler :Exception:" + e);
                containerDeviceDebug.exception((Throwable)e);
            }
            finally {
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                OverlordServerHandler overlordServerHandler = this;
                overlordServerHandler.myNodeRelationshipManager.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        block20: {
            BladeIMELogger.log("OverlordServerHandler.loadAssociationDataFromDb(" + device + ")");
            BladeIMELogger.log("Node Name:" + device.getNameString());
            BladeIMELogger.log("Node DeviceType:" + device.getDeviceType());
            Statement myStatement = null;
            Connection myConnection = null;
            ResultSet myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            MxNode theDevice = null;
            try {
                theDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceDbKey);
            }
            catch (MxUndefinedNodeException ex1) {
                theDevice = null;
            }
            BladeIMELogger.log("OverlordServerHandler.loadAssociationDataFromDb:In Loading Device Associations for " + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                MxNode dev1 = null;
                if (deviceKey1 == deviceDbKey) {
                    dev1 = theDevice;
                } else {
                    try {
                        dev1 = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey1);
                    }
                    catch (MxUndefinedNodeException ex) {
                        dev1 = null;
                    }
                }
                BladeIMELogger.log("OverlordServerHandler.loadAssociationDataFromDb : load assn for " + deviceDbKey + " k1 " + deviceKey1 + " k2 " + deviceKey2 + " dev1 " + dev1);
                if (dev1 == null || !dev1.getDeviceType().equals("Server") && !dev1.getDeviceType().equals("Storage")) continue;
                if (associationTypeNumber.equalsIgnoreCase("ServerToEnclosure")) {
                    if (deviceKey1 != deviceDbKey) continue;
                    na.setInContainer(true);
                    na.setParent(deviceKey2);
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                    continue;
                }
                if (!associationTypeNumber.startsWith("MgmtProcToServer_Ilo")) continue;
                na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, true);
            }
            Object var14_15 = null;
            try {
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
            }
            catch (SQLException sqle) {
            }
            catch (Exception e) {
                // empty catch block
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            {
                break block20;
                catch (Exception nape) {
                    BladeIMELogger.log("OverlordServerHandler.loadAssociationDataFromDb: A Node Associations Persistence Exception: " + nape);
                    Object var14_16 = null;
                    try {
                        myResultSet.close();
                        myStatement.close();
                        myResultSet = null;
                        myStatement = null;
                    }
                    catch (SQLException sqle) {
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    myResultSet.close();
                    myStatement.close();
                    myResultSet = null;
                    myStatement = null;
                }
                catch (SQLException sqle) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                throw throwable;
            }
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    private void doEnclosureDeviceProcessing(MxNode servNode) {
        BladeIMELogger.log("OverlordServerHandler.doEnclosureDeviceProcessing(" + servNode + ")");
        String servUUID = null;
        MxNode enclosureNode = null;
        servUUID = servNode.getAgentUUID() != null && servNode.getAgentUUID().length() > 0 ? servNode.getAgentUUID() : servNode.getSerialNumber();
        try {
            OAHelper myOAHelper = OAHelper.getOAHelper();
            MxNode enclORDevice = myOAHelper.getDeviceNodeHavingProperty(servUUID);
            OLBlade myOLBlade = (OLBlade)myOAHelper.getOLDevice(servNode, enclORDevice);
            if (enclORDevice != null && enclORDevice.getDeviceType().equals("Enclosure")) {
                BladeIMELogger.log("Logical Node not created, data available on enclosure node");
                enclosureNode = enclORDevice;
                BladeIMELogger.log("Enclosure Device Key:" + enclosureNode.getDeviceKey());
                this.makeAssociation(servNode, enclosureNode.getDeviceKey());
                this.myNodeRelationships.setSlotNumber(myOLBlade.getDeviceSlot());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(myOLBlade.getDeviceSlotsInXDirection());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(myOLBlade.getDeviceSlotsInYDirection());
                this.myNodeRelationships.setMmHeight(myOLBlade.getDeviceHeight());
                this.myNodeRelationships.setMmWidth(myOLBlade.getDeviceWidth());
                this.myNodeRelationships.setMmDepth(myOLBlade.getDeviceDepth());
                this.myNodeRelationships.setInContainer(true);
                myOLBlade.move(servNode, enclORDevice);
                myOLBlade.remove(enclORDevice);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureNode, false);
            } else if (enclORDevice != null && enclORDevice.getDeviceType().equals("Server")) {
                BladeIMELogger.log("Logical Node present, hence take data from Logical node");
                if (enclORDevice.getDeviceKey() != servNode.getDeviceKey()) {
                    MxNode LogicalServerNode = enclORDevice;
                    enclosureNode = this.getAssociatedDeviceNode(LogicalServerNode, "ServerToEnclosure");
                    NodeAssociations thelogicalServerAssociations = null;
                    thelogicalServerAssociations = this.myNodeRelationshipManager.getNodeAssociations(LogicalServerNode.getDeviceKey());
                    this.myNodeRelationships.setSlotNumber(thelogicalServerAssociations.getSlotNumber());
                    this.myNodeRelationships.setNumBladeSlotsUsedXDir(thelogicalServerAssociations.getNumBladeSlotsUsedXDir());
                    this.myNodeRelationships.setNumBladeSlotsUsedYDir(thelogicalServerAssociations.getNumBladeSlotsUsedYDir());
                    this.myNodeRelationships.setMmHeight(thelogicalServerAssociations.getMmHeight());
                    this.myNodeRelationships.setMmWidth(thelogicalServerAssociations.getMmWidth());
                    this.myNodeRelationships.setMmDepth(thelogicalServerAssociations.getMmDepth());
                    this.makeAssociation(servNode, enclosureNode.getDeviceKey());
                    this.myNodeRelationships.setInContainer(true);
                    myOLBlade.move(servNode, enclORDevice);
                    this.cleanUpAssociationData(LogicalServerNode, "ServerToEnclosure");
                    myOLBlade.remove(enclORDevice);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureNode, false);
                } else {
                    BladeIMELogger.log("Logical Node & Physical Nodes are merged");
                }
            } else {
                this.checkNodeInDB(servNode);
            }
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
        }
        catch (Exception e) {
            BladeIMELogger.log("OverlordServerHandler.doEnclosureDeviceProcessing: Exception :" + e);
        }
    }

    public MxNode getAssociatedDeviceNode(MxNode deviceNode, String asscType) {
        BladeIMELogger.log("OverlordServerHandler.getOANodeFromEnclNode(" + deviceNode + "," + asscType + ")");
        MxNode associatedDevice = null;
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            // empty catch block
        }
        Vector associatedDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(deviceNode.getDeviceKey(), asscType);
        int associatedDeviceKey = 0;
        if (associatedDeviceKeyVect.size() > 0) {
            Integer vectKey = (Integer)associatedDeviceKeyVect.elementAt(0);
            associatedDeviceKey = vectKey;
            BladeIMELogger.log("associatedDeviceKey:" + associatedDeviceKey);
            try {
                associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
            }
            catch (MxUndefinedNodeException ex) {
                BladeIMELogger.log("Node not found");
            }
        }
        return associatedDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAssociation(MxNode serverNode, int theEnclDeviceKey) {
        BladeIMELogger.log("OverlordServerHandler.makeAssociation(" + serverNode + "," + theEnclDeviceKey + ")");
        BladeIMELogger.log("server Device Key:" + serverNode.getDeviceKey());
        BladeIMELogger.log("enclosure Device Key:" + theEnclDeviceKey);
        MxNode syncObject = serverNode;
        try {
            MxNode enclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
            BladeIMELogger.log("na:" + na);
            if (na != null) {
                syncObject = na;
            }
            MxNode mxNode = syncObject;
            synchronized (mxNode) {
                if (na != null) {
                    int myDeviceKey = serverNode.getDeviceKey();
                    this.myNodeRelationships.setTheAssociation(serverNode.getDeviceKey(), enclosureNode.getDeviceKey(), "ServerToEnclosure", false);
                    this.addDeviceToTopologyTree(na, serverNode.getDeviceKey());
                    this.myNodeRelationshipManager.update(na);
                    MxNode theRackDevice = this.getAssociatedDeviceNode(enclosureNode, "EnclosureToRack");
                    NodeAssociations theRackDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theRackDevice.getDeviceKey());
                    this.getRackInformation(theRackDevice.getDeviceName(), theRackDevice.getAgentUUID(), enclosureNode.getDeviceKey());
                    this.myNodeRelationshipManager.update(na);
                    NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(theRackDevice.getDeviceKey());
                    this.updateDevContainerAndRoleNames(theRackDevice);
                }
            }
        }
        catch (Exception e) {
            BladeIMELogger.log("OverlordServerHandler.makeAssociation: Exception :" + e);
        }
    }

    public void checkNodeInDB(MxNode d) {
        NodeAssociations dTmpNodeAssociations;
        BladeIMELogger.log("OverlordServerHandler.checkNodeInDB(" + d + ")");
        MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
        if (dTmp != null && (dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
            DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
            topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
            dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
            this.myNodeRelationshipManager.update(dTmpNodeAssociations);
        }
    }

    private void doILODeviceProcessing(MxNode servNode) {
        BladeIMELogger.log("OverlordServerHandler.doILODeviceProcessing(" + servNode + ")");
        String theRibSerialNo = null;
        int associatedDeviceKey = 0;
        try {
            List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), servNode.getAgentUUID());
            if (allDevicesWithThisProperty.size() > 0) {
                Iterator iter = allDevicesWithThisProperty.iterator();
                while (iter.hasNext()) {
                    Integer assocDeviceKey = (Integer)iter.next();
                    BladeIMELogger.log("assocDeviceKey:" + assocDeviceKey);
                    BladeIMELogger.log("servNode.getDeviceKey():" + servNode.getDeviceKey());
                    this.myNodeRelationships.setTheAssociation(assocDeviceKey.intValue(), servNode.getDeviceKey(), "MgmtProcToServer_Ilo", true);
                }
            } else {
                int isThisIloRilo;
                String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
                if (!snmpEnabled.equals("checked")) {
                    BladeIMELogger.log("Overlord Server to ILO Association skipped (SNMP DISABLED GLOBALLY) on" + servNode.getDeviceName());
                    return;
                }
                if (!servNode.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
                    BladeIMELogger.log("Overlord Server to ILO Association skipped ; snmp not detected on " + servNode.getDeviceName());
                    return;
                }
                theRibSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.232.9.2.2.15.0[1]", true);
                BladeIMELogger.log("OverlordServerHandler.doILODeviceProcessing : ILO Serial Number:" + theRibSerialNo);
                if (theRibSerialNo != null && theRibSerialNo.trim().length() > 0 && (associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(theRibSerialNo)) != 0 && (isThisIloRilo = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.21.0[1]", true)) == 7) {
                    MxNode MPDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
                    this.cleanUpAssociationData(MPDevice, "MgmtProcToServer_Ilo");
                    this.myNodeRelationships.setTheAssociation(servNode.getDeviceKey(), associatedDeviceKey, "MgmtProcToServer_Ilo", true);
                }
            }
        }
        catch (Exception e) {
            BladeIMELogger.log("exception:" + e);
        }
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        BladeIMELogger.log("OverlordServerHandler.buildContainerTree(" + myAssoc + "," + node1 + "," + node2 + ")");
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        BladeIMELogger.log("OverlordServerHandler.cleanUpAssociationData(" + d + ")");
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "MgmtProcToServer_Ilo");
            Vector assDeviceVector = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("ServerToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "ServerToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), "ServerToEnclosure");
            for (int i = 0; i < assDeviceVector.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)assDeviceVector.elementAt(i)).intValue());
            }
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }

    private void cleanUpAssociationData(MxNode node, String strAssociationType) {
        BladeIMELogger.log("OverlordServerHandler.cleanUpAssociationData(" + node + "," + strAssociationType + ")");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), strAssociationType);
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }
}

