/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.DiscoveryController;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.OAXml.ICMB;
import com.hp.mx.portal.OAXml.OADataManager;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OLDevice;
import com.hp.mx.portal.OAXml.OLEnclosure;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

public class OAAssociationHandler
extends RackEnclosureTopologyHandler {
    private static final Object syncObject = new Object();

    public OAAssociationHandler(MxNode oaMxNode) {
        super(oaMxNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode oaMxNode, DeviceIdentificationData deviceIdentificationData) {
        BladeIMELogger.log("OAAssociationHandler.getAssociationData(" + oaMxNode + "," + deviceIdentificationData + ")");
        BladeIMELogger.log("OAAssociationHandler.getAssociationData.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
        BladeIMELogger.log("oaMxNode.getModel() " + oaMxNode.getModel());
        BladeIMELogger.log("oaMxNode.getDeviceType() " + oaMxNode.getDeviceType());
        BladeIMELogger.log("oaMxNode has OA subtype " + oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()));
        BladeIMELogger.log("oaMxNode has cClass subtype " + oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString()));
        if (!oaMxNode.getDeviceType().equals("MgmtProc")) {
            BladeIMELogger.log("**********IT IS NOT A MANAGEMENT PROCESSOR CLEANUPASSOCIATION**********" + oaMxNode.getWorkingAddress());
            this.cleanUpAssociationData(oaMxNode);
            return;
        }
        try {
            while (true) {
                OAAssociationHandler oAAssociationHandler = this;
                if (oAAssociationHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                Thread.sleep(100L);
            }
            BladeIMELogger.log("**********IT IS A MANAGEMENT PROCESSOR**********" + oaMxNode.getWorkingAddress());
            if (oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()) && oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                BladeIMELogger.log("**********GETTING NEW ASSOCIATIONS FOR OA " + oaMxNode.getWorkingAddress() + "**********");
                OADataManager oaDataManager = new OADataManager(oaMxNode);
                BladeIMELogger.log("**********SUCCESSFULLY PARSED OAXML. NOW PERFORMING ASSOCIATIONS FOR OA " + oaMxNode.getWorkingAddress() + "**********");
                this.performAssociations(oaDataManager, oaMxNode);
                BladeIMELogger.log("**********SUCCESSFULLY PERFORMED ASSOCIATIONS FOR OA " + oaMxNode.getWorkingAddress() + "**********");
            }
        }
        catch (HandlerException e) {
            BladeIMELogger.log("****************UNABLE TO ASSOCIATE OA " + oaMxNode.getWorkingAddress() + " WITH ITS ENCLOSURE. PLEASE ENSURE OA XML HAS GOT ENCLOSURE UUID, RACK UUID AND RACK TOPOLOGY IN IT****************");
            BladeIMELogger.log(e, "HandlerException in OAAssociationHandler.getAssociationData: " + e);
        }
        catch (InterruptedException e) {
            BladeIMELogger.log("****************UNABLE TO GET RELATIONSHIP LOCK FOR OA " + oaMxNode.getWorkingAddress() + " PLEASE DISCOVER THIS OA AFTER SOMETIME****************");
            BladeIMELogger.log(e, "InterruptedException in OAAssociationHandler.getAssociationData: " + e);
        }
        catch (OAException e) {
            BladeIMELogger.log("********ERROR IN PARSING OA XML. PLEASE ENSURE OA " + oaMxNode.getWorkingAddress() + " IS UP AND HAS GOT LATEST FIRMWARE INSTALLED IN IT*********");
            BladeIMELogger.log(e, "OAException in OAAssociationHandler.getAssociationData: " + e);
        }
        finally {
            OAAssociationHandler oAAssociationHandler = this;
            oAAssociationHandler.myNodeRelationshipManager.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAssociations(OADataManager oaDataManager, MxNode oaMxNode) throws HandlerException {
        BladeIMELogger.log("OAAssociationHandler.performAssociations(" + oaDataManager + "," + oaMxNode + ")");
        NodeAssociations myEnclosureNodeAssociations = null;
        OLEnclosure olEnclosure = oaDataManager.getEnclosureDevice();
        Vector topology = null;
        Object object = syncObject;
        synchronized (object) {
            topology = this.getTopology(olEnclosure);
            String rackName = olEnclosure.getRackName();
            String rackUUID = olEnclosure.getRackUUID();
            myEnclosureNodeAssociations = this.getEnclosureInformation(this.getCurrentTopology(olEnclosure, topology), rackName, rackUUID);
            this.getRackInformation(rackName, rackUUID, myEnclosureNodeAssociations.getDeviceKey());
            if (this.getTheRackDevice() != null) {
                this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.CCLASS_SUBTYPE.toString());
            }
        }
        try {
            this.buildOAAssociation(olEnclosure, oaMxNode, myEnclosureNodeAssociations);
        }
        catch (OAException e) {
            BladeIMELogger.log("OAAssociationHandler.performAssociations : OAException " + e);
        }
        String DISCOVERY_ASSOCIATED_DEVICE_CHECK = GlobalSettings.getProperty((String)"obaDisc_enabled_state", (String)"checked");
        BladeIMELogger.log("OAAssociationHandler.performAssociations : DISCOVERY_ASSOCIATED_DEVICE_CHECK " + DISCOVERY_ASSOCIATED_DEVICE_CHECK);
        List bladeList = olEnclosure.getBladeList();
        List switchList = olEnclosure.getSwitchList();
        NodeAssociations nodeAssociations = myEnclosureNodeAssociations;
        synchronized (nodeAssociations) {
            this.updateEnclosureNode(olEnclosure, myEnclosureNodeAssociations);
            this.buildDeviceAssociations(olEnclosure, bladeList, myEnclosureNodeAssociations, "ServerToEnclosure", DISCOVERY_ASSOCIATED_DEVICE_CHECK);
            this.buildDeviceAssociations(olEnclosure, switchList, myEnclosureNodeAssociations, "SwitchToEnclosure", DISCOVERY_ASSOCIATED_DEVICE_CHECK);
            if (DISCOVERY_ASSOCIATED_DEVICE_CHECK.equalsIgnoreCase("checked")) {
                for (int i = 0; i < bladeList.size(); ++i) {
                    if (!OAAssociationHandler.isValidDevIP(((OLDevice)bladeList.get(i)).getDeviceMgmtProcIp())) continue;
                    this.triggerAutomaticDiscovery(((OLDevice)bladeList.get(i)).getDeviceMgmtProcIp());
                }
            }
        }
        nodeAssociations = this.getTheRackDevice();
        synchronized (nodeAssociations) {
            this.storeTopologyInformation(topology, this.getTheRackDevice());
        }
    }

    private Vector getTopology(OLEnclosure olEnclosure) {
        BladeIMELogger.log("OAAssociationHandler.buildTopology(" + olEnclosure + ")");
        Vector topology = new Vector(1, 2);
        Vector<String> tplgy = null;
        List icmbList = olEnclosure.getICMBList();
        ICMB icmb = null;
        for (int i = 0; i < icmbList.size(); ++i) {
            icmb = (ICMB)icmbList.get(i);
            tplgy = new Vector<String>(11, 2);
            tplgy.addElement(icmb.getUUID());
            if (icmb.getUUID().equalsIgnoreCase(olEnclosure.getEnclosureUUID())) {
                tplgy.addElement(olEnclosure.getEnclosureName());
            } else {
                tplgy.addElement("");
            }
            tplgy.addElement("");
            tplgy.addElement("");
            tplgy.addElement("true");
            tplgy.addElement("false");
            tplgy.addElement(icmb.getLeftUUID());
            tplgy.addElement(icmb.getRightUUID());
            tplgy.addElement(icmb.getSerialNumber());
            tplgy.addElement(icmb.getLeftSerialNumber());
            tplgy.addElement(icmb.getRightSerialNumber());
            topology.addElement(tplgy);
        }
        return topology;
    }

    private Vector getCurrentTopology(OLEnclosure olEnclosure, Vector topology) throws HandlerException {
        BladeIMELogger.log("OAAssociationHandler.getCurrentTopology(" + olEnclosure + "," + topology + ")");
        Vector tplgy = null;
        String uuid = null;
        for (int i = 0; i < topology.size(); ++i) {
            tplgy = (Vector)topology.get(i);
            uuid = (String)tplgy.get(0);
            if (!uuid.equalsIgnoreCase(olEnclosure.getEnclosureUUID())) continue;
            return tplgy;
        }
        throw new HandlerException("Unable to get current topology information");
    }

    private void buildOAAssociation(OLEnclosure olEnclosure, MxNode oaMxNode, NodeAssociations myEnclosureNodeAssociations) throws OAException {
        BladeIMELogger.log("OAAssociationHandler.buildOAAssociation(" + olEnclosure + "," + oaMxNode + "," + myEnclosureNodeAssociations + ")");
        int enclosureDeviceKey = myEnclosureNodeAssociations.getDeviceKey();
        int oaDeviceKey = oaMxNode.getDeviceKey();
        BladeIMELogger.log("OAAssociationHandler.buildOAAssociation : enclosureDeviceKey " + enclosureDeviceKey);
        BladeIMELogger.log("OAAssociationHandler.buildOAAssociation : oaDeviceKey " + oaDeviceKey);
        OLDevice olDevice = olEnclosure.resolveCurrentOADevice(oaMxNode.getWorkingAddress());
        BladeIMELogger.log("OAAssociationHandler.buildOAAssociation : olDevice.getDeviceMgmtProcIp() " + olDevice.getDeviceMgmtProcIp());
        BladeIMELogger.log("OAAssociationHandler.buildOAAssociation : olDevice.getDeviceUUID() " + olDevice.getDeviceUUID());
        this.myNodeRelationships.setInContainer(true);
        this.myNodeRelationships.setParent(enclosureDeviceKey);
        this.myNodeRelationships.setSource("Enclosure");
        this.myNodeRelationships.setSlotNumber(olDevice.getDeviceSlot());
        this.myNodeRelationships.setMmHeight(olDevice.getDeviceHeight());
        this.myNodeRelationships.setMmWidth(olDevice.getDeviceWidth());
        this.myNodeRelationships.setMmDepth(olDevice.getDeviceDepth());
        int slotsUsedInXDirection = olDevice.getDeviceSlotsInXDirection();
        int slotsUsedInYDirection = olDevice.getDeviceSlotsInYDirection();
        this.myNodeRelationships.setNumBladeSlotsUsedYDir(1);
        if (slotsUsedInXDirection > 0 && slotsUsedInYDirection > 0) {
            this.myNodeRelationships.setNumBladeSlotsUsedXDir(slotsUsedInXDirection);
            this.myNodeRelationships.setNumBladeSlotsUsedYDir(slotsUsedInYDirection);
            this.myNodeRelationships.setNumBladeSlotsUsed(slotsUsedInXDirection * slotsUsedInYDirection);
        }
        if (this.myNodeRelationships.getSlotNumber() != -1) {
            this.removeOldDeviceAssociationsFromThisSlot(this.myNodeRelationships, myEnclosureNodeAssociations, "MgmtProc");
            this.myNodeRelationships.setTheAssociation(oaDeviceKey, enclosureDeviceKey, "MgmtProcToEnclosure", false);
        }
        if (oaMxNode.getAgentUUID() == null || oaMxNode.getAgentUUID().trim().length() == 0) {
            oaMxNode.setAgentUUID(olDevice.getDeviceUUID());
        }
        oaMxNode.setSerialNumber(olDevice.getDeviceSerialNumber());
        oaMxNode.setEnclosureName(olEnclosure.getEnclosureName());
        oaMxNode.setRackName(olEnclosure.getRackName());
        MxNode enclosureMxNode = olEnclosure.getDeviceMxNode();
        olDevice.update(oaMxNode, enclosureMxNode);
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        this.addDeviceToTopologyTree(myEnclosureNodeAssociations, oaDeviceKey);
    }

    private void updateEnclosureNode(OLEnclosure olEnclosure, NodeAssociations myEnclosureNodeAssociations) {
        BladeIMELogger.log("OAAssociationHandler.updateEnclosureNode(" + olEnclosure + "," + myEnclosureNodeAssociations + ")");
        myEnclosureNodeAssociations.setMaxNumItemsXDir(8);
        myEnclosureNodeAssociations.setMaxNumItemsYDir(2);
        myEnclosureNodeAssociations.setMaxNumItems(16);
        myEnclosureNodeAssociations.setSource("Enclosure");
        myEnclosureNodeAssociations.setMmHeight(olEnclosure.getEnclosureHeight());
        myEnclosureNodeAssociations.setMmWidth(olEnclosure.getEnclosureWidth());
        myEnclosureNodeAssociations.setMmDepth(olEnclosure.getEnclosureDepth());
        this.myNodeRelationshipManager.update(myEnclosureNodeAssociations);
        try {
            MxNode enclosureMxNode = olEnclosure.getDeviceMxNode();
            enclosureMxNode.setModel(olEnclosure.getEnclosureProductName());
            enclosureMxNode.setAssetNumber(olEnclosure.getEnclosureAsset());
            olEnclosure.update(enclosureMxNode);
        }
        catch (OAException e) {
            BladeIMELogger.log(e, "OAAssociationHandler.updateEnclosureNode : OAException " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDeviceAssociations(OLEnclosure olEnclosure, List deviceList, NodeAssociations myEnclosureNodeAssociations, String ASSOCIATION_TYPE, String DISCOVERY_ASSOCIATED_DEVICE_CHECK) {
        BladeIMELogger.log("OAAssociationHandler.buildDeviceAssociations(" + olEnclosure + "," + deviceList + "," + myEnclosureNodeAssociations + "," + ASSOCIATION_TYPE + "," + DISCOVERY_ASSOCIATED_DEVICE_CHECK + ")");
        String enclosureName = olEnclosure.getEnclosureName();
        String rackName = olEnclosure.getRackName();
        OLDevice olDevice = null;
        for (int i = 0; i < deviceList.size(); ++i) {
            olDevice = (OLDevice)deviceList.get(i);
            BladeIMELogger.log("OAAssociationHandler.buildDeviceAssociations : olDevice " + olDevice);
            if (!olDevice.isUniqueIdentifierExists()) {
                BladeIMELogger.log("OAAssociationHandler.buildDeviceAssociations : No Unique Identifier. Skipping Node Creation");
                continue;
            }
            MxNode deviceMxNode = olDevice.getDeviceMxNode();
            BladeIMELogger.log("OAAssociationHandler.buildDeviceAssociations : deviceMxNode " + deviceMxNode);
            if (deviceMxNode == null && DISCOVERY_ASSOCIATED_DEVICE_CHECK.equalsIgnoreCase("checked")) {
                deviceMxNode = this.createBareMetalDevice(olDevice, olEnclosure);
            }
            BladeIMELogger.log("OAAssociationHandler.buildDeviceAssociations : deviceMxNode " + deviceMxNode);
            if (deviceMxNode != null) {
                MxNode mxNode = deviceMxNode;
                synchronized (mxNode) {
                    this.performDeviceAssociation(olDevice, deviceMxNode, myEnclosureNodeAssociations, ASSOCIATION_TYPE, olEnclosure);
                }
            }
            MxNode enclosureMxNode = null;
            try {
                enclosureMxNode = olEnclosure.getDeviceMxNode();
            }
            catch (OAException e) {
                BladeIMELogger.log(e, "OAAssociationHandler.buildDeviceAssociations : OAException " + e);
            }
            olDevice.update(deviceMxNode, enclosureMxNode);
        }
    }

    private void performDeviceAssociation(OLDevice olDevice, MxNode deviceMxNode, NodeAssociations myEnclosureNodeAssociations, String ASSOCIATION_TYPE, OLEnclosure olEnclosure) {
        BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation(" + olDevice + "," + deviceMxNode + "," + myEnclosureNodeAssociations + "," + ASSOCIATION_TYPE + "," + olEnclosure + ")");
        int deviceKey = deviceMxNode.getDeviceKey();
        BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : deviceKey " + deviceKey);
        int enclosureDeviceKey = myEnclosureNodeAssociations.getDeviceKey();
        BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : enclosureDeviceKey " + enclosureDeviceKey);
        NodeAssociations myDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(deviceKey);
        BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : myDeviceNodeAssociations " + myDeviceNodeAssociations);
        if (myDeviceNodeAssociations == null) {
            BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : Creating new myDeviceNodeAssociations");
            myDeviceNodeAssociations = new NodeAssociations(deviceKey);
            BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : myDeviceNodeAssociations " + myDeviceNodeAssociations);
        }
        int DEVICE_OLD_SLOT = myDeviceNodeAssociations.getSlotNumber();
        BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : DEVICE_OLD_SLOT " + DEVICE_OLD_SLOT);
        BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : Creating new association for " + olDevice.getDeviceUUID());
        deviceMxNode.setEnclosureName(olEnclosure.getEnclosureName());
        deviceMxNode.setRackName(olEnclosure.getRackName());
        int slotsUsedInXDirection = olDevice.getDeviceSlotsInXDirection();
        int slotsUsedInYDirection = olDevice.getDeviceSlotsInYDirection();
        myDeviceNodeAssociations.setNumBladeSlotsUsedYDir(1);
        if (slotsUsedInXDirection > 0 && slotsUsedInYDirection > 0) {
            myDeviceNodeAssociations.setNumBladeSlotsUsedXDir(slotsUsedInXDirection);
            myDeviceNodeAssociations.setNumBladeSlotsUsedYDir(slotsUsedInYDirection);
            myDeviceNodeAssociations.setNumBladeSlotsUsed(slotsUsedInXDirection * slotsUsedInYDirection);
        }
        myDeviceNodeAssociations.setInContainer(true);
        myDeviceNodeAssociations.setParent(enclosureDeviceKey);
        myDeviceNodeAssociations.setSource("Enclosure");
        myDeviceNodeAssociations.setSlotNumber(olDevice.getDeviceSlot());
        myDeviceNodeAssociations.setMmHeight(olDevice.getDeviceHeight());
        myDeviceNodeAssociations.setMmWidth(olDevice.getDeviceWidth());
        myDeviceNodeAssociations.setMmDepth(olDevice.getDeviceDepth());
        if (myDeviceNodeAssociations.getSlotNumber() != -1) {
            this.removeOldDeviceAssociationsFromThisSlot(myDeviceNodeAssociations, myEnclosureNodeAssociations, olDevice.getDeviceType());
            myDeviceNodeAssociations.setTheAssociation(deviceKey, enclosureDeviceKey, ASSOCIATION_TYPE, false);
        }
        this.myNodeRelationshipManager.update(myDeviceNodeAssociations);
        this.updateDeviceDimensionInfo(myDeviceNodeAssociations);
        this.addDeviceToTopologyTree(myEnclosureNodeAssociations, deviceKey);
        try {
            String modifiedDeviceName = this.getModifiedLogicalDeviceName(olDevice, olEnclosure, deviceMxNode.getDeviceName(), DEVICE_OLD_SLOT);
            BladeIMELogger.log("OAAssociationHandler.performDeviceAssociation : modifiedDeviceName " + modifiedDeviceName);
            deviceMxNode.setDeviceName(modifiedDeviceName);
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), deviceMxNode, false);
        }
        catch (HandlerException e) {
            BladeIMELogger.log(e);
        }
        catch (MxException e) {
            BladeIMELogger.log((Exception)((Object)e), "OAAssociationHandler.performDeviceAssociation : Failed. Device Serial Number is " + deviceMxNode.getSerialNumber() + " MxException " + (Object)((Object)e));
        }
    }

    private MxNode createBareMetalDevice(OLDevice olDevice, OLEnclosure olEnclosure) {
        BladeIMELogger.log("OAAssociationHandler.createBareMetalDevice(" + olDevice + "," + olEnclosure + ")");
        MxNode deviceMxNode = new MxNode();
        deviceMxNode.setAgentUUID(olDevice.getDeviceUUID());
        deviceMxNode.setDeviceType(olDevice.getDeviceType());
        deviceMxNode.setSerialNumber(olDevice.getDeviceSerialNumber());
        deviceMxNode.setSnoozeTime(-3);
        deviceMxNode.setSnmpTimeOut(new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"5")).intValue());
        deviceMxNode.setSnmpRetry(new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2")).intValue());
        deviceMxNode.setIcmpTimeOut(new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"5")).intValue());
        deviceMxNode.setIcmpRetry(new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2")).intValue());
        int defaultsMask = 255;
        deviceMxNode.setDefaultsMask(true, defaultsMask);
        deviceMxNode.setModel(olDevice.getDeviceProductName());
        deviceMxNode.setDeviceSubTypes(olDevice.getSubTypeList());
        try {
            deviceMxNode.setDeviceName(this.getNewLogicalDeviceName(olDevice, olEnclosure));
            MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), deviceMxNode);
            return deviceMxNode;
        }
        catch (MxException e) {
            BladeIMELogger.log("OAAssociationHandler.createBareMetalDevice : Failed. Device Serial Number is " + olDevice.getDeviceUUID() + " MxException " + (Object)((Object)e));
            return null;
        }
    }

    private String getNewLogicalDeviceName(OLDevice olDevice, OLEnclosure olEnclosure) {
        BladeIMELogger.log("OAAssociationHandler.getNewLogicalDeviceName(" + olDevice + "," + olEnclosure + ")");
        String NEW_LOGICAL_DEVICE_NAME_BY_SLOT = this.getLogicalDeviceNameBySlotNumber(olDevice, olEnclosure);
        BladeIMELogger.log("OAAssociationHandler.getNewLogicalDeviceName.NEW_LOGICAL_DEVICE_NAME_BY_SLOT " + NEW_LOGICAL_DEVICE_NAME_BY_SLOT);
        MxNode otherMxNode = MxNodeController.getDefaultControllerNoEx().getDeviceByName(NEW_LOGICAL_DEVICE_NAME_BY_SLOT);
        BladeIMELogger.log("OAAssociationHandler.getNewLogicalDeviceName.otherMxNode " + otherMxNode);
        if (otherMxNode != null) {
            String NEW_LOGICAL_DEVICE_NAME_BY_SERIAL_NUM = this.getLogicalDeviceNameBySerialNumber(olDevice, olEnclosure);
            BladeIMELogger.log("OAAssociationHandler.getNewLogicalDeviceName.Finally returning logical node name by serial number " + NEW_LOGICAL_DEVICE_NAME_BY_SERIAL_NUM);
            return NEW_LOGICAL_DEVICE_NAME_BY_SERIAL_NUM;
        }
        BladeIMELogger.log("OAAssociationHandler.getNewLogicalDeviceName.Finally returning logical node name by slot number " + NEW_LOGICAL_DEVICE_NAME_BY_SLOT);
        return NEW_LOGICAL_DEVICE_NAME_BY_SLOT;
    }

    private String getLogicalDeviceNameBySlotNumber(OLDevice olDevice, OLEnclosure olEnclosure) {
        BladeIMELogger.log("OAAssociationHandler.getLogicalDeviceNameBySlotNumber(" + olDevice + "," + olEnclosure + ")");
        StringBuffer logicalDeviceNameBuffer = this.getLogicalDeviceNameStartString(olEnclosure);
        logicalDeviceNameBuffer.append(olDevice.getDeviceSlot());
        logicalDeviceNameBuffer.append("-");
        logicalDeviceNameBuffer.append(olDevice.getDeviceSide());
        return logicalDeviceNameBuffer.toString();
    }

    private String getLogicalDeviceNameBySerialNumber(OLDevice olDevice, OLEnclosure olEnclosure) {
        BladeIMELogger.log("OAAssociationHandler.getLogicalDeviceNameBySerialNumber(" + olDevice + "," + olEnclosure + ")");
        StringBuffer logicalDeviceNameBuffer = this.getLogicalDeviceNameStartString(olEnclosure);
        logicalDeviceNameBuffer.append(olDevice.getDeviceSerialNumber());
        return logicalDeviceNameBuffer.toString();
    }

    private String getModifiedLogicalDeviceName(OLDevice olDevice, OLEnclosure olEnclosure, String DEVICE_NAME, int DEVICE_OLD_SLOT) throws HandlerException {
        BladeIMELogger.log("OAAssociationHandler.getModifiedLogicalDeviceName(" + olDevice + "," + olEnclosure + "," + DEVICE_NAME + "," + DEVICE_OLD_SLOT + ")");
        if (DEVICE_NAME.startsWith("Serv_")) {
            BladeIMELogger.log("OAAssociationHandler.getModifiedLogicalDeviceName.ILO BARE METAL SERVER NAME " + DEVICE_NAME);
            return this.getNewLogicalDeviceName(olDevice, olEnclosure);
        }
        if (DEVICE_NAME.endsWith(olDevice.getDeviceSerialNumber())) {
            BladeIMELogger.log("OAAssociationHandler.getModifiedLogicalDeviceName.DEVICE NAME ENDS WITH SERIAL NUMBER " + DEVICE_NAME);
            return this.getNewLogicalDeviceName(olDevice, olEnclosure);
        }
        BladeIMELogger.log("OAAssociationHandler.getModifiedLogicalDeviceName.DEVICE_OLD_SLOT " + DEVICE_OLD_SLOT);
        BladeIMELogger.log("OAAssociationHandler.getModifiedLogicalDeviceName.olDevice.getDeviceSlot() " + olDevice.getDeviceSlot());
        if (DEVICE_NAME.endsWith(olDevice.getDeviceSide()) && DEVICE_OLD_SLOT > 0 && olDevice.getDeviceSlot() != DEVICE_OLD_SLOT) {
            BladeIMELogger.log("OAAssociationHandler.getModifiedLogicalDeviceName.DEVICE SLOT NUMBER HAS CHANGED " + DEVICE_NAME);
            return this.getNewLogicalDeviceName(olDevice, olEnclosure);
        }
        if (DEVICE_NAME.endsWith(olDevice.getDeviceSide()) && !DEVICE_NAME.startsWith(this.getLogicalDeviceNameStartString(olEnclosure).toString())) {
            BladeIMELogger.log("OAAssociationHandler.getModifiedLogicalDeviceName.DEVICE NAME HAS DIFFERENT RACK/ENCLOSURE NAME " + DEVICE_NAME);
            return this.getNewLogicalDeviceName(olDevice, olEnclosure);
        }
        throw new HandlerException("OAAssociationHandler.getModifiedLogicalDeviceName - No change in device name");
    }

    private StringBuffer getLogicalDeviceNameStartString(OLEnclosure olEnclosure) {
        BladeIMELogger.log("OAAssociationHandler.getLogicalDeviceNameStartString(" + olEnclosure + ")");
        StringBuffer logicalDeviceNameBuffer = new StringBuffer();
        logicalDeviceNameBuffer.append(olEnclosure.getRackName());
        logicalDeviceNameBuffer.append("_");
        logicalDeviceNameBuffer.append(olEnclosure.getEnclosureName());
        logicalDeviceNameBuffer.append("_");
        return logicalDeviceNameBuffer;
    }

    private static boolean isValidDevIP(String DEVICE_IP_ADDRESS) {
        boolean isValidIP = false;
        if (!DEVICE_IP_ADDRESS.equalsIgnoreCase("0.0.0.0")) {
            isValidIP = true;
        }
        return isValidIP;
    }

    private void triggerAutomaticDiscovery(String DEVICE_IP_ADDRESS) {
        BladeIMELogger.log("triggerAutomaticDiscovery(" + DEVICE_IP_ADDRESS + ")");
        try {
            MxNode deviceMxNode = new MxNode();
            deviceMxNode.addIPAddress(DEVICE_IP_ADDRESS);
            DiscoveryController.getDefaultController().discoverASystem((MxTransaction)new MxCoreTransaction(), deviceMxNode, true, "ID", false);
        }
        catch (MxException e) {
            BladeIMELogger.log((Exception)((Object)e), "OAAssociationHandler.triggerAutomaticDiscovery : Failed. DEVICE_IP_ADDRESS " + DEVICE_IP_ADDRESS + " MxException " + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode oaMxNode) {
        NodeAssociations myNodeRelationships;
        block25: {
            ResultSet myResultSet;
            Connection myConnection;
            Statement myStatement;
            block23: {
                BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb(" + oaMxNode + ")");
                BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
                myStatement = null;
                myConnection = null;
                myResultSet = null;
                int oaDeviceKey = oaMxNode.getDeviceKey();
                myNodeRelationships = this.myNodeRelationshipManager.getNodeAssociations(oaDeviceKey, true);
                BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.In Loading Device Associations for " + oaDeviceKey);
                if (oaMxNode == null || !oaMxNode.getDeviceType().equals("MgmtProc") || !oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString()) || !oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) break block23;
                BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.Started loading Device Associations for " + oaDeviceKey);
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + oaDeviceKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now");
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now deviceKey1 " + deviceKey1);
                    BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now deviceKey2 " + deviceKey2);
                    BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.Loading Associations now associationTypeNumber " + associationTypeNumber);
                    myNodeRelationships.setInContainer(true);
                    myNodeRelationships.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                    myNodeRelationships.setParent(deviceKey2);
                }
                BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb.Loading Dimension Info now");
                myNodeRelationships = this.myNodeRelationshipManager.loadDeviceDimensionInfo(oaDeviceKey, myNodeRelationships);
                this.myNodeRelationshipManager.update(myNodeRelationships);
                BladeIMELogger.log("loaded, In container flag is now " + myNodeRelationships.inContainer() + " parent " + myNodeRelationships.getParent());
            }
            Object var11_12 = null;
            try {
                if (myResultSet != null) {
                    myResultSet.close();
                }
                if (myStatement != null) {
                    myStatement.close();
                }
            }
            catch (SQLException sqle) {
            }
            catch (Exception e) {
                // empty catch block
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            {
                break block25;
                catch (SQLException sqlException) {
                    BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb : SQLException " + sqlException);
                    Object var11_13 = null;
                    try {
                        if (myResultSet != null) {
                            myResultSet.close();
                        }
                        if (myStatement != null) {
                            myStatement.close();
                        }
                    }
                    catch (SQLException sqle) {
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    break block25;
                }
                catch (Exception exception) {
                    BladeIMELogger.log("OAAssociationHandler.loadAssociationDataFromDb : Exception " + exception);
                    Object var11_14 = null;
                    try {
                        if (myResultSet != null) {
                            myResultSet.close();
                        }
                        if (myStatement != null) {
                            myStatement.close();
                        }
                    }
                    catch (SQLException sqle) {
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    if (myResultSet != null) {
                        myResultSet.close();
                    }
                    if (myStatement != null) {
                        myStatement.close();
                    }
                }
                catch (SQLException sqle) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                throw throwable;
            }
        }
        return myNodeRelationships;
    }

    public NodeAssociations buildContainerTree(NodeAssociations tempMyNodeRelationships, MxNode oaMxNode, MxNode enclosureMxNode) {
        BladeIMELogger.log("OAAssociationHandler.buildContainerTree(" + tempMyNodeRelationships + "," + oaMxNode + "," + enclosureMxNode + ")");
        BladeIMELogger.log("OAAssociationHandler.buildContainerTree.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(enclosureMxNode.getDeviceKey()), oaMxNode.getDeviceKey());
        tempMyNodeRelationships.setInContainer(true);
        tempMyNodeRelationships.setParent(enclosureMxNode.getDeviceKey());
        return tempMyNodeRelationships;
    }

    public void cleanUpAssociationData(MxNode oaMxNode) {
        BladeIMELogger.log("OAAssociationHandler.cleanUpAssociationData(" + oaMxNode + ")");
        BladeIMELogger.log("OAAssociationHandler.cleanUpAssociationData.WORKING_ADDRESS " + oaMxNode.getWorkingAddress());
        try {
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(oaMxNode.getDeviceKey(), "MgmtProcToEnclosure");
            Vector associatedDeviceKeyList = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("MgmtProcToEnclosure");
            for (int i = 0; i < associatedDeviceKeyList.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)associatedDeviceKeyList.elementAt(i)).intValue());
            }
        }
        catch (Exception e) {
            BladeIMELogger.log("OAAssociationHandler.cleanUpAssociationData : Exception " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getXMLData(MxNode oaMxNode) {
        StringBuffer xmlBuffer;
        block12: {
            BladeIMELogger.log("OAAssociationHandler.getXMLData(" + oaMxNode + ")");
            BufferedReader br = null;
            xmlBuffer = new StringBuffer();
            String workingAddress = oaMxNode.getWorkingAddress();
            BladeIMELogger.log("OAAssociationHandler.getXMLData.workingAddress " + workingAddress);
            br = new BufferedReader(new FileReader("C:\\Program Files\\HP\\Systems Insight Manager\\hpwebadmin\\webapps\\ROOT\\mxportal\\bladeime\\OA\\" + workingAddress + ".xml"));
            String line = null;
            while ((line = br.readLine()) != null) {
                xmlBuffer.append(line);
            }
            Object var6_6 = null;
            try {
                if (br != null) {
                    br.close();
                }
                break block12;
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (Exception e) {
                    BladeIMELogger.log(e, "OAAssociationHandler.getXMLData.Exception while reading " + workingAddress + ".xml file " + e);
                    Object var6_7 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block12;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return xmlBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDeviceDimensionInfo(NodeAssociations na) {
        BladeIMELogger.log("Start:updateDeviceDimensionInfo()");
        MxNode d = null;
        try {
            d = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(na.getDeviceKey());
        }
        catch (MxUndefinedNodeException ex) {
            // empty catch block
        }
        BladeIMELogger.log("Name:" + d.getNameString());
        BladeIMELogger.log("DeviceType:" + d.getDeviceType());
        if (d == null) return;
        if (!d.getDeviceType().equals("Storage")) {
            return;
        }
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int bladeSlot = na.getSlotNumber();
        int bladeHeight = na.getMmHeight();
        int bladeWidth = na.getMmWidth();
        int bladeDepth = na.getMmDepth();
        int maxNumBlades = na.getMaxNumItems();
        int bladeSlotsUsed = na.getNumBladeSlotsUsed();
        int maxNumBladesXDir = na.getMaxNumItemsXDir();
        int maxNumBladesYDir = na.getMaxNumItemsYDir();
        int bladeSlotsUsedXDir = na.getNumBladeSlotsUsedXDir();
        int bladeSlotsUsedYDir = na.getNumBladeSlotsUsedYDir();
        int switchesPresent = na.getSwitchesPresent();
        String source = na.getSource();
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("NodeAssociationsRepostitoryManager");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from deviceDimensionInfo where DeviceKey=" + na.getDeviceKey());
            if (myResultSet.next()) {
                int slot = myResultSet.getInt(2);
                int height = myResultSet.getInt(3);
                int width = myResultSet.getInt(4);
                int depth = myResultSet.getInt(5);
                int slotsUsed = myResultSet.getInt(7);
                int slotsUsedXDir = myResultSet.getInt(11);
                int slotsUsedYDir = myResultSet.getInt(12);
                boolean dimensionInfoChanged = false;
                if (slot != bladeSlot && bladeSlot != -1) {
                    dimensionInfoChanged = true;
                }
                if (height != bladeHeight && bladeHeight != -1) {
                    dimensionInfoChanged = true;
                }
                if (width != bladeWidth && bladeWidth != -1) {
                    dimensionInfoChanged = true;
                }
                if (depth != bladeDepth && bladeDepth != -1) {
                    dimensionInfoChanged = true;
                }
                if (slotsUsed != bladeSlotsUsed && (bladeSlotsUsed != 1 || slotsUsed == 0)) {
                    dimensionInfoChanged = true;
                }
                if (slotsUsedXDir != bladeSlotsUsedXDir && (bladeSlotsUsedXDir != 1 || slotsUsedXDir == 0)) {
                    dimensionInfoChanged = true;
                }
                if (slotsUsedYDir != bladeSlotsUsedYDir && (bladeSlotsUsedYDir != 1 || slotsUsedYDir == 0)) {
                    dimensionInfoChanged = true;
                }
                if (dimensionInfoChanged) {
                    myStatement.executeUpdate("update deviceDimensionInfo set Slot=" + bladeSlot + ",Height=" + bladeHeight + ",Width=" + bladeWidth + ",Depth=" + bladeDepth + ",MaxNumItems=" + maxNumBlades + ",NumBladeSlotsUsed=" + bladeSlotsUsed + ",SwitchesPresent=" + switchesPresent + ",MaxNumItemsXDir=" + maxNumBladesXDir + ",MaxNumItemsYDir=" + maxNumBladesYDir + ",SlotsUsedXDir=" + bladeSlotsUsedXDir + ",SlotsUsedYDir=" + bladeSlotsUsedYDir + ",Source='" + source + "' where DeviceKey=" + d.getDeviceKey());
                }
                myResultSet.close();
                myResultSet = null;
                myStatement.close();
                myStatement = null;
            } else {
                myResultSet.close();
                myResultSet = null;
                myStatement.close();
                myStatement = null;
                myStatement = myConnection.createStatement();
                String insertStmt = "insert into deviceDimensionInfo (DeviceKey,Slot,Height,Width,Depth,MaxNumItems,NumBladeSlotsUsed,SwitchesPresent,MaxNumItemsXDir,MaxNumItemsYDir,SlotsUsedXDir,SlotsUsedYDir,Source) ";
                myStatement.executeUpdate(insertStmt + "values(" + na.getDeviceKey() + "," + bladeSlot + "," + bladeHeight + "," + bladeWidth + "," + bladeDepth + "," + maxNumBlades + "," + bladeSlotsUsed + "," + switchesPresent + "," + maxNumBladesXDir + "," + maxNumBladesYDir + "," + bladeSlotsUsedXDir + "," + bladeSlotsUsedYDir + ",'" + source + "')");
            }
            this.releaseConnections(myConnection, myStatement, myResultSet);
            return;
        }
        catch (SQLException myException) {
            return;
        }
        finally {
            this.releaseConnections(myConnection, myStatement, myResultSet);
        }
    }

    private void releaseConnections(Connection myConnection, Statement myStatement, ResultSet myResultSet) {
        if (myResultSet != null) {
            try {
                myResultSet.close();
            }
            catch (SQLException myException) {
                // empty catch block
            }
        }
        if (myStatement != null) {
            try {
                myStatement.close();
            }
            catch (SQLException myException) {
                // empty catch block
            }
        }
        if (myConnection != null) {
            try {
                DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
            }
            catch (SQLException myException) {
                // empty catch block
            }
        }
    }
}

