/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.DeviceUrlType;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.nodemanager.NodeUrlTypeManager;
import com.hp.mx.core.protocol.snmp.SnmpRequest;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.core.tools.identification.mgmtproc.MgmtProcessorParser;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.nodesecurity.MxNodeSecurityHandler;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Element;

public class HurricaneAssociationDataHandler
extends RackEnclosureTopologyHandler {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private int associatedDeviceKey = 0;
    private String rackName = null;
    private String rUid = null;
    private String enclSerNo = null;
    private String enclosureName = null;
    private String enclUuid = null;
    private int numSlotsX = -1;
    private int numSlotsY = -1;
    private int bladeSlot = -1;
    private int bladeHeight = -1;
    private int bladeWidth = -1;
    private int bladeDepth = -1;
    private int maxNumBlades = 0;
    private int maxNumBladesX = 0;
    private int maxNumBladesY = 1;
    private String associationType = "";
    private Vector topology = new Vector();
    private int serverEnclosureIndex = -1;
    private NodeAssociations myServerNodeAssociations = null;
    private NodeAssociations myEnclosureNodeAssociations = null;
    private MxNode m_MPNode = null;
    private MxNode serverNode = null;
    private String strClientAttrib = MP_IPF_UUID;
    private static String MP_PA_SWID = new String("MP_PA_SWID");
    private static String MP_IPF_UUID = new String("MP_IPF_UUID");
    private static int IPF_UUID_FORMATED_LENGTH = 36;

    public HurricaneAssociationDataHandler(MxNode node) {
        super(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode node, DeviceIdentificationData idInfo) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"HurricaneAsociationDataHandler:getAssociatedData");
            m_log.debug((Object)("node.getModel():" + node.getModel()));
        }
        try {
            if (node.getDeviceType().equals("MgmtProc") && (node.getModel().toLowerCase().equals("integrated lights-out (ilo) for integrity and hp9000") || node.getModel().toLowerCase().equals("hp single partition server, management processor"))) {
                m_log.debug((Object)"in Hurricane association: mgmt node");
                SnmpRequest snmpReq = this.isSNMPAvailable(node);
                if (snmpReq == null) {
                    return;
                }
                this.m_MPNode = node;
            } else {
                if (!node.getDeviceType().equals("Server")) {
                    m_log.debug((Object)"In Hurricane Association:Not a server Node");
                    return;
                }
                String modelLower = node.getModel().toLowerCase();
                if (modelLower.indexOf("bl60p") == -1) {
                    m_log.debug((Object)"Not a hurricane Blade");
                    return;
                }
                m_log.debug((Object)"server node");
                this.serverNode = node;
                this.m_MPNode = this.FindOtherNode(this.serverNode);
                if (this.m_MPNode == null) {
                    m_log.debug((Object)"MP for Hurricane Blade not found, hence can not associate");
                    return;
                }
            }
            if (this.m_MPNode == null) {
                return;
            }
            String workingAddress = this.m_MPNode.getWorkingAddress();
            if (workingAddress == null) {
                m_log.debug((Object)("HurricaneAssociationDataHandler:Working Address is null for device : " + this.m_MPNode.getDeviceName()));
                return;
            }
            MgmtProcessorParser mpp = new MgmtProcessorParser();
            DeviceUrlType dUrlType = NodeUrlTypeManager.getDefaultManager().getUrlTypeByRootName("compaq.hmmd.MANAGEMENTPROCESSOR");
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("dUrlType:" + dUrlType));
                m_log.debug((Object)("MPNode.getDeviceKey():" + this.m_MPNode.getDeviceKey()));
            }
            StringBuffer urlName = new StringBuffer();
            urlName.append("http://");
            urlName.append(workingAddress);
            urlName.append(":80/");
            if (MgmtProcessorParser.iLoSimulationDebug.getEnabled()) {
                urlName.append("xmldata.asp?item=All");
            } else {
                urlName.append("xmldata?item=All");
            }
            String xmlData = mpp.sendTheRequest(urlName.toString());
            mpp.setXmlData(xmlData);
            while (true) {
                HurricaneAssociationDataHandler hurricaneAssociationDataHandler = this;
                if (hurricaneAssociationDataHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                Thread.sleep(100L);
            }
            if (xmlData != null) {
                Element rootElement = mpp.getXmlRootElement();
                this.parseIloSpecificDataFromXml(this.m_MPNode, rootElement);
                this.parseIloRackEnclosureDataFromXml(this.m_MPNode, rootElement);
                this.doRackEnclosureDeviceProcessing(this.m_MPNode);
            }
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            if (this.myServerNodeAssociations != null) {
                this.myNodeRelationshipManager.update(this.myServerNodeAssociations);
            }
            if (this.myEnclosureNodeAssociations != null) {
                this.myNodeRelationshipManager.update(this.myEnclosureNodeAssociations);
            }
            m_log.debug((Object)" Finished updated node associations from HurricaneILO ");
        }
        catch (Exception e) {
            MgmtProcessorParser.mgmtProcIdentificationDebug.exception((Throwable)e);
        }
        finally {
            HurricaneAssociationDataHandler hurricaneAssociationDataHandler = this;
            hurricaneAssociationDataHandler.myNodeRelationshipManager.releaseWriteLock();
        }
    }

    private SnmpRequest isSNMPAvailable(MxNode node) {
        if (!node.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            return null;
        }
        if (MxNodeSecurityHandler.getSnmpMonitorCommunityString((MxNode)node) == null) {
            return null;
        }
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        if (!snmpEnabled.equals("checked")) {
            return null;
        }
        return new SnmpRequest(node);
    }

    public MxNode FindOtherNode(MxNode node) {
        MxNode associatedDevice = null;
        try {
            associatedDevice = this.findAssociatedDevice(node, "MgmtProcToServer_IPF");
            if (associatedDevice == null) {
                associatedDevice = this.findAssociatedDevice(node, "MgmtProcToServer_PA");
                this.strClientAttrib = MP_PA_SWID;
            }
        }
        catch (Exception ex) {
            associatedDevice = null;
        }
        return associatedDevice;
    }

    public MxNode findAssociatedDevice(MxNode node, String strgClientAttrib) {
        MxNode associatedDevice;
        block5: {
            associatedDevice = null;
            try {
                NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
                Vector associatedDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(node.getDeviceKey(), strgClientAttrib);
                int associatedDeviceKey = 0;
                if (associatedDeviceKeyVect != null && associatedDeviceKeyVect.size() > 0) {
                    Integer vectKey = (Integer)associatedDeviceKeyVect.elementAt(0);
                    associatedDeviceKey = vectKey;
                }
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("associatedDeviceKey:" + associatedDeviceKey));
                }
                if (associatedDeviceKey != 0) {
                    associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
                }
            }
            catch (Exception ex) {
                associatedDevice = null;
                if (!m_log.isEnabledFor((Priority)Level.ERROR)) break block5;
                m_log.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)ex);
            }
        }
        return associatedDevice;
    }

    private void parseIloSpecificDataFromXml(MxNode d, Element rootElement) {
        block33: {
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)" In parseIloSpecificDataFromXml");
            }
            try {
                Element attribute = rootElement.getChild("MP");
                if (attribute != null) {
                    String productName = attribute.getChildText("PN");
                    String serialNumber = attribute.getChildText("SN");
                    if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                        m_log.debug((Object)("productName:" + productName));
                        m_log.debug((Object)("serialNumber:" + serialNumber));
                    }
                    d.setSerialNumber(serialNumber);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
                if ((attribute = rootElement.getChild("HSI")) == null) break block33;
                String sUUID = attribute.getChildText("UUID");
                String serverUuid = null;
                if (sUUID != null) {
                    serverUuid = this.normalizeUUID(sUUID);
                }
                String serverSerialNumber = attribute.getChildText("SBSN");
                String productModel = attribute.getChildText("SPN");
                MxNode associatedDevice = null;
                String iloDisc = GlobalSettings.getProperty((String)"iloDisc_enabled_state", (String)"NOT");
                this.strClientAttrib = MP_IPF_UUID;
                if (serverUuid == null || serverUuid.trim().length() == 0) {
                    serverUuid = serverSerialNumber;
                }
                if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                    m_log.debug((Object)("serverUuid:" + serverUuid));
                    m_log.debug((Object)("serverSerialNumber:" + serverSerialNumber));
                }
                try {
                    String strTmpSaveClientAttrib = this.strClientAttrib;
                    associatedDevice = this.FindOtherNode(d);
                    if (associatedDevice != null) {
                        this.associatedDeviceKey = associatedDevice.getDeviceKey();
                        this.serverNode = associatedDevice;
                        m_log.debug((Object)("associatedDevice not null: associatedDeviceKey:" + this.associatedDeviceKey));
                    } else {
                        this.strClientAttrib = strTmpSaveClientAttrib;
                    }
                }
                catch (Exception ex) {
                    associatedDevice = null;
                }
                if (associatedDevice != null && associatedDevice.getDeviceName().matches("Serv_.*")) {
                    if (m_log.isEnabledFor((Priority)Level.FATAL)) {
                        m_log.fatal((Object)("The Server Name:" + associatedDevice.getDeviceName()));
                    }
                    if (associatedDevice.getDeviceSubTypes().isEmpty()) {
                        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                            m_log.info((Object)"The Bare metal blades Subtype List is empty.Add subtypes");
                        }
                        this.setProductSubType(productModel, associatedDevice);
                        MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), associatedDevice, false);
                    }
                }
                if (this.associatedDeviceKey <= 0 && iloDisc.equalsIgnoreCase("checked")) {
                    attribute = rootElement.getChild("INFRA");
                    String enclName = null;
                    if (attribute != null) {
                        enclName = attribute.getChildText("ENCL");
                    }
                    if (enclName == null || enclName.equals("")) break block33;
                    this.serverNode = new MxNode();
                    this.serverNode.setDeviceName("Serv_" + serverSerialNumber);
                    this.serverNode.setAgentUUID(serverUuid.toUpperCase());
                    this.serverNode.setDeviceType("Server");
                    this.serverNode.setSerialNumber(serverSerialNumber);
                    if (this.serverNode.getSnoozeTime() != -3) {
                        this.serverNode.setSnoozeTime(-3);
                    }
                    try {
                        this.setProductSubType(productModel, this.serverNode);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("error:" + e));
                    }
                    Integer i = new Integer(GlobalSettings.getProperty((String)"NetworkTimeout", (String)"5"));
                    this.serverNode.setSnmpTimeOut(i.intValue());
                    i = new Integer(GlobalSettings.getProperty((String)"NetworkRetries", (String)"2"));
                    this.serverNode.setSnmpRetry(i.intValue());
                    i = new Integer(GlobalSettings.getProperty((String)"IcmpTimeout", (String)"5"));
                    this.serverNode.setIcmpTimeOut(i.intValue());
                    i = new Integer(GlobalSettings.getProperty((String)"IcmpRetries", (String)"2"));
                    this.serverNode.setIcmpRetry(i.intValue());
                    int defaultsMask = 255;
                    this.serverNode.setDefaultsMask(true, defaultsMask);
                    try {
                        MxNodeController.getDefaultControllerNoEx().addNode((MxTransaction)new MxCoreTransaction(), this.serverNode);
                        if (this.strClientAttrib.equalsIgnoreCase(MP_IPF_UUID)) {
                            this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), this.serverNode.getDeviceKey(), "MgmtProcToServer_IPF", true);
                        } else if (this.strClientAttrib.equalsIgnoreCase(MP_PA_SWID)) {
                            this.myNodeRelationships.setTheAssociation(d.getDeviceKey(), this.serverNode.getDeviceKey(), "MgmtProcToServer_PA", true);
                        }
                        this.myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(this.serverNode.getDeviceKey());
                        if (this.myServerNodeAssociations == null) {
                            this.myServerNodeAssociations = new NodeAssociations(this.serverNode.getDeviceKey());
                        }
                        if (this.strClientAttrib.equalsIgnoreCase(MP_IPF_UUID)) {
                            this.myServerNodeAssociations.setTheAssociation(this.serverNode.getDeviceKey(), d.getDeviceKey(), "MgmtProcToServer_IPF", true);
                        } else if (this.strClientAttrib.equalsIgnoreCase(MP_PA_SWID)) {
                            this.myServerNodeAssociations.setTheAssociation(this.serverNode.getDeviceKey(), d.getDeviceKey(), "MgmtProcToServer_PA", true);
                        }
                        break block33;
                    }
                    catch (Exception ex) {
                        containerDeviceDebug.exception((Throwable)ex);
                    }
                    break block33;
                }
                if (serverUuid != null && serverUuid.trim().length() > 0) {
                    d.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), serverUuid);
                } else if (serverSerialNumber != null && serverSerialNumber.trim().length() > 0) {
                    d.setSWAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), serverSerialNumber);
                }
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                DebugOutput.log((DebugSubsystem)MgmtProcessorParser.mgmtProcIdentificationDebug, (int)10, (String)("Failed to set the GROMIT-SERVER association for " + d.getDeviceName()));
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    private void parseIloRackEnclosureDataFromXml(MxNode d, Element rootElement) {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)" In parseIloRackEnclosureDataFromXml");
        }
        try {
            Element attribute = rootElement.getChild("INFRA");
            if (attribute != null) {
                this.rackName = attribute.getChildText("RACK");
                this.enclosureName = attribute.getChildText("ENCL");
                this.enclSerNo = attribute.getChildText("ENCL_SN");
                this.enclUuid = attribute.getChildText("UUID");
                this.maxNumBladesX = this.getIntegerValueFromXml(attribute.getChildText("MAX_NUMBER_SLOTS_X"));
                this.maxNumBladesY = this.getIntegerValueFromXml(attribute.getChildText("MAX_NUMBER_SLOTS_Y"));
                if ((attribute = attribute.getChild("BLADE")) != null) {
                    this.bladeSlot = this.getIntegerValueFromXml(attribute.getChildText("SLOT"));
                    this.bladeHeight = this.getIntegerValueFromXml(attribute.getChildText("HMM"));
                    this.bladeWidth = this.getIntegerValueFromXml(attribute.getChildText("WMM"));
                    this.bladeDepth = this.getIntegerValueFromXml(attribute.getChildText("DMM"));
                    int temp = this.getIntegerValueFromXml(attribute.getChildText("NUM_SLOTS_X"));
                    this.numSlotsX = temp != 0 && temp != -1 ? temp : 1;
                    this.numSlotsY = this.getIntegerValueFromXml(attribute.getChildText("NUM_SLOTS_Y"));
                }
            }
            this.topology = new Vector();
            String enclSer = null;
            String enclUUIDfrmTplgy = null;
            List rkNodes = rootElement.getChildren("RK_TPLGY");
            if (rkNodes != null) {
                Iterator l = rkNodes.iterator();
                while (l.hasNext()) {
                    attribute = (Element)l.next();
                    this.rUid = attribute.getChildText("RUID");
                    List icmbList = attribute.getChildren("ICMB");
                    int indexIntoTable = 0;
                    Iterator k = icmbList.iterator();
                    while (k.hasNext()) {
                        Integer hexValueProdId;
                        Element icmbAttributes = (Element)k.next();
                        Vector<String> tplgy = new Vector<String>();
                        enclSer = icmbAttributes.getAttributeValue("SER");
                        enclUUIDfrmTplgy = icmbAttributes.getAttributeValue("UUID");
                        if (enclUUIDfrmTplgy != null && enclUUIDfrmTplgy.trim().length() > 0 && enclUUIDfrmTplgy.trim().length() >= 10) {
                            tplgy.add(enclUUIDfrmTplgy);
                        } else {
                            tplgy.add("");
                        }
                        if (enclSer != null && this.enclSerNo != null && enclSer.equalsIgnoreCase(this.enclSerNo)) {
                            this.serverEnclosureIndex = indexIntoTable;
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Server index : " + this.serverEnclosureIndex + " and Ser no. " + enclSer));
                            tplgy.add(this.enclosureName);
                        } else {
                            tplgy.add("");
                        }
                        Element childElement = icmbAttributes.getChild("RIGHT");
                        String leftNgbrName = childElement.getAttributeValue("NAME");
                        if (leftNgbrName != null && leftNgbrName.trim().length() > 0) {
                            tplgy.add(leftNgbrName);
                        } else {
                            tplgy.add("");
                        }
                        childElement = icmbAttributes.getChild("LEFT");
                        String rgtNgbrName = childElement.getAttributeValue("NAME");
                        if (rgtNgbrName != null && rgtNgbrName.trim().length() > 0) {
                            tplgy.add(rgtNgbrName);
                        } else {
                            tplgy.add("");
                        }
                        String prodId = icmbAttributes.getAttributeValue("PROD_ID");
                        StringTokenizer st = new StringTokenizer(prodId, "x");
                        String temp = "";
                        st.nextToken();
                        if (st.hasMoreTokens()) {
                            temp = st.nextToken();
                        }
                        if ((hexValueProdId = Integer.valueOf(temp, 16)) == 3 || hexValueProdId == 5) {
                            tplgy.add("false");
                            tplgy.add("true");
                        } else {
                            tplgy.add("true");
                            tplgy.add("false");
                        }
                        childElement = icmbAttributes.getChild("RIGHT");
                        String leftEnclUuid = childElement.getAttributeValue("UUID");
                        if (leftEnclUuid != null && leftEnclUuid.trim().length() > 0 && leftEnclUuid.trim().length() >= 10) {
                            tplgy.add(leftEnclUuid);
                        } else {
                            tplgy.add("");
                        }
                        String leftSerNumber = childElement.getAttributeValue("SER");
                        childElement = icmbAttributes.getChild("LEFT");
                        String rgtEnclUuid = childElement.getAttributeValue("UUID");
                        String rgtSerNumber = childElement.getAttributeValue("SER");
                        if (rgtEnclUuid != null && rgtEnclUuid.trim().length() > 0 && rgtEnclUuid.trim().length() >= 10) {
                            tplgy.add(rgtEnclUuid);
                        } else {
                            tplgy.add("");
                        }
                        if (enclSer != null) {
                            tplgy.add(enclSer);
                            this.prodIdList.put(enclSer, temp);
                        } else {
                            tplgy.add("");
                        }
                        if (leftSerNumber != null) {
                            tplgy.add(leftSerNumber);
                        } else {
                            tplgy.add("");
                        }
                        if (rgtSerNumber != null) {
                            tplgy.add(rgtSerNumber);
                        } else {
                            tplgy.add("");
                        }
                        this.topology.add(tplgy);
                        ++indexIntoTable;
                    }
                }
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    private void doRackEnclosureDeviceProcessing(MxNode d) {
        block22: {
            try {
                m_log.debug((Object)"HurricaneAssociationDataHandler:doRackEnclosureDeviceProcessing");
                if (this.serverEnclosureIndex == -1) break block22;
                this.myEnclosureNodeAssociations = this.getEnclosureInformation((Vector)this.topology.elementAt(this.serverEnclosureIndex), this.rackName, this.rUid);
                this.getRackInformation(this.rackName, this.rUid, this.myEnclosureNodeAssociations.getDeviceKey());
                if (this.getTheRackDevice() != null) {
                    this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                }
                this.storeTopologyInformation(this.topology, this.getTheRackDevice());
                if (this.maxNumBladesX > 0 && this.maxNumBladesY > 0) {
                    this.myEnclosureNodeAssociations.setMaxNumItemsXDir(this.maxNumBladesX);
                    this.myEnclosureNodeAssociations.setMaxNumItemsYDir(this.maxNumBladesY);
                    this.myEnclosureNodeAssociations.setMaxNumItems(this.maxNumBladesX * this.maxNumBladesY);
                } else {
                    this.myEnclosureNodeAssociations.setMaxNumItems(this.maxNumBlades);
                }
                int serverDevKey = 0;
                if (this.serverNode != null) {
                    serverDevKey = this.serverNode.getDeviceKey();
                } else {
                    serverDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "MgmtProcToServer_IPF");
                    if (serverDevKey < 0) {
                        serverDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "MgmtProcToServer_PA");
                    }
                }
                m_log.debug((Object)("serverDevKey:" + serverDevKey));
                if (serverDevKey <= 0) break block22;
                MxNode serverDev = null;
                try {
                    serverDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(serverDevKey);
                }
                catch (MxUndefinedNodeException ex1) {
                    m_log.debug((Object)("- ServerToEncl: Unable to retrieve serverDev - " + serverDevKey + " exception: " + (Object)((Object)ex1)));
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("ILO - ServerToEncl: Unable to retrieve serverDev - " + serverDevKey + " exception: " + (Object)((Object)ex1)));
                }
                if (!serverDev.getDeviceName().startsWith("Serv_") && serverDev == null) break block22;
                m_log.debug((Object)"server node is present");
                int enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
                m_log.debug((Object)("enclDevKey:" + enclDevKey));
                if (enclDevKey > 0) break block22;
                m_log.debug((Object)"need to create a new enclosure node");
                Vector tpgy = (Vector)this.topology.get(this.serverEnclosureIndex);
                if (tpgy == null) break block22;
                String enclUuid = (String)tpgy.get(0);
                MxNode encl = null;
                try {
                    encl = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclUuid.trim());
                }
                catch (MxUndefinedNodeException ex) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("ILO - ServerToEncl: Unable to retrieve encl by UUID - " + enclUuid + " exception: " + (Object)((Object)ex)));
                }
                if (encl == null) {
                    String enclSerNo = (String)tpgy.get(8);
                    m_log.debug((Object)("enclSerNo:" + enclSerNo));
                    try {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ILO - ServerToEncl: attempting to get enclosure by serial No: " + enclSerNo));
                        encl = MxNodeController.getDefaultControllerNoEx().getNodeByAgentUUID(enclSerNo.trim());
                    }
                    catch (MxUndefinedNodeException ex) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ILO - ServerToEncl: attempting to get enclosure from db_deviceinfoex" + enclSerNo));
                        int enclDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclSerNo.trim(), 14);
                        m_log.debug((Object)("enclDeviceKey:" + enclDeviceKey));
                        try {
                            encl = MxNodeController.getDefaultControllerNoEx().getNodeByKey(enclDeviceKey);
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)("ILO - ServerToEncl: enclosure deviceKey = " + enclDeviceKey));
                        }
                        catch (MxUndefinedNodeException ex2) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("ILO - ServerToEncl: error retrieving enclosure from deviceinfoex - " + (Object)((Object)ex2)));
                        }
                    }
                }
                if (encl != null) {
                    this.myEnclosureNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(encl.getDeviceKey());
                    if (this.myEnclosureNodeAssociations == null) {
                        this.myEnclosureNodeAssociations = new NodeAssociations(encl.getDeviceKey());
                    }
                    this.myServerNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(serverDevKey);
                    if (this.myServerNodeAssociations == null) {
                        this.myServerNodeAssociations = new NodeAssociations(serverDevKey);
                    }
                    m_log.debug((Object)"set serverToEnclosure association");
                    this.myServerNodeAssociations.setTheAssociation(serverDevKey, encl.getDeviceKey(), "ServerToEnclosure", false);
                    this.myServerNodeAssociations.setSlotNumber(this.bladeSlot);
                    this.myServerNodeAssociations.setMmHeight(this.bladeHeight);
                    this.myServerNodeAssociations.setMmWidth(this.bladeWidth);
                    this.myServerNodeAssociations.setMmDepth(this.bladeDepth);
                    if (this.numSlotsX > 0 && this.numSlotsY > 0) {
                        this.myServerNodeAssociations.setNumBladeSlotsUsedXDir(this.numSlotsX);
                        this.myServerNodeAssociations.setNumBladeSlotsUsedYDir(this.numSlotsY);
                        this.myServerNodeAssociations.setNumBladeSlotsUsed(this.numSlotsX * this.numSlotsY);
                    } else {
                        this.myServerNodeAssociations.setNumBladeSlotsUsedYDir(1);
                    }
                    this.myNodeRelationships.setSource(this.associationType);
                    this.myServerNodeAssociations.setSource(this.associationType);
                    this.myEnclosureNodeAssociations.setSource(this.associationType);
                    this.addDeviceToTopologyTree(this.myEnclosureNodeAssociations, serverDevKey);
                    this.myServerNodeAssociations.setParent(encl.getDeviceKey());
                }
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
        }
    }

    private int getIntegerValueFromXml(String intString) {
        if (intString != null) {
            return new Integer(intString);
        }
        return -1;
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    private void setProductSubType(String model, MxNode server) {
        if (model != null) {
            server.setModel(model);
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.debug((Object)("HurricaneAssociationDataHandler.setProductSubType(" + model + ")"));
            }
            ArrayList<String> subTypes = new ArrayList<String>();
            subTypes.add("HP");
            subTypes.add("Integrity Server");
            subTypes.add("Blade");
            server.setDeviceSubTypes(subTypes);
        }
    }

    private String normalizeUUID(String strRawUUID) {
        char[] rawCharArray = strRawUUID.toLowerCase().toCharArray();
        char[] normalizeCharArray = new char[IPF_UUID_FORMATED_LENGTH];
        normalizeCharArray[0] = rawCharArray[6];
        normalizeCharArray[1] = rawCharArray[7];
        normalizeCharArray[2] = rawCharArray[4];
        normalizeCharArray[3] = rawCharArray[5];
        normalizeCharArray[4] = rawCharArray[2];
        normalizeCharArray[5] = rawCharArray[3];
        normalizeCharArray[6] = rawCharArray[0];
        normalizeCharArray[7] = rawCharArray[1];
        normalizeCharArray[8] = 45;
        normalizeCharArray[9] = rawCharArray[10];
        normalizeCharArray[10] = rawCharArray[11];
        normalizeCharArray[11] = rawCharArray[8];
        normalizeCharArray[12] = rawCharArray[9];
        normalizeCharArray[13] = 45;
        normalizeCharArray[14] = rawCharArray[14];
        normalizeCharArray[15] = rawCharArray[15];
        normalizeCharArray[16] = rawCharArray[12];
        normalizeCharArray[17] = rawCharArray[13];
        normalizeCharArray[18] = 45;
        normalizeCharArray[19] = rawCharArray[16];
        normalizeCharArray[20] = rawCharArray[17];
        normalizeCharArray[21] = rawCharArray[18];
        normalizeCharArray[22] = rawCharArray[19];
        normalizeCharArray[23] = 45;
        normalizeCharArray[24] = rawCharArray[20];
        normalizeCharArray[25] = rawCharArray[21];
        normalizeCharArray[26] = rawCharArray[22];
        normalizeCharArray[27] = rawCharArray[23];
        normalizeCharArray[28] = rawCharArray[24];
        normalizeCharArray[29] = rawCharArray[25];
        normalizeCharArray[30] = rawCharArray[26];
        normalizeCharArray[31] = rawCharArray[27];
        normalizeCharArray[32] = rawCharArray[28];
        normalizeCharArray[33] = rawCharArray[29];
        normalizeCharArray[34] = rawCharArray[30];
        normalizeCharArray[35] = rawCharArray[31];
        return new String(normalizeCharArray);
    }

    private String stripSWIDString(String strRawSWIDStringFromIPFOid) {
        String strLowerCaseVer = strRawSWIDStringFromIPFOid.toLowerCase();
        int nIdx = strLowerCaseVer.indexOf(58);
        return new String(strLowerCaseVer.substring(++nIdx));
    }

    public void cleanUpAssociationData(MxNode ILONode) {
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(ILONode.getDeviceKey(), "MgmtProcToServer_IPF");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(ILONode.getDeviceKey(), "MgmtProcToServer_PA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int deviceDbKey = device.getDeviceKey();
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
        if (device.getModel().compareToIgnoreCase("integrated lights-out (ilo) for integrity and hp9000") != 0) {
            return na;
        }
        try {
            MxNode theDevice = null;
            try {
                theDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceDbKey);
            }
            catch (MxUndefinedNodeException ex1) {
                theDevice = null;
            }
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " or devicekey2=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            MxNode dev1 = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                if (deviceKey1 == deviceDbKey) {
                    dev1 = theDevice;
                } else {
                    try {
                        dev1 = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey1);
                    }
                    catch (MxUndefinedNodeException ex) {
                        dev1 = null;
                    }
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("load assn for " + deviceDbKey + " k1 " + deviceKey1 + " k2 " + deviceKey2 + " dev1 " + dev1));
                if (dev1 != null && dev1.getDeviceType().equals("Server")) {
                    if (associationTypeNumber.equalsIgnoreCase("ServerToEnclosure")) {
                        if (deviceKey1 != deviceDbKey) continue;
                        na.setInContainer(true);
                        na.setParent(deviceKey2);
                        na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, false);
                        continue;
                    }
                    if (associationTypeNumber.startsWith("MgmtProcToServer_IPF")) {
                        na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, true);
                        continue;
                    }
                    if (!associationTypeNumber.startsWith("MgmtProcToServer_PA")) continue;
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, true);
                    continue;
                }
                if (dev1 == null || !dev1.getDeviceType().equals("MgmtProc")) continue;
                if (associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_IPF")) {
                    if (deviceKey1 != deviceDbKey) continue;
                    na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, true);
                    continue;
                }
                if (!associationTypeNumber.equalsIgnoreCase("MgmtProcToServer_PA") || deviceKey1 != deviceDbKey) continue;
                na.setTheAssociation(deviceKey1, deviceKey2, associationTypeNumber, true);
            }
            myResultSet.close();
            myStatement.close();
            myResultSet = null;
            myStatement = null;
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        catch (Exception myException) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
        }
        finally {
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }
}

