/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.UnsupportedSwitchHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class BladeSystemSwitchHandler
extends UnsupportedSwitchHandler {
    private String associationType = "";
    private String hpSerialNumber = "";
    private String modelName = "";
    private String leftSWSerialNumber = "";
    private String rightSWSerialNumber = "";
    private int switchSlot = -1;

    public BladeSystemSwitchHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        if (GlobalSettings.getProperty((String)"switch_code_wakeup", (String)"false").equalsIgnoreCase("true")) {
            block38: {
                int enclDevKey;
                boolean found;
                block37: {
                    found = false;
                    enclDevKey = 0;
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("IN The SWITCHASSOCIATIONDATAHANDLER.... for device " + d.getDeviceName()));
                    }
                    if (!d.getDeviceType().equals("Switch")) {
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The SWITCHASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
                        }
                        this.cleanUpAssociationData(d);
                        return;
                    }
                    String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
                    if (!snmpEnabled.equals("checked")) {
                        DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Switch Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName()));
                        return;
                    }
                    if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
                        DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Switch Association skipped ; snmp not detected on " + d.getDeviceName()));
                        return;
                    }
                    String workingAddress = d.getWorkingAddress();
                    if (workingAddress == null) {
                        if (containerDeviceDebug.check(10)) {
                            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("BladeSystemSwitchHandler : Working Address is null for device : " + d.getDeviceName()));
                        }
                        return;
                    }
                    try {
                        while (true) {
                            BladeSystemSwitchHandler bladeSystemSwitchHandler = this;
                            if (bladeSystemSwitchHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                            Thread.sleep(100L);
                        }
                        this.modelName = d.getModel();
                        if (this.modelName.matches("Cisco Gigabit Ethernet Switch Module.*.HP BladeSystem p-Class")) {
                            String ciscoSerialNumber = null;
                            boolean hasLeftSwitch = false;
                            boolean hasRightSwitch = false;
                            ciscoSerialNumber = this.snmpPdh.getStrValueFromMib("1.3.6.1.2.1.47.1.1.1.1.11.1001[1]", true);
                            BladeIMELogger.log("The ciscoSerialNumber:" + ciscoSerialNumber);
                            if (ciscoSerialNumber == null) {
                                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("BladeSystemSwitchHandler : Switch Serial number is null for device : " + d.getDeviceName()));
                                return;
                            }
                            BladeIMELogger.log("ciscoSerialNumber is not null.So get the HP Serial Number");
                            this.hpSerialNumber = this.convertCiscoToHPSerialNumber(ciscoSerialNumber);
                            BladeIMELogger.log("The HP Serial Number:" + this.hpSerialNumber);
                            d.setSerialNumber(this.hpSerialNumber);
                            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                            Vector listofDevKeys = this.getDevicesThatHaveAssociationsUsingATNs("ServerToEnclosure");
                            Integer devKey = new Integer(0);
                            for (int i = 0; i < listofDevKeys.size(); ++i) {
                                found = false;
                                hasLeftSwitch = false;
                                hasRightSwitch = false;
                                devKey = (Integer)listofDevKeys.elementAt(i);
                                MxNode d1 = MxNodeController.getDefaultControllerNoEx().getNodeByKey(devKey);
                                String modelName_device = d1.getModel();
                                if ((modelName_device = modelName_device.toLowerCase()).matches("proliant bl[0-9][0-9]p.*")) {
                                    this.leftSWSerialNumber = d1.getSWAttribute("compaq.devices.LeftSWSerialNo");
                                    this.rightSWSerialNumber = d1.getSWAttribute("compaq.devices.RightSWSerialNo");
                                    enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d1.getDeviceKey(), "ServerToEnclosure");
                                    if (enclDevKey > 0) {
                                        String rckId;
                                        String rckName;
                                        int tmpenclDevKey;
                                        if (this.leftSWSerialNumber != null && this.leftSWSerialNumber.equalsIgnoreCase(this.hpSerialNumber)) {
                                            tmpenclDevKey = 0;
                                            tmpenclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "SwitchToEnclosure");
                                            if (tmpenclDevKey == 0) {
                                                rckName = d1.getSWAttribute("compaq.devices.rackname");
                                                rckId = d1.getSWAttribute("compaq.devices.rackuid");
                                                this.doEnclosureDeviceProcessing(d.getDeviceKey(), enclDevKey, this.leftSWSerialNumber, null, rckName, rckId);
                                                found = true;
                                                if (rckName != null) {
                                                    d.setRackName(rckName);
                                                }
                                            }
                                        }
                                        if (this.rightSWSerialNumber != null && this.rightSWSerialNumber.equalsIgnoreCase(this.hpSerialNumber)) {
                                            tmpenclDevKey = 0;
                                            tmpenclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "SwitchToEnclosure");
                                            if (tmpenclDevKey == 0) {
                                                rckName = d1.getSWAttribute("compaq.devices.rackname");
                                                rckId = d1.getSWAttribute("compaq.devices.rackuid");
                                                this.doEnclosureDeviceProcessing(d.getDeviceKey(), enclDevKey, null, this.rightSWSerialNumber, rckName, rckId);
                                                found = true;
                                                if (rckName != null) {
                                                    d.setRackName(rckName);
                                                }
                                            }
                                        }
                                    }
                                }
                                if (!found) continue;
                                break block37;
                            }
                            break block37;
                        }
                        String encSerialNo = null;
                        this.getSwitchAttributesFromTheMib();
                        this.snmpPdh.snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.22.2.3.1.1.1.7.1.1");
                        this.snmpPdh.snmpReq.SnmpGet();
                        SnmpResponse curResp = this.snmpPdh.snmpReq.getResponseVarbinds();
                        SnmpResponseVarBind vb = curResp.findResponse("1.3.6.1.4.1.232.22.2.3.1.1.1.7.1.1");
                        if (vb != null && !vb.isError()) {
                            encSerialNo = vb.getValue();
                        }
                        if (!this.pclassleftSwitchPresent && !this.pclassrightSwitchPresent) break block37;
                        Vector listofSrvKeys = new Vector();
                        if (encSerialNo != null) {
                            listofSrvKeys = this.getDevicesThatHaveAssociationsWithSwitch(encSerialNo);
                        }
                        Integer devKey = new Integer(0);
                        for (int i = 0; i < listofSrvKeys.size(); ++i) {
                            devKey = (Integer)listofSrvKeys.elementAt(i);
                            MxNode d1 = MxNodeController.getDefaultControllerNoEx().getNodeByKey(devKey);
                            if (this.pclassleftSwitchPresent) {
                                this.leftSWSerialNumber = d1.getSWAttribute("compaq.devices.LeftSWSerialNo");
                                if (this.leftSWSerialNumber == null) continue;
                                d.setSerialNumber(this.leftSWSerialNumber);
                            } else {
                                if (!this.pclassrightSwitchPresent) continue;
                                this.rightSWSerialNumber = d1.getSWAttribute("compaq.devices.RightSWSerialNo");
                                if (this.rightSWSerialNumber == null) continue;
                                d.setSerialNumber(this.rightSWSerialNumber);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)(" EXCEPTION : " + e));
                        containerDeviceDebug.exception((Throwable)e);
                    }
                    finally {
                        this.myNodeRelationshipManager.update(this.myNodeRelationships);
                        BladeSystemSwitchHandler bladeSystemSwitchHandler = this;
                        bladeSystemSwitchHandler.myNodeRelationshipManager.releaseWriteLock();
                    }
                }
                enclDevKey = 0;
                String enclName = "";
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"SWITCHASSOCIATIONDATAHANDLER....setting Encl/Rack name in devContainerAndRole");
                try {
                    enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "SwitchToEnclosure");
                    if (enclDevKey <= 0 || !found) break block38;
                    try {
                        enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getDeviceName();
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    d.setEnclosureName(enclName);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
                catch (Exception e) {
                    containerDeviceDebug.exception((Throwable)e);
                }
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Done trying to find associations for SWITCH : " + d.getDeviceName()));
            }
        }
    }

    public void doEnclosureDeviceProcessing(int switchKey, int enclKey, String leftSWSerialNumber, String rightSWSerialNumber, String rkName, String rkId) {
        NodeAssociations theEnclNodeAssociations = null;
        Object theSwitchNodeAssociations = null;
        try {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"SwitchADH : In rackEnclosure Device Processing");
            this.myNodeRelationships.setSource("Switch");
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"SwitchADH : Finished storing switch attributes");
            if (enclKey > 0) {
                theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclKey);
            }
            if (theEnclNodeAssociations != null) {
                this.myNodeRelationships.setTheAssociation(switchKey, enclKey, "SwitchToEnclosure", false);
                this.addDeviceToTopologyTree(theEnclNodeAssociations, switchKey);
                if (leftSWSerialNumber != null) {
                    theEnclNodeAssociations.setHasLeftSwitch(true);
                    theEnclNodeAssociations.setHasLeftSwitchSlot(true);
                    this.myNodeRelationships.setSlotNumber(0);
                } else if (rightSWSerialNumber != null) {
                    theEnclNodeAssociations.setHasRightSwitch(true);
                    theEnclNodeAssociations.setHasRightSwitchSlot(true);
                    this.myNodeRelationships.setSlotNumber(9999);
                }
                this.myNodeRelationships.setInContainer(true);
                this.myNodeRelationships.setParent(enclKey);
                int switchesPresent = 0;
                if (leftSWSerialNumber != null && rightSWSerialNumber != null) {
                    switchesPresent = 3;
                } else if (leftSWSerialNumber != null && rightSWSerialNumber == null) {
                    switchesPresent = 2;
                } else if (leftSWSerialNumber == null && rightSWSerialNumber != null) {
                    switchesPresent = 1;
                } else if (leftSWSerialNumber == null && rightSWSerialNumber == null) {
                    switchesPresent = 0;
                }
                theEnclNodeAssociations.setSwitchApis(switchesPresent);
                theEnclNodeAssociations.setSource("Enclosure");
                NodeAssociations theRackNodeAssociations = this.getRackInformation(rkName, rkId, enclKey);
                if (this.getTheRackDevice() != null) {
                    this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                }
                if (theRackNodeAssociations != null) {
                    this.addTreeNodeToTopologyTree(theRackNodeAssociations, enclKey, null, null);
                    this.myNodeRelationshipManager.update(theRackNodeAssociations);
                }
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block5: {
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    if (device == null || !device.getDeviceType().equals("Switch") || !associationTypeNumber.equalsIgnoreCase("SwitchToEnclosure") || deviceKey1 != deviceDbKey) continue;
                    na.setInContainer(true);
                    na.setParent(deviceKey2);
                    na.setTheAssociation(deviceKey1, deviceKey2, "SwitchToEnclosure", false);
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (!containerDeviceDebug.check(10)) break block5;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
            }
            catch (SQLException myException) {
                try {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                }
                catch (Throwable throwable) {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    public void cleanUpAssociationData(MxNode d) {
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            Vector v = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
            for (int i = 0; i < v.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)v.elementAt(i)).intValue());
            }
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDevicesThatHaveAssociationsUsingATNs(String associationType) {
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        String sqlQuery = null;
        Vector<Integer> tempObject = new Vector<Integer>();
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.setTheAssociation:326");
            myStatement = myConnection.createStatement();
            sqlQuery = associationType.indexOf("MgmtProcToServer") > -1 ? "select DeviceKey1 from device_associations where AssociationTypeNumber like 'MgmtProcToServer%'" : "select DeviceKey1 from device_associations where AssociationTypeNumber='" + associationType + "'";
            myResultSet = myStatement.executeQuery(sqlQuery);
            while (myResultSet.next()) {
                tempObject.addElement(new Integer(myResultSet.getInt("DeviceKey1")));
            }
            myResultSet.close();
            myResultSet = null;
        }
        catch (SQLException myException) {
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
            }
            catch (Throwable throwable) {
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                throw throwable;
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        return tempObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDevicesThatHaveAssociationsWithSwitch(String enclSerialNo) {
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        Object sqlQuery = null;
        Vector<Integer> tempObject = new Vector<Integer>();
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.setTheAssociation:326");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select devices.devicekey from devices where devices.devicekey in (select cim_chassis.nodeid from cim_chassis where cim_chassis.serialnumber='" + enclSerialNo + "')" + "AND devices.producttypestr='Server'");
            while (myResultSet.next()) {
                tempObject.addElement(new Integer(myResultSet.getInt("DeviceKey")));
            }
            myResultSet.close();
            myResultSet = null;
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        catch (SQLException myException) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
        }
        finally {
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        return tempObject;
    }
}

