<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions">
	<xsl:template name="renderPEClassEnclRearView">
	<xsl:param name="enclSerialNum"/>
	<xsl:param name="typeOfDisplay"/>
	<xsl:variable name="heightOfEncl" >
		<xsl:choose>
			<xsl:when  test="./@type=$P_CLASS">
				<xsl:value-of select="$PC_ENCL_HEIGHT"/>							
			</xsl:when>
			<xsl:when test="./@type=$E_CLASS">
				<xsl:value-of select="$E_ENCL_HEIGHT"/>							
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	
	<table border="0" cellpadding="0" cellspacing="0" class="systemStatusTable" id="rearView">
	    <!-- Used to display the power zone border around the servere enclosure-->
		<xsl:attribute name="powerZone">
				<xsl:value-of select="./Common/PowerZone"/>
		</xsl:attribute>

        <tr>
            <td>
				<xsl:attribute name="width">
							<xsl:choose>
								<xsl:when test="./@type=$P_CLASS">
									<xsl:value-of select="$P_ENCL_WIDTH"/>
								</xsl:when>
								<xsl:when test="./@type=$E_CLASS">
									<xsl:value-of select="$E_ENCL_WIDTH"/>
								</xsl:when>
							</xsl:choose>
						</xsl:attribute>
					<table border="0" cellspacing="0" cellpadding="0" width="100%"  class="systemStatusTable">
						<xsl:choose>
							<xsl:when test="./@type=$E_CLASS">
								<xsl:call-template name="renderEClassRearView">
									<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<!-- Render the right (dukes) switch -->
									<xsl:call-template name="renderRearDevice">
											<xsl:with-param name="index" select="number(9999)"/>
											<xsl:with-param name="location"><xsl:text>Rear</xsl:text></xsl:with-param>
											<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
									</xsl:call-template>	
									<td>
										<table cellpadding="0" cellspacing="0">
											<tbody>
												<tr>
													<xsl:call-template name="renderRearBlades">
														<xsl:with-param name="slotNumber" select="number(9)"/>
													</xsl:call-template>	
												</tr>
											</tbody>
										</table>
									</td>
									<!-- Render the left (dukes) switch -->
									<xsl:call-template name="renderRearDevice">
											<xsl:with-param name="index" select="number(0)"/>
											<xsl:with-param name="location"><xsl:text>Rear</xsl:text></xsl:with-param>
											<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
									</xsl:call-template>	
								</tr>
								<tr>
									<td colspan="3">
										<img>
											<xsl:attribute name="src">
												<xsl:value-of select="$SRVENCL_BKPLANE"/>
											</xsl:attribute>
										</img> 
									</td>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
				   </table>
				 </td>
			</tr>
		</table>
	</xsl:template>


<xsl:template name="renderRearDevice">
	<xsl:param name="index"/>
	<xsl:param name="location"/>
	<xsl:param name="typeOfDisplay"/>
	<xsl:for-each select="Device[@location=$location  and SlotNumber = $index]  ">	
		<td>
			<xsl:attribute name="width">
				<xsl:value-of select="$PE_HALF_BAY_WIDTH"/>
			</xsl:attribute>
			<xsl:choose>		
				<xsl:when test="./hasDevice='ABSENT'">
					<xsl:attribute name="title">
						<xsl:value-of select="//I18N/L10NEmptyBay"/>
					</xsl:attribute>
					<img>
					 <xsl:attribute name="src">
						 <xsl:value-of select="$EMPT_SLT_REAR"/>
					 </xsl:attribute>
					</img> 
				</xsl:when>	
				<xsl:otherwise>
					<xsl:attribute name="title">
					<xsl:value-of select="//I18N/L10NBay"/>
						<xsl:text>: </xsl:text>
						<xsl:call-template name="computeTitleBay"><xsl:with-param name="slotNumber" select="./SlotNumber"/><xsl:with-param name="slotsXDirect" select="./SlotsUsed/XDirection" /></xsl:call-template>
						<xsl:text>, </xsl:text><xsl:value-of select="//I18N/L10NProductName"/>:<xsl:text> </xsl:text>
						<xsl:value-of select="./Common/Name"/><xsl:text>, </xsl:text><xsl:value-of select="./Common/Product"/>
					</xsl:attribute>

					<xsl:choose>
						<xsl:when test="./@bayType='Server'">
							<img>
								<xsl:attribute name="src">
								  <xsl:value-of select="$P_SRV_REAR"/><xsl:text>server_</xsl:text><xsl:value-of select="./SlotsUsed/XDirection"/><xsl:text>X.gif</xsl:text>
								 </xsl:attribute>
							</img>
						</xsl:when>
						<xsl:otherwise>
							<!-- Render Switch -->
											<xsl:attribute name="id"><xsl:text>Rear_Switch_</xsl:text><xsl:value-of select="./SlotNumber"/>
											</xsl:attribute>
							<xsl:choose>
								<xsl:when test="$typeOfDisplay=$BPV">
									<xsl:attribute name="class">deviceCell</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">deviceCellUnselectable</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							
							<xsl:choose>
								<xsl:when test="$typeOfDisplay=$BPV">
									<!-- drilldownURL attribute will point to URL when the user drill downs this device -->
									<xsl:attribute name="drilldownURL">
										<xsl:value-of select="./Common/DrillDownURL" />
									</xsl:attribute>
								</xsl:when>
							</xsl:choose>
							

							<xsl:attribute name="background">
								 <xsl:value-of select="$DUKES_SWITCH"/>
							</xsl:attribute>
							  <!--
								Add blade cell template information to the table cell.
								TODO: Give this element a standardized programattic id
								so that we can swap out its contents when an event is received.
								-->
								<xsl:element name="DIV">
									<xsl:attribute name="style">text-align:center; display:block;</xsl:attribute>
											<xsl:call-template name="renderStatusAndCheckBox">
													<xsl:with-param name="presence" select="$PRESENT" />
													<xsl:with-param name="status" select="./Status/UID" />
													<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay" />
													<xsl:with-param name="amStatus" select="./AutoManager/Status" />
													<xsl:with-param name="devHomeURL" select="./Common/HomePageURL" />
													<xsl:with-param name="amURL" select="./AutoManager/StatusURL" />
													<xsl:with-param name="drillDownURL" select="./Common/DrillDownURL"/>
													<xsl:with-param name="hwtitleStatus" select="./Status/Title"/>
													<xsl:with-param name="amTitleStatus" select="./AutoManager/StatusTitle"/>
											</xsl:call-template>		
								</xsl:element>

						 </xsl:otherwise> 
				</xsl:choose> 
						  
					
				</xsl:otherwise>
			</xsl:choose>	
		</td>
	</xsl:for-each>
</xsl:template>	

<!--
renderBlades template is called recursively to simulate a for loop which
repeats for 8 times (Number of slots in the rear view of an p-class enclosure)
Each time it calls renderRearDevice which renders the rear view of blade for the 
specific slot determined by the parameter slotNumber to it. 
-->
<xsl:template name="renderRearBlades">
<xsl:param name="slotNumber"/>

	<xsl:if test="number($slotNumber) > 1">
		<xsl:call-template name="renderRearDevice">
			<xsl:with-param name="index" select="$slotNumber - 1"/>
			<xsl:with-param name="location"><xsl:text>Front</xsl:text></xsl:with-param>
		</xsl:call-template>	
		<xsl:call-template name="renderRearBlades">
			<xsl:with-param name="slotNumber" select="$slotNumber - 1"/>
		</xsl:call-template>	
	</xsl:if>
</xsl:template>

<xsl:template name="powerEnclFrontView">
<xsl:param name="enclSerialNum"/>
	<table class="systemStatusTable" border="0" cellpadding="0" cellspacing="0">

		<xsl:attribute name="powerZone">
				<xsl:value-of select="./Common/PowerZone"/>
		</xsl:attribute>
		<tr>
		<td width="210">
			<table border="0" cellpadding="0" cellspacing="0">
				<tr>
					<xsl:call-template name="renderPowerEnclosure">
						<xsl:with-param name="enclSerialNum" select="$enclSerialNum"/>
					</xsl:call-template>	
				</tr>
			</table>		
		</td>
	</tr>

	</table>
</xsl:template>

<xsl:template name="powerEnclRearView">
<table border="0" cellspacing="0" cellpadding="0" class="systemStatusTable" id="rearViewPower">
	<xsl:attribute name="powerZone">
			<xsl:value-of select="./Common/PowerZone"/>
	</xsl:attribute>

	<tr>
		<td style="border: 1px solid #333;">
			<img>
				<xsl:attribute name="src">
				<xsl:value-of select="$P_PU_REAR"/><xsl:value-of select="./@size"/><xsl:text>.gif</xsl:text>
				</xsl:attribute>	
			</img> 
		</td>
	</tr>
</table>		
</xsl:template>


	<xsl:template name="renderPowerEnclosure">
		<xsl:param name="enclSerialNum"/>
					<td>
					<xsl:attribute name="width">
						<xsl:value-of select="$P_ENCL_WIDTH"/>
					</xsl:attribute>
					<xsl:variable name="heightPU">
						<xsl:value-of select=" number(substring(./@size,1,1))*number($ONEU_HEIGHT)"/>
					</xsl:variable>
					<xsl:attribute name="height">
						<xsl:value-of select="$heightPU"/>
					</xsl:attribute>
						<!-- Front view power supply container -->
						<table border="0" cellspacing="0" cellpadding="0" align="center">
							<xsl:attribute name="width">
								<xsl:value-of select="$P_ENCL_WIDTH"/>
							</xsl:attribute>
							<tr>
								<!--
									Loop through all of the value elements in the power supply status document
									(one value element for each power supply).
								-->
								<xsl:for-each select="./PowerSupplyUnit">
									
									<!-- Get the power supply number for the current power supply. -->
                                    <xsl:variable name="psNumber">
										<xsl:value-of select="./BayNumber"/>
                                    </xsl:variable>
									
									<!-- Retrieve the presence value -->
                                    <xsl:variable name="presence">
										<xsl:value-of select="./hasDevice"/>
                                    </xsl:variable>
									
									<!--
										Draw a table cell container for each power supply.  NOTE: These table
										cells will only line up with the above blade bays if there are six power
										supplies. It is currently assumed that there are six power supplies.								
									-->
									<xsl:element name="td">
									
										<!-- Set up the table cell's attributes -->
										<xsl:attribute name="width">39</xsl:attribute>
										<xsl:attribute name="height"><xsl:value-of select="$heightPU"/></xsl:attribute>
										<xsl:attribute name="align">center</xsl:attribute>
										<xsl:attribute name="valign">middle</xsl:attribute>
                                        
                                        <!-- As we cannot drilldown into an powerSupply we will set the class to deviceCellUnselectable -->
                                        <!--<xsl:choose>
                                            <xsl:when test="$presence=$PRESENT">
                                                <xsl:attribute name="class">deviceCell</xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:attribute name="class">deviceCellUnselectable</xsl:attribute>
                                            </xsl:otherwise>
                                        </xsl:choose>
										-->
										<xsl:attribute name="class">deviceCellUnselectable</xsl:attribute>
										<!-- Flyover details to be show over the powerUnit-->
										<xsl:attribute name="title">

											<xsl:choose>
												<xsl:when test="../@iloPresent='Yes'">
														<xsl:choose>
															<xsl:when test="$presence=$PRESENT">
																<xsl:value-of select="//I18N/L10NPOWERSUPPLY"/><xsl:text> </xsl:text><xsl:value-of select="$psNumber"/>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="//I18N/L10NEmptyBay"/>
															</xsl:otherwise>
														</xsl:choose>
												</xsl:when>	
												<xsl:otherwise>
															<xsl:value-of select="//I18N/L10NILOUpdateMessage"/>
													</xsl:otherwise>	
											</xsl:choose>	

										</xsl:attribute>
										<!--
											Set the table cell's background image based on the presence
											of the power supply in the current bay.
										-->
										<xsl:attribute name="background">
											<!-- Set the background image location based on presence -->
											<xsl:choose>
												<xsl:when test="$presence=$PRESENT">
													<xsl:value-of select="$P_PU_FRNT" /><xsl:value-of select="../@size"/><xsl:text>.gif</xsl:text>	
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="$P_PU_FRNT"/><xsl:value-of select="../@size"/><xsl:text>_absent.gif</xsl:text>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>
										
										<!-- TODO: Get correct enclosure number -->
										<xsl:attribute name="id">
											<xsl:value-of select="concat('enc', $enclSerialNum, 'ps', $psNumber, 'Select')" />
										</xsl:attribute>
										
										<xsl:attribute name="devNum"><xsl:value-of select="$psNumber" /></xsl:attribute>
										<xsl:attribute name="enclSerialNum"><xsl:value-of select="$enclSerialNum" /></xsl:attribute>
										<xsl:attribute name="devType">ps</xsl:attribute>
										<!-- Power supply information container. Holds the power supply's status icon. -->
										<xsl:element name="div">
											<xsl:attribute name="style">display:block; width:100%;</xsl:attribute>
											<!--
												Set the ID of the power supply information container. The ID can be used to
												retrieve the container and update the innerHTML when a power supply event
												occurs.
											-->
											<xsl:attribute name="id">
												<xsl:value-of select="concat('psContainer', $psNumber)" />
											</xsl:attribute>
											
											<xsl:choose>
												<xsl:when test="../@iloPresent='Yes'">
													<!-- Only render the status icon if the power supply is present. -->
													<xsl:choose>
														<xsl:when test="$presence=$PRESENT">
															<!-- Set up the power supply's status image icon -->
															<xsl:call-template name="statusIcon">
																<xsl:with-param name="statusCode" select="./Status/Value" />
																<xsl:with-param name="titleMsg" select="./Status/Title" />
															</xsl:call-template>
														</xsl:when>
														<xsl:otherwise>
															&#160;
														</xsl:otherwise>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="statusIcon">
														<xsl:with-param name="statusCode" select="'Unknown'" />
														<xsl:with-param name="titleMsg" select="//I18N/L10NILOUpdateMessage"/>
													</xsl:call-template>
												</xsl:otherwise>	
											</xsl:choose>	
										</xsl:element>
									</xsl:element>
								</xsl:for-each>
							</tr>
						</table>
					</td>
	</xsl:template>


	<xsl:template name="renderEClassRearView">
	<xsl:param name="typeOfDisplay"/>	
		<tr>
				<td>
				<table cellpadding="0" cellspacing="0" border="0" class="systemStatusTable">
					<tbody>
						<xsl:choose>
							<xsl:when test="number(./@firmwareRev) &lt; number($ECLASS_ENCL_FRMREV)">
									<xsl:call-template name="renderEClassStaticView"/>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<xsl:for-each select="Device[@location='Rear'  and @bayType='PowerSupply']">
										   <xsl:if test="./position = 'left' ">
											   <xsl:choose>
												   <xsl:when test="./hasDevice=$PRESENT">
														<td> 
														<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NLeftPSU"/></xsl:attribute>
															<img>
																<xsl:attribute name="src">
																	<xsl:value-of select="concat($ECLASS_REAR_PATH,'power/leftpower.gif')"/> 
																</xsl:attribute>
															</img> 
														</td>
													</xsl:when>	
													<xsl:otherwise>
														<td> 
															<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NEmptyBay"/></xsl:attribute>
															<img>
																<xsl:attribute name="src">
																	<xsl:value-of select="concat($ECLASS_REAR_PATH,'power/emptyPower.gif')"/> 
																</xsl:attribute>
															</img>	
														</td>
													</xsl:otherwise>
												</xsl:choose>	
										   </xsl:if>
									</xsl:for-each>		   
										<td>
											<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NFANS"/></xsl:attribute> 
											<img>
												<xsl:attribute name="src">
													<xsl:value-of select="concat($ECLASS_REAR_PATH,'middle.gif')"/> 
												</xsl:attribute>
											</img>
										</td>
										<xsl:for-each select="Device[@location='Rear'  and @bayType='PowerSupply']">
									   <xsl:if test="./position = 'right'">
										   <xsl:choose>
											   <xsl:when test="./hasDevice=$PRESENT">
													<td>
														<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NRightPSU"/></xsl:attribute> 
														<img>
															<xsl:attribute name="src">
																<xsl:value-of select="concat($ECLASS_REAR_PATH,'power/rightpower.gif')"/> 
															</xsl:attribute>
														</img> 
													</td>
												</xsl:when>	
												<xsl:otherwise>
													<td> 
														<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NEmptyBay"/></xsl:attribute>
														<img>
															<xsl:attribute name="src">
																<xsl:value-of select="concat($ECLASS_REAR_PATH,'power/emptyPower.gif')"/> 
															</xsl:attribute>
														</img>	
													</td>
												</xsl:otherwise>
											</xsl:choose>	
									   </xsl:if>
								</xsl:for-each>
								</tr>
								<xsl:for-each select="Device[@location='Rear'  and @bayType='Switch']">

								<xsl:variable name="presence">
									<xsl:value-of select="./hasDevice"/>
								</xsl:variable> 
								
								<tr>
									<td colspan="3" height="18"> 
									 
										<xsl:choose>
											<xsl:when test="$presence=$PRESENT">
												<xsl:if test="$typeOfDisplay=$BPV">
													<xsl:attribute name="class">deviceCell</xsl:attribute>
												</xsl:if>
													<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NProductName"/>:<xsl:text> </xsl:text><xsl:value-of select="./Common/Name"/><xsl:text>, </xsl:text><xsl:value-of select="//I18N/L10NProductModel"/>:<xsl:text> </xsl:text><xsl:value-of select="./Common/Product"/></xsl:attribute>
												<xsl:attribute name="background"><xsl:value-of select="concat($ECLASS_REAR_PATH,'switch/switch.gif')"/></xsl:attribute>
												<xsl:attribute name="id"><xsl:value-of select="./Common/NodeId"/></xsl:attribute>
												<xsl:attribute name="drilldownURL"><xsl:value-of select="./Common/DrillDownURL" /></xsl:attribute>
												
												 <table cellpadding="0" cellspacing="0" border="0" align="left" id="e-ClassRearTable">
														<tr>
															<td>
																	<xsl:element name="input">
																		<xsl:attribute name="type">checkbox</xsl:attribute>
																		<xsl:attribute name="rowselector">yes</xsl:attribute>
																		<xsl:attribute name="devid">bay</xsl:attribute>
																		<xsl:if test="$typeOfDisplay!=$BPV">
																			<xsl:attribute name="DISABLED"/>
																		</xsl:if>
																		<!-- Give the blade checkbox a unique ID based on the blade number -->
																		<xsl:attribute name="id">
																				<xsl:value-of select="'switchCheckBox'" />
																		</xsl:attribute>
																		<!--
																				Add an value attribute to <td> this will have the NodeID(GUID) of each device,
																				This is used by the javascript to when the user clickes All Blades/All Switches,
																				checkbox.
																				height value.
																		-->
																		<xsl:attribute name="guid">
																			<xsl:value-of select="./Common/NodeId" />
																		</xsl:attribute>
																	</xsl:element>
															</td>
															<td>
																<xsl:variable name="hwToolTip" select="//I18N/HWStatusToolTip"/>				
																<xsl:variable name="hwtitleStatus" select="./Status/Title"/>
																<xsl:variable name="clickMsg" select="//I18N/DetailsToolTip"/>				
																
																
																  <xsl:choose>
																		<xsl:when test="$typeOfDisplay=$BPV">
																			<xsl:call-template name="statusIconLink">
																				<xsl:with-param name="statusCode" select="./Status/UID" />
																				<xsl:with-param name="fallBackURL" select="./Common/DrillDownURL"/>
																				<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
																			</xsl:call-template>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:call-template name="statusIcon">
																				<xsl:with-param name="statusCode" select="./Status/UID" />
																				<xsl:with-param name="titleMsg" select="concat($hwToolTip,': ',$hwtitleStatus,'. ',$clickMsg,'.')"/>
																			</xsl:call-template>
																		</xsl:otherwise>
																</xsl:choose>
															</td>
														</tr>	
												 </table>
												 
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">deviceCellUnselectable</xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NEmptyBay"/></xsl:attribute>
												<xsl:attribute name="background"><xsl:value-of select="concat($ECLASS_REAR_PATH,'switch/switch_absent.gif')"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
									 

									</td>
								</tr>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</tbody>
				</table>
			</td>			
		</tr>
	</xsl:template>

	<xsl:template name="renderEClassStaticView">
			<td>
				<xsl:attribute name="title">
					<xsl:value-of select="//I18N/L10NEClass14Message"/>
				</xsl:attribute>
				<table cellpadding="0" cellspacing="0" border="0">
					<tbody>
						<tr>
							<td> 
								<img>
									<xsl:attribute name="src"><xsl:value-of select="concat($ECLASS_REAR_PATH,'static/CCI13_Rear.gif')"/></xsl:attribute>
								</img>
							</td>
						</tr>
					</tbody>
				</table>
			</td>
	</xsl:template>

</xsl:stylesheet>

