/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.persistence.databean.CIM_Chassis;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.ui.MxLoginBean;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MonteroUtils {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private MxLoginBean m_loginBean;
    private MxNodeClient m_nodeClient;

    public void init(MxLoginBean loginBean) {
        if (this.m_loginBean != loginBean) {
            this.m_loginBean = loginBean;
            this.m_nodeClient = this.m_loginBean.getNodeClient();
        }
    }

    public String convertMemory(double memory) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("MonteroUtils.convertMemory(" + memory + ")"));
        }
        String finalValue = null;
        if (memory == 0.0) {
            return " ";
        }
        if (memory >= 1.073741824E9) {
            double finalValue1 = memory / 1.073741824E9;
            double finalValue2 = memory - finalValue1 * 1.073741824E9;
            finalValue = finalValue1 + finalValue2 + "GB";
        } else {
            finalValue = memory / 1048576.0 + " " + "MB";
        }
        return finalValue;
    }

    public String getMemoryInformation(MxObjectID objectID) {
        String newMemory;
        block3: {
            newMemory = " ";
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("MonteroUtils.getMemoryInformation(" + objectID + ")"));
            }
            try {
                MxNode node = this.m_nodeClient.getNode(objectID, false);
                newMemory = this.convertMemory((double)node.getTotalMemory() * 1024.0);
            }
            catch (MxException nodeException) {
                if (!log_.isEnabledFor((Priority)Level.DEBUG)) break block3;
                log_.debug((Object)("MonteroUtils.getMemoryInformation(" + objectID + "):" + (Object)((Object)nodeException)));
            }
        }
        return newMemory;
    }

    public String getOSInformation(MxObjectID objectID) {
        String osInformation;
        block3: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("MonteroUtils.getOSInformation(" + objectID + ")"));
            }
            osInformation = " ";
            try {
                MxNode node = this.m_nodeClient.getNode(objectID, false);
                osInformation = node.getOSNameStr();
            }
            catch (MxException nodeException) {
                if (!log_.isEnabledFor((Priority)Level.DEBUG)) break block3;
                log_.debug((Object)("MonteroUtils.getOSInformation(" + objectID + "):" + (Object)((Object)nodeException) + "Value of osInformation:" + osInformation));
            }
        }
        return osInformation;
    }

    public String getFirmwareRevision(String serialNo) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("MonteroUtils.getFirmwareRevision(" + serialNo + ")"));
        }
        if (serialNo == null || serialNo.equals("")) {
            return " ";
        }
        CIM_Chassis cimChassisElement = new CIM_Chassis();
        String firmWareRev = " ";
        try {
            cimChassisElement.setSerialNumber(serialNo);
            cimChassisElement.setSnapshotID(new Long(-1L));
        }
        catch (Exception e) {
            return " ";
        }
        return firmWareRev;
    }

    public String getModel(MxObjectID objectID) {
        String modelName;
        block4: {
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("MonteroUtils.getModel(" + objectID + ")"));
            }
            modelName = " ";
            try {
                MxNode node = this.m_nodeClient.getNode(objectID, false);
                modelName = node.getModel();
                if (modelName == null || modelName.equals("")) {
                    CIM_Chassis cimChassisElement = new CIM_Chassis();
                    cimChassisElement.setSerialNumber(node.getSerialNumber());
                    cimChassisElement.setSnapshotID(new Long(-1L));
                }
            }
            catch (MxException nodeException) {
                if (!log_.isEnabledFor((Priority)Level.DEBUG)) break block4;
                log_.debug((Object)("MonteroUtils.getModel(" + objectID + "):Value Of modelName:" + modelName + ":" + (Object)((Object)nodeException)));
            }
        }
        return modelName;
    }

    public static boolean isIe(HttpServletRequest request) {
        String value;
        int indexOfBrowser;
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("MonteroUtils.isIe(" + request + ")"));
        }
        boolean isIE = (indexOfBrowser = (value = request.getHeader("user-agent")).indexOf("Gecko")) < 0;
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)("MonteroUtils.isIe(" + request + "):Value of indexOfBrowser:" + indexOfBrowser));
            log_.debug((Object)("MonteroUtils.isIe(" + request + "):Value of isIE:" + isIE));
        }
        return isIE;
    }
}

