/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.portMapping;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OLBlade;
import com.hp.mx.portal.OAXml.OLBladePortMap;
import com.hp.mx.portal.OAXml.OLSwitch;
import com.hp.mx.portal.OAXml.OLSwitchPortMap;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.InterConnectDevice;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.InterConnectDeviceType;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.InterConnectSlot;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.InterConnectSlotType;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.MEZZDevice;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.MezzPort;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.ObjectFactory;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.PortMapping;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.PortStatus;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.ServerDevice;
import com.hp.mx.portal.portMapping.OAPortMappingJaxb.ServerDeviceType;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

public class DevicePortMapping {
    ObjectFactory m_objFactory = new ObjectFactory();
    private MonteroResourceManager m_manager = MonteroResourceManager.getInstance();
    private MxLoginBean m_loginBean;

    public DevicePortMapping(MxLoginBean loginBean) {
        this.m_loginBean = loginBean;
    }

    public String renderXMLForBlade(MxNode node) {
        BladeIMELogger.log("DevicePortMapping.renderXMLForBlade(MxNode " + node);
        try {
            PortMapping serverPortMappingJaxb = this.m_objFactory.createPortMapping();
            ServerDevice bladePortMapJaxb = this.m_objFactory.createServerDevice();
            OAHelper oaHelper = OAHelper.getOAHelper();
            OLBlade bladeDevice = (OLBlade)oaHelper.getOLDevice(node, node);
            OLBladePortMap bladePortMapInfo = bladeDevice.getOLBladePortMap();
            List bladeMezzList = bladePortMapInfo.getMezzTypeList();
            List jaxbMezzDeviceList = bladePortMapJaxb.getMEZZDevice();
            this.createHeadersForBladePortMap(bladePortMapJaxb);
            if (bladeMezzList.size() == 0) {
                bladePortMapJaxb.setHasPortMapInfo("Absent");
            } else {
                bladePortMapJaxb.setHasPortMapInfo("Present");
                this.renderMezzInfoForFixedNics(bladeMezzList, jaxbMezzDeviceList);
                this.renderMezzInfoForMezzDevices(bladeMezzList, jaxbMezzDeviceList);
            }
            serverPortMappingJaxb.setServerDevice(bladePortMapJaxb);
            return this.renderPortMappingXML(serverPortMappingJaxb);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderXMLForBlade");
        }
        catch (OAException oae) {
            BladeIMELogger.log(oae, "OAException in DevicePortMapping.renderXMLForBlade()");
        }
        return null;
    }

    private void createHeadersForBladePortMap(ServerDevice bladePortMapJaxb) {
        BladeIMELogger.log("DevicePortMapping.createHeadersForBladePortMap");
        try {
            ServerDeviceType.I18NType i18N = this.m_objFactory.createServerDeviceTypeI18NType();
            i18N.setL10NMezzSlot(this.m_manager.getString("PortMap.MezzSlot", this.m_loginBean.getLocale()));
            i18N.setL10NDevicePort(this.m_manager.getString("PortMap.MezzDevicePort", this.m_loginBean.getLocale()));
            i18N.setL10NPortStatus(this.m_manager.getString("PortMap.Port Status", this.m_loginBean.getLocale()));
            i18N.setL10NInterConnect(this.m_manager.getString("PortMap.Interconnect", this.m_loginBean.getLocale()));
            i18N.setL10NBayPort(this.m_manager.getString("PortMap.Bay Port", this.m_loginBean.getLocale()));
            i18N.setL10NDeviceID(this.m_manager.getString("portMap.DeviceID", this.m_loginBean.getLocale()));
            i18N.setL10NMezzanine(this.m_manager.getString("portMap.Mezzanine", this.m_loginBean.getLocale()));
            i18N.setL10NBay(this.m_manager.getString("PortMap.Bay", this.m_loginBean.getLocale()));
            i18N.setL10NNotAvailable(this.m_manager.getString("NOT_AVAILABLE", this.m_loginBean.getLocale()));
            i18N.setL10NENET(this.m_manager.getString("portMap.ENET", this.m_loginBean.getLocale()));
            i18N.setL10NPort(this.m_manager.getString("portMap.Port", this.m_loginBean.getLocale()));
            i18N.setL10NMezzDeviceName(this.m_manager.getString("portMap.MezzanineDevice", this.m_loginBean.getLocale()));
            bladePortMapJaxb.setI18N(i18N);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.createHeadersForBladePortMap");
        }
    }

    private void renderMezzInfoForFixedNics(List mezzDeviceInfoList, List mezzDeviceJaxbList) {
        BladeIMELogger.log("DevicePortMapping.renderMezzInfoForFixedNics");
        try {
            int mezzDeviceInfoSize = mezzDeviceInfoList.size();
            BladeIMELogger.log("Number of Mezzanine devices present in the server:" + mezzDeviceInfoSize);
            OLBladePortMap.MezzType mezzTypeInfo = null;
            MEZZDevice mezzJaxbDevice = null;
            OLBladePortMap.MezzType.DeviceType mezzDeviceType = null;
            for (int i = 0; i < mezzDeviceInfoSize; ++i) {
                mezzTypeInfo = (OLBladePortMap.MezzType)mezzDeviceInfoList.get(i);
                mezzDeviceType = mezzTypeInfo.getDeviceType();
                BladeIMELogger.log("The DeviceType for the Mezzanine Device is:" + mezzDeviceType);
                if (!mezzDeviceType.getType().equalsIgnoreCase("MEZZ_SLOT_TYPE_FIXED") && !mezzDeviceType.getType().equalsIgnoreCase("MEZZ_DEV_TYPE_FIXED")) continue;
                BladeIMELogger.log("Update the JAXB objects with the Fixed NICS Information present for this server");
                mezzJaxbDevice = this.m_objFactory.createMEZZDevice();
                mezzJaxbDevice.setMezzSlot(this.m_manager.getString("portMap.ENET", this.m_loginBean.getLocale()));
                this.renderMezzInfo(mezzTypeInfo, mezzJaxbDevice, mezzDeviceJaxbList);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderMezzInfoForFixedNics");
        }
    }

    private void renderMezzInfoForMezzDevices(List mezzDeviceInfoList, List mezzDeviceJaxbList) {
        BladeIMELogger.log("DevicePortMapping.renderMezzInfoForMezzDevices");
        try {
            int mezzDeviceInfoSize = mezzDeviceInfoList.size();
            BladeIMELogger.log("Number of Mezzanine devices present in the server:" + mezzDeviceInfoSize);
            OLBladePortMap.MezzType mezzTypeInfo = null;
            MEZZDevice mezzJaxbDevice = null;
            OLBladePortMap.MezzType.DeviceType mezzDeviceType = null;
            for (int i = 0; i < mezzDeviceInfoSize; ++i) {
                mezzTypeInfo = (OLBladePortMap.MezzType)mezzDeviceInfoList.get(i);
                mezzDeviceType = mezzTypeInfo.getDeviceType();
                BladeIMELogger.log("The DeviceType for the Mezzanine Device is:" + mezzDeviceType);
                if (mezzDeviceType.getType().equalsIgnoreCase("MEZZ_SLOT_TYPE_FIXED") || mezzDeviceType.getType().equalsIgnoreCase("MEZZ_DEV_TYPE_FIXED")) continue;
                BladeIMELogger.log("Update the JAXB objects with the Mezz Device Port mapping information present for this server");
                mezzJaxbDevice = this.m_objFactory.createMEZZDevice();
                mezzJaxbDevice.setMezzSlot(mezzTypeInfo.getNumber());
                this.renderMezzInfo(mezzTypeInfo, mezzJaxbDevice, mezzDeviceJaxbList);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderMezzInfoForMezzDevices");
        }
    }

    private void renderMezzInfo(OLBladePortMap.MezzType mezzTypeInfo, MEZZDevice mezzJaxbDevice, List mezzDeviceJaxbList) {
        BladeIMELogger.log("DevicePortMapping.renderMezzInfo");
        OLBladePortMap.MezzType.DeviceType mezzDeviceTypeInfo = mezzTypeInfo.getDeviceType();
        OLBladePortMap.MezzType.SlotType mezzSlotTypeInfo = mezzTypeInfo.getSlotType();
        String deviceName = mezzDeviceTypeInfo.getName();
        BladeIMELogger.log("The Mezz Device Name from OA:" + deviceName);
        if (deviceName == null || deviceName.equalsIgnoreCase("")) {
            deviceName = this.m_manager.getString("PortMap.NoDevice", this.m_loginBean.getLocale());
        }
        mezzJaxbDevice.setMezzSlotName(deviceName);
        mezzJaxbDevice.setMezzSlotType(mezzDeviceTypeInfo.getType());
        this.renderMezzPortInfo(mezzSlotTypeInfo.getPortTypeList(), mezzDeviceTypeInfo.getPortTypeList(), mezzJaxbDevice);
        mezzDeviceJaxbList.add(mezzJaxbDevice);
    }

    private void renderMezzPortInfo(List mezzSlotPortList, List mezzDevicePortList, MEZZDevice mezzJaxbDevice) {
        BladeIMELogger.log("DevicePortMapping.renderMezzPortInfo");
        try {
            int noOfSlotPorts = mezzSlotPortList.size();
            List jaxbMezzPortList = mezzJaxbDevice.getMezzPort();
            MezzPort jaxbMezzPort = null;
            OLBladePortMap.MezzType.SlotType.PortType mezzSlotPort = null;
            OLBladePortMap.MezzType.DeviceType.PortType mezzDevicePort = null;
            BladeIMELogger.log("Number of Ports present for this slot:" + noOfSlotPorts);
            List portsList = this.getPortsListFromMezzDevice(mezzDevicePortList);
            String portNumber = null;
            for (int i = 0; i < noOfSlotPorts; ++i) {
                jaxbMezzPort = this.m_objFactory.createMezzPort();
                mezzSlotPort = (OLBladePortMap.MezzType.SlotType.PortType)mezzSlotPortList.get(i);
                portNumber = mezzSlotPort.getNumber();
                jaxbMezzPort.setMezzDevicePort(portNumber);
                jaxbMezzPort.setInterConnectBay(mezzSlotPort.getTrayBayNumber());
                jaxbMezzPort.setInterConnectBayPort(this.m_manager.getString("portMap.Port", this.m_loginBean.getLocale()) + mezzSlotPort.getTrayPortNumber());
                mezzDevicePort = this.getMezzDeviceForPort(portNumber, portsList, mezzDevicePortList);
                if (mezzDevicePort != null) {
                    jaxbMezzPort.setDeviceID(mezzDevicePort.getWWPN());
                    jaxbMezzPort.setPortStatus(this.renderPortStatus(mezzDevicePort.getStatus()));
                    jaxbMezzPort.setInterConnectTrayType(mezzDevicePort.getType());
                } else {
                    jaxbMezzPort.setPortStatus(this.renderPortStatus("UNKNOWN"));
                }
                jaxbMezzPortList.add(jaxbMezzPort);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderMezzPortInfo");
        }
    }

    private List getPortsListFromMezzDevice(List mezzDevicePortList) {
        BladeIMELogger.log("DevicePort");
        int mezzDevicePortSize = mezzDevicePortList.size();
        OLBladePortMap.MezzType.DeviceType.PortType mezzDevicePort = null;
        ArrayList<String> portList = new ArrayList<String>();
        for (int i = 0; i < mezzDevicePortSize; ++i) {
            mezzDevicePort = (OLBladePortMap.MezzType.DeviceType.PortType)mezzDevicePortList.get(i);
            portList.add(mezzDevicePort.getNumber());
        }
        return portList;
    }

    private OLBladePortMap.MezzType.DeviceType.PortType getMezzDeviceForPort(String portNumber, List portList, List mezzDevicePortList) {
        if (portNumber != null && portList.contains(portNumber)) {
            return (OLBladePortMap.MezzType.DeviceType.PortType)mezzDevicePortList.get(portList.indexOf(portNumber));
        }
        return null;
    }

    private PortStatus renderPortStatus(String status) {
        BladeIMELogger.log("DevicePortMapping.renderPortStatus");
        try {
            PortStatus portStatus = this.m_objFactory.createPortStatus();
            portStatus.setPortStatusString(status);
            portStatus.setPortStatusValue(this.getStatusValue(status));
            return portStatus;
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderPortStatus");
            return null;
        }
    }

    private String getStatusValue(String statusStr) {
        BladeIMELogger.log("DevicePortMapping.getStatus(String " + statusStr + ")");
        if (statusStr.equalsIgnoreCase("OK")) {
            return this.m_manager.getString("PortMap.Ok", this.m_loginBean.getLocale());
        }
        if (statusStr.equalsIgnoreCase("MISMATCH")) {
            return this.m_manager.getString("PortMap.Mismatch", this.m_loginBean.getLocale());
        }
        return "UNKNOWN";
    }

    private String renderPortMappingXML(PortMapping jaxbPortMapObj) {
        BladeIMELogger.log("DevicePortMapping.renderPortMappingXML");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.hp.mx.portal.portMapping.OAPortMappingJaxb");
            Marshaller xmlMarshaller = jc.createMarshaller();
            xmlMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter xmlString = new StringWriter(3000);
            xmlMarshaller.marshal((Object)jaxbPortMapObj, (Writer)xmlString);
            BladeIMELogger.log("PortMapping XML:" + xmlString);
            return xmlString.toString();
        }
        catch (PropertyException e) {
            BladeIMELogger.log((Exception)((Object)e), "PropertyException in DevicePortMapping.renderPortMappingXML");
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderPortMappingXML");
        }
        return null;
    }

    public String renderXMLForSwitch(MxNode node) {
        BladeIMELogger.log("DevicePortMapping.renderXMLForSwitch");
        try {
            PortMapping switchPortMappingJaxb = this.m_objFactory.createPortMapping();
            InterConnectDevice switchJaxbDevice = this.m_objFactory.createInterConnectDevice();
            OAHelper oaHelper = OAHelper.getOAHelper();
            OLSwitch switchType = (OLSwitch)oaHelper.getOLDevice(node, node);
            OLSwitchPortMap switchPortMap = switchType.getOLSwitchPortMap();
            List switchSlotTypeList = switchPortMap.getSlotTypeList();
            this.createHeadersForSwitchPortMap(switchJaxbDevice);
            if (switchSlotTypeList.size() == 0) {
                BladeIMELogger.log("The Port Mapping information is not present.So add ABSENT to the Switch Port mapping XML");
                switchJaxbDevice.setHasPortMapInfo("Absent");
            } else {
                switchJaxbDevice.setHasPortMapInfo("Present");
                this.renderInterconnectSlotInfo(switchSlotTypeList, switchJaxbDevice);
            }
            switchPortMappingJaxb.setInterConnectDevice(switchJaxbDevice);
            return this.renderPortMappingXML(switchPortMappingJaxb);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderXMLForSwitch");
        }
        catch (OAException oae) {
            BladeIMELogger.log(oae, "OAException in DevicePortMapping.renderXMLForSwitch");
        }
        return null;
    }

    private void createHeadersForSwitchPortMap(InterConnectDevice jaxbSwitchDevice) {
        BladeIMELogger.log("DevicePortMapping.createHeadersForSwitchPortMap");
        try {
            InterConnectDeviceType.I18NType i18N = this.m_objFactory.createInterConnectDeviceTypeI18NType();
            i18N.setL10NInterConnect(this.m_manager.getString("PortMap.Interconnect", this.m_loginBean.getLocale()));
            i18N.setL10NBayPort(this.m_manager.getString("PortMap.Bay Port", this.m_loginBean.getLocale()));
            i18N.setL10NPortStatus(this.m_manager.getString("PortMap.Port Status", this.m_loginBean.getLocale()));
            i18N.setL10NServerBay(this.m_manager.getString("portMap.Server Bay", this.m_loginBean.getLocale()));
            i18N.setL10NMezzPort(this.m_manager.getString("portMap.Mezz Port", this.m_loginBean.getLocale()));
            i18N.setL10NBay(this.m_manager.getString("PortMap.Bay", this.m_loginBean.getLocale()));
            i18N.setL10NPort(this.m_manager.getString("portMap.Port", this.m_loginBean.getLocale()));
            i18N.setL10NConnected(this.m_manager.getString("PortMap.Connected", this.m_loginBean.getLocale()));
            i18N.setL10NNoConnection(this.m_manager.getString("PortMap.NoConnection", this.m_loginBean.getLocale()));
            i18N.setL10NNotAvailable(this.m_manager.getString("NOT_AVAILABLE", this.m_loginBean.getLocale()));
            jaxbSwitchDevice.setI18N(i18N);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.createHeadersForSwitchPortMap");
        }
    }

    private void renderInterconnectSlotInfo(List switchSlotTypeList, InterConnectDevice jaxbSwitchDevice) {
        BladeIMELogger.log("DevicePortMapping.renderInterconnectSlotInfo");
        try {
            int switchSlotSize = switchSlotTypeList.size();
            List jaxbSwitchSlotsList = jaxbSwitchDevice.getInterConnectSlot();
            InterConnectSlot jaxbSwitchSlot = null;
            OLSwitchPortMap.SlotType switchSlotType = null;
            BladeIMELogger.log("The Number of slots for the switch:" + switchSlotSize);
            for (int i = 0; i < switchSlotSize; ++i) {
                switchSlotType = (OLSwitchPortMap.SlotType)switchSlotTypeList.get(i);
                jaxbSwitchSlot = this.m_objFactory.createInterConnectSlot();
                jaxbSwitchSlot.setInterConnectSlotNumber(switchSlotType.getNumber());
                List switchPortTypeList = switchSlotType.getPortTypeList();
                this.renderInterConnectTrayPortInfo(switchPortTypeList, jaxbSwitchSlot);
                jaxbSwitchSlotsList.add(jaxbSwitchSlot);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in DevicePortMapping.renderInterconnectSlotInfo");
        }
    }

    private void renderInterConnectTrayPortInfo(List switchPortTypeList, InterConnectSlot jaxbSwitchSlot) {
        BladeIMELogger.log("DevicePortMapping.renderInterConnectTrayPortInfo");
        try {
            int switchPortSize = switchPortTypeList.size();
            List jaxbSwitchPortsList = jaxbSwitchSlot.getInterConnectTrayPort();
            OLSwitchPortMap.SlotType.PortType switchPortType = null;
            InterConnectSlotType.InterConnectTrayPortType jaxbSwitchPort = null;
            BladeIMELogger.log("The Number of ports for the Switch:" + switchPortSize);
            Object status = null;
            for (int i = 0; i < switchPortSize; ++i) {
                switchPortType = (OLSwitchPortMap.SlotType.PortType)switchPortTypeList.get(i);
                jaxbSwitchPort = this.m_objFactory.createInterConnectSlotTypeInterConnectTrayPortType();
                jaxbSwitchPort.setPortNumber(switchPortType.getNumber());
                jaxbSwitchPort.setServerBay(switchPortType.getBladeBayNumber());
                jaxbSwitchPort.setServerMezzSlot(switchPortType.getBladeMezzNumber());
                jaxbSwitchPort.setServerMezzPort(switchPortType.getBladeMezzPortNumber());
                jaxbSwitchPort.setPortStatus(this.renderPortStatus(switchPortType.getStatus()));
                jaxbSwitchPortsList.add(jaxbSwitchPort);
            }
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "Exception in DevicePortMapping.renderInterConnectTrayPortInfo");
        }
    }
}

