/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DeviceInfoBean {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private MxNode m_node = null;
    MonteroBean m_MonteroBean = null;
    private int m_deviceKey = -1;
    private String m_strCpuType = "";
    private int m_numLogicalDrives = 0;
    private PreparedStatement m_sqlCPUQuery = null;
    private PreparedStatement m_sqlNumDrivesQuery = null;

    public void initialize(MonteroBean monteroBean, int deviceKey) {
        block7: {
            if (this.m_deviceKey != -1 && this.m_deviceKey == deviceKey) {
                if (m_log.isDebugEnabled()) {
                    m_log.debug((Object)("DeviceInfoBean is already initialized for nodeId:" + deviceKey));
                }
                return;
            }
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("Start: Initializing the MonteroDeviceBean for nodeId:" + deviceKey));
            }
            this.m_deviceKey = deviceKey;
            this.m_MonteroBean = monteroBean;
            this.m_MonteroBean.getSQLUtil().pollConnection();
            if (this.m_sqlCPUQuery == null || this.m_sqlNumDrivesQuery == null) {
                String cpuTypeQuery = "select Name,CurrentClockSpeed FROM CIM_Processor where Name != '' and NodeId = ?";
                String numDrivesQuery = "select count(*) FROM CIM_LogicalDisk WHERE NodeId = ?";
                this.m_sqlNumDrivesQuery = this.m_MonteroBean.getSQLUtil().createPreparedStatement(numDrivesQuery.toString());
                this.m_sqlCPUQuery = this.m_MonteroBean.getSQLUtil().createPreparedStatement(cpuTypeQuery.toString());
            }
            try {
                this.m_node = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                this.m_numLogicalDrives = this.getDiskDrivesFromDb();
                this.m_strCpuType = this.getCpuInfoFromDb();
            }
            catch (Exception e) {
                if (!m_log.isEnabledFor((Priority)Level.ERROR)) break block7;
                m_log.error((Object)"Error initializing deviceinfoBean: ", (Throwable)e);
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("End: Initializing the MonteroDeviceBean for nodeId:" + deviceKey));
        }
    }

    public String getCpuType() {
        return this.m_strCpuType;
    }

    public MxNode getMxNode() {
        return this.m_node;
    }

    public int getNumberLogicalDrives() {
        return this.m_numLogicalDrives;
    }

    private String friendlyCPUSpeed(String strSpeed) {
        int speed;
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)("DeviceInfoBean.friendlyCPUSpeed(" + strSpeed + ")"));
        }
        StringBuffer sb = new StringBuffer();
        try {
            speed = Integer.parseInt(strSpeed);
        }
        catch (NumberFormatException ex) {
            speed = 0;
            m_log.debug((Object)"Default CPU speed assumed", (Throwable)ex);
        }
        if (speed > 0) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(2);
            if ((double)speed >= 1000.0) {
                sb.append(nf.format((double)speed / 1000.0));
            } else {
                sb.append(nf.format(speed));
            }
            sb.append(" ");
            sb.append(MonteroResourceManager.getInstance().getString("cpu.abbreviation.mhz", this.m_MonteroBean.getLoginBean().getLocale()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCpuInfoFromDb() {
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)"Start:DeviceInfoBean.getCpuInfoFromDb()");
        }
        StringBuffer cpuInfo = new StringBuffer(MonteroResourceManager.getInstance().getString("UNKNOWN", this.m_MonteroBean.getLoginBean().getLocale()));
        ResultSet resultSet = null;
        try {
            this.m_sqlCPUQuery.setInt(1, this.m_node.getDeviceKey());
            resultSet = this.m_sqlCPUQuery.executeQuery();
            int cpuCount = 0;
            String cpuDescription = "";
            String cpuSpeed = "";
            while (resultSet.next()) {
                if (cpuCount == 0) {
                    cpuDescription = resultSet.getString(1);
                    cpuSpeed = this.friendlyCPUSpeed(resultSet.getString(2));
                }
                ++cpuCount;
            }
            if (cpuCount > 0 && cpuSpeed.length() > 0 && cpuDescription.length() > 0) {
                cpuInfo.delete(0, cpuInfo.length());
                cpuInfo.append(cpuCount);
                cpuInfo.append(" x ");
                cpuInfo.append(cpuSpeed);
                cpuInfo.append(" ");
                cpuInfo.append(cpuDescription);
            }
        }
        catch (SQLException sqlException) {
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.error((Object)"SQL Exception:", (Throwable)sqlException);
            }
        }
        catch (Exception ex) {
            if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                m_log.error((Object)"Exception:", (Throwable)ex);
            }
        }
        finally {
            block24: {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sqlException) {
                    if (!m_log.isEnabledFor((Priority)Level.DEBUG)) break block24;
                    m_log.error((Object)"Exception in finally clause", (Throwable)sqlException);
                }
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("Type Of CPU :" + cpuInfo.toString()));
            m_log.debug((Object)"End:DeviceInfoBean.getCpuInfoFromDb()");
        }
        return cpuInfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDiskDrivesFromDb() {
        if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
            m_log.debug((Object)"DeviceInfoBean.getDiskDrivesFromDb()");
        }
        ResultSet resultSet = null;
        int count = 0;
        try {
            this.m_sqlNumDrivesQuery.setInt(1, this.m_node.getDeviceKey());
            resultSet = this.m_sqlNumDrivesQuery.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        catch (SQLException sqlException) {
            if (m_log.isEnabledFor((Priority)Level.ERROR)) {
                m_log.error((Object)"DeviceInfoBean.getCpuInfoFromDb()", (Throwable)sqlException);
            }
        }
        catch (Exception ex) {
            if (m_log.isEnabledFor((Priority)Level.ERROR)) {
                m_log.error((Object)("DeviceInfoBean.getCpuInfoFromDb():" + ex));
            }
        }
        finally {
            block21: {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sqlException) {
                    if (!m_log.isEnabledFor((Priority)Level.DEBUG)) break block21;
                    m_log.error((Object)"DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", (Throwable)sqlException);
                }
            }
        }
        return count;
    }

    public MonteroBean getMonteroBean() {
        return this.m_MonteroBean;
    }
}

