/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.DeviceType;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Status;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.sun.xml.bind.JAXBObject;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Element;

public class MxBPVSwitch
extends MxBPVElement {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private MonteroResourceManager manager = MonteroResourceManager.getInstance();
    ObjectFactory m_objFactory = new ObjectFactory();
    int slotsOccupiedByXDirection;
    int slotsOccupiedByYDirection;

    public MxBPVSwitch(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.slotsOccupiedByXDirection = nodeAssociations.getNumBladeSlotsUsedXDir();
        this.slotsOccupiedByYDirection = nodeAssociations.getNumBladeSlotsUsedYDir();
        this.deviceType = "Switch";
    }

    public int getNumSlotsUsedYDir() {
        return 2;
    }

    String getDrillDownURL() {
        if (m_log.isEnabledFor((Priority)Level.INFO)) {
            m_log.info((Object)"MxBPVServer.getDrillDownURL()");
        }
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + MxDrillDown.DEVICE_NAME_DRILL_DOWN + "&globalselection=true";
    }

    public Element renderXML() {
        if (m_log.isEnabledFor((Priority)Level.INFO)) {
            m_log.info((Object)"MxBPVSwitch.renderXML()");
        }
        BPVXML bpvXml = BPVXML.getInstance();
        Element bpv_switch = bpvXml.createDevice(this, false);
        return bpv_switch;
    }

    public JAXBObject renderJAXBXML() {
        BladeIMELogger.log("MxBPVSwitch:renderJAXBXML");
        try {
            Device device = this.m_objFactory.createDevice();
            device.setBayType("Switch");
            device.setLocation("Rear");
            this.setSlotsInfoForDevice(device);
            this.setCommonInfoForDevice(device);
            Status status = this.m_objFactory.createStatus();
            String deviceStatus = this.getStatus();
            BladeIMELogger.log("Status of the switch is:" + deviceStatus);
            if (deviceStatus == null) {
                deviceStatus = "Unknown";
            }
            status.setUID(deviceStatus);
            String deviceStatTitle = MonteroResourceManager.getInstance().getString("xml." + deviceStatus, this.getLoginBean().getLocale());
            status.setTitle(deviceStatTitle);
            device.setStatus(status);
            return (JAXBObject)device;
        }
        catch (JAXBException je) {
            BladeIMELogger.log((Exception)((Object)je), "JAXBException in MxBPVSwitch.renderJAXBXML");
            return null;
        }
    }

    private void setSlotsInfoForDevice(DeviceType device) {
        BladeIMELogger.log("MxBPVSwitch.setSlotsInfoForDevice");
        try {
            device.setSlotNumber(this.slotNumber);
            device.setHasDevice("PRESENT");
            SlotsUsed slots = this.m_objFactory.createSlotsUsed();
            BladeIMELogger.log("X Direction:" + this.slotsOccupiedByXDirection);
            BladeIMELogger.log("Y Direction:" + this.slotsOccupiedByYDirection);
            slots.setXDirection(this.slotsOccupiedByXDirection);
            slots.setYDirection(this.slotsOccupiedByYDirection);
            device.setSlotsUsed(slots);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVSwitch.setSlotsInfoForDevice");
        }
    }

    private void setCommonInfoForDevice(DeviceType device) {
        BladeIMELogger.log("MxBPVSwitch.setCommonInfoForDevice");
        try {
            DeviceType.CommonType common = this.m_objFactory.createDeviceTypeCommonType();
            common.setName(this.getDeviceName());
            common.setProduct(this.node.getModel());
            common.setSerialNum(this.node.getSerialNumber());
            common.setNodeId(this.node.getGUID().toString());
            common.setDrillDownURL(this.getDrillDownURL());
            device.setCommon(common);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVSwitch.setCommonInfoForDevice");
        }
    }

    private String getDeviceName() {
        String name = this.node.getNameString();
        if (name == null) {
            name = this.node.getWorkingAddress();
        }
        BladeIMELogger.log("MxBPVSwitch.getDeviceName returns:The Switch name is:" + name);
        return name;
    }
}

