/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVIceServerEnclosure;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.DeviceType;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.portal.bpv.OABPVXmlJaxb.Status;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.sun.xml.bind.JAXBObject;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Element;

public class MxBPVServer
extends MxBPVElement {
    private static Logger log_ = Logger.getLogger((String)"Montero");
    private int numSlotsUsed;
    private int numSlotsUsedXDir;
    private int numSlotsUsedYDir;
    ObjectFactory m_objFactory = new ObjectFactory();
    private MonteroResourceManager manager = MonteroResourceManager.getInstance();

    public MxBPVServer(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        if (log_.isEnabledFor((Priority)Level.INFO)) {
            log_.info((Object)("MxBPVServer.MxBPVServer(" + node + "," + parent + "," + loginBean + ")"));
        }
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.numSlotsUsed = nodeAssociations.getNumBladeSlotsUsed();
        this.numSlotsUsedXDir = nodeAssociations.getNumBladeSlotsUsedXDir();
        this.numSlotsUsedYDir = nodeAssociations.getNumBladeSlotsUsedYDir();
        if (parent instanceof MxBPVIceServerEnclosure) {
            this.numSlotsUsedYDir = 2;
        }
        if (this.numSlotsUsedXDir * this.numSlotsUsedYDir != this.numSlotsUsed) {
            this.numSlotsUsedXDir = this.numSlotsUsed;
            this.numSlotsUsedYDir = 2;
        }
        this.deviceType = "BladeServer";
    }

    public int getNumSlotsUsed() {
        return this.numSlotsUsed;
    }

    public int getNumSlotsUsedXDir() {
        return this.numSlotsUsedXDir;
    }

    public int getNumSlotsUsedYDir() {
        return this.numSlotsUsedYDir;
    }

    String getDrillDownURL(String drillDownType) {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.info((Object)"MxBPVServer.getDrillDownURL()");
        }
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + drillDownType + "&globalselection=true";
    }

    public Element renderXML() {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"MxBPVServer.renderXML()");
        }
        BPVXML bpvXml = BPVXML.getInstance();
        Element server = bpvXml.createDevice(this, false);
        return server;
    }

    public JAXBObject renderJAXBXML() {
        BladeIMELogger.log("MxBPVServer.renderJAXBXML");
        try {
            Device device = this.m_objFactory.createDevice();
            device.setBayType("Server");
            device.setLocation("Front");
            this.setSlotsInfoForDevice(device);
            this.setCommonInfoForDevice(device);
            Status status = this.m_objFactory.createStatus();
            String deviceStatus = this.getStatus();
            BladeIMELogger.log("Server status:" + deviceStatus);
            if (deviceStatus == null) {
                deviceStatus = "Unknown";
            }
            String deviceStatTitle = MonteroResourceManager.getInstance().getString("xml." + deviceStatus, this.getLoginBean().getLocale());
            status.setUID(deviceStatus);
            status.setTitle(deviceStatTitle);
            device.setStatus(status);
            this.setAutomationStatus(device);
            return (JAXBObject)device;
        }
        catch (JAXBException je) {
            BladeIMELogger.log((Exception)((Object)je), "JAXBException in MxBPVServer:renderJAXBXML()");
            return null;
        }
    }

    private void setSlotsInfoForDevice(DeviceType device) {
        BladeIMELogger.log("MxBPVServer.setSlotsInfoForDevice");
        try {
            device.setSlotNumber(this.slotNumber);
            device.setHasDevice("PRESENT");
            SlotsUsed slots = this.m_objFactory.createSlotsUsed();
            BladeIMELogger.log("X Direction:" + this.numSlotsUsedXDir);
            BladeIMELogger.log("Y Direction:" + this.numSlotsUsedYDir);
            slots.setXDirection(this.numSlotsUsedXDir);
            slots.setYDirection(this.numSlotsUsedYDir);
            device.setSlotsUsed(slots);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVServer.setSlotsInfoForDevice");
        }
    }

    private void setCommonInfoForDevice(DeviceType device) {
        log_.debug((Object)"MxBPVServer.setCommonInfoForDevice");
        try {
            DeviceType.CommonType common = this.m_objFactory.createDeviceTypeCommonType();
            common.setName(this.getDeviceName());
            common.setProduct(this.node.getModel());
            common.setSerialNum(this.node.getSerialNumber());
            common.setNodeId(this.node.getGUID().toString());
            common.setDrillDownURL(this.getDrillDownURL(MxDrillDown.DEVICE_NAME_DRILL_DOWN));
            common.setHomepageURL(this.getDrillDownURL(MxDrillDown.HW_STATUS_DRILL_DOWN));
            device.setCommon(common);
        }
        catch (JAXBException e) {
            BladeIMELogger.log((Exception)((Object)e), "JAXBException in MxBPVServer.setCommonInfoForDevice");
        }
    }

    private void setAutomationStatus(DeviceType device) {
    }

    private String getDeviceName() {
        String name = this.node.getNameString();
        if (name == null) {
            name = this.node.getWorkingAddress();
        }
        BladeIMELogger.log("MxBPVServer.getDeviceName returns:The Server name:" + name);
        return name;
    }
}

