/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVContainer;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVPowerSupplyEnclosure;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import com.sun.xml.bind.JAXBObject;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Content;
import org.jdom.Element;

public class MxBPVRack
extends MxBPVContainer {
    private static Logger log_ = Logger.getLogger((String)"Montero");

    public MxBPVRack(MxNode node, MxLoginBean loginBean) throws Exception {
        super(node, null, loginBean);
        this.deviceType = "Rack";
    }

    public Element renderXML() throws MxBPVException {
        if (log_.isEnabledFor((Priority)Level.DEBUG)) {
            log_.debug((Object)"MxBPVRack.renderXML()");
        }
        BPVXML bpvXml = BPVXML.getInstance();
        Iterator iter = this.iterator();
        Element root = bpvXml.createRack(this, this.loginBean, iter.hasNext());
        log_.info((Object)("Iterator:" + iter.toString()));
        while (iter.hasNext()) {
            MxBPVElement childElement = (MxBPVElement)iter.next();
            Element device = childElement.renderXML();
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)("The childElement Document:" + device.getDocument()));
            }
            if (device.getDocument() != null) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)"The Child Element is already having the document.So clone the contents to add to the Root element");
                }
                root.addContent((Content)((Element)device.clone()));
                continue;
            }
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)"Add the child element contents to the Root");
            }
            root.addContent((Content)device);
        }
        return root;
    }

    public void populateAll() throws Exception {
        if (log_.isEnabledFor((Priority)Level.INFO)) {
            log_.info((Object)"MxBPVRack.populateAll()");
        }
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        DefaultMutableTreeNode rack = nodeAssociations.getContainerDeviceTree();
        Enumeration<TreeNode> enumeration = rack.children();
        while (enumeration.hasMoreElements()) {
            MxBPVContainer enclosureElement;
            DefaultMutableTreeNode enclosureNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Integer devKey = (Integer)enclosureNode.getUserObject();
            MxNode childNode = nodeClient.getNodeByKey(devKey.intValue(), false);
            if (!childNode.getDeviceType().equals("Enclosure")) continue;
            List subTypes = childNode.getDeviceSubTypes();
            if (subTypes.contains("PowerEnc")) {
                if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                    log_.debug((Object)"Adding Power enclosure");
                }
                enclosureElement = new MxBPVPowerSupplyEnclosure(childNode, this, this.getLoginBean());
                this.add(enclosureElement);
                continue;
            }
            if (log_.isEnabledFor((Priority)Level.DEBUG)) {
                log_.debug((Object)"Adding Server Enclosure");
            }
            enclosureElement = MxBPVServerEnclosure.create(childNode, this, this.getLoginBean());
            this.add(enclosureElement);
        }
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }
}

