/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.OAXml;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAXmlJaxb.SWITCHPortMap;
import com.hp.mx.portal.OAXml.OLConstants;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.ArrayList;
import java.util.List;

public class OLSwitchPortMap {
    private String status;
    private String passThroughEnabled;
    private List slotTypeList = new ArrayList();
    private final String[] CLIENTATTRIBUTES = new String[]{"SW_PRTMAP_ST_", "SW_PRTMAP_PASTHR_", "SW_PRTMAP_SLT_CNT_"};

    void init(MxNode deviceMxNode, String uniqueIdentifier) {
        BladeIMELogger.log("OLSwitchPortMap.init(" + deviceMxNode + "," + uniqueIdentifier + ")");
        this.status = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier);
        this.passThroughEnabled = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + uniqueIdentifier);
        this.print("OLSwitchPortMap.init DB");
        try {
            int OLSWTICHPORTMAP_SLOT_COUNT = Integer.parseInt(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + uniqueIdentifier));
            BladeIMELogger.log("OLSwitchPortMap.init.OLSWTICHPORTMAP_SLOT_COUNT " + OLSWTICHPORTMAP_SLOT_COUNT);
            SlotType slotType = null;
            for (int i = 0; i < OLSWTICHPORTMAP_SLOT_COUNT; ++i) {
                slotType = this.getSlotType();
                slotType.init(deviceMxNode, uniqueIdentifier, i);
                this.addSlotType(slotType);
            }
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "OLSwitchPortMap.init(DB).Unable to initialize SlotType " + e);
        }
    }

    void init(SWITCHPortMap switchPortMap) {
        BladeIMELogger.log("OLSwitchPortMap.init(" + switchPortMap + ")");
        try {
            this.status = switchPortMap.getSTATUS();
            this.passThroughEnabled = switchPortMap.getPASSTHRUMODEENABLED();
            List tempSlotType = switchPortMap.getSLOT();
            this.print("OLSwitchPortMap.init JAXB");
            SlotType slotType = null;
            for (int i = 0; i < tempSlotType.size(); ++i) {
                try {
                    slotType = this.getSlotType();
                    slotType.init((SWITCHPortMap.SLOTType)tempSlotType.get(i));
                    this.addSlotType(slotType);
                    continue;
                }
                catch (OAException e) {
                    BladeIMELogger.log(e, "OLSwitchPortMap.init(JAXB).OAException " + e);
                }
            }
        }
        catch (Exception e) {
            BladeIMELogger.log(e, "OLSwitchPortMap.init(JAXB).Exception " + e);
        }
    }

    void update(MxNode mxNode, String uniqueIdentifier) {
        BladeIMELogger.log("OLSwitchPortMap.update(" + mxNode + "," + uniqueIdentifier + ")");
        this.print("OLSwitchPortMap.update");
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + uniqueIdentifier, this.status);
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + uniqueIdentifier, this.passThroughEnabled);
        mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + uniqueIdentifier, String.valueOf(this.slotTypeList.size()));
        for (int i = 0; i < this.slotTypeList.size(); ++i) {
            ((SlotType)this.slotTypeList.get(i)).update(mxNode, uniqueIdentifier, i);
        }
    }

    void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("OLSwitchPortMap.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier));
            enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        for (i = 0; i < this.slotTypeList.size(); ++i) {
            ((SlotType)this.slotTypeList.get(i)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i);
        }
    }

    void clean(MxNode deviceMxNode, String uniqueIdentifier) {
        int i;
        BladeIMELogger.log("OLSwitchPortMap.clean(" + deviceMxNode + "," + uniqueIdentifier + ")");
        for (i = 0; i < this.CLIENTATTRIBUTES.length; ++i) {
            deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[i] + uniqueIdentifier);
        }
        for (i = 0; i < this.slotTypeList.size(); ++i) {
            ((SlotType)this.slotTypeList.get(i)).clean(deviceMxNode, uniqueIdentifier, i);
        }
    }

    private void print(String SOURCE) {
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
        BladeIMELogger.log("OLSwitchPortMap.status " + this.status);
        BladeIMELogger.log("OLSwitchPortMap.passThroughEnabled " + this.passThroughEnabled);
        BladeIMELogger.log("OLSwitchPortMap.slotTypeList.size() " + this.slotTypeList.size());
        BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
    }

    private SlotType getSlotType() {
        return new SlotType();
    }

    private void addSlotType(SlotType slotType) {
        this.slotTypeList.add(slotType);
    }

    public String getStatus() {
        return this.status;
    }

    public String getPassthroughEnabled() {
        return this.passThroughEnabled;
    }

    public List getSlotTypeList() {
        return this.slotTypeList;
    }

    public class SlotType {
        private String number;
        private String type;
        private List portTypeList = new ArrayList();
        private final String[] CLIENTATTRIBUTES = new String[]{"SLT_NUM_", "SLT_TYPE_", "SLT_PRT_CNT_"};

        private void init(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("OLSwitchPortMap.SlotType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            this.number = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
            this.type = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty);
            try {
                int OLSWITCHPORTMAP_SLOTTYPE_PORTTYPE_COUNT = Integer.parseInt(deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty));
                BladeIMELogger.log("OLSwitchPortMap.SlotType.init.OLSWITCHPORTMAP_SLOTTYPE_PORTTYPE_COUNT " + OLSWITCHPORTMAP_SLOTTYPE_PORTTYPE_COUNT);
                PortType portType = null;
                for (int j = 0; j < OLSWITCHPORTMAP_SLOTTYPE_PORTTYPE_COUNT; ++j) {
                    portType = this.getPortType();
                    portType.init(deviceMxNode, uniqueIdentifier, i, j);
                    this.addPortType(portType);
                }
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OLSwitchPortMap.SlotType.init(DB).Unable to initialize PortType " + e);
            }
            this.print("OLSwitchPortMap.SlotType.init DB");
        }

        private void init(SWITCHPortMap.SLOTType tempSlotType) throws OAException {
            BladeIMELogger.log("OLSwitchPortMap.SlotType.init(" + tempSlotType + ")");
            try {
                this.number = tempSlotType.getNUMBER().toString();
                this.type = tempSlotType.getTYPE();
                List tempPortTypeList = tempSlotType.getPORT();
                PortType portType = null;
                for (int i = 0; i < tempPortTypeList.size(); ++i) {
                    portType = this.getPortType();
                    portType.init((SWITCHPortMap.SLOTType.PORTType)tempPortTypeList.get(i));
                    this.addPortType(portType);
                }
                this.print("OLSwitchPortMap.SlotType.init JAXB");
            }
            catch (Exception e) {
                throw new OAException(e, "OLSwitchPortMap.SlotType.init(JAXB).Exception " + e);
            }
        }

        private void update(MxNode mxNode, String uniqueIdentifier, int i) {
            BladeIMELogger.log("OLSwitchPortMap.SlotType.update(" + mxNode + "," + uniqueIdentifier + "," + i + ")");
            this.print("OLSwitchPortMap.SlotType.update");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.number);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.type);
            mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, String.valueOf(this.portTypeList.size()));
            for (int j = 0; j < this.portTypeList.size(); ++j) {
                ((PortType)this.portTypeList.get(j)).update(mxNode, uniqueIdentifier, i, j);
            }
        }

        private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i) {
            int j;
            BladeIMELogger.log("OLSwitchPortMap.SlotType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty));
                enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
            }
            for (j = 0; j < this.portTypeList.size(); ++j) {
                ((PortType)this.portTypeList.get(j)).move(deviceMxNode, enclosureMxNode, uniqueIdentifier, i, j);
            }
        }

        private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i) {
            int j;
            BladeIMELogger.log("OLSwitchPortMap.SlotType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + ")");
            String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, uniqueIdentifier);
            for (j = 0; j < this.CLIENTATTRIBUTES.length; ++j) {
                deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[j] + clientAttributeProperty);
            }
            for (j = 0; j < this.portTypeList.size(); ++j) {
                ((PortType)this.portTypeList.get(j)).clean(deviceMxNode, uniqueIdentifier, i, j);
            }
        }

        private void print(String SOURCE) {
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
            BladeIMELogger.log("OLSwitchPortMap.SlotType.number " + this.number);
            BladeIMELogger.log("OLSwitchPortMap.SlotType.type " + this.type);
            BladeIMELogger.log("OLSwitchPortMap.SlotType.portTypeList.size() " + this.portTypeList.size());
            BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
        }

        public String getNumber() {
            return this.number;
        }

        public String getType() {
            return this.type;
        }

        public List getPortTypeList() {
            return this.portTypeList;
        }

        public PortType getPortType() {
            return new PortType();
        }

        public void addPortType(PortType portType) {
            this.portTypeList.add(portType);
        }

        public class PortType {
            private String number;
            private String bladeBayNumber;
            private String bladeMezzNumber;
            private String bladeMezzPortNumber;
            private String status;
            private String enabled;
            private String uuidStatus;
            private String linkLedStatus;
            private final String[] CLIENTATTRIBUTES = new String[]{"SLT_PRT_NUM_", "SLT_PRT_BAY_", "SLT_PRT_MEZ_", "SLT_PRT_PRT_NUM_", "SLT_PRT_ST_", "SLT_PRT_ENABLED_", "SLT_PRT_UUIDST_", "SLT_PRT_LEDST_"};

            private void init(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.init(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                this.number = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty);
                this.bladeBayNumber = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty);
                this.bladeMezzNumber = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty);
                this.bladeMezzPortNumber = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty);
                this.status = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[4] + clientAttributeProperty);
                this.enabled = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[5] + clientAttributeProperty);
                this.uuidStatus = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[6] + clientAttributeProperty);
                this.linkLedStatus = deviceMxNode.getClientAttribute(this.CLIENTATTRIBUTES[7] + clientAttributeProperty);
                this.print("OLSwitchPortMap.SlotType.PortType DB");
            }

            private void init(SWITCHPortMap.SLOTType.PORTType tempPortType) throws OAException {
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.init(" + tempPortType + ")");
                try {
                    this.number = tempPortType.getNUMBER().toString();
                    this.bladeBayNumber = tempPortType.getBLADEBAYNUMBER().toString();
                    this.bladeMezzNumber = tempPortType.getBLADEMEZZNUMBER().toString();
                    this.bladeMezzPortNumber = tempPortType.getBLADEMEZZPORTNUMBER().toString();
                    this.status = tempPortType.getSTATUS();
                    this.enabled = tempPortType.getENABLED();
                    this.uuidStatus = tempPortType.getUIDSTATUS();
                    this.linkLedStatus = tempPortType.getLINKLEDSTATUS();
                    this.print("OLSwitchPortMap.SlotType.PortType.init JAXB");
                }
                catch (Exception e) {
                    throw new OAException(e, "OLSwitchPortMap.SlotType.PortType.init(JAXB).Exception " + e);
                }
            }

            private void update(MxNode mxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.update(" + mxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                this.print("OLSwitchPortMap.SlotType.PortType.update");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[0] + clientAttributeProperty, this.number);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[1] + clientAttributeProperty, this.bladeBayNumber);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[2] + clientAttributeProperty, this.bladeMezzNumber);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[3] + clientAttributeProperty, this.bladeMezzPortNumber);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[4] + clientAttributeProperty, this.status);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[5] + clientAttributeProperty, this.enabled);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[6] + clientAttributeProperty, this.uuidStatus);
                mxNode.setClientAttribute(this.CLIENTATTRIBUTES[7] + clientAttributeProperty, this.linkLedStatus);
            }

            private void move(MxNode deviceMxNode, MxNode enclosureMxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.move(" + deviceMxNode + "," + enclosureMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                    deviceMxNode.setClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty, enclosureMxNode.getClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty));
                    enclosureMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty);
                }
            }

            private void clean(MxNode deviceMxNode, String uniqueIdentifier, int i, int j) {
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.clean(" + deviceMxNode + "," + uniqueIdentifier + "," + i + "," + j + ")");
                String clientAttributeProperty = OLConstants.getClientAttributeProperty(i, j, uniqueIdentifier);
                for (int k = 0; k < this.CLIENTATTRIBUTES.length; ++k) {
                    deviceMxNode.removeClientAttribute(this.CLIENTATTRIBUTES[k] + clientAttributeProperty);
                }
            }

            private void print(String SOURCE) {
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " STARTS**********");
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.number " + this.number);
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.bladeBayNumber " + this.bladeBayNumber);
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.bladeMezzNumber " + this.bladeMezzNumber);
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.bladeMezzPortNumber " + this.bladeMezzPortNumber);
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.status " + this.status);
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.enabled " + this.enabled);
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.uuidStatus " + this.uuidStatus);
                BladeIMELogger.log("OLSwitchPortMap.SlotType.PortType.linkLedStatus " + this.linkLedStatus);
                BladeIMELogger.log("*********PRINTING FROM " + SOURCE + " ENDS***********");
            }

            public String getNumber() {
                return this.number;
            }

            public String getBladeBayNumber() {
                return this.bladeBayNumber;
            }

            public String getBladeMezzNumber() {
                return this.bladeMezzNumber;
            }

            public String getBladeMezzPortNumber() {
                return this.bladeMezzPortNumber;
            }

            public String getStatus() {
                return this.status;
            }

            public String getEnabled() {
                return this.enabled;
            }

            public String getUUIDStatus() {
                return this.uuidStatus;
            }

            public String getLinkLedStatus() {
                return this.linkLedStatus;
            }
        }
    }
}

