/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal;

import com.hp.mx.core.client.MxToolClient;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.subjects.usermanager.MxInvalidUserException;
import com.hp.mx.core.subjects.usermanager.MxUndefinedUserException;
import com.hp.mx.core.toolmanager.MxTool;
import com.hp.mx.exceptions.MxFailedAuthenticationException;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.BladeIMELogger;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.portal.utils.MonteroSQLUtils;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MonteroBean {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private MxLoginBean m_loginBean = null;
    private MonteroSQLUtils m_SQLUtil = null;
    private MonteroSNMPUtils m_SNMPUtil = null;

    public void initialize(MxLoginBean loginBean) {
        if (this.m_loginBean == null) {
            this.m_loginBean = loginBean;
            this.m_SQLUtil = new MonteroSQLUtils(this.m_loginBean);
            this.m_SNMPUtil = new MonteroSNMPUtils(this.m_loginBean);
        }
    }

    public MxLoginBean getLoginBean() {
        return this.m_loginBean;
    }

    public MonteroSQLUtils getSQLUtil() {
        return this.m_SQLUtil;
    }

    private MxTool getToolObj(String tId) throws BladeSystemException {
        block9: {
            BladeIMELogger.log("MonteroBean.getToolObj(" + tId + ")");
            MxToolClient toolClient = this.m_loginBean.getToolClient();
            try {
                List tools = toolClient.getToolsForSessionUser();
                int numTools = tools.size();
                MxTool tool = null;
                for (int i = 0; i < numTools; ++i) {
                    tool = (MxTool)tools.get(i);
                    if (!tool.getName().equals((Object)tId)) continue;
                    BladeIMELogger.log("Tool object found returning");
                    return tool;
                }
            }
            catch (MxInvalidTransactionException e) {
                if (m_log.isEnabledFor((Priority)Level.ERROR)) {
                    m_log.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)e);
                }
            }
            catch (MxFailedAuthenticationException e) {
                if (m_log.isEnabledFor((Priority)Level.ERROR)) {
                    m_log.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)e);
                }
            }
            catch (MxInvalidUserException e) {
                if (m_log.isEnabledFor((Priority)Level.ERROR)) {
                    m_log.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)e);
                }
            }
            catch (MxUndefinedUserException e) {
                if (!m_log.isEnabledFor((Priority)Level.ERROR)) break block9;
                m_log.log((Priority)Level.ERROR, (Object)"Error:", (Throwable)e);
            }
        }
        BladeIMELogger.log("Error:Tool with Id not found:" + tId);
        throw new BladeSystemException("Tool with Id not found:" + tId);
    }

    public String getToolId(String tId) throws BladeSystemException {
        MxTool tool = this.getToolObj(tId);
        String toolStringID = tool.getClientAttribute("tool-id");
        String toolObjectID = tool.getObjectID().toString();
        return toolStringID == null ? toolObjectID : toolStringID;
    }

    public String getToolGUID(String tId) throws BladeSystemException {
        BladeIMELogger.log("MonteroBean.getToolGUID(" + tId + ")");
        MxTool tool = this.getToolObj(tId);
        return tool.getGUID().toString();
    }

    public MonteroSNMPUtils getSNMPUtil() {
        return this.m_SNMPUtil;
    }
}

