/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;

public abstract class UnsupportedSwitchHandler
extends RackEnclosureTopologyHandler {
    protected boolean pclassleftSwitchPresent = false;
    protected boolean pclassrightSwitchPresent = false;

    public abstract void getAssociationData(MxNode var1, DeviceIdentificationData var2);

    public abstract void cleanUpAssociationData(MxNode var1);

    public NodeAssociations loadAssociationDataFromDb(MxNode d) {
        return super.loadAssociationDataFromDb(d);
    }

    public abstract void setAssociationType(String var1);

    protected String convertCiscoToHPSerialNumber(String ciscoSerialNumber) {
        StringBuffer tmpSerialNumber = new StringBuffer();
        tmpSerialNumber = tmpSerialNumber.append("CN8");
        int YY = Integer.parseInt(ciscoSerialNumber.substring(3, 5), 10);
        if ((YY -= 4) < 10) {
            tmpSerialNumber = tmpSerialNumber.append("0");
        }
        if (YY < 0) {
            YY = 0;
        }
        int WW = Integer.parseInt(ciscoSerialNumber.substring(5, 7), 10);
        String ZZZ = ciscoSerialNumber.substring(8, 11);
        String genhpSerialNumber = tmpSerialNumber.append(YY).append(WW).append(ZZZ).toString();
        return genhpSerialNumber;
    }

    public void getSwitchAttributesFromTheMib() {
        boolean endOfTable = false;
        String switchesPresentOID = null;
        String switchesLocationOID = null;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.6.1.1.1.12[0],1.3.6.1.4.1.232.22.2.6.1.1.1.13[1]");
        while (!endOfTable) {
            SnmpResponseVarBind vb1;
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            switchesLocationOID = vb.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure - Switches Location OID : " + switchesLocationOID));
            }
            if ((vb1 = curResp.findById(1)) == null || vb1.isError()) break;
            switchesPresentOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure - Switches Present OID : " + switchesPresentOID));
            }
            if (!switchesLocationOID.startsWith("1.3.6.1.4.1.232.22.2.6.1.1.1.12.")) break;
            String temp = vb.getValue().trim();
            if (temp.equalsIgnoreCase("A") || temp.equalsIgnoreCase("Left Side") || temp.equalsIgnoreCase("Network Side A")) {
                if (vb1.getIntValue() == 3) {
                    this.pclassleftSwitchPresent = true;
                }
            } else if ((temp.equalsIgnoreCase("B") || temp.equalsIgnoreCase("Right Side") || temp.equalsIgnoreCase("Network Side B")) && vb1.getIntValue() == 3) {
                this.pclassrightSwitchPresent = true;
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Switches Present for device " + this.device.getDeviceName() + " is left " + this.pclassleftSwitchPresent + " and right " + this.pclassrightSwitchPresent));
            }
            this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
            this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(switchesPresentOID, "0");
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Left Switch  : " + this.pclassleftSwitchPresent));
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Right Switch  : " + this.pclassrightSwitchPresent));
    }

    public UnsupportedSwitchHandler(MxNode d) {
        super(d);
    }
}

