/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SwitchAssociationDataHandler
extends SnmpRackMibHandler {
    private static Logger m_log = Logger.getLogger((String)"Montero");
    private String associationType = "";

    public SwitchAssociationDataHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        if (GlobalSettings.getProperty((String)"switch_code_wakeup", (String)"false").equalsIgnoreCase("true")) {
            block35: {
                boolean associatedDeviceKey = false;
                if (containerDeviceDebug.check(10)) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("IN The SWITCHASSOCIATIONDATAHANDLER.... for device " + d.getDeviceName()));
                }
                if (!d.getDeviceType().equals("Switch")) {
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The SWITCHASSOCIATIONDATAHANDLER.... - Cleaning up the associations");
                    }
                    this.cleanUpAssociationData(d);
                    return;
                }
                String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
                if (!snmpEnabled.equals("checked")) {
                    DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Switch Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName()));
                    return;
                }
                if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
                    DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("Switch Association skipped ; snmp not detected on " + d.getDeviceName()));
                    return;
                }
                String workingAddress = d.getWorkingAddress();
                if (workingAddress == null) {
                    if (containerDeviceDebug.check(10)) {
                        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("SwitchAssociationDataHandler : Working Address is null for device : " + d.getDeviceName()));
                    }
                    return;
                }
                try {
                    String productModel = d.getModel();
                    this.getRackAttributesFromTheMib();
                    if (m_log.isEnabledFor((Priority)Level.DEBUG)) {
                        m_log.debug((Object)("SwitchAssociationDataHandler.productModel " + productModel));
                    }
                    String lowerModel = productModel.toLowerCase();
                    m_log.debug((Object)("lowerModel:" + lowerModel));
                    if (lowerModel.indexOf("c-class") != -1) {
                        m_log.debug((Object)"This is a c-Class switch hence return");
                        return;
                    }
                    if (productModel.equalsIgnoreCase("McDATA 4Gb SAN Switch for HP p-Class BladeSystem") || productModel.equalsIgnoreCase("Brocade 4Gb SAN Switch for HP p-Class BladeSystem")) {
                        this.getCommonEnclosureAttributesAndTopologyFromTheSANMib();
                        d.setClientAttribute("LOCATION", "RearUpperCube");
                    } else {
                        this.getCommonEnclosureAttributesAndTopologyFromTheMib();
                    }
                    this.getSwitchAttributesFromTheMib();
                    while (true) {
                        SwitchAssociationDataHandler switchAssociationDataHandler = this;
                        if (switchAssociationDataHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                        Thread.sleep(100L);
                    }
                    if (productModel.toUpperCase().indexOf("P-CLASS") != -1) {
                        d.addDeviceSubType(NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                    } else if (productModel.toUpperCase().indexOf("E-CLASS") != -1) {
                        d.addDeviceSubType(NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
                    }
                    String lftSWSerNum = null;
                    lftSWSerNum = this.getLeftSwitchSerialNumber();
                    String rghtSWSerNum = null;
                    rghtSWSerNum = this.getRightSwitchSerialNumber();
                    if (lftSWSerNum != null) {
                        d.setSerialNumber(lftSWSerNum);
                    } else if (rghtSWSerNum != null) {
                        d.setSerialNumber(rghtSWSerNum);
                    }
                    this.doRackEnclosureDeviceProcessing(d);
                }
                catch (Exception e) {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)(" EXCEPTION : " + e));
                    containerDeviceDebug.exception((Throwable)e);
                }
                finally {
                    this.myNodeRelationshipManager.update(this.myNodeRelationships);
                    SwitchAssociationDataHandler switchAssociationDataHandler = this;
                    switchAssociationDataHandler.myNodeRelationshipManager.releaseWriteLock();
                }
                int rackDevKey = 0;
                int enclDevKey = 0;
                String rackName = "";
                String enclName = "";
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"SWITCHASSOCIATIONDATAHANDLER....setting Encl/Rack name in devContainerAndRole");
                try {
                    enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "SwitchToEnclosure");
                    if (enclDevKey <= 0) break block35;
                    try {
                        enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getDeviceName();
                    }
                    catch (MxUndefinedNodeException ex) {
                        // empty catch block
                    }
                    rackDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(enclDevKey, "EnclosureToRack");
                    if (rackDevKey > 0) {
                        try {
                            rackName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackDevKey).getDeviceName();
                        }
                        catch (MxUndefinedNodeException ex1) {
                            // empty catch block
                        }
                    }
                    d.setRackName(rackName);
                    d.setEnclosureName(enclName);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
                }
                catch (Exception e) {
                    containerDeviceDebug.exception((Throwable)e);
                }
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Done trying to find associations for SWITCH : " + d.getDeviceName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        ResultSet myResultSet;
        Connection myConnection;
        Statement myStatement;
        block5: {
            myStatement = null;
            myConnection = null;
            myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            try {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("In Loading Device Associations for " + deviceDbKey));
                myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
                myStatement = myConnection.createStatement();
                myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
                int deviceKey1 = -1;
                int deviceKey2 = -1;
                String associationTypeNumber = null;
                while (myResultSet.next()) {
                    deviceKey1 = myResultSet.getInt(1);
                    deviceKey2 = myResultSet.getInt(2);
                    associationTypeNumber = myResultSet.getString(3).trim();
                    if (device == null || !device.getDeviceType().equals("Switch") || !associationTypeNumber.equalsIgnoreCase("SwitchToEnclosure") || deviceKey1 != deviceDbKey) continue;
                    na.setInContainer(true);
                    na.setParent(deviceKey2);
                    na.setTheAssociation(deviceKey1, deviceKey2, "SwitchToEnclosure", false);
                }
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
                if (!containerDeviceDebug.check(10)) break block5;
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent()));
            }
            catch (SQLException myException) {
                try {
                    DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("Failed to get the vector of devices that have associations " + myException));
                }
                catch (Throwable throwable) {
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    public void doRackEnclosureDeviceProcessing(MxNode d) {
        try {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"SwitchADH : In rackEnclosure Device Processing");
            this.myNodeRelationships.setSlotNumber(this.getSwitchSlot());
            this.myNodeRelationships.setSource(this.associationType);
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"SwitchADH : Finished storing switch attributes");
            NodeAssociations theEnclNodeAssociations = this.getEnclosureInformation(this.getContainerEnclosureInformation(), this.getRackName(), this.getRuid());
            if (theEnclNodeAssociations != null) {
                int myDeviceKey = this.device.getDeviceKey();
                int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "SwitchToEnclosure", false);
                this.addDeviceToTopologyTree(theEnclNodeAssociations, myDeviceKey);
                if (this.getLeftSwitchPresent()) {
                    theEnclNodeAssociations.setHasLeftSwitch(true);
                    theEnclNodeAssociations.setHasLeftSwitchSlot(true);
                } else if (this.getRightSwitchPresent()) {
                    theEnclNodeAssociations.setHasRightSwitch(true);
                    theEnclNodeAssociations.setHasRightSwitchSlot(true);
                }
                this.myNodeRelationships.setInContainer(true);
                this.myNodeRelationships.setParent(theEnclDeviceKey);
                int switchesPresent = 0;
                if (this.getLeftSwitchPresent() && this.getRightSwitchPresent()) {
                    switchesPresent = 3;
                } else if (this.getLeftSwitchPresent() && !this.getRightSwitchPresent()) {
                    switchesPresent = 2;
                } else if (!this.getLeftSwitchPresent() && this.getRightSwitchPresent()) {
                    switchesPresent = 1;
                } else if (!this.getLeftSwitchPresent() && !this.getRightSwitchPresent()) {
                    switchesPresent = 0;
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("LeftSwitchPresent in Rack enclosure topology handler : " + this.getLeftSwitchPresent()));
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)5, (String)("RightSwitchPresent in rack enclosure topology handler : " + this.getRightSwitchPresent()));
                theEnclNodeAssociations.setSwitchApis(switchesPresent);
                theEnclNodeAssociations.setSource("Enclosure");
                NodeAssociations theRackNodeAssociations = this.getRackInformation(this.getRackName(), this.getRuid(), theEnclDeviceKey);
                if (this.getTheRackDevice() != null) {
                    this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                }
                if (theRackNodeAssociations != null && theRackNodeAssociations != null) {
                    this.addTreeNodeToTopologyTree(theRackNodeAssociations, theEnclDeviceKey, null, null);
                    this.myNodeRelationshipManager.update(theRackNodeAssociations);
                }
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(this.getTheRackDevice().getDeviceKey());
                this.updateDevContainerAndRoleNames(this.getTheRackDevice());
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            Vector v = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
            for (int i = 0; i < v.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)v.elementAt(i)).intValue());
            }
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }
}

