/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OLSwitch;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class OverlordSwitchHandler
extends RackEnclosureTopologyHandler {
    private String serialNumberFromMib = null;

    public OverlordSwitchHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode switchNode, DeviceIdentificationData idInfo) {
        BladeIMELogger.log("OverlordSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
        if (!switchNode.getDeviceType().equals("Switch")) {
            BladeIMELogger.log("IN The OverlordSwitchAssociationDataHandler.... - Cleaning up the associations");
            this.cleanUpAssociationData(switchNode);
            return;
        }
        String workingAddress = switchNode.getWorkingAddress();
        if (workingAddress == null) {
            BladeIMELogger.log("OverlordSwitchAssociationDataHandler : Working Address is null for device : " + switchNode.getDeviceName());
            return;
        }
        if (switchNode.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            try {
                String serialNumberOfSwitch = switchNode.getSerialNumber();
                BladeIMELogger.log("Serial Number of a switch :" + switchNode.getSerialNumber());
                if (serialNumberOfSwitch == null || serialNumberOfSwitch.trim().length() == 0) {
                    serialNumberOfSwitch = this.getSerialNumberFromMib(switchNode);
                }
                if (serialNumberOfSwitch != null && serialNumberOfSwitch.trim().length() > 0) {
                    switchNode.setSerialNumber(serialNumberOfSwitch);
                    BladeIMELogger.log("switchNode.getSerialNumber:" + switchNode.getSerialNumber());
                    this.doEnclosureDeviceProcessing(switchNode);
                    MxNode theEnclDevice = this.getAssociatedDeviceNode(switchNode, "SwitchToEnclosure");
                    MxNode theRackDevice = this.getAssociatedDeviceNode(theEnclDevice, "EnclosureToRack");
                    switchNode.setEnclosureName(theEnclDevice.getDeviceName());
                    switchNode.setRackName(theRackDevice.getDeviceName());
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
                }
            }
            catch (Exception e) {
            }
            finally {
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                OverlordSwitchHandler overlordSwitchHandler = this;
                overlordSwitchHandler.myNodeRelationshipManager.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        block16: {
            BladeIMELogger.log("OverlordSwitchHandler.loadAssociationDataFromDb(" + device + ")");
            Statement myStatement = null;
            Connection myConnection = null;
            ResultSet myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            BladeIMELogger.log("OverlordSwitchHandler.loadAssociationDataFromDb: In Loading Device Associations for " + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                if (device == null || !device.getDeviceType().equals("Switch") || !associationTypeNumber.equalsIgnoreCase("SwitchToEnclosure") || deviceKey1 != deviceDbKey) continue;
                na.setInContainer(true);
                na.setParent(deviceKey2);
                na.setTheAssociation(deviceKey1, deviceKey2, "SwitchToEnclosure", false);
            }
            BladeIMELogger.log("OverlordSwitchHandler.loadAssociationDataFromDb: loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
            try {
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
            }
            catch (SQLException sqle) {
            }
            catch (Exception e) {
                // empty catch block
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            break block16;
            catch (SQLException myException) {
                try {
                    BladeIMELogger.log("OverlordSwitchHandler.loadAssociationDataFromDb: Failed to get the vector of devices that have associations " + myException);
                }
                catch (Throwable throwable) {
                    try {
                        myResultSet.close();
                        myStatement.close();
                        myResultSet = null;
                        myStatement = null;
                    }
                    catch (SQLException sqle) {
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                try {
                    myResultSet.close();
                    myStatement.close();
                    myResultSet = null;
                    myStatement = null;
                }
                catch (SQLException sqle) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    private void doEnclosureDeviceProcessing(MxNode switchNode) {
        BladeIMELogger.log("OverlordSwitchHandler.doEnclosureDeviceProcessing(" + switchNode + ")");
        BladeIMELogger.log("OverlordSwitchHandler.doEnclosureDeviceProcessing: Switch Serial Number :" + switchNode.getSerialNumber());
        MxNode enclosureNode = null;
        try {
            OAHelper myOAHelper = OAHelper.getOAHelper();
            MxNode enclORDevice = null;
            OLSwitch myOLSwitch = null;
            try {
                enclORDevice = myOAHelper.getDeviceNodeHavingProperty(switchNode.getSerialNumber());
                myOLSwitch = (OLSwitch)myOAHelper.getOLDevice(switchNode, enclORDevice);
            }
            catch (Exception e) {
                BladeIMELogger.log(e, "OverlordSwitch.doEnclosureDeviceProcessing unable to find enclosure node by switch serialnumber ");
            }
            if (enclORDevice != null && enclORDevice.getDeviceType().equals("Enclosure")) {
                BladeIMELogger.log("OverlordSwitchHandler.doEnclosureDeviceProcessing: enclosure node found with device key :" + enclORDevice.getDeviceKey());
                enclosureNode = enclORDevice;
                this.makeAssociation(switchNode, enclosureNode.getDeviceKey());
                this.myNodeRelationships.setSlotNumber(myOLSwitch.getDeviceSlot());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(myOLSwitch.getDeviceSlotsInXDirection());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(myOLSwitch.getDeviceSlotsInYDirection());
                this.myNodeRelationships.setMmHeight(myOLSwitch.getDeviceHeight());
                this.myNodeRelationships.setMmWidth(myOLSwitch.getDeviceWidth());
                this.myNodeRelationships.setMmDepth(myOLSwitch.getDeviceDepth());
                this.myNodeRelationships.setInContainer(true);
                myOLSwitch.move(switchNode, enclORDevice);
                myOLSwitch.remove(enclORDevice);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureNode, false);
            }
            if (enclORDevice != null && enclORDevice.getDeviceType().equals("Switch")) {
                BladeIMELogger.log("OverlordSwitchHandler.doEnclosureDeviceProcessing: logicalNode found with device key:" + enclORDevice.getDeviceKey());
                MxNode LogicalSwitchNode = enclORDevice;
                enclosureNode = this.getAssociatedDeviceNode(LogicalSwitchNode, "SwitchToEnclosure");
                this.makeAssociation(switchNode, enclosureNode.getDeviceKey());
                NodeAssociations thelogicalSwitchAssociations = null;
                thelogicalSwitchAssociations = this.myNodeRelationshipManager.getNodeAssociations(LogicalSwitchNode.getDeviceKey());
                this.myNodeRelationships.setSlotNumber(thelogicalSwitchAssociations.getSlotNumber());
                this.myNodeRelationships.setNumBladeSlotsUsedXDir(thelogicalSwitchAssociations.getNumBladeSlotsUsedXDir());
                this.myNodeRelationships.setNumBladeSlotsUsedYDir(thelogicalSwitchAssociations.getNumBladeSlotsUsedYDir());
                this.myNodeRelationships.setMmHeight(thelogicalSwitchAssociations.getMmHeight());
                this.myNodeRelationships.setMmWidth(thelogicalSwitchAssociations.getMmWidth());
                this.myNodeRelationships.setMmDepth(thelogicalSwitchAssociations.getMmDepth());
                this.myNodeRelationships.setInContainer(true);
                myOLSwitch.move(switchNode, enclORDevice);
                NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
                DefaultMutableTreeNode topologyTree = na.getContainerDeviceTree();
                this.removeBladeFromTopology(LogicalSwitchNode.getDeviceKey(), topologyTree);
                this.myNodeRelationshipManager.update(na);
                thelogicalSwitchAssociations.removeTheAssociation(LogicalSwitchNode.getDeviceKey(), "SwitchToEnclosure");
                this.myNodeRelationshipManager.update(thelogicalSwitchAssociations);
                this.cleanUpAssociationData(LogicalSwitchNode, "SwitchToEnclosure");
                myOLSwitch.remove(enclORDevice);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), enclosureNode, false);
            } else {
                this.checkNodeInDB(switchNode);
            }
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
        }
        catch (Exception e) {
            BladeIMELogger.log("OverlordSwitchHandler.doEnclosureDeviceProcessing: exception  :" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAssociation(MxNode switchNode, int theEnclDeviceKey) {
        BladeIMELogger.log("OverlordSwitchHandler.makeAssociation(" + switchNode + "," + theEnclDeviceKey + ")");
        BladeIMELogger.log("switchNode Device Key:" + switchNode.getDeviceKey());
        BladeIMELogger.log("enclosure Device Key:" + theEnclDeviceKey);
        MxNode syncObject = switchNode;
        try {
            MxNode enclosureNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey);
            NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(enclosureNode.getDeviceKey());
            BladeIMELogger.log("na:" + na);
            if (na != null) {
                syncObject = na;
            }
            MxNode mxNode = syncObject;
            synchronized (mxNode) {
                if (na != null) {
                    int myDeviceKey = switchNode.getDeviceKey();
                    this.myNodeRelationships.setTheAssociation(myDeviceKey, theEnclDeviceKey, "SwitchToEnclosure", false);
                    this.addDeviceToTopologyTree(na, myDeviceKey);
                    this.myNodeRelationshipManager.update(na);
                    MxNode theRackDevice = this.getAssociatedDeviceNode(enclosureNode, "EnclosureToRack");
                    NodeAssociations theRackDeviceNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(theRackDevice.getDeviceKey());
                    this.getRackInformation(theRackDevice.getDeviceName(), theRackDevice.getAgentUUID(), enclosureNode.getDeviceKey());
                    BladeIMELogger.log("OverlordSwitchHandler.makeAssociation: switchToEnclosure association set between :" + myDeviceKey + "and" + theEnclDeviceKey);
                    this.myNodeRelationshipManager.update(na);
                    NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(theRackDevice.getDeviceKey());
                    this.updateDevContainerAndRoleNames(theRackDevice);
                }
            }
        }
        catch (Exception e) {
            BladeIMELogger.log("OverlordSwitchHandler.makeAssociation: Exception :" + e);
        }
    }

    public void checkNodeInDB(MxNode d) {
        NodeAssociations dTmpNodeAssociations;
        BladeIMELogger.log("OverlordSwitchHandler.checkNodeInDB(" + d + ")");
        MxNode dTmp = MxNodeController.getDefaultControllerNoEx().getContainerDev(d, "Enclosure");
        if (dTmp != null && (dTmpNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(dTmp.getDeviceKey())) != null) {
            DefaultMutableTreeNode topologyTree = dTmpNodeAssociations.getContainerDeviceTree();
            topologyTree = this.removeBladeFromTopology(d.getDeviceKey(), topologyTree);
            dTmpNodeAssociations.setContainerDeviceTree(topologyTree);
            this.myNodeRelationshipManager.update(dTmpNodeAssociations);
        }
    }

    private String getSerialNumberFromMib(MxNode d) {
        BladeIMELogger.log("OverlordSwitchHandler.getSerialNumberFromMib: d.getNameString()" + d.getNameString());
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        if (!snmpEnabled.equals("checked")) {
            BladeIMELogger.log("Switch Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName());
            return null;
        }
        if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            BladeIMELogger.log("Switch Association skipped ; snmp not detected on " + d.getDeviceName());
            return null;
        }
        String swserialNumberOID = null;
        String serialNumberFromMib = null;
        boolean endOfTable = false;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.2.1.47.1.1.1.1.11[0]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            swserialNumberOID = vb.getOid();
            if (swserialNumberOID.startsWith("1.3.6.1.2.1.47.1.1.1.1.11.")) {
                BladeIMELogger.log("The Switch serial Number OID : " + swserialNumberOID);
                serialNumberFromMib = vb.getValue();
                BladeIMELogger.log(" switch serial Number :" + serialNumberFromMib);
                endOfTable = true;
                continue;
            }
            BladeIMELogger.log("switch serial number oid was not correct" + swserialNumberOID);
            break;
        }
        return serialNumberFromMib;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        BladeIMELogger.log("OverlordSwitchHandler.buildContainerTree(" + myAssoc + "," + node1 + "," + node2 + ")");
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        BladeIMELogger.log("OverlordSwitchHandler.cleanUpAssociationData(" + d + ")");
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            Vector assDeviceVector = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), "SwitchToEnclosure");
            for (int i = 0; i < assDeviceVector.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)assDeviceVector.elementAt(i)).intValue());
            }
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }

    private void cleanUpAssociationData(MxNode node, String strAssociationType) {
        BladeIMELogger.log("OverlordSwitchHandler.cleanUpAssociationData(" + node + "," + strAssociationType + ")");
        this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), strAssociationType);
    }

    public MxNode getAssociatedDeviceNode(MxNode deviceNode, String asscType) {
        BladeIMELogger.log("OverlordServerHandler.getOANodeFromEnclNode(" + deviceNode + "," + asscType + ")");
        MxNode associatedDevice = null;
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            // empty catch block
        }
        Vector associatedDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(deviceNode.getDeviceKey(), asscType);
        int associatedDeviceKey = 0;
        if (associatedDeviceKeyVect.size() > 0) {
            Integer vectKey = (Integer)associatedDeviceKeyVect.elementAt(0);
            associatedDeviceKey = vectKey;
            BladeIMELogger.log("associatedDeviceKey:" + associatedDeviceKey);
            try {
                associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
            }
            catch (MxUndefinedNodeException ex) {
                BladeIMELogger.log("Node not found");
            }
        }
        return associatedDevice;
    }
}

