/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.RackEnclosureTopologyHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

public class EClassSwitchHandler
extends RackEnclosureTopologyHandler {
    public EClassSwitchHandler(MxNode switchNode) {
        super(switchNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode switchNode, DeviceIdentificationData idInfo) {
        String snmpEnabled;
        BladeIMELogger.log("EClassSwitchHandler.getAssociationData(" + switchNode + "," + idInfo + ")");
        if (GlobalSettings.getProperty((String)"switch_code_wakeup", (String)"false").equalsIgnoreCase("true")) {
            BladeIMELogger.log("IN The ECLASSSWITCHHANDLER.... for device " + switchNode.getDeviceName());
            if (!switchNode.getDeviceType().equals("Switch")) {
                BladeIMELogger.log("IN The ECLASSSWITCHHANDLER.... - Cleaning up the associations");
                this.cleanUpAssociationData(switchNode);
                return;
            }
        }
        if (!(snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked")).equals("checked")) {
            BladeIMELogger.log("Switch Association skipped (SNMP DISABLED GLOBALLY) on " + switchNode.getDeviceName());
            return;
        }
        if (!switchNode.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            BladeIMELogger.log("Switch Association skipped ; snmp not detected on " + switchNode.getDeviceName());
            return;
        }
        String workingAddress = switchNode.getWorkingAddress();
        if (workingAddress == null) {
            BladeIMELogger.log("ECLASSSWITCHHANDLER : Working Address is null for device : " + switchNode.getDeviceName());
            return;
        }
        if (switchNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            try {
                String switchSerialNumber = this.getESwitchSerialNumFromMib(switchNode);
                if (switchSerialNumber != null && switchSerialNumber.trim().length() > 0) {
                    switchNode.setSerialNumber(switchSerialNumber);
                    this.addswitchIPs(switchNode);
                    BladeIMELogger.log("ECLASSSWITCHHANDLER : number IP addresses assigned :" + switchNode.getIPAddressCount());
                    for (int k = 0; k < switchNode.getIPAddressCount(); ++k) {
                        BladeIMELogger.log("IP address :" + switchNode.getIPAddress(k));
                    }
                    List allDevicesWithThisProperty = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("Switch_SerNum", switchSerialNumber);
                    if (allDevicesWithThisProperty.size() > 0) {
                        this.doEClassSwitchToEnclAssociation(allDevicesWithThisProperty, switchNode);
                    }
                }
            }
            catch (Exception e) {
                BladeIMELogger.log("EClassSwitchHandler.getAssociationData: EXCEPTION : " + e);
            }
            finally {
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                EClassSwitchHandler eClassSwitchHandler = this;
                eClassSwitchHandler.myNodeRelationshipManager.releaseWriteLock();
            }
        }
        int enclDevKey = 0;
        String enclName = "";
        BladeIMELogger.log("SWITCHASSOCIATIONDATAHANDLER....setting Encl/Rack name in devContainerAndRole");
        try {
            enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(switchNode.getDeviceKey(), "SwitchToEnclosure");
            if (enclDevKey > 0) {
                try {
                    enclName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDevKey).getDeviceName();
                }
                catch (MxUndefinedNodeException ex) {
                    // empty catch block
                }
            }
            switchNode.setEnclosureName(enclName);
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchNode, false);
        }
        catch (Exception e) {
            BladeIMELogger.log("EClassSwitchHandler.getAssociationData : Exception " + e);
        }
    }

    public void addswitchIPs(MxNode switchNode) {
        BladeIMELogger.log("ECLassSwicthHandler : addSwitchIPs for switchNode:" + switchNode.getModel());
        String ipAddress = null;
        String ipAddressOID = null;
        boolean endOfTable = false;
        this.snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.2.1.4.20.1.1[0]");
        while (!endOfTable) {
            this.snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            ipAddressOID = vb0.getOid();
            BladeIMELogger.log("ipAddressOID:" + ipAddressOID);
            if (ipAddressOID.startsWith("1.3.6.1.2.1.4.20.1.1.")) {
                ipAddress = vb0.getIPAddrValue();
                BladeIMELogger.log("ECLassSwicthHandleripAddress:" + ipAddress);
                this.snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                this.snmpPdh.getSnmpRequest().addSnmpGetVarbind(ipAddressOID, "0");
                if (ipAddress == null || ipAddress == "") continue;
                switchNode.addIPAddress(ipAddress);
                continue;
            }
            BladeIMELogger.log("OId was not correct" + ipAddressOID);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        NodeAssociations na;
        int deviceDbKey;
        block16: {
            BladeIMELogger.log("EClassSwitchHandler:loadAssociationDataFromDb(" + device + ")");
            Statement myStatement = null;
            Connection myConnection = null;
            ResultSet myResultSet = null;
            deviceDbKey = device.getDeviceKey();
            na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
            BladeIMELogger.log("EClassSwitchHandler:loadAssociationDataFromDb: In Loading Device Associations for " + deviceDbKey);
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey);
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            String associationTypeNumber = null;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                associationTypeNumber = myResultSet.getString(3).trim();
                if (device == null || !device.getDeviceType().equals("Switch") || !associationTypeNumber.equalsIgnoreCase("SwitchToEnclosure") || deviceKey1 != deviceDbKey) continue;
                na.setInContainer(true);
                na.setParent(deviceKey2);
                na.setTheAssociation(deviceKey1, deviceKey2, "SwitchToEnclosure", false);
            }
            BladeIMELogger.log("EClassSwitchHandler:loadAssociationDataFromDb: loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
            try {
                myResultSet.close();
                myStatement.close();
                myResultSet = null;
                myStatement = null;
            }
            catch (SQLException sqle) {
            }
            catch (Exception e) {
                // empty catch block
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            break block16;
            catch (SQLException myException) {
                try {
                    BladeIMELogger.log("Failed to get the vector of devices that have associations " + myException);
                }
                catch (Throwable throwable) {
                    try {
                        myResultSet.close();
                        myStatement.close();
                        myResultSet = null;
                        myStatement = null;
                    }
                    catch (SQLException sqle) {
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
                    throw throwable;
                }
                try {
                    myResultSet.close();
                    myStatement.close();
                    myResultSet = null;
                    myStatement = null;
                }
                catch (SQLException sqle) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
            }
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        return na;
    }

    private void doEClassSwitchToEnclAssociation(List allDevicesWithThisProperty, MxNode switchNode) {
        BladeIMELogger.log("EClassSwitchhandler:doEClassSwitchToEnclAssociation: (" + allDevicesWithThisProperty + "," + switchNode + ")");
        for (int i = 0; i < allDevicesWithThisProperty.size(); ++i) {
            int deviceKey = (Integer)allDevicesWithThisProperty.get(i);
            try {
                MxNode enclNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
                if (!enclNode.getDeviceType().equals("Enclosure")) continue;
                NodeAssociations theEnclNodeAssociations = null;
                theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclNode.getDeviceKey());
                if (theEnclNodeAssociations == null) continue;
                int myDeviceKey = switchNode.getDeviceKey();
                int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
                this.myNodeRelationships.setTheAssociation(switchNode.getDeviceKey(), enclNode.getDeviceKey(), "SwitchToEnclosure", false);
                BladeIMELogger.log("Association done between :" + theEnclDeviceKey + "and" + myDeviceKey + "As switchToEnclosure");
                this.myNodeRelationships.setSource("SwitchToEnclosure");
                this.addDeviceToTopologyTree(theEnclNodeAssociations, myDeviceKey);
                this.myNodeRelationships.setInContainer(true);
                this.myNodeRelationships.setParent(theEnclDeviceKey);
                theEnclNodeAssociations.setSource("Enclosure");
                switchNode.addDeviceSubType(NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(this.myNodeRelationships);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String getESwitchSerialNumFromMib(MxNode switchNode) {
        BladeIMELogger.log("EClassSwitchHandler:getESwitchSerialNumFromMib for switchNode.getDeviceKey():" + switchNode.getDeviceKey());
        String theSerialNo = this.snmpPdh.getStrValueFromMib("1.3.6.1.4.1.89.53.14.1.5.1[1]", true);
        BladeIMELogger.log("EClassSwicthHandler:theSerialNo:" + theSerialNo);
        if (theSerialNo != null && theSerialNo.trim().length() > 0) {
            return theSerialNo;
        }
        return null;
    }

    public void cleanUpAssociationData(MxNode d) {
        BladeIMELogger.log("EClassSwitchHandler.cleanUpAssociationData(" + d + ")");
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            Vector v = this.myNodeRelationshipManager.getAssociatedDevicesUsingATNs("SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), "SwitchToEnclosure");
            for (int i = 0; i < v.size(); ++i) {
                this.myNodeRelationshipManager.resetDeviceAssociations(((Integer)v.elementAt(i)).intValue());
            }
        }
        catch (NodeAssociationsPersistenceException nodeAssociationsPersistenceException) {
            // empty catch block
        }
    }
}

