/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.IdentificationComponent;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerConstants;
import com.hp.mx.core.tools.identification.associations.PClassServerHandler;
import com.hp.mx.database.GlobalSettings;
import com.hp.mx.utilities.DebugOutput;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Vector;

public class BladeSystemServerHandler
extends PClassServerHandler {
    private String associationType = "";
    private String leftSWSerialNumber = "";
    private String rightSWSerialNumber = "";
    private boolean leftSWPresent = false;
    private boolean rightSWPresent = false;

    public BladeSystemServerHandler(MxNode d) {
        super(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        if (AssociationHandlerConstants.isHPSystem()) {
            return;
        }
        int ribLoc = 0;
        Object theRibSerialNo = null;
        boolean associatedDeviceKey = false;
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("IN The BladeSystemServerHandler.... for device " + d.getDeviceName() + " And product type " + d.getDeviceType()));
        }
        if (!d.getDeviceType().equals("Server")) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The BladeSystemServerHandler.... - Cleaning up the associations");
            this.cleanUpAssociationData(d);
            return;
        }
        String snmpEnabled = GlobalSettings.getProperty((String)"snmp_check_state", (String)"checked");
        if (!snmpEnabled.equals("checked")) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("BladeSystem Server Association skipped (SNMP DISABLED GLOBALLY) on " + d.getDeviceName()));
            return;
        }
        if (!d.getIsProtocolSupported(MgmtProtoType_t.SNMP_PROTO)) {
            DebugOutput.log((DebugSubsystem)IdentificationComponent.identificationDebug, (int)20, (String)("BladeSystem Server Association skipped ; snmp not detected on " + d.getDeviceName()));
            return;
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)"IN The BladeSystemServerHandler.... - Getting the new associations");
        String workingAddress = d.getWorkingAddress();
        if (workingAddress == null) {
            if (!containerDeviceDebug.check(10)) return;
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("BladeSystemServerHandler : Working Address is null for device : " + d.getDeviceName()));
            return;
        }
        ribLoc = this.snmpPdh.getIntValueFromMib("1.3.6.1.4.1.232.9.2.2.10.0[1]", true);
        if (containerDeviceDebug.check(10)) {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("BladeSystemServerHandler....After getting rib location  " + ribLoc + " for device " + d.getDeviceName()));
        }
        int enclDevKey = 0;
        try {
            if (ribLoc != 1) return;
            while (true) {
                BladeSystemServerHandler bladeSystemServerHandler = this;
                if (bladeSystemServerHandler.myNodeRelationshipManager.isWriteLockForAssociationsAvailable()) break;
                Thread.sleep(100L);
            }
            try {
                this.getSwitchSerialNumbersFromTheServerMib();
                enclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "ServerToEnclosure");
                if (enclDevKey > 0) {
                    int tmpenclDevKey;
                    String jamochaModel;
                    int leftswDevKey = 0;
                    int rightswDevKey = 0;
                    String rckName = null;
                    String rckId = null;
                    this.getRackAttributesFromTheMib();
                    rckName = this.getRackName();
                    rckId = this.getRuid();
                    d.setSWAttribute("compaq.devices.rackname", rckName);
                    d.setSWAttribute("compaq.devices.rackuid", rckId);
                    if (this.leftSWSerialNumber != null && this.leftSWPresent) {
                        d.setSWAttribute("compaq.devices.LeftSWSerialNo", this.leftSWSerialNumber);
                        leftswDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(this.leftSWSerialNumber);
                        if (leftswDevKey > 0 && (jamochaModel = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(leftswDevKey).getModel()).matches("Cisco Gigabit Ethernet Switch Module.*.HP BladeSystem p-Class")) {
                            tmpenclDevKey = 0;
                            tmpenclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(leftswDevKey, "SwitchToEnclosure");
                            if (tmpenclDevKey == 0) {
                                this.doEnclosureDeviceProcessing(leftswDevKey, enclDevKey, this.leftSWSerialNumber, null, rckName, rckId);
                            }
                        }
                    }
                    if (this.rightSWSerialNumber == null || !this.rightSWPresent) return;
                    d.setSWAttribute("compaq.devices.RightSWSerialNo", this.rightSWSerialNumber);
                    rightswDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(this.rightSWSerialNumber);
                    if (rightswDevKey <= 0 || !(jamochaModel = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rightswDevKey).getModel()).matches("Cisco Gigabit Ethernet Switch Module.*.HP BladeSystem p-Class")) return;
                    tmpenclDevKey = 0;
                    tmpenclDevKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(rightswDevKey, "SwitchToEnclosure");
                    if (tmpenclDevKey != 0) return;
                    this.doEnclosureDeviceProcessing(rightswDevKey, enclDevKey, null, this.rightSWSerialNumber, rckName, rckId);
                    return;
                }
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Enclosure not associated for device " + this.device.getDeviceName()));
                return;
            }
            catch (Exception e) {
                containerDeviceDebug.exception((Throwable)e);
            }
            return;
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
            return;
        }
        finally {
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            BladeSystemServerHandler bladeSystemServerHandler = this;
            bladeSystemServerHandler.myNodeRelationshipManager.releaseWriteLock();
        }
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode d) {
        return super.loadAssociationDataFromDb(d);
    }

    public void cleanUpAssociationData(MxNode d) {
        super.cleanUpAssociationData(d);
    }

    public void getSwitchSerialNumbersFromTheServerMib() {
        boolean endOfTable = false;
        String switchesPresentOID = null;
        String switchesLocationOID = null;
        String serialNumberOID = null;
        Vector sp = new Vector();
        this.snmpPdh.snmpReq.setAsn1Numbers("1.3.6.1.4.1.232.22.2.6.1.1.1.12[0],1.3.6.1.4.1.232.22.2.6.1.1.1.13[1],1.3.6.1.4.1.232.22.2.6.1.1.1.7[2]");
        while (!endOfTable) {
            SnmpResponseVarBind vb2;
            SnmpResponseVarBind vb1;
            this.snmpPdh.snmpReq.SnmpGetNext();
            SnmpResponse curResp = this.snmpPdh.snmpReq.getResponseVarbinds();
            SnmpResponseVarBind vb = curResp.findById(0);
            if (vb == null || vb.isError()) break;
            switchesLocationOID = vb.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure - Switches Location OID : " + switchesLocationOID));
            }
            if ((vb1 = curResp.findById(1)) == null || vb1.isError()) break;
            switchesPresentOID = vb1.getOid();
            if (containerDeviceDebug.check(45)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)45, (String)("The Enclosure - Switches Present OID : " + switchesPresentOID));
            }
            if ((vb2 = curResp.findById(2)) == null || vb2.isError()) break;
            serialNumberOID = vb2.getOid();
            if (!switchesLocationOID.startsWith("1.3.6.1.4.1.232.22.2.6.1.1.1.12.")) break;
            String temp = vb.getValue().trim();
            if (temp.equalsIgnoreCase("A") || temp.equalsIgnoreCase("Left Side") || temp.equalsIgnoreCase("Network Side A")) {
                if (vb1.getIntValue() == 3) {
                    this.leftSWSerialNumber = vb2.getValue();
                    this.leftSWPresent = true;
                }
            } else if ((temp.equalsIgnoreCase("B") || temp.equalsIgnoreCase("Right Side") || temp.equalsIgnoreCase("Network Side B")) && vb1.getIntValue() == 3) {
                this.rightSWSerialNumber = vb2.getValue();
                this.rightSWPresent = true;
            }
            if (containerDeviceDebug.check(10)) {
                DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Switches Present for device " + this.device.getDeviceName()));
            }
            this.snmpPdh.snmpReq.clearSnmpReqInfo();
            this.snmpPdh.snmpReq.addSnmpGetVarbind(switchesLocationOID, "0");
            this.snmpPdh.snmpReq.addSnmpGetVarbind(switchesPresentOID, "1");
            this.snmpPdh.snmpReq.addSnmpGetVarbind(serialNumberOID, "2");
        }
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Left Switch  : " + this.leftSWSerialNumber));
        DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)10, (String)("Right Switch  : " + this.rightSWSerialNumber));
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        this.addDeviceToTopologyTree(this.myNodeRelationshipManager.getNodeAssociations(node2.getDeviceKey()), node1.getDeviceKey());
        myAssoc.setInContainer(true);
        myAssoc.setParent(node2.getDeviceKey());
        return myAssoc;
    }

    public void doEnclosureDeviceProcessing(int switchKey, int enclKey, String leftSWSerialNumber, String rightSWSerialNumber, String rkName, String rkId) {
        NodeAssociations theEnclNodeAssociations = null;
        try {
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"SwitchADH : In rackEnclosure Device Processing");
            NodeAssociations theSwitchAssociation = this.myNodeRelationshipManager.getNodeAssociations(switchKey);
            if (theSwitchAssociation == null) {
                theSwitchAssociation = new NodeAssociations(switchKey);
            }
            theSwitchAssociation.setSource("Switch");
            DebugOutput.log((DebugSubsystem)containerDeviceDebug, (int)35, (String)"SwitchADH : Finished storing switch attributes");
            if (enclKey > 0) {
                theEnclNodeAssociations = this.myNodeRelationshipManager.getNodeAssociations(enclKey);
            }
            if (theEnclNodeAssociations != null) {
                MxNode switchMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(switchKey);
                if (rkName != null) {
                    switchMxNode.setRackName(rkName);
                }
                String enclosureName = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclKey).getDeviceName();
                switchMxNode.setEnclosureName(enclosureName);
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), switchMxNode, false);
                theSwitchAssociation.setTheAssociation(switchKey, enclKey, "SwitchToEnclosure", false);
                this.addDeviceToTopologyTree(theEnclNodeAssociations, switchKey);
                if (leftSWSerialNumber != null) {
                    theEnclNodeAssociations.setHasLeftSwitch(true);
                    theEnclNodeAssociations.setHasLeftSwitchSlot(true);
                    theSwitchAssociation.setSlotNumber(0);
                } else if (rightSWSerialNumber != null) {
                    theEnclNodeAssociations.setHasRightSwitch(true);
                    theEnclNodeAssociations.setHasRightSwitchSlot(true);
                    theSwitchAssociation.setSlotNumber(9999);
                }
                theSwitchAssociation.setInContainer(true);
                theSwitchAssociation.setParent(enclKey);
                int switchesPresent = 0;
                if (leftSWSerialNumber != null && rightSWSerialNumber != null) {
                    switchesPresent = 3;
                } else if (leftSWSerialNumber != null && rightSWSerialNumber == null) {
                    switchesPresent = 2;
                } else if (leftSWSerialNumber == null && rightSWSerialNumber != null) {
                    switchesPresent = 1;
                } else if (leftSWSerialNumber == null && rightSWSerialNumber == null) {
                    switchesPresent = 0;
                }
                theEnclNodeAssociations.setSwitchApis(switchesPresent);
                theEnclNodeAssociations.setSource("Enclosure");
                NodeAssociations theRackNodeAssociations = this.getRackInformation(rkName, rkId, enclKey);
                if (this.getTheRackDevice() != null) {
                    this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                }
                if (theRackNodeAssociations != null) {
                    this.addTreeNodeToTopologyTree(theRackNodeAssociations, enclKey, null, null);
                    this.myNodeRelationshipManager.update(theRackNodeAssociations);
                }
                this.myNodeRelationshipManager.update(theEnclNodeAssociations);
                this.myNodeRelationshipManager.update(theSwitchAssociation);
            }
        }
        catch (Exception e) {
            containerDeviceDebug.exception((Throwable)e);
        }
    }
}

